/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.storage;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.block.MainchainBlockReference;
import io.horizen.block.MainchainBlockReferenceData;
import io.horizen.block.MainchainHeader;
import io.horizen.block.SidechainBlockBase;
import io.horizen.block.SidechainBlockHeaderBase;
import io.horizen.chain.AbstractFeePaymentsInfo;
import io.horizen.chain.ActiveChain;
import io.horizen.chain.ActiveChain$;
import io.horizen.chain.MainchainBlockReferenceDataInfo;
import io.horizen.chain.MainchainBlockReferenceInfo;
import io.horizen.chain.MainchainHeaderBaseInfo;
import io.horizen.chain.MainchainHeaderInfo;
import io.horizen.chain.MainchainHeaderMetadata;
import io.horizen.chain.SidechainBlockInfo;
import io.horizen.chain.SidechainBlockInfoSerializer$;
import io.horizen.params.NetworkParams;
import io.horizen.storage.SidechainBlockInfoProvider;
import io.horizen.storage.SidechainStorageInfo;
import io.horizen.storage.Storage;
import io.horizen.transaction.Transaction;
import io.horizen.utils.ByteArrayWrapper;
import io.horizen.utils.Pair;
import io.horizen.utils.Utils;
import io.horizen.utils.WithdrawalEpochInfo;
import io.horizen.utils.package$;
import io.horizen.vrf.VrfOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sparkz.core.consensus.ModifierSemanticValidity;
import sparkz.core.serialization.SparkzSerializer;
import sparkz.crypto.hash.Blake2b256$;
import sparkz.util.SparkzLogging;

@ScalaSignature(bytes="\u0006\u0001\rUcaB\u001c9\u0003\u0003y\u0014q\u0006\u0005\ts\u0001\u0011\t\u0011)A\u0005-\"A\u0011\f\u0001B\u0001B\u0003%!\f\u0003\u0006\u0002\u0006\u0001\u0011\t\u0011)A\u0005\u0003\u000fA!\"!\b\u0001\u0005\u0003\u0005\u000b\u0011BA\u0010\u0011\u001d\tI\u0003\u0001C\u0001\u0003WA\u0011\"a\u0010\u0001\u0005\u0004%I!!\u0011\t\u0011\u0005=\u0003\u0001)A\u0005\u0003\u0007B\u0011\"!\u0015\u0001\u0005\u0004%I!a\u0015\t\u0011\u0005m\u0003\u0001)A\u0005\u0003+Bq!!\u0018\u0001\t\u0013\ty\u0006C\u0004\u0002b\u0001!I!a\u0019\t\u000f\u0005\u0015\u0005\u0001\"\u0005\u0002\b\"9\u00111\u0012\u0001\u0005\u0002\u00055\u0005bBAK\u0001\u0011\u0005\u0011q\u0013\u0005\b\u0003C\u0003A\u0011AAR\u0011\u001d\t)\u000b\u0001C\u0001\u0003OCq!!+\u0001\t\u0003\tY\u000bC\u0004\u00024\u0002!\t!!.\t\u000f\u0005m\u0006\u0001\"\u0001\u0002>\"9\u0011\u0011\u0019\u0001\u0005\u0002\u0005\r\u0007bBAe\u0001\u0011\u0005\u00111\u001a\u0005\b\u0003+\u0004A\u0011BAl\u0011\u001d\tY\u000e\u0001C\u0005\u0003;Dq!!9\u0001\t\u0003\t\u0019\u000fC\u0004\u0002n\u0002!\t!a<\t\u000f\u0005U\b\u0001\"\u0001\u0002x\"9!1\u0001\u0001\u0005\u0002\t\u0015\u0001b\u0002B\u0005\u0001\u0011\u0005!1\u0002\u0005\b\u0005\u001f\u0001A\u0011\u0001B\t\u0011\u001d\u0011I\u0003\u0001C\u0001\u0005WAqA!\r\u0001\t\u0003\u0011\u0019\u0004C\u0004\u0003F\u0001!\tAa\u0012\t\u000f\t-\u0003\u0001\"\u0001\u0003N!9!\u0011\f\u0001\u0005\u0002\tm\u0003b\u0002B4\u0001\u0011\u0005!\u0011\u000e\u0005\b\u0005k\u0002A\u0011\u0001B<\u0011\u001d\u0011)\t\u0001C\u0001\u0005\u000fCqA!#\u0001\t\u0003\u0011Y\tC\u0004\u0003\u0010\u0002!IA!%\t\u000f\t\u0015\u0007\u0001\"\u0001\u0003H\"9!\u0011\u001b\u0001\u0005\u0002\tM\u0007b\u0002Bo\u0001\u0011\u0005!q\u001c\u0005\b\u0005G\u0004A\u0011\u0001Bs\u0011\u001d\u0011I\u000f\u0001C\u0001\u0005WDqA!>\u0001\t\u0003\u00119\u0010C\u0004\u0003|\u0002!\tA!@\t\u000f\r\u0005\u0001\u0001\"\u0001\u0004\u0004!91Q\u0003\u0001\u0005\u0002\r]\u0001bBB\u0010\u0001\u0011\u00051\u0011\u0005\u0005\b\u0007O\u0001A\u0011AB\u0015\u0011\u001d\u0019I\u0004\u0001C\u0001\u0007wAqaa\u0011\u0001\t\u0003\u0019)\u0005C\u0004\u0004L\u0001!\ta!\u0014\t\u000f\r=\u0003\u0001\"\u0011\u0004R\t1\u0012IY:ue\u0006\u001cG\u000fS5ti>\u0014\u0018p\u0015;pe\u0006<WM\u0003\u0002:u\u000591\u000f^8sC\u001e,'BA\u001e=\u0003\u001dAwN]5{K:T\u0011!P\u0001\u0003S>\u001c\u0001!\u0006\u0004AI\u0006-\u0011\u0011G\n\u0006\u0001\u0005;5J\u0014\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0002\t\u0006)1oY1mC&\u0011ai\u0011\u0002\u0007\u0003:L(+\u001a4\u0011\u0005!KU\"\u0001\u001d\n\u0005)C$AG*jI\u0016\u001c\u0007.Y5o\u00052|7m[%oM>\u0004&o\u001c<jI\u0016\u0014\bC\u0001%M\u0013\ti\u0005H\u0001\u000bTS\u0012,7\r[1j]N#xN]1hK&sgm\u001c\t\u0003\u001fRk\u0011\u0001\u0015\u0006\u0003#J\u000bA!\u001e;jY*\t1+\u0001\u0004ta\u0006\u00148N_\u0005\u0003+B\u0013Qb\u00159be.THj\\4hS:<\u0007C\u0001%X\u0013\tA\u0006HA\u0004Ti>\u0014\u0018mZ3\u0002\u001f\tdwnY6TKJL\u0017\r\\5{KJ\u00042a\u00171c\u001b\u0005a&BA/_\u00035\u0019XM]5bY&T\u0018\r^5p]*\u0011qLU\u0001\u0005G>\u0014X-\u0003\u0002b9\n\u00012\u000b]1sWj\u001cVM]5bY&TXM\u001d\t\u0003G\u0012d\u0001\u0001B\u0003f\u0001\t\u0007aM\u0001\u0002Q\u001bF\u0011qM\u001b\t\u0003\u0005\"L!![\"\u0003\u000f9{G\u000f[5oOB\u001a1N\u001d?\u0011\t1|\u0017o_\u0007\u0002[*\u0011aNO\u0001\u0006E2|7m[\u0005\u0003a6\u0014!cU5eK\u000eD\u0017-\u001b8CY>\u001c7NQ1tKB\u00111M\u001d\u0003\ng\u0012\f\t\u0011!A\u0003\u0002Q\u00141a\u0018\u00132#\t9W\u000f\u0005\u0002ws6\tqO\u0003\u0002yu\u0005YAO]1og\u0006\u001cG/[8o\u0013\tQxOA\u0006Ue\u0006t7/Y2uS>t\u0007CA2}\t%iH-!A\u0001\u0002\u000b\u0005aPA\u0002`II\n\"aZ@\u0011\u00071\f\t!C\u0002\u0002\u00045\u0014\u0001dU5eK\u000eD\u0017-\u001b8CY>\u001c7\u000eS3bI\u0016\u0014()Y:f\u0003e1W-\u001a)bs6,g\u000e^:J]\u001a|7+\u001a:jC2L'0\u001a:\u0011\tm\u0003\u0017\u0011\u0002\t\u0004G\u0006-AaBA\u0007\u0001\t\u0007\u0011q\u0002\u0002\u0004\rBK\u0015cA4\u0002\u0012A!\u00111CA\r\u001b\t\t)BC\u0002\u0002\u0018i\nQa\u00195bS:LA!a\u0007\u0002\u0016\t9\u0012IY:ue\u0006\u001cGOR3f!\u0006LX.\u001a8ug&sgm\\\u0001\u0007a\u0006\u0014\u0018-\\:\u0011\t\u0005\u0005\u0012QE\u0007\u0003\u0003GQ1!!\b;\u0013\u0011\t9#a\t\u0003\u001b9+Go^8sWB\u000b'/Y7t\u0003\u0019a\u0014N\\5u}QQ\u0011QFA\u001c\u0003s\tY$!\u0010\u0011\u000f!\u0003!-!\u0003\u00020A\u00191-!\r\u0005\u000f\u0005M\u0002A1\u0001\u00026\t\t1+E\u0002h\u0003[AQ!O\u0003A\u0002YCQ!W\u0003A\u0002iCq!!\u0002\u0006\u0001\u0004\t9\u0001C\u0004\u0002\u001e\u0015\u0001\r!a\b\u0002\u001d\t,7\u000f\u001e\"m_\u000e\\\u0017\nZ&fsV\u0011\u00111\t\t\u0005\u0003\u000b\nY%\u0004\u0002\u0002H)\u0019\u0011\u0011\n\u001e\u0002\u000bU$\u0018\u000e\\:\n\t\u00055\u0013q\t\u0002\u0011\u0005f$X-\u0011:sCf<&/\u00199qKJ\fqBY3ti\ncwnY6JI.+\u0017\u0010I\u0001\fC\u000e$\u0018N^3DQ\u0006Lg.\u0006\u0002\u0002VA!\u00111CA,\u0013\u0011\tI&!\u0006\u0003\u0017\u0005\u001bG/\u001b<f\u0007\"\f\u0017N\\\u0001\rC\u000e$\u0018N^3DQ\u0006Lg\u000eI\u0001\u0010Y>\fG-Q2uSZ,7\t[1j]R\u0011\u0011QK\u0001\rE2|7m[%oM>\\U-\u001f\u000b\u0005\u0003\u0007\n)\u0007C\u0004\u0002h-\u0001\r!!\u001b\u0002\u000f\tdwnY6JIB!\u00111NA@\u001d\u0011\ti'a\u001f\u000f\t\u0005=\u0014\u0011\u0010\b\u0005\u0003c\n9(\u0004\u0002\u0002t)\u0019\u0011Q\u000f \u0002\rq\u0012xn\u001c;?\u0013\u0005\u0019\u0016BA)S\u0013\r\ti\bU\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t)a!\u0003\u00155{G-\u001b4jKJLEMC\u0002\u0002~A\u000b!CZ3f!\u0006LX.\u001a8ug&sgm\\&fsR!\u00111IAE\u0011\u001d\t9\u0007\u0004a\u0001\u0003S\na\u0001[3jO\"$XCAAH!\r\u0011\u0015\u0011S\u0005\u0004\u0003'\u001b%aA%oi\u0006A\u0001.Z5hQR|e\r\u0006\u0003\u0002\u001a\u0006}\u0005#\u0002\"\u0002\u001c\u0006=\u0015bAAO\u0007\n1q\n\u001d;j_:Dq!a\u001a\u000f\u0001\u0004\tI'A\u0006cKN$(\t\\8dW&#WCAA5\u0003%\u0011Wm\u001d;CY>\u001c7.F\u0001c\u00035\u0011Wm\u001d;CY>\u001c7.\u00138g_V\u0011\u0011Q\u0016\t\u0005\u0003'\ty+\u0003\u0003\u00022\u0006U!AE*jI\u0016\u001c\u0007.Y5o\u00052|7m[%oM>\f\u0011B\u00197pG.\u0014\u00150\u00133\u0015\t\u0005]\u0016\u0011\u0018\t\u0005\u0005\u0006m%\rC\u0004\u0002hI\u0001\r!!\u001b\u0002\u001b\tdwnY6J]\u001a|')_%e)\u0011\ti+a0\t\u000f\u0005\u001d4\u00031\u0001\u0002j\u0005\u0019\"\r\\8dW&sgm\\(qi&|gNQ=JIR!\u0011QYAd!\u0015\u0011\u00151TAW\u0011\u001d\t9\u0007\u0006a\u0001\u0003S\n\u0001bY8oi\u0006Lgn\u001d\u000b\u0005\u0003\u001b\f\u0019\u000eE\u0002C\u0003\u001fL1!!5D\u0005\u001d\u0011un\u001c7fC:Dq!a\u001a\u0016\u0001\u0004\tI'\u0001\u0010cY>\u001c7.\u00138g_>\u0003H/[8o\u0005fLEM\u0012:p[N#xN]1hKR!\u0011QYAm\u0011\u001d\t9G\u0006a\u0001\u0003S\n\u0001D\u00197pG.LeNZ8Cs&#gI]8n'R|'/Y4f)\u0011\ti+a8\t\u000f\u0005\u001dt\u00031\u0001\u0002j\u00059s-\u001a;MCN$X*Y5oG\"\f\u0017N\u001c%fC\u0012,'OQ1tK&sgm\\%oG2,8/[8o)\u0011\t)/a;\u0011\t\u0005M\u0011q]\u0005\u0005\u0003S\f)BA\fNC&t7\r[1j]\"+\u0017\rZ3s\u0005\u0006\u001cX-\u00138g_\"9\u0011q\r\rA\u0002\u0005%\u0014!\u00049be\u0016tGO\u00117pG.LE\r\u0006\u0003\u0002r\u0006M\b#\u0002\"\u0002\u001c\u0006%\u0004bBA43\u0001\u0007\u0011\u0011N\u0001\u000eG\"\f\u0017N\\*d_J,gi\u001c:\u0015\t\u0005e(\u0011\u0001\t\u0006\u0005\u0006m\u00151 \t\u0004\u0005\u0006u\u0018bAA\u0000\u0007\n!Aj\u001c8h\u0011\u001d\t9G\u0007a\u0001\u0003S\nq\"[:J]\u0006\u001bG/\u001b<f\u0007\"\f\u0017N\u001c\u000b\u0005\u0003\u001b\u00149\u0001C\u0004\u0002hm\u0001\r!!\u001b\u0002%\u0005\u001cG/\u001b<f\u0007\"\f\u0017N\u001c\"m_\u000e\\\u0017\n\u001a\u000b\u0005\u0003c\u0014i\u0001C\u0004\u0002\fr\u0001\r!a$\u0002!\u0005\u001cG/\u001b<f\u0007\"\f\u0017N\\*j]\u000e,GC\u0002B\n\u0005G\u0011)\u0003\u0005\u0004\u0003\u0016\tu\u0011\u0011\u000e\b\u0005\u0005/\u0011YB\u0004\u0003\u0002r\te\u0011\"\u0001#\n\u0007\u0005u4)\u0003\u0003\u0003 \t\u0005\"aA*fc*\u0019\u0011QP\"\t\u000f\u0005\u001dT\u00041\u0001\u0002j!9!qE\u000fA\u0002\u0005e\u0015!\u00027j[&$\u0018\u0001E1di&4Xm\u00115bS:\fe\r^3s)\u0019\u0011\u0019B!\f\u00030!9\u0011q\r\u0010A\u0002\u0005%\u0004b\u0002B\u0014=\u0001\u0007\u0011\u0011T\u0001+O\u0016$8+\u001b3fG\"\f\u0017N\u001c\"m_\u000e\\7i\u001c8uC&t\u0017N\\4NC&t7\r[1j]\"+\u0017\rZ3s)\u0011\t9L!\u000e\t\u000f\t]r\u00041\u0001\u0003:\u0005\u0019R.Y5oG\"\f\u0017N\u001c%fC\u0012,'\u000fS1tQB)!Ia\u000f\u0003@%\u0019!QH\"\u0003\u000b\u0005\u0013(/Y=\u0011\u0007\t\u0013\t%C\u0002\u0003D\r\u0013AAQ=uK\u0006\tt-\u001a;TS\u0012,7\r[1j]\ncwnY6D_:$\u0018-\u001b8j]\u001el\u0015-\u001b8dQ\u0006LgNU3gKJ,gnY3ECR\fG\u0003BA\\\u0005\u0013BqAa\u000e!\u0001\u0004\u0011I$\u0001\u0011hKRl\u0015-\u001b8dQ\u0006LgN\u00117pG.\u0014VMZ3sK:\u001cWMQ=ICNDG\u0003\u0002B(\u0005/\u0002RAQAN\u0005#\u00022\u0001\u001cB*\u0013\r\u0011)&\u001c\u0002\u0018\u001b\u0006Lgn\u00195bS:\u0014En\\2l%\u00164WM]3oG\u0016DqAa\u000e\"\u0001\u0004\u0011I$\u0001\rhKRl\u0015-\u001b8dQ\u0006Lg\u000eS3bI\u0016\u0014()\u001f%bg\"$BA!\u0018\u0003fA)!)a'\u0003`A\u0019AN!\u0019\n\u0007\t\rTNA\bNC&t7\r[1j]\"+\u0017\rZ3s\u0011\u001d\u00119D\ta\u0001\u0005s\tqdZ3u\u001b\u0006Lgn\u00195bS:\u0014VMZ3sK:\u001cW\rR1uC\nK\b*Y:i)\u0011\u0011YGa\u001d\u0011\u000b\t\u000bYJ!\u001c\u0011\u00071\u0014y'C\u0002\u0003r5\u00141$T1j]\u000eD\u0017-\u001b8CY>\u001c7NU3gKJ,gnY3ECR\f\u0007b\u0002B\u001cG\u0001\u0007!\u0011H\u00015O\u0016$X*Y5oG\"\f\u0017N\u001c\"m_\u000e\\'+\u001a4fe\u0016t7-Z%oM>\u0014\u00150T1j]\u000eD\u0017-\u001b8CY>\u001c7\u000eS3jO\"$H\u0003\u0002B=\u0005\u0003\u0003RAQAN\u0005w\u0002B!a\u0005\u0003~%!!qPA\u000b\u0005mi\u0015-\u001b8dQ\u0006LgN\u00117pG.\u0014VMZ3sK:\u001cW-\u00138g_\"9!1\u0011\u0013A\u0002\u0005=\u0015aD7bS:\u001c\u0007.Y5o\u0011\u0016Lw\r\u001b;\u0002E\u001d,GOQ3ti6\u000b\u0017N\\2iC&t'\t\\8dWJ+g-\u001a:f]\u000e,\u0017J\u001c4p+\t\u0011I(\u0001\u0013hKRl\u0015-\u001b8dQ\u0006LgN\u00117pG.\u0014VMZ3sK:\u001cW-\u00138g_\nK\b*Y:i)\u0011\u0011IH!$\t\u000f\t]b\u00051\u0001\u0003:\u0005\u0001#-^5mI6\u000b\u0017N\\2iC&t'\t\\8dWJ+g-\u001a:f]\u000e,\u0017J\u001c4p)1\u0011YHa%\u00030\ne&Q\u0018Ba\u0011\u001d\u0011)j\na\u0001\u0005/\u000ba!\\2ICND\u0007\u0003\u0002BM\u0005SsAAa'\u0003(:!!Q\u0014BS\u001d\u0011\u0011yJa)\u000f\t\u0005E$\u0011U\u0005\u0002{%\u00111\bP\u0005\u0004\u0003/Q\u0014\u0002BA?\u0003+IAAa+\u0003.\n\u0019R*Y5oG\"\f\u0017N\u001c%fC\u0012,'\u000fS1tQ*!\u0011QPA\u000b\u0011\u001d\u0011\tl\na\u0001\u0005g\u000bQB]3gKJ,gnY3J]\u001a|\u0007\u0003BA\n\u0005kKAAa.\u0002\u0016\t9R*Y5oG\"\f\u0017N\u001c%fC\u0012,'/T3uC\u0012\fG/\u0019\u0005\b\u0005w;\u0003\u0019AAH\u00035i7M\u00117pG.DU-[4ii\"9!qX\u0014A\u0002\u0005%\u0014aH7bS:\u001c\u0007.Y5o\u0011\u0016\fG-\u001a:TS\u0012,7\r[1j]\ncwnY6JI\"9!1Y\u0014A\u0002\u0005%\u0014AJ7bS:\u001c\u0007.Y5o%\u00164WM]3oG\u0016$\u0015\r^1TS\u0012,7\r[1j]\ncwnY6JI\u0006ar-\u001a;NC&t7\r[1j]\"\u000b7\u000f[3t\r>\u0014\u0018J\u001c3fq\u0016\u001cH\u0003\u0002Be\u0005\u0017\u0004bA!\u0006\u0003\u001e\t]\u0005b\u0002BgQ\u0001\u0007!qZ\u0001\u0011[\u0006Lgn\u00195bS:DU-[4iiN\u0004bA!\u0006\u0003\u001e\u0005=\u0015AG4fi\n+7\u000f^'bS:\u001c\u0007.Y5o\u0011\u0016\fG-\u001a:J]\u001a|WC\u0001Bk!\u0015\u0011\u00151\u0014Bl!\u0011\t\u0019B!7\n\t\tm\u0017Q\u0003\u0002\u0014\u001b\u0006Lgn\u00195bS:DU-\u00193fe&sgm\\\u0001\u001fO\u0016$X*Y5oG\"\f\u0017N\u001c%fC\u0012,'/\u00138g_\nK\b*Z5hQR$BA!6\u0003b\"9!1\u0011\u0016A\u0002\u0005=\u0015\u0001H4fi6\u000b\u0017N\\2iC&t\u0007*Z1eKJLeNZ8Cs\"\u000b7\u000f\u001b\u000b\u0005\u0005+\u00149\u000fC\u0004\u00038-\u0002\rA!\u000f\u0002M\u001d,GOQ3ti6\u000b\u0017N\\2iC&t'\t\\8dWJ+g-\u001a:f]\u000e,G)\u0019;b\u0013:4w.\u0006\u0002\u0003nB)!)a'\u0003pB!\u00111\u0003By\u0013\u0011\u0011\u00190!\u0006\u0003?5\u000b\u0017N\\2iC&t'\t\\8dWJ+g-\u001a:f]\u000e,G)\u0019;b\u0013:4w.\u0001\u0016hKRl\u0015-\u001b8dQ\u0006LgN\u00117pG.\u0014VMZ3sK:\u001cW\rR1uC&sgm\u001c\"z\u0011\u0016Lw\r\u001b;\u0015\t\t5(\u0011 \u0005\b\u0005\u0007k\u0003\u0019AAH\u0003!:W\r^'bS:\u001c\u0007.Y5o\u00052|7m\u001b*fM\u0016\u0014XM\\2f\t\u0006$\u0018-\u00138g_\nK\b*Y:i)\u0011\u0011iOa@\t\u000f\t]b\u00061\u0001\u0003:\u00051Q\u000f\u001d3bi\u0016$ba!\u0002\u0004\u0010\rE\u0001CBB\u0004\u0007\u0017\ty#\u0004\u0002\u0004\n)\u0011\u0011kQ\u0005\u0005\u0007\u001b\u0019IAA\u0002UefDQA\\\u0018A\u0002\tDqaa\u00050\u0001\u0004\ti+A\u0005cY>\u001c7.\u00138g_\u0006)R\u000f\u001d3bi\u00164U-\u001a)bs6,g\u000e^:J]\u001a|GCBB\u0003\u00073\u0019Y\u0002C\u0004\u0002hA\u0002\r!!\u001b\t\u000f\ru\u0001\u00071\u0001\u0002\n\u0005ya-Z3QCflWM\u001c;t\u0013:4w.\u0001\nhKR4U-\u001a)bs6,g\u000e^:J]\u001a|G\u0003BB\u0012\u0007K\u0001RAQAN\u0003\u0013Aq!a\u001a2\u0001\u0004\tI'\u0001\ttK6\fg\u000e^5d-\u0006d\u0017\u000eZ5usR!11FB\u001c!\u0011\u0019ica\r\u000e\u0005\r=\"bAB\u0019=\u0006I1m\u001c8tK:\u001cXo]\u0005\u0005\u0007k\u0019yC\u0001\rN_\u0012Lg-[3s'\u0016l\u0017M\u001c;jGZ\u000bG.\u001b3jifDq!a\u001a3\u0001\u0004\tI'\u0001\fva\u0012\fG/Z*f[\u0006tG/[2WC2LG-\u001b;z)\u0019\u0019)a!\u0010\u0004@!)an\ra\u0001E\"91\u0011I\u001aA\u0002\r-\u0012AB:uCR,8/\u0001\btKR\f5OQ3ti\ncwnY6\u0015\r\r\u00151qIB%\u0011\u0015qG\u00071\u0001c\u0011\u001d\u0019\u0019\u0002\u000ea\u0001\u0003[\u000bq![:F[B$\u00180\u0006\u0002\u0002N\u0006iA.Y:u-\u0016\u00148/[8o\u0013\u0012,\"aa\u0015\u0011\u000b\t\u000bY*a\u0011")
public abstract class AbstractHistoryStorage<PM extends SidechainBlockBase<? extends Transaction, ? extends SidechainBlockHeaderBase>, FPI extends AbstractFeePaymentsInfo, S extends AbstractHistoryStorage<PM, FPI, S>>
implements SidechainBlockInfoProvider,
SidechainStorageInfo,
SparkzLogging {
    private final Storage storage;
    private final SparkzSerializer<PM> blockSerializer;
    private final SparkzSerializer<FPI> feePaymentsInfoSerializer;
    private final NetworkParams params;
    private final ByteArrayWrapper bestBlockIdKey;
    private final ActiveChain activeChain;
    private final Logger logger;

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    @Override
    public String getStorageName() {
        return SidechainStorageInfo.getStorageName$(this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private ByteArrayWrapper bestBlockIdKey() {
        return this.bestBlockIdKey;
    }

    private ActiveChain activeChain() {
        return this.activeChain;
    }

    private ActiveChain loadActiveChain() {
        if (this.storage.isEmpty()) {
            return ActiveChain$.MODULE$.apply(this.params.mainchainCreationBlockHeight());
        }
        ArrayBuffer activeChainBlocksInfo = new ArrayBuffer();
        activeChainBlocksInfo.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.bestBlockId(), (Object)this.blockInfoByIdFromStorage(this.bestBlockId()))}));
        while (((SidechainBlockInfo)((Tuple2)activeChainBlocksInfo.last())._2()).height() > 1) {
            String id = ((SidechainBlockInfo)((Tuple2)activeChainBlocksInfo.last())._2()).parentId();
            activeChainBlocksInfo.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)id, (Object)this.blockInfoByIdFromStorage(id))}));
        }
        ArrayBuffer orderedChainBlocks = (ArrayBuffer)activeChainBlocksInfo.reverse();
        Option mainchainBlockParent = orderedChainBlocks.headOption().flatMap((Function1 & Serializable & scala.Serializable)firstSidechainBlockInfo -> this.blockById((String)firstSidechainBlockInfo._1()).flatMap((Function1 & Serializable & scala.Serializable)firstSidechainBlock -> firstSidechainBlock.mainchainHeaders().headOption().map((Function1 & Serializable & scala.Serializable)firstMainchainHeader -> io.horizen.chain.package$.MODULE$.byteArrayToMainchainHeaderHash(firstMainchainHeader.hashPrevBlock()))));
        return ActiveChain$.MODULE$.apply((ArrayBuffer<Tuple2<String, SidechainBlockInfo>>)orderedChainBlocks, (ByteArrayWrapper)mainchainBlockParent.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException("Loaded active chain miss mainchain parent");
        }), this.params.mainchainCreationBlockHeight());
    }

    private ByteArrayWrapper blockInfoKey(String blockId) {
        return new ByteArrayWrapper(Blake2b256$.MODULE$.apply(new StringBuilder(9).append("blockInfo").append(blockId).toString()));
    }

    public ByteArrayWrapper feePaymentsInfoKey(String blockId) {
        return new ByteArrayWrapper(Blake2b256$.MODULE$.apply(new StringBuilder(15).append("feePaymentsInfo").append(blockId).toString()));
    }

    public int height() {
        return this.activeChain().height();
    }

    public Option<Object> heightOf(String blockId) {
        return this.blockInfoOptionById(blockId).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.height()));
    }

    public String bestBlockId() {
        return (String)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.bestBlockIdKey()))).map((Function1 & Serializable & scala.Serializable)d -> sparkz.util.package$.MODULE$.bytesToId(d.data())).getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.params.sidechainGenesisBlockId());
    }

    public PM bestBlock() {
        Predef$.MODULE$.require(this.height() > 0, (Function0 & Serializable & scala.Serializable)() -> "SidechainHistoryStorage is empty. Cannot retrieve best block.");
        return (PM)((SidechainBlockBase)this.blockById(this.bestBlockId()).get());
    }

    public SidechainBlockInfo bestBlockInfo() {
        Predef$.MODULE$.require(this.height() > 0, (Function0 & Serializable & scala.Serializable)() -> "SidechainHistoryStorage is empty. Cannot retrieve best block.");
        return this.blockInfoById(this.bestBlockId());
    }

    public Option<PM> blockById(String blockId) {
        None$ none$;
        ByteArrayWrapper blockIdBytes = new ByteArrayWrapper(sparkz.util.package$.MODULE$.idToBytes(blockId));
        Option baw = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(blockIdBytes)));
        Option option = baw;
        if (option instanceof Some) {
            Option option2;
            Some some = (Some)option;
            ByteArrayWrapper value = (ByteArrayWrapper)some.value();
            Try try_ = this.blockSerializer.parseBytesTry(value.data());
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                SidechainBlockBase block = (SidechainBlockBase)success.value();
                option2 = Option$.MODULE$.apply((Object)block);
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("Error while sidechain block parsing.", exception);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                option2 = Option$.MODULE$.empty();
            } else {
                throw new MatchError((Object)try_);
            }
            none$ = option2;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            if (this.log().underlying().isInfoEnabled()) {
                this.log().underlying().info("SidechainHistoryStorage:blockById: byte array is empty");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            none$ = None$.MODULE$;
        } else {
            throw new MatchError((Object)option);
        }
        return none$;
    }

    @Override
    public SidechainBlockInfo blockInfoById(String blockId) {
        return (SidechainBlockInfo)this.blockInfoOptionById(blockId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(24).append("No block info for block ").append(blockId).toString());
        });
    }

    public Option<SidechainBlockInfo> blockInfoOptionById(String blockId) {
        return this.activeChain().blockInfoById(blockId).orElse((Function0 & Serializable & scala.Serializable)() -> this.blockInfoOptionByIdFromStorage(blockId));
    }

    public boolean contains(String blockId) {
        return this.isInActiveChain(blockId) || this.blockInfoOptionByIdFromStorage(blockId).nonEmpty();
    }

    private Option<SidechainBlockInfo> blockInfoOptionByIdFromStorage(String blockId) {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.blockInfoKey(blockId)))).flatMap((Function1 & Serializable & scala.Serializable)baw -> SidechainBlockInfoSerializer$.MODULE$.parseBytesTry(baw.data()).toOption());
    }

    private SidechainBlockInfo blockInfoByIdFromStorage(String blockId) {
        return (SidechainBlockInfo)this.blockInfoOptionByIdFromStorage(blockId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(36).append("No blockInfo in storage for blockId ").append(blockId).toString());
        });
    }

    public MainchainHeaderBaseInfo getLastMainchainHeaderBaseInfoInclusion(String blockId) {
        SidechainBlockInfo sidechainBlockInfo = this.blockInfoById(blockId);
        while (sidechainBlockInfo.mainchainHeaderBaseInfo().isEmpty()) {
            sidechainBlockInfo = this.blockInfoById(sidechainBlockInfo.parentId());
        }
        return (MainchainHeaderBaseInfo)sidechainBlockInfo.mainchainHeaderBaseInfo().last();
    }

    public Option<String> parentBlockId(String blockId) {
        return this.blockInfoOptionById(blockId).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.parentId());
    }

    public Option<Object> chainScoreFor(String blockId) {
        return this.blockInfoOptionById(blockId).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.score()));
    }

    public boolean isInActiveChain(String blockId) {
        return this.activeChain().contains(blockId);
    }

    public Option<String> activeChainBlockId(int height) {
        return this.activeChain().idByHeight(height);
    }

    public Seq<String> activeChainSince(String blockId, Option<Object> limit) {
        return this.activeChain().chainSince(blockId, limit);
    }

    public Seq<String> activeChainAfter(String blockId, Option<Object> limit) {
        return this.activeChain().chainAfter(blockId, limit);
    }

    public Option<PM> getSidechainBlockContainingMainchainHeader(byte[] mainchainHeaderHash) {
        return this.activeChain().idByMcHeader(io.horizen.chain.package$.MODULE$.byteArrayToMainchainHeaderHash(mainchainHeaderHash)).flatMap((Function1 & Serializable & scala.Serializable)blockId -> this.blockById((String)blockId));
    }

    public Option<PM> getSidechainBlockContainingMainchainReferenceData(byte[] mainchainHeaderHash) {
        return this.activeChain().idByMcReferenceData(io.horizen.chain.package$.MODULE$.byteArrayToMainchainHeaderHash(mainchainHeaderHash)).flatMap((Function1 & Serializable & scala.Serializable)blockId -> this.blockById((String)blockId));
    }

    public Option<MainchainBlockReference> getMainchainBlockReferenceByHash(byte[] mainchainHeaderHash) {
        return this.getMainchainHeaderByHash(mainchainHeaderHash).flatMap((Function1 & Serializable & scala.Serializable)header -> this.getMainchainReferenceDataByHash(mainchainHeaderHash).map((Function1 & Serializable & scala.Serializable)data -> new MainchainBlockReference((MainchainHeader)header, (MainchainBlockReferenceData)data)));
    }

    public Option<MainchainHeader> getMainchainHeaderByHash(byte[] mainchainHeaderHash) {
        Option<PM> block = this.getSidechainBlockContainingMainchainHeader(mainchainHeaderHash);
        return block.flatMap((Function1 & Serializable & scala.Serializable)x$4 -> x$4.mainchainHeaders().find((Function1 & Serializable & scala.Serializable)header -> BoxesRunTime.boxToBoolean((boolean)AbstractHistoryStorage.$anonfun$getMainchainHeaderByHash$2(mainchainHeaderHash, header))));
    }

    public Option<MainchainBlockReferenceData> getMainchainReferenceDataByHash(byte[] mainchainHeaderHash) {
        Option<PM> block = this.getSidechainBlockContainingMainchainReferenceData(mainchainHeaderHash);
        return block.flatMap((Function1 & Serializable & scala.Serializable)x$5 -> x$5.mainchainBlockReferencesData().find((Function1 & Serializable & scala.Serializable)data -> BoxesRunTime.boxToBoolean((boolean)AbstractHistoryStorage.$anonfun$getMainchainReferenceDataByHash$2(mainchainHeaderHash, data))));
    }

    public Option<MainchainBlockReferenceInfo> getMainchainBlockReferenceInfoByMainchainBlockHeight(int mainchainHeight) {
        return this.activeChain().mcHashByMcHeight(mainchainHeight).flatMap((Function1 & Serializable & scala.Serializable)hash -> this.getMainchainBlockReferenceInfoByHash(package$.MODULE$.wrapperToByteArray((ByteArrayWrapper)hash)));
    }

    public Option<MainchainBlockReferenceInfo> getBestMainchainBlockReferenceInfo() {
        return this.getMainchainBlockReferenceInfoByMainchainBlockHeight(this.activeChain().heightOfMcReferencesData());
    }

    public Option<MainchainBlockReferenceInfo> getMainchainBlockReferenceInfoByHash(byte[] mainchainHeaderHash) {
        ByteArrayWrapper mcHash = io.horizen.chain.package$.MODULE$.byteArrayToMainchainHeaderHash(mainchainHeaderHash);
        return this.activeChain().mcRefDataHeightByMcHash(mcHash).flatMap((Function1 & Serializable & scala.Serializable)mcHeight -> AbstractHistoryStorage.$anonfun$getMainchainBlockReferenceInfoByHash$1(this, mcHash, BoxesRunTime.unboxToInt((Object)mcHeight)));
    }

    private MainchainBlockReferenceInfo buildMainchainBlockReferenceInfo(ByteArrayWrapper mcHash, MainchainHeaderMetadata referenceInfo, int mcBlockHeight, String mainchainHeaderSidechainBlockId, String mainchainReferenceDataSidechainBlockId) {
        return new MainchainBlockReferenceInfo(package$.MODULE$.wrapperToByteArray(mcHash), package$.MODULE$.wrapperToByteArray(referenceInfo.getParentId()), mcBlockHeight, sparkz.util.package$.MODULE$.idToBytes(mainchainHeaderSidechainBlockId), sparkz.util.package$.MODULE$.idToBytes(mainchainReferenceDataSidechainBlockId));
    }

    public Seq<ByteArrayWrapper> getMainchainHashesForIndexes(Seq<Object> mainchainHeights) {
        return (Seq)mainchainHeights.flatMap((Function1 & Serializable & scala.Serializable)mainchainHeight -> Option$.MODULE$.option2Iterable(this.activeChain().mcHashByMcHeight(BoxesRunTime.unboxToInt((Object)mainchainHeight))), Seq$.MODULE$.canBuildFrom());
    }

    public Option<MainchainHeaderInfo> getBestMainchainHeaderInfo() {
        return this.getMainchainHeaderInfoByHeight(this.activeChain().heightOfMcHeaders());
    }

    public Option<MainchainHeaderInfo> getMainchainHeaderInfoByHeight(int mainchainHeight) {
        return this.activeChain().mcHashByMcHeight(mainchainHeight).map((Function1 & Serializable & scala.Serializable)mcHash -> (MainchainHeaderInfo)this.getMainchainHeaderInfoByHash(package$.MODULE$.wrapperToByteArray((ByteArrayWrapper)mcHash)).get());
    }

    public Option<MainchainHeaderInfo> getMainchainHeaderInfoByHash(byte[] mainchainHeaderHash) {
        ByteArrayWrapper mcHash = io.horizen.chain.package$.MODULE$.byteArrayToMainchainHeaderHash(mainchainHeaderHash);
        return this.activeChain().mcHeadersHeightByMcHash(mcHash).flatMap((Function1 & Serializable & scala.Serializable)mcHeight -> AbstractHistoryStorage.$anonfun$getMainchainHeaderInfoByHash$1(this, mcHash, BoxesRunTime.unboxToInt((Object)mcHeight)));
    }

    public Option<MainchainBlockReferenceDataInfo> getBestMainchainBlockReferenceDataInfo() {
        return this.getMainchainBlockReferenceDataInfoByHeight(this.activeChain().heightOfMcReferencesData());
    }

    public Option<MainchainBlockReferenceDataInfo> getMainchainBlockReferenceDataInfoByHeight(int mainchainHeight) {
        return this.activeChain().mcHashByMcHeight(mainchainHeight).map((Function1 & Serializable & scala.Serializable)mcHash -> (MainchainBlockReferenceDataInfo)this.getMainchainBlockReferenceDataInfoByHash(package$.MODULE$.wrapperToByteArray((ByteArrayWrapper)mcHash)).get());
    }

    public Option<MainchainBlockReferenceDataInfo> getMainchainBlockReferenceDataInfoByHash(byte[] mainchainHeaderHash) {
        ByteArrayWrapper mcHash = io.horizen.chain.package$.MODULE$.byteArrayToMainchainHeaderHash(mainchainHeaderHash);
        return this.activeChain().mcRefDataHeightByMcHash(mcHash).flatMap((Function1 & Serializable & scala.Serializable)mcHeight -> AbstractHistoryStorage.$anonfun$getMainchainBlockReferenceDataInfoByHash$1(this, mcHash, BoxesRunTime.unboxToInt((Object)mcHeight)));
    }

    public Try<S> update(PM block, SidechainBlockInfo blockInfo) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(block != null, (Function0 & Serializable & scala.Serializable)() -> "Block must be NOT NULL.");
            String string = block.parentId();
            String string2 = blockInfo.parentId();
            Predef$.MODULE$.require(!(string != null ? !string.equals(string2) : string2 != null), (Function0 & Serializable & scala.Serializable)() -> "Passed BlockInfo data conflicts to passed Block.");
            ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>> toUpdate = new ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>>();
            toUpdate.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(new ByteArrayWrapper(this.blockInfoKey(block.id())), new ByteArrayWrapper(blockInfo.bytes())));
            toUpdate.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(new ByteArrayWrapper(sparkz.util.package$.MODULE$.idToBytes(block.id())), new ByteArrayWrapper(block.bytes())));
            $this.storage.update(new ByteArrayWrapper(Utils.nextVersion()), toUpdate, new ArrayList<ByteArrayWrapper>());
            return this;
        });
    }

    public Try<S> updateFeePaymentsInfo(String blockId, FPI feePaymentsInfo) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            $this.storage.update(new ByteArrayWrapper(Utils.nextVersion()), Arrays.asList((Object[])new Pair[]{new Pair<ByteArrayWrapper, ByteArrayWrapper>(new ByteArrayWrapper(this.feePaymentsInfoKey(blockId)), new ByteArrayWrapper(feePaymentsInfo.bytes()))}), new ArrayList<ByteArrayWrapper>());
            return this;
        });
    }

    public Option<FPI> getFeePaymentsInfo(String blockId) {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.feePaymentsInfoKey(blockId)))).flatMap((Function1 & Serializable & scala.Serializable)baw -> $this.feePaymentsInfoSerializer.parseBytesTry(baw.data()).toOption());
    }

    public ModifierSemanticValidity semanticValidity(String blockId) {
        ModifierSemanticValidity.Absent$ absent$;
        Option<SidechainBlockInfo> option = this.blockInfoOptionById(blockId);
        if (option instanceof Some) {
            Some some = (Some)option;
            SidechainBlockInfo info = (SidechainBlockInfo)some.value();
            absent$ = info.semanticValidity();
        } else if (None$.MODULE$.equals(option)) {
            absent$ = ModifierSemanticValidity.Absent$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        return absent$;
    }

    public Try<S> updateSemanticValidity(PM block, ModifierSemanticValidity status) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            SidechainBlockInfo oldInfo = (SidechainBlockInfo)this.activeChain().blockInfoById(block.id()).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.blockInfoById(block.id()));
            ModifierSemanticValidity x$1 = status;
            int x$2 = oldInfo.copy$default$1();
            long x$3 = oldInfo.copy$default$2();
            String x$4 = oldInfo.copy$default$3();
            long x$5 = oldInfo.copy$default$4();
            Seq<MainchainHeaderBaseInfo> x$6 = oldInfo.copy$default$6();
            Seq<ByteArrayWrapper> x$7 = oldInfo.copy$default$7();
            WithdrawalEpochInfo x$8 = oldInfo.copy$default$8();
            Option<VrfOutput> x$9 = oldInfo.copy$default$9();
            String x$10 = oldInfo.copy$default$10();
            SidechainBlockInfo blockInfo = oldInfo.copy(x$2, x$3, x$4, x$5, x$1, x$6, x$7, x$8, x$9, x$10);
            $this.storage.update(new ByteArrayWrapper(Utils.nextVersion()), Arrays.asList((Object[])new Pair[]{new Pair<ByteArrayWrapper, ByteArrayWrapper>(new ByteArrayWrapper(this.blockInfoKey(block.id())), new ByteArrayWrapper(blockInfo.bytes()))}), new ArrayList<ByteArrayWrapper>());
            return this;
        });
    }

    public Try<S> setAsBestBlock(PM block, SidechainBlockInfo blockInfo) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            $this.storage.update(new ByteArrayWrapper(Utils.nextVersion()), Arrays.asList((Object[])new Pair[]{new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.bestBlockIdKey(), new ByteArrayWrapper(sparkz.util.package$.MODULE$.idToBytes(block.id())))}), new ArrayList<ByteArrayWrapper>());
            Option mainchainParent = block.mainchainHeaders().headOption().map((Function1 & Serializable & scala.Serializable)header -> io.horizen.chain.package$.MODULE$.byteArrayToMainchainHeaderHash(header.hashPrevBlock()));
            this.activeChain().setBestBlock(block.id(), blockInfo, (Option<ByteArrayWrapper>)mainchainParent);
            return this;
        });
    }

    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    @Override
    public Option<ByteArrayWrapper> lastVersionId() {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.lastVersionID()));
    }

    public static final /* synthetic */ boolean $anonfun$getMainchainHeaderByHash$2(byte[] mainchainHeaderHash$2, MainchainHeader header) {
        return new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(mainchainHeaderHash$2)).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(header.hash()));
    }

    public static final /* synthetic */ boolean $anonfun$getMainchainReferenceDataByHash$2(byte[] mainchainHeaderHash$3, MainchainBlockReferenceData data) {
        return new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(mainchainHeaderHash$3)).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(data.headerHash()));
    }

    public static final /* synthetic */ Option $anonfun$getMainchainBlockReferenceInfoByHash$1(AbstractHistoryStorage $this, ByteArrayWrapper mcHash$1, int mcHeight) {
        return $this.activeChain().idByMcHeader(mcHash$1).flatMap((Function1 & Serializable & scala.Serializable)headerContainingId -> $this.activeChain().idByMcReferenceData(mcHash$1).flatMap((Function1 & Serializable & scala.Serializable)dataContainingId -> $this.activeChain().mcHeaderMetadataByMcHash(mcHash$1).map((Function1 & Serializable & scala.Serializable)mcMetadata -> $this.buildMainchainBlockReferenceInfo(mcHash$1, (MainchainHeaderMetadata)mcMetadata, mcHeight, (String)headerContainingId, (String)dataContainingId))));
    }

    public static final /* synthetic */ boolean $anonfun$getMainchainHeaderInfoByHash$5(ByteArrayWrapper mcHash$2, MainchainHeaderBaseInfo info) {
        return info.hash().equals(mcHash$2);
    }

    public static final /* synthetic */ Option $anonfun$getMainchainHeaderInfoByHash$1(AbstractHistoryStorage $this, ByteArrayWrapper mcHash$2, int mcHeight) {
        return $this.activeChain().idByMcHeader(mcHash$2).flatMap((Function1 & Serializable & scala.Serializable)sidechainBlockId -> $this.activeChain().mcHeaderMetadataByMcHash(mcHash$2).flatMap((Function1 & Serializable & scala.Serializable)mcMetadata -> $this.activeChain().blockInfoById((String)sidechainBlockId).flatMap((Function1 & Serializable & scala.Serializable)blockInfo -> blockInfo.mainchainHeaderBaseInfo().find((Function1 & Serializable & scala.Serializable)info -> BoxesRunTime.boxToBoolean((boolean)AbstractHistoryStorage.$anonfun$getMainchainHeaderInfoByHash$5(mcHash$2, info))).map((Function1 & Serializable & scala.Serializable)mainchainBaseInfo -> new MainchainHeaderInfo(mcHash$2, mcMetadata.getParentId(), mcHeight, (String)sidechainBlockId, mainchainBaseInfo.cumulativeCommTreeHash())))));
    }

    public static final /* synthetic */ Option $anonfun$getMainchainBlockReferenceDataInfoByHash$1(AbstractHistoryStorage $this, ByteArrayWrapper mcHash$3, int mcHeight) {
        return $this.activeChain().idByMcReferenceData(mcHash$3).map((Function1 & Serializable & scala.Serializable)sidechainBlockId -> new MainchainBlockReferenceDataInfo(mcHash$3, mcHeight, (String)sidechainBlockId));
    }

    public AbstractHistoryStorage(Storage storage, SparkzSerializer<PM> blockSerializer, SparkzSerializer<FPI> feePaymentsInfoSerializer, NetworkParams params) {
        this.storage = storage;
        this.blockSerializer = blockSerializer;
        this.feePaymentsInfoSerializer = feePaymentsInfoSerializer;
        this.params = params;
        SidechainStorageInfo.$init$(this);
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
        Predef$.MODULE$.require(storage != null, (Function0 & Serializable & scala.Serializable)() -> "Storage must be NOT NULL.");
        Predef$.MODULE$.require(blockSerializer != null, (Function0 & Serializable & scala.Serializable)() -> "Block serializer must be NOT NULL.");
        Predef$.MODULE$.require(params != null, (Function0 & Serializable & scala.Serializable)() -> "params must be NOT NULL.");
        this.bestBlockIdKey = new ByteArrayWrapper((byte[])Array$.MODULE$.fill(32, (Function0)(JFunction0.mcB.sp & Serializable & scala.Serializable)() -> -1, ClassTag$.MODULE$.Byte()));
        this.activeChain = this.loadActiveChain();
    }
}

