/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.secret;

import io.horizen.secret.PrivateKey25519;
import io.horizen.secret.SecretCreator;
import io.horizen.utils.Ed25519;
import io.horizen.utils.Pair;
import java.nio.charset.StandardCharsets;

public final class PrivateKey25519Creator
implements SecretCreator<PrivateKey25519> {
    private static final PrivateKey25519Creator instance;
    private static final byte[] domain;

    private PrivateKey25519Creator() {
    }

    public static PrivateKey25519Creator getInstance() {
        return instance;
    }

    @Override
    public PrivateKey25519 generateSecret(byte[] seed) {
        Pair<byte[], byte[]> keyPair = Ed25519.createKeyPair(seed);
        return new PrivateKey25519(keyPair.getKey(), keyPair.getValue());
    }

    @Override
    public byte[] salt() {
        return domain;
    }

    static {
        domain = "PrivateKey25519".getBytes(StandardCharsets.UTF_8);
        instance = new PrivateKey25519Creator();
    }
}

