/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.history.validation;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.account.block.AccountBlock;
import io.horizen.block.Ommer;
import io.horizen.block.OmmersContainer;
import io.horizen.block.SidechainBlockBase;
import io.horizen.block.SidechainBlockHeaderBase;
import io.horizen.chain.AbstractFeePaymentsInfo;
import io.horizen.chain.SidechainBlockInfo;
import io.horizen.consensus.ConsensusEpochAndSlot;
import io.horizen.consensus.FullConsensusEpochInfo;
import io.horizen.consensus.NonceConsensusEpochInfo;
import io.horizen.consensus.StakeConsensusEpochInfo;
import io.horizen.consensus.package$;
import io.horizen.fork.ActiveSlotCoefficientFork$;
import io.horizen.fork.ForkManager$;
import io.horizen.history.AbstractHistory;
import io.horizen.history.validation.HistoryBlockValidator;
import io.horizen.history.validation.InvalidSidechainBlockHeaderException;
import io.horizen.history.validation.InvalidSidechainBlockHeaderException$;
import io.horizen.history.validation.SidechainBlockSlotInFutureException;
import io.horizen.history.validation.SidechainBlockSlotInFutureException$;
import io.horizen.params.NetworkParams;
import io.horizen.storage.AbstractHistoryStorage;
import io.horizen.transaction.Transaction;
import io.horizen.utils.BytesUtils;
import io.horizen.utils.TimeToEpochUtils$;
import io.horizen.vrf.VrfOutput;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;
import sparkz.core.utils.TimeProvider;
import sparkz.util.SparkzLogging;

@ScalaSignature(bytes="\u0006\u0001\u0005mh\u0001\u0002\u0006\f\u0001QA\u0001b\u0019\u0001\u0003\u0002\u0003\u0006I\u0001\u001a\u0005\u0006Y\u0002!\t!\u001c\u0005\u0006a\u0002!\t%\u001d\u0005\u0006y\u0002!I! \u0005\b\u0003\u0003\u0001A\u0011BA\u0002\u0011\u001d\tY\u0001\u0001C\u0005\u0003\u001bAq!a\u000e\u0001\t\u0013\tI\u0004\u0003\u0005\u0002@\u0001!\taDA!\u0011!\t\t\u000e\u0001C\u0001\u001f\u0005M'AE\"p]N,gn];t-\u0006d\u0017\u000eZ1u_JT!\u0001D\u0007\u0002\u0015Y\fG.\u001b3bi&|gN\u0003\u0002\u000f\u001f\u00059\u0001.[:u_JL(B\u0001\t\u0012\u0003\u001dAwN]5{K:T\u0011AE\u0001\u0003S>\u001c\u0001!F\u0004\u0016E=J\u0004I\u0013+\u0014\t\u00011Bd\u0017\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0011uq\u0002E\f\u001d@\u0013Nk\u0011aC\u0005\u0003?-\u0011Q\u0003S5ti>\u0014\u0018P\u00117pG.4\u0016\r\\5eCR|'\u000f\u0005\u0002\"E1\u0001A!B\u0012\u0001\u0005\u0004!#A\u0001+Y#\t)\u0003\u0006\u0005\u0002\u0018M%\u0011q\u0005\u0007\u0002\b\u001d>$\b.\u001b8h!\tIC&D\u0001+\u0015\tYs\"A\u0006ue\u0006t7/Y2uS>t\u0017BA\u0017+\u0005-!&/\u00198tC\u000e$\u0018n\u001c8\u0011\u0005\u0005zC!\u0002\u0019\u0001\u0005\u0004\t$!\u0001%\u0012\u0005\u0015\u0012\u0004CA\u001a7\u001b\u0005!$BA\u001b\u0010\u0003\u0015\u0011Gn\\2l\u0013\t9DG\u0001\rTS\u0012,7\r[1j]\ncwnY6IK\u0006$WM\u001d\"bg\u0016\u0004\"!I\u001d\u0005\u000bi\u0002!\u0019A\u001e\u0003\tAku\nR\t\u0003Kq\u0002BaM\u001f!]%\u0011a\b\u000e\u0002\u0013'&$Wm\u00195bS:\u0014En\\2l\u0005\u0006\u001cX\r\u0005\u0002\"\u0001\u0012)\u0011\t\u0001b\u0001\u0005\n\u0019a\tU%\u0012\u0005\u0015\u001a\u0005C\u0001#H\u001b\u0005)%B\u0001$\u0010\u0003\u0015\u0019\u0007.Y5o\u0013\tAUIA\fBEN$(/Y2u\r\u0016,\u0007+Y=nK:$8/\u00138g_B\u0011\u0011E\u0013\u0003\u0006\u0017\u0002\u0011\r\u0001\u0014\u0002\u0006\u0011N#vJU\t\u0003K5\u0003RAT)9\u007f%k\u0011a\u0014\u0006\u0003!>\tqa\u001d;pe\u0006<W-\u0003\u0002S\u001f\n1\u0012IY:ue\u0006\u001cG\u000fS5ti>\u0014\u0018p\u0015;pe\u0006<W\r\u0005\u0002\")\u0012)Q\u000b\u0001b\u0001-\n\u0011\u0001\nV\t\u0003K]\u0003\u0002\u0002W-!]az\u0014jU\u0007\u0002\u001b%\u0011!,\u0004\u0002\u0010\u0003\n\u001cHO]1di\"K7\u000f^8ssB\u0011A,Y\u0007\u0002;*\u0011alX\u0001\u0005kRLGNC\u0001a\u0003\u0019\u0019\b/\u0019:lu&\u0011!-\u0018\u0002\u000e'B\f'o\u001b>M_\u001e<\u0017N\\4\u0002\u0019QLW.\u001a)s_ZLG-\u001a:\u0011\u0005\u0015TW\"\u00014\u000b\u0005\u001dD\u0017!B;uS2\u001c(BA5`\u0003\u0011\u0019wN]3\n\u0005-4'\u0001\u0004+j[\u0016\u0004&o\u001c<jI\u0016\u0014\u0018A\u0002\u001fj]&$h\b\u0006\u0002o_BAQ\u0004\u0001\u0011/q}J5\u000bC\u0003d\u0005\u0001\u0007A-\u0001\u0005wC2LG-\u0019;f)\r\u0011(p\u001f\t\u0004gV<X\"\u0001;\u000b\u0005yC\u0012B\u0001<u\u0005\r!&/\u001f\t\u0003/aL!!\u001f\r\u0003\tUs\u0017\u000e\u001e\u0005\u0006k\r\u0001\r\u0001\u000f\u0005\u0006\u001d\r\u0001\raU\u0001\u0015m\u0006d\u0017\u000eZ1uK\u001e+g.Z:jg\ncwnY6\u0015\u0007]tx\u0010C\u00036\t\u0001\u0007\u0001\bC\u0003\u000f\t\u0001\u00071+A\fwC2LG-\u0019;f\u001d>tw)\u001a8fg&\u001c(\t\\8dWR)q/!\u0002\u0002\n!1\u0011qA\u0003A\u0002a\nQB^3sS\u001aLW\r\u001a\"m_\u000e\\\u0007\"\u0002\b\u0006\u0001\u0004\u0019\u0016a\u0004<fe&4\u0017\u0010V5nKN$\u0018-\u001c9\u0015\u000f]\fy!!\n\u0002*!9\u0011\u0011\u0003\u0004A\u0002\u0005M\u0011A\u0006<fe&4\u0017.\u001a3CY>\u001c7\u000eV5nKN$\u0018-\u001c9\u0011\t\u0005U\u0011q\u0004\b\u0005\u0003/\tY\"\u0004\u0002\u0002\u001a)\u0011Q\u0007[\u0005\u0005\u0003;\tI\"A\u0003CY>\u001c7.\u0003\u0003\u0002\"\u0005\r\"!\u0003+j[\u0016\u001cH/Y7q\u0015\u0011\ti\"!\u0007\t\u000f\u0005\u001db\u00011\u0001\u0002\u0014\u0005!\u0002/\u0019:f]R\u0014En\\2l)&lWm\u001d;b[BDq!a\u000b\u0007\u0001\u0004\ti#\u0001\u0004qCJ\fWn\u001d\t\u0005\u0003_\t\u0019$\u0004\u0002\u00022)\u0019\u00111F\b\n\t\u0005U\u0012\u0011\u0007\u0002\u000e\u001d\u0016$xo\u001c:l!\u0006\u0014\u0018-\\:\u0002/Y,'/\u001b4z)&lWm\u001d;b[BLeNR;ukJ,G#B<\u0002<\u0005u\u0002bBA\t\u000f\u0001\u0007\u00111\u0003\u0005\u0006\u001d\u001d\u0001\raU\u0001\rm\u0016\u0014\u0018NZ=P[6,'o\u001d\u000b\u0010o\u0006\r\u0013QJA/\u0003O\n9)!%\u0002\u0014\"9\u0011Q\t\u0005A\u0002\u0005\u001d\u0013aD8n[\u0016\u00148oQ8oi\u0006Lg.\u001a:\u0011\tM\nIEL\u0005\u0004\u0003\u0017\"$aD(n[\u0016\u00148oQ8oi\u0006Lg.\u001a:\t\u000f\u0005=\u0003\u00021\u0001\u0002R\u0005i2-\u001e:sK:$h)\u001e7m\u0007>t7/\u001a8tkN,\u0005o\\2i\u0013:4w\u000e\u0005\u0003\u0002T\u0005eSBAA+\u0015\r\t9fD\u0001\nG>t7/\u001a8tkNLA!a\u0017\u0002V\t1b)\u001e7m\u0007>t7/\u001a8tkN,\u0005o\\2i\u0013:4w\u000eC\u0004\u0002`!\u0001\r!!\u0019\u0002CA\u0014XM^5pkN4U\u000f\u001c7D_:\u001cXM\\:vg\u0016\u0003xn\u00195J]\u001a|w\n\u001d;\u0011\u000b]\t\u0019'!\u0015\n\u0007\u0005\u0015\u0004D\u0001\u0004PaRLwN\u001c\u0005\b\u0003SB\u0001\u0019AA6\u0003E\u0011Wm\u001d;L]><h\u000eU1sK:$\u0018\n\u001a\t\u0005\u0003[\n\tI\u0004\u0003\u0002p\u0005ud\u0002BA9\u0003wrA!a\u001d\u0002z5\u0011\u0011Q\u000f\u0006\u0004\u0003o\u001a\u0012A\u0002\u001fs_>$h(C\u0001a\u0013\tqv,C\u0002\u0002\u0000u\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0004\u0006\u0015%AC'pI&4\u0017.\u001a:JI*\u0019\u0011qP/\t\u000f\u0005%\u0005\u00021\u0001\u0002\f\u0006\u0019\"-Z:u\u0017:|wO\u001c)be\u0016tG/\u00138g_B\u0019A)!$\n\u0007\u0005=UI\u0001\nTS\u0012,7\r[1j]\ncwnY6J]\u001a|\u0007\"\u0002\b\t\u0001\u0004\u0019\u0006bBAK\u0011\u0001\u0007\u0011qS\u0001#aJ,g/[8vg\u0016\u0003xn\u00195P[6,'o]%oM>\f5mY;nk2\fGo\u001c:\u0011\r\u0005e\u0015\u0011UAT\u001d\u0011\tY*a(\u000f\t\u0005M\u0014QT\u0005\u00023%\u0019\u0011q\u0010\r\n\t\u0005\r\u0016Q\u0015\u0002\u0004'\u0016\f(bAA@1A9q#!+\u0002.\u0006e\u0016bAAV1\t1A+\u001e9mKJ\u0002B!a,\u000266\u0011\u0011\u0011\u0017\u0006\u0004\u0003g{\u0011a\u0001<sM&!\u0011qWAY\u0005%1&OZ(viB,H\u000f\u0005\u0003\u0002<\u0006-g\u0002BA_\u0003\u0013tA!a0\u0002H:!\u0011\u0011YAc\u001d\u0011\t\u0019(a1\n\u0003II!\u0001E\t\n\u0007\u0005]s\"\u0003\u0003\u0002\u0000\u0005U\u0013\u0002BAg\u0003\u001f\u00141cQ8og\u0016t7/^:TY>$h*^7cKJTA!a \u0002V\u00051b/\u001a:jMf4uN]4j]\u001e\u001cF/Y6f\u0013:4w\u000eF\u0006x\u0003+\fI.a9\u0002h\u0006E\bBBAl\u0013\u0001\u0007!'\u0001\u0004iK\u0006$WM\u001d\u0005\b\u00037L\u0001\u0019AAo\u0003]\u0019H/Y6f\u0007>t7/\u001a8tkN,\u0005o\\2i\u0013:4w\u000e\u0005\u0003\u0002T\u0005}\u0017\u0002BAq\u0003+\u0012qc\u0015;bW\u0016\u001cuN\\:f]N,8/\u00129pG\"LeNZ8\t\u000f\u0005\u0015\u0018\u00021\u0001\u0002.\u0006IaO\u001d4PkR\u0004X\u000f\u001e\u0005\b\u0003SL\u0001\u0019AAv\u0003U\u0001XM]2f]R\fw-\u001a$pe.\f\u0005\u000f\u001d7jK\u0012\u00042aFAw\u0013\r\ty\u000f\u0007\u0002\b\u0005>|G.Z1o\u0011\u001d\t\u00190\u0003a\u0001\u0003k\fQ#Y2uSZ,7\u000b\\8u\u0007>,gMZ5dS\u0016tG\u000fE\u0002\u0018\u0003oL1!!?\u0019\u0005\u0019!u.\u001e2mK\u0002")
public class ConsensusValidator<TX extends Transaction, H extends SidechainBlockHeaderBase, PMOD extends SidechainBlockBase<TX, H>, FPI extends AbstractFeePaymentsInfo, HSTOR extends AbstractHistoryStorage<PMOD, FPI, HSTOR>, HT extends AbstractHistory<TX, H, PMOD, FPI, HSTOR, HT>>
implements HistoryBlockValidator<TX, H, PMOD, FPI, HSTOR, HT>,
SparkzLogging {
    private final TimeProvider timeProvider;
    private final Logger logger;

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public Try<BoxedUnit> validate(PMOD block, HT history) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (history.isGenesisBlock(block.id())) {
                this.validateGenesisBlock(block, history);
            } else {
                this.validateNonGenesisBlock(block, history);
            }
        });
    }

    private void validateGenesisBlock(PMOD block, HT history) {
        if (((SidechainBlockBase)block).timestamp() != ((AbstractHistory)history).params().sidechainGenesisBlockTimestamp()) {
            throw new IllegalArgumentException(new StringBuilder(78).append("Genesis block timestamp ").append(((SidechainBlockBase)block).timestamp()).append(" is differ than expected timestamp from configuration ").append(((AbstractHistory)history).params().sidechainGenesisBlockTimestamp()).toString());
        }
        boolean vrfSignIsNotCorrect = false;
        if (vrfSignIsNotCorrect) {
            throw new IllegalArgumentException("Genesis block timestamp is not signed his own forger box");
        }
    }

    private void validateNonGenesisBlock(PMOD verifiedBlock, HT history) {
        SidechainBlockInfo parentBlockInfo = ((AbstractHistory)history).blockInfoById(((SidechainBlockBase)verifiedBlock).parentId());
        this.verifyTimestamp(((SidechainBlockBase)verifiedBlock).timestamp(), parentBlockInfo.timestamp(), ((AbstractHistory)history).params());
        FullConsensusEpochInfo currentConsensusEpochInfo = ((AbstractHistory)history).getFullConsensusEpochInfoForBlock(((SidechainBlockBase)verifiedBlock).timestamp(), ((SidechainBlockBase)verifiedBlock).parentId());
        VrfOutput vrfOutput = (VrfOutput)((AbstractHistory)history).getVrfOutput((SidechainBlockHeaderBase)((SidechainBlockBase)verifiedBlock).header(), currentConsensusEpochInfo.nonceConsensusEpochInfo()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(36).append("VRF check for block ").append(verifiedBlock.id()).append(" had been failed").toString());
        });
        Object PMOD = verifiedBlock;
        if (PMOD instanceof AccountBlock) {
            AccountBlock accountBlock = (AccountBlock)PMOD;
            VrfOutput vrfOutput2 = vrfOutput;
            VrfOutput vrfOutput3 = accountBlock.header().vrfOutput();
            if (vrfOutput2 == null ? vrfOutput3 != null : !((Object)vrfOutput2).equals(vrfOutput3)) {
                throw new InvalidSidechainBlockHeaderException(new StringBuilder(47).append("AccountBlockHeader ").append(accountBlock.id()).append(": vrfOutput value is invalid").toString(), InvalidSidechainBlockHeaderException$.MODULE$.$lessinit$greater$default$2());
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        int consensusEpoch = TimeToEpochUtils$.MODULE$.timeStampToEpochNumber(((AbstractHistory)history).params().sidechainGenesisBlockTimestamp(), ((SidechainBlockBase)verifiedBlock).timestamp());
        boolean stakePercentageForkApplied = ForkManager$.MODULE$.getSidechainFork(consensusEpoch).stakePercentageForkApplied();
        double activeSlotCoefficient = ActiveSlotCoefficientFork$.MODULE$.get(consensusEpoch).activeSlotCoefficient();
        this.verifyForgingStakeInfo((SidechainBlockHeaderBase)((SidechainBlockBase)verifiedBlock).header(), currentConsensusEpochInfo.stakeConsensusEpochInfo(), vrfOutput, stakePercentageForkApplied, activeSlotCoefficient);
        SidechainBlockInfo lastBlockInPreviousConsensusEpochInfo = ((AbstractHistory)history).blockInfoById(((AbstractHistory)history).getLastBlockInPreviousConsensusEpoch(((SidechainBlockBase)verifiedBlock).timestamp(), ((SidechainBlockBase)verifiedBlock).parentId()));
        FullConsensusEpochInfo previousFullConsensusEpochInfo = ((AbstractHistory)history).getFullConsensusEpochInfoForBlock(lastBlockInPreviousConsensusEpochInfo.timestamp(), lastBlockInPreviousConsensusEpochInfo.parentId());
        this.verifyOmmers((OmmersContainer<H>)verifiedBlock, currentConsensusEpochInfo, (Option<FullConsensusEpochInfo>)new Some((Object)previousFullConsensusEpochInfo), ((SidechainBlockBase)verifiedBlock).parentId(), parentBlockInfo, history, (Seq<Tuple2<VrfOutput, Object>>)((Seq)Nil$.MODULE$));
        this.verifyTimestampInFuture(((SidechainBlockBase)verifiedBlock).timestamp(), history);
    }

    private void verifyTimestamp(long verifiedBlockTimestamp, long parentBlockTimestamp, NetworkParams params) {
        int epochNumberForParentBlock;
        int absoluteSlotNumberForParentBlock;
        if (verifiedBlockTimestamp < parentBlockTimestamp) {
            throw new IllegalArgumentException("Block had been generated before parent block had been generated");
        }
        int absoluteSlotNumberForVerifiedBlock = TimeToEpochUtils$.MODULE$.timeStampToAbsoluteSlotNumber(params.sidechainGenesisBlockTimestamp(), verifiedBlockTimestamp);
        if (absoluteSlotNumberForVerifiedBlock <= (absoluteSlotNumberForParentBlock = TimeToEpochUtils$.MODULE$.timeStampToAbsoluteSlotNumber(params.sidechainGenesisBlockTimestamp(), parentBlockTimestamp))) {
            throw new IllegalArgumentException("Block absolute slot number is equal or less than parent block");
        }
        int epochNumberForVerifiedBlock = TimeToEpochUtils$.MODULE$.timeStampToEpochNumber(params.sidechainGenesisBlockTimestamp(), verifiedBlockTimestamp);
        if (epochNumberForVerifiedBlock - (epochNumberForParentBlock = TimeToEpochUtils$.MODULE$.timeStampToEpochNumber(params.sidechainGenesisBlockTimestamp(), parentBlockTimestamp)) > 1) {
            throw new IllegalStateException("Whole epoch had been skipped");
        }
    }

    private void verifyTimestampInFuture(long verifiedBlockTimestamp, HT history) {
        if (TimeToEpochUtils$.MODULE$.timeStampToAbsoluteSlotNumber(((AbstractHistory)history).params().sidechainGenesisBlockTimestamp(), verifiedBlockTimestamp) > TimeToEpochUtils$.MODULE$.timeStampToAbsoluteSlotNumber(((AbstractHistory)history).params().sidechainGenesisBlockTimestamp(), this.timeProvider.time() / 1000L)) {
            throw new SidechainBlockSlotInFutureException("Block had been generated in the future", SidechainBlockSlotInFutureException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    public void verifyOmmers(OmmersContainer<H> ommersContainer, FullConsensusEpochInfo currentFullConsensusEpochInfo, Option<FullConsensusEpochInfo> previousFullConsensusEpochInfoOpt, String bestKnownParentId, SidechainBlockInfo bestKnownParentInfo, HT history, Seq<Tuple2<VrfOutput, Object>> previousEpochOmmersInfoAccumulator) {
        Seq<Ommer<H>> ommers = ommersContainer.ommers();
        if (ommers.isEmpty()) {
            return;
        }
        int ommersContainerEpochNumber = TimeToEpochUtils$.MODULE$.timeStampToEpochNumber(((AbstractHistory)history).params().sidechainGenesisBlockTimestamp(), ommersContainer.header().timestamp());
        ObjectRef accumulator = ObjectRef.create(previousEpochOmmersInfoAccumulator);
        IntRef previousOmmerEpochNumber = IntRef.create((int)ommersContainerEpochNumber);
        ObjectRef ommerCurrentFullConsensusEpochInfo = ObjectRef.create((Object)currentFullConsensusEpochInfo);
        ObjectRef ommerPreviousFullConsensusEpochInfoOpt = ObjectRef.create(previousFullConsensusEpochInfoOpt);
        ommers.foreach((Function1 & Serializable & scala.Serializable)ommer -> {
            ConsensusValidator.$anonfun$verifyOmmers$1(this, history, previousOmmerEpochNumber, ommerCurrentFullConsensusEpochInfo, previousFullConsensusEpochInfoOpt, ommersContainer, ommerPreviousFullConsensusEpochInfoOpt, bestKnownParentId, bestKnownParentInfo, accumulator, currentFullConsensusEpochInfo, ommersContainerEpochNumber, ommer);
            return BoxedUnit.UNIT;
        });
    }

    public void verifyForgingStakeInfo(SidechainBlockHeaderBase header, StakeConsensusEpochInfo stakeConsensusEpochInfo, VrfOutput vrfOutput, boolean percentageForkApplied, double activeSlotCoefficient) {
        BoxedUnit boxedUnit;
        if (this.log().underlying().isDebugEnabled()) {
            new StringBuilder(61).append("Verify Forging stake info against root hash: ").append(BytesUtils.toHexString(stakeConsensusEpochInfo.rootHash())).append(" by merkle path ").append(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(header.forgingStakeMerklePath().bytes())).deep().mkString()).toString();
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        boolean forgingStakeIsCorrect = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(stakeConsensusEpochInfo.rootHash())).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(header.forgingStakeMerklePath().apply(header.forgingStakeInfo().hash())));
        if (!forgingStakeIsCorrect) {
            BoxedUnit boxedUnit2;
            if (this.log().underlying().isDebugEnabled()) {
                new StringBuilder(42).append("Actual stakeInfo: rootHash: ").append(BytesUtils.toHexString(stakeConsensusEpochInfo.rootHash())).append(", totalStake: ").append(stakeConsensusEpochInfo.totalStake()).toString();
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            throw new IllegalStateException(new StringBuilder(79).append("Forging stake merkle path in block ").append(header.id()).append(" is inconsistent to stakes merkle root hash ").append(BytesUtils.toHexString(stakeConsensusEpochInfo.rootHash())).toString());
        }
        long value = header.forgingStakeInfo().stakeAmount();
        boolean stakeIsEnough = package$.MODULE$.vrfProofCheckAgainstStake(vrfOutput, value, stakeConsensusEpochInfo.totalStake(), percentageForkApplied, activeSlotCoefficient);
        if (!stakeIsEnough) {
            throw new IllegalArgumentException(new StringBuilder(67).append("Stake value in forger box in block ").append(header.id()).append(" is not enough for to be forger.").toString());
        }
    }

    public static final /* synthetic */ void $anonfun$verifyOmmers$1(ConsensusValidator $this, AbstractHistory history$2, IntRef previousOmmerEpochNumber$1, ObjectRef ommerCurrentFullConsensusEpochInfo$1, Option previousFullConsensusEpochInfoOpt$1, OmmersContainer ommersContainer$1, ObjectRef ommerPreviousFullConsensusEpochInfoOpt$1, String bestKnownParentId$1, SidechainBlockInfo bestKnownParentInfo$1, ObjectRef accumulator$1, FullConsensusEpochInfo currentFullConsensusEpochInfo$1, int ommersContainerEpochNumber$1, Ommer ommer) {
        ConsensusEpochAndSlot ommerEpochAndSlot = TimeToEpochUtils$.MODULE$.timestampToEpochAndSlot(history$2.params().sidechainGenesisBlockTimestamp(), ommer.header().timestamp());
        if (ommerEpochAndSlot.epochNumber() < previousOmmerEpochNumber$1.elem) {
            ommerCurrentFullConsensusEpochInfo$1.elem = (FullConsensusEpochInfo)previousFullConsensusEpochInfoOpt$1.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalStateException(new StringBuilder(40).append("Block ").append(ommersContainer$1.header().id()).append(" contains ommer two epochs before.").toString());
            });
            ommerPreviousFullConsensusEpochInfoOpt$1.elem = None$.MODULE$;
        } else if (ommerEpochAndSlot.epochNumber() > previousOmmerEpochNumber$1.elem) {
            NonceConsensusEpochInfo nonce = history$2.calculateNonceForNonGenesisEpoch(bestKnownParentId$1, bestKnownParentInfo$1, (Seq<Tuple2<VrfOutput, Object>>)((Seq)accumulator$1.elem));
            ommerCurrentFullConsensusEpochInfo$1.elem = new FullConsensusEpochInfo(currentFullConsensusEpochInfo$1.stakeConsensusEpochInfo(), nonce);
            ommerPreviousFullConsensusEpochInfoOpt$1.elem = previousFullConsensusEpochInfoOpt$1;
        }
        VrfOutput ommerVrfOutput = (VrfOutput)history$2.getVrfOutput((SidechainBlockHeaderBase)ommer.header(), ((FullConsensusEpochInfo)ommerCurrentFullConsensusEpochInfo$1.elem).nonceConsensusEpochInfo()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(36).append("VRF check for Ommer ").append(ommer.header().id()).append(" had been failed").toString());
        });
        boolean stakePercentageForkApplied = ForkManager$.MODULE$.getSidechainFork(ommersContainerEpochNumber$1).stakePercentageForkApplied();
        double activeSlotCoefficient = ActiveSlotCoefficientFork$.MODULE$.get(ommersContainerEpochNumber$1).activeSlotCoefficient();
        $this.verifyForgingStakeInfo((SidechainBlockHeaderBase)ommer.header(), ((FullConsensusEpochInfo)ommerCurrentFullConsensusEpochInfo$1.elem).stakeConsensusEpochInfo(), ommerVrfOutput, stakePercentageForkApplied, activeSlotCoefficient);
        $this.verifyOmmers(ommer, (FullConsensusEpochInfo)ommerCurrentFullConsensusEpochInfo$1.elem, (Option<FullConsensusEpochInfo>)((Option)ommerPreviousFullConsensusEpochInfoOpt$1.elem), bestKnownParentId$1, bestKnownParentInfo$1, history$2, (Seq<Tuple2<VrfOutput, Object>>)((Seq)accumulator$1.elem));
        if (ommerEpochAndSlot.epochNumber() < ommersContainerEpochNumber$1) {
            Tuple2 tuple2 = new Tuple2((Object)ommerVrfOutput, (Object)BoxesRunTime.boxToInteger((int)ommerEpochAndSlot.slotNumber()));
            accumulator$1.elem = (Seq)((Seq)accumulator$1.elem).$plus$colon((Object)tuple2, Seq$.MODULE$.canBuildFrom());
        }
        previousOmmerEpochNumber$1.elem = ommerEpochAndSlot.epochNumber();
    }

    public ConsensusValidator(TimeProvider timeProvider) {
        this.timeProvider = timeProvider;
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
    }
}

