/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.cryptolibprovider.utils;

import com.horizen.librustsidechains.Constants;
import com.horizen.librustsidechains.FieldElement;
import java.util.Arrays;

public class FieldElementUtils {
    public static int fieldElementLength() {
        return Constants.FIELD_ELEMENT_LENGTH();
    }

    public static FieldElement messageToFieldElement(byte[] message) {
        if (message.length != FieldElementUtils.fieldElementLength()) {
            throw new IllegalArgumentException("Unexpected message length. Message len " + message.length + " but it should be equal to " + FieldElementUtils.fieldElementLength());
        }
        return FieldElement.deserialize((byte[])message);
    }

    public static FieldElement elementToFieldElement(byte[] element) {
        if (element.length > FieldElementUtils.fieldElementLength()) {
            throw new IllegalArgumentException("Element length is exceed allowed element len. Field len " + element.length + " but it shall be less than " + FieldElementUtils.fieldElementLength());
        }
        return FieldElement.deserialize((byte[])Arrays.copyOf(element, FieldElementUtils.fieldElementLength()));
    }

    public static byte[] randomFieldElementBytes() {
        FieldElement fe = FieldElement.createRandom();
        byte[] feBytes = fe.serializeFieldElement();
        fe.freeFieldElement();
        return feBytes;
    }

    public static byte[] randomFieldElementBytes(long seed) {
        FieldElement fe = FieldElement.createRandom((long)seed);
        byte[] feBytes = fe.serializeFieldElement();
        fe.freeFieldElement();
        return feBytes;
    }
}

