/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.certificatesubmitter.strategies;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.AbstractState;
import io.horizen.certificatesubmitter.AbstractCertificateSubmitter;
import io.horizen.certificatesubmitter.strategies.CertificateSubmissionStrategy;
import io.horizen.certificatesubmitter.strategies.NonCeasingSidechain$;
import io.horizen.certificatesubmitter.strategies.SubmissionWindowStatus;
import io.horizen.history.AbstractHistory;
import io.horizen.params.NetworkParams;
import io.horizen.utils.BytesUtils;
import io.horizen.utils.WithdrawalEpochInfo;
import io.horizen.websocket.client.ChainTopQualityCertificateInfo;
import io.horizen.websocket.client.MainchainNodeChannel;
import io.horizen.websocket.client.MempoolTopQualityCertificateInfo;
import io.horizen.websocket.client.TopQualityCertificates;
import java.io.Serializable;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import sparkz.util.SparkzLogging;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015d\u0001\u0002\u0007\u000e\u0001YA\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\te\u0001\u0011\t\u0011)A\u0005g!)\u0001\b\u0001C\u0001s!)Q\b\u0001C!}!9\u0011\u0011\u0005\u0001\u0005B\u0005\r\u0002bBA%\u0001\u0011%\u00111J\u0004\b\u0003/j\u0001\u0012AA-\r\u0019aQ\u0002#\u0001\u0002\\!1\u0001\b\u0003C\u0001\u0003;B\u0011\"a\u0018\t\u0005\u0004%I!!\u0019\t\u0011\u0005\r\u0004\u0002)A\u0005\u0003#\u00121CT8o\u0007\u0016\f7/\u001b8h'&$Wm\u00195bS:T!AD\b\u0002\u0015M$(/\u0019;fO&,7O\u0003\u0002\u0011#\u0005!2-\u001a:uS\u001aL7-\u0019;fgV\u0014W.\u001b;uKJT!AE\n\u0002\u000f!|'/\u001b>f]*\tA#\u0001\u0002j_\u000e\u00011\u0003\u0002\u0001\u0018;\u0005\u0002\"\u0001G\u000e\u000e\u0003eQ\u0011AG\u0001\u0006g\u000e\fG.Y\u0005\u00039e\u0011a!\u00118z%\u00164\u0007C\u0001\u0010 \u001b\u0005i\u0011B\u0001\u0011\u000e\u0005u\u0019UM\u001d;jM&\u001c\u0017\r^3Tk\nl\u0017n]:j_:\u001cFO]1uK\u001eL\bC\u0001\u0012(\u001b\u0005\u0019#B\u0001\u0013&\u0003\u0011)H/\u001b7\u000b\u0003\u0019\naa\u001d9be.T\u0018B\u0001\u0015$\u00055\u0019\u0006/\u0019:lu2{wmZ5oO\u0006\u0001R.Y5oG\"\f\u0017N\\\"iC:tW\r\u001c\t\u0003WAj\u0011\u0001\f\u0006\u0003[9\naa\u00197jK:$(BA\u0018\u0012\u0003%9XMY:pG.,G/\u0003\u00022Y\t!R*Y5oG\"\f\u0017N\u001c(pI\u0016\u001c\u0005.\u00198oK2\fa\u0001]1sC6\u001c\bC\u0001\u001b7\u001b\u0005)$B\u0001\u001a\u0012\u0013\t9TGA\u0007OKR<xN]6QCJ\fWn]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007iZD\b\u0005\u0002\u001f\u0001!)\u0011f\u0001a\u0001U!)!g\u0001a\u0001g\u0005Iq-\u001a;Ti\u0006$Xo]\u000b\u0004\u007f\u001dcG#\u0002!DS\u0006\u0005\u0001C\u0001\u0010B\u0013\t\u0011UB\u0001\fTk\nl\u0017n]:j_:<\u0016N\u001c3poN#\u0018\r^;t\u0011\u0015!E\u00011\u0001F\u0003\u001dA\u0017n\u001d;pef\u0004\"AR$\r\u0001\u0011)\u0001\n\u0002b\u0001\u0013\n\t\u0001*\u0005\u0002K\u001bB\u0011\u0001dS\u0005\u0003\u0019f\u0011qAT8uQ&tw\rM\u0004O)ns\u0016\rZ4\u0011\u0011=\u000b6KW/aG\u001al\u0011\u0001\u0015\u0006\u0003\tFI!A\u0015)\u0003\u001f\u0005\u00137\u000f\u001e:bGRD\u0015n\u001d;pef\u0004\"A\u0012+\u0005\u0013U;\u0015\u0011!A\u0001\u0006\u00031&aA0%cE\u0011!j\u0016\t\u00031aK!!W\r\u0003\u0007\u0005s\u0017\u0010\u0005\u0002G7\u0012IAlRA\u0001\u0002\u0003\u0015\tA\u0016\u0002\u0004?\u0012\u0012\u0004C\u0001$_\t%yv)!A\u0001\u0002\u000b\u0005aKA\u0002`IM\u0002\"AR1\u0005\u0013\t<\u0015\u0011!A\u0001\u0006\u00031&aA0%iA\u0011a\t\u001a\u0003\nK\u001e\u000b\t\u0011!A\u0003\u0002Y\u00131a\u0018\u00136!\t1u\rB\u0005i\u000f\u0006\u0005\t\u0011!B\u0001-\n\u0019q\f\n\u001c\t\u000b)$\u0001\u0019A6\u0002\u000bM$\u0018\r^3\u0011\u0005\u0019cG!B7\u0005\u0005\u0004q'!A*\u0012\u0005){\u0007'\u00029vqnt\bCB9si^TX0D\u0001\u0012\u0013\t\u0019\u0018CA\u0007BEN$(/Y2u'R\fG/\u001a\t\u0003\rV$\u0011B\u001e7\u0002\u0002\u0003\u0005)\u0011\u0001,\u0003\u0007}#s\u0007\u0005\u0002Gq\u0012I\u0011\u0010\\A\u0001\u0002\u0003\u0015\tA\u0016\u0002\u0004?\u0012B\u0004C\u0001$|\t%aH.!A\u0001\u0002\u000b\u0005aKA\u0002`Ie\u0002\"A\u0012@\u0005\u0013}d\u0017\u0011!A\u0001\u0006\u00031&\u0001B0%cABq!a\u0001\u0005\u0001\u0004\t)!\u0001\u0002jIB!\u0011qAA\u000e\u001d\u0011\tI!a\u0006\u000f\t\u0005-\u0011Q\u0003\b\u0005\u0003\u001b\t\u0019\"\u0004\u0002\u0002\u0010)\u0019\u0011\u0011C\u000b\u0002\rq\u0012xn\u001c;?\u0013\u00051\u0013B\u0001\u0013&\u0013\r\tIbI\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti\"a\b\u0003\u00155{G-\u001b4jKJLEMC\u0002\u0002\u001a\r\nAb\u00195fG.\fV/\u00197jif$B!!\n\u0002,A\u0019\u0001$a\n\n\u0007\u0005%\u0012DA\u0004C_>dW-\u00198\t\u000f\u00055R\u00011\u0001\u00020\u000511\u000f^1ukN\u0004B!!\r\u0002D9!\u00111GA \u001d\u0011\t)$!\u0010\u000f\t\u0005]\u00121\b\b\u0005\u0003\u001b\tI$C\u0001\u0015\u0013\t\u00112#\u0003\u0002\u0011#%\u0019\u0011\u0011I\b\u00029\u0005\u00137\u000f\u001e:bGR\u001cUM\u001d;jM&\u001c\u0017\r^3Tk\nl\u0017\u000e\u001e;fe&!\u0011QIA$\u0005A\u0019\u0016n\u001a8biV\u0014Xm]*uCR,8OC\u0002\u0002B=\tA#[:DKJ$\u0018NZ5dCR,\u0007K]3tK:$H\u0003BA\u0013\u0003\u001bBq!a\u0014\u0007\u0001\u0004\t\t&A\u0003fa>\u001c\u0007\u000eE\u0002\u0019\u0003'J1!!\u0016\u001a\u0005\rIe\u000e^\u0001\u0014\u001d>t7)Z1tS:<7+\u001b3fG\"\f\u0017N\u001c\t\u0003=!\u0019\"\u0001C\f\u0015\u0005\u0005e\u0013\u0001\b(P\u001d~\u001bU)Q*J\u001d\u001e{6+\u0016\"N\u0013N\u001b\u0016j\u0014(`\t\u0016c\u0015)W\u000b\u0003\u0003#\nQDT(O?\u000e+\u0015iU%O\u000f~\u001bVKQ'J'NKuJT0E\u000b2\u000b\u0015\f\t")
public class NonCeasingSidechain
implements CertificateSubmissionStrategy,
SparkzLogging {
    private final MainchainNodeChannel mainchainChannel;
    private final NetworkParams params;
    private final Logger logger;

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public <H extends AbstractHistory<?, ?, ?, ?, ?, ?>, S extends AbstractState<?, ?, ?, ?>> SubmissionWindowStatus getStatus(H history, S state, String id) {
        WithdrawalEpochInfo withdrawalEpochInfo = history.blockInfoById(id).withdrawalEpochInfo();
        int nextCertReferencedEpochNumber = BoxesRunTime.unboxToInt((Object)state.lastCertificateReferencedEpoch().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1)) + 1;
        int certSubmissionEpoch = nextCertReferencedEpochNumber + 1;
        return certSubmissionEpoch < withdrawalEpochInfo.epoch() ? new SubmissionWindowStatus(nextCertReferencedEpochNumber, true) : (certSubmissionEpoch == withdrawalEpochInfo.epoch() && withdrawalEpochInfo.lastEpochIndex() >= NonCeasingSidechain$.MODULE$.io$horizen$certificatesubmitter$strategies$NonCeasingSidechain$$NON_CEASING_SUBMISSION_DELAY() ? new SubmissionWindowStatus(nextCertReferencedEpochNumber, true) : new SubmissionWindowStatus(nextCertReferencedEpochNumber, false));
    }

    @Override
    public boolean checkQuality(AbstractCertificateSubmitter.SignaturesStatus status) {
        return status.knownSigs().size() >= this.params.signersThreshold() && !this.isCertificatePresent(status.referencedEpoch());
    }

    private boolean isCertificatePresent(int epoch) {
        Try<TopQualityCertificates> try_ = this.mainchainChannel.getTopQualityCertificates(BytesUtils.toHexString(BytesUtils.reverseBytes(this.params.sidechainId())));
        if (try_ instanceof Success) {
            Some some;
            ChainTopQualityCertificateInfo ccInfo;
            Option option;
            Some some2;
            ChainTopQualityCertificateInfo ccInfo2;
            Option option2;
            Some some3;
            MempoolTopQualityCertificateInfo mcInfo;
            Option option3;
            Some some4;
            MempoolTopQualityCertificateInfo mcInfo2;
            Option option4;
            Success success = (Success)try_;
            TopQualityCertificates topQualityCertificates = (TopQualityCertificates)success.value();
            Tuple2 tuple2 = new Tuple2(topQualityCertificates.mempoolCertInfo(), topQualityCertificates.chainCertInfo());
            if (tuple2 != null && (option4 = (Option)tuple2._1()) instanceof Some && (mcInfo2 = (MempoolTopQualityCertificateInfo)(some4 = (Some)option4).value()).epoch() == epoch && mcInfo2.certHash() != null) {
                BoxedUnit boxedUnit;
                if (this.log().underlying().isInfoEnabled()) {
                    this.log().underlying().info(new StringBuilder(60).append("Submission not needed. Certificate already present in epoch ").append(epoch).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return true;
            }
            if (tuple2 != null && (option3 = (Option)tuple2._1()) instanceof Some && (mcInfo = (MempoolTopQualityCertificateInfo)(some3 = (Some)option3).value()).epoch() > epoch && mcInfo.certHash() != null) {
                BoxedUnit boxedUnit;
                if (this.log().underlying().isInfoEnabled()) {
                    this.log().underlying().info(new StringBuilder(47).append("Requested epoch ").append(epoch).append(" is obsolete. Current epoch is ").append(mcInfo.epoch()).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return true;
            }
            if (tuple2 != null && (option2 = (Option)tuple2._2()) instanceof Some && (ccInfo2 = (ChainTopQualityCertificateInfo)(some2 = (Some)option2).value()).epoch() == epoch && ccInfo2.certHash() != null) {
                BoxedUnit boxedUnit;
                if (this.log().underlying().isInfoEnabled()) {
                    this.log().underlying().info(new StringBuilder(60).append("Submission not needed. Certificate already present in epoch ").append(epoch).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return true;
            }
            if (tuple2 != null && (option = (Option)tuple2._2()) instanceof Some && (ccInfo = (ChainTopQualityCertificateInfo)(some = (Some)option).value()).epoch() > epoch && ccInfo.certHash() != null) {
                BoxedUnit boxedUnit;
                if (this.log().underlying().isInfoEnabled()) {
                    this.log().underlying().info(new StringBuilder(47).append("Requested epoch ").append(epoch).append(" is obsolete. Current epoch is ").append(ccInfo.epoch()).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return true;
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        } else if (try_ instanceof Failure) {
            BoxedUnit boxedUnit;
            if (this.log().underlying().isInfoEnabled()) {
                this.log().underlying().info("Check for top quality certificates before sending it failed. Trying to send the new certificate anyway.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        } else {
            throw new MatchError(try_);
        }
        return false;
    }

    public NonCeasingSidechain(MainchainNodeChannel mainchainChannel, NetworkParams params) {
        this.mainchainChannel = mainchainChannel;
        this.params = params;
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
    }
}

