/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.api.http;

import akka.http.scaladsl.model.StatusCode;
import akka.http.scaladsl.model.StatusCodes$;
import akka.http.scaladsl.server.MalformedQueryParamRejection;
import akka.http.scaladsl.server.MalformedRequestContentRejection;
import akka.http.scaladsl.server.MethodRejection;
import akka.http.scaladsl.server.MissingFormFieldRejection;
import akka.http.scaladsl.server.MissingQueryParamRejection;
import akka.http.scaladsl.server.Rejection;
import akka.http.scaladsl.server.RejectionHandler;
import akka.http.scaladsl.server.RejectionHandler$;
import akka.http.scaladsl.server.RequestEntityExpectedRejection$;
import akka.http.scaladsl.server.ValidationRejection;
import io.horizen.api.http.SidechainApiError;
import io.horizen.api.http.SidechainApiError$;
import scala.Function1;
import scala.PartialFunction;
import scala.Serializable;

public final class SidechainApiRejectionHandler$ {
    public static SidechainApiRejectionHandler$ MODULE$;
    private final RejectionHandler rejectionHandler;

    static {
        new SidechainApiRejectionHandler$();
    }

    public RejectionHandler rejectionHandler() {
        return this.rejectionHandler;
    }

    private SidechainApiRejectionHandler$() {
        MODULE$ = this;
        this.rejectionHandler = RejectionHandler$.MODULE$.newBuilder().handle((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Rejection, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof ValidationRejection) {
                    ValidationRejection validationRejection = (ValidationRejection)A1;
                    String msg = validationRejection.message();
                    object = new SidechainApiError((StatusCode)StatusCodes$.MODULE$.BadRequest(), "Validation failed").complete(msg);
                } else if (A1 instanceof MissingFormFieldRejection) {
                    MissingFormFieldRejection missingFormFieldRejection = (MissingFormFieldRejection)A1;
                    String fieldName = missingFormFieldRejection.fieldName();
                    object = new SidechainApiError((StatusCode)StatusCodes$.MODULE$.BadRequest(), "Missing Form Field").complete(new StringBuilder(30).append("The required (").append(fieldName).append(") was not found.").toString());
                } else if (A1 instanceof MissingQueryParamRejection) {
                    MissingQueryParamRejection missingQueryParamRejection = (MissingQueryParamRejection)A1;
                    String param = missingQueryParamRejection.parameterName();
                    object = new SidechainApiError((StatusCode)StatusCodes$.MODULE$.BadRequest(), "Missing Parameter").complete(new StringBuilder(30).append("The required (").append(param).append(") was not found.").toString());
                } else if (A1 instanceof MalformedQueryParamRejection) {
                    MalformedQueryParamRejection malformedQueryParamRejection = (MalformedQueryParamRejection)A1;
                    String param = malformedQueryParamRejection.parameterName();
                    object = new SidechainApiError((StatusCode)StatusCodes$.MODULE$.BadRequest(), "Malformed Parameter").complete(new StringBuilder(30).append("The required (").append(param).append(") was not found.").toString());
                } else if (A1 instanceof MalformedRequestContentRejection) {
                    MalformedRequestContentRejection malformedRequestContentRejection = (MalformedRequestContentRejection)A1;
                    String msg = malformedRequestContentRejection.message();
                    object = new SidechainApiError((StatusCode)StatusCodes$.MODULE$.BadRequest(), "Malformed Request").complete(msg);
                } else {
                    object = A1 instanceof MethodRejection ? SidechainApiError$.MODULE$.toRoute(new SidechainApiError((StatusCode)StatusCodes$.MODULE$.MethodNotAllowed(), "HTTP method not allowed.")) : (RequestEntityExpectedRejection$.MODULE$.equals(A1) ? SidechainApiError$.MODULE$.toRoute(new SidechainApiError((StatusCode)StatusCodes$.MODULE$.BadRequest(), "Request entity expected but not supplied")) : function1.apply(x1));
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Rejection x1) {
                Rejection rejection = x1;
                boolean bl = rejection instanceof ValidationRejection ? true : (rejection instanceof MissingFormFieldRejection ? true : (rejection instanceof MissingQueryParamRejection ? true : (rejection instanceof MalformedQueryParamRejection ? true : (rejection instanceof MalformedRequestContentRejection ? true : (rejection instanceof MethodRejection ? true : RequestEntityExpectedRejection$.MODULE$.equals(rejection))))));
                return bl;
            }
        }).handleNotFound(new SidechainApiError((StatusCode)StatusCodes$.MODULE$.NotFound(), "NotFound").complete("The requested resource could not be found.")).result();
    }
}

