/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.websocket;

import akka.actor.ActorRef;
import akka.pattern.AskableActorRef$;
import akka.util.Timeout;
import akka.util.Timeout$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.account.api.rpc.service.RpcFilter$;
import io.horizen.account.api.rpc.types.EthereumBlockView;
import io.horizen.account.api.rpc.types.EthereumLogView;
import io.horizen.account.block.AccountBlock;
import io.horizen.account.history.AccountHistory;
import io.horizen.account.mempool.AccountMemoryPool;
import io.horizen.account.proposition.AddressProposition;
import io.horizen.account.state.AccountState;
import io.horizen.account.state.AccountStateView;
import io.horizen.account.wallet.AccountWallet;
import io.horizen.account.websocket.WebSocketAccountServerRef$;
import io.horizen.account.websocket.data.SubscriptionWithFilter;
import io.horizen.account.websocket.data.WebSocketEthereumBlockView;
import io.horizen.evm.Address;
import io.horizen.evm.Hash;
import io.horizen.history.AbstractHistory;
import io.horizen.proposition.Proposition;
import io.horizen.utils.ClosableResourceHandler;
import io.horizen.wallet.AbstractWallet;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sparkz.core.NodeViewHolder;
import sparkz.util.SparkzLogging;
import sparkz.util.package;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005e\u0001B\u0006\r\u0001UAQA\u000b\u0001\u0005\u0002-BqA\f\u0001C\u0002\u0013\rq\u0006\u0003\u00048\u0001\u0001\u0006I\u0001\r\u0005\bq\u0001\u0011\r\u0011b\u0001:\u0011\u0019\u0001\u0005\u0001)A\u0005u\u0015!\u0011\t\u0001\u0001C\u0011\u0015Q\u0007\u0001\"\u0003l\u0011\u0019y\b\u0001\"\u0001\u0002\u0002!9\u0011\u0011\u0006\u0001\u0005\u0002\u0005-\u0002bBA:\u0001\u0011\u0005\u0011Q\u000f\u0002\u001c/\u0016\u00147k\\2lKR\f5mY8v]R\u001c\u0005.\u00198oK2LU\u000e\u001d7\u000b\u00055q\u0011!C<fEN|7m[3u\u0015\ty\u0001#A\u0004bG\u000e|WO\u001c;\u000b\u0005E\u0011\u0012a\u00025pe&TXM\u001c\u0006\u0002'\u0005\u0011\u0011n\\\u0002\u0001'\u0011\u0001a\u0003\b\u0013\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\r\u0005s\u0017PU3g!\ti\"%D\u0001\u001f\u0015\ty\u0002%\u0001\u0003vi&d'\"A\u0011\u0002\rM\u0004\u0018M]6{\u0013\t\u0019cDA\u0007Ta\u0006\u00148N\u001f'pO\u001eLgn\u001a\t\u0003K!j\u0011A\n\u0006\u0003OA\tQ!\u001e;jYNL!!\u000b\u0014\u0003/\rcwn]1cY\u0016\u0014Vm]8ve\u000e,\u0007*\u00198eY\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u0001-!\ti\u0003!D\u0001\r\u0003!!WO]1uS>tW#\u0001\u0019\u0011\u0005E*T\"\u0001\u001a\u000b\u0005}\u0019$\"\u0001\u001b\u0002\t\u0005\\7.Y\u0005\u0003mI\u0012q\u0001V5nK>,H/A\u0005ekJ\fG/[8oA\u0005\u0011QmY\u000b\u0002uA\u00111HP\u0007\u0002y)\u0011Q\bG\u0001\u000bG>t7-\u001e:sK:$\u0018BA =\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH/A\u0002fG\u0002\u0012!A\u0014,\u0011\r\r{%\u000b\u00170e\u001d\t!EJ\u0004\u0002F\u0015:\u0011a)S\u0007\u0002\u000f*\u0011\u0001\nF\u0001\u0007yI|w\u000e\u001e \n\u0003\u0005J!a\u0013\u0011\u0002\t\r|'/Z\u0005\u0003\u001b:\u000baBT8eKZKWm\u001e%pY\u0012,'O\u0003\u0002LA%\u0011\u0001+\u0015\u0002\f\u0007V\u0014(/\u001a8u-&,wO\u0003\u0002N\u001dB\u00111KV\u0007\u0002)*\u0011QKD\u0001\bQ&\u001cHo\u001c:z\u0013\t9FK\u0001\bBG\u000e|WO\u001c;ISN$xN]=\u0011\u0005ecV\"\u0001.\u000b\u0005ms\u0011!B:uCR,\u0017BA/[\u00051\t5mY8v]R\u001cF/\u0019;f!\ty&-D\u0001a\u0015\t\tg\"\u0001\u0004xC2dW\r^\u0005\u0003G\u0002\u0014Q\"Q2d_VtGoV1mY\u0016$\bCA3i\u001b\u00051'BA4\u000f\u0003\u001diW-\u001c9p_2L!!\u001b4\u0003#\u0005\u001b7m\\;oi6+Wn\u001c:z!>|G.\u0001\nbaBd\u0017p\u00148BG\u000e|WO\u001c;WS\u0016<XC\u00017p)\ti\u0007\u0010\u0005\u0002o_2\u0001A!\u00029\b\u0005\u0004\t(!\u0001*\u0012\u0005I,\bCA\ft\u0013\t!\bDA\u0004O_RD\u0017N\\4\u0011\u0005]1\u0018BA<\u0019\u0005\r\te.\u001f\u0005\u0006s\u001e\u0001\rA_\u0001\u0014MVt7\r^5p]R{')Z!qa2LW\r\u001a\t\u0005/mlX.\u0003\u0002}1\tIa)\u001e8di&|g.\r\t\u0003}\u001ai\u0011\u0001A\u0001\u0013O\u0016$x+\u00197mKR\fE\r\u001a:fgN,7/\u0006\u0002\u0002\u0004A1\u0011QAA\u0005\u0003\u001bi!!a\u0002\u000b\u0005}A\u0012\u0002BA\u0006\u0003\u000f\u00111\u0001\u0016:z!\u0019\ty!a\u0006\u0002\u001e9!\u0011\u0011CA\n!\t1\u0005$C\u0002\u0002\u0016a\ta\u0001\u0015:fI\u00164\u0017\u0002BA\r\u00037\u00111aU3u\u0015\r\t)\u0002\u0007\t\u0005\u0003?\t)#\u0004\u0002\u0002\")\u0019\u00111\u0005\t\u0002\u0007\u00154X.\u0003\u0003\u0002(\u0005\u0005\"aB!eIJ,7o]\u0001\u0019O\u0016$X\t\u001e5fe\u0016,X\u000eT8hg\u001a\u0013x.\u001c\"m_\u000e\\GCBA\u0017\u0003+\n\u0019\u0007\u0005\u0004\u0002\u0006\u0005%\u0011q\u0006\t\u0007\u0003c\tY$!\u0011\u000f\t\u0005M\u0012q\u0007\b\u0004\r\u0006U\u0012\"A\r\n\u0007\u0005e\u0002$A\u0004qC\u000e\\\u0017mZ3\n\t\u0005u\u0012q\b\u0002\u0004'\u0016\f(bAA\u001d1A!\u00111IA)\u001b\t\t)E\u0003\u0003\u0002H\u0005%\u0013!\u0002;za\u0016\u001c(\u0002BA&\u0003\u001b\n1A\u001d9d\u0015\r\tyED\u0001\u0004CBL\u0017\u0002BA*\u0003\u000b\u0012q\"\u0012;iKJ,W/\u001c'pOZKWm\u001e\u0005\b\u0003/J\u0001\u0019AA-\u0003\u0015\u0011Gn\\2l!\u0011\tY&a\u0018\u000e\u0005\u0005u#bAA,\u001d%!\u0011\u0011MA/\u00051\t5mY8v]R\u0014En\\2l\u0011\u001d\t)'\u0003a\u0001\u0003O\nac];cg\u000e\u0014\u0018\u000e\u001d;j_:<\u0016\u000e\u001e5GS2$XM\u001d\t\u0005\u0003S\ny'\u0004\u0002\u0002l)\u0019\u0011Q\u000e\u0007\u0002\t\u0011\fG/Y\u0005\u0005\u0003c\nYG\u0001\fTk\n\u001c8M]5qi&|gnV5uQ\u001aKG\u000e^3s\u0003m\t7mY8v]R\u0014En\\2l)><VMY:pG.,GOS:p]R!\u0011qOA@!\u0019\t)!!\u0003\u0002zA!\u0011\u0011NA>\u0013\u0011\ti(a\u001b\u00035]+'mU8dW\u0016$X\t\u001e5fe\u0016,XN\u00117pG.4\u0016.Z<\t\u000f\u0005]#\u00021\u0001\u0002Z\u0001")
public class WebSocketAccountChannelImpl
implements SparkzLogging,
ClosableResourceHandler {
    private final Timeout duration;
    private final ExecutionContext ec;
    private final Logger logger;

    @Override
    public <A extends AutoCloseable, B> B using(A resource, Function1<A, B> fun) {
        return (B)ClosableResourceHandler.using$(this, resource, fun);
    }

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public Timeout duration() {
        return this.duration;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    private <R> R applyOnAccountView(Function1<NodeViewHolder.CurrentView<AccountHistory, AccountState, AccountWallet, AccountMemoryPool>, R> functionToBeApplied) {
        Object value;
        ActorRef x$3;
        Timeout x$2;
        NodeViewHolder.ReceivableMessages$.GetDataFromCurrentView x$1;
        ActorRef qual$1 = akka.pattern.package$.MODULE$.ask(WebSocketAccountServerRef$.MODULE$.sidechainNodeViewHolderRef());
        Future res = AskableActorRef$.MODULE$.ask$extension1(qual$1, (Object)(x$1 = new NodeViewHolder.ReceivableMessages$.GetDataFromCurrentView((Function1 & Serializable & scala.Serializable)nodeview -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> functionToBeApplied.apply(nodeview)))), x$2 = this.duration(), x$3 = AskableActorRef$.MODULE$.ask$default$3$extension(qual$1, (Object)x$1));
        Try try_ = (Try)Await$.MODULE$.result((Awaitable)res, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(5000)).millis());
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("Failed to apply function on account view ");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                throw exception;
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        Object object = value = success.value();
        return (R)object;
    }

    public Try<Set<Address>> getWalletAddresses() {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Set)this.applyOnAccountView((Function1 & Serializable & scala.Serializable)nodeView -> (Set)((SetLike)((AbstractWallet)nodeView.vault()).publicKeys().filter((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)WebSocketAccountChannelImpl.$anonfun$getWalletAddresses$3(key)))).map((Function1 & Serializable & scala.Serializable)addressProposition -> ((AddressProposition)addressProposition).address(), Set$.MODULE$.canBuildFrom())));
    }

    public Try<Seq<EthereumLogView>> getEthereumLogsFromBlock(AccountBlock block, SubscriptionWithFilter subscriptionWithFilter) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Seq)this.applyOnAccountView((Function1 & Serializable & scala.Serializable)nodeView -> (Seq)this.using(((AccountState)nodeView.state()).getView(), (Function1 & Serializable & scala.Serializable)stateView -> RpcFilter$.MODULE$.getBlockLogs((AccountStateView)stateView, block, subscriptionWithFilter.filter()))));
    }

    public Try<WebSocketEthereumBlockView> accountBlockToWebsocketJson(AccountBlock block) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (WebSocketEthereumBlockView)this.applyOnAccountView((Function1 & Serializable & scala.Serializable)nodeView -> {
            long blockNumber = Predef$.MODULE$.Integer2int(((AbstractHistory)nodeView.history()).getBlockHeightById(block.id()).get());
            Hash blockHash = new Hash(package.ModifierIdOps$.MODULE$.toBytes$extension(sparkz.util.package$.MODULE$.ModifierIdOps(block.id())));
            return new WebSocketEthereumBlockView(EthereumBlockView.withoutTransactions(Predef$.MODULE$.long2Long(blockNumber), blockHash, block));
        }));
    }

    public static final /* synthetic */ boolean $anonfun$getWalletAddresses$3(Proposition key) {
        return key instanceof AddressProposition;
    }

    public WebSocketAccountChannelImpl() {
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
        ClosableResourceHandler.$init$(this);
        this.duration = Timeout$.MODULE$.durationToTimeout(new package.DurationInt(package$.MODULE$.DurationInt(20)).seconds());
        this.ec = ExecutionContext.Implicits$.MODULE$.global();
    }
}

