/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.utils;

import io.horizen.account.utils.RlpStreamDecoder;
import java.util.Arrays;
import java.util.List;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;
import sparkz.util.serialization.Writer;

public class RlpStreamEncoder {
    public static void encode(RlpType value, Writer writer) {
        if (value instanceof RlpString) {
            RlpStreamEncoder.encodeString((RlpString)value, writer);
        } else {
            RlpStreamEncoder.encodeList((RlpList)value, writer);
        }
    }

    static void encodeString(RlpString value, Writer writer) {
        byte[] bytesValue = value.getBytes();
        if (bytesValue.length == 1 && bytesValue[0] >= 0) {
            writer.putBytes(bytesValue);
        } else if (bytesValue.length <= 55) {
            writer.putUByte(RlpStreamDecoder.OFFSET_SHORT_STRING + bytesValue.length);
            writer.putBytes(bytesValue);
        } else {
            byte[] encodedStringLength = RlpStreamEncoder.toMinimalByteArray(bytesValue.length);
            writer.putUByte(RlpStreamDecoder.OFFSET_SHORT_STRING + 55 + encodedStringLength.length);
            writer.putBytes(encodedStringLength);
            writer.putBytes(bytesValue);
        }
    }

    static void encodeList(RlpList value, Writer writer) {
        List values = value.getValues();
        if (values.isEmpty()) {
            writer.putUByte(RlpStreamDecoder.OFFSET_SHORT_LIST);
        } else {
            Writer helperWriter = writer.newWriter();
            for (RlpType entry : values) {
                RlpStreamEncoder.encode(entry, helperWriter);
            }
            RlpStreamEncoder.encodeNestedList(helperWriter, writer);
        }
    }

    private static void encodeNestedList(Writer inWriter, Writer outWriter) {
        int bytesLength = inWriter.length();
        if (bytesLength <= 55) {
            outWriter.putUByte(RlpStreamDecoder.OFFSET_SHORT_LIST + bytesLength);
            outWriter.append(inWriter);
        } else {
            byte[] encodedStringLength = RlpStreamEncoder.toMinimalByteArray(bytesLength);
            outWriter.putUByte(RlpStreamDecoder.OFFSET_SHORT_LIST + 55 + encodedStringLength.length);
            outWriter.putBytes(encodedStringLength);
            outWriter.append(inWriter);
        }
    }

    private static byte[] toMinimalByteArray(int value) {
        byte[] encoded = RlpStreamEncoder.toByteArray(value);
        for (int i = 0; i < encoded.length; ++i) {
            if (encoded[i] == 0) continue;
            return Arrays.copyOfRange(encoded, i, encoded.length);
        }
        return new byte[0];
    }

    private static byte[] toByteArray(int value) {
        return new byte[]{(byte)(value >> 24 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
    }
}

