/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.state;

import io.horizen.account.state.GasPool;
import io.horizen.account.state.GasUtil$;
import io.horizen.account.state.MessageProcessor;
import io.horizen.account.state.OutOfGasException;
import io.horizen.account.state.StateDbAccountStateView;
import io.horizen.account.state.receipt.EthereumConsensusDataLog;
import io.horizen.evm.Address;
import io.horizen.evm.Hash;
import io.horizen.evm.StateDB;
import java.math.BigInteger;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005md\u0001\u0002\f\u0018\u0001\u0001B\u0001\"\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\tY\u0001\u0011\t\u0011)A\u0005[!Aa\b\u0001B\u0001B\u0003%q\b\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003E\u0011\u00159\u0005\u0001\"\u0001I\u0011\u0015q\u0005\u0001\"\u0003P\u0011\u0015\u0001\u0007\u0001\"\u0003b\u0011\u0015a\u0007\u0001\"\u0003n\u0011\u00159\b\u0001\"\u0011y\u0011\u0015Q\b\u0001\"\u0011|\u0011\u0015q\b\u0001\"\u0011\u0000\u0011\u001d\t)\u0001\u0001C!\u0003\u000fAq!!\u0004\u0001\t\u0003\ny\u0001C\u0004\u0002\u0016\u0001!\t%a\u0006\t\u000f\u0005-\u0002\u0001\"\u0011\u0002.!9\u0011\u0011\u0007\u0001\u0005B\u0005M\u0002bBA\u001d\u0001\u0011\u0005\u00131\b\u0005\b\u0003\u000b\u0002A\u0011IA$\u0011\u001d\ty\u0005\u0001C!\u0003#Bq!!\u0017\u0001\t\u0003\nY\u0006C\u0004\u0002f\u0001!\t%a\u001a\u0003CM#\u0018\r^3EE\u0006\u001b7m\\;oiN#\u0018\r^3WS\u0016<x)Y:Ue\u0006\u001c7.\u001a3\u000b\u0005aI\u0012!B:uCR,'B\u0001\u000e\u001c\u0003\u001d\t7mY8v]RT!\u0001H\u000f\u0002\u000f!|'/\u001b>f]*\ta$\u0001\u0002j_\u000e\u00011C\u0001\u0001\"!\t\u00113%D\u0001\u0018\u0013\t!sCA\fTi\u0006$X\r\u00122BG\u000e|WO\u001c;Ti\u0006$XMV5fo\u000691\u000f^1uK\u0012\u0013\u0007CA\u0014+\u001b\u0005A#BA\u0015\u001c\u0003\r)g/\\\u0005\u0003W!\u0012qa\u0015;bi\u0016$%)A\tnKN\u001c\u0018mZ3Qe>\u001cWm]:peN\u00042A\f\u001d<\u001d\tySG\u0004\u00021g5\t\u0011G\u0003\u00023?\u00051AH]8pizJ\u0011\u0001N\u0001\u0006g\u000e\fG.Y\u0005\u0003m]\nq\u0001]1dW\u0006<WMC\u00015\u0013\tI$HA\u0002TKFT!AN\u001c\u0011\u0005\tb\u0014BA\u001f\u0018\u0005AiUm]:bO\u0016\u0004&o\\2fgN|'/\u0001\u0005sK\u0006$wJ\u001c7z!\t\u0001\u0015)D\u00018\u0013\t\u0011uGA\u0004C_>dW-\u00198\u0002\u0007\u001d\f7\u000f\u0005\u0002#\u000b&\u0011ai\u0006\u0002\b\u000f\u0006\u001c\bk\\8m\u0003\u0019a\u0014N\\5u}Q)\u0011JS&M\u001bB\u0011!\u0005\u0001\u0005\u0006K\u0015\u0001\rA\n\u0005\u0006Y\u0015\u0001\r!\f\u0005\u0006}\u0015\u0001\ra\u0010\u0005\u0006\u0007\u0016\u0001\r\u0001R\u0001\u000eC\u000e\u001cw.\u001e8u\u0003\u000e\u001cWm]:\u0015\u0005A\u001b\u0006C\u0001!R\u0013\t\u0011vG\u0001\u0003V]&$\b\"\u0002+\u0007\u0001\u0004)\u0016aB1eIJ,7o\u001d\t\u0003OYK!a\u0016\u0015\u0003\u000f\u0005#GM]3tg\"\u001aa!W0\u0011\u0007\u0001SF,\u0003\u0002\\o\t1A\u000f\u001b:poN\u0004\"AI/\n\u0005y;\"!E(vi>3w)Y:Fq\u000e,\u0007\u000f^5p]\u000e\nA,A\u0007ti>\u0014\u0018mZ3BG\u000e,7o\u001d\u000b\u0004!\n\u001c\u0007\"\u0002+\b\u0001\u0004)\u0006\"\u00023\b\u0001\u0004)\u0017\u0001B:m_R\u00042\u0001\u00114i\u0013\t9wGA\u0003BeJ\f\u0017\u0010\u0005\u0002AS&\u0011!n\u000e\u0002\u0005\u0005f$X\rK\u0002\b3~\u000b!c\u001d;pe\u0006<Wm\u0016:ji\u0016\f5mY3tgR!\u0001K\\8u\u0011\u0015!\u0006\u00021\u0001V\u0011\u0015\u0001\b\u00021\u0001r\u0003\rYW-\u001f\t\u0003OIL!a\u001d\u0015\u0003\t!\u000b7\u000f\u001b\u0005\u0006k\"\u0001\r!]\u0001\u0006m\u0006dW/\u001a\u0015\u0004\u0011e{\u0016!D1dG>,h\u000e^#ySN$8\u000f\u0006\u0002@s\")A+\u0003a\u0001+\u0006a\u0011n]#pC\u0006\u001b7m\\;oiR\u0011q\b \u0005\u0006)*\u0001\r!\u0016\u0015\u0004\u0015e{\u0016AF5t'6\f'\u000f^\"p]R\u0014\u0018m\u0019;BG\u000e|WO\u001c;\u0015\u0007}\n\t\u0001C\u0003U\u0017\u0001\u0007Q\u000bK\u0002\f3~\u000b1bZ3u\u0007>$W\rS1tQR\u0019Q-!\u0003\t\u000bQc\u0001\u0019A+)\u00071Iv,A\u0004hKR\u001cu\u000eZ3\u0015\u0007\u0015\f\t\u0002C\u0003U\u001b\u0001\u0007Q\u000bK\u0002\u000e3~\u000b\u0001bZ3u\u001d>t7-\u001a\u000b\u0005\u00033\tI\u0003\u0005\u0003\u0002\u001c\u0005\u0015RBAA\u000f\u0015\u0011\ty\"!\t\u0002\t5\fG\u000f\u001b\u0006\u0003\u0003G\tAA[1wC&!\u0011qEA\u000f\u0005)\u0011\u0015nZ%oi\u0016<WM\u001d\u0005\u0006):\u0001\r!V\u0001\u000eS:\u001c'/Z1tK:{gnY3\u0015\u0007A\u000by\u0003C\u0003U\u001f\u0001\u0007Q+\u0001\u0006hKR\u0014\u0015\r\\1oG\u0016$B!!\u0007\u00026!)A\u000b\u0005a\u0001+\"\u001a\u0001#W0\u0002\u0015\u0005$GMQ1mC:\u001cW\rF\u0003Q\u0003{\ty\u0004C\u0003U#\u0001\u0007Q\u000bC\u0004\u0002BE\u0001\r!!\u0007\u0002\r\u0005lw.\u001e8uQ\r\t\u0012lX\u0001\u000bgV\u0014')\u00197b]\u000e,G#\u0002)\u0002J\u0005-\u0003\"\u0002+\u0013\u0001\u0004)\u0006bBA!%\u0001\u0007\u0011\u0011\u0004\u0015\u0004%e{\u0016!E4fi\u0006\u001b7m\\;oiN#xN]1hKR)Q-a\u0015\u0002V!)Ak\u0005a\u0001+\")\u0001o\u0005a\u0001K\"\u001a1#W0\u0002)U\u0004H-\u0019;f\u0003\u000e\u001cw.\u001e8u'R|'/Y4f)\u001d\u0001\u0016QLA0\u0003CBQ\u0001\u0016\u000bA\u0002UCQ\u0001\u001d\u000bA\u0002\u0015DQ!\u001e\u000bA\u0002\u0015D3\u0001F-`\u0003\u0019\tG\r\u001a'pOR\u0019\u0001+!\u001b\t\u000f\u0005-T\u00031\u0001\u0002n\u0005\u0019An\\4\u0011\t\u0005=\u0014QO\u0007\u0003\u0003cR1!a\u001d\u0018\u0003\u001d\u0011XmY3jaRLA!a\u001e\u0002r\tAR\t\u001e5fe\u0016,XnQ8og\u0016t7/^:ECR\fGj\\4)\u0007UIv\f")
public class StateDbAccountStateViewGasTracked
extends StateDbAccountStateView {
    private final StateDB stateDb;
    private final GasPool gas;

    private void accountAccess(Address address) throws OutOfGasException {
        boolean warm = this.stateDb.accessAccount(address);
        this.gas.subGas(warm ? GasUtil$.MODULE$.WarmStorageReadCostEIP2929() : GasUtil$.MODULE$.ColdAccountAccessCostEIP2929());
    }

    private void storageAccess(Address address, byte[] slot) throws OutOfGasException {
        boolean warm = this.stateDb.accessSlot(address, new Hash(slot));
        this.gas.subGas(warm ? GasUtil$.MODULE$.WarmStorageReadCostEIP2929() : GasUtil$.MODULE$.ColdSloadCostEIP2929());
    }

    private void storageWriteAccess(Address address, Hash key, Hash value) throws OutOfGasException {
        BigInteger bigInteger;
        Hash current;
        if (this.gas.getGas().compareTo(GasUtil$.MODULE$.SstoreSentryGasEIP2200()) <= 0) {
            throw new OutOfGasException("account storage write gas sentry fail");
        }
        if (!this.stateDb.accessSlot(address, key)) {
            this.gas.subGas(GasUtil$.MODULE$.ColdSloadCostEIP2929());
        }
        if (value.equals((Object)(current = this.stateDb.getStorage(address, key)))) {
            bigInteger = GasUtil$.MODULE$.WarmStorageReadCostEIP2929();
        } else {
            Hash original = this.stateDb.getCommittedStorage(address, key);
            if (original.equals((Object)current)) {
                if (original.equals((Object)Hash.ZERO)) {
                    bigInteger = GasUtil$.MODULE$.SstoreSetGasEIP2200();
                } else {
                    if (value.equals((Object)Hash.ZERO)) {
                        this.stateDb.addRefund(GasUtil$.MODULE$.SstoreClearsScheduleRefundEIP3529());
                    }
                    bigInteger = GasUtil$.MODULE$.SstoreResetGasEIP2200().subtract(GasUtil$.MODULE$.ColdSloadCostEIP2929());
                }
            } else {
                if (!original.equals((Object)Hash.ZERO)) {
                    if (current.equals((Object)Hash.ZERO)) {
                        this.stateDb.subRefund(GasUtil$.MODULE$.SstoreClearsScheduleRefundEIP3529());
                    } else if (value.equals((Object)Hash.ZERO)) {
                        this.stateDb.addRefund(GasUtil$.MODULE$.SstoreClearsScheduleRefundEIP3529());
                    }
                }
                if (original.equals((Object)value)) {
                    if (original.equals((Object)Hash.ZERO)) {
                        this.stateDb.addRefund(GasUtil$.MODULE$.SstoreSetGasEIP2200().subtract(GasUtil$.MODULE$.WarmStorageReadCostEIP2929()));
                    } else {
                        this.stateDb.addRefund(GasUtil$.MODULE$.SstoreResetGasEIP2200().subtract(GasUtil$.MODULE$.ColdSloadCostEIP2929()).subtract(GasUtil$.MODULE$.WarmStorageReadCostEIP2929()));
                    }
                }
                bigInteger = GasUtil$.MODULE$.WarmStorageReadCostEIP2929();
            }
        }
        BigInteger writeGasCost = bigInteger;
        this.gas.subGas(writeGasCost);
    }

    @Override
    public boolean accountExists(Address address) {
        this.accountAccess(address);
        return super.accountExists(address);
    }

    @Override
    public boolean isEoaAccount(Address address) throws OutOfGasException {
        this.accountAccess(address);
        return super.isEoaAccount(address);
    }

    @Override
    public boolean isSmartContractAccount(Address address) throws OutOfGasException {
        this.accountAccess(address);
        return super.isSmartContractAccount(address);
    }

    @Override
    public byte[] getCodeHash(Address address) throws OutOfGasException {
        this.accountAccess(address);
        return super.getCodeHash(address);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] getCode(Address address) throws OutOfGasException {
        void var2_2;
        block0: {
            this.accountAccess(address);
            byte[] code = super.getCode(address);
            if (code == null) break block0;
            this.gas.subGas(GasUtil$.MODULE$.codeCopy(code.length));
        }
        return var2_2;
    }

    @Override
    public BigInteger getNonce(Address address) {
        this.accountAccess(address);
        return super.getNonce(address);
    }

    @Override
    public void increaseNonce(Address address) {
        this.accountAccess(address);
        super.increaseNonce(address);
    }

    @Override
    public BigInteger getBalance(Address address) throws OutOfGasException {
        this.accountAccess(address);
        return super.getBalance(address);
    }

    @Override
    public void addBalance(Address address, BigInteger amount) throws OutOfGasException {
        this.accountAccess(address);
        super.addBalance(address, amount);
    }

    @Override
    public void subBalance(Address address, BigInteger amount) throws OutOfGasException {
        this.accountAccess(address);
        super.subBalance(address, amount);
    }

    @Override
    public byte[] getAccountStorage(Address address, byte[] key) throws OutOfGasException {
        this.storageAccess(address, key);
        return super.getAccountStorage(address, key);
    }

    @Override
    public void updateAccountStorage(Address address, byte[] key, byte[] value) throws OutOfGasException {
        this.storageWriteAccess(address, new Hash(key), new Hash(value));
        super.updateAccountStorage(address, key, value);
    }

    @Override
    public void addLog(EthereumConsensusDataLog log) throws OutOfGasException {
        this.gas.subGas(GasUtil$.MODULE$.logGas(log));
        super.addLog(log);
    }

    public StateDbAccountStateViewGasTracked(StateDB stateDb, Seq<MessageProcessor> messageProcessors, boolean readOnly, GasPool gas) {
        this.stateDb = stateDb;
        this.gas = gas;
        super(stateDb, messageProcessors, readOnly);
    }
}

