/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.state;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.account.proposition.AddressProposition;
import io.horizen.account.state.AccountForgingStakeInfo;
import io.horizen.account.state.AccountStateReader;
import io.horizen.account.state.AddNewStakeCmdInput;
import io.horizen.account.state.BaseAccountStateView;
import io.horizen.account.state.BlockContext;
import io.horizen.account.state.CertificateKeysProvider;
import io.horizen.account.state.ExecutionFailedException;
import io.horizen.account.state.ForgerPublicKeys;
import io.horizen.account.state.ForgerStakeData;
import io.horizen.account.state.ForgerStakesProvider;
import io.horizen.account.state.GasPool;
import io.horizen.account.state.InvalidMessageException;
import io.horizen.account.state.McAddrOwnershipData;
import io.horizen.account.state.McAddrOwnershipsProvider;
import io.horizen.account.state.Message;
import io.horizen.account.state.MessageProcessor;
import io.horizen.account.state.NativeSmartContractMsgProcessor;
import io.horizen.account.state.OwnerScAddress;
import io.horizen.account.state.StateDbAccountStateView$;
import io.horizen.account.state.StateDbAccountStateViewGasTracked;
import io.horizen.account.state.StateTransition;
import io.horizen.account.state.WithdrawalRequest;
import io.horizen.account.state.WithdrawalRequestProvider;
import io.horizen.account.state.WriteProtectionException;
import io.horizen.account.state.receipt.EthereumConsensusDataLog;
import io.horizen.account.state.receipt.EthereumConsensusDataReceipt;
import io.horizen.account.state.receipt.EthereumConsensusDataReceipt$ReceiptStatus$;
import io.horizen.account.transaction.AccountTransaction;
import io.horizen.account.transaction.EthereumTransaction;
import io.horizen.account.utils.BigIntegerUtil$;
import io.horizen.account.utils.MainchainTxCrosschainOutputAddressUtil$;
import io.horizen.account.utils.ZenWeiConverter$;
import io.horizen.block.MainchainBlockReferenceData;
import io.horizen.block.MainchainTxForwardTransferCrosschainOutput;
import io.horizen.block.MainchainTxSidechainCreationCrosschainOutput;
import io.horizen.certificatesubmitter.keys.CertifiersKeys;
import io.horizen.certificatesubmitter.keys.KeyRotationProof;
import io.horizen.certificatesubmitter.keys.KeyRotationProofTypes$;
import io.horizen.consensus.ForgingStakeInfo;
import io.horizen.evm.Address;
import io.horizen.evm.Hash;
import io.horizen.evm.ResourceHandle;
import io.horizen.evm.StateDB;
import io.horizen.evm.results.EvmLog;
import io.horizen.evm.results.ProofAccountResult;
import io.horizen.proof.Proof;
import io.horizen.proposition.Proposition;
import io.horizen.proposition.PublicKey25519Proposition;
import io.horizen.proposition.VrfPublicKey;
import io.horizen.transaction.mainchain.ForwardTransfer;
import io.horizen.transaction.mainchain.SidechainCreation;
import io.horizen.transaction.mainchain.SidechainRelatedMainchainOutput;
import io.horizen.utils.BytesUtils;
import java.io.Serializable;
import java.math.BigInteger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqView;
import scala.collection.SeqView$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Numeric;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.Try;
import scala.util.Try$;
import sparkz.crypto.hash.Keccak256$;
import sparkz.util.SparkzLogging;

@ScalaSignature(bytes="\u0006\u0001\r]h\u0001B\"E\u00015C\u0001\u0002\u001b\u0001\u0003\u0002\u0003\u0006I!\u001b\u0005\t_\u0002\u0011\t\u0011)A\u0005a\"Iq\u0010\u0001BA\u0002\u0013\u0005\u0011\u0011\u0001\u0005\u000b\u0003\u0013\u0001!\u00111A\u0005\u0002\u0005-\u0001BCA\f\u0001\t\u0005\t\u0015)\u0003\u0002\u0004!9\u0011\u0011\u0004\u0001\u0005\u0002\u0005m\u0001BCA\u0013\u0001!\u0015\r\u0011\"\u0001\u0002(!Q\u0011q\u0006\u0001\t\u0006\u0004%\t!!\r\t\u0015\u0005e\u0002\u0001#b\u0001\n\u0003\tY\u0004\u0003\u0006\u0002D\u0001A)\u0019!C\u0001\u0003\u000bB!\"!\u0014\u0001\u0011\u000b\u0007I\u0011AA(\u0011\u001d\ti\u0006\u0001C!\u0003?Bq!!#\u0001\t\u0003\nY\tC\u0004\u0002\u0018\u0002!\t%!'\t\u000f\u0005\u0015\u0006\u0001\"\u0011\u0002(\"9\u0011Q\u0019\u0001\u0005B\u0005\u0005\u0001bBAd\u0001\u0011\u0005\u0013\u0011\u001a\u0005\b\u0003'\u0004A\u0011IAk\u0011\u001d\tI\u000e\u0001C!\u00037Dq!a;\u0001\t\u0003\ni\u000fC\u0004\u0002x\u0002!\t%!?\t\u000f\t\u001d\u0001\u0001\"\u0001\u0003\n!I!q\u0004\u0001\u0012\u0002\u0013\u0005!\u0011\u0005\u0005\b\u0005o\u0001A\u0011\u0001B\u001d\u0011\u001d\u0011I\u0005\u0001C\u0001\u0005\u0017BqAa\"\u0001\t\u0003\u0011I\tC\u0004\u0003R\u0002!\tEa5\t\u000f\te\u0007\u0001\"\u0011\u0003\\\"9!q\u001c\u0001\u0005B\t\u0005\bb\u0002Bs\u0001\u0011\u0005#q\u001d\u0005\b\u0005_\u0004A\u0011\tBy\u0011\u001d\u0011)\u0010\u0001C!\u0005oDqa!\u0004\u0001\t\u0003\u001ay\u0001C\u0004\u0004\u0018\u0001!\te!\u0007\t\u000f\r\u0005\u0002\u0001\"\u0011\u0004$!91Q\u0006\u0001\u0005F\r=\u0002\"CB\u001b\u0001\t\u0007I\u0011BB\u001c\u0011!\u0019I\u0004\u0001Q\u0001\n\u0005}\bbBB\u001e\u0001\u0011%1Q\b\u0005\b\u0007\u000b\u0002AQIB$\u0011\u001d\u0019i\u0005\u0001C#\u0007\u001fBqaa\u0016\u0001\t\u000b\u001aI\u0006C\u0004\u0004`\u0001!\ta!\u0019\t\u000f\rU\u0004\u0001\"\u0011\u0004x!911\u0010\u0001\u0005B\ru\u0004bBBA\u0001\u0011\u000531\u0011\u0005\b\u0007\u000f\u0003A\u0011IBE\u0011\u001d\u0019i\t\u0001C!\u0007\u001fCqa!(\u0001\t\u0003\u001ay\nC\u0004\u0004&\u0002!\tea*\t\u000f\r%\u0006\u0001\"\u0011\u0004,\"911\u0017\u0001\u0005B\r]\u0002bBB[\u0001\u0011\u00051q\u0017\u0005\b\u0007\u000b\u0004A\u0011ABd\u0011\u001d\u0019Y\r\u0001C\u0001\u0007\u001bDqaa4\u0001\t\u0003\u0019\t\u000eC\u0004\u0004T\u0002!\taa*\t\u000f\rU\u0007\u0001\"\u0001\u0004X\"91Q\u001c\u0001\u0005B\r}\u0007bBBs\u0001\u0011\u00051q\u0015\u0005\b\u0007O\u0004A\u0011ABT\u0011\u001d\u0019I\u000f\u0001C!\u0007W<\u0011b!<E\u0003\u0003E\taa<\u0007\u0011\r#\u0015\u0011!E\u0001\u0007cDq!!\u0007A\t\u0003\u0019\u0019\u0010C\u0005\u0004v\u0002\u000b\n\u0011\"\u0001\u0003\"\t92\u000b^1uK\u0012\u0013\u0017iY2pk:$8\u000b^1uKZKWm\u001e\u0006\u0003\u000b\u001a\u000bQa\u001d;bi\u0016T!a\u0012%\u0002\u000f\u0005\u001c7m\\;oi*\u0011\u0011JS\u0001\bQ>\u0014\u0018N_3o\u0015\u0005Y\u0015AA5p\u0007\u0001\u0019R\u0001\u0001(U1\u0002\u0004\"a\u0014*\u000e\u0003AS\u0011!U\u0001\u0006g\u000e\fG.Y\u0005\u0003'B\u0013a!\u00118z%\u00164\u0007CA+W\u001b\u0005!\u0015BA,E\u0005Q\u0011\u0015m]3BG\u000e|WO\u001c;Ti\u0006$XMV5foB\u0011\u0011LX\u0007\u00025*\u00111\fX\u0001\u0005Y\u0006twMC\u0001^\u0003\u0011Q\u0017M^1\n\u0005}S&!D!vi>\u001cEn\\:fC\ndW\r\u0005\u0002bM6\t!M\u0003\u0002dI\u0006!Q\u000f^5m\u0015\u0005)\u0017AB:qCJ\\'0\u0003\u0002hE\ni1\u000b]1sWjdunZ4j]\u001e\fqa\u001d;bi\u0016$%\r\u0005\u0002k[6\t1N\u0003\u0002m\u0011\u0006\u0019QM^7\n\u00059\\'aB*uCR,GIQ\u0001\u0012[\u0016\u001c8/Y4f!J|7-Z:t_J\u001c\bcA9zy:\u0011!o\u001e\b\u0003gZl\u0011\u0001\u001e\u0006\u0003k2\u000ba\u0001\u0010:p_Rt\u0014\"A)\n\u0005a\u0004\u0016a\u00029bG.\fw-Z\u0005\u0003un\u00141aU3r\u0015\tA\b\u000b\u0005\u0002V{&\u0011a\u0010\u0012\u0002\u0011\u001b\u0016\u001c8/Y4f!J|7-Z:t_J\f\u0001B]3bI>sG._\u000b\u0003\u0003\u0007\u00012aTA\u0003\u0013\r\t9\u0001\u0015\u0002\b\u0005>|G.Z1o\u00031\u0011X-\u00193P]2Lx\fJ3r)\u0011\ti!a\u0005\u0011\u0007=\u000by!C\u0002\u0002\u0012A\u0013A!\u00168ji\"I\u0011Q\u0003\u0003\u0002\u0002\u0003\u0007\u00111A\u0001\u0004q\u0012\n\u0014!\u0003:fC\u0012|e\u000e\\=!\u0003\u0019a\u0014N\\5u}QA\u0011QDA\u0010\u0003C\t\u0019\u0003\u0005\u0002V\u0001!)\u0001N\u0002a\u0001S\")qN\u0002a\u0001a\"AqP\u0002I\u0001\u0002\u0004\t\u0019!A\u000bxSRDGM]1xC2\u0014V-\u001d)s_ZLG-\u001a:\u0016\u0005\u0005%\u0002cA+\u0002,%\u0019\u0011Q\u0006#\u00033]KG\u000f\u001b3sC^\fGNU3rk\u0016\u001cH\u000f\u0015:pm&$WM]\u0001\u0015M>\u0014x-\u001a:Ti\u0006\\Wm\u001d)s_ZLG-\u001a:\u0016\u0005\u0005M\u0002cA+\u00026%\u0019\u0011q\u0007#\u0003)\u0019{'oZ3s'R\f7.Z:Qe>4\u0018\u000eZ3s\u0003]\u0019WM\u001d;jM&\u001c\u0017\r^3LKf\u001c\bK]8wS\u0012,'/\u0006\u0002\u0002>A\u0019Q+a\u0010\n\u0007\u0005\u0005CIA\fDKJ$\u0018NZ5dCR,7*Z=t!J|g/\u001b3fe\u00069RnY!eIJ|uO\\3sg\"L\u0007\u000f\u0015:pm&$WM]\u000b\u0003\u0003\u000f\u00022!VA%\u0013\r\tY\u0005\u0012\u0002\u0019\u001b\u000e\fE\r\u001a:Po:,'o\u001d5jaN\u0004&o\u001c<jI\u0016\u0014\u0018A\t7jgR|eMT1uSZ,7+\\1si\u000e{g\u000e\u001e:bGR\fE\r\u001a:fgN,7/\u0006\u0002\u0002RA)q*a\u0015\u0002X%\u0019\u0011Q\u000b)\u0003\u000b\u0005\u0013(/Y=\u0011\u0007)\fI&C\u0002\u0002\\-\u0014q!\u00113ee\u0016\u001c8/\u0001\tlKf\u0014v\u000e^1uS>t\u0007K]8pMRA\u0011\u0011MA<\u0003\u0003\u000b)\tE\u0003P\u0003G\n9'C\u0002\u0002fA\u0013aa\u00149uS>t\u0007\u0003BA5\u0003gj!!a\u001b\u000b\t\u00055\u0014qN\u0001\u0005W\u0016L8OC\u0002\u0002r!\u000bAcY3si&4\u0017nY1uKN,(-\\5ui\u0016\u0014\u0018\u0002BA;\u0003W\u0012\u0001cS3z%>$\u0018\r^5p]B\u0013xn\u001c4\t\u000f\u0005eD\u00021\u0001\u0002|\u0005yq/\u001b;iIJ\fw/\u00197Fa>\u001c\u0007\u000eE\u0002P\u0003{J1!a Q\u0005\rIe\u000e\u001e\u0005\b\u0003\u0007c\u0001\u0019AA>\u00035Ig\u000eZ3y\u001f\u001a\u001c\u0016n\u001a8fe\"9\u0011q\u0011\u0007A\u0002\u0005m\u0014aB6fsRK\b/Z\u0001\u000fG\u0016\u0014H/\u001b4jKJ\u001c8*Z=t)\u0011\ti)!&\u0011\u000b=\u000b\u0019'a$\u0011\t\u0005%\u0014\u0011S\u0005\u0005\u0003'\u000bYG\u0001\bDKJ$\u0018NZ5feN\\U-_:\t\u000f\u0005eT\u00021\u0001\u0002|\u0005)r-\u001a;XSRDGM]1xC2\u0014V-];fgR\u001cH\u0003BAN\u0003G\u0003B!]=\u0002\u001eB\u0019Q+a(\n\u0007\u0005\u0005FIA\tXSRDGM]1xC2\u0014V-];fgRDq!!\u001f\u000f\u0001\u0004\tY(\u0001\nhKR4uN]4feN#\u0018m[3ECR\fG\u0003BAU\u0003c\u0003RaTA2\u0003W\u00032!VAW\u0013\r\ty\u000b\u0012\u0002\u0010\r>\u0014x-\u001a:Ti\u0006\\W\rR1uC\"9\u00111W\bA\u0002\u0005U\u0016aB:uC.,\u0017\n\u001a\t\u0005\u0003o\u000byL\u0004\u0003\u0002:\u0006m\u0006CA:Q\u0013\r\ti\fU\u0001\u0007!J,G-\u001a4\n\t\u0005\u0005\u00171\u0019\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005u\u0006+A\u0007jg\u001a{'oZ5oO>\u0003XM\\\u0001\u0017O\u0016$H*[:u\u001f\u001a4uN]4feN\u001cF/Y6fgV\u0011\u00111\u001a\t\u0005cf\fi\rE\u0002V\u0003\u001fL1!!5E\u0005]\t5mY8v]R4uN]4j]\u001e\u001cF/Y6f\u0013:4w.\u0001\u000bhKR\fE\u000e\\8xK\u00124uN]4fe2K7\u000f^\u000b\u0003\u0003/\u0004B!]=\u0002|\u0005Ir-\u001a;MSN$xJZ'd\u0003\u0012$'oT<oKJ\u001c\b.\u001b9t)\u0011\ti.!:\u0011\tEL\u0018q\u001c\t\u0004+\u0006\u0005\u0018bAAr\t\n\u0019RjY!eIJ|uO\\3sg\"L\u0007\u000fR1uC\"I\u0011q]\n\u0011\u0002\u0003\u0007\u0011\u0011^\u0001\rg\u000e\fE\r\u001a:fgN|\u0005\u000f\u001e\t\u0006\u001f\u0006\r\u0014QW\u0001\u001aO\u0016$H*[:u\u001f\u001a|uO\\3s'\u000e\fE\r\u001a:fgN,7\u000f\u0006\u0002\u0002pB!\u0011/_Ay!\r)\u00161_\u0005\u0004\u0003k$%AD(x]\u0016\u00148kY!eIJ,7o]\u0001\u0013_^tWM]:iSB$\u0015\r^1Fq&\u001cH\u000f\u0006\u0003\u0002\u0004\u0005m\bbBA\u007f+\u0001\u0007\u0011q`\u0001\f_^tWM]:iSBLE\rE\u0003P\u0003'\u0012\t\u0001E\u0002P\u0005\u0007I1A!\u0002Q\u0005\u0011\u0011\u0015\u0010^3\u0002A\u0005\u0004\b\u000f\\=NC&t7\r[1j]\ncwnY6SK\u001a,'/\u001a8dK\u0012\u000bG/\u0019\u000b\u0007\u0003\u001b\u0011YAa\u0007\t\u000f\t5a\u00031\u0001\u0003\u0010\u00059!/\u001a4ECR\f\u0007\u0003\u0002B\t\u0005/i!Aa\u0005\u000b\u0007\tU\u0001*A\u0003cY>\u001c7.\u0003\u0003\u0003\u001a\tM!aG'bS:\u001c\u0007.Y5o\u00052|7m\u001b*fM\u0016\u0014XM\\2f\t\u0006$\u0018\rC\u0005\u0003\u001eY\u0001\n\u00111\u0001\u0002\u0004\u0005Yb\r\u001e+p'6\f'\u000f^\"p]R\u0014\u0018m\u0019;G_J\\\u0017i\u0019;jm\u0016\f!&\u00199qYfl\u0015-\u001b8dQ\u0006LgN\u00117pG.\u0014VMZ3sK:\u001cW\rR1uC\u0012\"WMZ1vYR$#'\u0006\u0002\u0003$)\"\u00111\u0001B\u0013W\t\u00119\u0003\u0005\u0003\u0003*\tMRB\u0001B\u0016\u0015\u0011\u0011iCa\f\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u0019!\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tU\"1\u0006\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AH4fi>\u0013H-\u001a:fI\u001a{'oZ5oON#\u0018m[3t\u0013:4wnU3r+\t\u0011Y\u0004\u0005\u0003rs\nu\u0002\u0003\u0002B \u0005\u000bj!A!\u0011\u000b\u0007\t\r\u0003*A\u0005d_:\u001cXM\\:vg&!!q\tB!\u0005A1uN]4j]\u001e\u001cF/Y6f\u0013:4w.\u0001\u0007baBd\u00170T3tg\u0006<W\r\u0006\u0005\u0002\u0000\n5#q\u000bB1\u0011\u001d\u0011y%\u0007a\u0001\u0005#\n1!\\:h!\r)&1K\u0005\u0004\u0005+\"%aB'fgN\fw-\u001a\u0005\b\u00053J\u0002\u0019\u0001B.\u00031\u0011Gn\\2l\u000f\u0006\u001c\bk\\8m!\r)&QL\u0005\u0004\u0005?\"%aB$bgB{w\u000e\u001c\u0005\b\u0005GJ\u0002\u0019\u0001B3\u00031\u0011Gn\\2l\u0007>tG/\u001a=u!\r)&qM\u0005\u0004\u0005S\"%\u0001\u0004\"m_\u000e\\7i\u001c8uKb$\b&B\r\u0003n\te\u0004#B(\u0003p\tM\u0014b\u0001B9!\n1A\u000f\u001b:poN\u00042!\u0016B;\u0013\r\u00119\b\u0012\u0002\u0019\u000bb,7-\u001e;j_:4\u0015-\u001b7fI\u0016C8-\u001a9uS>t7E\u0001B:Q\u0015I\"Q\u0010BC!\u0015y%q\u000eB@!\r)&\u0011Q\u0005\u0004\u0005\u0007#%aF%om\u0006d\u0017\u000eZ'fgN\fw-Z#yG\u0016\u0004H/[8oG\t\u0011y(\u0001\tbaBd\u0017\u0010\u0016:b]N\f7\r^5p]RQ!1\u0012BQ\u0005\u0013\u0014iMa4\u0011\r\t5%\u0011\u0013BK\u001b\t\u0011yI\u0003\u0002d!&!!1\u0013BH\u0005\r!&/\u001f\t\u0005\u0005/\u0013i*\u0004\u0002\u0003\u001a*\u0019!1\u0014#\u0002\u000fI,7-Z5qi&!!q\u0014BM\u0005q)E\u000f[3sKVl7i\u001c8tK:\u001cXo\u001d#bi\u0006\u0014VmY3jaRDqAa)\u001b\u0001\u0004\u0011)+\u0001\u0002uqBA!q\u0015BW\u0005c\u0013i,\u0004\u0002\u0003**\u0019!1\u0016$\u0002\u0017Q\u0014\u0018M\\:bGRLwN\\\u0005\u0005\u0005_\u0013IK\u0001\nBG\u000e|WO\u001c;Ue\u0006t7/Y2uS>t\u0007\u0003\u0002BZ\u0005sk!A!.\u000b\u0007\t]\u0006*A\u0006qe>\u0004xn]5uS>t\u0017\u0002\u0002B^\u0005k\u00131\u0002\u0015:pa>\u001c\u0018\u000e^5p]B1!q\u0018Bc\u0005ck!A!1\u000b\u0007\t\r\u0007*A\u0003qe>|g-\u0003\u0003\u0003H\n\u0005'!\u0002)s_>4\u0007b\u0002Bf5\u0001\u0007\u00111P\u0001\bibLe\u000eZ3y\u0011\u001d\u0011IF\u0007a\u0001\u00057BqAa\u0019\u001b\u0001\u0004\u0011)'\u0001\u0007jg\u0016{\u0017-Q2d_VtG\u000f\u0006\u0003\u0002\u0004\tU\u0007b\u0002Bl7\u0001\u0007\u0011qK\u0001\bC\u0012$'/Z:t\u0003YI7oU7beR\u001cuN\u001c;sC\u000e$\u0018iY2pk:$H\u0003BA\u0002\u0005;DqAa6\u001d\u0001\u0004\t9&A\u0007bG\u000e|WO\u001c;Fq&\u001cHo\u001d\u000b\u0005\u0003\u0007\u0011\u0019\u000fC\u0004\u0003Xv\u0001\r!a\u0016\u0002\u0015\u0005$G-Q2d_VtG\u000f\u0006\u0004\u0002\u000e\t%(1\u001e\u0005\b\u0005/t\u0002\u0019AA,\u0011\u001d\u0011iO\ba\u0001\u0003\u007f\fAaY8eK\u0006i\u0011N\\2sK\u0006\u001cXMT8oG\u0016$B!!\u0004\u0003t\"9!q[\u0010A\u0002\u0005]\u0013AC1eI\n\u000bG.\u00198dKR1\u0011Q\u0002B}\u0005wDqAa6!\u0001\u0004\t9\u0006C\u0004\u0003~\u0002\u0002\rAa@\u0002\r\u0005lw.\u001e8u!\u0011\u0019\taa\u0002\u000e\u0005\r\r!bAB\u00039\u0006!Q.\u0019;i\u0013\u0011\u0019Iaa\u0001\u0003\u0015\tKw-\u00138uK\u001e,'\u000fK\u0003!\u0005[\u0012I(\u0001\u0006tk\n\u0014\u0015\r\\1oG\u0016$b!!\u0004\u0004\u0012\rM\u0001b\u0002BlC\u0001\u0007\u0011q\u000b\u0005\b\u0005{\f\u0003\u0019\u0001B\u0000Q\u0015\t#Q\u000eB=\u0003E9W\r^!dG>,h\u000e^*u_J\fw-\u001a\u000b\u0007\u0003\u007f\u001cYb!\b\t\u000f\t]'\u00051\u0001\u0002X!91q\u0004\u0012A\u0002\u0005}\u0018aA6fs\u0006!R\u000f\u001d3bi\u0016\f5mY8v]R\u001cFo\u001c:bO\u0016$\u0002\"!\u0004\u0004&\r\u001d2\u0011\u0006\u0005\b\u0005/\u001c\u0003\u0019AA,\u0011\u001d\u0019yb\ta\u0001\u0003\u007fDqaa\u000b$\u0001\u0004\ty0A\u0003wC2,X-\u0001\u000bsK6|g/Z!dG>,h\u000e^*u_J\fw-\u001a\u000b\u0007\u0003\u001b\u0019\tda\r\t\u000f\t]G\u00051\u0001\u0002X!91q\u0004\u0013A\u0002\u0005}\u0018\u0001D2ik:\\7*Z=TC2$XCAA\u0000\u00035\u0019\u0007.\u001e8l\u0017\u0016L8+\u00197uA\u0005Yq-\u001a;DQVt7nS3z)\u0019\typa\u0010\u0004B!91qD\u0014A\u0002\u0005}\bbBB\"O\u0001\u0007\u00111P\u0001\u000bG\",hn[%oI\u0016D\u0018AF4fi\u0006\u001b7m\\;oiN#xN]1hK\nKH/Z:\u0015\r\u0005}8\u0011JB&\u0011\u001d\u00119\u000e\u000ba\u0001\u0003/Bqaa\b)\u0001\u0004\ty0A\rva\u0012\fG/Z!dG>,h\u000e^*u_J\fw-\u001a\"zi\u0016\u001cH\u0003CA\u0007\u0007#\u001a\u0019f!\u0016\t\u000f\t]\u0017\u00061\u0001\u0002X!91qD\u0015A\u0002\u0005}\bbBB\u0016S\u0001\u0007\u0011q`\u0001\u001ae\u0016lwN^3BG\u000e|WO\u001c;Ti>\u0014\u0018mZ3CsR,7\u000f\u0006\u0004\u0002\u000e\rm3Q\f\u0005\b\u0005/T\u0003\u0019AA,\u0011\u001d\u0019yB\u000ba\u0001\u0003\u007f\f\u0001bZ3u!J|wN\u001a\u000b\u0007\u0007G\u001ayg!\u001d\u0011\t\r\u001541N\u0007\u0003\u0007OR1a!\u001bl\u0003\u001d\u0011Xm];miNLAa!\u001c\u0004h\t\u0011\u0002K]8pM\u0006\u001b7m\\;oiJ+7/\u001e7u\u0011\u001d\u00119n\u000ba\u0001\u0003/Bq!!\u001c,\u0001\u0004\u0019\u0019\bE\u0003P\u0003'\ny0\u0001\u0005hKRtuN\\2f)\u0011\u0011yp!\u001f\t\u000f\t]G\u00061\u0001\u0002X\u0005Qq-\u001a;CC2\fgnY3\u0015\t\t}8q\u0010\u0005\b\u0005/l\u0003\u0019AA,\u0003-9W\r^\"pI\u0016D\u0015m\u001d5\u0015\t\u0005}8Q\u0011\u0005\b\u0005/t\u0003\u0019AA,\u0003\u001d9W\r^\"pI\u0016$B!a@\u0004\f\"9!q[\u0018A\u0002\u0005]\u0013aB4fi2{wm\u001d\u000b\u0005\u0007#\u001bI\nE\u0003P\u0003'\u001a\u0019\n\u0005\u0003\u0003\u0018\u000eU\u0015\u0002BBL\u00053\u0013\u0001$\u0012;iKJ,W/\\\"p]N,gn];t\t\u0006$\u0018\rT8h\u0011\u001d\u0019Y\n\ra\u0001\u0003\u007f\fa\u0001\u001e=ICND\u0017AB1eI2{w\r\u0006\u0003\u0002\u000e\r\u0005\u0006bBBRc\u0001\u000711S\u0001\u0004Y><\u0017!B2m_N,GCAA\u0007\u0003A9W\r^*uCR,GI\u0019%b]\u0012dW-\u0006\u0002\u0004.B\u0019!na,\n\u0007\rE6N\u0001\bSKN|WO]2f\u0011\u0006tG\r\\3\u0002'\u001d,G/\u00138uKJlW\rZ5bi\u0016\u0014vn\u001c;\u0002\u001dM,G/\u001e9Uq\u000e{g\u000e^3yiR1\u0011QBB]\u0007wCqaa'6\u0001\u0004\ty\u0010C\u0004\u0004>V\u0002\raa0\u0002\u0007%$\u0007\u0010E\u0002Z\u0007\u0003L1aa1[\u0005\u001dIe\u000e^3hKJ\fqb]3ukB\f5mY3tg2K7\u000f\u001e\u000b\u0005\u0003\u001b\u0019I\rC\u0004\u0003PY\u0002\rA!\u0015\u0002\u0013\u001d,GOU3gk:$WC\u0001B\u0000\u0003!\u0019h.\u00199tQ>$XCAA>\u0003=1\u0017N\\1mSj,7\t[1oO\u0016\u001c\u0018\u0001\u0005:fm\u0016\u0014H\u000fV8T]\u0006\u00048\u000f[8u)\u0011\tia!7\t\u000f\rm'\b1\u0001\u0002|\u0005Q!/\u001a<jg&|g.\u00133\u0002#\u001d,GoR1t)J\f7m[3e-&,w\u000fF\u0002U\u0007CDqaa9<\u0001\u0004\u0011Y&A\u0002hCN\fQ#\u001a8bE2,wK]5uKB\u0013x\u000e^3di&|g.\u0001\feSN\f'\r\\3Xe&$X\r\u0015:pi\u0016\u001cG/[8o\u0003\u0005:W\r\u001e(bi&4XmU7beR\u001cuN\u001c;sC\u000e$\u0018\t\u001a3sKN\u001cH*[:u)\t\t\t&A\fTi\u0006$X\r\u00122BG\u000e|WO\u001c;Ti\u0006$XMV5foB\u0011Q\u000bQ\n\u0003\u0001:#\"aa<\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0001")
public class StateDbAccountStateView
implements BaseAccountStateView,
AutoCloseable,
SparkzLogging {
    private WithdrawalRequestProvider withdrawalReqProvider;
    private ForgerStakesProvider forgerStakesProvider;
    private CertificateKeysProvider certificateKeysProvider;
    private McAddrOwnershipsProvider mcAddrOwnershipProvider;
    private Address[] listOfNativeSmartContractAddresses;
    private final StateDB stateDb;
    private final Seq<MessageProcessor> messageProcessors;
    private boolean readOnly;
    private final byte[] chunkKeySalt;
    private final Logger logger;
    private volatile byte bitmap$0;

    public static boolean $lessinit$greater$default$3() {
        return StateDbAccountStateView$.MODULE$.$lessinit$greater$default$3();
    }

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    @Override
    public Option<String> getListOfMcAddrOwnerships$default$1() {
        return AccountStateReader.getListOfMcAddrOwnerships$default$1$(this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public boolean readOnly() {
        return this.readOnly;
    }

    public void readOnly_$eq(boolean x$1) {
        this.readOnly = x$1;
    }

    private WithdrawalRequestProvider withdrawalReqProvider$lzycompute() {
        StateDbAccountStateView stateDbAccountStateView = this;
        synchronized (stateDbAccountStateView) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.withdrawalReqProvider = (WithdrawalRequestProvider)this.messageProcessors.find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StateDbAccountStateView.$anonfun$withdrawalReqProvider$1(x$1))).get();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.withdrawalReqProvider;
    }

    public WithdrawalRequestProvider withdrawalReqProvider() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.withdrawalReqProvider$lzycompute() : this.withdrawalReqProvider;
    }

    private ForgerStakesProvider forgerStakesProvider$lzycompute() {
        StateDbAccountStateView stateDbAccountStateView = this;
        synchronized (stateDbAccountStateView) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.forgerStakesProvider = (ForgerStakesProvider)this.messageProcessors.find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StateDbAccountStateView.$anonfun$forgerStakesProvider$1(x$2))).get();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.forgerStakesProvider;
    }

    public ForgerStakesProvider forgerStakesProvider() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.forgerStakesProvider$lzycompute() : this.forgerStakesProvider;
    }

    private CertificateKeysProvider certificateKeysProvider$lzycompute() {
        StateDbAccountStateView stateDbAccountStateView = this;
        synchronized (stateDbAccountStateView) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.certificateKeysProvider = (CertificateKeysProvider)this.messageProcessors.find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)StateDbAccountStateView.$anonfun$certificateKeysProvider$1(x$3))).get();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.certificateKeysProvider;
    }

    public CertificateKeysProvider certificateKeysProvider() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.certificateKeysProvider$lzycompute() : this.certificateKeysProvider;
    }

    private McAddrOwnershipsProvider mcAddrOwnershipProvider$lzycompute() {
        StateDbAccountStateView stateDbAccountStateView = this;
        synchronized (stateDbAccountStateView) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.mcAddrOwnershipProvider = (McAddrOwnershipsProvider)this.messageProcessors.find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)StateDbAccountStateView.$anonfun$mcAddrOwnershipProvider$1(x$4))).get();
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.mcAddrOwnershipProvider;
    }

    public McAddrOwnershipsProvider mcAddrOwnershipProvider() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.mcAddrOwnershipProvider$lzycompute() : this.mcAddrOwnershipProvider;
    }

    private Address[] listOfNativeSmartContractAddresses$lzycompute() {
        StateDbAccountStateView stateDbAccountStateView = this;
        synchronized (stateDbAccountStateView) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.listOfNativeSmartContractAddresses = (Address[])((TraversableOnce)this.messageProcessors.collect((PartialFunction)new scala.Serializable(null){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends MessageProcessor, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (A1 instanceof NativeSmartContractMsgProcessor) {
                            NativeSmartContractMsgProcessor nativeSmartContractMsgProcessor = (NativeSmartContractMsgProcessor)A1;
                            object = nativeSmartContractMsgProcessor.contractAddress();
                        } else {
                            object = function1.apply(x1);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(MessageProcessor x1) {
                        MessageProcessor messageProcessor = x1;
                        boolean bl = messageProcessor instanceof NativeSmartContractMsgProcessor;
                        return bl;
                    }
                }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Address.class));
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.listOfNativeSmartContractAddresses;
    }

    public Address[] listOfNativeSmartContractAddresses() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.listOfNativeSmartContractAddresses$lzycompute() : this.listOfNativeSmartContractAddresses;
    }

    @Override
    public Option<KeyRotationProof> keyRotationProof(int withdrawalEpoch, int indexOfSigner, int keyType) {
        return this.certificateKeysProvider().getKeyRotationProof(withdrawalEpoch, indexOfSigner, KeyRotationProofTypes$.MODULE$.apply(keyType), this);
    }

    @Override
    public Option<CertifiersKeys> certifiersKeys(int withdrawalEpoch) {
        return new Some((Object)this.certificateKeysProvider().getCertifiersKeys(withdrawalEpoch, this));
    }

    @Override
    public Seq<WithdrawalRequest> getWithdrawalRequests(int withdrawalEpoch) {
        return this.withdrawalReqProvider().getListOfWithdrawalReqRecords(withdrawalEpoch, this);
    }

    @Override
    public Option<ForgerStakeData> getForgerStakeData(String stakeId) {
        return this.forgerStakesProvider().findStakeData(this, BytesUtils.fromHexString(stakeId));
    }

    @Override
    public boolean isForgingOpen() {
        return this.forgerStakesProvider().isForgerListOpen(this);
    }

    @Override
    public Seq<AccountForgingStakeInfo> getListOfForgersStakes() {
        return this.forgerStakesProvider().getListOfForgersStakes(this);
    }

    @Override
    public Seq<Object> getAllowedForgerList() {
        return this.forgerStakesProvider().getAllowedForgerListIndexes(this);
    }

    @Override
    public Seq<McAddrOwnershipData> getListOfMcAddrOwnerships(Option<String> scAddressOpt) {
        return this.mcAddrOwnershipProvider().getListOfMcAddrOwnerships(this, scAddressOpt);
    }

    @Override
    public Seq<OwnerScAddress> getListOfOwnerScAddresses() {
        return this.mcAddrOwnershipProvider().getListOfOwnerScAddresses(this);
    }

    @Override
    public boolean ownershipDataExist(byte[] ownershipId) {
        return this.mcAddrOwnershipProvider().ownershipDataExist(this, ownershipId);
    }

    public void applyMainchainBlockReferenceData(MainchainBlockReferenceData refData, boolean ftToSmartContractForkActive) {
        refData.sidechainRelatedAggregatedTransaction().foreach((Function1 & Serializable & scala.Serializable)aggTx -> (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(aggTx.mc2scTransactionsOutputs()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            StateDbAccountStateView.$anonfun$applyMainchainBlockReferenceData$2(this, ftToSmartContractForkActive, x0$1);
            return BoxedUnit.UNIT;
        }, Buffer$.MODULE$.canBuildFrom()));
    }

    public boolean applyMainchainBlockReferenceData$default$2() {
        return false;
    }

    public Seq<ForgingStakeInfo> getOrderedForgingStakesInfoSeq() {
        return (Seq)((TraversableOnce)this.getListOfForgersStakes().view().groupBy((Function1 & Serializable & scala.Serializable)stake -> new Tuple2((Object)stake.forgerStakeData().forgerPublicKeys().blockSignPublicKey(), (Object)stake.forgerStakeData().forgerPublicKeys().vrfPublicKey())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SeqView stakes;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = x0$1;
                    if (tuple22 == null) break block2;
                    tuple2 = (Tuple2)tuple22._1();
                    stakes = (SeqView)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            PublicKey25519Proposition blockSignKey = (PublicKey25519Proposition)tuple2._1();
            VrfPublicKey vrfKey = (VrfPublicKey)tuple2._2();
            ForgingStakeInfo forgingStakeInfo = new ForgingStakeInfo(blockSignKey, vrfKey, BoxesRunTime.unboxToLong((Object)((TraversableOnce)stakes.map((Function1 & Serializable & scala.Serializable)stake -> BoxesRunTime.boxToLong((long)ZenWeiConverter$.MODULE$.convertWeiToZennies(stake.forgerStakeData().stakedAmount())), SeqView$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
            return forgingStakeInfo;
        }, Iterable$.MODULE$.canBuildFrom())).toSeq().sorted(package$.MODULE$.Ordering().apply(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())).reverse());
    }

    public byte[] applyMessage(Message msg, GasPool blockGasPool, BlockContext blockContext) throws InvalidMessageException, ExecutionFailedException {
        return new StateTransition(this, this.messageProcessors, blockGasPool, blockContext, msg).transition();
    }

    public Try<EthereumConsensusDataReceipt> applyTransaction(AccountTransaction<Proposition, Proof<Proposition>> tx, int txIndex, GasPool blockGasPool, BlockContext blockContext) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            Enumeration.Value value;
            BoxedUnit boxedUnit3;
            if (!(tx instanceof EthereumTransaction)) {
                throw new IllegalArgumentException(new StringBuilder(29).append("Unsupported transaction type ").append(tx.getClass().getName()).toString());
            }
            EthereumTransaction ethTx = (EthereumTransaction)tx;
            if (!ethTx.isSigned()) {
                throw new IllegalArgumentException(new StringBuilder(27).append("Transaction is not signed: ").append(ethTx.id()).toString());
            }
            byte[] txHash = BytesUtils.fromHexString(ethTx.id());
            Message msg = ethTx.asMessage(blockContext$1.baseFee);
            this.setupTxContext(txHash, Predef$.MODULE$.int2Integer(txIndex));
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug("applying msg: used pool gas {}", new Object[]{blockGasPool.getUsedGas()});
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            try {
                try {
                    this.applyMessage(msg, blockGasPool, blockContext);
                    value = EthereumConsensusDataReceipt$ReceiptStatus$.MODULE$.SUCCESSFUL();
                }
                catch (ExecutionFailedException err) {
                    BoxedUnit boxedUnit4;
                    if (this.log().underlying().isDebugEnabled()) {
                        this.log().underlying().debug("applying message failed, tx id: {}, reason: {}", (Object[])new String[]{ethTx.id(), err.getMessage()});
                        boxedUnit4 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit4 = BoxedUnit.UNIT;
                    }
                    value = EthereumConsensusDataReceipt$ReceiptStatus$.MODULE$.FAILED();
                }
            }
            finally {
                $this.stateDb.finalizeChanges();
            }
            Enumeration.Value status = value;
            EthereumConsensusDataReceipt consensusDataReceipt = new EthereumConsensusDataReceipt(ethTx.version(), status.id(), blockGasPool.getUsedGas(), (Seq<EthereumConsensusDataLog>)Predef$.MODULE$.wrapRefArray((Object[])this.getLogs(txHash)));
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug("Returning consensus data receipt: {}", new Object[]{consensusDataReceipt.toString()});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug("applied msg: used pool gas {}", new Object[]{blockGasPool.getUsedGas()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return consensusDataReceipt;
        });
    }

    @Override
    public boolean isEoaAccount(Address address) {
        return this.stateDb.isEoaAccount(address);
    }

    @Override
    public boolean isSmartContractAccount(Address address) {
        return this.stateDb.isSmartContractAccount(address);
    }

    @Override
    public boolean accountExists(Address address) {
        return !this.stateDb.isEmpty(address);
    }

    @Override
    public void addAccount(Address address, byte[] code) {
        if (this.readOnly()) {
            throw new WriteProtectionException("invalid account code change");
        }
        this.stateDb.setCode(address, code);
    }

    @Override
    public void increaseNonce(Address address) {
        if (this.readOnly()) {
            throw new WriteProtectionException("invalid nonce change");
        }
        this.stateDb.setNonce(address, this.getNonce(address).add(BigInteger.ONE));
    }

    @Override
    public void addBalance(Address address, BigInteger amount) throws ExecutionFailedException {
        block4: {
            int n = amount.signum();
            switch (n) {
                default: 
            }
            if (n == 0) break block4;
            if (n < 0) {
                throw new ExecutionFailedException("cannot add negative amount to balance");
            }
            if (this.readOnly()) {
                throw new WriteProtectionException("invalid balance change");
            }
            this.stateDb.addBalance(address, amount);
        }
    }

    @Override
    public void subBalance(Address address, BigInteger amount) throws ExecutionFailedException {
        block4: {
            int n = amount.signum();
            switch (n) {
                default: 
            }
            if (n == 0) break block4;
            if (n < 0) {
                throw new ExecutionFailedException("cannot subtract negative amount from balance");
            }
            if (this.readOnly()) {
                throw new WriteProtectionException("invalid balance change");
            }
            this.stateDb.subBalance(address, amount);
        }
    }

    @Override
    public byte[] getAccountStorage(Address address, byte[] key) {
        return this.stateDb.getStorage(address, new Hash(key)).toBytes();
    }

    @Override
    public void updateAccountStorage(Address address, byte[] key, byte[] value) {
        if (this.readOnly()) {
            throw new WriteProtectionException("invalid write access to storage");
        }
        this.stateDb.setStorage(address, new Hash(key), new Hash(value));
    }

    @Override
    public final void removeAccountStorage(Address address, byte[] key) {
        this.updateAccountStorage(address, key, Hash.ZERO.toBytes());
    }

    private byte[] chunkKeySalt() {
        return this.chunkKeySalt;
    }

    private byte[] getChunkKey(byte[] key, int chunkIndex) {
        return Keccak256$.MODULE$.hash((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{this.chunkKeySalt(), key, BigIntegerUtil$.MODULE$.toUint256Bytes(BigInteger.valueOf(chunkIndex))}));
    }

    @Override
    public final byte[] getAccountStorageBytes(Address address, byte[] key) {
        int length = new BigInteger(1, this.getAccountStorage(address, key)).intValueExact();
        byte[] data = new byte[length];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (length + 32 - 1) / 32).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)chunkIndex -> new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(this.getAccountStorage(address, this.getChunkKey(key, chunkIndex)))).copyToArray((Object)data, chunkIndex * 32));
        return data;
    }

    @Override
    public final void updateAccountStorageBytes(Address address, byte[] key, byte[] value) {
        if (this.readOnly()) {
            throw new WriteProtectionException("invalid write access to storage");
        }
        int oldLength = new BigInteger(1, this.getAccountStorage(address, key)).intValueExact();
        int newLength = value.length;
        this.updateAccountStorage(address, key, BigIntegerUtil$.MODULE$.toUint256Bytes(BigInteger.valueOf(newLength)));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), Math.max(newLength, oldLength)).by(32).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)start -> {
            int chunkIndex = start / 32;
            byte[] chunkKey = this.getChunkKey(key, chunkIndex);
            if (start < newLength) {
                this.updateAccountStorage(address, chunkKey, (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(value)).slice(start, start + 32))).padTo(32, (Object)BoxesRunTime.boxToByte((byte)((byte)0)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte())));
            } else {
                this.removeAccountStorage(address, chunkKey);
            }
        });
    }

    @Override
    public final void removeAccountStorageBytes(Address address, byte[] key) {
        this.updateAccountStorageBytes(address, key, (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()));
    }

    public ProofAccountResult getProof(Address address, byte[][] keys) {
        return this.stateDb.getProof(address, (Hash[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])keys)).map((Function1 & Serializable & scala.Serializable)x$5 -> new Hash(x$5), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Hash.class))));
    }

    @Override
    public BigInteger getNonce(Address address) {
        return this.stateDb.getNonce(address);
    }

    @Override
    public BigInteger getBalance(Address address) {
        return this.stateDb.getBalance(address);
    }

    @Override
    public byte[] getCodeHash(Address address) {
        return this.stateDb.getCodeHash(address).toBytes();
    }

    @Override
    public byte[] getCode(Address address) {
        return this.stateDb.getCode(address);
    }

    @Override
    public EthereumConsensusDataLog[] getLogs(byte[] txHash) {
        return (EthereumConsensusDataLog[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.stateDb.getLogs(new Hash(txHash)))).map((Function1 & Serializable & scala.Serializable)log -> new EthereumConsensusDataLog(log.address, log.topics, log.data), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(EthereumConsensusDataLog.class)));
    }

    @Override
    public void addLog(EthereumConsensusDataLog log) {
        this.stateDb.addLog(new EvmLog(log.address(), log.topics(), log.data()));
    }

    @Override
    public void close() {
        this.stateDb.close();
    }

    @Override
    public ResourceHandle getStateDbHandle() {
        return this.stateDb;
    }

    @Override
    public byte[] getIntermediateRoot() {
        return this.stateDb.getIntermediateRoot().toBytes();
    }

    public void setupTxContext(byte[] txHash, Integer idx) {
        this.stateDb.setTxContext(new Hash(txHash), Predef$.MODULE$.Integer2int(idx));
    }

    public void setupAccessList(Message msg) {
        this.stateDb.accessSetup(msg.getFrom(), msg.getTo().orElse(Address.ZERO));
    }

    public BigInteger getRefund() {
        return this.stateDb.getRefund();
    }

    public int snapshot() {
        return this.stateDb.snapshot();
    }

    public void finalizeChanges() {
        this.stateDb.finalizeChanges();
    }

    public void revertToSnapshot(int revisionId) {
        this.stateDb.revertToSnapshot(revisionId);
    }

    @Override
    public BaseAccountStateView getGasTrackedView(GasPool gas) {
        return new StateDbAccountStateViewGasTracked(this.stateDb, this.messageProcessors, this.readOnly(), gas);
    }

    public void enableWriteProtection() {
        this.readOnly_$eq(true);
    }

    public void disableWriteProtection() {
        this.readOnly_$eq(false);
    }

    @Override
    public Address[] getNativeSmartContractAddressList() {
        return this.listOfNativeSmartContractAddresses();
    }

    public static final /* synthetic */ boolean $anonfun$withdrawalReqProvider$1(MessageProcessor x$1) {
        return x$1 instanceof WithdrawalRequestProvider;
    }

    public static final /* synthetic */ boolean $anonfun$forgerStakesProvider$1(MessageProcessor x$2) {
        return x$2 instanceof ForgerStakesProvider;
    }

    public static final /* synthetic */ boolean $anonfun$certificateKeysProvider$1(MessageProcessor x$3) {
        return x$3 instanceof CertificateKeysProvider;
    }

    public static final /* synthetic */ boolean $anonfun$mcAddrOwnershipProvider$1(MessageProcessor x$4) {
        return x$4 instanceof McAddrOwnershipsProvider;
    }

    public static final /* synthetic */ void $anonfun$applyMainchainBlockReferenceData$2(StateDbAccountStateView $this, boolean ftToSmartContractForkActive$1, SidechainRelatedMainchainOutput x0$1) {
        SidechainRelatedMainchainOutput sidechainRelatedMainchainOutput = x0$1;
        if (sidechainRelatedMainchainOutput instanceof SidechainCreation) {
            BoxedUnit boxedUnit;
            SidechainCreation sidechainCreation = (SidechainCreation)sidechainRelatedMainchainOutput;
            MainchainTxSidechainCreationCrosschainOutput scOut = sidechainCreation.getScCrOutput();
            BigInteger stakedAmount = ZenWeiConverter$.MODULE$.convertZenniesToWei(scOut.amount());
            Address ownerAddress = MainchainTxCrosschainOutputAddressUtil$.MODULE$.getAccountAddress(scOut.address());
            VrfPublicKey vrfPublicKey = new VrfPublicKey((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(scOut.customCreationData())).take(VrfPublicKey.KEY_LENGTH));
            PublicKey25519Proposition blockSignerProposition = new PublicKey25519Proposition((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(scOut.customCreationData())).slice(VrfPublicKey.KEY_LENGTH, VrfPublicKey.KEY_LENGTH + PublicKey25519Proposition.KEY_LENGTH));
            AddNewStakeCmdInput cmdInput = new AddNewStakeCmdInput(new ForgerPublicKeys(blockSignerProposition, vrfPublicKey), ownerAddress);
            byte[] returnData = $this.forgerStakesProvider().addScCreationForgerStake($this, ownerAddress, stakedAmount, cmdInput);
            if ($this.log().underlying().isDebugEnabled()) {
                $this.log().underlying().debug("sc creation forging stake added with stakeid: {}", new Object[]{BytesUtils.toHexString(returnData)});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (sidechainRelatedMainchainOutput instanceof ForwardTransfer) {
            BoxedUnit boxedUnit;
            ForwardTransfer forwardTransfer = (ForwardTransfer)sidechainRelatedMainchainOutput;
            MainchainTxForwardTransferCrosschainOutput ftOut = forwardTransfer.getFtOutput();
            BigInteger value = ZenWeiConverter$.MODULE$.convertZenniesToWei(ftOut.amount());
            AddressProposition recipientProposition = new AddressProposition(MainchainTxCrosschainOutputAddressUtil$.MODULE$.getAccountAddress(ftOut.propositionBytes()));
            Address recipientAddress = recipientProposition.address();
            if ($this.isEoaAccount(recipientAddress)) {
                BoxedUnit boxedUnit3;
                if ($this.log().underlying().isDebugEnabled()) {
                    $this.log().underlying().debug("adding FT amount = {} to EOA address={}", new Object[]{value, recipientProposition});
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                $this.addBalance(recipientAddress, value);
            } else if (ftToSmartContractForkActive$1) {
                BoxedUnit boxedUnit4;
                if ($this.log().underlying().isDebugEnabled()) {
                    $this.log().underlying().debug("adding FT amount = {} to Smart Contract address={}", new Object[]{value, recipientProposition});
                    boxedUnit4 = BoxedUnit.UNIT;
                } else {
                    boxedUnit4 = BoxedUnit.UNIT;
                }
                $this.addBalance(recipientAddress, value);
            } else {
                BoxedUnit boxedUnit5;
                Address burnAddress = Address.ZERO;
                if ($this.log().underlying().isWarnEnabled()) {
                    $this.log().underlying().warn("ignored FT, amount={} to address={} (the amount was burned by sending balance to {} address)", new Object[]{value, recipientProposition, burnAddress});
                    boxedUnit5 = BoxedUnit.UNIT;
                } else {
                    boxedUnit5 = BoxedUnit.UNIT;
                }
                $this.addBalance(burnAddress, value);
            }
            if ($this.log().underlying().isDebugEnabled()) {
                $this.log().underlying().debug("added FT amount = {} to address={}", new Object[]{value, recipientProposition});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit6 = boxedUnit;
        } else {
            throw new MatchError((Object)sidechainRelatedMainchainOutput);
        }
    }

    public StateDbAccountStateView(StateDB stateDb, Seq<MessageProcessor> messageProcessors, boolean readOnly) {
        this.stateDb = stateDb;
        this.messageProcessors = messageProcessors;
        this.readOnly = readOnly;
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
        this.chunkKeySalt = BytesUtils.fromHexString("fa09428dd8121ea57327c9f21af74ffad8bfd5e6e39dc3dc6c53241a85ec5b0d");
    }
}

