/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.state;

import io.horizen.account.state.BaseAccountStateView;
import io.horizen.account.state.Invocation;
import io.horizen.account.state.MessageProcessorInitializationException;
import io.horizen.account.state.NativeSmartContractMsgProcessor;
import io.horizen.utils.BytesUtils;
import scala.Predef$;
import scala.collection.GenIterable;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u00053Qa\u0002\u0005\u0002\u0002EAQA\u0006\u0001\u0005\u0002]AQ!\u0007\u0001\u0005BiAQa\u000b\u0001\u0005B1BQa\u000e\u0001\u0005\u0012aBQa\u000f\u0001\u0005\u0002qBQA\u0010\u0001\u0005\u0002}\u00121DT1uSZ,7+\\1si\u000e{g\u000e\u001e:bGR<\u0016\u000e\u001e5G_J\\'BA\u0005\u000b\u0003\u0015\u0019H/\u0019;f\u0015\tYA\"A\u0004bG\u000e|WO\u001c;\u000b\u00055q\u0011a\u00025pe&TXM\u001c\u0006\u0002\u001f\u0005\u0011\u0011n\\\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u0014)5\t\u0001\"\u0003\u0002\u0016\u0011\tyb*\u0019;jm\u0016\u001cV.\u0019:u\u0007>tGO]1di6\u001bx\r\u0015:pG\u0016\u001c8o\u001c:\u0002\rqJg.\u001b;?)\u0005A\u0002CA\n\u0001\u0003\u0011Ig.\u001b;\u0015\u0007m\tc\u0005\u0005\u0002\u001d?5\tQDC\u0001\u001f\u0003\u0015\u00198-\u00197b\u0013\t\u0001SD\u0001\u0003V]&$\b\"\u0002\u0012\u0003\u0001\u0004\u0019\u0013\u0001\u0002<jK^\u0004\"a\u0005\u0013\n\u0005\u0015B!\u0001\u0006\"bg\u0016\f5mY8v]R\u001cF/\u0019;f-&,w\u000fC\u0003(\u0005\u0001\u0007\u0001&\u0001\u000bd_:\u001cXM\\:vg\u0016\u0003xn\u00195Ok6\u0014WM\u001d\t\u00039%J!AK\u000f\u0003\u0007%sG/\u0001\u0006dC:\u0004&o\\2fgN$B!\f\u00196mA\u0011ADL\u0005\u0003_u\u0011qAQ8pY\u0016\fg\u000eC\u00032\u0007\u0001\u0007!'\u0001\u0006j]Z|7-\u0019;j_:\u0004\"aE\u001a\n\u0005QB!AC%om>\u001c\u0017\r^5p]\")!e\u0001a\u0001G!)qe\u0001a\u0001Q\u0005qAm\\*qK\u000eLg-[2J]&$HcA\u000e:u!)!\u0005\u0002a\u0001G!)q\u0005\u0002a\u0001Q\u0005a\u0011n\u001d$pe.\f5\r^5wKR\u0011Q&\u0010\u0005\u0006O\u0015\u0001\r\u0001K\u0001\tS:LG\u000fR8oKR\u0011Q\u0006\u0011\u0005\u0006E\u0019\u0001\ra\t")
public abstract class NativeSmartContractWithFork
extends NativeSmartContractMsgProcessor {
    @Override
    public void init(BaseAccountStateView view, int consensusEpochNumber) {
        BoxedUnit boxedUnit;
        if (this.isForkActive(consensusEpochNumber)) {
            BoxedUnit boxedUnit2;
            if (this.initDone(view)) {
                BoxedUnit boxedUnit3;
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("Message processor already initialized");
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                throw new MessageProcessorInitializationException("Message processor already initialized");
            }
            if (!view.accountExists(this.contractAddress())) {
                if (this.log().underlying().isDebugEnabled()) {
                    this.log().underlying().debug("Creating Message Processor account {}", new Object[]{this.contractAddress()});
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
            } else {
                String msg = new StringBuilder(68).append("Account ").append(this.contractAddress()).append(" already exists!! Overwriting account with contract code ").append(BytesUtils.toHexString(this.contractCode())).append("...").toString();
                if (this.log().underlying().isWarnEnabled()) {
                    this.log().underlying().warn(msg);
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
            }
            view.addAccount(this.contractAddress(), this.contractCode());
            this.doSpecificInit(view, consensusEpochNumber);
        } else if (this.log().underlying().isWarnEnabled()) {
            this.log().underlying().warn("Can not perform initialization, fork is not active");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Override
    public boolean canProcess(Invocation invocation, BaseAccountStateView view, int consensusEpochNumber) {
        boolean bl;
        if (super.canProcess(invocation, view, consensusEpochNumber)) {
            if (this.isForkActive(consensusEpochNumber)) {
                if (!this.initDone(view)) {
                    this.init(view, consensusEpochNumber);
                }
                bl = true;
            } else {
                BoxedUnit boxedUnit;
                if (this.log().underlying().isWarnEnabled()) {
                    this.log().underlying().warn("Can not process invocation, fork is not active: invocation = {}", new Object[]{invocation});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public void doSpecificInit(BaseAccountStateView view, int consensusEpochNumber) {
    }

    public boolean isForkActive(int consensusEpochNumber) {
        return false;
    }

    public boolean initDone(BaseAccountStateView view) {
        return view.accountExists(this.contractAddress()) && new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(this.contractCodeHash())).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(view.getCodeHash(this.contractAddress())));
    }
}

