/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.state;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.account.state.BaseAccountStateView;
import io.horizen.account.state.Invocation;
import io.horizen.account.state.MessageProcessor;
import io.horizen.account.state.MessageProcessorInitializationException;
import io.horizen.account.state.NativeSmartContractMsgProcessor$;
import io.horizen.account.state.events.EthereumEvent;
import io.horizen.account.state.receipt.EthereumConsensusDataLog;
import io.horizen.evm.Address;
import scala.Function1;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import sparkz.crypto.hash.Keccak256$;
import sparkz.util.SparkzLogging;

@ScalaSignature(bytes="\u0006\u0001\u0005%c!\u0002\b\u0010\u0003\u0003A\u0002\"B\u0017\u0001\t\u0003q\u0003b\u0002\u0019\u0001\u0005\u00045\t!\r\u0005\bq\u0001\u0011\rQ\"\u0001:\u0011!\u0019\u0005\u0001#b\u0001\n\u0003I\u0004\"\u0002#\u0001\t\u0003*\u0005bBA\u0001\u0001\u0011\u0005\u00131\u0001\u0005\b\u0003\u0017\u0001A\u0011IA\u0007\u0011\u001d\ti\u0002\u0001C\u0001\u0003?9q!a\u000e\u0010\u0011\u0003\tID\u0002\u0004\u000f\u001f!\u0005\u00111\b\u0005\u0007[)!\t!a\u0011\t\u0011\u0005\u0015#B1A\u0005\u0002eBq!a\u0012\u000bA\u0003%!HA\u0010OCRLg/Z*nCJ$8i\u001c8ue\u0006\u001cG/T:h!J|7-Z:t_JT!\u0001E\t\u0002\u000bM$\u0018\r^3\u000b\u0005I\u0019\u0012aB1dG>,h\u000e\u001e\u0006\u0003)U\tq\u0001[8sSj,gNC\u0001\u0017\u0003\tIwn\u0001\u0001\u0014\t\u0001I\u0012%\n\t\u00035}i\u0011a\u0007\u0006\u00039u\tA\u0001\\1oO*\ta$\u0001\u0003kCZ\f\u0017B\u0001\u0011\u001c\u0005\u0019y%M[3diB\u0011!eI\u0007\u0002\u001f%\u0011Ae\u0004\u0002\u0011\u001b\u0016\u001c8/Y4f!J|7-Z:t_J\u0004\"AJ\u0016\u000e\u0003\u001dR!\u0001K\u0015\u0002\tU$\u0018\u000e\u001c\u0006\u0002U\u000511\u000f]1sWjL!\u0001L\u0014\u0003\u001bM\u0003\u0018M]6{\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\tq\u0006\u0005\u0002#\u0001\u0005y1m\u001c8ue\u0006\u001cG/\u00113ee\u0016\u001c8/F\u00013!\t\u0019d'D\u00015\u0015\t)4#A\u0002fm6L!a\u000e\u001b\u0003\u000f\u0005#GM]3tg\u0006a1m\u001c8ue\u0006\u001cGoQ8eKV\t!\bE\u0002<}\u0001k\u0011\u0001\u0010\u0006\u0002{\u0005)1oY1mC&\u0011q\b\u0010\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003w\u0005K!A\u0011\u001f\u0003\t\tKH/Z\u0001\u0011G>tGO]1di\u000e{G-\u001a%bg\"\fA!\u001b8jiR\u0019a)\u0013(\u0011\u0005m:\u0015B\u0001%=\u0005\u0011)f.\u001b;\t\u000b)+\u0001\u0019A&\u0002\tYLWm\u001e\t\u0003E1K!!T\b\u0003)\t\u000b7/Z!dG>,h\u000e^*uCR,g+[3x\u0011\u0015yU\u00011\u0001Q\u0003Q\u0019wN\\:f]N,8/\u00129pG\"tU/\u001c2feB\u00111(U\u0005\u0003%r\u00121!\u00138uQ\r)AK\u0017\t\u0004wU;\u0016B\u0001,=\u0005\u0019!\bN]8xgB\u0011!\u0005W\u0005\u00033>\u0011q%T3tg\u0006<W\r\u0015:pG\u0016\u001c8o\u001c:J]&$\u0018.\u00197ju\u0006$\u0018n\u001c8Fq\u000e,\u0007\u000f^5p]F\"ad\u00174\u0000!\ta6M\u0004\u0002^CB\u0011a\fP\u0007\u0002?*\u0011\u0001mF\u0001\u0007yI|w\u000e\u001e \n\u0005\td\u0014A\u0002)sK\u0012,g-\u0003\u0002eK\n11\u000b\u001e:j]\u001eT!A\u0019\u001f2\u000b\r:7N\u001f7\u0016\u0005!LW#A.\u0005\u000b)<\"\u0019A8\u0003\u0003QK!\u0001\\7\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0015\tqG(\u0001\u0004uQJ|wo]\t\u0003aN\u0004\"aO9\n\u0005Id$a\u0002(pi\"Lgn\u001a\t\u0003i^t!aO;\n\u0005Yd\u0014a\u00029bG.\fw-Z\u0005\u0003qf\u0014\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0005Yd\u0014'B\u0012|yvtgBA\u001e}\u0013\tqG(\r\u0003#wqr(!B:dC2\f\u0017G\u0001\u0014X\u00035\u0019Wo\u001d;p[R\u0013\u0018mY5oOR\u0011\u0011Q\u0001\t\u0004w\u0005\u001d\u0011bAA\u0005y\t9!i\\8mK\u0006t\u0017AC2b]B\u0013xnY3tgRA\u0011QAA\b\u00033\tY\u0002C\u0004\u0002\u0012\u001d\u0001\r!a\u0005\u0002\u0015%tgo\\2bi&|g\u000eE\u0002#\u0003+I1!a\u0006\u0010\u0005)IeN^8dCRLwN\u001c\u0005\u0006\u0015\u001e\u0001\ra\u0013\u0005\u0006\u001f\u001e\u0001\r\u0001U\u0001\u001cO\u0016$X\t\u001e5fe\u0016,XnQ8og\u0016t7/^:ECR\fGj\\4\u0015\t\u0005\u0005\u0012Q\u0006\t\u0005\u0003G\tI#\u0004\u0002\u0002&)\u0019\u0011qE\b\u0002\u000fI,7-Z5qi&!\u00111FA\u0013\u0005a)E\u000f[3sKVl7i\u001c8tK:\u001cXo\u001d#bi\u0006dun\u001a\u0005\b\u0003_A\u0001\u0019AA\u0019\u0003\u0015)g/\u001a8u!\rY\u00141G\u0005\u0004\u0003ka$aA!os\u0006yb*\u0019;jm\u0016\u001cV.\u0019:u\u0007>tGO]1di6\u001bx\r\u0015:pG\u0016\u001c8o\u001c:\u0011\u0005\tR1c\u0001\u0006\u0002>A\u00191(a\u0010\n\u0007\u0005\u0005CH\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0003s\t!CT+M\u0019~CU\tW0T)JKejR04e\u0005\u0019b*\u0016'M?\"+\u0005lX*U%&suiX\u001a3A\u0001")
public abstract class NativeSmartContractMsgProcessor
implements MessageProcessor,
SparkzLogging {
    private byte[] contractCodeHash;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static byte[] NULL_HEX_STRING_32() {
        return NativeSmartContractMsgProcessor$.MODULE$.NULL_HEX_STRING_32();
    }

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public abstract Address contractAddress();

    public abstract byte[] contractCode();

    private byte[] contractCodeHash$lzycompute() {
        NativeSmartContractMsgProcessor nativeSmartContractMsgProcessor = this;
        synchronized (nativeSmartContractMsgProcessor) {
            if (!this.bitmap$0) {
                this.contractCodeHash = Keccak256$.MODULE$.hash(this.contractCode());
                this.bitmap$0 = true;
            }
        }
        return this.contractCodeHash;
    }

    public byte[] contractCodeHash() {
        return !this.bitmap$0 ? this.contractCodeHash$lzycompute() : this.contractCodeHash;
    }

    @Override
    public void init(BaseAccountStateView view, int consensusEpochNumber) throws MessageProcessorInitializationException {
        if (!view.accountExists(this.contractAddress())) {
            BoxedUnit boxedUnit;
            view.addAccount(this.contractAddress(), this.contractCode());
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug("created Message Processor account {}", new Object[]{this.contractAddress()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            BoxedUnit boxedUnit;
            String errorMsg = new StringBuilder(23).append("Account ").append(this.contractAddress()).append(" already exists").toString();
            if (this.log().underlying().isErrorEnabled()) {
                this.log().underlying().error(errorMsg);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            throw new MessageProcessorInitializationException(errorMsg);
        }
    }

    @Override
    public boolean customTracing() {
        return false;
    }

    @Override
    public boolean canProcess(Invocation invocation, BaseAccountStateView view, int consensusEpochNumber) {
        return invocation.callee().exists((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)NativeSmartContractMsgProcessor.$anonfun$canProcess$1(this, x$1)));
    }

    public EthereumConsensusDataLog getEthereumConsensusDataLog(Object event) {
        return EthereumEvent.getEthereumConsensusDataLog(this.contractAddress(), event);
    }

    public static final /* synthetic */ boolean $anonfun$canProcess$1(NativeSmartContractMsgProcessor $this, Address x$1) {
        return $this.contractAddress().equals((Object)x$1);
    }

    public NativeSmartContractMsgProcessor() {
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
    }
}

