/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.state;

import io.horizen.account.abi.ABIUtil;
import io.horizen.account.fork.Version1_2_0Fork$;
import io.horizen.account.fork.ZenDAOFork$;
import io.horizen.account.proof.SignatureSecp256k1;
import io.horizen.account.state.AddNewMultisigOwnershipCmdInput;
import io.horizen.account.state.AddNewMultisigOwnershipCmdInputDecoder$;
import io.horizen.account.state.AddNewOwnershipCmdInput;
import io.horizen.account.state.AddNewOwnershipCmdInputDecoder$;
import io.horizen.account.state.BaseAccountStateView;
import io.horizen.account.state.ExecutionContext;
import io.horizen.account.state.ExecutionFailedException;
import io.horizen.account.state.ExecutionRevertedException;
import io.horizen.account.state.GetOwnershipsCmdInput;
import io.horizen.account.state.GetOwnershipsCmdInputDecoder$;
import io.horizen.account.state.Invocation;
import io.horizen.account.state.McAddrOwnershipData;
import io.horizen.account.state.McAddrOwnershipDataListEncoder$;
import io.horizen.account.state.McAddrOwnershipDataSerializer$;
import io.horizen.account.state.McAddrOwnershipLinkedList$;
import io.horizen.account.state.McAddrOwnershipMsgProcessor$;
import io.horizen.account.state.McAddrOwnershipsProvider;
import io.horizen.account.state.Message;
import io.horizen.account.state.NativeSmartContractMsgProcessor$;
import io.horizen.account.state.NativeSmartContractWithFork;
import io.horizen.account.state.OutOfGasException;
import io.horizen.account.state.OwnerScAddrListEncoder$;
import io.horizen.account.state.OwnerScAddress;
import io.horizen.account.state.RemoveOwnershipCmdInput;
import io.horizen.account.state.RemoveOwnershipCmdInputDecoder$;
import io.horizen.account.state.ScAddrOwnershipLinkedList;
import io.horizen.account.state.ScAddrOwnershipLinkedList$;
import io.horizen.account.state.ScAddressRefsLinkedList$;
import io.horizen.account.state.events.AddMcAddrOwnership;
import io.horizen.account.state.events.AddMcAddrOwnership$;
import io.horizen.account.state.events.RemoveMcAddrOwnership;
import io.horizen.account.state.events.RemoveMcAddrOwnership$;
import io.horizen.account.state.receipt.EthereumConsensusDataLog;
import io.horizen.account.utils.WellKnownAddresses$;
import io.horizen.evm.Address;
import io.horizen.params.NetworkParams;
import io.horizen.utils.BytesUtils;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.bouncycastle.asn1.x9.X9ECParameters;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import sparkz.crypto.hash.Keccak256$;

@ScalaSignature(bytes="\u0006\u0001\rme\u0001\u0002'N\u0001ZC\u0001b\u001a\u0001\u0003\u0016\u0004%\t\u0001\u001b\u0005\t_\u0002\u0011\t\u0012)A\u0005S\")\u0001\u000f\u0001C\u0001c\"9A\u000f\u0001b\u0001\n\u0003*\bB\u0002?\u0001A\u0003%a\u000fC\u0004~\u0001\t\u0007I\u0011\t@\t\u000f\u0005-\u0001\u0001)A\u0005\u007f\"9\u0011Q\u0002\u0001\u0005R\u0005=\u0001bBA\u0016\u0001\u0011%\u0011Q\u0006\u0005\b\u0003'\u0002A\u0011BA+\u0011\u001d\t\t\u0007\u0001C\u0001\u0003GBq!a\u001f\u0001\t\u0003\ti\bC\u0004\u0002\u0006\u0002!\t!a\"\t\u000f\u0005=\u0005\u0001\"\u0001\u0002\u0012\"9\u0011q\u0013\u0001\u0005\u0002\u0005e\u0005bBAP\u0001\u0011\u0005\u0011\u0011\u0015\u0005\b\u0003O\u0003A\u0011IAU\u0011\u001d\t)\r\u0001C!\u0003\u000fD\u0011\"!8\u0001#\u0003%\t!a8\t\u000f\u0005U\b\u0001\"\u0003\u0002x\"9\u0011Q \u0001\u0005B\u0005}\bb\u0002B\u0006\u0001\u0011%!Q\u0002\u0005\b\u0005'\u0001A\u0011\tB\u000b\u0011\u001d\u0011)\u0004\u0001C\u0001\u0005oAqAa\u000f\u0001\t\u0003\u0012i\u0004C\u0004\u0003B\u0001!\tEa\u0011\t\u0013\t\u001d\u0003!!A\u0005\u0002\t%\u0003\"\u0003B'\u0001E\u0005I\u0011\u0001B(\u0011%\u0011\u0019\u0006AA\u0001\n\u0003\u0012)\u0006C\u0005\u0003f\u0001\t\t\u0011\"\u0001\u0003h!I!\u0011\u000e\u0001\u0002\u0002\u0013\u0005!1\u000e\u0005\n\u0005o\u0002\u0011\u0011!C!\u0005sB\u0011Ba\"\u0001\u0003\u0003%\tA!#\t\u0013\t5\u0005!!A\u0005B\t=\u0005\"\u0003BI\u0001\u0005\u0005I\u0011\tBJ\u0011%\u0011)\nAA\u0001\n\u0003\u00129jB\u0004\u0003\u001c6C\tA!(\u0007\r1k\u0005\u0012\u0001BP\u0011\u0019\u0001h\u0005\"\u0001\u00038\"A!\u0011\u0018\u0014C\u0002\u0013\u0005a\u0010C\u0004\u0003<\u001a\u0002\u000b\u0011B@\t\u0011\tufE1A\u0005\u0002yDqAa0'A\u0003%q\u0010\u0003\u0005\u0003B\u001a\u0012\r\u0011\"\u0001\u007f\u0011\u001d\u0011\u0019M\nQ\u0001\n}D\u0001B!2'\u0005\u0004%\tA \u0005\b\u0005\u000f4\u0003\u0015!\u0003\u0000\u0011%\u0011IM\nb\u0001\n\u0003\u0011Y\r\u0003\u0005\u0003N\u001a\u0002\u000b\u0011BA\u001f\u0011%\u0011yM\nb\u0001\n\u0003\u0011Y\r\u0003\u0005\u0003R\u001a\u0002\u000b\u0011BA\u001f\u0011%\u0011\u0019N\nb\u0001\n\u0003\u0011Y\r\u0003\u0005\u0003V\u001a\u0002\u000b\u0011BA\u001f\u0011%\u00119N\nb\u0001\n\u0003\u0011Y\r\u0003\u0005\u0003Z\u001a\u0002\u000b\u0011BA\u001f\u0011%\u0011YN\nb\u0001\n\u0003\u0011Y\r\u0003\u0005\u0003^\u001a\u0002\u000b\u0011BA\u001f\u0011%\u0011yN\nb\u0001\n\u0003\u0011Y\r\u0003\u0005\u0003b\u001a\u0002\u000b\u0011BA\u001f\u0011%\u0011\u0019O\nb\u0001\n\u0003\u0011)\u000f\u0003\u0005\u0003\u0000\u001a\u0002\u000b\u0011\u0002Bt\u0011\u001d\u0019\tA\nC\u0001\u0007\u0007Aqa!\u0003'\t\u0003\u0019Y\u0001C\u0004\u0004\u001e\u0019\"\taa\b\t\u000f\r5b\u0005\"\u0001\u00040!91Q\u0007\u0014\u0005\u0002\r]\u0002bBB!M\u0011%11\t\u0005\b\u0007\u001f2C\u0011BB)\u0011\u001d\u0019iF\nC\u0001\u0007?Bqa!\u001e'\t\u0003\u00199\b\u0003\u0004\u0004~\u0019\"IA \u0005\n\u0007\u007f2\u0003R1A\u0005\u0002yD\u0011b!!'\u0003\u0003%\tia!\t\u0013\r\u001de%!A\u0005\u0002\u000e%\u0005\"CBIM\u0005\u0005I\u0011BBJ\u0005mi5-\u00113ee>;h.\u001a:tQ&\u0004Xj]4Qe>\u001cWm]:pe*\u0011ajT\u0001\u0006gR\fG/\u001a\u0006\u0003!F\u000bq!Y2d_VtGO\u0003\u0002S'\u00069\u0001n\u001c:ju\u0016t'\"\u0001+\u0002\u0005%|7\u0001A\n\u0006\u0001][f\f\u001a\t\u00031fk\u0011!T\u0005\u000356\u00131DT1uSZ,7+\\1si\u000e{g\u000e\u001e:bGR<\u0016\u000e\u001e5G_J\\\u0007C\u0001-]\u0013\tiVJ\u0001\rNG\u0006#GM](x]\u0016\u00148\u000f[5qgB\u0013xN^5eKJ\u0004\"a\u00182\u000e\u0003\u0001T\u0011!Y\u0001\u0006g\u000e\fG.Y\u0005\u0003G\u0002\u0014q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002`K&\u0011a\r\u0019\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u000e]\u0016$xo\u001c:l!\u0006\u0014\u0018-\\:\u0016\u0003%\u0004\"A[7\u000e\u0003-T!\u0001\\)\u0002\rA\f'/Y7t\u0013\tq7NA\u0007OKR<xN]6QCJ\fWn]\u0001\u000f]\u0016$xo\u001c:l!\u0006\u0014\u0018-\\:!\u0003\u0019a\u0014N\\5u}Q\u0011!o\u001d\t\u00031\u0002AQaZ\u0002A\u0002%\fqbY8oiJ\f7\r^!eIJ,7o]\u000b\u0002mB\u0011qO_\u0007\u0002q*\u0011\u00110U\u0001\u0004KZl\u0017BA>y\u0005\u001d\tE\r\u001a:fgN\f\u0001cY8oiJ\f7\r^!eIJ,7o\u001d\u0011\u0002\u0019\r|g\u000e\u001e:bGR\u001cu\u000eZ3\u0016\u0003}\u0004RaXA\u0001\u0003\u000bI1!a\u0001a\u0005\u0015\t%O]1z!\ry\u0016qA\u0005\u0004\u0003\u0013\u0001'\u0001\u0002\"zi\u0016\fQbY8oiJ\f7\r^\"pI\u0016\u0004\u0013A\u00043p'B,7-\u001b4jG&s\u0017\u000e\u001e\u000b\u0007\u0003#\t9\"!\t\u0011\u0007}\u000b\u0019\"C\u0002\u0002\u0016\u0001\u0014A!\u00168ji\"9\u0011\u0011\u0004\u0005A\u0002\u0005m\u0011\u0001\u0002<jK^\u00042\u0001WA\u000f\u0013\r\ty\"\u0014\u0002\u0015\u0005\u0006\u001cX-Q2d_VtGo\u0015;bi\u00164\u0016.Z<\t\u000f\u0005\r\u0002\u00021\u0001\u0002&\u0005!2m\u001c8tK:\u001cXo]#q_\u000eDg*^7cKJ\u00042aXA\u0014\u0013\r\tI\u0003\u0019\u0002\u0004\u0013:$\u0018AE1eI6\u001b\u0017\t\u001a3s\u001f^tWM]:iSB$\"\"!\u0005\u00020\u0005E\u0012QGA\u001d\u0011\u001d\tI\"\u0003a\u0001\u00037Aa!a\r\n\u0001\u0004y\u0018aC8x]\u0016\u00148\u000f[5q\u0013\u0012Da!a\u000e\n\u0001\u00041\u0018!C:d\u0003\u0012$'/Z:t\u0011\u001d\tY$\u0003a\u0001\u0003{\tA#\\2Ue\u0006t7\u000f]1sK:$\u0018\t\u001a3sKN\u001c\b\u0003BA \u0003\u001brA!!\u0011\u0002JA\u0019\u00111\t1\u000e\u0005\u0005\u0015#bAA$+\u00061AH]8pizJ1!a\u0013a\u0003\u0019\u0001&/\u001a3fM&!\u0011qJA)\u0005\u0019\u0019FO]5oO*\u0019\u00111\n1\u0002=Ut7\r[3dW\u0016$'+Z7pm\u0016l5-\u00113ee>;h.\u001a:tQ&\u0004HCCA\t\u0003/\nI&a\u0017\u0002`!9\u0011\u0011\u0004\u0006A\u0002\u0005m\u0001BBA\u001a\u0015\u0001\u0007q\u0010C\u0004\u0002^)\u0001\r!!\u0010\u0002\u0019M\u001c\u0017\t\u001a3sKN\u001c8\u000b\u001e:\t\u000f\u0005m\"\u00021\u0001\u0002>\u0005!Bm\\!eI:+woT<oKJ\u001c\b.\u001b9D[\u0012$ra`A3\u0003_\n\t\bC\u0004\u0002h-\u0001\r!!\u001b\u0002\u0015%tgo\\2bi&|g\u000eE\u0002Y\u0003WJ1!!\u001cN\u0005)IeN^8dCRLwN\u001c\u0005\b\u00033Y\u0001\u0019AA\u000e\u0011\u001d\t\u0019h\u0003a\u0001\u0003k\n1!\\:h!\rA\u0016qO\u0005\u0004\u0003sj%aB'fgN\fw-Z\u0001\u001dI>\fE\r\u001a(fo6+H\u000e^5tS\u001e|uO\\3sg\"L\u0007oQ7e)\u001dy\u0018qPAA\u0003\u0007Cq!a\u001a\r\u0001\u0004\tI\u0007C\u0004\u0002\u001a1\u0001\r!a\u0007\t\u000f\u0005MD\u00021\u0001\u0002v\u0005!Bm\u001c*f[>4XmT<oKJ\u001c\b.\u001b9D[\u0012$ra`AE\u0003\u0017\u000bi\tC\u0004\u0002h5\u0001\r!!\u001b\t\u000f\u0005eQ\u00021\u0001\u0002\u001c!9\u00111O\u0007A\u0002\u0005U\u0014\u0001\u00073p\u000f\u0016$H*[:u\u001f\u001a|uO\\3sg\"L\u0007o]\"nIR)q0a%\u0002\u0016\"9\u0011q\r\bA\u0002\u0005%\u0004bBA\r\u001d\u0001\u0007\u00111D\u0001\u001cI><U\r\u001e'jgR|e-\u00117m\u001f^tWM]:iSB\u001c8)\u001c3\u0015\u000b}\fY*!(\t\u000f\u0005\u001dt\u00021\u0001\u0002j!9\u0011\u0011D\bA\u0002\u0005m\u0011A\b3p\u000f\u0016$H*[:u\u001f\u001a|uO\\3s'\u000e\fE\r\u001a:fgN,7oQ7e)\u0015y\u00181UAS\u0011\u001d\t9\u0007\u0005a\u0001\u0003SBq!!\u0007\u0011\u0001\u0004\tY\"A\rhKRd\u0015n\u001d;PM>;h.\u001a:TG\u0006#GM]3tg\u0016\u001cH\u0003BAV\u0003\u0007\u0004b!!,\u00028\u0006uf\u0002BAX\u0003gsA!a\u0011\u00022&\t\u0011-C\u0002\u00026\u0002\fq\u0001]1dW\u0006<W-\u0003\u0003\u0002:\u0006m&aA*fc*\u0019\u0011Q\u00171\u0011\u0007a\u000by,C\u0002\u0002B6\u0013abT<oKJ\u001c6-\u00113ee\u0016\u001c8\u000fC\u0004\u0002\u001aE\u0001\r!a\u0007\u00023\u001d,G\u000fT5ti>3WjY!eIJ|uO\\3sg\"L\u0007o\u001d\u000b\u0007\u0003\u0013\f\t.a5\u0011\r\u00055\u0016qWAf!\rA\u0016QZ\u0005\u0004\u0003\u001fl%aE'd\u0003\u0012$'oT<oKJ\u001c\b.\u001b9ECR\f\u0007bBA\r%\u0001\u0007\u00111\u0004\u0005\n\u0003+\u0014\u0002\u0013!a\u0001\u0003/\fAb]2BI\u0012\u0014Xm]:PaR\u0004RaXAm\u0003{I1!a7a\u0005\u0019y\u0005\u000f^5p]\u0006\u0019s-\u001a;MSN$xJZ'd\u0003\u0012$'oT<oKJ\u001c\b.\u001b9tI\u0011,g-Y;mi\u0012\u0012TCAAqU\u0011\t9.a9,\u0005\u0005\u0015\b\u0003BAt\u0003cl!!!;\u000b\t\u0005-\u0018Q^\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a<a\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003g\fIOA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fqdZ3u'\u000e\fE\r\u001a:MSN$xJZ'd\u0003\u0012$'oT<oKJ\u001c\b.\u001b9t)\u0019\tI-!?\u0002|\"9\u0011\u0011\u0004\u000bA\u0002\u0005m\u0001bBA\u001c)\u0001\u0007\u0011QH\u0001\u0013_^tWM]:iSB$\u0015\r^1Fq&\u001cH\u000f\u0006\u0004\u0003\u0002\t\u001d!\u0011\u0002\t\u0004?\n\r\u0011b\u0001B\u0003A\n9!i\\8mK\u0006t\u0007bBA\r+\u0001\u0007\u00111\u0004\u0005\u0007\u0003g)\u0002\u0019A@\u0002-\u001d,G/\u0012=jgRLgnZ!tg>\u001c\u0017.\u0019;j_:$b!a6\u0003\u0010\tE\u0001bBA\r-\u0001\u0007\u00111\u0004\u0005\u0007\u0003g1\u0002\u0019A@\u0002\u000fA\u0014xnY3tgR9qPa\u0006\u0003\u001a\tm\u0001bBA4/\u0001\u0007\u0011\u0011\u000e\u0005\b\u000339\u0002\u0019AA\u000e\u0011\u001d\u0011ib\u0006a\u0001\u0005?\tqaY8oi\u0016DH\u000fE\u0002Y\u0005CI1Aa\tN\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH\u000fK\u0003\u0018\u0005O\u0011\u0019\u0004E\u0003`\u0005S\u0011i#C\u0002\u0003,\u0001\u0014a\u0001\u001e5s_^\u001c\bc\u0001-\u00030%\u0019!\u0011G'\u00031\u0015CXmY;uS>tg)Y5mK\u0012,\u0005pY3qi&|gn\t\u0002\u0003.\u0005!\u0012n]'vYRL7/[4G_J\\\u0017i\u0019;jm\u0016$BA!\u0001\u0003:!9\u00111\u0005\rA\u0002\u0005\u0015\u0012\u0001C5oSR$uN\\3\u0015\t\t\u0005!q\b\u0005\b\u00033I\u0002\u0019AA\u000e\u00031I7OR8sW\u0006\u001bG/\u001b<f)\u0011\u0011\tA!\u0012\t\u000f\u0005\r\"\u00041\u0001\u0002&\u0005!1m\u001c9z)\r\u0011(1\n\u0005\bOn\u0001\n\u00111\u0001j\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"A!\u0015+\u0007%\f\u0019/A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005/\u0002BA!\u0017\u0003d5\u0011!1\f\u0006\u0005\u0005;\u0012y&\u0001\u0003mC:<'B\u0001B1\u0003\u0011Q\u0017M^1\n\t\u0005=#1L\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003K\ta\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0003n\tM\u0004cA0\u0003p%\u0019!\u0011\u000f1\u0003\u0007\u0005s\u0017\u0010C\u0005\u0003v}\t\t\u00111\u0001\u0002&\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa\u001f\u0011\r\tu$1\u0011B7\u001b\t\u0011yHC\u0002\u0003\u0002\u0002\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011)Ia \u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005\u0003\u0011Y\tC\u0005\u0003v\u0005\n\t\u00111\u0001\u0003n\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002&\u0005AAo\\*ue&tw\r\u0006\u0002\u0003X\u00051Q-];bYN$BA!\u0001\u0003\u001a\"I!Q\u000f\u0013\u0002\u0002\u0003\u0007!QN\u0001\u001c\u001b\u000e\fE\r\u001a:Po:,'o\u001d5ja6\u001bx\r\u0015:pG\u0016\u001c8o\u001c:\u0011\u0005a33C\u0002\u0014\u0003\"\n\u001dF\rE\u0002`\u0005GK1A!*a\u0005\u0019\te.\u001f*fMB!!\u0011\u0016BZ\u001b\t\u0011YK\u0003\u0003\u0003.\n=\u0016\u0001B;uS2T!A!-\u0002\rM\u0004\u0018M]6{\u0013\u0011\u0011)La+\u0003\u001bM\u0003\u0018M]6{\u0019><w-\u001b8h)\t\u0011i*\u0001\u000ePo:,'o\u001d5jaNd\u0015N\\6fI2K7\u000f\u001e+ja.+\u00170A\u000ePo:,'o\u001d5jaNd\u0015N\\6fI2K7\u000f\u001e+ja.+\u0017\u0010I\u0001\u001d\u001f^tWM]:iSBd\u0015N\\6fI2K7\u000f\u001e(vY24\u0016\r\\;f\u0003uyuO\\3sg\"L\u0007\u000fT5oW\u0016$G*[:u\u001dVdGNV1mk\u0016\u0004\u0013!H*d\u0003\u0012$'/Z:t%\u001647\u000fT5oW\u0016$G*[:u)&\u00048*Z=\u0002=M\u001b\u0017\t\u001a3sKN\u001c(+\u001a4t\u0019&t7.\u001a3MSN$H+\u001b9LKf\u0004\u0013\u0001I*d\u0003\u0012$'/Z:t%\u001647\u000fT5oW\u0016$G*[:u\u001dVdGNV1mk\u0016\f\u0011eU2BI\u0012\u0014Xm]:SK\u001a\u001cH*\u001b8lK\u0012d\u0015n\u001d;Ok2dg+\u00197vK\u0002\n!$\u00113e\u001d\u0016<X*\u001e7uSNLwmT<oKJ\u001c\b.\u001b9D[\u0012,\"!!\u0010\u00027\u0005#GMT3x\u001bVdG/[:jO>;h.\u001a:tQ&\u00048)\u001c3!\u0003I\tE\r\u001a(fo>;h.\u001a:tQ&\u00048)\u001c3\u0002'\u0005#GMT3x\u001f^tWM]:iSB\u001cU\u000e\u001a\u0011\u0002%I+Wn\u001c<f\u001f^tWM]:iSB\u001cU\u000eZ\u0001\u0014%\u0016lwN^3Po:,'o\u001d5ja\u000ekG\rI\u0001\u001a\u000f\u0016$H*[:u\u001f\u001a\fE\u000e\\(x]\u0016\u00148\u000f[5qg\u000ekG-\u0001\u000eHKRd\u0015n\u001d;PM\u0006cGnT<oKJ\u001c\b.\u001b9t\u00076$\u0007%\u0001\fHKRd\u0015n\u001d;PM>;h.\u001a:tQ&\u00048oQ7e\u0003]9U\r\u001e'jgR|emT<oKJ\u001c\b.\u001b9t\u00076$\u0007%\u0001\u000fHKRd\u0015n\u001d;PM>;h.\u001a:TG\u0006#GM]3tg\u0016\u001c8)\u001c3\u0002;\u001d+G\u000fT5ti>3wj\u001e8feN\u001b\u0017\t\u001a3sKN\u001cXm]\"nI\u0002\nA\"Z2QCJ\fW.\u001a;feN,\"Aa:\u0011\t\t%(1`\u0007\u0003\u0005WTAA!<\u0003p\u0006\u0011\u00010\u000f\u0006\u0005\u0005c\u0014\u00190\u0001\u0003bg:\f$\u0002\u0002B{\u0005o\fABY8v]\u000eL8-Y:uY\u0016T!A!?\u0002\u0007=\u0014x-\u0003\u0003\u0003~\n-(A\u0004-:\u000b\u000e\u0003\u0016M]1nKR,'o]\u0001\u000eK\u000e\u0004\u0016M]1nKR,'o\u001d\u0011\u0002\u001d\u001d,GoT<oKJ\u001c\b.\u001b9JIR\u0019qp!\u0002\t\u000f\r\u001da\b1\u0001\u0002>\u0005IQnY!eIJ,7o]\u0001\u000fO\u0016$XjY*jO:\fG/\u001e:f)\u0011\u0019ia!\u0007\u0011\t\r=1QC\u0007\u0003\u0007#Q1aa\u0005P\u0003\u0015\u0001(o\\8g\u0013\u0011\u00199b!\u0005\u0003%MKwM\\1ukJ,7+Z2qeU24.\r\u0005\b\u00077y\u0004\u0019AA\u001f\u0003Ei7mU5h]\u0006$XO]3TiJLgnZ\u0001\u001fG\",7m['d%\u0016$W-Z7TGJL\u0007\u000f\u001e$pe6+H\u000e^5tS\u001e$Ba!\t\u0004*A9qla\t\u0002&\r\u001d\u0012bAB\u0013A\n1A+\u001e9mKJ\u0002R!!,\u00028~Dqaa\u000bA\u0001\u0004\ti$\u0001\u0007sK\u0012,W-\\*de&\u0004H/\u0001\tdQ\u0016\u001c7.T2BI\u0012\u0014Xm]:fgR)qp!\r\u00044!91qA!A\u0002\u0005u\u0002\"\u00027B\u0001\u0004I\u0017\u0001F2iK\u000e\\W*\u001e7uSNLw-\u00113ee\u0016\u001c8\u000f\u0006\u0005\u0003\u0002\re2QHB \u0011\u001d\u0019YD\u0011a\u0001\u0003{\t\u0011#\\2Nk2$\u0018n]5h\u0003\u0012$'/Z:t\u0011\u001d\u0019YC\u0011a\u0001\u0003{AQ\u0001\u001c\"A\u0002%\f\u0011$[:WC2LGmT<oKJ\u001c\b.\u001b9TS\u001et\u0017\r^;sKRQ!\u0011AB#\u0007\u000f\u001aIe!\u0014\t\r\u0005]2\t1\u0001w\u0011\u001d\tYd\u0011a\u0001\u0003{Aqaa\u0013D\u0001\u0004\u0019i!A\u0006nGNKwM\\1ukJ,\u0007\"B4D\u0001\u0004I\u0017!I5t-\u0006d\u0017\u000eZ(x]\u0016\u00148\u000f[5q\u001bVdG/[:jONKwM\\1ukJ,GC\u0003B\u0001\u0007'\u001a)fa\u0016\u0004\\!1\u0011q\u0007#A\u0002YDqaa\u000fE\u0001\u0004\ti\u0004\u0003\u0004\u0004Z\u0011\u0003\ra`\u0001\u0007aV\u00147*Z=\t\u000f\r-C\t1\u0001\u0004\u000e\u0005ib/\u001a:jMf\u001c\u0016n\u001a8biV\u0014Xm],ji\"$\u0006N]3tQ>dG\r\u0006\u0007\u0002&\r\u00054QMB4\u0007W\u001a\t\b\u0003\u0004\u0004d\u0015\u0003\rA^\u0001\u0010g\u0016tG-\u001a:TG\u0006#GM]3tg\"911H#A\u0002\u0005u\u0002bBB5\u000b\u0002\u00071qE\u0001\baV\u00147*Z=t\u0011\u001d\u0019i'\u0012a\u0001\u0007_\n!b]5h]\u0006$XO]3t!\u0019\ti+a.\u0004\u000e!911O#A\u0002\u0005\u0015\u0012a\u0006;ie\u0016\u001c\bn\u001c7e'&<g.\u0019;ve\u00164\u0016\r\\;f\u000399W\r^'d\u0011\u0006\u001c\b.\u001a3Ng\u001e$2a`B=\u0011\u001d\u0019YH\u0012a\u0001\u0003{\t1#\\3tg\u0006<W\rV8TS\u001et7\u000b\u001e:j]\u001e\fQbZ3u\u001b\u0006<\u0017n\u0019\"zi\u0016\u001c\u0018\u0001E2bG\",G-T1hS\u000e\u0014\u0015\u0010^3t\u0003\u0015\t\u0007\u000f\u001d7z)\r\u00118Q\u0011\u0005\u0006O&\u0003\r![\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0019Yi!$\u0011\t}\u000bI.\u001b\u0005\t\u0007\u001fS\u0015\u0011!a\u0001e\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0007+\u0003BA!\u0017\u0004\u0018&!1\u0011\u0014B.\u0005\u0019y%M[3di\u0002")
public class McAddrOwnershipMsgProcessor
extends NativeSmartContractWithFork
implements McAddrOwnershipsProvider,
Product,
scala.Serializable {
    private final NetworkParams networkParams;
    private final Address contractAddress;
    private final byte[] contractCode;

    public static Option<NetworkParams> unapply(McAddrOwnershipMsgProcessor mcAddrOwnershipMsgProcessor) {
        return McAddrOwnershipMsgProcessor$.MODULE$.unapply(mcAddrOwnershipMsgProcessor);
    }

    public static McAddrOwnershipMsgProcessor apply(NetworkParams networkParams) {
        return McAddrOwnershipMsgProcessor$.MODULE$.apply(networkParams);
    }

    public static byte[] cachedMagicBytes() {
        return McAddrOwnershipMsgProcessor$.MODULE$.cachedMagicBytes();
    }

    public static byte[] getMcHashedMsg(String string) {
        return McAddrOwnershipMsgProcessor$.MODULE$.getMcHashedMsg(string);
    }

    public static int verifySignaturesWithThreshold(Address address, String string, Seq<byte[]> seq, Seq<SignatureSecp256k1> seq2, int n) {
        return McAddrOwnershipMsgProcessor$.MODULE$.verifySignaturesWithThreshold(address, string, seq, seq2, n);
    }

    public static boolean checkMultisigAddress(String string, String string2, NetworkParams networkParams) {
        return McAddrOwnershipMsgProcessor$.MODULE$.checkMultisigAddress(string, string2, networkParams);
    }

    public static byte[] checkMcAddresses(String string, NetworkParams networkParams) {
        return McAddrOwnershipMsgProcessor$.MODULE$.checkMcAddresses(string, networkParams);
    }

    public static Tuple2<Object, Seq<byte[]>> checkMcRedeemScriptForMultisig(String string) {
        return McAddrOwnershipMsgProcessor$.MODULE$.checkMcRedeemScriptForMultisig(string);
    }

    public static SignatureSecp256k1 getMcSignature(String string) {
        return McAddrOwnershipMsgProcessor$.MODULE$.getMcSignature(string);
    }

    public static byte[] getOwnershipId(String string) {
        return McAddrOwnershipMsgProcessor$.MODULE$.getOwnershipId(string);
    }

    public static X9ECParameters ecParameters() {
        return McAddrOwnershipMsgProcessor$.MODULE$.ecParameters();
    }

    public static String GetListOfOwnerScAddressesCmd() {
        return McAddrOwnershipMsgProcessor$.MODULE$.GetListOfOwnerScAddressesCmd();
    }

    public static String GetListOfOwnershipsCmd() {
        return McAddrOwnershipMsgProcessor$.MODULE$.GetListOfOwnershipsCmd();
    }

    public static String GetListOfAllOwnershipsCmd() {
        return McAddrOwnershipMsgProcessor$.MODULE$.GetListOfAllOwnershipsCmd();
    }

    public static String RemoveOwnershipCmd() {
        return McAddrOwnershipMsgProcessor$.MODULE$.RemoveOwnershipCmd();
    }

    public static String AddNewOwnershipCmd() {
        return McAddrOwnershipMsgProcessor$.MODULE$.AddNewOwnershipCmd();
    }

    public static String AddNewMultisigOwnershipCmd() {
        return McAddrOwnershipMsgProcessor$.MODULE$.AddNewMultisigOwnershipCmd();
    }

    public static byte[] ScAddressRefsLinkedListNullValue() {
        return McAddrOwnershipMsgProcessor$.MODULE$.ScAddressRefsLinkedListNullValue();
    }

    public static byte[] ScAddressRefsLinkedListTipKey() {
        return McAddrOwnershipMsgProcessor$.MODULE$.ScAddressRefsLinkedListTipKey();
    }

    public static byte[] OwnershipLinkedListNullValue() {
        return McAddrOwnershipMsgProcessor$.MODULE$.OwnershipLinkedListNullValue();
    }

    public static byte[] OwnershipsLinkedListTipKey() {
        return McAddrOwnershipMsgProcessor$.MODULE$.OwnershipsLinkedListTipKey();
    }

    public NetworkParams networkParams() {
        return this.networkParams;
    }

    @Override
    public Address contractAddress() {
        return this.contractAddress;
    }

    @Override
    public byte[] contractCode() {
        return this.contractCode;
    }

    @Override
    public void doSpecificInit(BaseAccountStateView view, int consensusEpochNumber) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        byte[] initialTip = view.getAccountStorage(this.contractAddress(), McAddrOwnershipMsgProcessor$.MODULE$.OwnershipsLinkedListTipKey());
        if (!new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(initialTip)).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(NativeSmartContractMsgProcessor$.MODULE$.NULL_HEX_STRING_32()))) {
            String warnMsg = "Initial tip already set, overwriting it!! ";
            if (this.log().underlying().isWarnEnabled()) {
                this.log().underlying().warn(warnMsg);
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        view.updateAccountStorage(this.contractAddress(), McAddrOwnershipMsgProcessor$.MODULE$.OwnershipsLinkedListTipKey(), McAddrOwnershipMsgProcessor$.MODULE$.OwnershipLinkedListNullValue());
        if (!new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(view.getAccountStorage(this.contractAddress(), McAddrOwnershipMsgProcessor$.MODULE$.ScAddressRefsLinkedListTipKey()))).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(NativeSmartContractMsgProcessor$.MODULE$.NULL_HEX_STRING_32()))) {
            String warnMsg = "Sc Initial tip already set, overwriting it!! ";
            if (this.log().underlying().isWarnEnabled()) {
                this.log().underlying().warn(warnMsg);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        view.updateAccountStorage(this.contractAddress(), McAddrOwnershipMsgProcessor$.MODULE$.ScAddressRefsLinkedListTipKey(), McAddrOwnershipMsgProcessor$.MODULE$.ScAddressRefsLinkedListNullValue());
    }

    private void addMcAddrOwnership(BaseAccountStateView view, byte[] ownershipId, Address scAddress, String mcTransparentAddress) {
        McAddrOwnershipLinkedList$.MODULE$.addNewNode(view, ownershipId, this.contractAddress());
        McAddrOwnershipData mcAddrOwnershipData = new McAddrOwnershipData(scAddress.toStringNoPrefix(), mcTransparentAddress);
        byte[] serializedOwnershipData = McAddrOwnershipDataSerializer$.MODULE$.toBytes(mcAddrOwnershipData);
        view.updateAccountStorageBytes(this.contractAddress(), ownershipId, serializedOwnershipData);
        ScAddrOwnershipLinkedList scAddrList = ScAddrOwnershipLinkedList$.MODULE$.apply(view, scAddress.toStringNoPrefix());
        byte[] dataId = scAddrList.getDataId(mcTransparentAddress);
        scAddrList.addNewNode(view, dataId, this.contractAddress());
        byte[] serializedData = mcTransparentAddress.getBytes(StandardCharsets.UTF_8);
        view.updateAccountStorageBytes(this.contractAddress(), dataId, serializedData);
    }

    private void uncheckedRemoveMcAddrOwnership(BaseAccountStateView view, byte[] ownershipId, String scAddressStr, String mcTransparentAddress) {
        ScAddrOwnershipLinkedList scAddrList = ScAddrOwnershipLinkedList$.MODULE$.apply(view, scAddressStr);
        byte[] dataId = scAddrList.getDataId(mcTransparentAddress);
        scAddrList.removeNode(view, dataId, this.contractAddress());
        view.removeAccountStorageBytes(this.contractAddress(), dataId);
        McAddrOwnershipLinkedList$.MODULE$.removeNode(view, ownershipId, this.contractAddress());
        view.removeAccountStorageBytes(this.contractAddress(), ownershipId);
    }

    public byte[] doAddNewOwnershipCmd(Invocation invocation, BaseAccountStateView view, Message msg) {
        BoxedUnit boxedUnit;
        if (invocation.value().signum() != 0) {
            BoxedUnit boxedUnit2;
            String errMsg = new StringBuilder(33).append("Value must be zero: invocation = ").append(invocation).toString();
            if (this.log().underlying().isWarnEnabled()) {
                this.log().underlying().warn(errMsg);
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            throw new ExecutionRevertedException(errMsg);
        }
        if (!view.accountExists(msg.getFrom())) {
            BoxedUnit boxedUnit3;
            String errMsg = new StringBuilder(37).append("Sender account does not exist: msg = ").append(msg).toString();
            if (this.log().underlying().isWarnEnabled()) {
                this.log().underlying().warn(errMsg);
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            throw new ExecutionRevertedException(errMsg);
        }
        byte[] inputParams = ABIUtil.getArgumentsFromData(invocation.input());
        AddNewOwnershipCmdInput cmdInput = (AddNewOwnershipCmdInput)AddNewOwnershipCmdInputDecoder$.MODULE$.decode(inputParams);
        String mcTransparentAddress = cmdInput.mcTransparentAddress();
        String mcSignature = cmdInput.mcSignature();
        byte[] newOwnershipId = McAddrOwnershipMsgProcessor$.MODULE$.getOwnershipId(mcTransparentAddress);
        SignatureSecp256k1 mcSignSecp256k1 = McAddrOwnershipMsgProcessor$.MODULE$.getMcSignature(mcSignature);
        if (!McAddrOwnershipMsgProcessor$.MODULE$.io$horizen$account$state$McAddrOwnershipMsgProcessor$$isValidOwnershipSignature(msg.getFrom(), mcTransparentAddress, mcSignSecp256k1, this.networkParams())) {
            BoxedUnit boxedUnit4;
            String errMsg = new StringBuilder(36).append("Invalid mc signature ").append(mcSignature).append(": invocation = ").append(invocation).toString();
            if (this.log().underlying().isWarnEnabled()) {
                this.log().underlying().warn(errMsg);
                boxedUnit4 = BoxedUnit.UNIT;
            } else {
                boxedUnit4 = BoxedUnit.UNIT;
            }
            throw new ExecutionRevertedException(errMsg);
        }
        Option<String> option = this.getExistingAssociation(view, newOwnershipId);
        if (option instanceof Some) {
            BoxedUnit boxedUnit5;
            Some some = (Some)option;
            String scAddrStr = (String)some.value();
            String errMsg = new StringBuilder(63).append("MC address ").append(mcTransparentAddress).append(" is already associated to sc address ").append(scAddrStr).append(": invocation = ").append(invocation).toString();
            if (this.log().underlying().isWarnEnabled()) {
                this.log().underlying().warn(errMsg);
                boxedUnit5 = BoxedUnit.UNIT;
            } else {
                boxedUnit5 = BoxedUnit.UNIT;
            }
            throw new ExecutionRevertedException(errMsg);
        }
        if (!None$.MODULE$.equals(option)) {
            throw new MatchError(option);
        }
        BoxedUnit boxedUnit6 = BoxedUnit.UNIT;
        this.addMcAddrOwnership(view, newOwnershipId, msg.getFrom(), mcTransparentAddress);
        if (this.log().underlying().isDebugEnabled()) {
            this.log().underlying().debug(new StringBuilder(81).append("Added ownership to stateDb: newOwnershipId=").append(BytesUtils.toHexString(newOwnershipId)).append(",").append(" scAddress=").append(msg.getFrom()).append(", mcAddress=").append(mcTransparentAddress).append(", mcSignature=").append(mcSignature).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        AddMcAddrOwnership addNewMcAddrOwnershipEvt = AddMcAddrOwnership$.MODULE$.apply(msg.getFrom(), mcTransparentAddress);
        EthereumConsensusDataLog evmLog = this.getEthereumConsensusDataLog(addNewMcAddrOwnershipEvt);
        view.addLog(evmLog);
        return newOwnershipId;
    }

    public byte[] doAddNewMultisigOwnershipCmd(Invocation invocation, BaseAccountStateView view, Message msg) {
        BoxedUnit boxedUnit;
        if (invocation.value().signum() != 0) {
            BoxedUnit boxedUnit2;
            String errMsg = new StringBuilder(33).append("Value must be zero: invocation = ").append(invocation).toString();
            if (this.log().underlying().isWarnEnabled()) {
                this.log().underlying().warn(errMsg);
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            throw new ExecutionRevertedException(errMsg);
        }
        Address senderScAddress = msg.getFrom();
        if (!view.accountExists(senderScAddress)) {
            BoxedUnit boxedUnit3;
            String errMsg = new StringBuilder(37).append("Sender account does not exist: msg = ").append(msg).toString();
            if (this.log().underlying().isWarnEnabled()) {
                this.log().underlying().warn(errMsg);
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            throw new ExecutionRevertedException(errMsg);
        }
        byte[] inputParams = ABIUtil.getArgumentsFromData(invocation.input());
        AddNewMultisigOwnershipCmdInput cmdInput = (AddNewMultisigOwnershipCmdInput)AddNewMultisigOwnershipCmdInputDecoder$.MODULE$.decode(inputParams);
        String mcMultisigAddress = cmdInput.mcTransparentAddress();
        String redeemScript = cmdInput.redeemScript();
        Seq<String> mcSignatures = cmdInput.mcSignatures();
        if (mcSignatures.size() > 16) {
            BoxedUnit boxedUnit4;
            String errMsg = new StringBuilder(81).append("Too many signatures ").append(mcSignatures.size()).append(", can not be more that max num of pubkeys in a redeem script ").append(16).toString();
            if (this.log().underlying().isWarnEnabled()) {
                this.log().underlying().warn(errMsg);
                boxedUnit4 = BoxedUnit.UNIT;
            } else {
                boxedUnit4 = BoxedUnit.UNIT;
            }
            throw new ExecutionRevertedException(errMsg);
        }
        if (!McAddrOwnershipMsgProcessor$.MODULE$.checkMultisigAddress(mcMultisigAddress, redeemScript, this.networkParams())) {
            BoxedUnit boxedUnit5;
            String errMsg = "Could not verify multisig address against redeemScript";
            if (this.log().underlying().isWarnEnabled()) {
                this.log().underlying().warn(errMsg);
                boxedUnit5 = BoxedUnit.UNIT;
            } else {
                boxedUnit5 = BoxedUnit.UNIT;
            }
            throw new ExecutionRevertedException(errMsg);
        }
        Tuple2<Object, Seq<byte[]>> retValue = null;
        try {
            retValue = McAddrOwnershipMsgProcessor$.MODULE$.checkMcRedeemScriptForMultisig(redeemScript);
        }
        catch (IllegalArgumentException e) {
            BoxedUnit boxedUnit6;
            String errMsg = new StringBuilder(35).append("Unexpected format of redeemScript: ").append(e.getMessage()).toString();
            if (this.log().underlying().isWarnEnabled()) {
                this.log().underlying().warn(errMsg);
                boxedUnit6 = BoxedUnit.UNIT;
            } else {
                boxedUnit6 = BoxedUnit.UNIT;
            }
            throw new ExecutionRevertedException(errMsg);
        }
        int thresholdSignatureValue = retValue._1$mcI$sp();
        Seq pubKeys = (Seq)retValue._2();
        if (mcSignatures.size() < thresholdSignatureValue) {
            BoxedUnit boxedUnit7;
            String errMsg = new StringBuilder(54).append("Signatures are not enough. Input has ").append(mcSignatures.size()).append(", needs at least ").append(thresholdSignatureValue).toString();
            if (this.log().underlying().isWarnEnabled()) {
                this.log().underlying().warn(errMsg);
                boxedUnit7 = BoxedUnit.UNIT;
            } else {
                boxedUnit7 = BoxedUnit.UNIT;
            }
            throw new ExecutionRevertedException(errMsg);
        }
        byte[] newOwnershipId = McAddrOwnershipMsgProcessor$.MODULE$.getOwnershipId(mcMultisigAddress);
        Seq signatures = (Seq)mcSignatures.map((Function1 & Serializable & scala.Serializable)s -> McAddrOwnershipMsgProcessor$.MODULE$.getMcSignature((String)s), Seq$.MODULE$.canBuildFrom());
        int score = McAddrOwnershipMsgProcessor$.MODULE$.verifySignaturesWithThreshold(senderScAddress, mcMultisigAddress, (Seq<byte[]>)pubKeys, (Seq<SignatureSecp256k1>)signatures, thresholdSignatureValue);
        if (score < thresholdSignatureValue) {
            BoxedUnit boxedUnit8;
            String errMsg = new StringBuilder(62).append("Invalid number of verified signatures: ").append(score).append(", need: ").append(thresholdSignatureValue).append(": invocation = ").append(invocation).toString();
            if (this.log().underlying().isWarnEnabled()) {
                this.log().underlying().warn(errMsg);
                boxedUnit8 = BoxedUnit.UNIT;
            } else {
                boxedUnit8 = BoxedUnit.UNIT;
            }
            throw new ExecutionRevertedException(errMsg);
        }
        Option<String> option = this.getExistingAssociation(view, newOwnershipId);
        if (option instanceof Some) {
            BoxedUnit boxedUnit9;
            Some some = (Some)option;
            String scAddrStr = (String)some.value();
            String errMsg = new StringBuilder(63).append("MC address ").append(mcMultisigAddress).append(" is already associated to sc address ").append(scAddrStr).append(": invocation = ").append(invocation).toString();
            if (this.log().underlying().isWarnEnabled()) {
                this.log().underlying().warn(errMsg);
                boxedUnit9 = BoxedUnit.UNIT;
            } else {
                boxedUnit9 = BoxedUnit.UNIT;
            }
            throw new ExecutionRevertedException(errMsg);
        }
        if (!None$.MODULE$.equals(option)) {
            throw new MatchError(option);
        }
        BoxedUnit boxedUnit10 = BoxedUnit.UNIT;
        this.addMcAddrOwnership(view, newOwnershipId, senderScAddress, mcMultisigAddress);
        if (this.log().underlying().isDebugEnabled()) {
            this.log().underlying().debug(new StringBuilder(76).append("Added ownership to stateDb: newOwnershipId=").append(BytesUtils.toHexString(newOwnershipId)).append(",").append(" scAddress=").append(senderScAddress).append("}, mcMultisigAddress=").append(mcMultisigAddress).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        AddMcAddrOwnership addNewMcAddrOwnershipEvt = AddMcAddrOwnership$.MODULE$.apply(senderScAddress, mcMultisigAddress);
        EthereumConsensusDataLog evmLog = this.getEthereumConsensusDataLog(addNewMcAddrOwnershipEvt);
        view.addLog(evmLog);
        return newOwnershipId;
    }

    public byte[] doRemoveOwnershipCmd(Invocation invocation, BaseAccountStateView view, Message msg) {
        byte[] ownershipId;
        String mcTransparentAddress;
        if (msg.getNonce() == null) {
            throw new ExecutionRevertedException("Call must include a nonce");
        }
        if (invocation.value().signum() != 0) {
            throw new ExecutionRevertedException("Value must be zero");
        }
        if (!view.accountExists(msg.getFrom())) {
            throw new ExecutionRevertedException(new StringBuilder(31).append("Sender account does not exist: ").append(msg.getFrom()).toString());
        }
        byte[] inputParams = ABIUtil.getArgumentsFromData(invocation.input());
        RemoveOwnershipCmdInput cmdInput = (RemoveOwnershipCmdInput)RemoveOwnershipCmdInputDecoder$.MODULE$.decode(inputParams);
        Option<String> option = cmdInput.mcTransparentAddressOpt();
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            mcTransparentAddress = (String)some.value();
            ownershipId = McAddrOwnershipMsgProcessor$.MODULE$.getOwnershipId(mcTransparentAddress);
            Option<String> option2 = this.getExistingAssociation(view, ownershipId);
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                String scAddrStr = (String)some2.value();
                if (!msg.getFrom().toStringNoPrefix().equals(scAddrStr)) {
                    BoxedUnit boxedUnit2;
                    String errMsg = new StringBuilder(40).append("sc address ").append(scAddrStr).append(" is not the owner of ").append(mcTransparentAddress).append(": msg = ").append(msg).toString();
                    if (this.log().underlying().isWarnEnabled()) {
                        this.log().underlying().warn(errMsg);
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    throw new ExecutionRevertedException(errMsg);
                }
            } else {
                if (None$.MODULE$.equals(option2)) {
                    throw new ExecutionRevertedException(new StringBuilder(26).append("Ownership ").append(BytesUtils.toHexString(ownershipId)).append(" does not exists").toString());
                }
                throw new MatchError(option2);
            }
            BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
            this.uncheckedRemoveMcAddrOwnership(view, ownershipId, msg.getFrom().toStringNoPrefix(), mcTransparentAddress);
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug(new StringBuilder(72).append("Removed ownership from stateDb: ownershipId=").append(BytesUtils.toHexString(ownershipId)).append(",").append(" scAddress=").append(msg.getFrom()).append(", mcPubKeyBytes=").append(mcTransparentAddress).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            if (None$.MODULE$.equals(option)) {
                throw new ExecutionRevertedException("Invalid null mc address");
            }
            throw new MatchError(option);
        }
        RemoveMcAddrOwnership removeMcAddrOwnershipEvt = RemoveMcAddrOwnership$.MODULE$.apply(msg.getFrom(), mcTransparentAddress);
        EthereumConsensusDataLog evmLog = this.getEthereumConsensusDataLog(removeMcAddrOwnershipEvt);
        view.addLog(evmLog);
        byte[] byArray = ownershipId;
        return byArray;
    }

    public byte[] doGetListOfOwnershipsCmd(Invocation invocation, BaseAccountStateView view) {
        if (invocation.value().signum() != 0) {
            throw new ExecutionRevertedException("Call value must be zero");
        }
        byte[] inputParams = ABIUtil.getArgumentsFromData(invocation.input());
        GetOwnershipsCmdInput cmdInput = (GetOwnershipsCmdInput)GetOwnershipsCmdInputDecoder$.MODULE$.decode(inputParams);
        Seq<McAddrOwnershipData> ownershipList = this.getScAddrListOfMcAddrOwnerships(view, cmdInput.scAddress().toStringNoPrefix());
        return McAddrOwnershipDataListEncoder$.MODULE$.encode((List)CollectionConverters$.MODULE$.seqAsJavaListConverter(ownershipList).asJava());
    }

    public byte[] doGetListOfAllOwnershipsCmd(Invocation invocation, BaseAccountStateView view) {
        if (invocation.value().signum() != 0) {
            throw new ExecutionRevertedException("Call value must be zero");
        }
        if (ABIUtil.getArgumentsFromData(invocation.input()).length > 0) {
            BoxedUnit boxedUnit;
            String msgStr = new StringBuilder(36).append("invalid msg data length: ").append(invocation.input().length).append(", expected ").append(4).toString();
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug(msgStr);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            throw new ExecutionRevertedException(msgStr);
        }
        Seq<McAddrOwnershipData> ownershipList = this.getListOfMcAddrOwnerships(view, this.getListOfMcAddrOwnerships$default$2());
        return McAddrOwnershipDataListEncoder$.MODULE$.encode((List)CollectionConverters$.MODULE$.seqAsJavaListConverter(ownershipList).asJava());
    }

    public byte[] doGetListOfOwnerScAddressesCmd(Invocation invocation, BaseAccountStateView view) {
        if (invocation.value().signum() != 0) {
            throw new ExecutionRevertedException("Call value must be zero");
        }
        if (ABIUtil.getArgumentsFromData(invocation.input()).length > 0) {
            BoxedUnit boxedUnit;
            String msgStr = new StringBuilder(36).append("invalid msg data length: ").append(invocation.input().length).append(", expected ").append(4).toString();
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug(msgStr);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            throw new ExecutionRevertedException(msgStr);
        }
        Seq<OwnerScAddress> ownershipList = this.getListOfOwnerScAddresses(view);
        return OwnerScAddrListEncoder$.MODULE$.encode((List)CollectionConverters$.MODULE$.seqAsJavaListConverter(ownershipList).asJava());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Seq<OwnerScAddress> getListOfOwnerScAddresses(BaseAccountStateView view) {
        void var3_2;
        BoxedUnit boxedUnit;
        Seq ownerScAddresses = (Seq)Nil$.MODULE$;
        byte[] nodeReference = view.getAccountStorage(this.contractAddress(), McAddrOwnershipMsgProcessor$.MODULE$.ScAddressRefsLinkedListTipKey());
        if (new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(nodeReference)).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(NativeSmartContractMsgProcessor$.MODULE$.NULL_HEX_STRING_32()))) {
            return ownerScAddresses;
        }
        try {
            while (!ScAddressRefsLinkedList$.MODULE$.linkedListNodeRefIsNull(nodeReference)) {
                OwnerScAddress ownerScAddress;
                byte[] prevNodeReference;
                block10: {
                    Tuple2<OwnerScAddress, byte[]> tuple2;
                    block9: {
                        tuple2 = ScAddressRefsLinkedList$.MODULE$.getScAddresRefsListItem(view, nodeReference);
                        if (tuple2 == null) break block9;
                        OwnerScAddress item = (OwnerScAddress)tuple2._1();
                        prevNodeReference = (byte[])tuple2._2();
                        if (item == null) break block9;
                        ownerScAddress = item;
                        if (prevNodeReference != null) break block10;
                    }
                    throw new MatchError(tuple2);
                }
                byte[] byArray = prevNodeReference;
                Tuple2 tuple2 = new Tuple2((Object)ownerScAddress, (Object)byArray);
                Tuple2 tuple22 = tuple2;
                OwnerScAddress item = (OwnerScAddress)tuple22._1();
                byte[] prevNodeReference2 = (byte[])tuple22._2();
                OwnerScAddress ownerScAddress2 = item;
                ownerScAddresses = (Seq)ownerScAddresses.$plus$colon((Object)ownerScAddress2, Seq$.MODULE$.canBuildFrom());
                nodeReference = prevNodeReference2;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        catch (OutOfGasException e) {
            if (this.log().underlying().isWarnEnabled()) {
                this.log().underlying().warn(new StringBuilder(45).append("OOG exception thrown after getting ").append(ownerScAddresses.length()).append(" elements!").toString(), (Throwable)e);
                boxedUnit = BoxedUnit.UNIT;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        return var3_2;
    }

    @Override
    public Seq<McAddrOwnershipData> getListOfMcAddrOwnerships(BaseAccountStateView view, Option<String> scAddressOpt) {
        BoxedUnit boxedUnit;
        Seq ownershipsList = (Seq)Nil$.MODULE$;
        byte[] nodeReference = view.getAccountStorage(this.contractAddress(), McAddrOwnershipMsgProcessor$.MODULE$.OwnershipsLinkedListTipKey());
        if (new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(nodeReference)).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(NativeSmartContractMsgProcessor$.MODULE$.NULL_HEX_STRING_32()))) {
            return ownershipsList;
        }
        Option<String> option = scAddressOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            String scAddr = (String)some.value();
            return this.getScAddrListOfMcAddrOwnerships(view, scAddr);
        }
        if (!None$.MODULE$.equals(option)) {
            throw new MatchError(option);
        }
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        try {
            while (!McAddrOwnershipLinkedList$.MODULE$.linkedListNodeRefIsNull(nodeReference)) {
                McAddrOwnershipData mcAddrOwnershipData;
                byte[] prevNodeReference;
                block12: {
                    Tuple2<McAddrOwnershipData, byte[]> tuple2;
                    block11: {
                        tuple2 = McAddrOwnershipLinkedList$.MODULE$.getOwnershipListItem(view, nodeReference);
                        if (tuple2 == null) break block11;
                        McAddrOwnershipData item = (McAddrOwnershipData)tuple2._1();
                        prevNodeReference = (byte[])tuple2._2();
                        if (item == null) break block11;
                        mcAddrOwnershipData = item;
                        if (prevNodeReference != null) break block12;
                    }
                    throw new MatchError(tuple2);
                }
                byte[] byArray = prevNodeReference;
                Tuple2 tuple2 = new Tuple2((Object)mcAddrOwnershipData, (Object)byArray);
                Tuple2 tuple22 = tuple2;
                McAddrOwnershipData item = (McAddrOwnershipData)tuple22._1();
                byte[] prevNodeReference2 = (byte[])tuple22._2();
                McAddrOwnershipData mcAddrOwnershipData2 = item;
                ownershipsList = (Seq)ownershipsList.$plus$colon((Object)mcAddrOwnershipData2, Seq$.MODULE$.canBuildFrom());
                nodeReference = prevNodeReference2;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        catch (OutOfGasException e) {
            if (this.log().underlying().isWarnEnabled()) {
                this.log().underlying().warn(new StringBuilder(45).append("OOG exception thrown after getting ").append(ownershipsList.length()).append(" elements!").toString(), (Throwable)e);
                boxedUnit = BoxedUnit.UNIT;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        return ownershipsList;
    }

    @Override
    public Option<String> getListOfMcAddrOwnerships$default$2() {
        return None$.MODULE$;
    }

    private Seq<McAddrOwnershipData> getScAddrListOfMcAddrOwnerships(BaseAccountStateView view, String scAddress) {
        BoxedUnit boxedUnit;
        ScAddrOwnershipLinkedList scAddrList = ScAddrOwnershipLinkedList$.MODULE$.apply(view, scAddress);
        byte[] nodeReference = scAddrList.getTip(view);
        Seq ownershipsList = (Seq)Nil$.MODULE$;
        try {
            while (!scAddrList.linkedListNodeRefIsNull(nodeReference)) {
                String string;
                byte[] prevNodeReference;
                block8: {
                    Tuple2<String, byte[]> tuple2;
                    block7: {
                        tuple2 = scAddrList.getItem(view, nodeReference);
                        if (tuple2 == null) break block7;
                        String item = (String)tuple2._1();
                        prevNodeReference = (byte[])tuple2._2();
                        if (item == null) break block7;
                        string = item;
                        if (prevNodeReference != null) break block8;
                    }
                    throw new MatchError(tuple2);
                }
                byte[] byArray = prevNodeReference;
                Tuple2 tuple2 = new Tuple2((Object)string, (Object)byArray);
                Tuple2 tuple22 = tuple2;
                String item = (String)tuple22._1();
                byte[] prevNodeReference2 = (byte[])tuple22._2();
                McAddrOwnershipData mcAddrOwnershipData = new McAddrOwnershipData(scAddress, item);
                ownershipsList = (Seq)ownershipsList.$plus$colon((Object)mcAddrOwnershipData, Seq$.MODULE$.canBuildFrom());
                nodeReference = prevNodeReference2;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        catch (OutOfGasException e) {
            if (this.log().underlying().isWarnEnabled()) {
                this.log().underlying().warn(new StringBuilder(45).append("OOG exception thrown after getting ").append(ownershipsList.length()).append(" elements!").toString(), (Throwable)e);
                boxedUnit = BoxedUnit.UNIT;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        return ownershipsList;
    }

    @Override
    public boolean ownershipDataExist(BaseAccountStateView view, byte[] ownershipId) {
        byte[] data = view.getAccountStorage(this.contractAddress(), ownershipId);
        return !new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(data)).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(NativeSmartContractMsgProcessor$.MODULE$.NULL_HEX_STRING_32()));
    }

    private Option<String> getExistingAssociation(BaseAccountStateView view, byte[] ownershipId) {
        None$ none$;
        Option<McAddrOwnershipData> option = McAddrOwnershipLinkedList$.MODULE$.getOwnershipData(view, ownershipId);
        if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            McAddrOwnershipData obj = (McAddrOwnershipData)some.value();
            none$ = new Some((Object)obj.scAddress());
        } else {
            throw new MatchError(option);
        }
        return none$;
    }

    @Override
    public byte[] process(Invocation invocation, BaseAccountStateView view, ExecutionContext context) throws ExecutionFailedException {
        byte[] byArray;
        if (!this.isForkActive(context.blockContext().consensusEpochNumber)) {
            throw new ExecutionRevertedException("zenDao fork not active");
        }
        BaseAccountStateView gasView = view.getGasTrackedView(invocation.gasPool());
        if (!this.initDone(gasView)) {
            throw new ExecutionRevertedException("zenDao native smart contract init not done");
        }
        if (invocation.input().length == 0) {
            throw new ExecutionRevertedException(new StringBuilder(24).append("No data in invocation = ").append(invocation).toString());
        }
        String string = ABIUtil.getFunctionSignature(invocation.input());
        String string2 = McAddrOwnershipMsgProcessor$.MODULE$.AddNewMultisigOwnershipCmd();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            if (!this.isMultisigForkActive(context.blockContext().consensusEpochNumber)) {
                BoxedUnit boxedUnit;
                if (this.log().underlying().isWarnEnabled()) {
                    this.log().underlying().warn("fork not active, can not handle multisig ownership cmd yet");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                throw new ExecutionRevertedException(new StringBuilder(23).append("op code not supported: ").append(McAddrOwnershipMsgProcessor$.MODULE$.AddNewMultisigOwnershipCmd()).toString());
            }
            byArray = this.doAddNewMultisigOwnershipCmd(invocation, gasView, context.msg());
        } else {
            String string4 = McAddrOwnershipMsgProcessor$.MODULE$.AddNewOwnershipCmd();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                byArray = this.doAddNewOwnershipCmd(invocation, gasView, context.msg());
            } else {
                String string6 = McAddrOwnershipMsgProcessor$.MODULE$.RemoveOwnershipCmd();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    byArray = this.doRemoveOwnershipCmd(invocation, gasView, context.msg());
                } else {
                    String string8 = McAddrOwnershipMsgProcessor$.MODULE$.GetListOfAllOwnershipsCmd();
                    String string9 = string;
                    if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                        byArray = this.doGetListOfAllOwnershipsCmd(invocation, gasView);
                    } else {
                        String string10 = McAddrOwnershipMsgProcessor$.MODULE$.GetListOfOwnershipsCmd();
                        String string11 = string;
                        if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                            byArray = this.doGetListOfOwnershipsCmd(invocation, gasView);
                        } else {
                            String string12 = McAddrOwnershipMsgProcessor$.MODULE$.GetListOfOwnerScAddressesCmd();
                            String string13 = string;
                            if (!(string12 != null ? !string12.equals(string13) : string13 != null)) {
                                byArray = this.doGetListOfOwnerScAddressesCmd(invocation, gasView);
                            } else {
                                throw new ExecutionRevertedException(new StringBuilder(23).append("op code not supported: ").append(string).toString());
                            }
                        }
                    }
                }
            }
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isMultisigForkActive(int consensusEpochNumber) {
        void var2_2;
        BoxedUnit boxedUnit;
        String strVal;
        boolean forkIsActive = Version1_2_0Fork$.MODULE$.get(consensusEpochNumber).active();
        String string = strVal = forkIsActive ? "YES" : "NO";
        if (this.log().underlying().isTraceEnabled()) {
            this.log().underlying().trace("Epoch {}: Version1_2_0Fork fork active={}", new Object[]{BoxesRunTime.boxToInteger((int)consensusEpochNumber), strVal});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return (boolean)var2_2;
    }

    @Override
    public boolean initDone(BaseAccountStateView view) {
        byte[] initialTip = view.getAccountStorage(WellKnownAddresses$.MODULE$.MC_ADDR_OWNERSHIP_SMART_CONTRACT_ADDRESS(), McAddrOwnershipMsgProcessor$.MODULE$.OwnershipsLinkedListTipKey());
        return !new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(initialTip)).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(NativeSmartContractMsgProcessor$.MODULE$.NULL_HEX_STRING_32()));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isForkActive(int consensusEpochNumber) {
        void var2_2;
        BoxedUnit boxedUnit;
        String strVal;
        boolean forkIsActive = ZenDAOFork$.MODULE$.get(consensusEpochNumber).active();
        String string = strVal = forkIsActive ? "YES" : "NO";
        if (this.log().underlying().isTraceEnabled()) {
            this.log().underlying().trace("Epoch {}: ZenDAO fork active={}", new Object[]{BoxesRunTime.boxToInteger((int)consensusEpochNumber), strVal});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return (boolean)var2_2;
    }

    public McAddrOwnershipMsgProcessor copy(NetworkParams networkParams) {
        return new McAddrOwnershipMsgProcessor(networkParams);
    }

    public NetworkParams copy$default$1() {
        return this.networkParams();
    }

    public String productPrefix() {
        return "McAddrOwnershipMsgProcessor";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.networkParams();
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof McAddrOwnershipMsgProcessor;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof McAddrOwnershipMsgProcessor)) return false;
        boolean bl = true;
        if (!bl) return false;
        McAddrOwnershipMsgProcessor mcAddrOwnershipMsgProcessor = (McAddrOwnershipMsgProcessor)x$1;
        NetworkParams networkParams = this.networkParams();
        NetworkParams networkParams2 = mcAddrOwnershipMsgProcessor.networkParams();
        if (networkParams == null) {
            if (networkParams2 != null) {
                return false;
            }
        } else if (!networkParams.equals(networkParams2)) return false;
        if (!mcAddrOwnershipMsgProcessor.canEqual(this)) return false;
        return true;
    }

    public McAddrOwnershipMsgProcessor(NetworkParams networkParams) {
        this.networkParams = networkParams;
        Product.$init$((Product)this);
        this.contractAddress = WellKnownAddresses$.MODULE$.MC_ADDR_OWNERSHIP_SMART_CONTRACT_ADDRESS();
        this.contractCode = Keccak256$.MODULE$.hash("McAddrOwnershipSmartContractCode");
    }
}

