/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.state;

import io.horizen.account.state.GasUintOverflowException;
import io.horizen.account.state.receipt.EthereumConsensusDataLog;
import io.horizen.account.transaction.EthereumTransaction;
import io.horizen.account.utils.BigIntegerUtil$;
import java.math.BigInteger;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichByte$;

public final class GasUtil$ {
    public static GasUtil$ MODULE$;
    private final BigInteger TxGas;
    private final BigInteger TxGasContractCreation;
    private final BigInteger TxDataZeroGas;
    private final BigInteger TxDataNonZeroGasEIP2028;
    private final BigInteger ColdAccountAccessCostEIP2929;
    private final BigInteger WarmStorageReadCostEIP2929;
    private final BigInteger ColdSloadCostEIP2929;
    private final BigInteger SstoreSentryGasEIP2200;
    private final BigInteger SstoreSetGasEIP2200;
    private final BigInteger SstoreResetGasEIP2200;
    private final BigInteger SstoreClearsScheduleRefundEIP3529;
    private final BigInteger CopyGas;
    private final BigInteger LogGas;
    private final BigInteger LogTopicGas;
    private final BigInteger LogDataGas;
    private final BigInteger RefundQuotientEIP3529;

    static {
        new GasUtil$();
    }

    public BigInteger TxGas() {
        return this.TxGas;
    }

    public BigInteger TxGasContractCreation() {
        return this.TxGasContractCreation;
    }

    public BigInteger TxDataZeroGas() {
        return this.TxDataZeroGas;
    }

    public BigInteger TxDataNonZeroGasEIP2028() {
        return this.TxDataNonZeroGasEIP2028;
    }

    public BigInteger ColdAccountAccessCostEIP2929() {
        return this.ColdAccountAccessCostEIP2929;
    }

    public BigInteger WarmStorageReadCostEIP2929() {
        return this.WarmStorageReadCostEIP2929;
    }

    public BigInteger ColdSloadCostEIP2929() {
        return this.ColdSloadCostEIP2929;
    }

    public BigInteger SstoreSentryGasEIP2200() {
        return this.SstoreSentryGasEIP2200;
    }

    public BigInteger SstoreSetGasEIP2200() {
        return this.SstoreSetGasEIP2200;
    }

    public BigInteger SstoreResetGasEIP2200() {
        return this.SstoreResetGasEIP2200;
    }

    public BigInteger SstoreClearsScheduleRefundEIP3529() {
        return this.SstoreClearsScheduleRefundEIP3529;
    }

    public BigInteger CopyGas() {
        return this.CopyGas;
    }

    public BigInteger LogGas() {
        return this.LogGas;
    }

    public BigInteger LogTopicGas() {
        return this.LogTopicGas;
    }

    public BigInteger LogDataGas() {
        return this.LogDataGas;
    }

    public BigInteger RefundQuotientEIP3529() {
        return this.RefundQuotientEIP3529;
    }

    /*
     * WARNING - void declaration
     */
    public BigInteger intrinsicGas(byte[] data, boolean isContractCreation) {
        void var3_3;
        BigInteger gas;
        BigInteger bigInteger = gas = isContractCreation ? this.TxGasContractCreation() : this.TxGas();
        if (data != null && data.length > 0) {
            int nonZeroElements = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(data)).count((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)GasUtil$.$anonfun$intrinsicGas$1(BoxesRunTime.unboxToByte((Object)x$1))));
            int zeroElements = data.length - nonZeroElements;
            gas = gas.add(this.TxDataNonZeroGasEIP2028().multiply(BigInteger.valueOf(nonZeroElements)));
            if (!BigIntegerUtil$.MODULE$.isUint64(gas = gas.add(this.TxDataZeroGas().multiply(BigInteger.valueOf(zeroElements))))) {
                throw new GasUintOverflowException();
            }
        }
        return var3_3;
    }

    public BigInteger logGas(EthereumConsensusDataLog log) {
        return this.LogGas().add(this.LogTopicGas().multiply(BigInteger.valueOf(log.topics().length))).add(this.LogDataGas().multiply(BigInteger.valueOf(log.data().length)));
    }

    public BigInteger codeCopy(int size) {
        BigInteger words = BigInteger.valueOf((size + 31) / 32);
        return this.CopyGas().multiply(words);
    }

    public Tuple2<BigInteger, BigInteger> getTxFeesPerGas(EthereumTransaction tx, BigInteger baseFeePerGas) {
        Tuple2 tuple2;
        if (tx.isEIP1559()) {
            BigInteger maxFeePerGas = tx.getMaxFeePerGas();
            BigInteger maxPriorityFeePerGas = tx.getMaxPriorityFeePerGas();
            BigInteger forgerTipPerGas = baseFeePerGas.add(maxPriorityFeePerGas).compareTo(maxFeePerGas) > 0 ? maxFeePerGas.subtract(baseFeePerGas) : maxPriorityFeePerGas;
            tuple2 = new Tuple2((Object)baseFeePerGas, (Object)forgerTipPerGas);
        } else {
            tuple2 = new Tuple2((Object)baseFeePerGas, (Object)tx.getGasPrice().subtract(baseFeePerGas));
        }
        return tuple2;
    }

    public static final /* synthetic */ boolean $anonfun$intrinsicGas$1(byte x$1) {
        return RichByte$.MODULE$.signum$extension(Predef$.MODULE$.byteWrapper(x$1)) != 0;
    }

    private GasUtil$() {
        MODULE$ = this;
        this.TxGas = BigInteger.valueOf(21000L);
        this.TxGasContractCreation = BigInteger.valueOf(53000L);
        this.TxDataZeroGas = BigInteger.valueOf(4L);
        this.TxDataNonZeroGasEIP2028 = BigInteger.valueOf(16L);
        this.ColdAccountAccessCostEIP2929 = BigInteger.valueOf(2600L);
        this.WarmStorageReadCostEIP2929 = BigInteger.valueOf(100L);
        this.ColdSloadCostEIP2929 = BigInteger.valueOf(2100L);
        this.SstoreSentryGasEIP2200 = BigInteger.valueOf(2300L);
        this.SstoreSetGasEIP2200 = BigInteger.valueOf(20000L);
        this.SstoreResetGasEIP2200 = BigInteger.valueOf(5000L);
        this.SstoreClearsScheduleRefundEIP3529 = BigInteger.valueOf(4800L);
        this.CopyGas = BigInteger.valueOf(3L);
        this.LogGas = BigInteger.valueOf(375L);
        this.LogTopicGas = BigInteger.valueOf(375L);
        this.LogDataGas = BigInteger.valueOf(8L);
        this.RefundQuotientEIP3529 = BigInteger.valueOf(5L);
    }
}

