/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.state;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.account.state.OutOfGasException;
import java.math.BigInteger;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import sparkz.util.SparkzLogging;

@ScalaSignature(bytes="\u0006\u000193Aa\u0003\u0007\u0001+!AA\u0005\u0001BC\u0002\u0013\u0005Q\u0005\u0003\u0005/\u0001\t\u0005\t\u0015!\u0003'\u0011\u0015y\u0003\u0001\"\u00011\u0011\u001d!\u0004\u00011A\u0005\n\u0015Bq!\u000e\u0001A\u0002\u0013%a\u0007\u0003\u0004=\u0001\u0001\u0006KA\n\u0005\u0006{\u0001!\t!\n\u0005\u0006}\u0001!\t!\n\u0005\u0006\u007f\u0001!\t\u0001\u0011\u0005\u0006\u0017\u0002!\t\u0001\u0014\u0002\b\u000f\u0006\u001c\bk\\8m\u0015\tia\"A\u0003ti\u0006$XM\u0003\u0002\u0010!\u00059\u0011mY2pk:$(BA\t\u0013\u0003\u001dAwN]5{K:T\u0011aE\u0001\u0003S>\u001c\u0001aE\u0002\u0001-q\u0001\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u0011a!\u00118z%\u00164\u0007CA\u000f#\u001b\u0005q\"BA\u0010!\u0003\u0011)H/\u001b7\u000b\u0003\u0005\naa\u001d9be.T\u0018BA\u0012\u001f\u00055\u0019\u0006/\u0019:lu2{wmZ5oO\u0006Q\u0011N\\5uS\u0006dw)Y:\u0016\u0003\u0019\u0002\"a\n\u0017\u000e\u0003!R!!\u000b\u0016\u0002\t5\fG\u000f\u001b\u0006\u0002W\u0005!!.\u0019<b\u0013\ti\u0003F\u0001\u0006CS\u001eLe\u000e^3hKJ\f1\"\u001b8ji&\fGnR1tA\u00051A(\u001b8jiz\"\"!M\u001a\u0011\u0005I\u0002Q\"\u0001\u0007\t\u000b\u0011\u001a\u0001\u0019\u0001\u0014\u0002\u0015\r,(O]3oi\u001e\u000b7/\u0001\bdkJ\u0014XM\u001c;HCN|F%Z9\u0015\u0005]R\u0004CA\f9\u0013\tI\u0004D\u0001\u0003V]&$\bbB\u001e\u0006\u0003\u0003\u0005\rAJ\u0001\u0004q\u0012\n\u0014aC2veJ,g\u000e^$bg\u0002\naaZ3u\u000f\u0006\u001c\u0018AC4fiV\u001bX\rZ$bg\u000611/\u001e2HCN$\"aN!\t\u000b\tK\u0001\u0019\u0001\u0014\u0002\u0007\u001d\f7\u000fK\u0002\n\t*\u00032aF#H\u0013\t1\u0005D\u0001\u0004uQJ|wo\u001d\t\u0003e!K!!\u0013\u0007\u0003#=+Ho\u00144HCN,\u0005pY3qi&|gnI\u0001H\u0003\u0019\tG\rZ$bgR\u0011q'\u0014\u0005\u0006\u0005*\u0001\rA\n")
public class GasPool
implements SparkzLogging {
    private final BigInteger initialGas;
    private BigInteger currentGas;
    private final Logger logger;

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public BigInteger initialGas() {
        return this.initialGas;
    }

    private BigInteger currentGas() {
        return this.currentGas;
    }

    private void currentGas_$eq(BigInteger x$1) {
        this.currentGas = x$1;
    }

    public BigInteger getGas() {
        return this.currentGas();
    }

    public BigInteger getUsedGas() {
        return this.initialGas().subtract(this.currentGas());
    }

    public void subGas(BigInteger gas) throws OutOfGasException {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (gas.signum() == -1) {
            throw new IllegalArgumentException("cannot consume a negative amount of gas");
        }
        if (this.currentGas().compareTo(gas) < 0) {
            throw new OutOfGasException(new StringBuilder(39).append("trying to remove gas=").append(gas).append(" from current-gas=").append(this.currentGas()).toString());
        }
        if (this.log().underlying().isTraceEnabled()) {
            this.log().underlying().trace("subtracting {} from currentGas={}", (Object[])new BigInteger[]{gas, this.currentGas()});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        this.currentGas_$eq(this.currentGas().subtract(gas));
        if (this.log().underlying().isTraceEnabled()) {
            this.log().underlying().trace("---> currentGas={}", new Object[]{this.currentGas()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void addGas(BigInteger gas) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (gas.signum() == -1) {
            throw new IllegalArgumentException("cannot return a negative amount of gas");
        }
        if (this.log().underlying().isTraceEnabled()) {
            this.log().underlying().trace("adding {} to currentGas={}", (Object[])new BigInteger[]{gas, this.currentGas()});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        BigInteger sum = this.currentGas().add(gas);
        if (sum.compareTo(this.initialGas()) > 0) {
            throw new IllegalArgumentException("cannot return more gas than was used");
        }
        this.currentGas_$eq(sum);
        if (this.log().underlying().isTraceEnabled()) {
            this.log().underlying().trace("---> currentGas={}", new Object[]{this.currentGas()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public GasPool(BigInteger initialGas) {
        this.initialGas = initialGas;
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
        this.currentGas = initialGas;
    }
}

