/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.state;

import com.google.common.primitives.Bytes;
import io.horizen.account.abi.ABIUtil;
import io.horizen.account.fork.Version1_2_0Fork$;
import io.horizen.account.proof.SignatureSecp256k1;
import io.horizen.account.proposition.AddressProposition;
import io.horizen.account.state.AccountForgingStakeInfo;
import io.horizen.account.state.AccountForgingStakeInfoListEncoder$;
import io.horizen.account.state.AddNewStakeCmdInput;
import io.horizen.account.state.AddNewStakeCmdInputDecoder$;
import io.horizen.account.state.BaseAccountStateView;
import io.horizen.account.state.ExecutionContext;
import io.horizen.account.state.ExecutionFailedException;
import io.horizen.account.state.ExecutionRevertedException;
import io.horizen.account.state.ForgerPublicKeys;
import io.horizen.account.state.ForgerStakeData;
import io.horizen.account.state.ForgerStakeDataSerializer$;
import io.horizen.account.state.ForgerStakeLinkedList$;
import io.horizen.account.state.ForgerStakeMsgProcessor$;
import io.horizen.account.state.ForgerStakesProvider;
import io.horizen.account.state.Invocation;
import io.horizen.account.state.Invocation$;
import io.horizen.account.state.Message;
import io.horizen.account.state.MessageProcessorInitializationException;
import io.horizen.account.state.NativeSmartContractMsgProcessor;
import io.horizen.account.state.NativeSmartContractMsgProcessor$;
import io.horizen.account.state.OpenStakeForgerListCmdInput;
import io.horizen.account.state.OpenStakeForgerListCmdInputDecoder$;
import io.horizen.account.state.RemoveStakeCmdInput;
import io.horizen.account.state.RemoveStakeCmdInputDecoder$;
import io.horizen.account.state.events.DelegateForgerStake;
import io.horizen.account.state.events.DelegateForgerStake$;
import io.horizen.account.state.events.OpenForgerList;
import io.horizen.account.state.events.OpenForgerList$;
import io.horizen.account.state.events.WithdrawForgerStake;
import io.horizen.account.state.events.WithdrawForgerStake$;
import io.horizen.account.state.receipt.EthereumConsensusDataLog;
import io.horizen.account.utils.WellKnownAddresses$;
import io.horizen.account.utils.ZenWeiConverter$;
import io.horizen.evm.Address;
import io.horizen.params.NetworkParams;
import io.horizen.proof.Signature25519;
import io.horizen.proposition.PublicKey25519Proposition;
import io.horizen.proposition.VrfPublicKey;
import io.horizen.utils.BytesUtils;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.List;
import java.util.Optional;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sparkz.crypto.hash.Keccak256$;

@ScalaSignature(bytes="\u0006\u0001\r}a\u0001\u0002!B\u0001*C\u0001b\u0017\u0001\u0003\u0016\u0004%\t\u0001\u0018\u0005\tE\u0002\u0011\t\u0012)A\u0005;\")1\r\u0001C\u0001I\"9q\r\u0001b\u0001\n\u0003B\u0007BB8\u0001A\u0003%\u0011\u000eC\u0004q\u0001\t\u0007I\u0011I9\t\ra\u0004\u0001\u0015!\u0003s\u0011\u001dI\bA1A\u0005\u0002qCaA\u001f\u0001!\u0002\u0013i\u0006\"B>\u0001\t\u0003a\bbBA\u0003\u0001\u0011\u0005\u0013q\u0001\u0005\b\u0003G\u0001A\u0011AA\u0013\u0011\u001d\t\u0019\u0004\u0001C\u0001\u0003kAq!!\u001c\u0001\t\u0013\ty\u0007C\u0004\u0002v\u0001!\t%a\u001e\t\u000f\u00055\u0005\u0001\"\u0001\u0002\u0010\"I\u00111\u0015\u0001\u0012\u0002\u0013\u0005\u0011Q\u0015\u0005\b\u0003w\u0003A\u0011BA_\u0011\u001d\t\u0019\r\u0001C!\u0003\u000bDq!a:\u0001\t\u0003\tI\u000fC\u0004\u0002n\u0002!\t!a<\t\u000f\u0005U\b\u0001\"\u0001\u0002x\"9\u0011q \u0001\u0005\n\t\u0005\u0001b\u0002B\u0003\u0001\u0011\u0005!q\u0001\u0005\b\u0005\u001f\u0001A\u0011\tB\t\u0011!\u0011\t\u0004\u0001C!\u000b\nM\u0002\u0002\u0003B#\u0001\u0011\u0005SIa\u0012\t\u000f\t-\u0003\u0001\"\u0003\u0003N!A!1\u000b\u0001\u0005B\u0015\u0013)\u0006C\u0005\u0003\\\u0001\t\t\u0011\"\u0001\u0003^!I!\u0011\r\u0001\u0012\u0002\u0013\u0005!1\r\u0005\n\u0005O\u0002\u0011\u0011!C!\u0005SB\u0011Ba\u001e\u0001\u0003\u0003%\tA!\u001f\t\u0013\tm\u0004!!A\u0005\u0002\tu\u0004\"\u0003BE\u0001\u0005\u0005I\u0011\tBF\u0011%\u0011I\nAA\u0001\n\u0003\u0011Y\nC\u0005\u0003 \u0002\t\t\u0011\"\u0011\u0003\"\"I!1\u0015\u0001\u0002\u0002\u0013\u0005#Q\u0015\u0005\n\u0005O\u0003\u0011\u0011!C!\u0005S;qA!,B\u0011\u0003\u0011yK\u0002\u0004A\u0003\"\u0005!\u0011\u0017\u0005\u0007G&\"\tA!/\t\u0011\tm\u0016F1A\u0005\u0002EDqA!0*A\u0003%!\u000f\u0003\u0005\u0003@&\u0012\r\u0011\"\u0001r\u0011\u001d\u0011\t-\u000bQ\u0001\nID\u0001Ba1*\u0005\u0004%\t!\u001d\u0005\b\u0005\u000bL\u0003\u0015!\u0003s\u0011%\u00119-\u000bb\u0001\n\u0003\u0011I\r\u0003\u0005\u0003Z&\u0002\u000b\u0011\u0002Bf\u0011%\u0011Y.\u000bb\u0001\n\u0003\u0011I\r\u0003\u0005\u0003^&\u0002\u000b\u0011\u0002Bf\u0011%\u0011y.\u000bb\u0001\n\u0003\u0011I\r\u0003\u0005\u0003b&\u0002\u000b\u0011\u0002Bf\u0011%\u0011\u0019/\u000bb\u0001\n\u0003\u0011I\r\u0003\u0005\u0003f&\u0002\u000b\u0011\u0002Bf\u0011%\u00119/\u000bb\u0001\n\u0003\u0011I\r\u0003\u0005\u0003j&\u0002\u000b\u0011\u0002Bf\u0011\u001d\u0011Y/\u000bC\u0001\u0005[DqA!?*\t\u0003\u0011Y\u0010C\u0005\u0004\u0006%\n\t\u0011\"!\u0004\b!I11B\u0015\u0002\u0002\u0013\u00055Q\u0002\u0005\n\u0007+I\u0013\u0011!C\u0005\u0007/\u0011qCR8sO\u0016\u00148\u000b^1lK6\u001bx\r\u0015:pG\u0016\u001c8o\u001c:\u000b\u0005\t\u001b\u0015!B:uCR,'B\u0001#F\u0003\u001d\t7mY8v]RT!AR$\u0002\u000f!|'/\u001b>f]*\t\u0001*\u0001\u0002j_\u000e\u00011#\u0002\u0001L\u001fJC\u0006C\u0001'N\u001b\u0005\t\u0015B\u0001(B\u0005}q\u0015\r^5wKNk\u0017M\u001d;D_:$(/Y2u\u001bN<\u0007K]8dKN\u001cxN\u001d\t\u0003\u0019BK!!U!\u0003)\u0019{'oZ3s'R\f7.Z:Qe>4\u0018\u000eZ3s!\t\u0019f+D\u0001U\u0015\u0005)\u0016!B:dC2\f\u0017BA,U\u0005\u001d\u0001&o\u001c3vGR\u0004\"aU-\n\u0005i#&\u0001D*fe&\fG.\u001b>bE2,\u0017A\u00029be\u0006l7/F\u0001^!\tq\u0006-D\u0001`\u0015\tYV)\u0003\u0002b?\nia*\u001a;x_J\\\u0007+\u0019:b[N\fq\u0001]1sC6\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\u0003K\u001a\u0004\"\u0001\u0014\u0001\t\u000bm\u001b\u0001\u0019A/\u0002\u001f\r|g\u000e\u001e:bGR\fE\r\u001a:fgN,\u0012!\u001b\t\u0003U6l\u0011a\u001b\u0006\u0003Y\u0016\u000b1!\u001a<n\u0013\tq7NA\u0004BI\u0012\u0014Xm]:\u0002!\r|g\u000e\u001e:bGR\fE\r\u001a:fgN\u0004\u0013\u0001D2p]R\u0014\u0018m\u0019;D_\u0012,W#\u0001:\u0011\u0007M\u001bX/\u0003\u0002u)\n)\u0011I\u001d:bsB\u00111K^\u0005\u0003oR\u0013AAQ=uK\u0006i1m\u001c8ue\u0006\u001cGoQ8eK\u0002\nQB\\3uo>\u00148\u000eU1sC6\u001c\u0018A\u00048fi^|'o\u001b)be\u0006l7\u000fI\u0001\u000bO\u0016$8\u000b^1lK&#GC\u0001:~\u0011\u0015q(\u00021\u0001\u0000\u0003\ri7o\u001a\t\u0004\u0019\u0006\u0005\u0011bAA\u0002\u0003\n9Q*Z:tC\u001e,\u0017\u0001B5oSR$b!!\u0003\u0002\u0010\u0005e\u0001cA*\u0002\f%\u0019\u0011Q\u0002+\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003#Y\u0001\u0019AA\n\u0003\u00111\u0018.Z<\u0011\u00071\u000b)\"C\u0002\u0002\u0018\u0005\u0013ACQ1tK\u0006\u001b7m\\;oiN#\u0018\r^3WS\u0016<\bbBA\u000e\u0017\u0001\u0007\u0011QD\u0001\u0015G>t7/\u001a8tkN,\u0005o\\2i\u001dVl'-\u001a:\u0011\u0007M\u000by\"C\u0002\u0002\"Q\u00131!\u00138u\u0003=)\u00070[:ugN#\u0018m[3ECR\fGCBA\u0014\u0003[\ty\u0003E\u0002T\u0003SI1!a\u000bU\u0005\u001d\u0011un\u001c7fC:Dq!!\u0005\r\u0001\u0004\t\u0019\u0002\u0003\u0004\u000221\u0001\rA]\u0001\bgR\f7.Z%e\u00039\tG\r\u001a$pe\u001e,'o\u0015;bW\u0016$b\"!\u0003\u00028\u0005e\u00121HA&\u0003+\nI\u0006C\u0004\u0002\u00125\u0001\r!a\u0005\t\r\u0005ER\u00021\u0001s\u0011\u001d\ti$\u0004a\u0001\u0003\u007f\tAC\u00197pG.\u001c\u0016n\u001a8Qe>\u0004xn]5uS>t\u0007\u0003BA!\u0003\u000fj!!a\u0011\u000b\u0007\u0005\u0015S)A\u0006qe>\u0004xn]5uS>t\u0017\u0002BA%\u0003\u0007\u0012\u0011\u0004U;cY&\u001c7*Z=3kU\n\u0014\b\u0015:pa>\u001c\u0018\u000e^5p]\"9\u0011QJ\u0007A\u0002\u0005=\u0013\u0001\u0004<sMB+(\r\\5d\u0017\u0016L\b\u0003BA!\u0003#JA!a\u0015\u0002D\taaK\u001d4Qk\nd\u0017nY&fs\"1\u0011qK\u0007A\u0002%\fab\\<oKJ\u0004VO\u00197jG.+\u0017\u0010C\u0004\u0002\\5\u0001\r!!\u0018\u0002\u0019M$\u0018m[3e\u00036|WO\u001c;\u0011\t\u0005}\u0013\u0011N\u0007\u0003\u0003CRA!a\u0019\u0002f\u0005!Q.\u0019;i\u0015\t\t9'\u0001\u0003kCZ\f\u0017\u0002BA6\u0003C\u0012!BQ5h\u0013:$XmZ3s\u0003E\u0011X-\\8wK\u001a{'oZ3s'R\f7.\u001a\u000b\u0007\u0003\u0013\t\t(a\u001d\t\u000f\u0005Ea\u00021\u0001\u0002\u0014!1\u0011\u0011\u0007\bA\u0002I\f\u0001$\u00193e'\u000e\u001c%/Z1uS>tgi\u001c:hKJ\u001cF/Y6f)%\u0011\u0018\u0011PA>\u0003\u007f\n\u0019\tC\u0004\u0002\u0012=\u0001\r!a\u0005\t\r\u0005ut\u00021\u0001j\u0003\u0015ywO\\3s\u0011\u001d\t\ti\u0004a\u0001\u0003;\nQA^1mk\u0016Dq!!\"\u0010\u0001\u0004\t9)\u0001\u0003eCR\f\u0007c\u0001'\u0002\n&\u0019\u00111R!\u0003'\u0005#GMT3x'R\f7.Z\"nI&s\u0007/\u001e;\u0002!\u0011|\u0017\t\u001a3OK^\u001cF/Y6f\u00076$G#\u0003:\u0002\u0012\u0006m\u0015QTAP\u0011\u001d\t\u0019\n\u0005a\u0001\u0003+\u000b!\"\u001b8w_\u000e\fG/[8o!\ra\u0015qS\u0005\u0004\u00033\u000b%AC%om>\u001c\u0017\r^5p]\"9\u0011\u0011\u0003\tA\u0002\u0005M\u0001\"\u0002@\u0011\u0001\u0004y\b\"CAQ!A\u0005\t\u0019AA\u0014\u0003MI7oR3oKNL7oU2De\u0016\fG/[8o\u0003i!w.\u00113e\u001d\u0016<8\u000b^1lK\u000ekG\r\n3fM\u0006,H\u000e\u001e\u00135+\t\t9K\u000b\u0003\u0002(\u0005%6FAAV!\u0011\ti+a.\u000e\u0005\u0005=&\u0002BAY\u0003g\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005UF+\u0001\u0006b]:|G/\u0019;j_:LA!!/\u00020\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00021\rDWmY6HKRd\u0015n\u001d;PM\u001a{'oZ3sg\u000ekG\r\u0006\u0003\u0002\n\u0005}\u0006BBAa%\u0001\u0007!/\u0001\u0005dC2dG-\u0019;b\u0003Y9W\r\u001e'jgR|eMR8sO\u0016\u00148o\u0015;bW\u0016\u001cH\u0003BAd\u0003K\u0004b!!3\u0002Z\u0006}g\u0002BAf\u0003+tA!!4\u0002T6\u0011\u0011q\u001a\u0006\u0004\u0003#L\u0015A\u0002\u001fs_>$h(C\u0001V\u0013\r\t9\u000eV\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tY.!8\u0003\u0007M+\u0017OC\u0002\u0002XR\u00032\u0001TAq\u0013\r\t\u0019/\u0011\u0002\u0018\u0003\u000e\u001cw.\u001e8u\r>\u0014x-\u001b8h'R\f7.Z%oM>Dq!!\u0005\u0014\u0001\u0004\t\u0019\"\u0001\u0013e_Vs7\r[3dW\u0016$w)\u001a;MSN$xJ\u001a$pe\u001e,'o]*uC.,7oQ7e)\r\u0011\u00181\u001e\u0005\b\u0003#!\u0002\u0019AA\n\u0003U!wnR3u\u0019&\u001cHo\u00144G_J<WM]:D[\u0012$RA]Ay\u0003gDq!a%\u0016\u0001\u0004\t)\nC\u0004\u0002\u0012U\u0001\r!a\u0005\u0002!\u0011|'+Z7pm\u0016\u001cF/Y6f\u00076$Gc\u0002:\u0002z\u0006m\u0018Q \u0005\b\u0003'3\u0002\u0019AAK\u0011\u001d\t\tB\u0006a\u0001\u0003'AQA \fA\u0002}\f!dZ3u\u00032dwn^3e\r>\u0014x-\u001a:t\u0013:$W\r\u001f'jgR$2A\u001dB\u0002\u0011\u001d\t\tb\u0006a\u0001\u0003'\t\u0001\u0004Z8Pa\u0016t7\u000b^1lK\u001a{'oZ3s\u0019&\u001cHoQ7e)\u001d\u0011(\u0011\u0002B\u0006\u0005\u001bAq!a%\u0019\u0001\u0004\t)\nC\u0004\u0002\u0012a\u0001\r!a\u0005\t\u000byD\u0002\u0019A@\u0002\u000fA\u0014xnY3tgR9!Oa\u0005\u0003\u0016\t]\u0001bBAJ3\u0001\u0007\u0011Q\u0013\u0005\b\u0003#I\u0002\u0019AA\n\u0011\u001d\u0011I\"\u0007a\u0001\u00057\tqaY8oi\u0016DH\u000fE\u0002M\u0005;I1Aa\bB\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH\u000fK\u0003\u001a\u0005G\u0011y\u0003E\u0003T\u0005K\u0011I#C\u0002\u0003(Q\u0013a\u0001\u001e5s_^\u001c\bc\u0001'\u0003,%\u0019!QF!\u00031\u0015CXmY;uS>tg)Y5mK\u0012,\u0005pY3qi&|gn\t\u0002\u0003*\u0005ia-\u001b8e'R\f7.\u001a#bi\u0006$bA!\u000e\u0003B\t\r\u0003#B*\u00038\tm\u0012b\u0001B\u001d)\n1q\n\u001d;j_:\u00042\u0001\u0014B\u001f\u0013\r\u0011y$\u0011\u0002\u0010\r>\u0014x-\u001a:Ti\u0006\\W\rR1uC\"9\u0011\u0011\u0003\u000eA\u0002\u0005M\u0001BBA\u00195\u0001\u0007!/\u0001\tjg\u001a{'oZ3s\u0019&\u001cHo\u00149f]R!\u0011q\u0005B%\u0011\u001d\t\tb\u0007a\u0001\u0003'\t\u0011$[:G_J<WM\u001d'jgR|\u0005/\u001a8V]\u000eDWmY6fIR!\u0011q\u0005B(\u0011\u0019\u0011\t\u0006\ba\u0001e\u0006!A.[:u\u0003m9W\r^!mY><X\r\u001a$pe\u001e,'\u000fT5ti&sG-\u001a=fgR!!q\u000bB-!\u0019\tI-!7\u0002\u001e!9\u0011\u0011C\u000fA\u0002\u0005M\u0011\u0001B2paf$2!\u001aB0\u0011\u001dYf\u0004%AA\u0002u\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003f)\u001aQ,!+\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0011Y\u0007\u0005\u0003\u0003n\tMTB\u0001B8\u0015\u0011\u0011\t(!\u001a\u0002\t1\fgnZ\u0005\u0005\u0005k\u0012yG\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003;\ta\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0003\u0000\t\u0015\u0005cA*\u0003\u0002&\u0019!1\u0011+\u0003\u0007\u0005s\u0017\u0010C\u0005\u0003\b\n\n\t\u00111\u0001\u0002\u001e\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"A!$\u0011\r\t=%Q\u0013B@\u001b\t\u0011\tJC\u0002\u0003\u0014R\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u00119J!%\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003O\u0011i\nC\u0005\u0003\b\u0012\n\t\u00111\u0001\u0003\u0000\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002\u001e\u0005AAo\\*ue&tw\r\u0006\u0002\u0003l\u00051Q-];bYN$B!a\n\u0003,\"I!qQ\u0014\u0002\u0002\u0003\u0007!qP\u0001\u0018\r>\u0014x-\u001a:Ti\u0006\\W-T:h!J|7-Z:t_J\u0004\"\u0001T\u0015\u0014\t%\u0012\u0019\f\u0017\t\u0004'\nU\u0016b\u0001B\\)\n1\u0011I\\=SK\u001a$\"Aa,\u0002!1Kgn[3e\u0019&\u001cH\u000fV5q\u0017\u0016L\u0018!\u0005'j].,G\rT5tiRK\u0007oS3zA\u0005\u0019B*\u001b8lK\u0012d\u0015n\u001d;Ok2dg+\u00197vK\u0006!B*\u001b8lK\u0012d\u0015n\u001d;Ok2dg+\u00197vK\u0002\n\u0011DU3tiJL7\r^3e\r>\u0014x-\u001a:GY\u0006<7\u000fT5ti\u0006Q\"+Z:ue&\u001cG/\u001a3G_J<WM\u001d$mC\u001e\u001cH*[:uA\u0005\u0019r)\u001a;MSN$xJ\u001a$pe\u001e,'o]\"nIV\u0011!1\u001a\t\u0005\u0005\u001b\u0014)N\u0004\u0003\u0003P\nE\u0007cAAg)&\u0019!1\u001b+\u0002\rA\u0013X\rZ3g\u0013\u0011\u0011)Ha6\u000b\u0007\tMG+\u0001\u000bHKRd\u0015n\u001d;PM\u001a{'oZ3sg\u000ekG\rI\u0001\u000f\u0003\u0012$g*Z<Ti\u0006\\WmQ7e\u0003=\tE\r\u001a(foN#\u0018m[3D[\u0012\u0004\u0013A\u0004*f[>4Xm\u0015;bW\u0016\u001cU\u000eZ\u0001\u0010%\u0016lwN^3Ti\u0006\\WmQ7eA\u00051r\n]3o'R\f7.\u001a$pe\u001e,'\u000fT5ti\u000ekG-A\fPa\u0016t7\u000b^1lK\u001a{'oZ3s\u0019&\u001cHoQ7eA\u0005ir\n]3o'R\f7.\u001a$pe\u001e,'\u000fT5ti\u000ekGmQ8se\u0016\u001cG/\u0001\u0010Pa\u0016t7\u000b^1lK\u001a{'oZ3s\u0019&\u001cHoQ7e\u0007>\u0014(/Z2uA\u0005qr-\u001a;SK6|g/Z*uC.,7)\u001c3NKN\u001c\u0018mZ3U_NKwM\u001c\u000b\be\n=(\u0011\u001fB{\u0011\u0019\t\td\u000fa\u0001e\"1!1_\u001eA\u0002%\fAA\u001a:p[\"1!q_\u001eA\u0002I\fQA\\8oG\u0016\faeZ3u\u001fB,gn\u0015;bW\u00164uN]4fe2K7\u000f^\"nI6+7o]1hKR{7+[4o)\u001d\u0011(Q`B\u0001\u0007\u0007AqAa@=\u0001\u0004\ti\"A\u0006g_J<WM]%oI\u0016D\bB\u0002Bzy\u0001\u0007\u0011\u000e\u0003\u0004\u0003xr\u0002\rA]\u0001\u0006CB\u0004H.\u001f\u000b\u0004K\u000e%\u0001\"B.>\u0001\u0004i\u0016aB;oCB\u0004H.\u001f\u000b\u0005\u0007\u001f\u0019\t\u0002\u0005\u0003T\u0005oi\u0006\u0002CB\n}\u0005\u0005\t\u0019A3\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GCAB\r!\u0011\u0011iga\u0007\n\t\ru!q\u000e\u0002\u0007\u001f\nTWm\u0019;")
public class ForgerStakeMsgProcessor
extends NativeSmartContractMsgProcessor
implements ForgerStakesProvider,
Product,
scala.Serializable {
    private final NetworkParams params;
    private final Address contractAddress;
    private final byte[] contractCode;
    private final NetworkParams networkParams;

    public static Option<NetworkParams> unapply(ForgerStakeMsgProcessor forgerStakeMsgProcessor) {
        return ForgerStakeMsgProcessor$.MODULE$.unapply(forgerStakeMsgProcessor);
    }

    public static ForgerStakeMsgProcessor apply(NetworkParams networkParams) {
        return ForgerStakeMsgProcessor$.MODULE$.apply(networkParams);
    }

    public static byte[] getOpenStakeForgerListCmdMessageToSign(int n, Address address, byte[] byArray) {
        return ForgerStakeMsgProcessor$.MODULE$.getOpenStakeForgerListCmdMessageToSign(n, address, byArray);
    }

    public static byte[] getRemoveStakeCmdMessageToSign(byte[] byArray, Address address, byte[] byArray2) {
        return ForgerStakeMsgProcessor$.MODULE$.getRemoveStakeCmdMessageToSign(byArray, address, byArray2);
    }

    public static String OpenStakeForgerListCmdCorrect() {
        return ForgerStakeMsgProcessor$.MODULE$.OpenStakeForgerListCmdCorrect();
    }

    public static String OpenStakeForgerListCmd() {
        return ForgerStakeMsgProcessor$.MODULE$.OpenStakeForgerListCmd();
    }

    public static String RemoveStakeCmd() {
        return ForgerStakeMsgProcessor$.MODULE$.RemoveStakeCmd();
    }

    public static String AddNewStakeCmd() {
        return ForgerStakeMsgProcessor$.MODULE$.AddNewStakeCmd();
    }

    public static String GetListOfForgersCmd() {
        return ForgerStakeMsgProcessor$.MODULE$.GetListOfForgersCmd();
    }

    public static byte[] RestrictedForgerFlagsList() {
        return ForgerStakeMsgProcessor$.MODULE$.RestrictedForgerFlagsList();
    }

    public static byte[] LinkedListNullValue() {
        return ForgerStakeMsgProcessor$.MODULE$.LinkedListNullValue();
    }

    public static byte[] LinkedListTipKey() {
        return ForgerStakeMsgProcessor$.MODULE$.LinkedListTipKey();
    }

    public NetworkParams params() {
        return this.params;
    }

    @Override
    public Address contractAddress() {
        return this.contractAddress;
    }

    @Override
    public byte[] contractCode() {
        return this.contractCode;
    }

    public NetworkParams networkParams() {
        return this.networkParams;
    }

    public byte[] getStakeId(Message msg) {
        return Keccak256$.MODULE$.hash(Bytes.concat((byte[][])new byte[][]{msg.getFrom().toBytes(), msg.getNonce().toByteArray(), msg.getValue().toByteArray(), msg.getData()}));
    }

    @Override
    public void init(BaseAccountStateView view, int consensusEpochNumber) {
        super.init(view, consensusEpochNumber);
        byte[] initialTip = view.getAccountStorage(this.contractAddress(), ForgerStakeMsgProcessor$.MODULE$.LinkedListTipKey());
        if (!new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(initialTip)).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(NativeSmartContractMsgProcessor$.MODULE$.NULL_HEX_STRING_32()))) {
            throw new MessageProcessorInitializationException("initial tip already set");
        }
        view.updateAccountStorage(this.contractAddress(), ForgerStakeMsgProcessor$.MODULE$.LinkedListTipKey(), ForgerStakeMsgProcessor$.MODULE$.LinkedListNullValue());
        byte[] restrictForgerList = view.getAccountStorage(this.contractAddress(), ForgerStakeMsgProcessor$.MODULE$.RestrictedForgerFlagsList());
        if (!new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(restrictForgerList)).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(NativeSmartContractMsgProcessor$.MODULE$.NULL_HEX_STRING_32()))) {
            throw new MessageProcessorInitializationException("restrictForgerList already set");
        }
    }

    public boolean existsStakeData(BaseAccountStateView view, byte[] stakeId) {
        byte[] data = view.getAccountStorage(this.contractAddress(), stakeId);
        return !new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(data)).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(NativeSmartContractMsgProcessor$.MODULE$.NULL_HEX_STRING_32()));
    }

    public void addForgerStake(BaseAccountStateView view, byte[] stakeId, PublicKey25519Proposition blockSignProposition, VrfPublicKey vrfPublicKey, Address ownerPublicKey, BigInteger stakedAmount) {
        ForgerStakeLinkedList$.MODULE$.addNewNode(view, stakeId, this.contractAddress());
        ForgerStakeData forgerStakeData = new ForgerStakeData(new ForgerPublicKeys(blockSignProposition, vrfPublicKey), new AddressProposition(ownerPublicKey), stakedAmount);
        view.updateAccountStorageBytes(this.contractAddress(), stakeId, ForgerStakeDataSerializer$.MODULE$.toBytes(forgerStakeData));
    }

    private void removeForgerStake(BaseAccountStateView view, byte[] stakeId) {
        ForgerStakeLinkedList$.MODULE$.removeNode(view, stakeId, this.contractAddress());
        view.removeAccountStorageBytes(this.contractAddress(), stakeId);
    }

    @Override
    public byte[] addScCreationForgerStake(BaseAccountStateView view, Address owner, BigInteger value, AddNewStakeCmdInput data) {
        Message msg = new Message(owner, Optional.of(this.contractAddress()), BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, value, BigInteger.ONE.negate(), Bytes.concat((byte[][])new byte[][]{BytesUtils.fromHexString(ForgerStakeMsgProcessor$.MODULE$.AddNewStakeCmd()), data.encode()}), false);
        return this.doAddNewStakeCmd(Invocation$.MODULE$.fromMessage(msg), view, msg, true);
    }

    public byte[] doAddNewStakeCmd(Invocation invocation, BaseAccountStateView view, Message msg, boolean isGenesisScCreation) {
        BoxedUnit boxedUnit;
        if (msg.getNonce() == null) {
            throw new ExecutionRevertedException("Call must include a nonce");
        }
        BigInteger stakedAmount = invocation.value();
        if (stakedAmount.signum() <= 0) {
            throw new ExecutionRevertedException("Value must not be zero");
        }
        if (!ZenWeiConverter$.MODULE$.isValidZenAmount(stakedAmount)) {
            throw new ExecutionRevertedException(new StringBuilder(33).append("Value is not a legal wei amount: ").append(stakedAmount.toString()).toString());
        }
        if (!view.accountExists(invocation.caller()) && !isGenesisScCreation) {
            throw new ExecutionRevertedException(new StringBuilder(31).append("Sender account does not exist: ").append(invocation.caller()).toString());
        }
        byte[] inputParams = ABIUtil.getArgumentsFromData(invocation.input());
        AddNewStakeCmdInput cmdInput = (AddNewStakeCmdInput)AddNewStakeCmdInputDecoder$.MODULE$.decode(inputParams);
        PublicKey25519Proposition blockSignPublicKey = cmdInput.forgerPublicKeys().blockSignPublicKey();
        VrfPublicKey vrfPublicKey = cmdInput.forgerPublicKeys().vrfPublicKey();
        Address ownerAddress = cmdInput.ownerAddress();
        if (!view.isEoaAccount(cmdInput.ownerAddress())) {
            throw new ExecutionRevertedException("Owner account is not an EOA");
        }
        if (!(isGenesisScCreation || this.isForgerListOpen(view) || this.networkParams().allowedForgersList().contains((Object)new Tuple2((Object)blockSignPublicKey, (Object)vrfPublicKey)))) {
            throw new ExecutionRevertedException("Forger is not in the allowed list");
        }
        byte[] newStakeId = this.getStakeId(msg);
        if (this.existsStakeData(view, newStakeId)) {
            throw new ExecutionRevertedException(new StringBuilder(21).append("Stake ").append(BytesUtils.toHexString(newStakeId)).append(" already exists").toString());
        }
        this.addForgerStake(view, newStakeId, blockSignPublicKey, vrfPublicKey, ownerAddress, stakedAmount);
        if (this.log().underlying().isDebugEnabled()) {
            this.log().underlying().debug("Added stake to stateDb: newStakeId={}, blockSignPublicKey={}, vrfPublicKey={}, ownerAddress={}, stakedAmount={}", new Object[]{BytesUtils.toHexString(newStakeId), blockSignPublicKey, vrfPublicKey, ownerAddress, stakedAmount});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        DelegateForgerStake addNewStakeEvt = DelegateForgerStake$.MODULE$.apply(invocation.caller(), ownerAddress, newStakeId, stakedAmount);
        EthereumConsensusDataLog evmLog = this.getEthereumConsensusDataLog(addNewStakeEvt);
        view.addLog(evmLog);
        if (isGenesisScCreation) {
            view.addBalance(this.contractAddress(), stakedAmount);
        } else {
            view.subBalance(invocation.caller(), stakedAmount);
            view.addBalance(this.contractAddress(), stakedAmount);
        }
        return newStakeId;
    }

    public boolean doAddNewStakeCmd$default$4() {
        return false;
    }

    private void checkGetListOfForgersCmd(byte[] calldata) {
        if (ABIUtil.getArgumentsFromData(calldata).length > 0) {
            BoxedUnit boxedUnit;
            String msgStr = new StringBuilder(36).append("invalid msg data length: ").append(calldata.length).append(", expected ").append(4).toString();
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug(msgStr);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            throw new ExecutionRevertedException(msgStr);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Seq<AccountForgingStakeInfo> getListOfForgersStakes(BaseAccountStateView view) {
        void var3_2;
        Seq stakeList = (Seq)Nil$.MODULE$;
        byte[] nodeReference = view.getAccountStorage(this.contractAddress(), ForgerStakeMsgProcessor$.MODULE$.LinkedListTipKey());
        while (!ForgerStakeLinkedList$.MODULE$.linkedListNodeRefIsNull(nodeReference)) {
            AccountForgingStakeInfo accountForgingStakeInfo;
            byte[] prevNodeReference;
            block4: {
                Tuple2<AccountForgingStakeInfo, byte[]> tuple2;
                block3: {
                    tuple2 = ForgerStakeLinkedList$.MODULE$.getStakeListItem(view, nodeReference);
                    if (tuple2 == null) break block3;
                    AccountForgingStakeInfo item = (AccountForgingStakeInfo)tuple2._1();
                    prevNodeReference = (byte[])tuple2._2();
                    if (item == null) break block3;
                    accountForgingStakeInfo = item;
                    if (prevNodeReference != null) break block4;
                }
                throw new MatchError(tuple2);
            }
            byte[] byArray = prevNodeReference;
            Tuple2 tuple2 = new Tuple2((Object)accountForgingStakeInfo, (Object)byArray);
            Tuple2 tuple22 = tuple2;
            AccountForgingStakeInfo item = (AccountForgingStakeInfo)tuple22._1();
            byte[] prevNodeReference2 = (byte[])tuple22._2();
            AccountForgingStakeInfo accountForgingStakeInfo2 = item;
            stakeList = (Seq)stakeList.$plus$colon((Object)accountForgingStakeInfo2, Seq$.MODULE$.canBuildFrom());
            nodeReference = prevNodeReference2;
        }
        return var3_2;
    }

    public byte[] doUncheckedGetListOfForgersStakesCmd(BaseAccountStateView view) {
        Seq<AccountForgingStakeInfo> stakeList = this.getListOfForgersStakes(view);
        return AccountForgingStakeInfoListEncoder$.MODULE$.encode((List)JavaConverters$.MODULE$.seqAsJavaListConverter(stakeList).asJava());
    }

    public byte[] doGetListOfForgersCmd(Invocation invocation, BaseAccountStateView view) {
        if (invocation.value().signum() != 0) {
            throw new ExecutionRevertedException("Call value must be zero");
        }
        this.checkGetListOfForgersCmd(invocation.input());
        return this.doUncheckedGetListOfForgersStakesCmd(view);
    }

    public byte[] doRemoveStakeCmd(Invocation invocation, BaseAccountStateView view, Message msg) {
        boolean result;
        byte[] msgToSign;
        ForgerStakeData stakeData;
        if (msg.getNonce() == null) {
            throw new ExecutionRevertedException("Call must include a nonce");
        }
        if (invocation.value().signum() != 0) {
            throw new ExecutionRevertedException("Call value must be zero");
        }
        byte[] inputParams = ABIUtil.getArgumentsFromData(invocation.input());
        RemoveStakeCmdInput cmdInput = (RemoveStakeCmdInput)RemoveStakeCmdInputDecoder$.MODULE$.decode(inputParams);
        byte[] stakeId = cmdInput.stakeId();
        SignatureSecp256k1 signature = cmdInput.signature();
        Try try_ = Try$.MODULE$.apply((Function0)((JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ForgerStakeMsgProcessor.$anonfun$doRemoveStakeCmd$2(signature, stakeData = (ForgerStakeData)this.findStakeData(view, stakeId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new ExecutionRevertedException("No such stake id in state-db");
        }), msgToSign = ForgerStakeMsgProcessor$.MODULE$.getRemoveStakeCmdMessageToSign(stakeId, invocation.caller(), msg.getNonce().toByteArray()))));
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable ex = failure.exception();
                throw new ExecutionRevertedException(new StringBuilder(39).append("Could not verify ill-formed signature: ").append(ex.getMessage()).toString());
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        boolean bl = result = BoxesRunTime.unboxToBoolean((Object)success.value());
        boolean isValid = bl;
        if (!isValid) {
            throw new ExecutionRevertedException("Invalid signature");
        }
        this.removeForgerStake(view, stakeId);
        WithdrawForgerStake removeStakeEvt = WithdrawForgerStake$.MODULE$.apply(stakeData.ownerPublicKey().address(), stakeId);
        EthereumConsensusDataLog evmLog = this.getEthereumConsensusDataLog(removeStakeEvt);
        view.addLog(evmLog);
        view.subBalance(this.contractAddress(), stakeData.stakedAmount());
        view.addBalance(stakeData.ownerPublicKey().address(), stakeData.stakedAmount());
        return stakeId;
    }

    private byte[] getAllowedForgersIndexList(BaseAccountStateView view) {
        if (this.networkParams().allowedForgersList().isEmpty()) {
            throw new IllegalStateException("Illegal call when list of forger is empty");
        }
        byte[] restrictForgerList = view.getAccountStorage(this.contractAddress(), ForgerStakeMsgProcessor$.MODULE$.RestrictedForgerFlagsList());
        return new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(restrictForgerList)).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(NativeSmartContractMsgProcessor$.MODULE$.NULL_HEX_STRING_32())) ? new byte[this.networkParams().allowedForgersList().size()] : view.getAccountStorageBytes(this.contractAddress(), ForgerStakeMsgProcessor$.MODULE$.RestrictedForgerFlagsList());
    }

    public byte[] doOpenStakeForgerListCmd(Invocation invocation, BaseAccountStateView view, Message msg) {
        byte[] msgToSign;
        if (!this.networkParams().restrictForgers()) {
            throw new ExecutionRevertedException("Illegal call when list of forger is not restricted");
        }
        if (this.networkParams().allowedForgersList().isEmpty()) {
            throw new ExecutionRevertedException("Illegal call when list of forger is empty");
        }
        if (invocation.value().signum() != 0) {
            throw new ExecutionRevertedException("Call value must be zero");
        }
        byte[] inputParams = ABIUtil.getArgumentsFromData(invocation.input());
        OpenStakeForgerListCmdInput cmdInput = (OpenStakeForgerListCmdInput)OpenStakeForgerListCmdInputDecoder$.MODULE$.decode(inputParams);
        int forgerIndex = cmdInput.forgerIndex();
        Signature25519 signature = cmdInput.signature();
        if (this.networkParams().allowedForgersList().size() < forgerIndex + 1) {
            throw new ExecutionRevertedException(new StringBuilder(46).append("Invalid forgerIndex=").append(forgerIndex).append(": allowedForgersList size=").append(this.networkParams().allowedForgersList().size()).toString());
        }
        PublicKey25519Proposition blockSignerProposition = (PublicKey25519Proposition)((Tuple2)this.networkParams().allowedForgersList().apply(forgerIndex))._1();
        if (!signature.isValid(blockSignerProposition, msgToSign = ForgerStakeMsgProcessor$.MODULE$.getOpenStakeForgerListCmdMessageToSign(forgerIndex, invocation.caller(), msg.getNonce().toByteArray()))) {
            throw new ExecutionRevertedException(new StringBuilder(69).append("Invalid signature, could not validate against blockSignerProposition=").append(blockSignerProposition).toString());
        }
        byte[] restrictForgerList = this.getAllowedForgersIndexList(view);
        if (this.isForgerListOpenUnchecked(restrictForgerList)) {
            throw new ExecutionRevertedException("Forger list already open");
        }
        if (restrictForgerList[forgerIndex] == 1) {
            throw new ExecutionRevertedException("Forger index already processed");
        }
        restrictForgerList[forgerIndex] = 1;
        view.updateAccountStorageBytes(this.contractAddress(), ForgerStakeMsgProcessor$.MODULE$.RestrictedForgerFlagsList(), restrictForgerList);
        OpenForgerList addOpenStakeForgerListEvt = OpenForgerList$.MODULE$.apply(forgerIndex, invocation.caller(), blockSignerProposition);
        EthereumConsensusDataLog evmLog = this.getEthereumConsensusDataLog(addOpenStakeForgerListEvt);
        view.addLog(evmLog);
        return restrictForgerList;
    }

    @Override
    public byte[] process(Invocation invocation, BaseAccountStateView view, ExecutionContext context) throws ExecutionFailedException {
        byte[] byArray;
        BaseAccountStateView gasView = view.getGasTrackedView(invocation.gasPool());
        String string = ABIUtil.getFunctionSignature(invocation.input());
        String string2 = ForgerStakeMsgProcessor$.MODULE$.GetListOfForgersCmd();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            byArray = this.doGetListOfForgersCmd(invocation, gasView);
        } else {
            String string4 = ForgerStakeMsgProcessor$.MODULE$.AddNewStakeCmd();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                byArray = this.doAddNewStakeCmd(invocation, gasView, context.msg(), this.doAddNewStakeCmd$default$4());
            } else {
                String string6 = ForgerStakeMsgProcessor$.MODULE$.RemoveStakeCmd();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    byArray = this.doRemoveStakeCmd(invocation, gasView, context.msg());
                } else {
                    String string8 = ForgerStakeMsgProcessor$.MODULE$.OpenStakeForgerListCmd();
                    String string9 = string;
                    if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                        byArray = this.doOpenStakeForgerListCmd(invocation, gasView, context.msg());
                    } else {
                        String string10 = ForgerStakeMsgProcessor$.MODULE$.OpenStakeForgerListCmdCorrect();
                        String string11 = string;
                        if (!(string10 != null ? !string10.equals(string11) : string11 != null) && Version1_2_0Fork$.MODULE$.get(context.blockContext().consensusEpochNumber).active()) {
                            byArray = this.doOpenStakeForgerListCmd(invocation, gasView, context.msg());
                        } else {
                            throw new ExecutionRevertedException(new StringBuilder(23).append("op code not supported: ").append(string).toString());
                        }
                    }
                }
            }
        }
        return byArray;
    }

    @Override
    public Option<ForgerStakeData> findStakeData(BaseAccountStateView view, byte[] stakeId) {
        return ForgerStakeLinkedList$.MODULE$.findStakeData(view, stakeId);
    }

    @Override
    public boolean isForgerListOpen(BaseAccountStateView view) {
        boolean bl;
        if (this.params().restrictForgers()) {
            byte[] restrictForgerList = this.getAllowedForgersIndexList(view);
            bl = this.isForgerListOpenUnchecked(restrictForgerList);
        } else {
            bl = true;
        }
        return bl;
    }

    private boolean isForgerListOpenUnchecked(byte[] list) {
        return BoxesRunTime.unboxToByte((Object)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(list)).sum((Numeric)Numeric.ByteIsIntegral$.MODULE$)) > list.length / 2;
    }

    @Override
    public Seq<Object> getAllowedForgerListIndexes(BaseAccountStateView view) {
        Seq seq;
        if (this.params().restrictForgers()) {
            byte[] restrictForgerList = this.getAllowedForgersIndexList(view);
            seq = (Seq)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(restrictForgerList)).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToByte((Object)x$3)), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        } else {
            seq = (Seq)Nil$.MODULE$;
        }
        return seq;
    }

    public ForgerStakeMsgProcessor copy(NetworkParams params) {
        return new ForgerStakeMsgProcessor(params);
    }

    public NetworkParams copy$default$1() {
        return this.params();
    }

    public String productPrefix() {
        return "ForgerStakeMsgProcessor";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.params();
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ForgerStakeMsgProcessor;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ForgerStakeMsgProcessor)) return false;
        boolean bl = true;
        if (!bl) return false;
        ForgerStakeMsgProcessor forgerStakeMsgProcessor = (ForgerStakeMsgProcessor)x$1;
        NetworkParams networkParams = this.params();
        NetworkParams networkParams2 = forgerStakeMsgProcessor.params();
        if (networkParams == null) {
            if (networkParams2 != null) {
                return false;
            }
        } else if (!networkParams.equals(networkParams2)) return false;
        if (!forgerStakeMsgProcessor.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$doRemoveStakeCmd$2(SignatureSecp256k1 signature$1, ForgerStakeData stakeData$1, byte[] msgToSign$1) {
        return signature$1.isValid(stakeData$1.ownerPublicKey(), msgToSign$1);
    }

    public ForgerStakeMsgProcessor(NetworkParams params) {
        this.params = params;
        Product.$init$((Product)this);
        this.contractAddress = WellKnownAddresses$.MODULE$.FORGER_STAKE_SMART_CONTRACT_ADDRESS();
        this.contractCode = Keccak256$.MODULE$.hash("ForgerStakeSmartContractCode");
        this.networkParams = params;
    }
}

