/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.state;

import io.horizen.account.state.AccountForgingStakeInfo;
import io.horizen.account.state.BaseAccountStateView;
import io.horizen.account.state.ExecutionRevertedException;
import io.horizen.account.state.ForgerPublicKeys;
import io.horizen.account.state.ForgerStakeData;
import io.horizen.account.state.ForgerStakeDataSerializer$;
import io.horizen.account.state.ForgerStakeMsgProcessor$;
import io.horizen.account.state.MessageProcessorUtil;
import io.horizen.account.utils.WellKnownAddresses$;
import io.horizen.evm.Address;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class ForgerStakeLinkedList$
implements MessageProcessorUtil.NativeSmartContractLinkedList {
    public static ForgerStakeLinkedList$ MODULE$;
    private final byte[] listTipKey;
    private final byte[] listTipNullValue;

    static {
        new ForgerStakeLinkedList$();
    }

    @Override
    public Option<MessageProcessorUtil.LinkedListNode> getLinkedListNode(BaseAccountStateView view, byte[] nodeId, Address contract_address) {
        return MessageProcessorUtil.NativeSmartContractLinkedList.getLinkedListNode$(this, view, nodeId, contract_address);
    }

    @Override
    public void addNewNode(BaseAccountStateView view, byte[] dataId, Address contract_address) {
        MessageProcessorUtil.NativeSmartContractLinkedList.addNewNode$(this, view, dataId, contract_address);
    }

    @Override
    public Option<BoxedUnit> modifyNode(BaseAccountStateView view, byte[] nodeId, Address contract_address, Function1<MessageProcessorUtil.LinkedListNode, MessageProcessorUtil.LinkedListNode> modify) {
        return MessageProcessorUtil.NativeSmartContractLinkedList.modifyNode$(this, view, nodeId, contract_address, modify);
    }

    @Override
    public void removeNode(BaseAccountStateView view, byte[] dataId, Address contract_address) {
        MessageProcessorUtil.NativeSmartContractLinkedList.removeNode$(this, view, dataId, contract_address);
    }

    @Override
    public boolean linkedListNodeRefIsNull(byte[] ref) {
        return MessageProcessorUtil.NativeSmartContractLinkedList.linkedListNodeRefIsNull$(this, ref);
    }

    @Override
    public byte[] listTipKey() {
        return this.listTipKey;
    }

    @Override
    public byte[] listTipNullValue() {
        return this.listTipNullValue;
    }

    public Option<ForgerStakeData> findStakeData(BaseAccountStateView view, byte[] stakeId) {
        None$ none$;
        byte[] data = view.getAccountStorageBytes(WellKnownAddresses$.MODULE$.FORGER_STAKE_SMART_CONTRACT_ADDRESS(), stakeId);
        if (data.length == 0) {
            none$ = None$.MODULE$;
        } else {
            Try<ForgerStakeData> try_ = ForgerStakeDataSerializer$.MODULE$.parseBytesTry(data);
            if (!(try_ instanceof Success)) {
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable exception = failure.exception();
                    throw new ExecutionRevertedException("Error while parsing forger data.", exception);
                }
                throw new MatchError(try_);
            }
            Success success = (Success)try_;
            ForgerStakeData obj = (ForgerStakeData)success.value();
            Some some = new Some((Object)obj);
            none$ = some;
        }
        return none$;
    }

    public Tuple2<AccountForgingStakeInfo, byte[]> getStakeListItem(BaseAccountStateView view, byte[] tip) {
        if (this.linkedListNodeRefIsNull(tip)) {
            throw new ExecutionRevertedException("Tip has the null value, no list here");
        }
        MessageProcessorUtil.LinkedListNode node = (MessageProcessorUtil.LinkedListNode)this.getLinkedListNode(view, tip, WellKnownAddresses$.MODULE$.FORGER_STAKE_SMART_CONTRACT_ADDRESS()).get();
        ForgerStakeData stakeData = (ForgerStakeData)this.findStakeData(view, node.dataKey()).get();
        AccountForgingStakeInfo listItem = new AccountForgingStakeInfo(node.dataKey(), new ForgerStakeData(new ForgerPublicKeys(stakeData.forgerPublicKeys().blockSignPublicKey(), stakeData.forgerPublicKeys().vrfPublicKey()), stakeData.ownerPublicKey(), stakeData.stakedAmount()));
        byte[] prevNodeKey = node.previousNodeKey();
        return new Tuple2((Object)listItem, (Object)prevNodeKey);
    }

    private ForgerStakeLinkedList$() {
        MODULE$ = this;
        MessageProcessorUtil.NativeSmartContractLinkedList.$init$(this);
        this.listTipKey = ForgerStakeMsgProcessor$.MODULE$.LinkedListTipKey();
        this.listTipNullValue = ForgerStakeMsgProcessor$.MODULE$.LinkedListNullValue();
    }
}

