/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.state;

import io.horizen.account.fork.ContractInteroperabilityFork;
import io.horizen.account.state.BaseAccountStateView;
import io.horizen.account.state.BlockContext;
import io.horizen.account.state.ExecutionContext;
import io.horizen.account.state.ExecutionFailedException;
import io.horizen.account.state.ExecutionRevertedException;
import io.horizen.account.state.GasPool;
import io.horizen.account.state.HistoryBlockHashProvider;
import io.horizen.account.state.Invocation;
import io.horizen.account.state.MessageProcessor;
import io.horizen.evm.Address;
import io.horizen.evm.BlockHashCallback;
import io.horizen.evm.Evm;
import io.horizen.evm.EvmContext;
import io.horizen.evm.ExternalInvocation;
import io.horizen.evm.Hash;
import io.horizen.evm.InvocationCallback;
import io.horizen.evm.ResourceHandle;
import io.horizen.evm.Tracer;
import io.horizen.evm.results.InvocationResult;
import io.horizen.utils.BytesUtils;
import java.math.BigInteger;
import scala.Array;
import scala.Option;
import scala.compat.java8.OptionConverters;

public class EvmMessageProcessor
implements MessageProcessor {
    private Address[] nativeContractAddresses = null;

    private Address[] getNativeContractAddresses(BaseAccountStateView view) {
        if (this.nativeContractAddresses == null) {
            this.nativeContractAddresses = view.getNativeSmartContractAddressList();
        }
        assert (this.nativeContractAddresses != null) : "List of native smart contract addresses cannot be null";
        return this.nativeContractAddresses;
    }

    @Override
    public boolean customTracing() {
        return true;
    }

    @Override
    public void init(BaseAccountStateView view, int consensusEpochNumber) {
    }

    @Override
    public boolean canProcess(Invocation invocation, BaseAccountStateView view, int consensusEpochNumber) {
        Option<Address> to = invocation.callee();
        if (to.isEmpty()) {
            return true;
        }
        return view.isSmartContractAccount((Address)to.get());
    }

    @Override
    public byte[] process(Invocation invocation, BaseAccountStateView view, ExecutionContext context) throws ExecutionFailedException {
        BlockContext block = context.blockContext();
        EvmContext evmContext = new EvmContext(BigInteger.valueOf(block.chainID), block.forgerAddress, block.blockGasLimit, context.msg().getGasPrice(), BigInteger.valueOf(block.blockNumber), BigInteger.valueOf(block.timestamp), block.baseFee, block.random);
        try (BlockHashGetter blockHashGetter = new BlockHashGetter(block.blockHashProvider);){
            byte[] byArray;
            try (NativeContractProxy nativeContractProxy = new NativeContractProxy(context);){
                evmContext.setBlockHashCallback((BlockHashCallback)blockHashGetter);
                if (ContractInteroperabilityFork.get(block.consensusEpochNumber).active()) {
                    evmContext.setExternalContracts(this.getNativeContractAddresses(view));
                } else {
                    evmContext.setExternalContracts(new Address[0]);
                }
                evmContext.setExternalCallback((InvocationCallback)nativeContractProxy);
                evmContext.setTracer((Tracer)block.getTracer().orElse(null));
                evmContext.setInitialDepth(context.depth() - 1);
                io.horizen.evm.Invocation evmInvocation = new io.horizen.evm.Invocation(invocation.caller(), (Address)invocation.callee().getOrElse(() -> null), invocation.value(), invocation.input(), invocation.gasPool().getGas(), invocation.readOnly());
                InvocationResult result = Evm.Apply((ResourceHandle)view.getStateDbHandle(), (io.horizen.evm.Invocation)evmInvocation, (EvmContext)evmContext);
                BigInteger usedGas = invocation.gasPool().getGas().subtract(result.leftOverGas);
                invocation.gasPool().subGas(usedGas);
                if (result.reverted) {
                    throw new ExecutionRevertedException(result.returnData);
                }
                if (!result.executionError.isEmpty()) {
                    throw new ExecutionFailedException(result.executionError);
                }
                byArray = result.returnData;
            }
            return byArray;
        }
    }

    private static class NativeContractProxy
    extends InvocationCallback {
        private final ExecutionContext context;

        public NativeContractProxy(ExecutionContext context) {
            this.context = context;
        }

        private String nonEmptyErrorMessage(Exception exception) {
            String msg = exception.toString();
            if (msg == null || msg.isEmpty()) {
                msg = exception.getClass().getName();
            }
            return msg;
        }

        protected InvocationResult execute(ExternalInvocation invocation) {
            GasPool gasPool = new GasPool(invocation.gas);
            try {
                byte[] returnData = this.context.executeDepth(Invocation.apply(invocation.caller, (Option<Address>)Option.apply((Object)invocation.callee), invocation.value, (byte[])Option.apply((Object)invocation.input).getOrElse(Array::emptyByteArray), gasPool, invocation.readOnly), invocation.depth - 1);
                return new InvocationResult(returnData, gasPool.getGas(), "", false, null);
            }
            catch (ExecutionRevertedException e) {
                return new InvocationResult(e.returnData, gasPool.getGas(), this.nonEmptyErrorMessage(e), true, null);
            }
            catch (Exception e) {
                return new InvocationResult(new byte[0], gasPool.getGas(), this.nonEmptyErrorMessage(e), false, null);
            }
        }
    }

    private static class BlockHashGetter
    extends BlockHashCallback {
        private final HistoryBlockHashProvider provider;

        private BlockHashGetter(HistoryBlockHashProvider provider) {
            this.provider = provider;
        }

        protected Hash getBlockHash(BigInteger blockNumber) {
            return OptionConverters.toJava(this.provider.blockIdByHeight(blockNumber.intValueExact())).map(hex -> new Hash(BytesUtils.fromHexString(hex))).orElse(Hash.ZERO);
        }
    }
}

