/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.state;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import io.horizen.account.abi.ABIUtil;
import io.horizen.account.state.BaseAccountStateView;
import io.horizen.account.state.CertificateKeyRotationMsgProcessor$;
import io.horizen.account.state.CertificateKeysProvider;
import io.horizen.account.state.ExecutionContext;
import io.horizen.account.state.ExecutionFailedException;
import io.horizen.account.state.ExecutionRevertedException;
import io.horizen.account.state.Invocation;
import io.horizen.account.state.KeyRotationHistory;
import io.horizen.account.state.KeyRotationHistorySerializer$;
import io.horizen.account.state.NativeSmartContractMsgProcessor;
import io.horizen.account.state.SubmitKeyRotationCmdInput;
import io.horizen.account.state.SubmitKeyRotationCmdInputDecoder$;
import io.horizen.account.state.events.SubmitKeyRotation;
import io.horizen.account.state.events.SubmitKeyRotation$;
import io.horizen.account.state.receipt.EthereumConsensusDataLog;
import io.horizen.certificatesubmitter.keys.CertifiersKeys;
import io.horizen.certificatesubmitter.keys.KeyRotationProof;
import io.horizen.certificatesubmitter.keys.KeyRotationProofSerializer$;
import io.horizen.certificatesubmitter.keys.KeyRotationProofTypes$;
import io.horizen.cryptolibprovider.CryptoLibProvider$;
import io.horizen.evm.Address;
import io.horizen.params.NetworkParams;
import io.horizen.proof.SchnorrProof;
import io.horizen.proposition.SchnorrProposition;
import io.horizen.proposition.SchnorrPropositionSerializer;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sparkz.crypto.hash.Keccak256$;

@ScalaSignature(bytes="\u0006\u0001\rUa\u0001\u0002\u00192\u0001jB\u0001b\u0013\u0001\u0003\u0016\u0004%\t\u0001\u0014\u0005\t%\u0002\u0011\t\u0012)A\u0005\u001b\")1\u000b\u0001C\u0001)\"9q\u000b\u0001b\u0001\n\u0003B\u0006BB0\u0001A\u0003%\u0011\fC\u0004a\u0001\t\u0007I\u0011I1\t\r!\u0004\u0001\u0015!\u0003c\u0011\u0015I\u0007\u0001\"\u0011k\u0011!\t)\u0001\u0001C!k\u0005\u001d\u0001bBA\u0013\u0001\u0011%\u0011q\u0005\u0005\b\u0003\u0007\u0002A\u0011BA#\u0011!\ty\u0005\u0001C!k\u0005E\u0003\u0002CAG\u0001\u0011\u0005Q'a$\t\u000f\u0005u\u0005\u0001\"\u0003\u0002 \"9\u0011\u0011\u0017\u0001\u0005\n\u0005M\u0006bBA_\u0001\u0011%\u0011q\u0018\u0005\b\u0003\u0017\u0004A\u0011BAg\u0011\u001d\t)\u000e\u0001C\u0005\u0003/Dq!!@\u0001\t\u0013\ty\u0010C\u0004\u0003\b\u0001!IA!\u0003\t\u000f\t5\u0001\u0001\"\u0003\u0003\u0010!9!Q\u0003\u0001\u0005\n\t]\u0001b\u0002B\u0011\u0001\u0011%!1\u0005\u0005\b\u0005W\u0001A\u0011\u0002B\u0017\u0011\u001d\u0011\u0019\u0004\u0001C\u0005\u0005kA\u0011Ba\u000f\u0001\u0003\u0003%\tA!\u0010\t\u0013\t\u0005\u0003!%A\u0005\u0002\t\r\u0003\"\u0003B-\u0001\u0005\u0005I\u0011\tB.\u0011%\u0011i\u0007AA\u0001\n\u0003\u0011y\u0007C\u0005\u0003r\u0001\t\t\u0011\"\u0001\u0003t!I!q\u0010\u0001\u0002\u0002\u0013\u0005#\u0011\u0011\u0005\n\u0005\u001f\u0003\u0011\u0011!C\u0001\u0005#C\u0011Ba'\u0001\u0003\u0003%\tE!(\t\u0013\t}\u0005!!A\u0005B\t\u0005\u0006\"\u0003BR\u0001\u0005\u0005I\u0011\tBS\u000f\u001d\u0011I+\rE\u0001\u0005W3a\u0001M\u0019\t\u0002\t5\u0006BB*&\t\u0003\u0011)\f\u0003\u0005\u00038\u0016\u0012\r\u0011\"\u0001Y\u0011\u001d\u0011I,\nQ\u0001\neC\u0011Ba/&\u0005\u0004%\tA!0\t\u0011\t\u0015X\u0005)A\u0005\u0005\u007fC\u0011Ba:&\u0005\u0004%\tA!;\t\u0011\teX\u0005)A\u0005\u0005WD\u0011Ba?&\u0003\u0003%\tI!@\t\u0013\r\u0005Q%!A\u0005\u0002\u000e\r\u0001\"CB\u0006K\u0005\u0005I\u0011BB\u0007\u0005\t\u001aUM\u001d;jM&\u001c\u0017\r^3LKf\u0014v\u000e^1uS>tWj]4Qe>\u001cWm]:pe*\u0011!gM\u0001\u0006gR\fG/\u001a\u0006\u0003iU\nq!Y2d_VtGO\u0003\u00027o\u00059\u0001n\u001c:ju\u0016t'\"\u0001\u001d\u0002\u0005%|7\u0001A\n\u0006\u0001mz$\t\u0013\t\u0003yuj\u0011!M\u0005\u0003}E\u0012qDT1uSZ,7+\\1si\u000e{g\u000e\u001e:bGRl5o\u001a)s_\u000e,7o]8s!\ta\u0004)\u0003\u0002Bc\t92)\u001a:uS\u001aL7-\u0019;f\u0017\u0016L8\u000f\u0015:pm&$WM\u001d\t\u0003\u0007\u001ak\u0011\u0001\u0012\u0006\u0002\u000b\u0006)1oY1mC&\u0011q\t\u0012\u0002\b!J|G-^2u!\t\u0019\u0015*\u0003\u0002K\t\na1+\u001a:jC2L'0\u00192mK\u00061\u0001/\u0019:b[N,\u0012!\u0014\t\u0003\u001dBk\u0011a\u0014\u0006\u0003\u0017VJ!!U(\u0003\u001b9+Go^8sWB\u000b'/Y7t\u0003\u001d\u0001\u0018M]1ng\u0002\na\u0001P5oSRtDCA+W!\ta\u0004\u0001C\u0003L\u0007\u0001\u0007Q*A\bd_:$(/Y2u\u0003\u0012$'/Z:t+\u0005I\u0006C\u0001.^\u001b\u0005Y&B\u0001/6\u0003\r)g/\\\u0005\u0003=n\u0013q!\u00113ee\u0016\u001c8/\u0001\td_:$(/Y2u\u0003\u0012$'/Z:tA\u0005a1m\u001c8ue\u0006\u001cGoQ8eKV\t!\rE\u0002DG\u0016L!\u0001\u001a#\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\r3\u0017BA4E\u0005\u0011\u0011\u0015\u0010^3\u0002\u001b\r|g\u000e\u001e:bGR\u001cu\u000eZ3!\u0003\u001d\u0001(o\\2fgN$BAY6qk\")A\u000e\u0003a\u0001[\u0006Q\u0011N\u001c<pG\u0006$\u0018n\u001c8\u0011\u0005qr\u0017BA82\u0005)IeN^8dCRLwN\u001c\u0005\u0006c\"\u0001\rA]\u0001\u0005m&,w\u000f\u0005\u0002=g&\u0011A/\r\u0002\u0015\u0005\u0006\u001cX-Q2d_VtGo\u0015;bi\u00164\u0016.Z<\t\u000bYD\u0001\u0019A<\u0002\u000f\r|g\u000e^3yiB\u0011A\b_\u0005\u0003sF\u0012\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;)\t!Y\u00181\u0001\t\u0004\u0007rt\u0018BA?E\u0005\u0019!\bN]8xgB\u0011Ah`\u0005\u0004\u0003\u0003\t$\u0001G#yK\u000e,H/[8o\r\u0006LG.\u001a3Fq\u000e,\u0007\u000f^5p]\u000e\na0A\thKR\u001cUM\u001d;jM&,'o]&fsN$b!!\u0003\u0002\u001a\u0005\r\u0002\u0003BA\u0006\u0003+i!!!\u0004\u000b\t\u0005=\u0011\u0011C\u0001\u0005W\u0016L8OC\u0002\u0002\u0014U\nAcY3si&4\u0017nY1uKN,(-\\5ui\u0016\u0014\u0018\u0002BA\f\u0003\u001b\u0011abQ3si&4\u0017.\u001a:t\u0017\u0016L8\u000fC\u0004\u0002\u001c%\u0001\r!!\b\u0002\u0011\u0015\u0004xn\u00195Ok6\u00042aQA\u0010\u0013\r\t\t\u0003\u0012\u0002\u0004\u0013:$\b\"B9\n\u0001\u0004\u0011\u0018AE4fi2\u000bG/Z:u\u001b\u0006\u001cH/\u001a:LKf$\"\"!\u000b\u00026\u0005]\u00121HA !\u0011\tY#!\r\u000e\u0005\u00055\"bAA\u0018k\u0005Y\u0001O]8q_NLG/[8o\u0013\u0011\t\u0019$!\f\u0003%M\u001b\u0007N\\8seB\u0013x\u000e]8tSRLwN\u001c\u0005\u0006c*\u0001\rA\u001d\u0005\b\u0003sQ\u0001\u0019AA\u0015\u0003%\u0019wN\u001c4jO.+\u0017\u0010C\u0004\u0002>)\u0001\r!!\b\u0002\u001dI,\u0017/^3ti\u0016$W\t]8dQ\"9\u0011\u0011\t\u0006A\u0002\u0005u\u0011!B5oI\u0016D\u0018aE4fi2\u000bG/Z:u'&<g.\u001b8h\u0017\u0016LHCCA\u0015\u0003\u000f\nI%a\u0013\u0002N!)\u0011o\u0003a\u0001e\"9\u0011\u0011H\u0006A\u0002\u0005%\u0002bBA\u001f\u0017\u0001\u0007\u0011Q\u0004\u0005\b\u0003\u0003Z\u0001\u0019AA\u000f\u0003M9W\r^&fsJ{G/\u0019;j_:\u0004&o\\8g))\t\u0019&a\u0018\u0002b\u0005\r\u00141\u0012\t\u0006\u0007\u0006U\u0013\u0011L\u0005\u0004\u0003/\"%AB(qi&|g\u000e\u0005\u0003\u0002\f\u0005m\u0013\u0002BA/\u0003\u001b\u0011\u0001cS3z%>$\u0018\r^5p]B\u0013xn\u001c4\t\u000f\u0005mA\u00021\u0001\u0002\u001e!9\u0011\u0011\t\u0007A\u0002\u0005u\u0001bBA3\u0019\u0001\u0007\u0011qM\u0001\bW\u0016LH+\u001f9f!\u0011\tI'!\"\u000f\t\u0005-\u0014\u0011\u0011\b\u0005\u0003[\nyH\u0004\u0003\u0002p\u0005ud\u0002BA9\u0003wrA!a\u001d\u0002z5\u0011\u0011Q\u000f\u0006\u0004\u0003oJ\u0014A\u0002\u001fs_>$h(C\u00019\u0013\t1t'C\u0002\u0002\u0014UJA!a\u0004\u0002\u0012%!\u00111QA\u0007\u0003UYU-\u001f*pi\u0006$\u0018n\u001c8Qe>|g\rV=qKNLA!a\"\u0002\n\n!2*Z=S_R\fG/[8o!J|wN\u001a+za\u0016TA!a!\u0002\u000e!)\u0011\u000f\u0004a\u0001e\u00061r-\u001a;LKf\u001c(k\u001c;bi&|g\u000eS5ti>\u0014\u0018\u0010\u0006\u0005\u0002\u0012\u0006]\u0015\u0011TAN!\ra\u00141S\u0005\u0004\u0003+\u000b$AE&fsJ{G/\u0019;j_:D\u0015n\u001d;pefDq!!\u001a\u000e\u0001\u0004\t9\u0007C\u0004\u0002B5\u0001\r!!\b\t\u000bEl\u0001\u0019\u0001:\u0002+A,HoS3z%>$\u0018\r^5p]\"K7\u000f^8ssRQ\u0011\u0011UAT\u0003S\u000bY+!,\u0011\u0007\r\u000b\u0019+C\u0002\u0002&\u0012\u0013A!\u00168ji\"9\u0011Q\r\bA\u0002\u0005\u001d\u0004bBA!\u001d\u0001\u0007\u0011Q\u0004\u0005\u0006c:\u0001\rA\u001d\u0005\b\u0003_s\u0001\u0019AAI\u0003\u001dA\u0017n\u001d;pef\f1\u0003];u\u0017\u0016L(k\u001c;bi&|g\u000e\u0015:p_\u001a$\u0002\"!)\u00026\u0006]\u0016\u0011\u0018\u0005\b\u00037y\u0001\u0019AA\u000f\u0011\u0015\tx\u00021\u0001s\u0011\u001d\tYl\u0004a\u0001\u00033\n\u0001c[3z%>$\u0018\r^5p]B\u0013xn\u001c4\u0002\u001b\u001d,GoU5h]&twmS3z)!\t\t-a1\u0002H\u0006%\u0007#B\"\u0002V\u0005%\u0002bBAc!\u0001\u0007\u0011QD\u0001\fKB|7\r\u001b(v[\n,'\u000fC\u0004\u0002BA\u0001\r!!\b\t\u000bE\u0004\u0002\u0019\u0001:\u0002\u0019\u001d,G/T1ti\u0016\u00148*Z=\u0015\u0011\u0005\u0005\u0017qZAi\u0003'Dq!!2\u0012\u0001\u0004\ti\u0002C\u0004\u0002BE\u0001\r!!\b\t\u000bE\f\u0002\u0019\u0001:\u0002;\rDWmY6LKf\u0014v\u000e^1uS>t\u0007K]8pMZ\u000bG.\u001b3jif$\"\"!7\u0002f\u0006\u001d\u0018q_A~!\u0019\tY.!9\u0002\"6\u0011\u0011Q\u001c\u0006\u0004\u0003?$\u0015\u0001B;uS2LA!a9\u0002^\n\u0019AK]=\t\u000f\u0005m&\u00031\u0001\u0002Z!9\u0011\u0011\u001e\nA\u0002\u0005-\u0018a\u00048fo.+\u0017pU5h]\u0006$XO]3\u0011\t\u00055\u00181_\u0007\u0003\u0003_T1!!=6\u0003\u0015\u0001(o\\8g\u0013\u0011\t)0a<\u0003\u0019M\u001b\u0007N\\8seB\u0013xn\u001c4\t\u000f\u0005e(\u00031\u0001\u0002\u001e\u0005y1-\u001e:sK:$X\t]8dQ:+X\u000eC\u0003r%\u0001\u0007!/A\u000bfq\u0016\u001c7+\u001e2nSR\\U-\u001f*pi\u0006$\u0018n\u001c8\u0015\u000f\t\u0014\tAa\u0001\u0003\u0006!)An\u0005a\u0001[\")\u0011o\u0005a\u0001e\"9\u0011\u0011`\nA\u0002\u0005u\u0011aF2iK\u000e\\\u0017J\u001c<pG\u0006$\u0018n\u001c8WC2LG-\u001b;z)\u0011\t\tKa\u0003\t\u000b1$\u0002\u0019A7\u0002\u0019\r\fGnY;mCR,7*Z=\u0015\u0007\t\u0014\t\u0002\u0003\u0004\u0003\u0014U\u0001\rAY\u0001\bW\u0016L8+Z3e\u0003Y9W\r^&fsJ{G/\u0019;j_:\u0004&o\\8g\u0017\u0016LHc\u00022\u0003\u001a\tm!q\u0004\u0005\b\u0003K2\u0002\u0019AA4\u0011\u001d\u0011iB\u0006a\u0001\u0003;\tqb^5uQ\u0012\u0014\u0018m^1m\u000bB|7\r\u001b\u0005\b\u0003\u00032\u0002\u0019AA\u000f\u0003A9W\r^*jO:LgnZ&fs.+\u0017\u0010F\u0003c\u0005K\u0011I\u0003C\u0004\u0003(]\u0001\r!!\b\u0002\u000b\u0015\u0004xn\u00195\t\u000f\u0005\u0005s\u00031\u0001\u0002\u001e\u0005yq-\u001a;NCN$XM]&fs.+\u0017\u0010F\u0003c\u0005_\u0011\t\u0004C\u0004\u0003(a\u0001\r!!\b\t\u000f\u0005\u0005\u0003\u00041\u0001\u0002\u001e\u0005Ir-\u001a;LKf\u001c(k\u001c;bi&|g\u000eS5ti>\u0014\u0018pS3z)\u0015\u0011'q\u0007B\u001d\u0011\u001d\t)'\u0007a\u0001\u0003OBq!!\u0011\u001a\u0001\u0004\ti\"\u0001\u0003d_BLHcA+\u0003@!91J\u0007I\u0001\u0002\u0004i\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0005\u000bR3!\u0014B$W\t\u0011I\u0005\u0005\u0003\u0003L\tUSB\u0001B'\u0015\u0011\u0011yE!\u0015\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B*\t\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t]#Q\n\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003^A!!q\fB5\u001b\t\u0011\tG\u0003\u0003\u0003d\t\u0015\u0014\u0001\u00027b]\u001eT!Aa\u001a\u0002\t)\fg/Y\u0005\u0005\u0005W\u0012\tG\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003;\ta\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0003v\tm\u0004cA\"\u0003x%\u0019!\u0011\u0010#\u0003\u0007\u0005s\u0017\u0010C\u0005\u0003~y\t\t\u00111\u0001\u0002\u001e\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa!\u0011\r\t\u0015%1\u0012B;\u001b\t\u00119IC\u0002\u0003\n\u0012\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011iIa\"\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005'\u0013I\nE\u0002D\u0005+K1Aa&E\u0005\u001d\u0011un\u001c7fC:D\u0011B! !\u0003\u0003\u0005\rA!\u001e\u0002\u0011!\f7\u000f[\"pI\u0016$\"!!\b\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"A!\u0018\u0002\r\u0015\fX/\u00197t)\u0011\u0011\u0019Ja*\t\u0013\tu4%!AA\u0002\tU\u0014AI\"feRLg-[2bi\u0016\\U-\u001f*pi\u0006$\u0018n\u001c8Ng\u001e\u0004&o\\2fgN|'\u000f\u0005\u0002=KM!QEa,I!\r\u0019%\u0011W\u0005\u0004\u0005g#%AB!osJ+g\r\u0006\u0002\u0003,\u0006)3)\u001a:uS\u001aL7-\u0019;f\u0017\u0016L(k\u001c;bi&|gnQ8oiJ\f7\r^!eIJ,7o]\u0001'\u0007\u0016\u0014H/\u001b4jG\u0006$XmS3z%>$\u0018\r^5p]\u000e{g\u000e\u001e:bGR\fE\r\u001a:fgN\u0004\u0013AI\"feRLg-[2bi\u0016\\U-\u001f*pi\u0006$\u0018n\u001c8D_:$(/Y2u\u0007>$W-\u0006\u0002\u0003@B!!\u0011\u0019Bp\u001d\u0011\u0011\u0019M!7\u000f\t\t\u0015'1\u001b\b\u0005\u0005\u000f\u0014iM\u0004\u0003\u0002t\t%\u0017B\u0001Bf\u0003\u0019\u0019\b/\u0019:lu&!!q\u001aBi\u0003\u0019\u0019'/\u001f9u_*\u0011!1Z\u0005\u0005\u0005+\u00149.\u0001\u0003iCND'\u0002\u0002Bh\u0005#LAAa7\u0003^\u00069\u0001/Y2lC\u001e,'\u0002\u0002Bk\u0005/LAA!9\u0003d\nAA)[4fgR\u001c$G\u0003\u0003\u0003\\\nu\u0017aI\"feRLg-[2bi\u0016\\U-\u001f*pi\u0006$\u0018n\u001c8D_:$(/Y2u\u0007>$W\rI\u0001\u001b'V\u0014W.\u001b;LKf\u0014v\u000e^1uS>t'+Z9D[\u0012\u001c\u0016nZ\u000b\u0003\u0005W\u0004BA!<\u0003v:!!q\u001eBy!\r\t\u0019\bR\u0005\u0004\u0005g$\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0003l\t](b\u0001Bz\t\u0006Y2+\u001e2nSR\\U-\u001f*pi\u0006$\u0018n\u001c8SKF\u001cU\u000eZ*jO\u0002\nQ!\u00199qYf$2!\u0016B\u0000\u0011\u0015YU\u00061\u0001N\u0003\u001d)h.\u00199qYf$Ba!\u0002\u0004\bA!1)!\u0016N\u0011!\u0019IALA\u0001\u0002\u0004)\u0016a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0019y\u0001\u0005\u0003\u0003`\rE\u0011\u0002BB\n\u0005C\u0012aa\u00142kK\u000e$\b")
public class CertificateKeyRotationMsgProcessor
extends NativeSmartContractMsgProcessor
implements CertificateKeysProvider,
Product,
scala.Serializable {
    private final NetworkParams params;
    private final Address contractAddress;
    private final byte[] contractCode;

    public static Option<NetworkParams> unapply(CertificateKeyRotationMsgProcessor certificateKeyRotationMsgProcessor) {
        return CertificateKeyRotationMsgProcessor$.MODULE$.unapply(certificateKeyRotationMsgProcessor);
    }

    public static CertificateKeyRotationMsgProcessor apply(NetworkParams networkParams) {
        return CertificateKeyRotationMsgProcessor$.MODULE$.apply(networkParams);
    }

    public static String SubmitKeyRotationReqCmdSig() {
        return CertificateKeyRotationMsgProcessor$.MODULE$.SubmitKeyRotationReqCmdSig();
    }

    public static byte[] CertificateKeyRotationContractCode() {
        return CertificateKeyRotationMsgProcessor$.MODULE$.CertificateKeyRotationContractCode();
    }

    public static Address CertificateKeyRotationContractAddress() {
        return CertificateKeyRotationMsgProcessor$.MODULE$.CertificateKeyRotationContractAddress();
    }

    public NetworkParams params() {
        return this.params;
    }

    @Override
    public Address contractAddress() {
        return this.contractAddress;
    }

    @Override
    public byte[] contractCode() {
        return this.contractCode;
    }

    @Override
    public byte[] process(Invocation invocation, BaseAccountStateView view, ExecutionContext context) throws ExecutionFailedException {
        BaseAccountStateView gasView = view.getGasTrackedView(invocation.gasPool());
        String string = ABIUtil.getFunctionSignature(invocation.input());
        String string2 = CertificateKeyRotationMsgProcessor$.MODULE$.SubmitKeyRotationReqCmdSig();
        String string3 = string;
        if (string2 != null ? !string2.equals(string3) : string3 != null) {
            throw new ExecutionRevertedException(new StringBuilder(55).append("Requested function does not exist. Function signature: ").append(string).toString());
        }
        byte[] byArray = this.execSubmitKeyRotation(invocation, gasView, context.blockContext().withdrawalEpochNumber);
        return byArray;
    }

    @Override
    public CertifiersKeys getCertifiersKeys(int epochNum, BaseAccountStateView view) {
        Vector singingKeys = ((TraversableOnce)((TraversableLike)this.params().signersPublicKeys().zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)key_index -> this.getLatestSigningKey(view, (SchnorrProposition)key_index._1(), epochNum + 1, key_index._2$mcI$sp()), Seq$.MODULE$.canBuildFrom())).toVector();
        Vector masterKeys = ((TraversableOnce)((TraversableLike)this.params().mastersPublicKeys().zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)key_index -> this.getLatestMasterKey(view, (SchnorrProposition)key_index._1(), epochNum + 1, key_index._2$mcI$sp()), Seq$.MODULE$.canBuildFrom())).toVector();
        return new CertifiersKeys((Vector<SchnorrProposition>)singingKeys, (Vector<SchnorrProposition>)masterKeys);
    }

    private SchnorrProposition getLatestMasterKey(BaseAccountStateView view, SchnorrProposition configKey, int requestedEpoch, int index) {
        KeyRotationHistory masterKeyChangeHistory = this.getKeysRotationHistory(KeyRotationProofTypes$.MODULE$.MasterKeyRotationProofType(), index, view);
        return (SchnorrProposition)masterKeyChangeHistory.epochNumbers().find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$1 -> x$1 < requestedEpoch).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> this.getMasterKey(BoxesRunTime.unboxToInt((Object)x$2), index, view)).getOrElse((Function0 & Serializable & scala.Serializable)() -> configKey);
    }

    private SchnorrProposition getLatestSigningKey(BaseAccountStateView view, SchnorrProposition configKey, int requestedEpoch, int index) {
        KeyRotationHistory signingKeyChangeHistory = this.getKeysRotationHistory(KeyRotationProofTypes$.MODULE$.SigningKeyRotationProofType(), index, view);
        return (SchnorrProposition)signingKeyChangeHistory.epochNumbers().find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$3 -> x$3 < requestedEpoch).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> this.getSigningKey(BoxesRunTime.unboxToInt((Object)x$4), index, view)).getOrElse((Function0 & Serializable & scala.Serializable)() -> configKey);
    }

    @Override
    public Option<KeyRotationProof> getKeyRotationProof(int epochNum, int index, Enumeration.Value keyType, BaseAccountStateView view) {
        byte[] key = this.getKeyRotationProofKey(keyType, epochNum, index);
        byte[] maybeData = view.getAccountStorageBytes(this.contractAddress(), key);
        return maybeData.length > 0 ? new Some(KeyRotationProofSerializer$.MODULE$.parseBytes(maybeData)) : None$.MODULE$;
    }

    public KeyRotationHistory getKeysRotationHistory(Enumeration.Value keyType, int index, BaseAccountStateView view) {
        byte[] maybeData = view.getAccountStorageBytes(this.contractAddress(), this.getKeysRotationHistoryKey(keyType, index));
        return maybeData.length > 0 ? (KeyRotationHistory)KeyRotationHistorySerializer$.MODULE$.parseBytes(maybeData) : new KeyRotationHistory((List<Object>)Nil$.MODULE$);
    }

    private void putKeyRotationHistory(Enumeration.Value keyType, int index, BaseAccountStateView view, KeyRotationHistory history) {
        view.updateAccountStorageBytes(this.contractAddress(), this.getKeysRotationHistoryKey(keyType, index), history.bytes());
    }

    private void putKeyRotationProof(int epochNum, BaseAccountStateView view, KeyRotationProof keyRotationProof) {
        byte[] key = this.getKeyRotationProofKey(keyRotationProof.keyType(), epochNum, keyRotationProof.index());
        view.updateAccountStorageBytes(this.contractAddress(), key, keyRotationProof.bytes());
    }

    private Option<SchnorrProposition> getSigningKey(int epochNumber, int index, BaseAccountStateView view) {
        byte[] bytes = view.getAccountStorageBytes(this.contractAddress(), this.getSigningKeyKey(epochNumber, index));
        return bytes.length > 0 ? new Some(SchnorrPropositionSerializer.getSerializer().parseBytes(bytes)) : None$.MODULE$;
    }

    private Option<SchnorrProposition> getMasterKey(int epochNumber, int index, BaseAccountStateView view) {
        byte[] bytes = view.getAccountStorageBytes(this.contractAddress(), this.getMasterKeyKey(epochNumber, index));
        return bytes.length > 0 ? new Some(SchnorrPropositionSerializer.getSerializer().parseBytes(bytes)) : None$.MODULE$;
    }

    private Try<BoxedUnit> checkKeyRotationProofValidity(KeyRotationProof keyRotationProof, SchnorrProof newKeySignature, int currentEpochNum, BaseAccountStateView view) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            byte[] byArray;
            int index = keyRotationProof.index();
            if (index < 0 || index >= this.params().signersPublicKeys().length()) {
                throw new ExecutionRevertedException(new StringBuilder(46).append("Key rotation proof - key index out for range: ").append(index).toString());
            }
            SchnorrProposition signingKeyFromConfig = (SchnorrProposition)this.params().signersPublicKeys().apply(index);
            SchnorrProposition masterKeyFromConfig = (SchnorrProposition)this.params().mastersPublicKeys().apply(index);
            Enumeration.Value value = keyRotationProof.keyType();
            Enumeration.Value value2 = KeyRotationProofTypes$.MODULE$.SigningKeyRotationProofType();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                byArray = CryptoLibProvider$.MODULE$.thresholdSignatureCircuitWithKeyRotation().getMsgToSignForSigningKeyUpdate(keyRotationProof.newKey().pubKeyBytes(), currentEpochNum, this.params().sidechainId());
            } else {
                Enumeration.Value value4 = KeyRotationProofTypes$.MODULE$.MasterKeyRotationProofType();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    byArray = CryptoLibProvider$.MODULE$.thresholdSignatureCircuitWithKeyRotation().getMsgToSignForMasterKeyUpdate(keyRotationProof.newKey().pubKeyBytes(), currentEpochNum, this.params().sidechainId());
                } else {
                    throw new MatchError((Object)value);
                }
            }
            byte[] newKeyAsMessage = byArray;
            SchnorrProposition latestSigningKey = this.getLatestSigningKey(view, signingKeyFromConfig, currentEpochNum, index);
            if (!keyRotationProof.signingKeySignature().isValid(latestSigningKey, newKeyAsMessage)) {
                throw new ExecutionRevertedException(new StringBuilder(51).append("Key rotation proof - signing signature is invalid: ").append(index).toString());
            }
            SchnorrProposition latestMasterKey = this.getLatestMasterKey(view, masterKeyFromConfig, currentEpochNum, index);
            if (!keyRotationProof.masterKeySignature().isValid(latestMasterKey, newKeyAsMessage)) {
                throw new ExecutionRevertedException(new StringBuilder(50).append("Key rotation proof - master signature is invalid: ").append(index).toString());
            }
            if (!newKeySignature.isValid(keyRotationProof.newKey(), newKeyAsMessage)) {
                throw new ExecutionRevertedException(new StringBuilder(48).append("Key rotation proof - self signature is invalid: ").append(index).toString());
            }
        });
    }

    private byte[] execSubmitKeyRotation(Invocation invocation, BaseAccountStateView view, int currentEpochNum) {
        byte[] byArray;
        this.checkInvocationValidity(invocation);
        SubmitKeyRotationCmdInput inputData = (SubmitKeyRotationCmdInput)SubmitKeyRotationCmdInputDecoder$.MODULE$.decode(ABIUtil.getArgumentsFromData(invocation.input()));
        KeyRotationProof keyRotationProof = inputData.keyRotationProof();
        int keyIndex = keyRotationProof.index();
        Enumeration.Value keyType = keyRotationProof.keyType();
        Try<BoxedUnit> try_ = this.checkKeyRotationProofValidity(keyRotationProof, inputData.newKeySignature(), currentEpochNum, view);
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable ex = failure.exception();
                throw new ExecutionRevertedException(new StringBuilder(31).append("Key Rotation Proof is invalid: ").append(ex.getMessage()).toString());
            }
            throw new MatchError(try_);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        this.putKeyRotationProof(currentEpochNum, view, keyRotationProof);
        Enumeration.Value value = keyType;
        Enumeration.Value value2 = KeyRotationProofTypes$.MODULE$.SigningKeyRotationProofType();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            byArray = this.getSigningKeyKey(currentEpochNum, keyIndex);
        } else {
            Enumeration.Value value4 = KeyRotationProofTypes$.MODULE$.MasterKeyRotationProofType();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                byArray = this.getMasterKeyKey(currentEpochNum, keyIndex);
            } else {
                throw new MatchError((Object)value);
            }
        }
        byte[] storageKey = byArray;
        view.updateAccountStorageBytes(this.contractAddress(), storageKey, keyRotationProof.newKey().bytes());
        KeyRotationHistory history = this.getKeysRotationHistory(keyType, keyIndex, view);
        if (!history.epochNumbers().headOption().exists((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$5 -> ((Object)BoxesRunTime.boxToInteger((int)x$5)).equals(BoxesRunTime.boxToInteger((int)currentEpochNum)))) {
            int n = currentEpochNum;
            this.putKeyRotationHistory(keyType, keyIndex, view, new KeyRotationHistory((List<Object>)history.epochNumbers().$colon$colon((Object)BoxesRunTime.boxToInteger((int)n))));
        }
        SubmitKeyRotation keyRotationEvent = SubmitKeyRotation$.MODULE$.apply(keyType, keyIndex, keyRotationProof.newKey(), currentEpochNum);
        EthereumConsensusDataLog evmLog = this.getEthereumConsensusDataLog(keyRotationEvent);
        view.addLog(evmLog);
        return keyRotationProof.encode();
    }

    private void checkInvocationValidity(Invocation invocation) {
        if (invocation.input().length != 4 + SubmitKeyRotationCmdInputDecoder$.MODULE$.getABIDataParamsStaticLengthInBytes()) {
            throw new ExecutionRevertedException(new StringBuilder(36).append("Wrong invocation data field length: ").append(invocation.input().length).toString());
        }
        if (invocation.value().signum() != 0) {
            throw new ExecutionRevertedException(new StringBuilder(19).append("Value is non-zero: ").append(invocation).toString());
        }
    }

    private byte[] calculateKey(byte[] keySeed) {
        return Keccak256$.MODULE$.hash(keySeed);
    }

    private byte[] getKeyRotationProofKey(Enumeration.Value keyType, int withdrawalEpoch, int index) {
        return this.calculateKey(Bytes.concat((byte[][])new byte[][]{"keyRotationProof".getBytes(StandardCharsets.UTF_8), Ints.toByteArray((int)keyType.id()), Ints.toByteArray((int)withdrawalEpoch), Ints.toByteArray((int)index)}));
    }

    private byte[] getSigningKeyKey(int epoch, int index) {
        return this.calculateKey(Bytes.concat((byte[][])new byte[][]{"signingKey".getBytes(StandardCharsets.UTF_8), Ints.toByteArray((int)epoch), Ints.toByteArray((int)index)}));
    }

    private byte[] getMasterKeyKey(int epoch, int index) {
        return this.calculateKey(Bytes.concat((byte[][])new byte[][]{"masterKey".getBytes(StandardCharsets.UTF_8), Ints.toByteArray((int)epoch), Ints.toByteArray((int)index)}));
    }

    private byte[] getKeysRotationHistoryKey(Enumeration.Value keyType, int index) {
        return this.calculateKey(Bytes.concat((byte[][])new byte[][]{"keyHistory".getBytes(StandardCharsets.UTF_8), Ints.toByteArray((int)keyType.id()), Ints.toByteArray((int)index)}));
    }

    public CertificateKeyRotationMsgProcessor copy(NetworkParams params) {
        return new CertificateKeyRotationMsgProcessor(params);
    }

    public NetworkParams copy$default$1() {
        return this.params();
    }

    public String productPrefix() {
        return "CertificateKeyRotationMsgProcessor";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.params();
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CertificateKeyRotationMsgProcessor;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CertificateKeyRotationMsgProcessor)) return false;
        boolean bl = true;
        if (!bl) return false;
        CertificateKeyRotationMsgProcessor certificateKeyRotationMsgProcessor = (CertificateKeyRotationMsgProcessor)x$1;
        NetworkParams networkParams = this.params();
        NetworkParams networkParams2 = certificateKeyRotationMsgProcessor.params();
        if (networkParams == null) {
            if (networkParams2 != null) {
                return false;
            }
        } else if (!networkParams.equals(networkParams2)) return false;
        if (!certificateKeyRotationMsgProcessor.canEqual(this)) return false;
        return true;
    }

    public CertificateKeyRotationMsgProcessor(NetworkParams params) {
        this.params = params;
        Product.$init$((Product)this);
        this.contractAddress = CertificateKeyRotationMsgProcessor$.MODULE$.CertificateKeyRotationContractAddress();
        this.contractCode = CertificateKeyRotationMsgProcessor$.MODULE$.CertificateKeyRotationContractCode();
    }
}

