/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.state;

import com.horizen.certnative.BackwardTransfer;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.AbstractState;
import io.horizen.account.block.AccountBlock;
import io.horizen.account.block.AccountBlockHeader;
import io.horizen.account.fork.GasFeeFork;
import io.horizen.account.fork.GasFeeFork$;
import io.horizen.account.fork.Version1_2_0Fork$;
import io.horizen.account.history.validation.InvalidTransactionChainIdException;
import io.horizen.account.history.validation.InvalidTransactionChainIdException$;
import io.horizen.account.node.NodeAccountState;
import io.horizen.account.proposition.AddressProposition;
import io.horizen.account.state.AccountForgingStakeInfo;
import io.horizen.account.state.AccountStateView;
import io.horizen.account.state.BlockContext;
import io.horizen.account.state.ForgerStakeData;
import io.horizen.account.state.GasLimitReached;
import io.horizen.account.state.GasPool;
import io.horizen.account.state.GasUtil$;
import io.horizen.account.state.HistoryBlockHashProvider;
import io.horizen.account.state.McAddrOwnershipData;
import io.horizen.account.state.MessageProcessor;
import io.horizen.account.state.NonceTooLowException;
import io.horizen.account.state.OwnerScAddress;
import io.horizen.account.state.SenderNotEoaException;
import io.horizen.account.state.StateDbAccountStateView;
import io.horizen.account.state.StateDbAccountStateView$;
import io.horizen.account.state.WithdrawalRequest;
import io.horizen.account.state.receipt.EthereumConsensusDataLog;
import io.horizen.account.state.receipt.EthereumConsensusDataReceipt;
import io.horizen.account.state.receipt.EthereumReceipt;
import io.horizen.account.storage.AccountStateMetadataStorage;
import io.horizen.account.transaction.AccountTransaction;
import io.horizen.account.transaction.EthereumTransaction;
import io.horizen.account.utils.AccountBlockFeeInfo;
import io.horizen.account.utils.AccountFeePaymentsUtils$;
import io.horizen.account.utils.AccountPayment;
import io.horizen.account.utils.FeeUtils$;
import io.horizen.account.utils.Secp256k1;
import io.horizen.block.MainchainBackwardTransferCertificateOutput;
import io.horizen.block.MainchainBlockReferenceData;
import io.horizen.block.WithdrawalEpochCertificate;
import io.horizen.certificatesubmitter.keys.CertifiersKeys;
import io.horizen.certificatesubmitter.keys.KeyRotationProof;
import io.horizen.consensus.ConsensusEpochInfo;
import io.horizen.consensus.ForgingStakeInfo;
import io.horizen.cryptolibprovider.CircuitTypes$;
import io.horizen.evm.Address;
import io.horizen.evm.Database;
import io.horizen.evm.Hash;
import io.horizen.evm.ResourceHandle;
import io.horizen.evm.StateDB;
import io.horizen.params.NetworkParams;
import io.horizen.proof.Proof;
import io.horizen.proposition.Proposition;
import io.horizen.proposition.SchnorrProposition;
import io.horizen.state.State;
import io.horizen.utils.ByteArrayWrapper;
import io.horizen.utils.BytesUtils;
import io.horizen.utils.ClosableResourceHandler;
import io.horizen.utils.MerkleTree;
import io.horizen.utils.TimeToEpochUtils$;
import io.horizen.utils.WithdrawalEpochInfo;
import io.horizen.utils.WithdrawalEpochUtils$;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sparkz.core.package$;
import sparkz.core.transaction.Transaction;
import sparkz.core.transaction.state.TransactionValidation;
import sparkz.core.utils.NetworkTimeProvider;
import sparkz.util.SparkzLogging;

@ScalaSignature(bytes="\u0006\u0001\u0011\u001de\u0001B\"E\u00015C!\"a\n\u0001\u0005\u000b\u0007I\u0011AA\u0015\u0011)\t)\u0004\u0001B\u0001B\u0003%\u00111\u0006\u0005\u000b\u0003o\u0001!\u0011!Q\u0001\n\u0005e\u0002BCA\"\u0001\t\u0005\t\u0015!\u0003\u0002F!Q\u00111\n\u0001\u0003\u0006\u0004%\t%!\u0014\t\u0015\u0005-\u0004A!A!\u0002\u0013\ty\u0005\u0003\u0006\u0002n\u0001\u0011\t\u0011)A\u0005\u0003_B!\"a\u001f\u0001\u0005\u0003\u0005\u000b\u0011BA?\u0011)\tI\t\u0001B\u0001B\u0003%\u00111\u0012\u0005\b\u0003K\u0003A\u0011AAT\u000b\u0015\t9\f\u0001\u0011n\u0011\u001d\tI\f\u0001C\u0005\u0003wCq!a3\u0001\t\u0003\ni\rC\u0004\u0002T\u0002!I!!6\t\u000f\t=\u0001\u0001\"\u0003\u0003\u0012!9!1\u0005\u0001\u0005B\t\u0015\u0002b\u0002B\u001c\u0001\u0011\u0005#\u0011\b\u0005\b\u0005{\u0001A\u0011\tB \u0011\u001d\u00119\u0005\u0001C!\u0005\u0013BqAa\u0013\u0001\t\u0003\u0011i\u0005C\u0004\u0003f\u0001!\tEa\u001a\t\u000f\tU\u0004\u0001\"\u0011\u0003x!9!q\u0012\u0001\u0005B\tE\u0005b\u0002BZ\u0001\u0011\u0005#Q\u0017\u0005\b\u0005\u0003\u0004A\u0011\tBb\u0011\u001d\u00119\r\u0001C!\u0005\u0013DqA!8\u0001\t\u0003\u0012y\u000eC\u0004\u0003h\u0002!\tE!;\t\u000f\t5\b\u0001\"\u0011\u0003p\"9!\u0011\u001f\u0001\u0005B\tM\b\"CB\t\u0001E\u0005I\u0011AB\n\u0011\u001d\u0019I\u0003\u0001C!\u0007WAqa!\f\u0001\t\u0003\u001ay\u0003C\u0004\u00044\u0001!\te!\u000e\t\u000f\r\u0005\u0003\u0001\"\u0011\u0004D!91\u0011\u000b\u0001\u0005B\rM\u0003bBB8\u0001\u0011\u00053\u0011\u000f\u0005\b\u0007g\u0002A\u0011IB;\u0011\u001d\u0019I\b\u0001C!\u0007wBqaa \u0001\t\u0003\u001a\t\tC\u0004\u0004\f\u0002!\te!$\t\u000f\rE\u0005\u0001\"\u0011\u0004\u0014\"91\u0011\u0017\u0001\u0005B\rM\u0006\"CBb\u0001E\u0005I\u0011ABc\u0011\u001d\u0019I\r\u0001C!\u0007\u0017Dqa!6\u0001\t\u0003\u001a9\u000eC\u0004\u0004^\u0002!\tea8\t\u000f\rM\b\u0001\"\u0011\u0004r!91Q\u001f\u0001\u0005B\r]\bbBB~\u0001\u0011\u00053Q \u0005\b\u0007\u007f\u0004A\u0011\tC\u0001\u0011\u001d!i\u0001\u0001C!\t\u001fAq\u0001b\u0006\u0001\t\u0003\"I\u0002C\u0004\u0005\"\u0001!\t\u0005b\t\t\u000f\u0011%\u0002\u0001\"\u0011\u0005,!9Aq\u0006\u0001\u0005B\u0011E\u0002b\u0002C\u001b\u0001\u0011\u0005Cq\u0007\u0005\b\tw\u0001A\u0011\tC\u001f\u0011\u001d!)\u0005\u0001C!\t\u000fBq\u0001\"\u0013\u0001\t\u0003\"9\u0005C\u0004\u0005L\u0001!\t\u0005\"\u0014\b\u000f\u0011MC\t#\u0001\u0005V\u001911\t\u0012E\u0001\t/Bq!!*@\t\u0003!y\u0006\u0003\u0005\u0005b}\"\t\u0001\u0013C2\u0011!!\u0019h\u0010C\u0001\u0011\u0012U$\u0001D!dG>,h\u000e^*uCR,'BA#G\u0003\u0015\u0019H/\u0019;f\u0015\t9\u0005*A\u0004bG\u000e|WO\u001c;\u000b\u0005%S\u0015a\u00025pe&TXM\u001c\u0006\u0002\u0017\u0006\u0011\u0011n\\\u0002\u0001')\u0001aj\\<\u0002\u0004\u0005=\u00111\u0004\t\u0007\u001fB\u0013FM[7\u000e\u0003!K!!\u0015%\u0003\u001b\u0005\u00137\u000f\u001e:bGR\u001cF/\u0019;f!\u0011\u0019f\u000b\u00170\u000e\u0003QS!!\u0016$\u0002\u0017Q\u0014\u0018M\\:bGRLwN\\\u0005\u0003/R\u0013!#Q2d_VtG\u000f\u0016:b]N\f7\r^5p]B\u0011\u0011\fX\u0007\u00025*\u00111\fS\u0001\faJ|\u0007o\\:ji&|g.\u0003\u0002^5\nY\u0001K]8q_NLG/[8o!\ry&\rW\u0007\u0002A*\u0011\u0011\rS\u0001\u0006aJ|wNZ\u0005\u0003G\u0002\u0014Q\u0001\u0015:p_\u001a\u0004\"!\u001a5\u000e\u0003\u0019T!a\u001a$\u0002\u000b\tdwnY6\n\u0005%4'AE!dG>,h\u000e\u001e\"m_\u000e\\\u0007*Z1eKJ\u0004\"!Z6\n\u000514'\u0001D!dG>,h\u000e\u001e\"m_\u000e\\\u0007C\u00018\u0001\u001b\u0005!\u0005C\u00029s%*$X.D\u0001r\u0015\t)\u0005*\u0003\u0002tc\n)1\u000b^1uKB\u0011a.^\u0005\u0003m\u0012\u0013\u0001#Q2d_VtGo\u0015;bi\u00164\u0016.Z<\u0011\u0007a|(+D\u0001z\u0015\t)%P\u0003\u0002Vw*\u0011A0`\u0001\u0005G>\u0014XMC\u0001\u007f\u0003\u0019\u0019\b/\u0019:lu&\u0019\u0011\u0011A=\u0003+Q\u0013\u0018M\\:bGRLwN\u001c,bY&$\u0017\r^5p]B!\u0011QAA\u0006\u001b\t\t9AC\u0002\u0002\n\u0019\u000bAA\\8eK&!\u0011QBA\u0004\u0005Aqu\u000eZ3BG\u000e|WO\u001c;Ti\u0006$X\r\u0005\u0003\u0002\u0012\u0005]QBAA\n\u0015\r\t)\u0002S\u0001\u0006kRLGn]\u0005\u0005\u00033\t\u0019BA\fDY>\u001c\u0018M\u00197f%\u0016\u001cx.\u001e:dK\"\u000bg\u000e\u001a7feB!\u0011QDA\u0012\u001b\t\tyBC\u0002\u0002\"u\fA!\u001e;jY&!\u0011QEA\u0010\u00055\u0019\u0006/\u0019:lu2{wmZ5oO\u00061\u0001/\u0019:b[N,\"!a\u000b\u0011\t\u00055\u0012\u0011G\u0007\u0003\u0003_Q1!a\nI\u0013\u0011\t\u0019$a\f\u0003\u001b9+Go^8sWB\u000b'/Y7t\u0003\u001d\u0001\u0018M]1ng\u0002\nA\u0002^5nKB\u0013xN^5eKJ\u0004B!a\u000f\u0002@5\u0011\u0011Q\b\u0006\u0004\u0003+Y\u0018\u0002BA!\u0003{\u00111CT3uo>\u00148\u000eV5nKB\u0013xN^5eKJ\f\u0011C\u00197pG.D\u0015m\u001d5Qe>4\u0018\u000eZ3s!\rq\u0017qI\u0005\u0004\u0003\u0013\"%\u0001\u0007%jgR|'/\u001f\"m_\u000e\\\u0007*Y:i!J|g/\u001b3fe\u00069a/\u001a:tS>tWCAA(!\u0011\t\t&!\u001a\u000f\t\u0005M\u0013\u0011\r\b\u0005\u0003+\nyF\u0004\u0003\u0002X\u0005uSBAA-\u0015\r\tY\u0006T\u0001\u0007yI|w\u000e\u001e \n\u0003yL!\u0001`?\n\u0007\u0005\r40A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u001d\u0014\u0011\u000e\u0002\u000b-\u0016\u00148/[8o)\u0006<'bAA2w\u0006Aa/\u001a:tS>t\u0007%\u0001\u000bti\u0006$X-T3uC\u0012\fG/Y*u_J\fw-\u001a\t\u0005\u0003c\n9(\u0004\u0002\u0002t)\u0019\u0011Q\u000f$\u0002\u000fM$xN]1hK&!\u0011\u0011PA:\u0005m\t5mY8v]R\u001cF/\u0019;f\u001b\u0016$\u0018\rZ1uCN#xN]1hK\u0006q1\u000f^1uK\u0012\u00137\u000b^8sC\u001e,\u0007\u0003BA@\u0003\u000bk!!!!\u000b\u0007\u0005\r\u0005*A\u0002fm6LA!a\"\u0002\u0002\nAA)\u0019;bE\u0006\u001cX-A\tnKN\u001c\u0018mZ3Qe>\u001cWm]:peN\u0004b!!$\u0002\u001a\u0006}e\u0002BAH\u0003+sA!a\u0016\u0002\u0012&\u0011\u00111S\u0001\u0006g\u000e\fG.Y\u0005\u0005\u0003G\n9J\u0003\u0002\u0002\u0014&!\u00111TAO\u0005\r\u0019V-\u001d\u0006\u0005\u0003G\n9\nE\u0002o\u0003CK1!a)E\u0005AiUm]:bO\u0016\u0004&o\\2fgN|'/\u0001\u0004=S:LGO\u0010\u000b\u0010[\u0006%\u00161VAW\u0003_\u000b\t,a-\u00026\"9\u0011q\u0005\u0006A\u0002\u0005-\u0002bBA\u001c\u0015\u0001\u0007\u0011\u0011\b\u0005\b\u0003\u0007R\u0001\u0019AA#\u0011\u001d\tYE\u0003a\u0001\u0003\u001fBq!!\u001c\u000b\u0001\u0004\ty\u0007C\u0004\u0002|)\u0001\r!! \t\u000f\u0005%%\u00021\u0001\u0002\f\n!aJV\"U\u00039Ig.\u001b;Qe>\u001cWm]:peN$B!!0\u0002HB)\u0011qXAb[6\u0011\u0011\u0011\u0019\u0006\u0005\u0003C\t9*\u0003\u0003\u0002F\u0006\u0005'a\u0001+ss\"9\u0011\u0011\u001a\u0007A\u0002\u0005=\u0013AD5oSRL\u0017\r\u001c,feNLwN\\\u0001\u000eCB\u0004H._'pI&4\u0017.\u001a:\u0015\t\u0005u\u0016q\u001a\u0005\u0007\u0003#l\u0001\u0019\u00016\u0002\u00075|G-A\tfm\u0006dgi\u001c:hKJ\u001c(+Z<be\u0012$\"\"a6\u0002`\u0006\u0005\u00181\u001eB\u0006!\u0011\tI.a7\u000e\u0005\u0005]\u0015\u0002BAo\u0003/\u0013A!\u00168ji\"1\u0011\u0011\u001b\bA\u0002)Dq!a9\u000f\u0001\u0004\t)/\u0001\fn_\u0012<\u0016\u000e\u001e5ee\u0006<\u0018\r\\#q_\u000eD\u0017J\u001c4p!\u0011\t\t\"a:\n\t\u0005%\u00181\u0003\u0002\u0014/&$\b\u000e\u001a:bo\u0006dW\t]8dQ&sgm\u001c\u0005\b\u0003[t\u0001\u0019AAx\u0003Q\u0019wN\\:f]N,8/\u00129pG\"tU/\u001c2feB!\u0011\u0011\u001fB\u0003\u001d\u0011\t\u0019P!\u0001\u000f\t\u0005U\u0018Q \b\u0005\u0003o\fYP\u0004\u0003\u0002X\u0005e\u0018\"A&\n\u0005%S\u0015bAA\u0000\u0011\u0006I1m\u001c8tK:\u001cXo]\u0005\u0005\u0003G\u0012\u0019AC\u0002\u0002\u0000\"KAAa\u0002\u0003\n\t!2i\u001c8tK:\u001cXo]#q_\u000eDg*^7cKJTA!a\u0019\u0003\u0004!1!Q\u0002\bA\u0002Q\f\u0011b\u001d;bi\u00164\u0016.Z<\u0002;Y\fG.\u001b3bi\u0016$v\u000e])vC2LG/_\"feRLg-[2bi\u0016$b!a6\u0003\u0014\t\u0005\u0002b\u0002B\u000b\u001f\u0001\u0007!qC\u0001\u0016i>\u0004\u0018+^1mSRL8)\u001a:uS\u001aL7-\u0019;f!\u0011\u0011IB!\b\u000e\u0005\tm!BA4I\u0013\u0011\u0011yBa\u0007\u00035]KG\u000f\u001b3sC^\fG.\u00129pG\"\u001cUM\u001d;jM&\u001c\u0017\r^3\t\r\t5q\u00021\u0001u\u0003eI7oU<ji\u000eD\u0017N\\4D_:\u001cXM\\:vg\u0016\u0003xn\u00195\u0015\t\t\u001d\"Q\u0006\t\u0005\u00033\u0014I#\u0003\u0003\u0003,\u0005]%a\u0002\"p_2,\u0017M\u001c\u0005\b\u0005_\u0001\u0002\u0019\u0001B\u0019\u00039\u0011Gn\\2l)&lWm\u0015;b[B\u0004B!!7\u00034%!!QGAL\u0005\u0011auN\\4\u0002\u0015I|G\u000e\u001c2bG.$v\u000e\u0006\u0003\u0002>\nm\u0002bBA&#\u0001\u0007\u0011qJ\u0001\u0011[\u0006D(k\u001c7mE\u0006\u001c7\u000eR3qi\",\"A!\u0011\u0011\t\u0005e'1I\u0005\u0005\u0005\u000b\n9JA\u0002J]R\fqaZ3u-&,w/F\u0001u\u0003Y9W\r^*uCR,GI\u0019,jK^4%o\\7S_>$H\u0003\u0002B(\u0005+\u00022A\u001cB)\u0013\r\u0011\u0019\u0006\u0012\u0002\u0018'R\fG/\u001a#c\u0003\u000e\u001cw.\u001e8u'R\fG/\u001a,jK^DqAa\u0016\u0015\u0001\u0004\u0011I&A\u0005ti\u0006$XMU8piB1\u0011\u0011\u001cB.\u0005?JAA!\u0018\u0002\u0018\n)\u0011I\u001d:bsB!\u0011\u0011\u001cB1\u0013\u0011\u0011\u0019'a&\u0003\t\tKH/Z\u0001\u0016O\u0016$x+\u001b;iIJ\fw/\u00197SKF,Xm\u001d;t)\u0011\u0011IG!\u001d\u0011\r\u00055\u0015\u0011\u0014B6!\rq'QN\u0005\u0004\u0005_\"%!E,ji\"$'/Y<bYJ+\u0017/^3ti\"9!1O\u000bA\u0002\t\u0005\u0013aD<ji\"$'/Y<bY\u0016\u0003xn\u00195\u0002#\t\f7m[<be\u0012$&/\u00198tM\u0016\u00148\u000f\u0006\u0003\u0003z\t5\u0005CBAG\u00033\u0013Y\b\u0005\u0003\u0003~\t%UB\u0001B@\u0015\u0011\u0011\tIa!\u0002\u0015\r,'\u000f\u001e8bi&4XMC\u0002J\u0005\u000bS!Aa\"\u0002\u0007\r|W.\u0003\u0003\u0003\f\n}$\u0001\u0005\"bG.<\u0018M\u001d3Ue\u0006t7OZ3s\u0011\u001d\u0011\u0019H\u0006a\u0001\u0005\u0003\n\u0001c[3z%>$\u0018\r^5p]B\u0013xn\u001c4\u0015\u0011\tM%\u0011\u0016BV\u0005_\u0003b!!7\u0003\u0016\ne\u0015\u0002\u0002BL\u0003/\u0013aa\u00149uS>t\u0007\u0003\u0002BN\u0005Kk!A!(\u000b\t\t}%\u0011U\u0001\u0005W\u0016L8OC\u0002\u0003$\"\u000bAcY3si&4\u0017nY1uKN,(-\\5ui\u0016\u0014\u0018\u0002\u0002BT\u0005;\u0013\u0001cS3z%>$\u0018\r^5p]B\u0013xn\u001c4\t\u000f\tMt\u00031\u0001\u0003B!9!QV\fA\u0002\t\u0005\u0013!D5oI\u0016DxJZ*jO:,'\u000fC\u0004\u00032^\u0001\rA!\u0011\u0002\u000f-,\u0017\u0010V=qK\u0006q1-\u001a:uS\u001aLWM]:LKf\u001cH\u0003\u0002B\\\u0005\u007f\u0003b!!7\u0003\u0016\ne\u0006\u0003\u0002BN\u0005wKAA!0\u0003\u001e\nq1)\u001a:uS\u001aLWM]:LKf\u001c\bb\u0002B:1\u0001\u0007!\u0011I\u0001\u001fY\u0006\u001cHoQ3si&4\u0017nY1uKJ+g-\u001a:f]\u000e,G-\u00129pG\",\"A!2\u0011\r\u0005e'Q\u0013B!\u0003}a\u0017m\u001d;DKJ$\u0018NZ5dCR,7+\u001b3fG\"\f\u0017N\u001c\"m_\u000e\\\u0017\n\u001a\u000b\u0003\u0005\u0017\u0004b!!7\u0003\u0016\n5\u0007\u0003\u0002Bh\u0005/tAA!5\u0003V:!\u0011Q\u000bBj\u0013\r\t\t#`\u0005\u0005\u0003G\ny\"\u0003\u0003\u0003Z\nm'AC'pI&4\u0017.\u001a:JI*!\u00111MA\u0010\u0003-\u0019WM\u001d;jM&\u001c\u0017\r^3\u0015\t\t\u0005(1\u001d\t\u0007\u00033\u0014)Ja\u0006\t\u000f\t\u00158\u00041\u0001\u0003B\u0005I\"/\u001a4fe\u0016t7-\u001a3XSRDGM]1xC2,\u0005o\\2i\u0003a9W\r\u001e+paF+\u0018\r\\5us\u000e+'\u000f^5gS\u000e\fG/\u001a\u000b\u0005\u0005C\u0014Y\u000fC\u0004\u0003fr\u0001\rA!\u0011\u0002\u0013!\f7oQ3bg\u0016$GC\u0001B\u0014\u0003I9W\r\u001e$fKB\u000b\u00170\\3oiNLeNZ8\u0015\u0011\tU8\u0011AB\u0002\u0007\u000b\u0001b!!$\u0002\u001a\n]\b\u0003\u0002B}\u0005{l!Aa?\u000b\u0007\u0005Ua)\u0003\u0003\u0003\u0000\nm(AD!dG>,h\u000e\u001e)bs6,g\u000e\u001e\u0005\b\u0005gr\u0002\u0019\u0001B!\u0011\u001d\tiO\ba\u0001\u0003_D\u0011ba\u0002\u001f!\u0003\u0005\ra!\u0003\u0002)\tdwnY6U_\u0006\u0003\b/\u001a8e\r\u0016,\u0017J\u001c4p!\u0019\tIN!&\u0004\fA!!\u0011`B\u0007\u0013\u0011\u0019yAa?\u0003'\u0005\u001b7m\\;oi\ncwnY6GK\u0016LeNZ8\u00029\u001d,GOR3f!\u0006LX.\u001a8ug&sgm\u001c\u0013eK\u001a\fW\u000f\u001c;%gU\u00111Q\u0003\u0016\u0005\u0007\u0013\u00199b\u000b\u0002\u0004\u001aA!11DB\u0013\u001b\t\u0019iB\u0003\u0003\u0004 \r\u0005\u0012!C;oG\",7m[3e\u0015\u0011\u0019\u0019#a&\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004(\ru!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u00061r-\u001a;XSRDGM]1xC2,\u0005o\\2i\u0013:4w.\u0006\u0002\u0002f\u00069r-\u001a;D_:\u001cXM\\:vg\u0016\u0003xn\u00195Ok6\u0014WM]\u000b\u0003\u0007c\u0001b!!7\u0003\u0016\u0006=\u0018AH4fi>\u0013H-\u001a:fI\u001a{'oZ5oON#\u0018m[3t\u0013:4wnU3r)\t\u00199\u0004\u0005\u0004\u0002\u000e\u0006e5\u0011\b\t\u0005\u0007w\u0019i$\u0004\u0002\u0003\u0004%!1q\bB\u0002\u0005A1uN]4j]\u001e\u001cF/Y6f\u0013:4w.\u0001\u000fhKR\u001cUO\u001d:f]R\u001cuN\\:f]N,8/\u00129pG\"LeNZ8\u0016\u0005\r\u0015\u0003\u0003CAm\u0007\u000f\u0012ima\u0013\n\t\r%\u0013q\u0013\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t\rm2QJ\u0005\u0005\u0007\u001f\u0012\u0019A\u0001\nD_:\u001cXM\\:vg\u0016\u0003xn\u00195J]\u001a|\u0017AC4fi\n\u000bG.\u00198dKR!1QKB3!\u0011\u00199f!\u0019\u000e\u0005\re#\u0002BB.\u0007;\nA!\\1uQ*\u00111qL\u0001\u0005U\u00064\u0018-\u0003\u0003\u0004d\re#A\u0003\"jO&sG/Z4fe\"91q\r\u0013A\u0002\r%\u0014aB1eIJ,7o\u001d\t\u0005\u0003\u007f\u001aY'\u0003\u0003\u0004n\u0005\u0005%aB!eIJ,7o]\u0001\u0014O\u0016$\u0018iY2pk:$8\u000b^1uKJ{w\u000e^\u000b\u0003\u00053\n1bZ3u\u0007>$W\rS1tQR!!\u0011LB<\u0011\u001d\u00199G\na\u0001\u0007S\n\u0001bZ3u\u001d>t7-\u001a\u000b\u0005\u0007+\u001ai\bC\u0004\u0004h\u001d\u0002\ra!\u001b\u0002-\u001d,G\u000fT5ti>3gi\u001c:hKJ\u001c8\u000b^1lKN,\"aa!\u0011\r\u00055\u0015\u0011TBC!\rq7qQ\u0005\u0004\u0007\u0013#%aF!dG>,h\u000e\u001e$pe\u001eLgnZ*uC.,\u0017J\u001c4p\u0003Q9W\r^!mY><X\r\u001a$pe\u001e,'\u000fT5tiV\u00111q\u0012\t\u0007\u0003\u001b\u000bIJ!\u0011\u0002%\u001d,GOR8sO\u0016\u00148\u000b^1lK\u0012\u000bG/\u0019\u000b\u0005\u0007+\u001bi\n\u0005\u0004\u0002Z\nU5q\u0013\t\u0004]\u000ee\u0015bABN\t\nyai\u001c:hKJ\u001cF/Y6f\t\u0006$\u0018\rC\u0004\u0004 *\u0002\ra!)\u0002\u000fM$\u0018m[3JIB!11UBV\u001d\u0011\u0019)ka*\u0011\t\u0005]\u0013qS\u0005\u0005\u0007S\u000b9*\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0007[\u001byK\u0001\u0004TiJLgn\u001a\u0006\u0005\u0007S\u000b9*A\rhKRd\u0015n\u001d;PM6\u001b\u0017\t\u001a3s\u001f^tWM]:iSB\u001cH\u0003BB[\u0007{\u0003b!!$\u0002\u001a\u000e]\u0006c\u00018\u0004:&\u001911\u0018#\u0003'5\u001b\u0017\t\u001a3s\u001f^tWM]:iSB$\u0015\r^1\t\u0013\r}6\u0006%AA\u0002\r\u0005\u0017\u0001D:d\u0003\u0012$'/Z:t\u001fB$\bCBAm\u0005+\u001b\t+A\u0012hKRd\u0015n\u001d;PM6\u001b\u0017\t\u001a3s\u001f^tWM]:iSB\u001cH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\r\u001d'\u0006BBa\u0007/\t\u0011dZ3u\u0019&\u001cHo\u00144Po:,'oU2BI\u0012\u0014Xm]:fgR\u00111Q\u001a\t\u0007\u0003\u001b\u000bIja4\u0011\u00079\u001c\t.C\u0002\u0004T\u0012\u0013abT<oKJ\u001c6-\u00113ee\u0016\u001c8/\u0001\npo:,'o\u001d5ja\u0012\u000bG/Y#ySN$H\u0003\u0002B\u0014\u00073Dqaa7/\u0001\u0004\u0011I&A\u0006po:,'o\u001d5ja&#\u0017aB4fi2{wm\u001d\u000b\u0005\u0007C\u001cy\u000f\u0005\u0004\u0002Z\nm31\u001d\t\u0005\u0007K\u001cY/\u0004\u0002\u0004h*\u00191\u0011\u001e#\u0002\u000fI,7-Z5qi&!1Q^Bt\u0005a)E\u000f[3sKVl7i\u001c8tK:\u001cXo\u001d#bi\u0006dun\u001a\u0005\b\u0007c|\u0003\u0019\u0001B-\u0003\u0019!\b\u0010S1tQ\u0006\u0019r-\u001a;J]R,'/\\3eS\u0006$XMU8pi\u00069q-\u001a;D_\u0012,G\u0003\u0002B-\u0007sDqaa\u001a2\u0001\u0004\u0019I'\u0001\bhKRtU\r\u001f;CCN,g)Z3\u0016\u0005\rU\u0013!F4fiR\u0013\u0018M\\:bGRLwN\u001c*fG\u0016L\u0007\u000f\u001e\u000b\u0005\t\u0007!Y\u0001\u0005\u0004\u0002Z\nUEQ\u0001\t\u0005\u0007K$9!\u0003\u0003\u0005\n\r\u001d(aD#uQ\u0016\u0014X-^7SK\u000e,\u0017\u000e\u001d;\t\u000f\rE8\u00071\u0001\u0003Z\u0005\u0001r-\u001a;Ti\u0006$X\r\u00122IC:$G.Z\u000b\u0003\t#\u0001B!a \u0005\u0014%!AQCAA\u00059\u0011Vm]8ve\u000e,\u0007*\u00198eY\u0016\f\u0011cZ3u\u0003\u000e\u001cw.\u001e8u'R|'/Y4f)\u0019\u0011I\u0006b\u0007\u0005\u001e!91qM\u001bA\u0002\r%\u0004b\u0002C\u0010k\u0001\u0007!\u0011L\u0001\u0004W\u0016L\u0018AF4fi\u0006\u001b7m\\;oiN#xN]1hK\nKH/Z:\u0015\r\teCQ\u0005C\u0014\u0011\u001d\u00199G\u000ea\u0001\u0007SBq\u0001b\b7\u0001\u0004\u0011I&A\u0007bG\u000e|WO\u001c;Fq&\u001cHo\u001d\u000b\u0005\u0005O!i\u0003C\u0004\u0004h]\u0002\ra!\u001b\u0002\u0019%\u001cXi\\1BG\u000e|WO\u001c;\u0015\t\t\u001dB1\u0007\u0005\b\u0007OB\u0004\u0019AB5\u0003YI7oU7beR\u001cuN\u001c;sC\u000e$\u0018iY2pk:$H\u0003\u0002B\u0014\tsAqaa\u001a:\u0001\u0004\u0019I'\u0001\u0005wC2LG-\u0019;f)\u0011!y\u0004\"\u0011\u0011\r\u0005}\u00161YAl\u0011\u0019!\u0019E\u000fa\u0001%\u0006\u0011A\u000f_\u0001\u001bSN<\u0016\u000e\u001e5ee\u0006<\u0018\r\\#q_\u000eDG*Y:u\u0013:$W\r_\u000b\u0003\u0005O\tQ\"[:G_J<\u0017N\\4Pa\u0016t\u0017AE;uq>lUM]6mKR\u0013X-\u001a*p_R$B\u0001b\u0014\u0005RA1\u0011\u0011\u001cBK\u00053BqAa\u001d>\u0001\u0004\u0011\t%\u0001\u0007BG\u000e|WO\u001c;Ti\u0006$X\r\u0005\u0002o\u007fM)q\b\"\u0017\u0002\u001cA!\u0011\u0011\u001cC.\u0013\u0011!i&a&\u0003\r\u0005s\u0017PU3g)\t!)&\u0001\u0007sKN$xN]3Ti\u0006$X\r\u0006\b\u0005f\u0011\u001dD\u0011\u000eC6\t[\"y\u0007\"\u001d\u0011\u000b\u0005e'QS7\t\u000f\u00055\u0014\t1\u0001\u0002p!9\u00111P!A\u0002\u0005u\u0004bBAE\u0003\u0002\u0007\u00111\u0012\u0005\b\u0003O\t\u0005\u0019AA\u0016\u0011\u001d\t9$\u0011a\u0001\u0003sAq!a\u0011B\u0001\u0004\t)%\u0001\nde\u0016\fG/Z$f]\u0016\u001c\u0018n]*uCR,G\u0003EA_\to\"I\bb\u001f\u0005~\u0011}D\u0011\u0011CB\u0011\u001d\tiG\u0011a\u0001\u0003_Bq!a\u001fC\u0001\u0004\ti\bC\u0004\u0002\n\n\u0003\r!a#\t\u000f\u0005\u001d\"\t1\u0001\u0002,!9\u0011q\u0007\"A\u0002\u0005e\u0002bBA\"\u0005\u0002\u0007\u0011Q\t\u0005\u0007\t\u000b\u0013\u0005\u0019\u00016\u0002\u0019\u001d,g.Z:jg\ncwnY6")
public class AccountState
extends AbstractState<AccountTransaction<Proposition, Proof<Proposition>>, AccountBlockHeader, AccountBlock, AccountState>
implements State<AccountTransaction<Proposition, Proof<Proposition>>, AccountBlock, AccountStateView, AccountState>,
TransactionValidation<AccountTransaction<Proposition, Proof<Proposition>>>,
NodeAccountState,
ClosableResourceHandler,
SparkzLogging {
    private final NetworkParams params;
    private final NetworkTimeProvider timeProvider;
    private final HistoryBlockHashProvider blockHashProvider;
    private final String version;
    private final AccountStateMetadataStorage stateMetadataStorage;
    private final Database stateDbStorage;
    private final Seq<MessageProcessor> messageProcessors;
    private final Logger logger;

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    @Override
    public <A extends AutoCloseable, B> B using(A resource, Function1<A, B> fun) {
        return (B)ClosableResourceHandler.using$(this, resource, fun);
    }

    public boolean isValid(Transaction tx) {
        return TransactionValidation.isValid$((TransactionValidation)this, (Transaction)tx);
    }

    public Seq<AccountTransaction<Proposition, Proof<Proposition>>> filterValid(Seq<AccountTransaction<Proposition, Proof<Proposition>>> txs) {
        return TransactionValidation.filterValid$((TransactionValidation)this, txs);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public NetworkParams params() {
        return this.params;
    }

    public String version() {
        return this.version;
    }

    public Try<AccountState> io$horizen$account$state$AccountState$$initProcessors(String initialVersion) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (AccountState)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)view -> {
            int consensusEpochNumber = view.getConsensusEpochNumberAsInt();
            $this.messageProcessors.foreach((Function1 & Serializable & scala.Serializable)processor -> {
                processor.init(view, consensusEpochNumber);
                return BoxedUnit.UNIT;
            });
            try {
                view.commit(initialVersion);
            }
            catch (Throwable t) {
                BoxedUnit boxedUnit;
                String errMsg = new StringBuilder(44).append("Could not commit view with initial version: ").append(initialVersion).toString();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error(errMsg, t);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                throw t;
            }
            return this;
        }));
    }

    public Try<AccountState> applyModifier(AccountBlock mod) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(package$.MODULE$.versionToBytes(this.version()))).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray((byte[])package$.MODULE$.idToBytes().apply((Object)mod.parentId()))), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Incorrect state version!: ").append(mod.parentId()).append(" found, ").append(this.version()).append(" expected").toString());
            return (AccountState)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)stateView -> {
                BoxedUnit boxedUnit;
                if (stateView.hasCeased()) {
                    BoxedUnit boxedUnit2;
                    String errMsg = new StringBuilder(53).append("Can't apply Block ").append(mod.id()).append(", because the sidechain has ceased.").toString();
                    if (this.log().underlying().isErrorEnabled()) {
                        this.log().underlying().error(errMsg);
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    throw new IllegalStateException(errMsg);
                }
                mod.sidechainTransactions().foreach((Function1 & Serializable & scala.Serializable)tx -> {
                    tx.semanticValidity();
                    return BoxedUnit.UNIT;
                });
                WithdrawalEpochInfo currentWithdrawalEpochInfo = this.getWithdrawalEpochInfo();
                WithdrawalEpochInfo modWithdrawalEpochInfo = WithdrawalEpochUtils$.MODULE$.getWithdrawalEpochInfo(mod, currentWithdrawalEpochInfo, this.params());
                if (this.params().isNonCeasing()) {
                    ((IterableLike)mod.mainchainBlockReferencesData().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> Option$.MODULE$.option2Iterable(x$1.topQualityCertificate()), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)cert -> {
                        this.validateTopQualityCertificate(cert, stateView);
                        return BoxedUnit.UNIT;
                    });
                } else if (WithdrawalEpochUtils$.MODULE$.hasReachedCertificateSubmissionWindowEnd(mod, currentWithdrawalEpochInfo, this.params())) {
                    int certReferencedEpochNumber = modWithdrawalEpochInfo.epoch() - 1;
                    Option topQualityCertificateOpt = mod.topQualityCertificateOpt().orElse((Function0 & Serializable & scala.Serializable)() -> stateView.getTopQualityCertificate(certReferencedEpochNumber));
                    Option option = topQualityCertificateOpt;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        WithdrawalEpochCertificate cert2 = (WithdrawalEpochCertificate)some.value();
                        this.validateTopQualityCertificate(cert2, (AccountStateView)stateView);
                        BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                    } else if (None$.MODULE$.equals(option)) {
                        BoxedUnit boxedUnit4;
                        if (this.log().underlying().isInfoEnabled()) {
                            this.log().underlying().info(new StringBuilder(131).append("In the end of the certificate submission window of epoch ").append(modWithdrawalEpochInfo.epoch()).append(" ").append("there are no certificates referenced to the epoch ").append(certReferencedEpochNumber).append(". Sidechain has ceased.").toString());
                            boxedUnit4 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit4 = BoxedUnit.UNIT;
                        }
                        stateView.setCeased();
                        BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError((Object)option);
                    }
                }
                stateView.updateWithdrawalEpochInfo(modWithdrawalEpochInfo);
                int consensusEpochNumber = TimeToEpochUtils$.MODULE$.timeStampToEpochNumber(this.params().sidechainGenesisBlockTimestamp(), mod.timestamp());
                stateView.updateConsensusEpochNumber(consensusEpochNumber);
                ObjectRef cumGasUsed = ObjectRef.create((Object)BigInteger.ZERO);
                ObjectRef cumBaseFee = ObjectRef.create((Object)BigInteger.ZERO);
                ObjectRef cumForgerTips = ObjectRef.create((Object)BigInteger.ZERO);
                boolean ftToSmartContractForkActive = Version1_2_0Fork$.MODULE$.get(consensusEpochNumber).active();
                mod.mainchainBlockReferencesData().foreach((Function1 & Serializable & scala.Serializable)mcBlockRefData -> {
                    AccountState.$anonfun$applyModifier$8(stateView, mod, ftToSmartContractForkActive, mcBlockRefData);
                    return BoxedUnit.UNIT;
                });
                ListBuffer receiptList = new ListBuffer();
                int blockNumber = $this.stateMetadataStorage.getHeight() + 1;
                byte[] blockHash = (byte[])package$.MODULE$.idToBytes().apply((Object)mod.id());
                GasPool blockGasPool = new GasPool(mod.header().gasLimit());
                BlockContext blockContext = new BlockContext(mod.header(), blockNumber, consensusEpochNumber, modWithdrawalEpochInfo.epoch(), this.params().chainId(), $this.blockHashProvider);
                ((TraversableLike)mod.sidechainTransactions().zipWithIndex(Seq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)AccountState.$anonfun$applyModifier$9(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                    AccountState.$anonfun$applyModifier$10(this, stateView, blockGasPool, blockContext, cumGasUsed, blockHash, blockNumber, receiptList, cumBaseFee, cumForgerTips, x$3);
                    return BoxedUnit.UNIT;
                });
                if (this.log().underlying().isDebugEnabled()) {
                    this.log().underlying().debug("cumBaseFee={}, cumForgerTips={}", (Object[])new BigInteger[]{(BigInteger)cumBaseFee.elem, (BigInteger)cumForgerTips.elem});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                stateView.updateFeePaymentInfo(new AccountBlockFeeInfo((BigInteger)cumBaseFee.elem, (BigInteger)cumForgerTips.elem, mod.header().forgerAddress()));
                stateView.updateForgerBlockCounter(mod.forgerPublicKey(), consensusEpochNumber);
                this.evalForgersReward(mod, modWithdrawalEpochInfo, consensusEpochNumber, (AccountStateView)stateView);
                mod.verifyLogsBloomConsistency((Seq<EthereumReceipt>)receiptList);
                mod.verifyReceiptDataConsistency((Seq<EthereumConsensusDataReceipt>)((Seq)receiptList.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.consensusDataReceipt(), ListBuffer$.MODULE$.canBuildFrom())));
                BigInteger gasUsed = (BigInteger)receiptList.lastOption().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.consensusDataReceipt().cumulativeGasUsed()).getOrElse((Function0 & Serializable & scala.Serializable)() -> BigInteger.ZERO);
                mod.verifyGasUsedConsistency(gasUsed);
                byte[] stateRoot = stateView.getIntermediateRoot();
                mod.verifyStateRootDataConsistency(stateRoot);
                stateView.updateTransactionReceipts((Seq<EthereumReceipt>)receiptList);
                stateView.updateNextBaseFee(FeeUtils$.MODULE$.calculateNextBaseFee(mod, this.params()));
                stateView.commit(package$.MODULE$.idToVersion(mod.id()));
                return new AccountState(this.params(), $this.timeProvider, $this.blockHashProvider, package$.MODULE$.idToVersion(mod.id()), $this.stateMetadataStorage, $this.stateDbStorage, $this.messageProcessors);
            });
        });
    }

    private void evalForgersReward(AccountBlock mod, WithdrawalEpochInfo modWithdrawalEpochInfo, int consensusEpochNumber, AccountStateView stateView) {
        boolean isWithdrawalEpochFinished = WithdrawalEpochUtils$.MODULE$.isEpochLastIndex(modWithdrawalEpochInfo, this.params());
        if (isWithdrawalEpochFinished) {
            BoxedUnit boxedUnit;
            Seq<AccountPayment> feePayments = stateView.getFeePaymentsInfo(modWithdrawalEpochInfo.epoch(), consensusEpochNumber, (Option<AccountBlockFeeInfo>)None$.MODULE$);
            if (this.log().underlying().isInfoEnabled()) {
                this.log().underlying().info("End of Withdrawal Epoch {} reached, added {} rewards with block {}", new Object[]{BoxesRunTime.boxToInteger((int)modWithdrawalEpochInfo.epoch()), BoxesRunTime.boxToInteger((int)feePayments.length()), mod.header().id()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            byte[] feePaymentsHash = AccountFeePaymentsUtils$.MODULE$.calculateFeePaymentsHash(feePayments);
            if (!new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(mod.feePaymentsHash())).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(feePaymentsHash))) {
                BoxedUnit boxedUnit2;
                String errMsg = new StringBuilder(72).append("Block ").append(mod.id()).append(": computed feePaymentsHash ").append(BytesUtils.toHexString(feePaymentsHash)).append(" is different from the one in the block").toString();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error(errMsg);
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                throw new IllegalArgumentException(errMsg);
            }
            stateView.resetForgerPoolAndBlockCounters(consensusEpochNumber);
            feePayments.foreach((Function1 & Serializable & scala.Serializable)payment -> {
                AccountState.$anonfun$evalForgersReward$1(this, stateView, payment);
                return BoxedUnit.UNIT;
            });
        } else if (!new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(mod.feePaymentsHash())).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(AccountFeePaymentsUtils$.MODULE$.DEFAULT_ACCOUNT_FEE_PAYMENTS_HASH()))) {
            String errMsg = new StringBuilder(66).append("Block ").append(mod.id()).append(" has feePaymentsHash ").append(BytesUtils.toHexString(mod.feePaymentsHash())).append(" defined when no fee payments expected.").toString();
            throw new IllegalArgumentException(errMsg);
        }
    }

    private void validateTopQualityCertificate(WithdrawalEpochCertificate topQualityCertificate, AccountStateView stateView) {
        int certReferencedEpochNumber = topQualityCertificate.epochNumber();
        Seq<WithdrawalRequest> expectedWithdrawalRequests = stateView.getWithdrawalRequests(certReferencedEpochNumber);
        if (topQualityCertificate.backwardTransferOutputs().size() != expectedWithdrawalRequests.size()) {
            throw new IllegalStateException(new StringBuilder(139).append("Epoch ").append(certReferencedEpochNumber).append(" top quality certificate backward transfers ").append("number ").append(topQualityCertificate.backwardTransferOutputs().size()).append(" is different than expected ").append(expectedWithdrawalRequests.size()).append(". ").append("Node's active chain is the fork from MC perspective.").toString());
        }
        ((IterableLike)topQualityCertificate.backwardTransferOutputs().zip(expectedWithdrawalRequests, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            AccountState.$anonfun$validateTopQualityCertificate$1(certReferencedEpochNumber, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public boolean isSwitchingConsensusEpoch(long blockTimeStamp) {
        int currentConsensusEpoch;
        int blockConsensusEpoch = TimeToEpochUtils$.MODULE$.timeStampToEpochNumber(this.params().sidechainGenesisBlockTimestamp(), blockTimeStamp);
        return blockConsensusEpoch != (currentConsensusEpoch = BoxesRunTime.unboxToInt((Object)this.getConsensusEpochNumber().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> io.horizen.consensus.package$.MODULE$.intToConsensusEpochNumber(0))));
    }

    public Try<AccountState> rollbackTo(String version) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(version != null, (Function0 & Serializable & scala.Serializable)() -> "Version to rollback to must be NOT NULL.");
            AccountStateMetadataStorage newMetaState = (AccountStateMetadataStorage)$this.stateMetadataStorage.rollback(new ByteArrayWrapper(package$.MODULE$.versionToBytes(version))).get();
            return new AccountState(this.params(), $this.timeProvider, $this.blockHashProvider, version, newMetaState, $this.stateDbStorage, $this.messageProcessors);
        }).recoverWith((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AccountState $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                BoxedUnit boxedUnit;
                A1 A1 = x1;
                if (this.$outer.log().underlying().isErrorEnabled()) {
                    this.$outer.log().underlying().error("Exception was thrown during rollback.", A1);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                Failure failure = new Failure(A1);
                return (B1)failure;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public int maxRollbackDepth() {
        return this.stateMetadataStorage.rollbackVersions().size();
    }

    @Override
    public AccountStateView getView() {
        Hash stateRoot = new Hash(this.stateMetadataStorage.getAccountStateRoot());
        StateDB statedb = new StateDB(this.stateDbStorage, stateRoot);
        return new AccountStateView(this.stateMetadataStorage.getView(), statedb, this.messageProcessors);
    }

    public StateDbAccountStateView getStateDbViewFromRoot(byte[] stateRoot) {
        return new StateDbAccountStateView(new StateDB(this.stateDbStorage, new Hash(stateRoot)), this.messageProcessors, StateDbAccountStateView$.MODULE$.$lessinit$greater$default$3());
    }

    @Override
    public Seq<WithdrawalRequest> getWithdrawalRequests(int withdrawalEpoch) {
        return (Seq)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$6 -> x$6.getWithdrawalRequests(withdrawalEpoch));
    }

    @Override
    public Seq<BackwardTransfer> backwardTransfers(int withdrawalEpoch) {
        return (Seq)((TraversableLike)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$7 -> x$7.getWithdrawalRequests(withdrawalEpoch))).map((Function1 & Serializable & scala.Serializable)wr -> new BackwardTransfer(wr.proposition().bytes(), wr.valueInZennies()), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public Option<KeyRotationProof> keyRotationProof(int withdrawalEpoch, int indexOfSigner, int keyType) {
        return (Option)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$8 -> x$8.keyRotationProof(withdrawalEpoch, indexOfSigner, keyType));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Option<CertifiersKeys> certifiersKeys(int withdrawalEpoch) {
        Some some;
        block3: {
            block2: {
                if (withdrawalEpoch == -1) break block2;
                Enumeration.Value value = this.params().circuitType();
                Enumeration.Value value2 = CircuitTypes$.MODULE$.NaiveThresholdSignatureCircuit();
                if (value != null ? !value.equals(value2) : value2 != null) break block3;
            }
            some = new Some((Object)new CertifiersKeys((Vector<SchnorrProposition>)this.params().signersPublicKeys().toVector(), (Vector<SchnorrProposition>)this.params().mastersPublicKeys().toVector()));
            return some;
        }
        some = (Option)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$9 -> x$9.certifiersKeys(withdrawalEpoch));
        return some;
    }

    @Override
    public Option<Object> lastCertificateReferencedEpoch() {
        return this.stateMetadataStorage.lastCertificateReferencedEpoch();
    }

    @Override
    public Option<String> lastCertificateSidechainBlockId() {
        return this.stateMetadataStorage.lastCertificateSidechainBlockId();
    }

    @Override
    public Option<WithdrawalEpochCertificate> certificate(int referencedWithdrawalEpoch) {
        return this.getTopQualityCertificate(referencedWithdrawalEpoch);
    }

    @Override
    public Option<WithdrawalEpochCertificate> getTopQualityCertificate(int referencedWithdrawalEpoch) {
        return this.stateMetadataStorage.getTopQualityCertificate(referencedWithdrawalEpoch);
    }

    @Override
    public boolean hasCeased() {
        return this.stateMetadataStorage.hasCeased();
    }

    @Override
    public Seq<AccountPayment> getFeePaymentsInfo(int withdrawalEpoch, int consensusEpochNumber, Option<AccountBlockFeeInfo> blockToAppendFeeInfo) {
        Seq<AccountBlockFeeInfo> feePaymentInfoSeq = this.stateMetadataStorage.getFeePayments(withdrawalEpoch);
        Map<AddressProposition, BigInteger> mcForgerPoolRewards = this.stateMetadataStorage.getMcForgerPoolRewards();
        return AccountFeePaymentsUtils$.MODULE$.getForgersRewards(feePaymentInfoSeq, mcForgerPoolRewards);
    }

    @Override
    public Option<AccountBlockFeeInfo> getFeePaymentsInfo$default$3() {
        return None$.MODULE$;
    }

    @Override
    public WithdrawalEpochInfo getWithdrawalEpochInfo() {
        return this.stateMetadataStorage.getWithdrawalEpochInfo();
    }

    @Override
    public Option<Object> getConsensusEpochNumber() {
        return this.stateMetadataStorage.getConsensusEpochNumber();
    }

    @Override
    public Seq<ForgingStakeInfo> getOrderedForgingStakesInfoSeq() {
        return (Seq)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$10 -> x$10.getOrderedForgingStakesInfoSeq());
    }

    @Override
    public Tuple2<String, ConsensusEpochInfo> getCurrentConsensusEpochInfo() {
        Seq<ForgingStakeInfo> forgingStakes = this.getOrderedForgingStakesInfoSeq();
        if (forgingStakes.isEmpty()) {
            throw new IllegalStateException("ForgerStakes list can't be empty.");
        }
        Option<Object> option = this.getConsensusEpochNumber();
        if (!(option instanceof Some)) {
            throw new IllegalStateException("Can't retrieve Consensus Epoch related info form StateStorage.");
        }
        Some some = (Some)option;
        int consensusEpochNumber = BoxesRunTime.unboxToInt((Object)some.value());
        String lastBlockInEpoch = sparkz.util.package$.MODULE$.bytesToId(((ByteArrayWrapper)this.stateMetadataStorage.lastVersionId().get()).data());
        ConsensusEpochInfo consensusEpochInfo = new ConsensusEpochInfo(consensusEpochNumber, MerkleTree.createMerkleTree((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)forgingStakes.map((Function1 & Serializable & scala.Serializable)info -> info.hash(), Seq$.MODULE$.canBuildFrom())).asJava()), BoxesRunTime.unboxToLong((Object)((TraversableOnce)forgingStakes.map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong((long)x$11.stakeAmount()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
        Tuple2 tuple2 = new Tuple2((Object)lastBlockInEpoch, (Object)consensusEpochInfo);
        return tuple2;
    }

    @Override
    public BigInteger getBalance(Address address) {
        return (BigInteger)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$12 -> x$12.getBalance(address));
    }

    @Override
    public byte[] getAccountStateRoot() {
        return this.stateMetadataStorage.getAccountStateRoot();
    }

    @Override
    public byte[] getCodeHash(Address address) {
        return (byte[])this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$13 -> x$13.getCodeHash(address));
    }

    @Override
    public BigInteger getNonce(Address address) {
        return (BigInteger)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$14 -> x$14.getNonce(address));
    }

    @Override
    public Seq<AccountForgingStakeInfo> getListOfForgersStakes() {
        return (Seq)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$15 -> x$15.getListOfForgersStakes());
    }

    @Override
    public Seq<Object> getAllowedForgerList() {
        return (Seq)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$16 -> x$16.getAllowedForgerList());
    }

    @Override
    public Option<ForgerStakeData> getForgerStakeData(String stakeId) {
        return (Option)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$17 -> x$17.getForgerStakeData(stakeId));
    }

    @Override
    public Seq<McAddrOwnershipData> getListOfMcAddrOwnerships(Option<String> scAddressOpt) {
        return (Seq)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$18 -> x$18.getListOfMcAddrOwnerships(scAddressOpt));
    }

    @Override
    public Option<String> getListOfMcAddrOwnerships$default$1() {
        return None$.MODULE$;
    }

    @Override
    public Seq<OwnerScAddress> getListOfOwnerScAddresses() {
        return (Seq)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$19 -> x$19.getListOfOwnerScAddresses());
    }

    @Override
    public boolean ownershipDataExist(byte[] ownershipId) {
        return BoxesRunTime.unboxToBoolean(this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)x$20.ownershipDataExist(ownershipId))));
    }

    @Override
    public EthereumConsensusDataLog[] getLogs(byte[] txHash) {
        return (EthereumConsensusDataLog[])this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$21 -> x$21.getLogs(txHash));
    }

    @Override
    public byte[] getIntermediateRoot() {
        return (byte[])this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$22 -> x$22.getIntermediateRoot());
    }

    @Override
    public byte[] getCode(Address address) {
        return (byte[])this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$23 -> x$23.getCode(address));
    }

    @Override
    public BigInteger getNextBaseFee() {
        return (BigInteger)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$24 -> x$24.getNextBaseFee());
    }

    @Override
    public Option<EthereumReceipt> getTransactionReceipt(byte[] txHash) {
        return (Option)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$25 -> x$25.getTransactionReceipt(txHash));
    }

    @Override
    public ResourceHandle getStateDbHandle() {
        return (ResourceHandle)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$26 -> x$26.getStateDbHandle());
    }

    @Override
    public byte[] getAccountStorage(Address address, byte[] key) {
        return (byte[])this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$27 -> x$27.getAccountStorage(address, key));
    }

    @Override
    public byte[] getAccountStorageBytes(Address address, byte[] key) {
        return (byte[])this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$28 -> x$28.getAccountStorageBytes(address, key));
    }

    @Override
    public boolean accountExists(Address address) {
        return BoxesRunTime.unboxToBoolean(this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$29 -> BoxesRunTime.boxToBoolean((boolean)x$29.accountExists(address))));
    }

    @Override
    public boolean isEoaAccount(Address address) {
        return BoxesRunTime.unboxToBoolean(this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$30 -> BoxesRunTime.boxToBoolean((boolean)x$30.isEoaAccount(address))));
    }

    @Override
    public boolean isSmartContractAccount(Address address) {
        return BoxesRunTime.unboxToBoolean(this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$31 -> BoxesRunTime.boxToBoolean((boolean)x$31.isSmartContractAccount(address))));
    }

    public Try<BoxedUnit> validate(AccountTransaction<Proposition, Proof<Proposition>> tx) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (!(tx instanceof EthereumTransaction)) {
                BoxedUnit boxedUnit;
                String errMsg = new StringBuilder(46).append("Transaction ").append(tx.id()).append(": instance of class ").append(tx.getClass().getName()).append(", not of type ").append(EthereumTransaction.class.getName()).toString();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error(errMsg);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                throw new IllegalArgumentException(errMsg);
            }
            EthereumTransaction ethTx = (EthereumTransaction)tx;
            if ((ethTx.isEIP155() || ethTx.isEIP1559()) && !BoxesRunTime.equalsNumObject((Number)ethTx.getChainId(), (Object)BoxesRunTime.boxToLong((long)this.params().chainId()))) {
                BoxedUnit boxedUnit;
                String errMsg = new StringBuilder(61).append("Transaction ").append(ethTx.id()).append(": chainId=").append(ethTx.getChainId()).append(" is different from expected SC chainId ").append(this.params().chainId()).toString();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error(errMsg);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                throw new InvalidTransactionChainIdException(errMsg, InvalidTransactionChainIdException$.MODULE$.$lessinit$greater$default$2());
            }
            ethTx.semanticValidity();
            Address sender = ethTx.getFrom().address();
            GasFeeFork feeFork = GasFeeFork$.MODULE$.get(BoxesRunTime.unboxToInt((Object)$this.stateMetadataStorage.getConsensusEpochNumber().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)));
            if (feeFork.blockGasLimit().compareTo(ethTx.getGasLimit()) < 0) {
                throw new IllegalArgumentException(new StringBuilder(78).append("Transaction gas limit exceeds block gas limit: tx gas limit ").append(ethTx.getGasLimit()).append(", block gas limit ").append(feeFork.blockGasLimit()).toString());
            }
            if (feeFork.baseFeeMinimum().compareTo(ethTx.getMaxFeePerGas()) > 0) {
                throw new IllegalArgumentException(new StringBuilder(64).append("max fee per gas below minimum: address ").append(sender).append(", maxFeePerGas ").append(ethTx.getMaxFeePerGas()).append(", minimum ").append(feeFork.baseFeeMinimum()).toString());
            }
            this.using(this.getView(), (Function1 & Serializable & scala.Serializable)stateView -> {
                AccountState.$anonfun$validate$3(sender, ethTx, stateView);
                return BoxedUnit.UNIT;
            });
        }).recoverWith((PartialFunction)new scala.Serializable(this, tx){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AccountState $outer;
            private final AccountTransaction tx$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                BoxedUnit boxedUnit;
                A1 A1 = x1;
                if (this.$outer.log().underlying().isDebugEnabled()) {
                    this.$outer.log().underlying().debug(new StringBuilder(22).append("Not valid transaction ").append(this.tx$1.id()).toString(), A1);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                Failure failure = new Failure(A1);
                return (B1)failure;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tx$1 = tx$1;
            }
        });
    }

    @Override
    public boolean isWithdrawalEpochLastIndex() {
        return WithdrawalEpochUtils$.MODULE$.isEpochLastIndex(this.getWithdrawalEpochInfo(), this.params());
    }

    @Override
    public boolean isForgingOpen() {
        return this.params().restrictForgers() ? BoxesRunTime.unboxToBoolean(this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$32 -> BoxesRunTime.boxToBoolean((boolean)x$32.isForgingOpen()))) : true;
    }

    @Override
    public Option<byte[]> utxoMerkleTreeRoot(int withdrawalEpoch) {
        return None$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$applyModifier$8(AccountStateView stateView$1, AccountBlock mod$1, boolean ftToSmartContractForkActive$1, MainchainBlockReferenceData mcBlockRefData) {
        stateView$1.addTopQualityCertificates(mcBlockRefData, mod$1.id());
        stateView$1.applyMainchainBlockReferenceData(mcBlockRefData, ftToSmartContractForkActive$1);
    }

    public static final /* synthetic */ boolean $anonfun$applyModifier$9(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$applyModifier$10(AccountState $this, AccountStateView stateView$1, GasPool blockGasPool$1, BlockContext blockContext$1, ObjectRef cumGasUsed$1, byte[] blockHash$1, int blockNumber$1, ListBuffer receiptList$1, ObjectRef cumBaseFee$1, ObjectRef cumForgerTips$1, Tuple2 x$3) {
        Tuple2 tuple2 = x$3;
        if (tuple2 != null) {
            Tuple2 tuple22;
            BigInteger txGasUsed;
            AccountTransaction tx = (AccountTransaction)tuple2._1();
            int txIndex = tuple2._2$mcI$sp();
            boolean bl = false;
            Failure failure = null;
            Try<EthereumConsensusDataReceipt> try_ = stateView$1.applyTransaction(tx, txIndex, blockGasPool$1, blockContext$1);
            if (try_ instanceof Success) {
                BoxedUnit boxedUnit;
                Success success = (Success)try_;
                EthereumConsensusDataReceipt consensusDataReceipt = (EthereumConsensusDataReceipt)success.value();
                txGasUsed = consensusDataReceipt.cumulativeGasUsed().subtract((BigInteger)cumGasUsed$1.elem);
                cumGasUsed$1.elem = consensusDataReceipt.cumulativeGasUsed();
                EthereumTransaction ethTx = (EthereumTransaction)tx;
                byte[] txHash = BytesUtils.fromHexString(ethTx.id());
                None$ contractAddress = ethTx.getTo().isEmpty() ? Option$.MODULE$.apply((Object)Secp256k1.generateContractAddress(ethTx.getFrom().address(), ethTx.getNonce())) : None$.MODULE$;
                EthereumReceipt fullReceipt = new EthereumReceipt(consensusDataReceipt, txHash, txIndex, blockHash$1, blockNumber$1, txGasUsed, (Option<Address>)contractAddress);
                if ($this.log().underlying().isDebugEnabled()) {
                    $this.log().underlying().debug("Adding to receipt list: {}", new Object[]{fullReceipt.toString()});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                receiptList$1.$plus$eq((Object)fullReceipt);
                Tuple2<BigInteger, BigInteger> tuple23 = GasUtil$.MODULE$.getTxFeesPerGas(ethTx, blockContext$1.baseFee);
                if (tuple23 == null) {
                    throw new MatchError(tuple23);
                }
                BigInteger txBaseFeePerGas = (BigInteger)tuple23._1();
                BigInteger txForgerTipPerGas = (BigInteger)tuple23._2();
                tuple22 = new Tuple2((Object)txBaseFeePerGas, (Object)txForgerTipPerGas);
            } else {
                if (try_ instanceof Failure) {
                    bl = true;
                    failure = (Failure)try_;
                    Throwable err = failure.exception();
                    if (err instanceof GasLimitReached) {
                        BoxedUnit boxedUnit;
                        GasLimitReached gasLimitReached = (GasLimitReached)err;
                        if ($this.log().underlying().isErrorEnabled()) {
                            $this.log().underlying().error("Could not apply tx, block gas limit exceeded");
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        throw new IllegalArgumentException("Could not apply tx, block gas limit exceeded", gasLimitReached);
                    }
                }
                if (bl) {
                    BoxedUnit boxedUnit;
                    Throwable err = failure.exception();
                    if ($this.log().underlying().isErrorEnabled()) {
                        $this.log().underlying().error("Could not apply tx", err);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    throw new IllegalArgumentException(err);
                }
                throw new MatchError(try_);
            }
            Tuple2 tuple24 = tuple22;
            BigInteger txBaseFeePerGas = (BigInteger)tuple24._1();
            BigInteger txForgerTipPerGas = (BigInteger)tuple24._2();
            cumBaseFee$1.elem = ((BigInteger)cumBaseFee$1.elem).add(txBaseFeePerGas.multiply(txGasUsed));
            cumForgerTips$1.elem = ((BigInteger)cumForgerTips$1.elem).add(txForgerTipPerGas.multiply(txGasUsed));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$evalForgersReward$1(AccountState $this, AccountStateView stateView$2, AccountPayment payment) {
        BoxedUnit boxedUnit;
        stateView$2.addBalance(payment.address().address(), payment.value());
        if ($this.log().underlying().isDebugEnabled()) {
            $this.log().underlying().debug(" address: {} / value: {}", new Object[]{payment.address().address(), payment.value()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$validateTopQualityCertificate$1(int certReferencedEpochNumber$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            MainchainBackwardTransferCertificateOutput certOutput = (MainchainBackwardTransferCertificateOutput)tuple2._1();
            WithdrawalRequest expectedWithdrawalRequest = (WithdrawalRequest)tuple2._2();
            if (certOutput.amount() != expectedWithdrawalRequest.valueInZennies() || !Arrays.equals(certOutput.pubKeyHash(), expectedWithdrawalRequest.proposition().bytes())) {
                throw new IllegalStateException(new StringBuilder(135).append("Epoch ").append(certReferencedEpochNumber$2).append(" top quality certificate backward transfers ").append("data is different than expected. Node's active chain is the fork from MC perspective.").toString());
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$validate$3(Address sender$1, EthereumTransaction ethTx$1, AccountStateView stateView) {
        BigInteger stateNonce = stateView.getNonce(sender$1);
        if (stateNonce.compareTo(ethTx$1.getNonce()) > 0) {
            throw new NonceTooLowException(sender$1, ethTx$1.getNonce(), stateNonce);
        }
        BigInteger maxTxCost = ethTx$1.maxCost();
        BigInteger currentBalance = stateView.getBalance(sender$1);
        if (currentBalance.compareTo(maxTxCost) < 0) {
            throw new IllegalArgumentException(new StringBuilder(64).append("Insufficient funds for executing transaction: balance ").append(currentBalance).append(", tx cost ").append(maxTxCost).toString());
        }
        if (!stateView.isEoaAccount(sender$1)) {
            throw new SenderNotEoaException(sender$1, stateView.getCodeHash(sender$1));
        }
    }

    public AccountState(NetworkParams params, NetworkTimeProvider timeProvider, HistoryBlockHashProvider blockHashProvider, String version, AccountStateMetadataStorage stateMetadataStorage, Database stateDbStorage, Seq<MessageProcessor> messageProcessors) {
        this.params = params;
        this.timeProvider = timeProvider;
        this.blockHashProvider = blockHashProvider;
        this.version = version;
        this.stateMetadataStorage = stateMetadataStorage;
        this.stateDbStorage = stateDbStorage;
        this.messageProcessors = messageProcessors;
        TransactionValidation.$init$((TransactionValidation)this);
        ClosableResourceHandler.$init$(this);
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
    }
}

