/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.secret;

import io.horizen.account.secret.PrivateKeySecp256k1;
import io.horizen.account.utils.Secp256k1;
import io.horizen.secret.SecretCreator;
import io.horizen.utils.Pair;
import java.nio.charset.StandardCharsets;

public final class PrivateKeySecp256k1Creator
implements SecretCreator<PrivateKeySecp256k1> {
    private static final PrivateKeySecp256k1Creator instance;
    private static final byte[] domain;

    private PrivateKeySecp256k1Creator() {
    }

    public static PrivateKeySecp256k1Creator getInstance() {
        return instance;
    }

    @Override
    public PrivateKeySecp256k1 generateSecret(byte[] seed) {
        Pair<byte[], byte[]> keyPair = Secp256k1.createKeyPair(seed);
        assert (keyPair != null);
        return new PrivateKeySecp256k1(keyPair.getKey());
    }

    @Override
    public byte[] salt() {
        return domain;
    }

    static {
        domain = "PrivateKeySecp256k1".getBytes(StandardCharsets.UTF_8);
        instance = new PrivateKeySecp256k1Creator();
    }
}

