/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.mempool;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.AccountMempoolSettings;
import io.horizen.account.api.rpc.types.EthereumTransactionView;
import io.horizen.account.block.AccountBlock;
import io.horizen.account.mempool.MempoolMap$;
import io.horizen.account.mempool.TransactionsByPriceAndNonceIter;
import io.horizen.account.mempool.TxCache;
import io.horizen.account.mempool.TxExecutableStatus$;
import io.horizen.account.mempool.TxMetaInfo;
import io.horizen.account.mempool.exception.AccountMemPoolOutOfBoundException;
import io.horizen.account.mempool.exception.NonceGapTooWideException;
import io.horizen.account.mempool.exception.TransactionReplaceUnderpricedException;
import io.horizen.account.mempool.exception.TxOversizedException;
import io.horizen.account.proposition.AddressProposition;
import io.horizen.account.state.AccountStateReaderProvider;
import io.horizen.account.state.BaseStateReaderProvider;
import io.horizen.account.transaction.AccountTransaction;
import io.horizen.account.transaction.EthereumTransaction;
import io.horizen.evm.Address;
import io.horizen.proof.Proof;
import io.horizen.proposition.Proposition;
import java.io.Serializable;
import java.math.BigInteger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.BufferedIterator;
import scala.collection.GenIterable;
import scala.collection.GenTraversable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.IterableView;
import scala.collection.Iterator;
import scala.collection.MapLike;
import scala.collection.Parallel;
import scala.collection.Parallelizable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.generic.CanBuildFrom;
import scala.collection.generic.FilterMonadic;
import scala.collection.generic.GenericCompanion;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.PriorityQueue;
import scala.collection.mutable.Queue;
import scala.collection.mutable.SortedMap;
import scala.collection.mutable.SortedMap$;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.TreeMap;
import scala.collection.parallel.Combiner;
import scala.collection.parallel.ParIterable;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.util.Try;
import scala.util.Try$;
import sparkz.core.transaction.Transaction;
import sparkz.util.SparkzLogging;

@ScalaSignature(bytes="\u0006\u0001\reh\u0001\u0002.\\\u0001\u0011D\u0001b\u001d\u0001\u0003\u0002\u0003\u0006I\u0001\u001e\u0005\tu\u0002\u0011\t\u0011)A\u0005w\"Aa\u0010\u0001B\u0001B\u0003%q\u0010C\u0004\u0002\b\u0001!\t!!\u0003\u0006\r\u0005U\u0001\u0001BA\f\u0011%\t\u0019\u0006\u0001b\u0001\n\u0013\t)\u0006\u0003\u0005\u0002X\u0001\u0001\u000b\u0011BA\u0014\u0011%\tI\u0006\u0001b\u0001\n\u0013\tY\u0006\u0003\u0005\u0002d\u0001\u0001\u000b\u0011BA/\u0011%\t)\u0007\u0001b\u0001\n\u0013\tY\u0006\u0003\u0005\u0002h\u0001\u0001\u000b\u0011BA/\u0011%\tI\u0007\u0001b\u0001\n\u0013\tY\u0006\u0003\u0005\u0002l\u0001\u0001\u000b\u0011BA/\u0011%\ti\u0007\u0001b\u0001\n\u0013\ty\u0007\u0003\u0005\u0002\u0002\u0002\u0001\u000b\u0011BA9\u0011%\t\u0019\t\u0001b\u0001\n\u0013\t)\t\u0003\u0005\u0002\u000e\u0002\u0001\u000b\u0011BAD\u0011%\ty\t\u0001b\u0001\n\u0013\t\t\n\u0003\u0005\u0002.\u0002\u0001\u000b\u0011BAJ\u0011%\ty\u000b\u0001b\u0001\n\u0013\t\t\n\u0003\u0005\u00022\u0002\u0001\u000b\u0011BAJ\u0011%\t\u0019\f\u0001b\u0001\n\u0013\t)\f\u0003\u0005\u0002:\u0002\u0001\u000b\u0011BA\\\u0011\u001d\tY\f\u0001C\u0005\u0003{C\u0001\"a1\u0001\t\u0003Y\u0016Q\u0019\u0005\b\u0003W\u0004A\u0011AAw\u0011!\u0011\u0019\u0002\u0001C\u00017\nU\u0001\u0002\u0003B!\u0001\u0011\u00051La\u0011\t\u000f\tM\u0003\u0001\"\u0001\u0003V!9!\u0011\f\u0001\u0005\u0002\tm\u0003b\u0002B1\u0001\u0011\u0005\u00111\f\u0005\b\u0005G\u0002A\u0011AA.\u0011!\u0011)\u0007\u0001C\u00017\n\u001d\u0004\u0002\u0003B8\u0001\u0011\u00051La\u001a\t\u0011\tE\u0004\u0001\"\u0001\\\u0005OBqAa\u001d\u0001\t\u0003\u0011)\b\u0003\u0005\u0003|\u0001!\ta\u0017B?\u0011\u001d\u0011\t\t\u0001C\u0001\u00037BqAa!\u0001\t\u0003\u0011)\tC\u0004\u0003\f\u0002!\tA!$\t\u000f\t]\u0005\u0001\"\u0001\u0003\u001a\"9!1\u0014\u0001\u0005\u0002\tu\u0005b\u0002BS\u0001\u0011\u0005!q\u0015\u0005\b\u0005\u001f\u0004A\u0011\u0001Bi\u0011\u001d\u0011I\u000e\u0001C\u0005\u00057DqA!9\u0001\t\u0003\u0011\u0019\u000fC\u0004\u0003|\u0002!IA!@\t\u000f\r\u0005\u0001\u0001\"\u0001\u0004\u0004!I1\u0011\f\u0001\u0012\u0002\u0013\u000511\f\u0005\b\u0007c\u0002A\u0011AB:\u0011\u001d\u0019Y\b\u0001C\u0001\u0007{B\u0001b!'\u0001\t\u0003Y61\u0014\u0005\t\u0007K\u0003A\u0011A.\u0004(\"A1\u0011\u0017\u0001\u0005\u0002m\u001b\u0019\f\u0003\u0006\u0004>\u0002\t\n\u0011\"\u0001\\\u0007\u007fC\u0001ba1\u0001\t\u0003Y&q\r\u0004\u0007\u0007\u000f\u0001\u0001a!\u0003\t\u0015\r-\u0011H!A!\u0002\u0013\t9\u0003\u0003\u0006\u0004\u000ee\u0012\t\u0011)A\u0005\u0003\u007fDq!a\u0002:\t\u0003\u0019yA\u0002\u0004\u0004\u0016e\u00021q\u0003\u0005\b\u0003\u000fiD\u0011AB\u0010\u0011\u001d\u0019)#\u0010C\u0001\u0007OA\u0011b!\f>\u0005\u0004%Iaa\f\t\u0011\r]R\b)A\u0005\u0007cA\u0011b!\u000f>\u0005\u0004%Iaa\u000f\t\u0011\r\rS\b)A\u0005\u0007{Aqa!\u0012>\t\u0003\u001a9\u0005C\u0004\u0004Ju\"\tea\u0013\t\u000f\r5S\b\"\u0001\u0004P!91\u0011K\u001f\u0005\u0002\r-\u0003bBB*s\u0011\u00053QK\u0004\b\u0007\u000b\\\u0006\u0012ABd\r\u0019Q6\f#\u0001\u0004J\"9\u0011q\u0001&\u0005\u0002\r-\u0007\"CBg\u0015\n\u0007I\u0011BA.\u0011!\u0019yM\u0013Q\u0001\n\u0005u\u0003\"CBi\u0015\n\u0007I\u0011BA.\u0011!\u0019\u0019N\u0013Q\u0001\n\u0005u\u0003\"CBk\u0015\n\u0007I\u0011BA.\u0011!\u00199N\u0013Q\u0001\n\u0005u\u0003\"CBm\u0015\n\u0007I\u0011AA.\u0011!\u0019YN\u0013Q\u0001\n\u0005u\u0003\"CBo\u0015\n\u0007I\u0011AA.\u0011!\u0019yN\u0013Q\u0001\n\u0005u\u0003\"CBq\u0015\n\u0007I\u0011AA.\u0011!\u0019\u0019O\u0013Q\u0001\n\u0005u\u0003bBBs\u0015\u0012\u00051q\u001d\u0005\b\u0007WTE\u0011ABw\u0005)iU-\u001c9p_2l\u0015\r\u001d\u0006\u00039v\u000bq!\\3na>|GN\u0003\u0002_?\u00069\u0011mY2pk:$(B\u00011b\u0003\u001dAwN]5{K:T\u0011AY\u0001\u0003S>\u001c\u0001aE\u0002\u0001K.\u0004\"AZ5\u000e\u0003\u001dT\u0011\u0001[\u0001\u0006g\u000e\fG.Y\u0005\u0003U\u001e\u0014a!\u00118z%\u00164\u0007C\u00017r\u001b\u0005i'B\u00018p\u0003\u0011)H/\u001b7\u000b\u0003A\faa\u001d9be.T\u0018B\u0001:n\u00055\u0019\u0006/\u0019:lu2{wmZ5oO\u0006Q\u0012mY2pk:$8\u000b^1uKJ+\u0017\rZ3s!J|g/\u001b3feB\u0011Q\u000f_\u0007\u0002m*\u0011q/X\u0001\u0006gR\fG/Z\u0005\u0003sZ\u0014!$Q2d_VtGo\u0015;bi\u0016\u0014V-\u00193feB\u0013xN^5eKJ\fqCY1tKN#\u0018\r^3SK\u0006$WM\u001d)s_ZLG-\u001a:\u0011\u0005Ud\u0018BA?w\u0005]\u0011\u0015m]3Ti\u0006$XMU3bI\u0016\u0014\bK]8wS\u0012,'/A\bnK6\u0004xn\u001c7TKR$\u0018N\\4t!\u0011\t\t!a\u0001\u000e\u0003}K1!!\u0002`\u0005Y\t5mY8v]RlU-\u001c9p_2\u001cV\r\u001e;j]\u001e\u001c\u0018A\u0002\u001fj]&$h\b\u0006\u0005\u0002\f\u0005=\u0011\u0011CA\n!\r\ti\u0001A\u0007\u00027\")1\u000f\u0002a\u0001i\")!\u0010\u0002a\u0001w\")a\u0010\u0002a\u0001\u007f\nqA\u000b_%e\u0005ftuN\\2f\u001b\u0006\u0004\b\u0003CA\r\u0003G\t9#a\u000e\u000e\u0005\u0005m!\u0002BA\u000f\u0003?\tq!\\;uC\ndWMC\u0002\u0002\"\u001d\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\t)#a\u0007\u0003\u0013M{'\u000f^3e\u001b\u0006\u0004\b\u0003BA\u0015\u0003gi!!a\u000b\u000b\t\u00055\u0012qF\u0001\u0005[\u0006$\bN\u0003\u0002\u00022\u0005!!.\u0019<b\u0013\u0011\t)$a\u000b\u0003\u0015\tKw-\u00138uK\u001e,'\u000f\u0005\u0003\u0002:\u00055c\u0002BA\u001e\u0003\u0013rA!!\u0010\u0002H9!\u0011qHA#\u001b\t\t\tEC\u0002\u0002D\r\fa\u0001\u0010:p_Rt\u0014\"\u00019\n\u00059|\u0017bAA&[\u00069\u0001/Y2lC\u001e,\u0017\u0002BA(\u0003#\u0012!\"T8eS\u001aLWM]%e\u0015\r\tY%\\\u0001\u0013[\u0006D\u0018\t\u001c7po\u0016$gj\u001c8dK\u001e\u000b\u0007/\u0006\u0002\u0002(\u0005\u0019R.\u0019=BY2|w/\u001a3O_:\u001cWmR1qA\u0005\u0011R*\u0019=TY>$8\u000fU3s\u0003\u000e\u001cw.\u001e8u+\t\ti\u0006E\u0002g\u0003?J1!!\u0019h\u0005\rIe\u000e^\u0001\u0014\u001b\u0006D8\u000b\\8ugB+'/Q2d_VtG\u000fI\u0001\u0010\u001b\u0006DX*Z7Q_>d7\u000b\\8ug\u0006\u0001R*\u0019=NK6\u0004vn\u001c7TY>$8\u000fI\u0001\u0017\u001b\u0006Dhj\u001c8Fq\u0016\u001c7+\u001e2Q_>d7\u000b\\8ug\u00069R*\u0019=O_:,\u00050Z2Tk\n\u0004vn\u001c7TY>$8\u000fI\u0001\u000b)bd\u0015NZ3uS6,WCAA9!\u0011\t\u0019(! \u000e\u0005\u0005U$\u0002BA<\u0003s\n\u0001\u0002Z;sCRLwN\u001c\u0006\u0004\u0003w:\u0017AC2p]\u000e,(O]3oi&!\u0011qPA;\u000591\u0015N\\5uK\u0012+(/\u0019;j_:\f1\u0002\u0016=MS\u001a,G/[7fA\u00059A\u000f_\"bG\",WCAAD!\u0011\ti!!#\n\u0007\u0005-5LA\u0004Uq\u000e\u000b7\r[3\u0002\u0011QD8)Y2iK\u0002\nQ\"\u001a=fGV$\u0018M\u00197f)b\u001cXCAAJ!!\t)*!'\u0002\u001e\u0006%VBAAL\u0015\u0011\tY(a\b\n\t\u0005m\u0015q\u0013\u0002\b)JLW-T1q!\u0011\ty*!*\u000e\u0005\u0005\u0005&bAAR?\u0006Y\u0001O]8q_NLG/[8o\u0013\u0011\t9+!)\u0003\u0017A\u0013x\u000e]8tSRLwN\u001c\t\u0004\u0003W+Q\"\u0001\u0001\u0002\u001d\u0015DXmY;uC\ndW\r\u0016=tA\u0005\u0001bn\u001c8Fq\u0016\u001cW\u000f^1cY\u0016$\u0006p]\u0001\u0012]>tW\t_3dkR\f'\r\\3UqN\u0004\u0013A\u00028p]\u000e,7/\u0006\u0002\u00028BA\u0011QSAM\u0003;\u000b9#A\u0004o_:\u001cWm\u001d\u0011\u0002+\u001d,G/T1y\u0003\u000e\u001cW\r\u001d;bE2,gj\u001c8dKR!\u0011qEA`\u0011\u001d\t\t\r\u0007a\u0001\u0003O\t!b\u001d;bi\u0016tuN\\2f\u0003M1\u0017N\u001c3Uq^KG\u000f[*b[\u0016tuN\\2f)\u0019\t9-!:\u0002hB)a-!3\u0002N&\u0019\u00111Z4\u0003\r=\u0003H/[8o!!\ty-!6\u0002\u001e\u0006eWBAAi\u0015\r\t\u0019.X\u0001\fiJ\fgn]1di&|g.\u0003\u0003\u0002X\u0006E'AE!dG>,h\u000e\u001e+sC:\u001c\u0018m\u0019;j_:\u0004b!a7\u0002b\u0006uUBAAo\u0015\r\tynX\u0001\u0006aJ|wNZ\u0005\u0005\u0003G\fiNA\u0003Qe>|g\r\u0003\u0004_3\u0001\u0007\u0011Q\u0014\u0005\b\u0003SL\u0002\u0019AA\u0014\u0003\u0015qwN\\2f\u0003\r\tG\r\u001a\u000b\u0005\u0003_\u0014y\u0001\u0005\u0004\u0002r\u0006U\u0018\u0011`\u0007\u0003\u0003gT!A\\4\n\t\u0005]\u00181\u001f\u0002\u0004)JL\bc\u00024\u0002|\u0006-\u0011q`\u0005\u0004\u0003{<'A\u0002+va2,'\u0007\u0005\u0004\u0003\u0002\t%\u0011Q\u001a\b\u0005\u0005\u0007\u00119A\u0004\u0003\u0002@\t\u0015\u0011\"\u00015\n\u0007\u0005-s-\u0003\u0003\u0003\f\t5!\u0001C%uKJ\f'\r\\3\u000b\u0007\u0005-s\rC\u0004\u0003\u0012i\u0001\r!!4\u0002\u001d\u0015$\b\u000e\u0016:b]N\f7\r^5p]\u0006\t\u0012\r\u001a3OK^$&/\u00198tC\u000e$\u0018n\u001c8\u0015\u0011\t]!\u0011\u0004B\u000f\u0005?\u0001RAZAe\u0003oAqAa\u0007\u001c\u0001\u0004\tI+\u0001\u0007uq\nKhj\u001c8dK6\u000b\u0007\u000fC\u0004\u0003\u0012m\u0001\r!!4\t\u000f\t\u00052\u00041\u0001\u0003$\u0005QQ\r_3d'R\fG/^:\u0011\t\t\u0015\"1\b\b\u0005\u0005O\u00119D\u0004\u0003\u0003*\tUb\u0002\u0002B\u0016\u0005gqAA!\f\u000329!\u0011q\bB\u0018\u0013\u0005\u0011\u0017B\u00011b\u0013\tqv,\u0003\u0002];&\u0019!\u0011H.\u0002%QCX\t_3dkR\f'\r\\3Ti\u0006$Xo]\u0005\u0005\u0005{\u0011yD\u0001\nUq\u0016CXmY;uC\ndWm\u0015;biV\u001c(b\u0001B\u001d7\u0006\u0011\"/\u001a9mC\u000e,GK]1og\u0006\u001cG/[8o))\u00119B!\u0012\u0003J\t5#\u0011\u000b\u0005\b\u0005\u000fb\u0002\u0019AA\u001c\u00031)\u00070[:uS:<G\u000b_%e\u0011\u001d\u0011Y\u0005\ba\u0001\u0003\u001b\fQA\\3x)bDqAa\u0014\u001d\u0001\u0004\tI+A\bnCB|e\r\u0016=t\u0005ftuN\\2f\u0011\u001d\u0011\t\u0003\ba\u0001\u0005G\tqbZ3u\u0003\u000e\u001cw.\u001e8u'2|Go\u001d\u000b\u0005\u0003;\u00129\u0006\u0003\u0004_;\u0001\u0007\u0011QT\u0001\u0010O\u0016$\u0018iY2pk:$hj\u001c8dKR!!Q\fB0!\u00151\u0017\u0011ZA\u0014\u0011\u0019qf\u00041\u0001\u0002\u001e\u0006)r-\u001a;NK6\u0004xn\u001c7TSj,\u0017J\\*m_R\u001c\u0018\u0001H4fi:{g.\u0012=fGN+(\r]8pYNK'0Z%o'2|Go]\u0001\u0011MJ,W-T3na>|Gn\u00157piN$\"A!\u001b\u0011\u0007\u0019\u0014Y'C\u0002\u0003n\u001d\u0014A!\u00168ji\u00069bM]3f\u001d>tW\t_3d'V\u0014\u0007o\\8m'2|Go]\u0001\u001be\u0016lwN^3US6,Gm\\;u)J\fgn]1di&|gn]\u0001\u0012e\u0016lwN^3Ge>lW*Z7q_>dG\u0003\u0002B<\u0005s\u0002b!!=\u0002v\u0006-\u0001b\u0002B\tI\u0001\u0007\u0011QZ\u0001\u0007e\u0016lwN^3\u0015\t\t]$q\u0010\u0005\b\u0005#)\u0003\u0019AAg\u0003\u0011\u0019\u0018N_3\u0002\u001d\u001d,G\u000f\u0016:b]N\f7\r^5p]R!\u0011q\u0019BD\u0011\u001d\u0011Ii\na\u0001\u0003o\tA\u0001\u001e=JI\u0006A1m\u001c8uC&t7\u000f\u0006\u0003\u0003\u0010\nU\u0005c\u00014\u0003\u0012&\u0019!1S4\u0003\u000f\t{w\u000e\\3b]\"9!\u0011\u0012\u0015A\u0002\u0005]\u0012A\u0002<bYV,7/\u0006\u0002\u0002\u0000\u0006\u0019R.Z7q_>dGK]1og\u0006\u001cG/[8ogR!!q\u0014BQ!\u0019\u0011\tA!\u0003\u00028!9!1\u0015\u0016A\u0002\t=\u0015AC3yK\u000e,H/\u00192mK\u00061R.Z7q_>dGK]1og\u0006\u001cG/[8og6\u000b\u0007\u000f\u0006\u0003\u0003*\n5\u0007\u0003CAK\u00033\u0013YKa.\u0011\t\t5&1W\u0007\u0003\u0005_S1A!-`\u0003\r)g/\\\u0005\u0005\u0005k\u0013yKA\u0004BI\u0012\u0014Xm]:\u0011\u0011\u0005e\u00111EA\u0014\u0005s\u0003BAa/\u0003J6\u0011!Q\u0018\u0006\u0005\u0005\u007f\u0013\t-A\u0003usB,7O\u0003\u0003\u0003D\n\u0015\u0017a\u0001:qG*\u0019!qY/\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0003L\nu&aF#uQ\u0016\u0014X-^7Ue\u0006t7/Y2uS>tg+[3x\u0011\u001d\u0011\u0019k\u000ba\u0001\u0005\u001f\u000b!$\\3na>|G\u000e\u0016:b]N\f7\r^5p]Nl\u0015\r\u001d$s_6$bAa.\u0003T\nU\u0007b\u0002BRY\u0001\u0007!q\u0012\u0005\b\u0005/d\u0003\u0019\u0001BV\u0003-1'o\\7BI\u0012\u0014Xm]:\u00021I,GO]5fm\u0016$\u0006\u0010U8pY\nKhj\u001c8dK6\u000b\u0007\u000f\u0006\u0003\u00038\nu\u0007b\u0002Bp[\u0001\u0007\u0011\u0011V\u0001\u000fibLEMQ=O_:\u001cW-T1q\u0003uiW-\u001c9p_2$&/\u00198tC\u000e$\u0018n\u001c8t\u001b\u0006\u0004\u0018J\\:qK\u000e$H\u0003\u0002Bs\u0005s\u0004\u0002\"!&\u0002\u001a\n-&q\u001d\t\t\u00033\t\u0019#a\n\u0003jB!!1\u001eBz\u001d\u0011\u0011iOa<\u0011\u0007\u0005}r-C\u0002\u0003r\u001e\fa\u0001\u0015:fI\u00164\u0017\u0002\u0002B{\u0005o\u0014aa\u0015;sS:<'b\u0001ByO\"9!1\u0015\u0018A\u0002\t=\u0015a\u0007:fiJLWM^3Uq&s7\u000f]3di\nKhj\u001c8dK6\u000b\u0007\u000f\u0006\u0003\u0003h\n}\bb\u0002Bp_\u0001\u0007\u0011\u0011V\u0001\u0012i\u0006\\W-\u0012=fGV$\u0018M\u00197f)b\u001cH\u0003BB\u0003\u0007/\u00022!a+:\u0005m!&/\u00198tC\u000e$\u0018n\u001c8t\u0005f\u0004&/[2f\u0003:$gj\u001c8dKN!\u0011(ZA\u0000\u0003\u001d\u0011\u0017m]3GK\u0016\f\u0001BZ8sG\u0016$G\u000b\u001f\u000b\u0007\u0007\u000b\u0019\tba\u0005\t\u000f\r-A\b1\u0001\u0002(!91Q\u0002\u001fA\u0002\u0005}(\u0001B%uKJ\u001cB!P3\u0004\u001aA!\u0011QBB\u000e\u0013\r\u0019ib\u0017\u0002 )J\fgn]1di&|gn\u001d\"z!JL7-Z!oI:{gnY3Ji\u0016\u0014HCAB\u0011!\r\u0019\u0019#P\u0007\u0002s\u00059A\u000f_(sI\u0016\u0014H\u0003BA\u0014\u0007SAqaa\u000b@\u0001\u0004\ti-\u0001\u0002uq\u0006iam\u001c:dK\u0012$\u00060U;fk\u0016,\"a!\r\u0011\r\u0005e11GAg\u0013\u0011\u0019)$a\u0007\u0003\u000bE+X-^3\u0002\u001d\u0019|'oY3e)b\fV/Z;fA\u0005aqN\u001d3fe\u0016$\u0017+^3vKV\u00111Q\b\t\u0007\u00033\u0019y$!4\n\t\r\u0005\u00131\u0004\u0002\u000e!JLwN]5usF+X-^3\u0002\u001b=\u0014H-\u001a:fIF+X-^3!\u0003\u001dA\u0017m\u001d(fqR,\"Aa$\u0002\t9,\u0007\u0010\u001e\u000b\u0003\u0003\u001b\fA\u0001]3fWV\u0011\u0011QZ\u0001\u0015e\u0016lwN^3B]\u0012\u001c6.\u001b9BG\u000e|WO\u001c;\u0002\u0011%$XM]1u_J,\"a!\u0007\t\u0013\r5\u0001\u0007%AA\u0002\u0005}\u0018a\u0007;bW\u0016,\u00050Z2vi\u0006\u0014G.\u001a+yg\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0004^)\"\u0011q`B0W\t\u0019\t\u0007\u0005\u0003\u0004d\r5TBAB3\u0015\u0011\u00199g!\u001b\u0002\u0013Ut7\r[3dW\u0016$'bAB6O\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\r=4Q\r\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017aD2b]B\u000b\u0017\u0010S5hQ\u0016\u0014h)Z3\u0015\r\t=5QOB<\u0011\u001d\u0011YE\ra\u0001\u0003\u001bDqa!\u001f3\u0001\u0004\ti-A\u0003pY\u0012$\u00060A\u0007va\u0012\fG/Z'f[B{w\u000e\u001c\u000b\u0007\u0003\u007f\u001cyh!&\t\u000f\r\u00055\u00071\u0001\u0004\u0004\u0006q!/\u001a6fGR,GM\u00117pG.\u001c\bC\u0002B\u0001\u0007\u000b\u001bI)\u0003\u0003\u0004\b\n5!aA*fcB!11RBI\u001b\t\u0019iIC\u0002\u0004\u0010v\u000bQA\u00197pG.LAaa%\u0004\u000e\na\u0011iY2pk:$(\t\\8dW\"91qS\u001aA\u0002\r\r\u0015!D1qa2LW\r\u001a\"m_\u000e\\7/\u0001\u0010va\u0012\fG/Z!dG>,h\u000e^,ji\"\u0014VM^3si\u0016$gj\u001c8dKR1\u0011q`BO\u0007?CaA\u0018\u001bA\u0002\u0005u\u0005bBBQi\u0001\u000711U\u0001\u0016ib\u001chI]8n%\u0016TWm\u0019;fI\ncwnY6t!\u0019\u0011\ta!\"\u0002N\u0006qR\r_5tiJ+'.Z2uK\u0012$\u0006p],ji\"4\u0016\r\\5e\u001d>t7-\u001a\u000b\u0007\u0005\u001f\u001bIk!,\t\u000f\r-V\u00071\u0001\u0004$\u0006Y!/\u001a6fGR,G\r\u0016=t\u0011\u001d\u0019y+\u000ea\u0001\u0003O\tQ\"\u001a=qK\u000e$X\r\u001a(p]\u000e,\u0017!D;qI\u0006$X-Q2d_VtG\u000f\u0006\u0005\u0002\u0000\u000eU6qWB^\u0011\u0019qf\u00071\u0001\u0002\u001e\"91\u0011\u0018\u001cA\u0002\u0005\u001d\u0012!\u00078p]\u000e,wJ\u001a+iK2\u000bG/Z:u\u0003B\u0004H.[3e)bD\u0011b!)7!\u0003\u0005\raa)\u0002/U\u0004H-\u0019;f\u0003\u000e\u001cw.\u001e8uI\u0011,g-Y;mi\u0012\u001aTCABaU\u0011\u0019\u0019ka\u0018\u0002!\rDWmY6NK6\u0004xn\u001c7TSj,\u0017AC'f[B|w\u000e\\'baB\u0019\u0011Q\u0002&\u0014\u0005)+GCABd\u0003U\tE\r\u001a(fo\u0016CXm\u0019+sC:\u001c\u0018m\u0019;j_:\fa#\u00113e\u001d\u0016<X\t_3d)J\fgn]1di&|g\u000eI\u0001\u001f\u0003\u0012$wJ\u001d*fa2\f7-\u001a(p]\u0016CXm\u0019+sC:\u001c\u0018m\u0019;j_:\fq$\u00113e\u001fJ\u0014V\r\u001d7bG\u0016tuN\\#yK\u000e$&/\u00198tC\u000e$\u0018n\u001c8!\u0003Y\u0011V\r\u001d7bG\u0016,\u00050Z2Ue\u0006t7/Y2uS>t\u0017a\u0006*fa2\f7-Z#yK\u000e$&/\u00198tC\u000e$\u0018n\u001c8!\u0003)!\u0006p\u00157piNK'0Z\u0001\f)b\u001cFn\u001c;TSj,\u0007%\u0001\nNCbtU/\\(g'2|Go\u001d$peRC\u0018aE'bq:+Xn\u00144TY>$8OR8s)b\u0004\u0013!C'bqRC8+\u001b>f\u0003)i\u0015\r\u001f+y'&TX\rI\u0001\rib\u001c\u0016N_3J]Ncw\u000e\u001e\u000b\u0005\u0003;\u001aI\u000fC\u0004\u0004,a\u0003\r!!4\u0002\u0015ML'0\u001a+p'2|G\u000f\u0006\u0003\u0002^\r=\bbBBy3\u0002\u000711_\u0001\u000b]VlwJ\u001a\"zi\u0016\u001c\bc\u00014\u0004v&\u00191q_4\u0003\t1{gn\u001a")
public class MempoolMap
implements SparkzLogging {
    private final AccountStateReaderProvider accountStateReaderProvider;
    private final BaseStateReaderProvider baseStateReaderProvider;
    private final BigInteger maxAllowedNonceGap;
    private final int MaxSlotsPerAccount;
    private final int MaxMemPoolSlots;
    private final int MaxNonExecSubPoolSlots;
    private final FiniteDuration TxLifetime;
    private final TxCache txCache;
    private final TrieMap<Proposition, SortedMap<BigInteger, String>> io$horizen$account$mempool$MempoolMap$$executableTxs;
    private final TrieMap<Proposition, SortedMap<BigInteger, String>> nonExecutableTxs;
    private final TrieMap<Proposition, BigInteger> nonces;
    private final Logger logger;

    public static int sizeToSlot(long l) {
        return MempoolMap$.MODULE$.sizeToSlot(l);
    }

    public static int txSizeInSlot(AccountTransaction<Proposition, Proof<Proposition>> accountTransaction) {
        return MempoolMap$.MODULE$.txSizeInSlot(accountTransaction);
    }

    public static int MaxTxSize() {
        return MempoolMap$.MODULE$.MaxTxSize();
    }

    public static int MaxNumOfSlotsForTx() {
        return MempoolMap$.MODULE$.MaxNumOfSlotsForTx();
    }

    public static int TxSlotSize() {
        return MempoolMap$.MODULE$.TxSlotSize();
    }

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private BigInteger maxAllowedNonceGap() {
        return this.maxAllowedNonceGap;
    }

    private int MaxSlotsPerAccount() {
        return this.MaxSlotsPerAccount;
    }

    private int MaxMemPoolSlots() {
        return this.MaxMemPoolSlots;
    }

    private int MaxNonExecSubPoolSlots() {
        return this.MaxNonExecSubPoolSlots;
    }

    private FiniteDuration TxLifetime() {
        return this.TxLifetime;
    }

    private TxCache txCache() {
        return this.txCache;
    }

    public TrieMap<Proposition, SortedMap<BigInteger, String>> io$horizen$account$mempool$MempoolMap$$executableTxs() {
        return this.io$horizen$account$mempool$MempoolMap$$executableTxs;
    }

    private TrieMap<Proposition, SortedMap<BigInteger, String>> nonExecutableTxs() {
        return this.nonExecutableTxs;
    }

    private TrieMap<Proposition, BigInteger> nonces() {
        return this.nonces;
    }

    private BigInteger getMaxAcceptableNonce(BigInteger stateNonce) {
        return stateNonce.add(this.maxAllowedNonceGap());
    }

    public Option<AccountTransaction<Proposition, Proof<Proposition>>> findTxWithSameNonce(Proposition account, BigInteger nonce) {
        Option txOpt = this.io$horizen$account$mempool$MempoolMap$$executableTxs().get((Object)account).flatMap((Function1 & Serializable & scala.Serializable)txMap -> txMap.get((Object)nonce).map((Function1 & Serializable & scala.Serializable)x$1 -> this.txCache().apply((String)x$1)));
        return txOpt.orElse((Function0 & Serializable & scala.Serializable)() -> this.nonExecutableTxs().get((Object)account).flatMap((Function1 & Serializable & scala.Serializable)txMap -> txMap.get((Object)nonce).map((Function1 & Serializable & scala.Serializable)x$2 -> this.txCache().apply((String)x$2))));
    }

    public Try<Tuple2<MempoolMap, Iterable<AccountTransaction<Proposition, Proof<Proposition>>>>> add(AccountTransaction<Proposition, Proof<Proposition>> ethTransaction) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(ethTransaction instanceof EthereumTransaction, (Function0 & Serializable & scala.Serializable)() -> "Transaction is not EthereumTransaction");
            ListBuffer promotedTxs = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            if (!this.contains(ethTransaction.id())) {
                ListBuffer listBuffer;
                int n;
                Object account = ethTransaction.getFrom();
                long txSize = ethTransaction.size();
                if (txSize > (long)MempoolMap$.MODULE$.MaxTxSize()) {
                    BoxedUnit boxedUnit;
                    if (this.log().underlying().isTraceEnabled()) {
                        this.log().underlying().trace(new java.lang.StringBuilder(77).append("Transaction ").append(ethTransaction).append(" size exceeds maximum allowed size: current size ").append(txSize).append(", ").append("maximum size: ").append(MempoolMap$.MODULE$.MaxTxSize()).toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    throw new TxOversizedException(((AddressProposition)account).address(), txSize);
                }
                BigInteger stateNonce = $this.accountStateReaderProvider.getAccountStateReader().getNonce(((AddressProposition)account).address());
                BigInteger maxAcceptableNonce = this.getMaxAcceptableNonce(stateNonce);
                if (ethTransaction.getNonce().compareTo(maxAcceptableNonce) > 0) {
                    BoxedUnit boxedUnit;
                    if (this.log().underlying().isTraceEnabled()) {
                        this.log().underlying().trace(new java.lang.StringBuilder(117).append("Transaction ").append(ethTransaction).append(" nonce gap respect state nonce exceeds maximum allowed size: tx nonce ").append(ethTransaction.getNonce()).append(", ").append("state nonce: ").append(stateNonce).append(", maximum nonce gap ").append(this.maxAllowedNonceGap()).toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    throw new NonceGapTooWideException(ethTransaction.id(), ethTransaction.getNonce(), stateNonce);
                }
                Option<AccountTransaction<Proposition, Proof<Proposition>>> txToReplaceOpt = this.findTxWithSameNonce((Proposition)account, ethTransaction.getNonce());
                Option<AccountTransaction<Proposition, Proof<Proposition>>> option = txToReplaceOpt;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    AccountTransaction txToReplace = (AccountTransaction)some.value();
                    if (!this.canPayHigherFee(ethTransaction, txToReplace)) {
                        BoxedUnit boxedUnit;
                        if (this.log().underlying().isTraceEnabled()) {
                            this.log().underlying().trace("Transaction {} cannot replace {} because it is underpriced", (Object[])new AccountTransaction[]{ethTransaction, txToReplace});
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        throw new TransactionReplaceUnderpricedException(ethTransaction.id());
                    }
                    n = MempoolMap$.MODULE$.txSizeInSlot(txToReplace);
                } else if (None$.MODULE$.equals(option)) {
                    n = 0;
                } else {
                    throw new MatchError(option);
                }
                int numOfSlotsOfTxToReplace = n;
                int newTxSizeInSlot = MempoolMap$.MODULE$.sizeToSlot(txSize);
                int additionalSlots = package$.MODULE$.max(newTxSizeInSlot - numOfSlotsOfTxToReplace, 0);
                int accountSlotsNumber = this.getAccountSlots((Proposition)account);
                if (accountSlotsNumber + additionalSlots > this.MaxSlotsPerAccount()) {
                    BoxedUnit boxedUnit;
                    if (this.log().underlying().isTraceEnabled()) {
                        this.log().underlying().trace("Adding transaction {} exceeds maximum allowed size per account ({} slots)", new Object[]{ethTransaction, BoxesRunTime.boxToInteger((int)this.MaxSlotsPerAccount())});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    throw new AccountMemPoolOutOfBoundException(ethTransaction.id());
                }
                BigInteger expectedNonce = (BigInteger)this.nonces().getOrElseUpdate(account, (Function0 & Serializable & scala.Serializable)() -> stateNonce);
                int n2 = expectedNonce.compareTo(ethTransaction.getNonce());
                if (MempoolMap$.MODULE$.io$horizen$account$mempool$MempoolMap$$AddNewExecTransaction() == n2) {
                    SortedMap executableTxsPerAccount = (SortedMap)this.io$horizen$account$mempool$MempoolMap$$executableTxs().getOrElseUpdate(account, (Function0 & Serializable & scala.Serializable)() -> new TreeMap(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())));
                    this.addNewTransaction((SortedMap<BigInteger, String>)executableTxsPerAccount, ethTransaction, TxExecutableStatus$.MODULE$.EXEC());
                    promotedTxs.$plus$eq((Object)ethTransaction);
                    ObjectRef nextNonce = ObjectRef.create((Object)expectedNonce.add(BigInteger.ONE));
                    this.nonExecutableTxs().get(account).foreach((Function1 & Serializable & scala.Serializable)nonExecTxsPerAccount -> {
                        Option candidateToPromotionTx = nonExecTxsPerAccount.remove((Object)((BigInteger)nextNonce$1.elem));
                        while (candidateToPromotionTx.isDefined()) {
                            String promotedTxId = (String)candidateToPromotionTx.get();
                            executableTxsPerAccount.put((Object)((BigInteger)nextNonce$1.elem), (Object)promotedTxId);
                            promotedTxs.$plus$eq(this.txCache().promoteTransaction(promotedTxId));
                            nextNonce$1.elem = ((BigInteger)nextNonce$1.elem).add(BigInteger.ONE);
                            candidateToPromotionTx = nonExecTxsPerAccount.remove((Object)((BigInteger)nextNonce$1.elem));
                        }
                        return nonExecTxsPerAccount.isEmpty() ? this.nonExecutableTxs().remove(account) : BoxedUnit.UNIT;
                    });
                    listBuffer = this.nonces().put(account, (Object)((BigInteger)nextNonce.elem));
                } else if (MempoolMap$.MODULE$.io$horizen$account$mempool$MempoolMap$$AddOrReplaceNonExecTransaction() == n2) {
                    SortedMap nonExecTxsPerAccount2 = (SortedMap)this.nonExecutableTxs().getOrElseUpdate(account, (Function0 & Serializable & scala.Serializable)() -> new TreeMap(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())));
                    listBuffer = txToReplaceOpt.isDefined() ? this.replaceTransaction(((Transaction)txToReplaceOpt.get()).id(), ethTransaction, (SortedMap<BigInteger, String>)nonExecTxsPerAccount2, TxExecutableStatus$.MODULE$.NON_EXEC()) : this.addNewTransaction((SortedMap<BigInteger, String>)nonExecTxsPerAccount2, ethTransaction, TxExecutableStatus$.MODULE$.NON_EXEC());
                } else if (MempoolMap$.MODULE$.io$horizen$account$mempool$MempoolMap$$ReplaceExecTransaction() == n2) {
                    SortedMap executableTxsPerAccount = (SortedMap)this.io$horizen$account$mempool$MempoolMap$$executableTxs().apply(account);
                    this.replaceTransaction(((Transaction)txToReplaceOpt.get()).id(), ethTransaction, (SortedMap<BigInteger, String>)executableTxsPerAccount, TxExecutableStatus$.MODULE$.EXEC());
                    listBuffer = promotedTxs.$plus$eq(txToReplaceOpt.get());
                } else {
                    throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n2));
                }
                this.checkMempoolSize();
            }
            return new Tuple2((Object)this, (Object)promotedTxs);
        });
    }

    public Option<String> addNewTransaction(SortedMap<BigInteger, String> txByNonceMap, AccountTransaction<Proposition, Proof<Proposition>> ethTransaction, Enumeration.Value execStatus) {
        this.txCache().add(ethTransaction, execStatus);
        return txByNonceMap.put((Object)ethTransaction.getNonce(), (Object)ethTransaction.id());
    }

    public Option<String> replaceTransaction(String existingTxId, AccountTransaction<Proposition, Proof<Proposition>> newTx, SortedMap<BigInteger, String> mapOfTxsByNonce, Enumeration.Value execStatus) {
        this.txCache().remove(existingTxId);
        this.txCache().add(newTx, execStatus);
        return mapOfTxsByNonce.put((Object)newTx.getNonce(), (Object)newTx.id());
    }

    public int getAccountSlots(Proposition account) {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)Option$.MODULE$.option2Iterable(this.io$horizen$account$mempool$MempoolMap$$executableTxs().get((Object)account)).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.nonExecutableTxs().get((Object)account)), scala.collection.Iterable$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> x$3.values(), scala.collection.Iterable$.MODULE$.canBuildFrom())).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable & scala.Serializable)(sum, txId) -> BoxesRunTime.boxToInteger((int)MempoolMap.$anonfun$getAccountSlots$2(this, BoxesRunTime.unboxToInt((Object)sum), txId))));
    }

    public Option<BigInteger> getAccountNonce(Proposition account) {
        return this.nonces().get((Object)account);
    }

    public int getMempoolSizeInSlots() {
        return this.txCache().getSizeInSlots();
    }

    public int getNonExecSubpoolSizeInSlots() {
        return this.txCache().getNonExecSizeInSlots();
    }

    public void freeMempoolSlots() {
        do {
            BoxedUnit boxedUnit;
            Option<AccountTransaction<Proposition, Proof<Proposition>>> oldestTx = this.txCache().getOldestTransaction();
            if (this.log().underlying().isTraceEnabled()) {
                this.log().underlying().trace("Evicting transaction {}", new Object[]{oldestTx});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.remove((AccountTransaction)oldestTx.get());
        } while (this.getMempoolSizeInSlots() > this.MaxMemPoolSlots());
    }

    public void freeNonExecSubpoolSlots() {
        TxCache.NonExecTransactionIterator nonExecIter = this.txCache().getNonExecIterator();
        do {
            BoxedUnit boxedUnit;
            AccountTransaction<Proposition, Proof<Proposition>> oldestTx = nonExecIter.next();
            if (this.log().underlying().isTraceEnabled()) {
                this.log().underlying().trace("Evicting transaction {}", new Object[]{oldestTx});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.remove(oldestTx);
        } while (this.getNonExecSubpoolSizeInSlots() > this.MaxNonExecSubPoolSlots());
    }

    public void removeTimedoutTransactions() {
        Option<TxMetaInfo> oldestTxInfoOpt = this.txCache().getOldestTransactionInfo();
        while (oldestTxInfoOpt.isDefined() && ((TxMetaInfo)oldestTxInfoOpt.get()).hasTimedOut()) {
            BoxedUnit boxedUnit;
            if (this.log().underlying().isTraceEnabled()) {
                this.log().underlying().trace("Removing timed out transaction {}", new Object[]{((TxMetaInfo)oldestTxInfoOpt.get()).tx()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.remove(((TxMetaInfo)oldestTxInfoOpt.get()).tx());
            oldestTxInfoOpt = this.txCache().getOldestTransactionInfo();
        }
    }

    public Try<MempoolMap> removeFromMempool(AccountTransaction<Proposition, Proof<Proposition>> ethTransaction) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            block2: {
                BoxedUnit boxedUnit;
                this.remove(ethTransaction).get();
                if (this.getNonExecSubpoolSizeInSlots() <= this.MaxNonExecSubPoolSlots()) break block2;
                if (this.log().underlying().isTraceEnabled()) {
                    this.log().underlying().trace(new java.lang.StringBuilder(107).append("Removing transaction ").append(ethTransaction).append(" exceeded maximum allowed non exec subpool size (").append(this.MaxNonExecSubPoolSlots()).append(" slots). ").append("Evicting oldest transactions").toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                this.freeNonExecSubpoolSlots();
            }
            return this;
        });
    }

    public Try<MempoolMap> remove(AccountTransaction<Proposition, Proof<Proposition>> ethTransaction) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            block2: {
                if (!this.txCache().remove(ethTransaction.id()).isDefined()) break block2;
                if (((BigInteger)this.nonces().apply(ethTransaction.getFrom())).compareTo(ethTransaction.getNonce()) < 0) {
                    this.nonExecutableTxs().get(ethTransaction.getFrom()).foreach((Function1 & Serializable & scala.Serializable)nonExecTxsPerAccount -> {
                        Object object;
                        nonExecTxsPerAccount.remove((Object)ethTransaction.getNonce());
                        if (nonExecTxsPerAccount.isEmpty()) {
                            this.nonExecutableTxs().remove(ethTransaction.getFrom());
                            object = !this.io$horizen$account$mempool$MempoolMap$$executableTxs().contains(ethTransaction.getFrom()) ? this.nonces().remove(ethTransaction.getFrom()) : BoxedUnit.UNIT;
                        } else {
                            object = BoxedUnit.UNIT;
                        }
                        return object;
                    });
                } else {
                    this.io$horizen$account$mempool$MempoolMap$$executableTxs().get(ethTransaction.getFrom()).foreach((Function1 & Serializable & scala.Serializable)execTxsPerAccount -> {
                        Object object;
                        execTxsPerAccount.remove((Object)ethTransaction.getNonce());
                        this.nonces().put(ethTransaction.getFrom(), (Object)ethTransaction.getNonce());
                        BigInteger nextNonce = ethTransaction.getNonce().add(BigInteger.ONE);
                        Option demotedTxId = execTxsPerAccount.remove((Object)nextNonce);
                        if (demotedTxId.isDefined()) {
                            SortedMap nonExecTxsPerAccount = (SortedMap)this.nonExecutableTxs().getOrElseUpdate(ethTransaction.getFrom(), (Function0 & Serializable & scala.Serializable)() -> new TreeMap(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())));
                            do {
                                this.txCache().demoteTransaction((String)demotedTxId.get());
                                nonExecTxsPerAccount.put((Object)nextNonce, demotedTxId.get());
                            } while ((demotedTxId = execTxsPerAccount.remove((Object)(nextNonce = nextNonce.add(BigInteger.ONE)))).isDefined());
                        }
                        if (execTxsPerAccount.isEmpty()) {
                            this.io$horizen$account$mempool$MempoolMap$$executableTxs().remove(ethTransaction.getFrom());
                            object = !this.nonExecutableTxs().contains(ethTransaction.getFrom()) ? this.nonces().remove(ethTransaction.getFrom()) : BoxedUnit.UNIT;
                        } else {
                            object = BoxedUnit.UNIT;
                        }
                        return object;
                    });
                }
            }
            return this;
        });
    }

    public int size() {
        return this.txCache().size();
    }

    public Option<AccountTransaction<Proposition, Proof<Proposition>>> getTransaction(String txId) {
        return this.txCache().getTransaction(txId);
    }

    public boolean contains(String txId) {
        return this.txCache().contains(txId);
    }

    public Iterable<AccountTransaction<Proposition, Proof<Proposition>>> values() {
        return this.txCache().values();
    }

    public Iterable<String> mempoolTransactions(boolean executable) {
        TrieMap<Proposition, SortedMap<BigInteger, String>> mempoolIdsMap = executable ? this.io$horizen$account$mempool$MempoolMap$$executableTxs() : this.nonExecutableTxs();
        return (Iterable)mempoolIdsMap.values().flatMap((Function1 & Serializable & scala.Serializable)x$4 -> x$4.values(), scala.collection.Iterable$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    public TrieMap<Address, SortedMap<BigInteger, EthereumTransactionView>> mempoolTransactionsMap(boolean executable) {
        void var2_2;
        TrieMap txsMap = TrieMap$.MODULE$.empty();
        TrieMap<Proposition, SortedMap<BigInteger, String>> mempoolIdsMap = executable ? this.io$horizen$account$mempool$MempoolMap$$executableTxs() : this.nonExecutableTxs();
        mempoolIdsMap.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)MempoolMap.$anonfun$mempoolTransactionsMap$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            Tuple2 tuple2 = x$5;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Proposition from = (Proposition)tuple2._1();
            SortedMap nonceIdsMap = (SortedMap)tuple2._2();
            Option option = txsMap.put((Object)((AddressProposition)from).address(), this.retrieveTxPoolByNonceMap((SortedMap<BigInteger, String>)nonceIdsMap));
            return option;
        });
        return var2_2;
    }

    public SortedMap<BigInteger, EthereumTransactionView> mempoolTransactionsMapFrom(boolean executable, Address fromAddress) {
        SortedMap sortedMap;
        Option mempoolIdByNonceMapFrom = executable ? this.io$horizen$account$mempool$MempoolMap$$executableTxs().get((Object)new AddressProposition(fromAddress)) : this.nonExecutableTxs().get((Object)new AddressProposition(fromAddress));
        Option option = mempoolIdByNonceMapFrom;
        if (option instanceof Some) {
            Some some = (Some)option;
            SortedMap map = (SortedMap)some.value();
            sortedMap = this.retrieveTxPoolByNonceMap((SortedMap<BigInteger, String>)map);
        } else if (None$.MODULE$.equals(option)) {
            sortedMap = SortedMap$.MODULE$.empty(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
        } else {
            throw new MatchError((Object)option);
        }
        return sortedMap;
    }

    /*
     * WARNING - void declaration
     */
    private SortedMap<BigInteger, EthereumTransactionView> retrieveTxPoolByNonceMap(SortedMap<BigInteger, String> txIdByNonceMap) {
        void var2_2;
        TreeMap txPoolByNonceMap = new TreeMap(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
        txIdByNonceMap.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)MempoolMap.$anonfun$retrieveTxPoolByNonceMap$1(check$ifrefutable$2))).foreach(arg_0 -> MempoolMap.$anonfun$retrieveTxPoolByNonceMap$2(this, (SortedMap)txPoolByNonceMap, arg_0));
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public TrieMap<Address, SortedMap<BigInteger, String>> mempoolTransactionsMapInspect(boolean executable) {
        void var2_2;
        TrieMap txsMap = TrieMap$.MODULE$.empty();
        TrieMap<Proposition, SortedMap<BigInteger, String>> mempoolIdsMap = executable ? this.io$horizen$account$mempool$MempoolMap$$executableTxs() : this.nonExecutableTxs();
        mempoolIdsMap.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)MempoolMap.$anonfun$mempoolTransactionsMapInspect$1(check$ifrefutable$3))).foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
            Tuple2 tuple2 = x$7;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Proposition from = (Proposition)tuple2._1();
            SortedMap nonceIdsMap = (SortedMap)tuple2._2();
            Option option = txsMap.put((Object)((AddressProposition)from).address(), this.retrieveTxInspectByNonceMap((SortedMap<BigInteger, String>)nonceIdsMap));
            return option;
        });
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private SortedMap<BigInteger, String> retrieveTxInspectByNonceMap(SortedMap<BigInteger, String> txIdByNonceMap) {
        void var2_2;
        TreeMap txPoolByNonceMap = new TreeMap(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
        txIdByNonceMap.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)MempoolMap.$anonfun$retrieveTxInspectByNonceMap$1(check$ifrefutable$4))).foreach(arg_0 -> MempoolMap.$anonfun$retrieveTxInspectByNonceMap$2(this, (SortedMap)txPoolByNonceMap, arg_0));
        return var2_2;
    }

    public TransactionsByPriceAndNonce takeExecutableTxs(Iterable<AccountTransaction<Proposition, Proof<Proposition>>> forcedTx) {
        BigInteger baseFee = this.baseStateReaderProvider.getBaseStateReader().getNextBaseFee();
        return new TransactionsByPriceAndNonce(this, baseFee, forcedTx);
    }

    public Iterable<AccountTransaction<Proposition, Proof<Proposition>>> takeExecutableTxs$default$1() {
        return (Iterable)Nil$.MODULE$;
    }

    public boolean canPayHigherFee(AccountTransaction<Proposition, Proof<Proposition>> newTx, AccountTransaction<Proposition, Proof<Proposition>> oldTx) {
        return newTx.getMaxFeePerGas().compareTo(oldTx.getMaxFeePerGas()) > 0 && newTx.getMaxPriorityFeePerGas().compareTo(oldTx.getMaxPriorityFeePerGas()) > 0;
    }

    public Iterable<AccountTransaction<Proposition, Proof<Proposition>>> updateMemPool(Seq<AccountBlock> rejectedBlocks, Seq<AccountBlock> appliedBlocks) {
        TrieMap appliedTxNoncesByAccount = TrieMap$.MODULE$.empty();
        appliedBlocks.foreach((Function1 & Serializable & scala.Serializable)block -> {
            MempoolMap.$anonfun$updateMemPool$1(appliedTxNoncesByAccount, block);
            return BoxedUnit.UNIT;
        });
        Seq listOfRejectedBlocksTxs = (Seq)rejectedBlocks.flatMap((Function1 & Serializable & scala.Serializable)x$9 -> x$9.transactions(), Seq$.MODULE$.canBuildFrom());
        Map rejectedTransactionsByAccount = listOfRejectedBlocksTxs.groupBy((Function1 & Serializable & scala.Serializable)x$10 -> x$10.getFrom());
        scala.collection.immutable.Iterable newExecTxs = (scala.collection.immutable.Iterable)rejectedTransactionsByAccount.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Iterable<AccountTransaction<Proposition, Proof<Proposition>>> promotedTxs;
            Iterable<AccountTransaction<Proposition, Proof<Proposition>>> iterable;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Proposition account = (Proposition)tuple2._1();
            Seq rejectedTxs = (Seq)tuple2._2();
            Option latestNonceAfterAppliedTxs = appliedTxNoncesByAccount.remove((Object)account);
            Option option = latestNonceAfterAppliedTxs;
            if (option instanceof Some) {
                Some some = (Some)option;
                BigInteger latestNonce = (BigInteger)some.value();
                iterable = this.updateAccount(account, latestNonce, (Seq<AccountTransaction<Proposition, Proof<Proposition>>>)rejectedTxs);
                promotedTxs = iterable;
                return promotedTxs;
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                iterable = this.updateAccountWithRevertedNonce(account, (Seq<AccountTransaction<Proposition, Proof<Proposition>>>)rejectedTxs);
            }
            promotedTxs = iterable;
            return promotedTxs;
        }, Iterable$.MODULE$.canBuildFrom());
        newExecTxs = (scala.collection.immutable.Iterable)newExecTxs.$plus$plus((GenTraversableOnce)appliedTxNoncesByAccount.flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Proposition account = (Proposition)tuple2._1();
            BigInteger nonce = (BigInteger)tuple2._2();
            Iterable<AccountTransaction<Proposition, Proof<Proposition>>> iterable = this.updateAccount(account, nonce, this.updateAccount$default$3());
            return iterable;
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom());
        this.removeTimedoutTransactions();
        this.checkMempoolSize();
        return newExecTxs;
    }

    public Iterable<AccountTransaction<Proposition, Proof<Proposition>>> updateAccountWithRevertedNonce(Proposition account, Seq<AccountTransaction<Proposition, Proof<Proposition>>> txsFromRejectedBlocks) {
        Option option;
        Option nonExecTxsOpt;
        Address fromAddress = ((AddressProposition)account).address();
        BigInteger balance = this.accountStateReaderProvider.getAccountStateReader().getBalance(fromAddress);
        TreeMap newExecTxs = new TreeMap(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
        TreeMap newNonExecTxs = new TreeMap(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
        BigInteger stateNonce = ((AccountTransaction)txsFromRejectedBlocks.head()).getNonce();
        BigInteger maxAcceptableNonce = this.getMaxAcceptableNonce(stateNonce);
        ObjectRef destMap = ObjectRef.create((Object)newExecTxs);
        BooleanRef haveBecomeNonExecutable = BooleanRef.create((boolean)false);
        BooleanRef maxNonceGapExceeded = BooleanRef.create((boolean)false);
        LongRef currAccountSlots = LongRef.create((long)0L);
        ObjectRef txsToReinject = ObjectRef.create((Object)Nil$.MODULE$);
        txsFromRejectedBlocks.withFilter((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)MempoolMap.$anonfun$updateAccountWithRevertedNonce$1(maxNonceGapExceeded, x$11))).foreach((Function1 & Serializable & scala.Serializable)tx -> {
            MempoolMap.$anonfun$updateAccountWithRevertedNonce$2(this, maxAcceptableNonce, balance, currAccountSlots, haveBecomeNonExecutable, txsToReinject, destMap, newNonExecTxs, maxNonceGapExceeded, tx);
            return BoxedUnit.UNIT;
        });
        ((List)txsToReinject.elem).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            MempoolMap.$anonfun$updateAccountWithRevertedNonce$3(this, x0$1);
            return BoxedUnit.UNIT;
        });
        Option execTxsOpt = this.io$horizen$account$mempool$MempoolMap$$executableTxs().remove((Object)account);
        if (execTxsOpt.nonEmpty()) {
            SortedMap execTxs = (SortedMap)execTxsOpt.get();
            if (maxNonceGapExceeded.elem) {
                execTxs.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String id = (String)tuple2._2();
                    Option<AccountTransaction<Proposition, Proof<Proposition>>> option = this.txCache().remove(id);
                    return option;
                });
            } else {
                execTxs.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                    BoxedUnit boxedUnit;
                    Tuple2 tuple2 = x0$3;
                    if (tuple2 != null) {
                        BigInteger nonce = (BigInteger)tuple2._1();
                        String id = (String)tuple2._2();
                        if (!maxNonceGapExceeded$1.elem && nonce.compareTo(maxAcceptableNonce) <= 0) {
                            AccountTransaction<Proposition, Proof<Proposition>> tx = this.txCache().apply(id);
                            int txSizeInSlots = MempoolMap$.MODULE$.txSizeInSlot(tx);
                            if (balance.compareTo(tx.maxCost()) >= 0 && currAccountSlots$1.elem + (long)txSizeInSlots <= (long)this.MaxSlotsPerAccount()) {
                                ((TreeMap)destMap$1.elem).put((Object)nonce, (Object)id);
                                currAccountSlots$1.elem += (long)txSizeInSlots;
                                if (haveBecomeNonExecutable$1.elem) {
                                    this.txCache().demoteTransaction(id);
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                            } else {
                                this.txCache().remove(id);
                                if (!haveBecomeNonExecutable$1.elem) {
                                    destMap$1.elem = newNonExecTxs;
                                    haveBecomeNonExecutable$1.elem = true;
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                            }
                        } else {
                            if (!maxNonceGapExceeded$1.elem) {
                                maxNonceGapExceeded$1.elem = true;
                            }
                            boxedUnit = this.txCache().remove(id);
                        }
                    } else {
                        throw new MatchError((Object)tuple2);
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return boxedUnit2;
                });
            }
        }
        if ((nonExecTxsOpt = this.nonExecutableTxs().remove((Object)account)).nonEmpty()) {
            SortedMap nonExecTxs = (SortedMap)nonExecTxsOpt.get();
            if (maxNonceGapExceeded.elem) {
                nonExecTxs.foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
                    Tuple2 tuple2 = x0$4;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String id = (String)tuple2._2();
                    Option<AccountTransaction<Proposition, Proof<Proposition>>> option = this.txCache().remove(id);
                    return option;
                });
            } else {
                nonExecTxs.foreach((Function1 & Serializable & scala.Serializable)x0$5 -> {
                    BoxedUnit boxedUnit;
                    Tuple2 tuple2 = x0$5;
                    if (tuple2 != null) {
                        BigInteger nonce = (BigInteger)tuple2._1();
                        String id = (String)tuple2._2();
                        if (!maxNonceGapExceeded$1.elem && nonce.compareTo(maxAcceptableNonce) <= 0) {
                            AccountTransaction<Proposition, Proof<Proposition>> tx = this.txCache().apply(id);
                            int txSizeInSlots = MempoolMap$.MODULE$.txSizeInSlot(tx);
                            if (balance.compareTo(tx.maxCost()) >= 0 && currAccountSlots$1.elem + (long)txSizeInSlots <= (long)this.MaxSlotsPerAccount()) {
                                newNonExecTxs.put((Object)nonce, (Object)id);
                                currAccountSlots$1.elem += (long)txSizeInSlots;
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = this.txCache().remove(id);
                            }
                        } else {
                            if (!maxNonceGapExceeded$1.elem) {
                                maxNonceGapExceeded$1.elem = true;
                            }
                            boxedUnit = this.txCache().remove(id);
                        }
                    } else {
                        throw new MatchError((Object)tuple2);
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return boxedUnit2;
                });
            }
        }
        if (newExecTxs.nonEmpty()) {
            this.nonces().put((Object)account, (Object)((BigInteger)newExecTxs.lastKey()).add(BigInteger.ONE));
            option = this.io$horizen$account$mempool$MempoolMap$$executableTxs().put((Object)account, (Object)newExecTxs);
        } else {
            option = this.nonces().put((Object)account, (Object)stateNonce);
        }
        Object object = newNonExecTxs.nonEmpty() ? this.nonExecutableTxs().put((Object)account, (Object)newNonExecTxs) : BoxedUnit.UNIT;
        return (Iterable)((List)txsToReinject.elem).withFilter((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)MempoolMap.$anonfun$updateAccountWithRevertedNonce$8(x$13))).map((Function1 & Serializable & scala.Serializable)el -> (AccountTransaction)el._1(), List$.MODULE$.canBuildFrom());
    }

    public boolean existRejectedTxsWithValidNonce(Seq<AccountTransaction<Proposition, Proof<Proposition>>> rejectedTxs, BigInteger expectedNonce) {
        return rejectedTxs.nonEmpty() && ((AccountTransaction)rejectedTxs.last()).getNonce().compareTo(expectedNonce) >= 0;
    }

    public Iterable<AccountTransaction<Proposition, Proof<Proposition>>> updateAccount(Proposition account, BigInteger nonceOfTheLatestAppliedTx, Seq<AccountTransaction<Proposition, Proof<Proposition>>> txsFromRejectedBlocks) {
        ListBuffer listBuffer;
        ObjectRef newExpectedNonce = ObjectRef.create((Object)nonceOfTheLatestAppliedTx.add(BigInteger.ONE));
        if (this.existRejectedTxsWithValidNonce(txsFromRejectedBlocks, (BigInteger)newExpectedNonce.elem)) {
            listBuffer = this.updateAccountWithRevertedNonce(account, (Seq<AccountTransaction<Proposition, Proof<Proposition>>>)((Seq)txsFromRejectedBlocks.dropWhile((Function1 & Serializable & scala.Serializable)tx -> BoxesRunTime.boxToBoolean((boolean)MempoolMap.$anonfun$updateAccount$1(newExpectedNonce, tx)))));
        } else {
            Object object;
            Address fromAddress = ((AddressProposition)account).address();
            BigInteger balance = this.accountStateReaderProvider.getAccountStateReader().getBalance(fromAddress);
            TreeMap newExecTxs = new TreeMap(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
            TreeMap newNonExecTxs = new TreeMap(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
            ObjectRef destMap = ObjectRef.create((Object)newExecTxs);
            BooleanRef haveBecomeNonExecutable = BooleanRef.create((boolean)false);
            Option execTxsOpt = this.io$horizen$account$mempool$MempoolMap$$executableTxs().remove((Object)account);
            if (execTxsOpt.nonEmpty()) {
                ((TraversableLike)execTxsOpt.get()).withFilter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MempoolMap.$anonfun$updateAccount$2(this, newExpectedNonce, x0$1))).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    MempoolMap.$anonfun$updateAccount$3(this, balance, destMap, haveBecomeNonExecutable, newNonExecTxs, x0$2);
                    return BoxedUnit.UNIT;
                });
            }
            if (newExecTxs.nonEmpty()) {
                newExpectedNonce.elem = ((BigInteger)newExecTxs.lastKey()).add(BigInteger.ONE);
            }
            ListBuffer listOfPromotedTxs = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            Option nonExecTxs = this.nonExecutableTxs().remove((Object)account);
            if (nonExecTxs.nonEmpty()) {
                ((TraversableLike)nonExecTxs.get()).withFilter((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)MempoolMap.$anonfun$updateAccount$4(this, newExpectedNonce, x0$3))).foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
                    Option option;
                    Tuple2 tuple2 = x0$4;
                    if (tuple2 != null) {
                        BigInteger nonce = (BigInteger)tuple2._1();
                        String id = (String)tuple2._2();
                        if (balance.compareTo(this.txCache().apply(id).maxCost()) >= 0) {
                            if (nonce.compareTo((BigInteger)newExpectedNonce$1.elem) == 0) {
                                newExecTxs.put((Object)nonce, (Object)id);
                                listOfPromotedTxs.$plus$eq(this.txCache().promoteTransaction(id));
                                newExpectedNonce$1.elem = ((BigInteger)newExpectedNonce$1.elem).add(BigInteger.ONE);
                                option = BoxedUnit.UNIT;
                            } else {
                                option = newNonExecTxs.put((Object)nonce, (Object)id);
                            }
                        } else {
                            option = this.txCache().remove(id);
                        }
                    } else {
                        throw new MatchError((Object)tuple2);
                    }
                    Option option2 = option;
                    return option2;
                });
            }
            if (newExecTxs.isEmpty() && newNonExecTxs.isEmpty()) {
                object = this.nonces().remove((Object)account);
            } else {
                this.nonces().put((Object)account, (Object)((BigInteger)newExpectedNonce.elem));
                Object object2 = newExecTxs.nonEmpty() ? this.io$horizen$account$mempool$MempoolMap$$executableTxs().put((Object)account, (Object)newExecTxs) : BoxedUnit.UNIT;
                object = newNonExecTxs.nonEmpty() ? this.nonExecutableTxs().put((Object)account, (Object)newNonExecTxs) : BoxedUnit.UNIT;
            }
            listBuffer = listOfPromotedTxs;
        }
        ListBuffer newExecTxs = listBuffer;
        return newExecTxs;
    }

    public Seq<AccountTransaction<Proposition, Proof<Proposition>>> updateAccount$default$3() {
        return (Seq)Nil$.MODULE$;
    }

    public void checkMempoolSize() {
        block6: {
            BoxedUnit boxedUnit;
            if (this.getNonExecSubpoolSizeInSlots() > this.MaxNonExecSubPoolSlots()) {
                BoxedUnit boxedUnit2;
                if (this.log().underlying().isTraceEnabled()) {
                    this.log().underlying().trace(new java.lang.StringBuilder(99).append("Non exec sub pool size (").append(this.getNonExecSubpoolSizeInSlots()).append(" slots) exceeds maximum allowed size ").append("(").append(this.MaxNonExecSubPoolSlots()).append(" slots). Evicting oldest transactions").toString());
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                this.freeNonExecSubpoolSlots();
            }
            if (this.getMempoolSizeInSlots() <= this.MaxMemPoolSlots()) break block6;
            if (this.log().underlying().isWarnEnabled()) {
                this.log().underlying().warn(new java.lang.StringBuilder(99).append("Memory pool size (").append(this.getMempoolSizeInSlots()).append(" slots) exceeds maximum allowed size (").append(this.MaxMemPoolSlots()).append(" slots). ").append("Start evicting oldest transactions").toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.freeMempoolSlots();
            if (this.getNonExecSubpoolSizeInSlots() > this.MaxNonExecSubPoolSlots()) {
                this.freeNonExecSubpoolSlots();
            }
        }
    }

    public static final /* synthetic */ int $anonfun$getAccountSlots$2(MempoolMap $this, int sum, String txId) {
        return sum + MempoolMap$.MODULE$.txSizeInSlot($this.txCache().apply(txId));
    }

    public static final /* synthetic */ boolean $anonfun$mempoolTransactionsMap$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$retrieveTxPoolByNonceMap$1(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ Option $anonfun$retrieveTxPoolByNonceMap$2(MempoolMap $this, SortedMap txPoolByNonceMap$1, Tuple2 x$6) {
        Tuple2 tuple2 = x$6;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        BigInteger txNonce = (BigInteger)tuple2._1();
        String txId = (String)tuple2._2();
        AccountTransaction tx = (AccountTransaction)$this.getTransaction(txId).get();
        Option option = txPoolByNonceMap$1.put((Object)txNonce, (Object)new EthereumTransactionView((EthereumTransaction)tx));
        return option;
    }

    public static final /* synthetic */ boolean $anonfun$mempoolTransactionsMapInspect$1(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$retrieveTxInspectByNonceMap$1(Tuple2 check$ifrefutable$4) {
        Tuple2 tuple2 = check$ifrefutable$4;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ Option $anonfun$retrieveTxInspectByNonceMap$2(MempoolMap $this, SortedMap txPoolByNonceMap$2, Tuple2 x$8) {
        Option option;
        Tuple2 tuple2 = x$8;
        if (tuple2 != null) {
            BigInteger txNonce = (BigInteger)tuple2._1();
            String txId = (String)tuple2._2();
            AccountTransaction tx = (AccountTransaction)$this.getTransaction(txId).get();
            if (tx.getTo().isPresent()) {
                String toStr = ((AddressProposition)tx.getTo().get()).address().toString();
                option = txPoolByNonceMap$2.put((Object)txNonce, (Object)new java.lang.StringBuilder(20).append(toStr).append(": ").append(tx.getValue()).append(" wei + ").append(tx.getGasLimit()).append(" gas \u00d7 ").append(tx.getGasPrice()).append(" wei").toString());
            } else {
                option = txPoolByNonceMap$2.put((Object)txNonce, (Object)new java.lang.StringBuilder(37).append("contract creation: ").append(tx.getValue()).append(" wei + ").append(tx.getGasLimit()).append(" gas \u00d7 ").append(tx.getGasPrice()).append(" wei").toString());
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        Option option2 = option;
        return option2;
    }

    public static final /* synthetic */ void $anonfun$updateMemPool$1(TrieMap appliedTxNoncesByAccount$1, AccountBlock block) {
        block.transactions().foreach((Function1 & Serializable & scala.Serializable)tx -> appliedTxNoncesByAccount$1.put(tx.getFrom(), (Object)tx.getNonce()));
    }

    public static final /* synthetic */ boolean $anonfun$updateAccountWithRevertedNonce$1(BooleanRef maxNonceGapExceeded$1, AccountTransaction x$11) {
        return !maxNonceGapExceeded$1.elem;
    }

    public static final /* synthetic */ void $anonfun$updateAccountWithRevertedNonce$2(MempoolMap $this, BigInteger maxAcceptableNonce$1, BigInteger balance$1, LongRef currAccountSlots$1, BooleanRef haveBecomeNonExecutable$1, ObjectRef txsToReinject$1, ObjectRef destMap$1, TreeMap newNonExecTxs$1, BooleanRef maxNonceGapExceeded$1, AccountTransaction tx) {
        if (tx.getNonce().compareTo(maxAcceptableNonce$1) <= 0) {
            int txSizeInSlots = MempoolMap$.MODULE$.txSizeInSlot(tx);
            if (balance$1.compareTo(tx.maxCost()) >= 0 && txSizeInSlots <= MempoolMap$.MODULE$.MaxNumOfSlotsForTx() && currAccountSlots$1.elem + (long)txSizeInSlots <= (long)$this.MaxSlotsPerAccount()) {
                Enumeration.Value txStatus = haveBecomeNonExecutable$1.elem ? TxExecutableStatus$.MODULE$.NON_EXEC() : TxExecutableStatus$.MODULE$.EXEC();
                Tuple2 tuple2 = new Tuple2((Object)tx, (Object)txStatus);
                txsToReinject$1.elem = ((List)txsToReinject$1.elem).$colon$colon((Object)tuple2);
                ((TreeMap)destMap$1.elem).put((Object)tx.getNonce(), (Object)tx.id());
                currAccountSlots$1.elem += (long)txSizeInSlots;
            } else if (!haveBecomeNonExecutable$1.elem) {
                destMap$1.elem = newNonExecTxs$1;
                haveBecomeNonExecutable$1.elem = true;
            }
        } else {
            maxNonceGapExceeded$1.elem = true;
        }
    }

    public static final /* synthetic */ void $anonfun$updateAccountWithRevertedNonce$3(MempoolMap $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        AccountTransaction tx = (AccountTransaction)tuple2._1();
        Enumeration.Value execStatus = (Enumeration.Value)tuple2._2();
        $this.txCache().add(tx, execStatus);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$updateAccountWithRevertedNonce$8(Tuple2 x$13) {
        Object object = x$13._2();
        Enumeration.Value value = TxExecutableStatus$.MODULE$.EXEC();
        return !(object != null ? !object.equals(value) : value != null);
    }

    public static final /* synthetic */ boolean $anonfun$updateAccount$1(ObjectRef newExpectedNonce$1, AccountTransaction tx) {
        return tx.getNonce().compareTo((BigInteger)newExpectedNonce$1.elem) < 0;
    }

    public static final /* synthetic */ boolean $anonfun$updateAccount$2(MempoolMap $this, ObjectRef newExpectedNonce$1, Tuple2 x0$1) {
        boolean bl;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            BigInteger nonce = (BigInteger)tuple2._1();
            String id = (String)tuple2._2();
            if (nonce.compareTo((BigInteger)newExpectedNonce$1.elem) < 0) {
                $this.txCache().remove(id);
                bl = false;
            } else {
                bl = true;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        boolean bl2 = bl;
        return bl2;
    }

    public static final /* synthetic */ void $anonfun$updateAccount$3(MempoolMap $this, BigInteger balance$2, ObjectRef destMap$2, BooleanRef haveBecomeNonExecutable$2, TreeMap newNonExecTxs$2, Tuple2 x0$2) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            BigInteger nonce = (BigInteger)tuple2._1();
            String id = (String)tuple2._2();
            if (balance$2.compareTo($this.txCache().apply(id).maxCost()) >= 0) {
                ((TreeMap)destMap$2.elem).put((Object)nonce, (Object)id);
                if (haveBecomeNonExecutable$2.elem) {
                    $this.txCache().demoteTransaction(id);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                $this.txCache().remove(id);
                if (!haveBecomeNonExecutable$2.elem) {
                    destMap$2.elem = newNonExecTxs$2;
                    haveBecomeNonExecutable$2.elem = true;
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ boolean $anonfun$updateAccount$4(MempoolMap $this, ObjectRef newExpectedNonce$1, Tuple2 x0$3) {
        boolean bl;
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            BigInteger nonce = (BigInteger)tuple2._1();
            String id = (String)tuple2._2();
            if (nonce.compareTo((BigInteger)newExpectedNonce$1.elem) < 0) {
                $this.txCache().remove(id);
                bl = false;
            } else {
                bl = true;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        boolean bl2 = bl;
        return bl2;
    }

    public MempoolMap(AccountStateReaderProvider accountStateReaderProvider, BaseStateReaderProvider baseStateReaderProvider, AccountMempoolSettings mempoolSettings) {
        this.accountStateReaderProvider = accountStateReaderProvider;
        this.baseStateReaderProvider = baseStateReaderProvider;
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
        this.maxAllowedNonceGap = BigInteger.valueOf(mempoolSettings.maxNonceGap()).subtract(BigInteger.ONE);
        this.MaxSlotsPerAccount = mempoolSettings.maxAccountSlots();
        this.MaxMemPoolSlots = mempoolSettings.maxMemPoolSlots();
        this.MaxNonExecSubPoolSlots = mempoolSettings.maxNonExecMemPoolSlots();
        this.TxLifetime = mempoolSettings.txLifetime();
        this.txCache = new TxCache(this.TxLifetime());
        this.io$horizen$account$mempool$MempoolMap$$executableTxs = TrieMap$.MODULE$.empty();
        this.nonExecutableTxs = TrieMap$.MODULE$.empty();
        this.nonces = TrieMap$.MODULE$.empty();
    }

    public class TransactionsByPriceAndNonce
    implements Iterable<AccountTransaction<Proposition, Proof<Proposition>>> {
        public final BigInteger io$horizen$account$mempool$MempoolMap$TransactionsByPriceAndNonce$$baseFee;
        public final Iterable<AccountTransaction<Proposition, Proof<Proposition>>> io$horizen$account$mempool$MempoolMap$TransactionsByPriceAndNonce$$forcedTx;
        public final /* synthetic */ MempoolMap $outer;

        public GenericCompanion<Iterable> companion() {
            return Iterable.companion$((Iterable)this);
        }

        public Iterable<AccountTransaction<Proposition, Proof<Proposition>>> seq() {
            return Iterable.seq$((Iterable)this);
        }

        public Iterable<AccountTransaction<Proposition, Proof<Proposition>>> thisCollection() {
            return IterableLike.thisCollection$((IterableLike)this);
        }

        public Iterable toCollection(Object repr) {
            return IterableLike.toCollection$((IterableLike)this, (Object)repr);
        }

        public <U> void foreach(Function1<AccountTransaction<Proposition, Proof<Proposition>>, U> f) {
            IterableLike.foreach$((IterableLike)this, f);
        }

        public boolean forall(Function1<AccountTransaction<Proposition, Proof<Proposition>>, Object> p) {
            return IterableLike.forall$((IterableLike)this, p);
        }

        public boolean exists(Function1<AccountTransaction<Proposition, Proof<Proposition>>, Object> p) {
            return IterableLike.exists$((IterableLike)this, p);
        }

        public Option<AccountTransaction<Proposition, Proof<Proposition>>> find(Function1<AccountTransaction<Proposition, Proof<Proposition>>, Object> p) {
            return IterableLike.find$((IterableLike)this, p);
        }

        public boolean isEmpty() {
            return IterableLike.isEmpty$((IterableLike)this);
        }

        public <B> B foldRight(B z, Function2<AccountTransaction<Proposition, Proof<Proposition>>, B, B> op) {
            return (B)IterableLike.foldRight$((IterableLike)this, z, op);
        }

        public <B> B reduceRight(Function2<AccountTransaction<Proposition, Proof<Proposition>>, B, B> op) {
            return (B)IterableLike.reduceRight$((IterableLike)this, op);
        }

        public Iterable<AccountTransaction<Proposition, Proof<Proposition>>> toIterable() {
            return IterableLike.toIterable$((IterableLike)this);
        }

        public Iterator<AccountTransaction<Proposition, Proof<Proposition>>> toIterator() {
            return IterableLike.toIterator$((IterableLike)this);
        }

        public Object head() {
            return IterableLike.head$((IterableLike)this);
        }

        public Object slice(int from, int until) {
            return IterableLike.slice$((IterableLike)this, (int)from, (int)until);
        }

        public Object take(int n) {
            return IterableLike.take$((IterableLike)this, (int)n);
        }

        public Object drop(int n) {
            return IterableLike.drop$((IterableLike)this, (int)n);
        }

        public Object takeWhile(Function1 p) {
            return IterableLike.takeWhile$((IterableLike)this, (Function1)p);
        }

        public Iterator<Iterable<AccountTransaction<Proposition, Proof<Proposition>>>> grouped(int size) {
            return IterableLike.grouped$((IterableLike)this, (int)size);
        }

        public Iterator<Iterable<AccountTransaction<Proposition, Proof<Proposition>>>> sliding(int size) {
            return IterableLike.sliding$((IterableLike)this, (int)size);
        }

        public Iterator<Iterable<AccountTransaction<Proposition, Proof<Proposition>>>> sliding(int size, int step) {
            return IterableLike.sliding$((IterableLike)this, (int)size, (int)step);
        }

        public Object takeRight(int n) {
            return IterableLike.takeRight$((IterableLike)this, (int)n);
        }

        public Object dropRight(int n) {
            return IterableLike.dropRight$((IterableLike)this, (int)n);
        }

        public <B> void copyToArray(Object xs, int start, int len) {
            IterableLike.copyToArray$((IterableLike)this, (Object)xs, (int)start, (int)len);
        }

        public <A1, B, That> That zip(GenIterable<B> that, CanBuildFrom<Iterable<AccountTransaction<Proposition, Proof<Proposition>>>, Tuple2<A1, B>, That> bf) {
            return (That)IterableLike.zip$((IterableLike)this, that, bf);
        }

        public <B, A1, That> That zipAll(GenIterable<B> that, A1 thisElem, B thatElem, CanBuildFrom<Iterable<AccountTransaction<Proposition, Proof<Proposition>>>, Tuple2<A1, B>, That> bf) {
            return (That)IterableLike.zipAll$((IterableLike)this, that, thisElem, thatElem, bf);
        }

        public <A1, That> That zipWithIndex(CanBuildFrom<Iterable<AccountTransaction<Proposition, Proof<Proposition>>>, Tuple2<A1, Object>, That> bf) {
            return (That)IterableLike.zipWithIndex$((IterableLike)this, bf);
        }

        public <B> boolean sameElements(GenIterable<B> that) {
            return IterableLike.sameElements$((IterableLike)this, that);
        }

        public Stream<AccountTransaction<Proposition, Proof<Proposition>>> toStream() {
            return IterableLike.toStream$((IterableLike)this);
        }

        public boolean canEqual(Object that) {
            return IterableLike.canEqual$((IterableLike)this, (Object)that);
        }

        public IterableView<AccountTransaction<Proposition, Proof<Proposition>>, Iterable<AccountTransaction<Proposition, Proof<Proposition>>>> view() {
            return IterableLike.view$((IterableLike)this);
        }

        public IterableView<AccountTransaction<Proposition, Proof<Proposition>>, Iterable<AccountTransaction<Proposition, Proof<Proposition>>>> view(int from, int until) {
            return IterableLike.view$((IterableLike)this, (int)from, (int)until);
        }

        public Builder<AccountTransaction<Proposition, Proof<Proposition>>, Iterable<AccountTransaction<Proposition, Proof<Proposition>>>> newBuilder() {
            return GenericTraversableTemplate.newBuilder$((GenericTraversableTemplate)this);
        }

        public <B> Builder<B, Iterable<B>> genericBuilder() {
            return GenericTraversableTemplate.genericBuilder$((GenericTraversableTemplate)this);
        }

        public <A1, A2> Tuple2<Iterable<A1>, Iterable<A2>> unzip(Function1<AccountTransaction<Proposition, Proof<Proposition>>, Tuple2<A1, A2>> asPair) {
            return GenericTraversableTemplate.unzip$((GenericTraversableTemplate)this, asPair);
        }

        public <A1, A2, A3> Tuple3<Iterable<A1>, Iterable<A2>, Iterable<A3>> unzip3(Function1<AccountTransaction<Proposition, Proof<Proposition>>, Tuple3<A1, A2, A3>> asTriple) {
            return GenericTraversableTemplate.unzip3$((GenericTraversableTemplate)this, asTriple);
        }

        public GenTraversable flatten(Function1 asTraversable) {
            return GenericTraversableTemplate.flatten$((GenericTraversableTemplate)this, (Function1)asTraversable);
        }

        public GenTraversable transpose(Function1 asTraversable) {
            return GenericTraversableTemplate.transpose$((GenericTraversableTemplate)this, (Function1)asTraversable);
        }

        public Object repr() {
            return TraversableLike.repr$((TraversableLike)this);
        }

        public final boolean isTraversableAgain() {
            return TraversableLike.isTraversableAgain$((TraversableLike)this);
        }

        public Combiner<AccountTransaction<Proposition, Proof<Proposition>>, ParIterable<AccountTransaction<Proposition, Proof<Proposition>>>> parCombiner() {
            return TraversableLike.parCombiner$((TraversableLike)this);
        }

        public boolean hasDefiniteSize() {
            return TraversableLike.hasDefiniteSize$((TraversableLike)this);
        }

        public <B, That> That $plus$plus(GenTraversableOnce<B> that, CanBuildFrom<Iterable<AccountTransaction<Proposition, Proof<Proposition>>>, B, That> bf) {
            return (That)TraversableLike.$plus$plus$((TraversableLike)this, that, bf);
        }

        public <B, That> That $plus$plus$colon(TraversableOnce<B> that, CanBuildFrom<Iterable<AccountTransaction<Proposition, Proof<Proposition>>>, B, That> bf) {
            return (That)TraversableLike.$plus$plus$colon$((TraversableLike)this, that, bf);
        }

        public <B, That> That $plus$plus$colon(Traversable<B> that, CanBuildFrom<Iterable<AccountTransaction<Proposition, Proof<Proposition>>>, B, That> bf) {
            return (That)TraversableLike.$plus$plus$colon$((TraversableLike)this, that, bf);
        }

        public <B, That> That map(Function1<AccountTransaction<Proposition, Proof<Proposition>>, B> f, CanBuildFrom<Iterable<AccountTransaction<Proposition, Proof<Proposition>>>, B, That> bf) {
            return (That)TraversableLike.map$((TraversableLike)this, f, bf);
        }

        public <B, That> That flatMap(Function1<AccountTransaction<Proposition, Proof<Proposition>>, GenTraversableOnce<B>> f, CanBuildFrom<Iterable<AccountTransaction<Proposition, Proof<Proposition>>>, B, That> bf) {
            return (That)TraversableLike.flatMap$((TraversableLike)this, f, bf);
        }

        public Object filterImpl(Function1 p, boolean isFlipped) {
            return TraversableLike.filterImpl$((TraversableLike)this, (Function1)p, (boolean)isFlipped);
        }

        public Object filter(Function1 p) {
            return TraversableLike.filter$((TraversableLike)this, (Function1)p);
        }

        public Object filterNot(Function1 p) {
            return TraversableLike.filterNot$((TraversableLike)this, (Function1)p);
        }

        public <B, That> That collect(PartialFunction<AccountTransaction<Proposition, Proof<Proposition>>, B> pf, CanBuildFrom<Iterable<AccountTransaction<Proposition, Proof<Proposition>>>, B, That> bf) {
            return (That)TraversableLike.collect$((TraversableLike)this, pf, bf);
        }

        public Tuple2<Iterable<AccountTransaction<Proposition, Proof<Proposition>>>, Iterable<AccountTransaction<Proposition, Proof<Proposition>>>> partition(Function1<AccountTransaction<Proposition, Proof<Proposition>>, Object> p) {
            return TraversableLike.partition$((TraversableLike)this, p);
        }

        public <K> Map<K, Iterable<AccountTransaction<Proposition, Proof<Proposition>>>> groupBy(Function1<AccountTransaction<Proposition, Proof<Proposition>>, K> f) {
            return TraversableLike.groupBy$((TraversableLike)this, f);
        }

        public <B, That> That scan(B z, Function2<B, B, B> op, CanBuildFrom<Iterable<AccountTransaction<Proposition, Proof<Proposition>>>, B, That> cbf) {
            return (That)TraversableLike.scan$((TraversableLike)this, z, op, cbf);
        }

        public <B, That> That scanLeft(B z, Function2<B, AccountTransaction<Proposition, Proof<Proposition>>, B> op, CanBuildFrom<Iterable<AccountTransaction<Proposition, Proof<Proposition>>>, B, That> bf) {
            return (That)TraversableLike.scanLeft$((TraversableLike)this, z, op, bf);
        }

        public <B, That> That scanRight(B z, Function2<AccountTransaction<Proposition, Proof<Proposition>>, B, B> op, CanBuildFrom<Iterable<AccountTransaction<Proposition, Proof<Proposition>>>, B, That> bf) {
            return (That)TraversableLike.scanRight$((TraversableLike)this, z, op, bf);
        }

        public Option<AccountTransaction<Proposition, Proof<Proposition>>> headOption() {
            return TraversableLike.headOption$((TraversableLike)this);
        }

        public Object tail() {
            return TraversableLike.tail$((TraversableLike)this);
        }

        public Object last() {
            return TraversableLike.last$((TraversableLike)this);
        }

        public Option<AccountTransaction<Proposition, Proof<Proposition>>> lastOption() {
            return TraversableLike.lastOption$((TraversableLike)this);
        }

        public Object init() {
            return TraversableLike.init$((TraversableLike)this);
        }

        public Object sliceWithKnownDelta(int from, int until, int delta) {
            return TraversableLike.sliceWithKnownDelta$((TraversableLike)this, (int)from, (int)until, (int)delta);
        }

        public Object sliceWithKnownBound(int from, int until) {
            return TraversableLike.sliceWithKnownBound$((TraversableLike)this, (int)from, (int)until);
        }

        public Object dropWhile(Function1 p) {
            return TraversableLike.dropWhile$((TraversableLike)this, (Function1)p);
        }

        public Tuple2<Iterable<AccountTransaction<Proposition, Proof<Proposition>>>, Iterable<AccountTransaction<Proposition, Proof<Proposition>>>> span(Function1<AccountTransaction<Proposition, Proof<Proposition>>, Object> p) {
            return TraversableLike.span$((TraversableLike)this, p);
        }

        public Tuple2<Iterable<AccountTransaction<Proposition, Proof<Proposition>>>, Iterable<AccountTransaction<Proposition, Proof<Proposition>>>> splitAt(int n) {
            return TraversableLike.splitAt$((TraversableLike)this, (int)n);
        }

        public Iterator<Iterable<AccountTransaction<Proposition, Proof<Proposition>>>> tails() {
            return TraversableLike.tails$((TraversableLike)this);
        }

        public Iterator<Iterable<AccountTransaction<Proposition, Proof<Proposition>>>> inits() {
            return TraversableLike.inits$((TraversableLike)this);
        }

        public Traversable<AccountTransaction<Proposition, Proof<Proposition>>> toTraversable() {
            return TraversableLike.toTraversable$((TraversableLike)this);
        }

        public <Col> Col to(CanBuildFrom<Nothing$, AccountTransaction<Proposition, Proof<Proposition>>, Col> cbf) {
            return (Col)TraversableLike.to$((TraversableLike)this, cbf);
        }

        public String toString() {
            return TraversableLike.toString$((TraversableLike)this);
        }

        public String stringPrefix() {
            return TraversableLike.stringPrefix$((TraversableLike)this);
        }

        public FilterMonadic<AccountTransaction<Proposition, Proof<Proposition>>, Iterable<AccountTransaction<Proposition, Proof<Proposition>>>> withFilter(Function1<AccountTransaction<Proposition, Proof<Proposition>>, Object> p) {
            return TraversableLike.withFilter$((TraversableLike)this, p);
        }

        public Parallel par() {
            return Parallelizable.par$((Parallelizable)this);
        }

        public List<AccountTransaction<Proposition, Proof<Proposition>>> reversed() {
            return TraversableOnce.reversed$((TraversableOnce)this);
        }

        public int size() {
            return TraversableOnce.size$((TraversableOnce)this);
        }

        public boolean nonEmpty() {
            return TraversableOnce.nonEmpty$((TraversableOnce)this);
        }

        public int count(Function1<AccountTransaction<Proposition, Proof<Proposition>>, Object> p) {
            return TraversableOnce.count$((TraversableOnce)this, p);
        }

        public <B> Option<B> collectFirst(PartialFunction<AccountTransaction<Proposition, Proof<Proposition>>, B> pf) {
            return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
        }

        public <B> B $div$colon(B z, Function2<B, AccountTransaction<Proposition, Proof<Proposition>>, B> op) {
            return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
        }

        public <B> B $colon$bslash(B z, Function2<AccountTransaction<Proposition, Proof<Proposition>>, B, B> op) {
            return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
        }

        public <B> B foldLeft(B z, Function2<B, AccountTransaction<Proposition, Proof<Proposition>>, B> op) {
            return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
        }

        public <B> B reduceLeft(Function2<B, AccountTransaction<Proposition, Proof<Proposition>>, B> op) {
            return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
        }

        public <B> Option<B> reduceLeftOption(Function2<B, AccountTransaction<Proposition, Proof<Proposition>>, B> op) {
            return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
        }

        public <B> Option<B> reduceRightOption(Function2<AccountTransaction<Proposition, Proof<Proposition>>, B, B> op) {
            return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
        }

        public <A1> A1 reduce(Function2<A1, A1, A1> op) {
            return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
        }

        public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
            return TraversableOnce.reduceOption$((TraversableOnce)this, op);
        }

        public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
            return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
        }

        public <B> B aggregate(Function0<B> z, Function2<B, AccountTransaction<Proposition, Proof<Proposition>>, B> seqop, Function2<B, B, B> combop) {
            return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
        }

        public <B> B sum(Numeric<B> num) {
            return (B)TraversableOnce.sum$((TraversableOnce)this, num);
        }

        public <B> B product(Numeric<B> num) {
            return (B)TraversableOnce.product$((TraversableOnce)this, num);
        }

        public Object min(Ordering cmp) {
            return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
        }

        public Object max(Ordering cmp) {
            return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
        }

        public Object maxBy(Function1 f, Ordering cmp) {
            return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
        }

        public Object minBy(Function1 f, Ordering cmp) {
            return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
        }

        public <B> void copyToBuffer(Buffer<B> dest) {
            TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
        }

        public <B> void copyToArray(Object xs, int start) {
            TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
        }

        public <B> void copyToArray(Object xs) {
            TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
        }

        public <B> Object toArray(ClassTag<B> evidence$1) {
            return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
        }

        public List<AccountTransaction<Proposition, Proof<Proposition>>> toList() {
            return TraversableOnce.toList$((TraversableOnce)this);
        }

        public Seq<AccountTransaction<Proposition, Proof<Proposition>>> toSeq() {
            return TraversableOnce.toSeq$((TraversableOnce)this);
        }

        public IndexedSeq<AccountTransaction<Proposition, Proof<Proposition>>> toIndexedSeq() {
            return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
        }

        public <B> Buffer<B> toBuffer() {
            return TraversableOnce.toBuffer$((TraversableOnce)this);
        }

        public <B> Set<B> toSet() {
            return TraversableOnce.toSet$((TraversableOnce)this);
        }

        public Vector<AccountTransaction<Proposition, Proof<Proposition>>> toVector() {
            return TraversableOnce.toVector$((TraversableOnce)this);
        }

        public <T, U> Map<T, U> toMap(Predef.$less$colon$less<AccountTransaction<Proposition, Proof<Proposition>>, Tuple2<T, U>> ev) {
            return TraversableOnce.toMap$((TraversableOnce)this, ev);
        }

        public String mkString(String start, String sep, String end) {
            return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
        }

        public String mkString(String sep) {
            return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
        }

        public String mkString() {
            return TraversableOnce.mkString$((TraversableOnce)this);
        }

        public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
        }

        public StringBuilder addString(StringBuilder b, String sep) {
            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
        }

        public StringBuilder addString(StringBuilder b) {
            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
        }

        public int sizeHintIfCheap() {
            return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
        }

        public TransactionsByPriceAndNonceIter iterator() {
            return new Iter();
        }

        public /* synthetic */ MempoolMap io$horizen$account$mempool$MempoolMap$TransactionsByPriceAndNonce$$$outer() {
            return this.$outer;
        }

        public TransactionsByPriceAndNonce(MempoolMap $outer, BigInteger baseFee, Iterable<AccountTransaction<Proposition, Proof<Proposition>>> forcedTx) {
            this.io$horizen$account$mempool$MempoolMap$TransactionsByPriceAndNonce$$baseFee = baseFee;
            this.io$horizen$account$mempool$MempoolMap$TransactionsByPriceAndNonce$$forcedTx = forcedTx;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            GenTraversableOnce.$init$((GenTraversableOnce)this);
            TraversableOnce.$init$((TraversableOnce)this);
            Parallelizable.$init$((Parallelizable)this);
            TraversableLike.$init$((TraversableLike)this);
            GenericTraversableTemplate.$init$((GenericTraversableTemplate)this);
            GenTraversable.$init$((GenTraversable)this);
            Traversable.$init$((Traversable)this);
            GenIterable.$init$((GenIterable)this);
            IterableLike.$init$((IterableLike)this);
            Iterable.$init$((Iterable)this);
        }

        public class Iter
        implements TransactionsByPriceAndNonceIter {
            private final Queue<AccountTransaction<Proposition, Proof<Proposition>>> forcedTxQueue;
            private final PriorityQueue<AccountTransaction<Proposition, Proof<Proposition>>> orderedQueue;

            public Iterator<AccountTransaction<Proposition, Proof<Proposition>>> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.isTraversableAgain$((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public Iterator<AccountTransaction<Proposition, Proof<Proposition>>> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<AccountTransaction<Proposition, Proof<Proposition>>> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<AccountTransaction<Proposition, Proof<Proposition>>> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<AccountTransaction<Proposition, Proof<Proposition>>> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<AccountTransaction<Proposition, Proof<Proposition>>, B> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.$plus$plus$((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<AccountTransaction<Proposition, Proof<Proposition>>, GenTraversableOnce<B>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public Iterator<AccountTransaction<Proposition, Proof<Proposition>>> filter(Function1<AccountTransaction<Proposition, Proof<Proposition>>, Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<AccountTransaction<Proposition, Proof<Proposition>>, B, Object> p) {
                return Iterator.corresponds$((Iterator)this, that, p);
            }

            public Iterator<AccountTransaction<Proposition, Proof<Proposition>>> withFilter(Function1<AccountTransaction<Proposition, Proof<Proposition>>, Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public Iterator<AccountTransaction<Proposition, Proof<Proposition>>> filterNot(Function1<AccountTransaction<Proposition, Proof<Proposition>>, Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<AccountTransaction<Proposition, Proof<Proposition>>, B> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, AccountTransaction<Proposition, Proof<Proposition>>, B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<AccountTransaction<Proposition, Proof<Proposition>>, B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public Iterator<AccountTransaction<Proposition, Proof<Proposition>>> takeWhile(Function1<AccountTransaction<Proposition, Proof<Proposition>>, Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<AccountTransaction<Proposition, Proof<Proposition>>>, Iterator<AccountTransaction<Proposition, Proof<Proposition>>>> partition(Function1<AccountTransaction<Proposition, Proof<Proposition>>, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public Tuple2<Iterator<AccountTransaction<Proposition, Proof<Proposition>>>, Iterator<AccountTransaction<Proposition, Proof<Proposition>>>> span(Function1<AccountTransaction<Proposition, Proof<Proposition>>, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<AccountTransaction<Proposition, Proof<Proposition>>> dropWhile(Function1<AccountTransaction<Proposition, Proof<Proposition>>, Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<AccountTransaction<Proposition, Proof<Proposition>>, B>> zip(Iterator<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<AccountTransaction<Proposition, Proof<Proposition>>, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<AccountTransaction<Proposition, Proof<Proposition>>, U> f) {
                Iterator.foreach$((Iterator)this, f);
            }

            public boolean forall(Function1<AccountTransaction<Proposition, Proof<Proposition>>, Object> p) {
                return Iterator.forall$((Iterator)this, p);
            }

            public boolean exists(Function1<AccountTransaction<Proposition, Proof<Proposition>>, Object> p) {
                return Iterator.exists$((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public Option<AccountTransaction<Proposition, Proof<Proposition>>> find(Function1<AccountTransaction<Proposition, Proof<Proposition>>, Object> p) {
                return Iterator.find$((Iterator)this, p);
            }

            public int indexWhere(Function1<AccountTransaction<Proposition, Proof<Proposition>>, Object> p) {
                return Iterator.indexWhere$((Iterator)this, p);
            }

            public int indexWhere(Function1<AccountTransaction<Proposition, Proof<Proposition>>, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public BufferedIterator<AccountTransaction<Proposition, Proof<Proposition>>> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public int length() {
                return Iterator.length$((Iterator)this);
            }

            public Tuple2<Iterator<AccountTransaction<Proposition, Proof<Proposition>>>, Iterator<AccountTransaction<Proposition, Proof<Proposition>>>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Traversable<AccountTransaction<Proposition, Proof<Proposition>>> toTraversable() {
                return Iterator.toTraversable$((Iterator)this);
            }

            public Iterator<AccountTransaction<Proposition, Proof<Proposition>>> toIterator() {
                return Iterator.toIterator$((Iterator)this);
            }

            public Stream<AccountTransaction<Proposition, Proof<Proposition>>> toStream() {
                return Iterator.toStream$((Iterator)this);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public List<AccountTransaction<Proposition, Proof<Proposition>>> reversed() {
                return TraversableOnce.reversed$((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.size$((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.nonEmpty$((TraversableOnce)this);
            }

            public int count(Function1<AccountTransaction<Proposition, Proof<Proposition>>, Object> p) {
                return TraversableOnce.count$((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<AccountTransaction<Proposition, Proof<Proposition>>, B> pf) {
                return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, AccountTransaction<Proposition, Proof<Proposition>>, B> op) {
                return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<AccountTransaction<Proposition, Proof<Proposition>>, B, B> op) {
                return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, AccountTransaction<Proposition, Proof<Proposition>>, B> op) {
                return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<AccountTransaction<Proposition, Proof<Proposition>>, B, B> op) {
                return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, AccountTransaction<Proposition, Proof<Proposition>>, B> op) {
                return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<AccountTransaction<Proposition, Proof<Proposition>>, B, B> op) {
                return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, AccountTransaction<Proposition, Proof<Proposition>>, B> op) {
                return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<AccountTransaction<Proposition, Proof<Proposition>>, B, B> op) {
                return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.reduceOption$((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, AccountTransaction<Proposition, Proof<Proposition>>, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.sum$((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.product$((TraversableOnce)this, num);
            }

            public Object min(Ordering cmp) {
                return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object max(Ordering cmp) {
                return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
            }

            public List<AccountTransaction<Proposition, Proof<Proposition>>> toList() {
                return TraversableOnce.toList$((TraversableOnce)this);
            }

            public Iterable<AccountTransaction<Proposition, Proof<Proposition>>> toIterable() {
                return TraversableOnce.toIterable$((TraversableOnce)this);
            }

            public Seq<AccountTransaction<Proposition, Proof<Proposition>>> toSeq() {
                return TraversableOnce.toSeq$((TraversableOnce)this);
            }

            public IndexedSeq<AccountTransaction<Proposition, Proof<Proposition>>> toIndexedSeq() {
                return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.toBuffer$((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.toSet$((TraversableOnce)this);
            }

            public Vector<AccountTransaction<Proposition, Proof<Proposition>>> toVector() {
                return TraversableOnce.toVector$((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, AccountTransaction<Proposition, Proof<Proposition>>, Col> cbf) {
                return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
            }

            public <T, U> Map<T, U> toMap(Predef.$less$colon$less<AccountTransaction<Proposition, Proof<Proposition>>, Tuple2<T, U>> ev) {
                return TraversableOnce.toMap$((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.mkString$((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
            }

            public int sizeHintIfCheap() {
                return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
            }

            public BigInteger txOrder(AccountTransaction<Proposition, Proof<Proposition>> tx) {
                return tx.getMaxFeePerGas().subtract(this.io$horizen$account$mempool$MempoolMap$TransactionsByPriceAndNonce$Iter$$$outer().io$horizen$account$mempool$MempoolMap$TransactionsByPriceAndNonce$$baseFee).min(tx.getMaxPriorityFeePerGas());
            }

            private Queue<AccountTransaction<Proposition, Proof<Proposition>>> forcedTxQueue() {
                return this.forcedTxQueue;
            }

            private PriorityQueue<AccountTransaction<Proposition, Proof<Proposition>>> orderedQueue() {
                return this.orderedQueue;
            }

            public boolean hasNext() {
                return this.forcedTxQueue().nonEmpty() || this.orderedQueue().nonEmpty();
            }

            /*
             * WARNING - void declaration
             */
            public AccountTransaction<Proposition, Proof<Proposition>> next() {
                AccountTransaction accountTransaction;
                if (this.forcedTxQueue().nonEmpty()) {
                    accountTransaction = (AccountTransaction)this.forcedTxQueue().dequeue();
                } else {
                    void var1_1;
                    AccountTransaction bestTx = (AccountTransaction)this.orderedQueue().dequeue();
                    Option nextTxIdOpt = ((MapLike)this.io$horizen$account$mempool$MempoolMap$TransactionsByPriceAndNonce$Iter$$$outer().io$horizen$account$mempool$MempoolMap$TransactionsByPriceAndNonce$$$outer().io$horizen$account$mempool$MempoolMap$$executableTxs().apply(bestTx.getFrom())).get((Object)bestTx.getNonce().add(BigInteger.ONE));
                    if (nextTxIdOpt.nonEmpty()) {
                        AccountTransaction tx = (AccountTransaction)this.io$horizen$account$mempool$MempoolMap$TransactionsByPriceAndNonce$Iter$$$outer().io$horizen$account$mempool$MempoolMap$TransactionsByPriceAndNonce$$$outer().getTransaction((String)nextTxIdOpt.get()).get();
                        this.orderedQueue().enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccountTransaction[]{tx}));
                    }
                    accountTransaction = var1_1;
                }
                return accountTransaction;
            }

            @Override
            public AccountTransaction<Proposition, Proof<Proposition>> peek() {
                return this.forcedTxQueue().nonEmpty() ? (AccountTransaction)this.forcedTxQueue().head() : (AccountTransaction)this.orderedQueue().head();
            }

            @Override
            public AccountTransaction<Proposition, Proof<Proposition>> removeAndSkipAccount() {
                return this.forcedTxQueue().nonEmpty() ? (AccountTransaction)this.forcedTxQueue().dequeue() : (AccountTransaction)this.orderedQueue().dequeue();
            }

            public /* synthetic */ TransactionsByPriceAndNonce io$horizen$account$mempool$MempoolMap$TransactionsByPriceAndNonce$Iter$$$outer() {
                return TransactionsByPriceAndNonce.this;
            }

            public static final /* synthetic */ void $anonfun$new$1(Iter $this, Tuple2 x0$1) {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                SortedMap mapOfTxsPerAccount = (SortedMap)tuple2._2();
                AccountTransaction tx = (AccountTransaction)$this.io$horizen$account$mempool$MempoolMap$TransactionsByPriceAndNonce$Iter$$$outer().io$horizen$account$mempool$MempoolMap$TransactionsByPriceAndNonce$$$outer().getTransaction((String)mapOfTxsPerAccount.values().head()).get();
                $this.orderedQueue().enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccountTransaction[]{tx}));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }

            public static final /* synthetic */ void $anonfun$new$2(Iter $this, AccountTransaction x$14) {
                $this.forcedTxQueue().enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccountTransaction[]{x$14}));
            }

            public Iter() {
                if (TransactionsByPriceAndNonce.this == null) {
                    throw null;
                }
                GenTraversableOnce.$init$((GenTraversableOnce)this);
                TraversableOnce.$init$((TraversableOnce)this);
                Iterator.$init$((Iterator)this);
                this.forcedTxQueue = new Queue();
                this.orderedQueue = new PriorityQueue(scala.package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)tx -> this.txOrder((AccountTransaction<Proposition, Proof<Proposition>>)tx), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())));
                TransactionsByPriceAndNonce.this.io$horizen$account$mempool$MempoolMap$TransactionsByPriceAndNonce$$$outer().io$horizen$account$mempool$MempoolMap$$executableTxs().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Iter.$anonfun$new$1(this, x0$1);
                    return BoxedUnit.UNIT;
                });
                TransactionsByPriceAndNonce.this.io$horizen$account$mempool$MempoolMap$TransactionsByPriceAndNonce$$forcedTx.foreach((Function1 & Serializable & scala.Serializable)x$14 -> {
                    Iter.$anonfun$new$2(this, x$14);
                    return BoxedUnit.UNIT;
                });
            }
        }
    }
}

