/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.mempool;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.AccountMempoolSettings;
import io.horizen.SidechainTypes;
import io.horizen.account.api.rpc.types.EthereumTransactionView;
import io.horizen.account.block.AccountBlock;
import io.horizen.account.mempool.AccountMemoryPool$;
import io.horizen.account.mempool.MempoolMap;
import io.horizen.account.node.NodeAccountMemoryPool;
import io.horizen.account.proposition.AddressProposition;
import io.horizen.account.state.AccountEventNotifierProvider;
import io.horizen.account.state.AccountStateReaderProvider;
import io.horizen.account.state.BaseStateReaderProvider;
import io.horizen.account.transaction.AccountTransaction;
import io.horizen.account.transaction.EthereumTransaction;
import io.horizen.evm.Address;
import io.horizen.proof.Proof;
import io.horizen.proposition.Proposition;
import io.horizen.utxo.box.Box;
import io.horizen.utxo.box.ForgerBox;
import io.horizen.utxo.box.WithdrawalRequestBox;
import io.horizen.utxo.box.ZenBox;
import io.horizen.utxo.transaction.BoxTransaction;
import io.horizen.utxo.transaction.SidechainTransaction;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.Optional;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.concurrent.TrieMap;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.SortedMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sparkz.core.NodeViewModifier;
import sparkz.core.consensus.ContainsModifiers;
import sparkz.core.transaction.MemoryPool;
import sparkz.core.transaction.MempoolReader;
import sparkz.util.SparkzLogging;
import sparkz.util.package;
import supertagged.package;

@ScalaSignature(bytes="\u0006\u0001\t\u001dg\u0001B\u0015+\u0001MB\u0001b\u001a\u0001\u0003\u0002\u0003\u0006I\u0001\u001b\u0005\tW\u0002\u0011\t\u0011)A\u0005Y\"A!\u000f\u0001B\u0001B\u0003%1\u000f\u0003\u0005w\u0001\t\u0005\t\u0015!\u0003x\u0011!Q\bA!A!\u0002\u0013Y\b\"\u0002@\u0001\t\u0003yX!BA\u0006\u0001\u0001*\u0006bBA\u0007\u0001\u0011\u0005\u0013q\u0002\u0005\b\u0003o\u0001A\u0011IA\u001d\u0011\u001d\t)\u0005\u0001C!\u0003\u000fBq!a\u0018\u0001\t\u0003\n\t\u0007C\u0004\u0002j\u0001!\t%a\u001b\t\u000f\u0005]\u0004\u0001\"\u0001\u0002z!I\u0011Q\u0011\u0001\u0012\u0002\u0013\u0005\u0011q\u0011\u0005\b\u0003;\u0003A\u0011IAP\u0011\u001d\ti\n\u0001C!\u0003KCq!!-\u0001\t\u0003\n\u0019\fC\u0004\u00028\u0002!\t%!/\t\u000f\u0005\u0005\u0007\u0001\"\u0011\u0002D\"9\u0011\u0011\u0019\u0001\u0005B\u0005M\u0007bBAl\u0001\u0011\u0005\u0013\u0011\u001c\u0005\b\u0003;\u0004A\u0011IAp\u0011\u001d\t\u0019\u000f\u0001C!\u0003KDq!!>\u0001\t\u0003\t9\u0010C\u0004\u0002|\u0002!\t!a>\t\u000f\u0005u\b\u0001\"\u0001\u0002\u0000\"9!\u0011\n\u0001\u0005\u0002\u0005}\bb\u0002B&\u0001\u0011\u0005!Q\n\u0005\b\u0005'\u0002A\u0011\u0001B+\u0011\u001d\u0011I\u0006\u0001C\u0001\u00057BqA!\u001d\u0001\t\u0003\u0011Y\u0006C\u0004\u0003t\u0001!\tA!\u001e\t\u000f\u0005\r\b\u0001\"\u0011\u0003z!9!q\u0011\u0001\u0005B\t%\u0005b\u0002BF\u0001\u0011\u0005#Q\u0012\u0005\b\u00053\u0003A\u0011\u0001BN\u000f\u001d\u0011\u0019L\u000bE\u0001\u0005k3a!\u000b\u0016\t\u0002\t]\u0006B\u0002@'\t\u0003\u0011I\fC\u0004\u0003<\u001a\"\tA!0\u0003#\u0005\u001b7m\\;oi6+Wn\u001c:z!>|GN\u0003\u0002,Y\u00059Q.Z7q_>d'BA\u0017/\u0003\u001d\t7mY8v]RT!a\f\u0019\u0002\u000f!|'/\u001b>f]*\t\u0011'\u0001\u0002j_\u000e\u00011C\u0002\u00015u][\u0016\r\u0005\u00026q5\taGC\u00018\u0003\u0015\u00198-\u00197b\u0013\tIdG\u0001\u0004B]f\u0014VM\u001a\t\u0005w\t#U+D\u0001=\u0015\tid(A\u0006ue\u0006t7/Y2uS>t'BA A\u0003\u0011\u0019wN]3\u000b\u0003\u0005\u000baa\u001d9be.T\u0018BA\"=\u0005)iU-\\8ssB{w\u000e\u001c\t\u0005\u000b\u001eKu*D\u0001G\u0015\tiD&\u0003\u0002I\r\n\u0011\u0012iY2pk:$HK]1og\u0006\u001cG/[8o!\tQU*D\u0001L\u0015\tae&A\u0006qe>\u0004xn]5uS>t\u0017B\u0001(L\u0005-\u0001&o\u001c9pg&$\u0018n\u001c8\u0011\u0007A\u001b\u0016*D\u0001R\u0015\t\u0011f&A\u0003qe>|g-\u0003\u0002U#\n)\u0001K]8pMB\u0011a\u000bA\u0007\u0002UA\u0011\u0001,W\u0007\u0002]%\u0011!L\f\u0002\u000f'&$Wm\u00195bS:$\u0016\u0010]3t!\tav,D\u0001^\u0015\tqF&\u0001\u0003o_\u0012,\u0017B\u00011^\u0005Uqu\u000eZ3BG\u000e|WO\u001c;NK6|'/\u001f)p_2\u0004\"AY3\u000e\u0003\rT!\u0001\u001a!\u0002\tU$\u0018\u000e\\\u0005\u0003M\u000e\u0014Qb\u00159be.THj\\4hS:<\u0017aC;oG>tg-\u001b:nK\u0012\u0004\"AV5\n\u0005)T#AC'f[B|w\u000e\\'ba\u0006Q\u0012mY2pk:$8\u000b^1uKJ+\u0017\rZ3s!J|g/\u001b3feB\u0011Q\u000e]\u0007\u0002]*\u0011q\u000eL\u0001\u0006gR\fG/Z\u0005\u0003c:\u0014!$Q2d_VtGo\u0015;bi\u0016\u0014V-\u00193feB\u0013xN^5eKJ\fqCY1tKN#\u0018\r^3SK\u0006$WM\u001d)s_ZLG-\u001a:\u0011\u00055$\u0018BA;o\u0005]\u0011\u0015m]3Ti\u0006$XMU3bI\u0016\u0014\bK]8wS\u0012,'/A\bnK6\u0004xn\u001c7TKR$\u0018N\\4t!\tA\u00060\u0003\u0002z]\t1\u0012iY2pk:$X*Z7q_>d7+\u001a;uS:<7/A\u000bfm\u0016tGOT8uS\u001aLWM\u001d)s_ZLG-\u001a:\u0011\u00055d\u0018BA?o\u0005q\t5mY8v]R,e/\u001a8u\u001d>$\u0018NZ5feB\u0013xN^5eKJ\fa\u0001P5oSRtDcC+\u0002\u0002\u0005\r\u0011QAA\u0004\u0003\u0013AQa\u001a\u0004A\u0002!DQa\u001b\u0004A\u00021DQA\u001d\u0004A\u0002MDQA\u001e\u0004A\u0002]DQA\u001f\u0004A\u0002m\u0014AA\u0014,D)\u0006aQn\u001c3jM&,'OQ=JIR!\u0011\u0011CA\f!\u0011)\u00141\u0003#\n\u0007\u0005UaG\u0001\u0004PaRLwN\u001c\u0005\b\u00033A\u0001\u0019AA\u000e\u0003)iw\u000eZ5gS\u0016\u0014\u0018\n\u001a\t\u0005\u0003;\t\tD\u0004\u0003\u0002 \u00055b\u0002BA\u0011\u0003WqA!a\t\u0002*5\u0011\u0011Q\u0005\u0006\u0004\u0003O\u0011\u0014A\u0002\u001fs_>$h(C\u0001B\u0013\t!\u0007)C\u0002\u00020\r\fq\u0001]1dW\u0006<W-\u0003\u0003\u00024\u0005U\"AC'pI&4\u0017.\u001a:JI*\u0019\u0011qF2\u0002\u0011\r|g\u000e^1j]N$B!a\u000f\u0002BA\u0019Q'!\u0010\n\u0007\u0005}bGA\u0004C_>dW-\u00198\t\u000f\u0005\r\u0013\u00021\u0001\u0002\u001c\u0005\u0011\u0011\u000eZ\u0001\u0007O\u0016$\u0018\t\u001c7\u0015\t\u0005%\u0013\u0011\f\t\u0006\u0003\u0017\n\u0019\u0006\u0012\b\u0005\u0003\u001b\n\tF\u0004\u0003\u0002$\u0005=\u0013\"A\u001c\n\u0007\u0005=b'\u0003\u0003\u0002V\u0005]#aA*fc*\u0019\u0011q\u0006\u001c\t\u000f\u0005m#\u00021\u0001\u0002^\u0005\u0019\u0011\u000eZ:\u0011\r\u0005-\u00131KA\u000e\u0003\u0011\u0019\u0018N_3\u0016\u0005\u0005\r\u0004cA\u001b\u0002f%\u0019\u0011q\r\u001c\u0003\u0007%sG/\u0001\u0003uC.,G\u0003BA7\u0003g\u0002R!a\u0013\u0002p\u0011KA!!\u001d\u0002X\tA\u0011\n^3sC\ndW\rC\u0004\u0002v1\u0001\r!a\u0019\u0002\u000b1LW.\u001b;\u0002#Q\f7.Z#yK\u000e,H/\u00192mKRC8\u000f\u0006\u0003\u0002|\u0005\u0005\u0005c\u00015\u0002~%\u0019\u0011qP5\u00037Q\u0013\u0018M\\:bGRLwN\\:CsB\u0013\u0018nY3B]\u0012tuN\\2f\u0011%\t\u0019)\u0004I\u0001\u0002\u0004\ti'\u0001\u0005g_J\u001cW\r\u001a+y\u0003m!\u0018m[3Fq\u0016\u001cW\u000f^1cY\u0016$\u0006p\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u0012\u0016\u0005\u0003[\nYi\u000b\u0002\u0002\u000eB!\u0011qRAM\u001b\t\t\tJ\u0003\u0003\u0002\u0014\u0006U\u0015!C;oG\",7m[3e\u0015\r\t9JN\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAN\u0003#\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003\u00191\u0017\u000e\u001c;feR\u0019Q+!)\t\u000f\u0005\rv\u00021\u0001\u0002J\u0005\u0019A\u000f_:\u0015\u0007U\u000b9\u000bC\u0004\u0002*B\u0001\r!a+\u0002\u0013\r|g\u000eZ5uS>t\u0007CB\u001b\u0002.\u0012\u000bY$C\u0002\u00020Z\u0012\u0011BR;oGRLwN\\\u0019\u0002\u000b9|G/\u00138\u0015\t\u0005u\u0013Q\u0017\u0005\b\u00037\n\u0002\u0019AA/\u0003%9W\r\u001e*fC\u0012,'/\u0006\u0002\u0002<B!1(!0E\u0013\r\ty\f\u0010\u0002\u000e\u001b\u0016l\u0007o\\8m%\u0016\fG-\u001a:\u0002\u0007A,H\u000f\u0006\u0003\u0002F\u0006=\u0007#BAd\u0003\u0017,VBAAe\u0015\t!g'\u0003\u0003\u0002N\u0006%'a\u0001+ss\"1\u0011\u0011[\nA\u0002\u0011\u000b!\u0001\u001e=\u0015\t\u0005\u0015\u0017Q\u001b\u0005\b\u0003G#\u0002\u0019AA7\u0003=\u0001X\u000f^,ji\"|W\u000f^\"iK\u000e\\GcA+\u0002\\\"9\u00111U\u000bA\u0002\u00055\u0014A\u0002:f[>4X\rF\u0002V\u0003CDa!!5\u0017\u0001\u0004!\u0015aD4fiR\u0013\u0018M\\:bGRLwN\\:\u0015\u0005\u0005\u001d\b#BAu\u0003c$UBAAv\u0015\r!\u0017Q\u001e\u0006\u0003\u0003_\fAA[1wC&!\u00111_Av\u0005\u0011a\u0015n\u001d;\u00023\u001d,G/\u0012=fGV$\u0018M\u00197f)J\fgn]1di&|gn]\u000b\u0003\u0003s\u0004b!!;\u0002r\u0006m\u0011\u0001H4fi:{g.\u0012=fGV$\u0018M\u00197f)J\fgn]1di&|gn]\u0001\u001dO\u0016$X\t_3dkR\f'\r\\3Ue\u0006t7/Y2uS>t7/T1q+\t\u0011\t\u0001\u0005\u0005\u0003\u0004\t5!\u0011\u0003B\u000f\u001b\t\u0011)A\u0003\u0003\u0003\b\t%\u0011AC2p]\u000e,(O]3oi*\u0019!1\u0002\u001c\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003\u0010\t\u0015!a\u0002+sS\u0016l\u0015\r\u001d\t\u0005\u0005'\u0011I\"\u0004\u0002\u0003\u0016)\u0019!q\u0003\u0018\u0002\u0007\u00154X.\u0003\u0003\u0003\u001c\tU!aB!eIJ,7o\u001d\t\t\u0005?\u0011)C!\u000b\u000365\u0011!\u0011\u0005\u0006\u0005\u0005G\u0011I!A\u0004nkR\f'\r\\3\n\t\t\u001d\"\u0011\u0005\u0002\n'>\u0014H/\u001a3NCB\u0004BAa\u000b\u000325\u0011!Q\u0006\u0006\u0005\u0005_\ti/\u0001\u0003nCRD\u0017\u0002\u0002B\u001a\u0005[\u0011!BQ5h\u0013:$XmZ3s!\u0011\u00119D!\u0012\u000e\u0005\te\"\u0002\u0002B\u001e\u0005{\tQ\u0001^=qKNTAAa\u0010\u0003B\u0005\u0019!\u000f]2\u000b\u0007\t\rC&A\u0002ba&LAAa\u0012\u0003:\t9R\t\u001e5fe\u0016,X\u000e\u0016:b]N\f7\r^5p]ZKWm^\u0001 O\u0016$hj\u001c8Fq\u0016\u001cW\u000f^1cY\u0016$&/\u00198tC\u000e$\u0018n\u001c8t\u001b\u0006\u0004\u0018\u0001I4fi\u0016CXmY;uC\ndW\r\u0016:b]N\f7\r^5p]Nl\u0015\r\u001d$s_6$BA!\b\u0003P!9!\u0011\u000b\u000fA\u0002\tE\u0011\u0001\u00024s_6\f1eZ3u\u001d>tW\t_3dkR\f'\r\\3Ue\u0006t7/Y2uS>t7/T1q\rJ|W\u000e\u0006\u0003\u0003\u001e\t]\u0003b\u0002B);\u0001\u0007!\u0011C\u0001$O\u0016$X\t_3dkR\f'\r\\3Ue\u0006t7/Y2uS>t7/T1q\u0013:\u001c\b/Z2u+\t\u0011i\u0006\u0005\u0005\u0003\u0004\t5!\u0011\u0003B0!!\u0011yB!\n\u0003*\t\u0005\u0004\u0003\u0002B2\u0005WrAA!\u001a\u0003hA\u0019\u00111\u0005\u001c\n\u0007\t%d'\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005[\u0012yG\u0001\u0004TiJLgn\u001a\u0006\u0004\u0005S2\u0014AJ4fi:{g.\u0012=fGV$\u0018M\u00197f)J\fgn]1di&|gn]'ba&s7\u000f]3di\u0006aq-\u001a;Q_>dgj\u001c8dKR!!\u0011\u0006B<\u0011\u0015i\u0003\u00051\u0001J)\u0019\t9Oa\u001f\u0003\u0006\"9!QP\u0011A\u0002\t}\u0014!A2\u0011\u000b\u0005%(\u0011\u0011#\n\t\t\r\u00151\u001e\u0002\u000b\u0007>l\u0007/\u0019:bi>\u0014\bbBA;C\u0001\u0007\u00111M\u0001\bO\u0016$8+\u001b>f)\t\t\u0019'\u0001\nhKR$&/\u00198tC\u000e$\u0018n\u001c8Cs&#G\u0003\u0002BH\u0005+\u0003R!!;\u0003\u0012\u0012KAAa%\u0002l\nAq\n\u001d;j_:\fG\u000eC\u0004\u0003\u0018\u000e\u0002\rA!\u0019\u0002\u001bQ\u0014\u0018M\\:bGRLwN\\%e\u00035)\b\u000fZ1uK6+W\u000eU8pYR)QK!(\u00030\"9!q\u0014\u0013A\u0002\t\u0005\u0016!\u0004:f[>4X\r\u001a\"m_\u000e\\7\u000f\u0005\u0004\u0002L\u0005M#1\u0015\t\u0005\u0005K\u0013Y+\u0004\u0002\u0003(*\u0019!\u0011\u0016\u0017\u0002\u000b\tdwnY6\n\t\t5&q\u0015\u0002\r\u0003\u000e\u001cw.\u001e8u\u00052|7m\u001b\u0005\b\u0005c#\u0003\u0019\u0001BQ\u00035\t\u0007\u000f\u001d7jK\u0012\u0014En\\2lg\u0006\t\u0012iY2pk:$X*Z7pef\u0004vn\u001c7\u0011\u0005Y33C\u0001\u00145)\t\u0011),\u0001\nde\u0016\fG/Z#naRLX*Z7q_>dG#C+\u0003@\n\u0005'1\u0019Bc\u0011\u0015Y\u0007\u00061\u0001m\u0011\u0015\u0011\b\u00061\u0001t\u0011\u00151\b\u00061\u0001x\u0011\u0015Q\b\u00061\u0001|\u0001")
public class AccountMemoryPool
implements MemoryPool<AccountTransaction<Proposition, Proof<Proposition>>, AccountMemoryPool>,
SidechainTypes,
NodeAccountMemoryPool,
SparkzLogging {
    private final MempoolMap unconfirmed;
    private final AccountStateReaderProvider accountStateReaderProvider;
    private final BaseStateReaderProvider baseStateReaderProvider;
    private final AccountMempoolSettings mempoolSettings;
    private final AccountEventNotifierProvider eventNotifierProvider;
    private final Logger logger;

    public static AccountMemoryPool createEmptyMempool(AccountStateReaderProvider accountStateReaderProvider, BaseStateReaderProvider baseStateReaderProvider, AccountMempoolSettings accountMempoolSettings, AccountEventNotifierProvider accountEventNotifierProvider) {
        return AccountMemoryPool$.MODULE$.createEmptyMempool(accountStateReaderProvider, baseStateReaderProvider, accountMempoolSettings, accountEventNotifierProvider);
    }

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    @Override
    public BoxTransaction<Proposition, Box<Proposition>> sidechainTxToScbt(SidechainTransaction<Proposition, Box<Proposition>> t) {
        return SidechainTypes.sidechainTxToScbt$(this, t);
    }

    @Override
    public AccountTransaction<Proposition, Proof<Proposition>> ethereumTxToScat(EthereumTransaction t) {
        return SidechainTypes.ethereumTxToScat$(this, t);
    }

    @Override
    public java.util.List<BoxTransaction<Proposition, Box<Proposition>>> sidechainTxListToScbtList(java.util.List<SidechainTransaction<Proposition, Box<Proposition>>> tl) {
        return SidechainTypes.sidechainTxListToScbtList$(this, tl);
    }

    @Override
    public Box<Proposition> zenBoxToScb(ZenBox b) {
        return SidechainTypes.zenBoxToScb$(this, b);
    }

    @Override
    public Box<Proposition> withdrawalRequestBoxToScb(WithdrawalRequestBox b) {
        return SidechainTypes.withdrawalRequestBoxToScb$(this, b);
    }

    @Override
    public Box<Proposition> forgerBoxToScb(ForgerBox b) {
        return SidechainTypes.forgerBoxToScb$(this, b);
    }

    @Override
    public java.util.List<Box<Proposition>> zenBoxJavaListToScbtJavaList(java.util.List<ZenBox> bl) {
        return SidechainTypes.zenBoxJavaListToScbtJavaList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> zenBoxListToScbtList(List<ZenBox> bl) {
        return SidechainTypes.zenBoxListToScbtList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> forgerBoxListToScbtList(List<ForgerBox> bl) {
        return SidechainTypes.forgerBoxListToScbtList$(this, bl);
    }

    @Override
    public Set<Box<Proposition>> zenBoxSetToScbSet(Set<ZenBox> bs) {
        return SidechainTypes.zenBoxSetToScbSet$(this, bs);
    }

    @Override
    public ForgerBox scbToForgerBox(Box<Proposition> b) {
        return SidechainTypes.scbToForgerBox$(this, b);
    }

    @Override
    public WithdrawalRequestBox scbToWithdrawalRequestBox(Box<Proposition> b) {
        return SidechainTypes.scbToWithdrawalRequestBox$(this, b);
    }

    public Option<AccountTransaction<Proposition, Proof<Proposition>>> getById(String id) {
        return MempoolReader.getById$((MempoolReader)this, (String)id);
    }

    public boolean contains(NodeViewModifier persistentModifier) {
        return ContainsModifiers.contains$((ContainsModifiers)this, (NodeViewModifier)persistentModifier);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public Option<AccountTransaction<Proposition, Proof<Proposition>>> modifierById(String modifierId) {
        return this.unconfirmed.getTransaction(modifierId);
    }

    public boolean contains(String id) {
        return this.unconfirmed.contains(id);
    }

    public Seq<AccountTransaction<Proposition, Proof<Proposition>>> getAll(Seq<String> ids) {
        return (Seq)ids.flatMap((Function1 & Serializable & scala.Serializable)modifierId -> Option$.MODULE$.option2Iterable(this.modifierById((String)modifierId)), Seq$.MODULE$.canBuildFrom());
    }

    public int size() {
        return this.unconfirmed.size();
    }

    public Iterable<AccountTransaction<Proposition, Proof<Proposition>>> take(int limit) {
        return (Iterable)this.unconfirmed.takeExecutableTxs((Iterable<AccountTransaction<Proposition, Proof<Proposition>>>)((Iterable)Nil$.MODULE$)).take(limit);
    }

    public MempoolMap.TransactionsByPriceAndNonce takeExecutableTxs(Iterable<AccountTransaction<Proposition, Proof<Proposition>>> forcedTx) {
        return this.unconfirmed.takeExecutableTxs(forcedTx);
    }

    public Iterable<AccountTransaction<Proposition, Proof<Proposition>>> takeExecutableTxs$default$1() {
        return (Iterable)Nil$.MODULE$;
    }

    public AccountMemoryPool filter(Seq<AccountTransaction<Proposition, Proof<Proposition>>> txs) {
        return this.filter((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)AccountMemoryPool.$anonfun$filter$1(txs, t)));
    }

    /*
     * WARNING - void declaration
     */
    public AccountMemoryPool filter(Function1<AccountTransaction<Proposition, Proof<Proposition>>, Object> condition) {
        void var3_3;
        Iterable filteredTxs = (Iterable)this.unconfirmed.values().filter((Function1 & Serializable & scala.Serializable)tx -> BoxesRunTime.boxToBoolean((boolean)AccountMemoryPool.$anonfun$filter$3(condition, tx)));
        AccountMemoryPool newMemPool = AccountMemoryPool$.MODULE$.createEmptyMempool(this.accountStateReaderProvider, this.baseStateReaderProvider, this.mempoolSettings, this.eventNotifierProvider);
        filteredTxs.foreach((Function1 & Serializable & scala.Serializable)tx -> newMemPool.put((AccountTransaction<Proposition, Proof<Proposition>>)tx));
        return var3_3;
    }

    public Seq<String> notIn(Seq<String> ids) {
        return MempoolReader.notIn$((MempoolReader)this, ids);
    }

    public MempoolReader<AccountTransaction<Proposition, Proof<Proposition>>> getReader() {
        return this;
    }

    public Try<AccountMemoryPool> put(AccountTransaction<Proposition, Proof<Proposition>> tx) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Tuple2 tuple2 = (Tuple2)$this.unconfirmed.add(tx).get();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            MempoolMap updatedUnconfirmed = (MempoolMap)tuple2._1();
            Iterable newExecTcs = (Iterable)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)updatedUnconfirmed, (Object)newExecTcs);
            Tuple2 tuple23 = tuple22;
            MempoolMap updatedUnconfirmed2 = (MempoolMap)tuple23._1();
            Iterable newExecTcs2 = (Iterable)tuple23._2();
            if (newExecTcs2.nonEmpty()) {
                $this.eventNotifierProvider.getEventNotifier().sendNewExecTxsEvent((Iterable<AccountTransaction<Proposition, Proof<Proposition>>>)newExecTcs2);
            }
            return new AccountMemoryPool(updatedUnconfirmed2, $this.accountStateReaderProvider, $this.baseStateReaderProvider, $this.mempoolSettings, $this.eventNotifierProvider);
        });
    }

    public Try<AccountMemoryPool> put(Iterable<AccountTransaction<Proposition, Proof<Proposition>>> txs) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            txs.foreach((Function1 & Serializable & scala.Serializable)t -> this.put((AccountTransaction<Proposition, Proof<Proposition>>)t));
            return this;
        });
    }

    public AccountMemoryPool putWithoutCheck(Iterable<AccountTransaction<Proposition, Proof<Proposition>>> txs) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public AccountMemoryPool remove(AccountTransaction<Proposition, Proof<Proposition>> tx) {
        Try<MempoolMap> try_ = this.unconfirmed.removeFromMempool(tx);
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error(new StringBuilder(50).append("Exception while removing transaction ").append(tx).append(" from MemPool").toString(), e);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                throw e;
            }
            throw new MatchError(try_);
        }
        Success success = (Success)try_;
        MempoolMap mempoolMap = (MempoolMap)success.value();
        AccountMemoryPool accountMemoryPool = new AccountMemoryPool(mempoolMap, this.accountStateReaderProvider, this.baseStateReaderProvider, this.mempoolSettings, this.eventNotifierProvider);
        return accountMemoryPool;
    }

    @Override
    public java.util.List<AccountTransaction<Proposition, Proof<Proposition>>> getTransactions() {
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.unconfirmed.values().toList()).asJava();
    }

    public java.util.List<String> getExecutableTransactions() {
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.unconfirmed.mempoolTransactions(true).toList()).asJava();
    }

    public java.util.List<String> getNonExecutableTransactions() {
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.unconfirmed.mempoolTransactions(false).toList()).asJava();
    }

    public TrieMap<Address, SortedMap<BigInteger, EthereumTransactionView>> getExecutableTransactionsMap() {
        return this.unconfirmed.mempoolTransactionsMap(true);
    }

    public TrieMap<Address, SortedMap<BigInteger, EthereumTransactionView>> getNonExecutableTransactionsMap() {
        return this.unconfirmed.mempoolTransactionsMap(false);
    }

    public SortedMap<BigInteger, EthereumTransactionView> getExecutableTransactionsMapFrom(Address from) {
        return this.unconfirmed.mempoolTransactionsMapFrom(true, from);
    }

    public SortedMap<BigInteger, EthereumTransactionView> getNonExecutableTransactionsMapFrom(Address from) {
        return this.unconfirmed.mempoolTransactionsMapFrom(false, from);
    }

    public TrieMap<Address, SortedMap<BigInteger, String>> getExecutableTransactionsMapInspect() {
        return this.unconfirmed.mempoolTransactionsMapInspect(true);
    }

    public TrieMap<Address, SortedMap<BigInteger, String>> getNonExecutableTransactionsMapInspect() {
        return this.unconfirmed.mempoolTransactionsMapInspect(false);
    }

    public BigInteger getPoolNonce(Proposition account) {
        return (BigInteger)this.unconfirmed.getAccountNonce(account).getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.accountStateReaderProvider.getAccountStateReader().getNonce(((AddressProposition)account).address()));
    }

    @Override
    public java.util.List<AccountTransaction<Proposition, Proof<Proposition>>> getTransactions(Comparator<AccountTransaction<Proposition, Proof<Proposition>>> c, int limit) {
        java.util.List<AccountTransaction<Proposition, Proof<Proposition>>> txs = this.getTransactions();
        txs.sort(c);
        return txs.subList(0, limit);
    }

    @Override
    public int getSize() {
        return this.size();
    }

    @Override
    public Optional<AccountTransaction<Proposition, Proof<Proposition>>> getTransactionById(String transactionId) {
        return Optional.ofNullable(this.unconfirmed.getTransaction((String)package.ModifierId$.MODULE$.$at$at((Object)transactionId, package.Tagger$.MODULE$.baseRaw())).orNull(Predef$.MODULE$.$conforms()));
    }

    public AccountMemoryPool updateMemPool(Seq<AccountBlock> removedBlocks, Seq<AccountBlock> appliedBlocks) {
        Iterable<AccountTransaction<Proposition, Proof<Proposition>>> newExecTcs = this.unconfirmed.updateMemPool(removedBlocks, appliedBlocks);
        if (newExecTcs.nonEmpty()) {
            this.eventNotifierProvider.getEventNotifier().sendNewExecTxsEvent(newExecTcs);
        }
        return new AccountMemoryPool(this.unconfirmed, this.accountStateReaderProvider, this.baseStateReaderProvider, this.mempoolSettings, this.eventNotifierProvider);
    }

    public static final /* synthetic */ boolean $anonfun$filter$2(AccountTransaction t$1, AccountTransaction x$1) {
        String string = x$1.id();
        String string2 = t$1.id();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$filter$1(Seq txs$1, AccountTransaction t) {
        return !txs$1.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AccountMemoryPool.$anonfun$filter$2(t, x$1)));
    }

    public static final /* synthetic */ boolean $anonfun$filter$3(Function1 condition$1, AccountTransaction tx) {
        return BoxesRunTime.unboxToBoolean((Object)condition$1.apply((Object)tx));
    }

    public AccountMemoryPool(MempoolMap unconfirmed, AccountStateReaderProvider accountStateReaderProvider, BaseStateReaderProvider baseStateReaderProvider, AccountMempoolSettings mempoolSettings, AccountEventNotifierProvider eventNotifierProvider) {
        this.unconfirmed = unconfirmed;
        this.accountStateReaderProvider = accountStateReaderProvider;
        this.baseStateReaderProvider = baseStateReaderProvider;
        this.mempoolSettings = mempoolSettings;
        this.eventNotifierProvider = eventNotifierProvider;
        ContainsModifiers.$init$((ContainsModifiers)this);
        MempoolReader.$init$((MempoolReader)this);
        MemoryPool.$init$((MemoryPool)this);
        SidechainTypes.$init$(this);
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
    }
}

