/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.block;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonView;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.account.block.AccountBlock$;
import io.horizen.account.block.AccountBlockHeader;
import io.horizen.account.block.AccountBlockSerializer;
import io.horizen.account.companion.SidechainAccountTransactionsCompanion;
import io.horizen.account.proposition.AddressProposition;
import io.horizen.account.state.receipt.EthereumConsensusDataReceipt;
import io.horizen.account.state.receipt.EthereumReceipt;
import io.horizen.account.transaction.AccountTransaction;
import io.horizen.account.utils.Bloom;
import io.horizen.account.utils.Bloom$;
import io.horizen.block.MainchainBlockReferenceData;
import io.horizen.block.MainchainHeader;
import io.horizen.block.Ommer;
import io.horizen.block.SidechainBlockBase;
import io.horizen.consensus.ForgingStakeInfo;
import io.horizen.evm.TrieHasher;
import io.horizen.history.validation.InconsistentSidechainBlockDataException;
import io.horizen.history.validation.InconsistentSidechainBlockDataException$;
import io.horizen.json.Views;
import io.horizen.proof.Proof;
import io.horizen.proof.Signature25519;
import io.horizen.proof.VrfProof;
import io.horizen.proposition.Proposition;
import io.horizen.secret.PrivateKey25519;
import io.horizen.utils.BytesUtils;
import io.horizen.utils.ListSerializer;
import io.horizen.utils.MerklePath;
import io.horizen.vrf.VrfOutput;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;
import scala.Function1;
import scala.Option;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.util.Try;
import sparkz.util.SparkzLogging;

@JsonView(value={Views.Default.class})
@JsonIgnoreProperties(value={"messageToSign", "transactions", "version", "serializer", "modifierTypeId", "encoder", "companion", "forgerPublicKey", "logger"})
@ScalaSignature(bytes="\u0006\u0001\r=d\u0001B\u0015+\u0001MB\u0001b\u0016\u0001\u0003\u0006\u0004%\t\u0005\u0017\u0005\n3\u0002\u0011\t\u0011)A\u0005\u0017jC\u0001b\u0017\u0001\u0003\u0006\u0004%\t\u0005\u0018\u0005\nW\u0002\u0011\t\u0011)A\u0005;2D\u0001\"\u001c\u0001\u0003\u0006\u0004%\tE\u001c\u0005\ng\u0002\u0011\t\u0011)A\u0005_RD\u0001\"\u001e\u0001\u0003\u0006\u0004%\tE\u001e\u0005\nw\u0002\u0011\t\u0011)A\u0005orD\u0001\" \u0001\u0003\u0006\u0004%\tE \u0005\f\u0003\u000f\u0001!\u0011!Q\u0001\n}\fI\u0001\u0003\u0006\u0002\f\u0001\u0011\t\u0011)A\u0005\u0003\u001bAq!a\u0006\u0001\t\u0003\tI\"\u0002\u0004\u0002*\u0001\u0001\u00131\u0004\u0005\u000b\u0003W\u0001\u0001R1A\u0005B\u00055\u0002\"CA\u001b\u0001!\u0015\r\u0011\"\u0011]\u0011\u001d\t9\u0004\u0001C\u0001\u0003sAq!!\u0012\u0001\t\u0003\n9\u0005C\u0004\u0002l\u0001!\t!!\u001c\t\u000f\u0005\u001d\u0005\u0001\"\u0001\u0002\n\"9\u0011\u0011\u0015\u0001\u0005\u0002\u0005\r\u0006bBA\\\u0001\u0011\u0005\u0011\u0011\u0018\u0005\b\u0003\u0013\u0004A\u0011IAf\u0011\u001d\t\u0019\u000e\u0001C!\u0003+Dq!a6\u0001\t\u0003\nI\u000eC\u0004\u0002f\u0002!\t%a:\t\u000f\u00055\b\u0001\"\u0011\u0002p\u001e9!1\n\u0016\t\u0002\t5cAB\u0015+\u0011\u0003\u0011y\u0005C\u0004\u0002\u0018q!\tA!\u0018\t\u0013\t}CD1A\u0005\u0002\t\u0005\u0004\u0002\u0003B=9\u0001\u0006IAa\u0019\t\u0013\tmDD1A\u0005\u0002\tu\u0004\u0002\u0003BC9\u0001\u0006IAa \t\u0013\t\u001dED1A\u0005\u0002\tu\u0004\u0002\u0003BE9\u0001\u0006IAa \t\u000f\t-E\u0004\"\u0001\u0003\u000e\"I1Q\b\u000f\u0012\u0002\u0013\u00051q\b\u0005\b\u0007'bB\u0011AB+\u0011\u001d\u0019I\u0006\bC\u0001\u00077B\u0011ba\u0018\u001d\u0003\u0003%Ia!\u0019\u0003\u0019\u0005\u001b7m\\;oi\ncwnY6\u000b\u0005-b\u0013!\u00022m_\u000e\\'BA\u0017/\u0003\u001d\t7mY8v]RT!a\f\u0019\u0002\u000f!|'/\u001b>f]*\t\u0011'\u0001\u0002j_\u000e\u00011c\u0001\u00015\u001fB!QgN\u001dL\u001b\u00051$BA\u0016/\u0013\tAdG\u0001\nTS\u0012,7\r[1j]\ncwnY6CCN,\u0007\u0003\u0002\u001e>\u007f\u0015k\u0011a\u000f\u0006\u0003y1\n1\u0002\u001e:b]N\f7\r^5p]&\u0011ah\u000f\u0002\u0013\u0003\u000e\u001cw.\u001e8u)J\fgn]1di&|g\u000e\u0005\u0002A\u00076\t\u0011I\u0003\u0002C]\u0005Y\u0001O]8q_NLG/[8o\u0013\t!\u0015IA\u0006Qe>\u0004xn]5uS>t\u0007c\u0001$J\u007f5\tqI\u0003\u0002I]\u0005)\u0001O]8pM&\u0011!j\u0012\u0002\u0006!J|wN\u001a\t\u0003\u00196k\u0011AK\u0005\u0003\u001d*\u0012!#Q2d_VtGO\u00117pG.DU-\u00193feB\u0011\u0001+V\u0007\u0002#*\u0011!kU\u0001\u0005kRLGNC\u0001U\u0003\u0019\u0019\b/\u0019:lu&\u0011a+\u0015\u0002\u000e'B\f'o\u001b>M_\u001e<\u0017N\\4\u0002\r!,\u0017\rZ3s+\u0005Y\u0015a\u00025fC\u0012,'\u000fI\u0005\u0003/^\nQc]5eK\u000eD\u0017-\u001b8Ue\u0006t7/Y2uS>t7/F\u0001^!\rq\u0006.\u000f\b\u0003?\u0016t!\u0001Y2\u000e\u0003\u0005T!A\u0019\u001a\u0002\rq\u0012xn\u001c;?\u0013\u0005!\u0017!B:dC2\f\u0017B\u00014h\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011\u0001Z\u0005\u0003S*\u00141aU3r\u0015\t1w-\u0001\ftS\u0012,7\r[1j]R\u0013\u0018M\\:bGRLwN\\:!\u0013\tYv'\u0001\u000fnC&t7\r[1j]\ncwnY6SK\u001a,'/\u001a8dKN$\u0015\r^1\u0016\u0003=\u00042A\u00185q!\t)\u0014/\u0003\u0002sm\tYR*Y5oG\"\f\u0017N\u001c\"m_\u000e\\'+\u001a4fe\u0016t7-\u001a#bi\u0006\fQ$\\1j]\u000eD\u0017-\u001b8CY>\u001c7NU3gKJ,gnY3t\t\u0006$\u0018\rI\u0005\u0003[^\n\u0001#\\1j]\u000eD\u0017-\u001b8IK\u0006$WM]:\u0016\u0003]\u00042A\u00185y!\t)\u00140\u0003\u0002{m\tyQ*Y5oG\"\f\u0017N\u001c%fC\u0012,'/A\tnC&t7\r[1j]\"+\u0017\rZ3sg\u0002J!!^\u001c\u0002\r=lW.\u001a:t+\u0005y\b\u0003\u00020i\u0003\u0003\u0001B!NA\u0002\u0017&\u0019\u0011Q\u0001\u001c\u0003\u000b=kW.\u001a:\u0002\u000f=lW.\u001a:tA%\u0011QpN\u0001\nG>l\u0007/\u00198j_:\u0004B!a\u0004\u0002\u00145\u0011\u0011\u0011\u0003\u0006\u0004\u0003\u0017a\u0013\u0002BA\u000b\u0003#\u0011QeU5eK\u000eD\u0017-\u001b8BG\u000e|WO\u001c;Ue\u0006t7/Y2uS>t7oQ8na\u0006t\u0017n\u001c8\u0002\rqJg.\u001b;?)9\tY\"!\b\u0002 \u0005\u0005\u00121EA\u0013\u0003O\u0001\"\u0001\u0014\u0001\t\u000b]c\u0001\u0019A&\t\u000bmc\u0001\u0019A/\t\u000b5d\u0001\u0019A8\t\u000bUd\u0001\u0019A<\t\u000bud\u0001\u0019A@\t\u000f\u0005-A\u00021\u0001\u0002\u000e\t\tQ*\u0001\u0006tKJL\u0017\r\\5{KJ,\"!a\f\u0011\u00071\u000b\t$C\u0002\u00024)\u0012a#Q2d_VtGO\u00117pG.\u001cVM]5bY&TXM]\u0001\riJ\fgn]1di&|gn]\u0001\u0010M>\u0014x-\u001a:Qk\nd\u0017nY&fsV\u0011\u00111\b\t\u0005\u0003{\t\t%\u0004\u0002\u0002@)\u0011!\tL\u0005\u0005\u0003\u0007\nyD\u0001\nBI\u0012\u0014Xm]:Qe>\u0004xn]5uS>t\u0017!\t<fe&4\u0017\u0010\u0016:b]N\f7\r^5p]N$\u0015\r^1D_:\u001c\u0018n\u001d;f]\u000eLHCAA%!\u0011\tY%!\u0014\u000e\u0003\u001dL1!a\u0014h\u0005\u0011)f.\u001b;)\u000bE\t\u0019&!\u001b\u0011\r\u0005-\u0013QKA-\u0013\r\t9f\u001a\u0002\u0007i\"\u0014xn^:\u0011\t\u0005m\u0013QM\u0007\u0003\u0003;RA!a\u0018\u0002b\u0005Qa/\u00197jI\u0006$\u0018n\u001c8\u000b\u0007\u0005\rd&A\u0004iSN$xN]=\n\t\u0005\u001d\u0014Q\f\u0002(\u0013:\u001cwN\\:jgR,g\u000e^*jI\u0016\u001c\u0007.Y5o\u00052|7m\u001b#bi\u0006,\u0005pY3qi&|gn\t\u0002\u0002Z\u0005ab/\u001a:jMf\u0014VmY3jaR$\u0015\r^1D_:\u001c\u0018n\u001d;f]\u000eLH\u0003BA%\u0003_Bq!!\u001d\u0013\u0001\u0004\t\u0019(A\u0006sK\u000e,\u0017\u000e\u001d;MSN$\b\u0003\u00020i\u0003k\u0002B!a\u001e\u0002\u00026\u0011\u0011\u0011\u0010\u0006\u0005\u0003w\ni(A\u0004sK\u000e,\u0017\u000e\u001d;\u000b\u0007\u0005}D&A\u0003ti\u0006$X-\u0003\u0003\u0002\u0004\u0006e$\u0001H#uQ\u0016\u0014X-^7D_:\u001cXM\\:vg\u0012\u000bG/\u0019*fG\u0016L\u0007\u000f\u001e\u0015\u0006%\u0005M\u0013\u0011N\u0001\u0019m\u0016\u0014\u0018NZ=HCN,6/\u001a3D_:\u001c\u0018n\u001d;f]\u000eLH\u0003BA%\u0003\u0017Cq!!$\u0014\u0001\u0004\ty)A\bfqB,7\r^3e\u000f\u0006\u001cXk]3e!\u0011\t\t*a'\u000e\u0005\u0005M%\u0002BAK\u0003/\u000bA!\\1uQ*\u0011\u0011\u0011T\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u001e\u0006M%A\u0003\"jO&sG/Z4fe\"*1#a\u0015\u0002j\u0005qb/\u001a:jMf\u001cF/\u0019;f%>|G\u000fR1uC\u000e{gn]5ti\u0016t7-\u001f\u000b\u0005\u0003\u0013\n)\u000bC\u0004\u0002(R\u0001\r!!+\u0002\u0013M$\u0018\r^3S_>$\bCBA&\u0003W\u000by+C\u0002\u0002.\u001e\u0014Q!\u0011:sCf\u0004B!a\u0013\u00022&\u0019\u00111W4\u0003\t\tKH/\u001a\u0015\u0006)\u0005M\u0013\u0011N\u0001\u001bm\u0016\u0014\u0018NZ=M_\u001e\u001c(\t\\8p[\u000e{gn]5ti\u0016t7-\u001f\u000b\u0005\u0003\u0013\nY\fC\u0004\u0002>V\u0001\r!a0\u0002\u0011I,7-Z5qiN\u0004BA\u00185\u0002BB!\u0011qOAb\u0013\u0011\t)-!\u001f\u0003\u001f\u0015#\b.\u001a:fk6\u0014VmY3jaRDS!FA*\u0003S\naB^3sg&|g.S:WC2LG\r\u0006\u0002\u0002NB!\u00111JAh\u0013\r\t\tn\u001a\u0002\b\u0005>|G.Z1o\u0003\u0001\"(/\u00198tC\u000e$\u0018n\u001c8t\u0019&\u001cH/\u0012=dK\u0016$7oU5{K2KW.\u001b;\u0016\u0005\u00055\u0017!\u00062m_\u000e\\W\t_2fK\u0012\u001c8+\u001b>f\u0019&l\u0017\u000e\u001e\u000b\u0005\u0003\u001b\fY\u000eC\u0004\u0002^b\u0001\r!a8\u0002\u0013\tdwnY6TSj,\u0007\u0003BA&\u0003CL1!a9h\u0005\u0011auN\\4\u0002;\tdwnY6Fq\u000e,W\rZ:Pm\u0016\u0014\b.Z1e'&TX\rT5nSR$B!!4\u0002j\"9\u00111^\rA\u0002\u0005}\u0017!\u00052m_\u000e\\wJ^3sQ\u0016\fGmU5{K\u0006Y!\r\\8dWRC8+\u001b>f)\t\ty\u000eK\u0004\u0001\u0003g\u0014YA!\u0004\u0011\t\u0005U(qA\u0007\u0003\u0003oTA!!?\u0002|\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\t\u0005u\u0018q`\u0001\bU\u0006\u001c7n]8o\u0015\u0011\u0011\tAa\u0001\u0002\u0013\u0019\f7\u000f^3sq6d'B\u0001B\u0003\u0003\r\u0019w.\\\u0005\u0005\u0005\u0013\t9P\u0001\u000bKg>t\u0017j\u001a8pe\u0016\u0004&o\u001c9feRLWm]\u0001\u0006m\u0006dW/\u001a\u0017\u0013\u0005\u001f\u0011\u0019B!\u0006\u0003\u001a\tm!q\u0004B\u0012\u0005K\u00119#\t\u0002\u0003\u0012\u0005iQ.Z:tC\u001e,Gk\\*jO:\f#!!\u000e\"\u0005\t]\u0011a\u0002<feNLwN\\\u0011\u0003\u0003W\t#A!\b\u0002\u001d5|G-\u001b4jKJ$\u0016\u0010]3JI\u0006\u0012!\u0011E\u0001\bK:\u001cw\u000eZ3sC\t\tY!\t\u0002\u00028\u0005\u0012!\u0011F\u0001\u0007Y><w-\u001a:)\u000f\u0001\u0011iCa\u0003\u00034A!\u0011Q\u001fB\u0018\u0013\u0011\u0011\t$a>\u0003\u0011)\u001bxN\u001c,jK^d#A!\u000e$\u0005\t]\u0002\u0003\u0002B\u001d\u0005\u000brAAa\u000f\u0003B5\u0011!Q\b\u0006\u0004\u0005\u007fq\u0013\u0001\u00026t_:LAAa\u0011\u0003>\u0005)a+[3xg&!!q\tB%\u0005\u001d!UMZ1vYRTAAa\u0011\u0003>\u0005a\u0011iY2pk:$(\t\\8dWB\u0011A\nH\n\u00069\tE#q\u000b\t\u0005\u0003\u0017\u0012\u0019&C\u0002\u0003V\u001d\u0014a!\u00118z%\u00164\u0007\u0003BA&\u00053J1Aa\u0017h\u00051\u0019VM]5bY&T\u0018M\u00197f)\t\u0011i%A\u000bB\u0007\u000e{UK\u0014+`\u00052{5iS0W\u000bJ\u001b\u0016j\u0014(\u0016\u0005\t\r\u0004\u0003\u0002B3\u0005grAAa\u001a\u0003p5\u0011!\u0011\u000e\u0006\u0004W\t-$b\u0001B7'\u0006!1m\u001c:f\u0013\u0011\u0011\tH!\u001b\u0002\u000b\tcwnY6\n\t\tU$q\u000f\u0002\b-\u0016\u00148/[8o\u0015\u0011\u0011\tH!\u001b\u0002-\u0005\u001b5iT+O)~\u0013EjT\"L?Z+%kU%P\u001d\u0002\nq$T!Y?\u0006\u001b5iT+O)~\u0013EjT\"L?>3VI\u0015%F\u0003\u0012{6+\u0013.F+\t\u0011y\b\u0005\u0003\u0002L\t\u0005\u0015b\u0001BBO\n\u0019\u0011J\u001c;\u0002A5\u000b\u0005lX!D\u0007>+f\nV0C\u0019>\u001b5jX(W\u000bJCU)\u0011#`'&SV\tI\u0001\u0017\u001b\u0006Cv,Q\"D\u001fVsEk\u0018\"M\u001f\u000e[ulU%[\u000b\u00069R*\u0011-`\u0003\u000e\u001bu*\u0016(U?\ncujQ&`'&SV\tI\u0001\u0007GJ,\u0017\r^3\u0015]\t=%\u0011\u0014BR\u0005O\u0013\tLa-\u00036\n]&\u0011\u0018Be\u00053\u0014\u0019Oa=\u0004\u0004\r\u001d1\u0011BB\u0007\u0007#\u0019)b!\u0007\u0004\u001e\r}1Q\u0006\t\u0007\u0005#\u0013)*a\u0007\u000e\u0005\tM%B\u0001*h\u0013\u0011\u00119Ja%\u0003\u0007Q\u0013\u0018\u0010C\u0004\u0003\u001c\u0012\u0002\rA!(\u0002\u0011A\f'/\u001a8u\u0013\u0012\u0004BA!\u001a\u0003 &!!\u0011\u0015B<\u0005\u001d\u0011En\\2l\u0013\u0012DqA!*%\u0001\u0004\u0011\u0019'\u0001\u0007cY>\u001c7NV3sg&|g\u000eC\u0004\u0003*\u0012\u0002\rAa+\u0002\u0013QLW.Z:uC6\u0004\b\u0003\u0002B3\u0005[KAAa,\u0003x\tIA+[7fgR\fW\u000e\u001d\u0005\u0006[\u0012\u0002\ra\u001c\u0005\u00067\u0012\u0002\r!\u0018\u0005\u0006k\u0012\u0002\ra\u001e\u0005\u0006{\u0012\u0002\ra \u0005\b\u0005w#\u0003\u0019\u0001B_\u0003=ywO\\3s!JLg/\u0019;f\u0017\u0016L\b\u0003\u0002B`\u0005\u000bl!A!1\u000b\u0007\t\rg&\u0001\u0004tK\u000e\u0014X\r^\u0005\u0005\u0005\u000f\u0014\tMA\bQe&4\u0018\r^3LKf\u0014T'N\u0019:\u0011\u001d\u0011Y\r\na\u0001\u0005\u001b\f\u0001CZ8sO&twm\u0015;bW\u0016LeNZ8\u0011\t\t='Q[\u0007\u0003\u0005#T1Aa5/\u0003%\u0019wN\\:f]N,8/\u0003\u0003\u0003X\nE'\u0001\u0005$pe\u001eLgnZ*uC.,\u0017J\u001c4p\u0011\u001d\u0011Y\u000e\na\u0001\u0005;\f\u0001B\u001e:g!J|wN\u001a\t\u0004\r\n}\u0017b\u0001Bq\u000f\nAaK\u001d4Qe>|g\rC\u0004\u0003f\u0012\u0002\rAa:\u0002\u0013Y\u0014hmT;uaV$\b\u0003\u0002Bu\u0005_l!Aa;\u000b\u0007\t5h&A\u0002we\u001aLAA!=\u0003l\nIaK\u001d4PkR\u0004X\u000f\u001e\u0005\b\u0005k$\u0003\u0019\u0001B|\u0003i1wN]4j]\u001e\u001cF/Y6f\u0013:4w.T3sW2,\u0007+\u0019;i!\u0011\u0011IPa@\u000e\u0005\tm(b\u0001B\u007f]\u0005)Q\u000f^5mg&!1\u0011\u0001B~\u0005)iUM]6mKB\u000bG\u000f\u001b\u0005\b\u0007\u000b!\u0003\u0019AAU\u0003=1W-\u001a)bs6,g\u000e^:ICND\u0007bBATI\u0001\u0007\u0011\u0011\u0016\u0005\b\u0007\u0017!\u0003\u0019AAU\u00031\u0011XmY3jaR\u001c(k\\8u\u0011\u001d\u0019y\u0001\na\u0001\u0003w\tQBZ8sO\u0016\u0014\u0018\t\u001a3sKN\u001c\bbBB\nI\u0001\u0007\u0011qR\u0001\bE\u0006\u001cXMR3f\u0011\u001d\u00199\u0002\na\u0001\u0003\u001f\u000bqaZ1t+N,G\rC\u0004\u0004\u001c\u0011\u0002\r!a$\u0002\u0011\u001d\f7\u000fT5nSRDq!a\u0003%\u0001\u0004\ti\u0001C\u0004\u0004\"\u0011\u0002\raa\t\u0002\u00131|wm\u001d\"m_>l\u0007\u0003BB\u0013\u0007Si!aa\n\u000b\u0007\tuH&\u0003\u0003\u0004,\r\u001d\"!\u0002\"m_>l\u0007\"CB\u0018IA\u0005\t\u0019AB\u0019\u0003=\u0019\u0018n\u001a8biV\u0014Xm\u00149uS>t\u0007CBA&\u0007g\u00199$C\u0002\u00046\u001d\u0014aa\u00149uS>t\u0007c\u0001$\u0004:%\u001911H$\u0003\u001dMKwM\\1ukJ,''N\u001b2s\u0005\t2M]3bi\u0016$C-\u001a4bk2$HE\r\u001a\u0016\u0005\r\u0005#\u0006BB\u0019\u0007\u0007Z#a!\u0012\u0011\t\r\u001d3qJ\u0007\u0003\u0007\u0013RAaa\u0013\u0004N\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003s<\u0017\u0002BB)\u0007\u0013\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003\r\u001a\u0017\r\\2vY\u0006$X\r\u0016:b]N\f7\r^5p]NlUM]6mKJ{w\u000e\u001e%bg\"$B!!+\u0004X!)1L\na\u0001;\u0006!2-\u00197dk2\fG/\u001a*fG\u0016L\u0007\u000f\u001e*p_R$B!!+\u0004^!9\u0011\u0011O\u0014A\u0002\u0005M\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"aa\u0019\u0011\t\r\u001541N\u0007\u0003\u0007ORAa!\u001b\u0002\u0018\u0006!A.\u00198h\u0013\u0011\u0019iga\u001a\u0003\r=\u0013'.Z2u\u0001")
public class AccountBlock
extends SidechainBlockBase<AccountTransaction<Proposition, Proof<Proposition>>, AccountBlockHeader>
implements SparkzLogging {
    private AccountBlockSerializer serializer;
    private Seq<AccountTransaction<Proposition, Proof<Proposition>>> transactions;
    private final SidechainAccountTransactionsCompanion companion;
    private final Logger logger;
    private volatile byte bitmap$0;

    public static byte[] calculateReceiptRoot(Seq<EthereumConsensusDataReceipt> seq) {
        return AccountBlock$.MODULE$.calculateReceiptRoot(seq);
    }

    public static byte[] calculateTransactionsMerkleRootHash(Seq<AccountTransaction<Proposition, Proof<Proposition>>> seq) {
        return AccountBlock$.MODULE$.calculateTransactionsMerkleRootHash(seq);
    }

    public static Option<Signature25519> create$default$22() {
        return AccountBlock$.MODULE$.create$default$22();
    }

    public static Try<AccountBlock> create(String string, byte by, long l, Seq<MainchainBlockReferenceData> seq, Seq<AccountTransaction<Proposition, Proof<Proposition>>> seq2, Seq<MainchainHeader> seq3, Seq<Ommer<AccountBlockHeader>> seq4, PrivateKey25519 privateKey25519, ForgingStakeInfo forgingStakeInfo, VrfProof vrfProof, VrfOutput vrfOutput, MerklePath merklePath, byte[] byArray, byte[] byArray2, byte[] byArray3, AddressProposition addressProposition, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, SidechainAccountTransactionsCompanion sidechainAccountTransactionsCompanion, Bloom bloom, Option<Signature25519> option) {
        return AccountBlock$.MODULE$.create(string, by, l, seq, seq2, seq3, seq4, privateKey25519, forgingStakeInfo, vrfProof, vrfOutput, merklePath, byArray, byArray2, byArray3, addressProposition, bigInteger, bigInteger2, bigInteger3, sidechainAccountTransactionsCompanion, bloom, option);
    }

    public static int MAX_ACCOUNT_BLOCK_SIZE() {
        return AccountBlock$.MODULE$.MAX_ACCOUNT_BLOCK_SIZE();
    }

    public static int MAX_ACCOUNT_BLOCK_OVERHEAD_SIZE() {
        return AccountBlock$.MODULE$.MAX_ACCOUNT_BLOCK_OVERHEAD_SIZE();
    }

    public static byte ACCOUNT_BLOCK_VERSION() {
        return AccountBlock$.MODULE$.ACCOUNT_BLOCK_VERSION();
    }

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public AccountBlockHeader header() {
        return (AccountBlockHeader)super.header();
    }

    @Override
    public Seq<AccountTransaction<Proposition, Proof<Proposition>>> sidechainTransactions() {
        return super.sidechainTransactions();
    }

    @Override
    public Seq<MainchainBlockReferenceData> mainchainBlockReferencesData() {
        return super.mainchainBlockReferencesData();
    }

    @Override
    public Seq<MainchainHeader> mainchainHeaders() {
        return super.mainchainHeaders();
    }

    @Override
    public Seq<Ommer<AccountBlockHeader>> ommers() {
        return super.ommers();
    }

    private AccountBlockSerializer serializer$lzycompute() {
        AccountBlock accountBlock = this;
        synchronized (accountBlock) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.serializer = new AccountBlockSerializer(this.companion);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.serializer;
    }

    public AccountBlockSerializer serializer() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.serializer$lzycompute() : this.serializer;
    }

    private Seq<AccountTransaction<Proposition, Proof<Proposition>>> transactions$lzycompute() {
        AccountBlock accountBlock = this;
        synchronized (accountBlock) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.transactions = this.sidechainTransactions();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.transactions;
    }

    public Seq<AccountTransaction<Proposition, Proof<Proposition>>> transactions() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.transactions$lzycompute() : this.transactions;
    }

    public AddressProposition forgerPublicKey() {
        return this.header().forgerAddress();
    }

    @Override
    public void verifyTransactionsDataConsistency() throws InconsistentSidechainBlockDataException {
        byte[] txRootHash = TrieHasher.Root((byte[][])((byte[][])((TraversableOnce)this.sidechainTransactions().map((Function1 & Serializable & scala.Serializable)tx -> tx.bytes(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))))).toBytes();
        if (!Arrays.equals(txRootHash, this.header().sidechainTransactionsMerkleRootHash())) {
            BoxedUnit boxedUnit;
            String reason = new StringBuilder(49).append("Invalid transaction root hash: actual ").append(BytesUtils.toHexString(this.header().sidechainTransactionsMerkleRootHash())).append(", expected ").append(BytesUtils.toHexString(txRootHash)).toString();
            if (this.log().underlying().isErrorEnabled()) {
                this.log().underlying().error(reason);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            throw new InconsistentSidechainBlockDataException(reason, InconsistentSidechainBlockDataException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    public void verifyReceiptDataConsistency(Seq<EthereumConsensusDataReceipt> receiptList) throws InconsistentSidechainBlockDataException {
        byte[] receiptRootHash = AccountBlock$.MODULE$.calculateReceiptRoot(receiptList);
        if (!Arrays.equals(receiptRootHash, this.header().receiptsRoot())) {
            BoxedUnit boxedUnit;
            String reason = new StringBuilder(46).append("Invalid receipts root hash: actual ").append(BytesUtils.toHexString(this.header().receiptsRoot())).append(", expected ").append(BytesUtils.toHexString(receiptRootHash)).toString();
            if (this.log().underlying().isErrorEnabled()) {
                this.log().underlying().error(reason);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            throw new InconsistentSidechainBlockDataException(reason, InconsistentSidechainBlockDataException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    public void verifyGasUsedConsistency(BigInteger expectedGasUsed) throws InconsistentSidechainBlockDataException {
        if (!expectedGasUsed.equals(this.header().gasUsed())) {
            BoxedUnit boxedUnit;
            String reason = new StringBuilder(36).append("Invalid gas used: actual ").append(this.header().gasUsed()).append(", expected ").append(expectedGasUsed).toString();
            if (this.log().underlying().isErrorEnabled()) {
                this.log().underlying().error(reason);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            throw new InconsistentSidechainBlockDataException(reason, InconsistentSidechainBlockDataException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    public void verifyStateRootDataConsistency(byte[] stateRoot) throws InconsistentSidechainBlockDataException {
        if (!Arrays.equals(stateRoot, this.header().stateRoot())) {
            BoxedUnit boxedUnit;
            String reason = new StringBuilder(43).append("Invalid state root hash: actual ").append(BytesUtils.toHexString(this.header().stateRoot())).append(", expected ").append(BytesUtils.toHexString(stateRoot)).toString();
            if (this.log().underlying().isErrorEnabled()) {
                this.log().underlying().error(reason);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            throw new InconsistentSidechainBlockDataException(reason, InconsistentSidechainBlockDataException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    public void verifyLogsBloomConsistency(Seq<EthereumReceipt> receipts) throws InconsistentSidechainBlockDataException {
        Bloom logsBloom = Bloom$.MODULE$.fromReceipts((Seq<EthereumConsensusDataReceipt>)((Seq)receipts.map((Function1 & Serializable & scala.Serializable)r -> r.consensusDataReceipt(), Seq$.MODULE$.canBuildFrom())));
        if (!logsBloom.equals(this.header().logsBloom())) {
            BoxedUnit boxedUnit;
            String reason = "Invalid logs bloom";
            if (this.log().underlying().isErrorEnabled()) {
                this.log().underlying().error(reason);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            throw new InconsistentSidechainBlockDataException(reason, InconsistentSidechainBlockDataException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    @Override
    public boolean versionIsValid() {
        return this.version() == AccountBlock$.MODULE$.ACCOUNT_BLOCK_VERSION();
    }

    @Override
    public boolean transactionsListExceedsSizeLimit() {
        return false;
    }

    @Override
    public boolean blockExceedsSizeLimit(long blockSize) {
        return blockSize > (long)AccountBlock$.MODULE$.MAX_ACCOUNT_BLOCK_SIZE();
    }

    @Override
    public boolean blockExceedsOverheadSizeLimit(long blockOverheadSize) {
        return blockOverheadSize > (long)AccountBlock$.MODULE$.MAX_ACCOUNT_BLOCK_OVERHEAD_SIZE();
    }

    @Override
    public long blockTxSize() {
        return new ListSerializer<AccountTransaction<Proposition, Proof<Proposition>>>(this.companion).toBytes(JavaConverters$.MODULE$.seqAsJavaListConverter(this.sidechainTransactions()).asJava()).length;
    }

    public AccountBlock(AccountBlockHeader header, Seq<AccountTransaction<Proposition, Proof<Proposition>>> sidechainTransactions, Seq<MainchainBlockReferenceData> mainchainBlockReferencesData, Seq<MainchainHeader> mainchainHeaders, Seq<Ommer<AccountBlockHeader>> ommers, SidechainAccountTransactionsCompanion companion) {
        this.companion = companion;
        super(header, sidechainTransactions, mainchainBlockReferencesData, mainchainHeaders, ommers);
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
    }
}

