/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.abi;

import java.util.List;
import org.web3j.abi.DefaultFunctionReturnDecoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.DynamicArray;
import org.web3j.abi.datatypes.DynamicBytes;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.Utf8String;
import org.web3j.utils.Numeric;

public interface ABIDecoder<T> {
    public static final int DO_NOT_CHECK_DYNAMIC_SIZE = -1;

    public List<TypeReference<Type>> getListOfABIParamTypes();

    default public int getABIDataParamsStaticLengthInBytes() {
        return 32 * this.getListOfABIParamTypes().size();
    }

    default public int getABIDataParamsDynamicLengthInBytes() {
        return -1;
    }

    default public boolean areAllArgumentsFixedLength() throws ClassNotFoundException {
        List<TypeReference<Type>> paramsTypes = this.getListOfABIParamTypes();
        for (TypeReference<Type> t : paramsTypes) {
            Class classType = t.getClassType();
            if (!this.isDynamicType(classType)) continue;
            return false;
        }
        return true;
    }

    default public boolean isDynamicType(Class<Type> classType) {
        return DynamicArray.class.isAssignableFrom(classType) || DynamicBytes.class.isAssignableFrom(classType) || Utf8String.class.isAssignableFrom(classType);
    }

    default public T decode(byte[] abiEncodedData) throws ClassNotFoundException {
        if (this.areAllArgumentsFixedLength()) {
            if (abiEncodedData.length != this.getABIDataParamsStaticLengthInBytes()) {
                throw new IllegalArgumentException("Wrong message data field length: " + abiEncodedData.length + ", expected: " + this.getABIDataParamsStaticLengthInBytes());
            }
        } else {
            int dynamicLength = this.getABIDataParamsDynamicLengthInBytes();
            if (dynamicLength != -1 && abiEncodedData.length != dynamicLength) {
                throw new IllegalArgumentException("Wrong message data field length: " + abiEncodedData.length + ", expected: " + dynamicLength);
            }
        }
        String inputParamsString = Numeric.toHexString((byte[])abiEncodedData);
        DefaultFunctionReturnDecoder decoder = new DefaultFunctionReturnDecoder();
        List listOfParams = decoder.decodeFunctionResult(inputParamsString, this.getListOfABIParamTypes());
        return this.createType(listOfParams);
    }

    public T createType(List<Type> var1);
}

