/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account;

import io.horizen.AbstractSidechainNodeViewHolder;
import io.horizen.SidechainSettings;
import io.horizen.account.block.AccountBlock;
import io.horizen.account.block.AccountBlockHeader;
import io.horizen.account.chain.AccountFeePaymentsInfo;
import io.horizen.account.history.AccountHistory;
import io.horizen.account.history.AccountHistory$;
import io.horizen.account.history.validation.BaseFeeBlockValidator;
import io.horizen.account.history.validation.ChainIdBlockSemanticValidator;
import io.horizen.account.mempool.AccountMemoryPool;
import io.horizen.account.mempool.AccountMemoryPool$;
import io.horizen.account.node.AccountNodeView;
import io.horizen.account.node.NodeAccountHistory;
import io.horizen.account.node.NodeAccountMemoryPool;
import io.horizen.account.node.NodeAccountState;
import io.horizen.account.state.AccountEventNotifier;
import io.horizen.account.state.AccountState;
import io.horizen.account.state.AccountState$;
import io.horizen.account.state.AccountStateReader;
import io.horizen.account.state.MessageProcessor;
import io.horizen.account.state.MessageProcessorUtil$;
import io.horizen.account.storage.AccountHistoryStorage;
import io.horizen.account.storage.AccountStateMetadataStorage;
import io.horizen.account.transaction.AccountTransaction;
import io.horizen.account.transaction.EthereumTransaction;
import io.horizen.account.utils.AccountPayment;
import io.horizen.account.wallet.AccountWallet;
import io.horizen.account.wallet.AccountWallet$;
import io.horizen.consensus.ConsensusDataStorage;
import io.horizen.consensus.ConsensusEpochInfo;
import io.horizen.consensus.StakeConsensusEpochInfo;
import io.horizen.evm.Database;
import io.horizen.history.AbstractHistory;
import io.horizen.history.validation.HistoryBlockValidator;
import io.horizen.history.validation.SemanticBlockValidator;
import io.horizen.node.NodeWalletBase;
import io.horizen.params.NetworkParams;
import io.horizen.proof.Proof;
import io.horizen.proposition.Proposition;
import io.horizen.state.BaseStateReader;
import io.horizen.storage.AbstractHistoryStorage;
import io.horizen.storage.SidechainSecretStorage;
import io.horizen.storage.SidechainStorageInfo;
import io.horizen.utils.ByteArrayWrapper;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import sparkz.core.network.NodeViewSynchronizer;
import sparkz.core.package$;
import sparkz.core.utils.NetworkTimeProvider;

@ScalaSignature(bytes="\u0006\u0001\r-e\u0001B\u001d;\u0001\u0005C\u0001b\u001a\u0001\u0003\u0002\u0003\u0006I\u0001\u001b\u0005\tW\u0002\u0011\t\u0011)A\u0005Y\"A\u0011\u000f\u0001B\u0001B\u0003%!\u000f\u0003\u0005}\u0001\t\u0005\t\u0015!\u0003~\u0011)\t9\u0001\u0001B\u0001B\u0003%\u0011\u0011\u0002\u0005\u000b\u0003+\u0001!\u0011!Q\u0001\n\u0005]\u0001BCA\u000f\u0001\t\u0005\t\u0015!\u0003\u0002 !Q\u00111\u0006\u0001\u0003\u0002\u0003\u0006I!!\f\t\u0015\u0005=\u0003A!A!\u0002\u0013\t\t\u0006C\u0005\u0002\\\u0001\u0011\t\u0011)A\u0005=\"9\u0011Q\f\u0001\u0005\u0002\u0005}S!BA=\u0001\u0001jXABA>\u0001\u0001\ni(\u0002\u0004\u0002\n\u0002\u0001\u00131R\u0003\u0007\u0003#\u0003\u0001%a%\u0006\r\u0005}\u0005\u0001IAQ\u000b\u0019\ti\u000b\u0001\u0011\u00020\u00161\u00111\u0018\u0001!\u0003{Cq!!3\u0001\t#\tY\rC\u0004\u0002P\u0002!\t%!5\t\u000f\u0005\u0015\b\u0001\"\u0011\u0002h\"9\u00111\u001f\u0001\u0005B\u0005U\bb\u0002B\u0005\u0001\u0011\u0005#1\u0002\u0005\b\u00057\u0001A\u0011\u000bB\u000f\u0011\u001d\u0011y\u0002\u0001C\u0005\u0005CAqAa\u0010\u0001\t\u0003\u0012\t\u0005C\u0004\u0003L\u0001!\tE!\u0014\t\u000f\t}\u0003\u0001\"\u0015\u0003b!Q!1\r\u0001\t\u0006\u0004%\tE!\u001a\t\u000f\t=\u0004\u0001\"\u0015\u0003r!9!1\u0011\u0001\u0005R\t\u0015\u0005b\u0002BL\u0001\u0011\u0005#\u0011T\u0004\b\u0005?S\u0004\u0012\u0001BQ\r\u0019I$\b#\u0001\u0003$\"9\u0011Q\f\u0012\u0005\u0002\t-fA\u0002BWE\u0001\u0013y\u000b\u0003\u0006\u0003d\u0012\u0012)\u001a!C\u0001\u0005KD!Ba:%\u0005#\u0005\u000b\u0011\u0002B?\u0011\u001d\ti\u0006\nC\u0001\u0005SD\u0011B!=%\u0003\u0003%\tAa=\t\u0013\t]H%%A\u0005\u0002\te\b\"CB\bI\u0005\u0005I\u0011IB\t\u0011%\u0019\t\u0003JA\u0001\n\u0003\u0019\u0019\u0003C\u0005\u0004&\u0011\n\t\u0011\"\u0001\u0004(!I11\u0007\u0013\u0002\u0002\u0013\u00053Q\u0007\u0005\n\u0007\u0007\"\u0013\u0011!C\u0001\u0007\u000bB\u0011ba\u0014%\u0003\u0003%\te!\u0015\t\u0013\rMC%!A\u0005B\rU\u0003\"CB,I\u0005\u0005I\u0011IB-\u000f%\u0019iFIA\u0001\u0012\u0003\u0019yFB\u0005\u0003.\n\n\t\u0011#\u0001\u0004b!9\u0011QL\u001a\u0005\u0002\r=\u0004\"CB*g\u0005\u0005IQIB+\u0011%\u0019\thMA\u0001\n\u0003\u001b\u0019\bC\u0005\u0004xM\n\t\u0011\"!\u0004z!I1\u0011Q\u001a\u0002\u0002\u0013%11\u0011\u0002\u001f\u0003\u000e\u001cw.\u001e8u'&$Wm\u00195bS:tu\u000eZ3WS\u0016<\bj\u001c7eKJT!a\u000f\u001f\u0002\u000f\u0005\u001c7m\\;oi*\u0011QHP\u0001\bQ>\u0014\u0018N_3o\u0015\u0005y\u0014AA5p\u0007\u0001\u00192\u0001\u0001\"b!\u0015\u0019EI\u0012-_\u001b\u0005a\u0014BA#=\u0005}\t%m\u001d;sC\u000e$8+\u001b3fG\"\f\u0017N\u001c(pI\u00164\u0016.Z<I_2$WM\u001d\t\u0005\u000f*c%+D\u0001I\u0015\tI%(A\u0006ue\u0006t7/Y2uS>t\u0017BA&I\u0005I\t5mY8v]R$&/\u00198tC\u000e$\u0018n\u001c8\u0011\u00055\u0003V\"\u0001(\u000b\u0005=c\u0014a\u00039s_B|7/\u001b;j_:L!!\u0015(\u0003\u0017A\u0013x\u000e]8tSRLwN\u001c\t\u0004'ZcU\"\u0001+\u000b\u0005Uc\u0014!\u00029s_>4\u0017BA,U\u0005\u0015\u0001&o\\8g!\tIF,D\u0001[\u0015\tY&(A\u0003cY>\u001c7.\u0003\u0002^5\n\u0011\u0012iY2pk:$(\t\\8dW\"+\u0017\rZ3s!\tIv,\u0003\u0002a5\na\u0011iY2pk:$(\t\\8dWB\u0011!-Z\u0007\u0002G*\u0011AMO\u0001\u0006gR\fG/Z\u0005\u0003M\u000e\u0014A#Q2d_VtG/\u0012<f]Rtu\u000e^5gS\u0016\u0014\u0018!E:jI\u0016\u001c\u0007.Y5o'\u0016$H/\u001b8hgB\u00111)[\u0005\u0003Ur\u0012\u0011cU5eK\u000eD\u0017-\u001b8TKR$\u0018N\\4t\u0003\u0019\u0001\u0018M]1ngB\u0011Qn\\\u0007\u0002]*\u00111\u000eP\u0005\u0003a:\u0014QBT3uo>\u00148\u000eU1sC6\u001c\u0018\u0001\u0004;j[\u0016\u0004&o\u001c<jI\u0016\u0014\bCA:{\u001b\u0005!(BA;w\u0003\u0015)H/\u001b7t\u0015\t9\b0\u0001\u0003d_J,'\"A=\u0002\rM\u0004\u0018M]6{\u0013\tYHOA\nOKR<xN]6US6,\u0007K]8wS\u0012,'/\u0001\biSN$xN]=Ti>\u0014\u0018mZ3\u0011\u0007y\f\u0019!D\u0001\u0000\u0015\r\t\tAO\u0001\bgR|'/Y4f\u0013\r\t)a \u0002\u0016\u0003\u000e\u001cw.\u001e8u\u0011&\u001cHo\u001c:z'R|'/Y4f\u0003Q\u0019wN\\:f]N,8\u000fR1uCN#xN]1hKB!\u00111BA\t\u001b\t\tiAC\u0002\u0002\u0010q\n\u0011bY8og\u0016t7/^:\n\t\u0005M\u0011Q\u0002\u0002\u0015\u0007>t7/\u001a8tkN$\u0015\r^1Ti>\u0014\u0018mZ3\u0002)M$\u0018\r^3NKR\fG-\u0019;b'R|'/Y4f!\rq\u0018\u0011D\u0005\u0004\u00037y(aG!dG>,h\u000e^*uCR,W*\u001a;bI\u0006$\u0018m\u0015;pe\u0006<W-\u0001\bti\u0006$X\r\u00122Ti>\u0014\u0018mZ3\u0011\t\u0005\u0005\u0012qE\u0007\u0003\u0003GQ1!!\n=\u0003\r)g/\\\u0005\u0005\u0003S\t\u0019C\u0001\u0005ECR\f'-Y:f\u0003]\u0019Wo\u001d;p[6+7o]1hKB\u0013xnY3tg>\u00148\u000f\u0005\u0004\u00020\u0005\r\u0013\u0011\n\b\u0005\u0003c\tiD\u0004\u0003\u00024\u0005eRBAA\u001b\u0015\r\t9\u0004Q\u0001\u0007yI|w\u000e\u001e \n\u0005\u0005m\u0012!B:dC2\f\u0017\u0002BA \u0003\u0003\nq\u0001]1dW\u0006<WM\u0003\u0002\u0002<%!\u0011QIA$\u0005\r\u0019V-\u001d\u0006\u0005\u0003\u007f\t\t\u0005E\u0002c\u0003\u0017J1!!\u0014d\u0005AiUm]:bO\u0016\u0004&o\\2fgN|'/A\u0007tK\u000e\u0014X\r^*u_J\fw-\u001a\t\u0005\u0003'\n9&\u0004\u0002\u0002V)\u0019\u0011\u0011\u0001\u001f\n\t\u0005e\u0013Q\u000b\u0002\u0017'&$Wm\u00195bS:\u001cVm\u0019:fiN#xN]1hK\u0006aq-\u001a8fg&\u001c(\t\\8dW\u00061A(\u001b8jiz\"b#!\u0019\u0002f\u0005\u001d\u0014\u0011NA6\u0003[\ny'!\u001d\u0002t\u0005U\u0014q\u000f\t\u0004\u0003G\u0002Q\"\u0001\u001e\t\u000b\u001d\\\u0001\u0019\u00015\t\u000b-\\\u0001\u0019\u00017\t\u000bE\\\u0001\u0019\u0001:\t\u000bq\\\u0001\u0019A?\t\u000f\u0005\u001d1\u00021\u0001\u0002\n!9\u0011QC\u0006A\u0002\u0005]\u0001bBA\u000f\u0017\u0001\u0007\u0011q\u0004\u0005\b\u0003WY\u0001\u0019AA\u0017\u0011\u001d\tye\u0003a\u0001\u0003#Ba!a\u0017\f\u0001\u0004q&!\u0002%T)>\u0013&a\u0001%J'B!\u0011qPAC\u001b\t\t\tIC\u0002\u0002\u0004j\nq\u0001[5ti>\u0014\u00180\u0003\u0003\u0002\b\u0006\u0005%AD!dG>,h\u000e\u001e%jgR|'/\u001f\u0002\u0003\u001bN\u00032AYAG\u0013\r\tyi\u0019\u0002\r\u0003\u000e\u001cw.\u001e8u'R\fG/\u001a\u0002\u0003-2\u0003B!!&\u0002\u001c6\u0011\u0011q\u0013\u0006\u0004\u00033S\u0014AB<bY2,G/\u0003\u0003\u0002\u001e\u0006]%!D!dG>,h\u000e^,bY2,GO\u0001\u0002N!B!\u00111UAU\u001b\t\t)KC\u0002\u0002(j\nq!\\3na>|G.\u0003\u0003\u0002,\u0006\u0015&!E!dG>,h\u000e^'f[>\u0014\u0018\u0010U8pY\n\u0019a\tU%\u0011\t\u0005E\u0016qW\u0007\u0003\u0003gS1!!.;\u0003\u0015\u0019\u0007.Y5o\u0013\u0011\tI,a-\u0003-\u0005\u001b7m\\;oi\u001a+W\rU1z[\u0016tGo]%oM>\u0014!A\u0014,\u0011\t\u0005}\u0016QY\u0007\u0003\u0003\u0003T1!a1;\u0003\u0011qw\u000eZ3\n\t\u0005\u001d\u0017\u0011\u0019\u0002\u0010\u0003\u000e\u001cw.\u001e8u\u001d>$WMV5fo\u0006\tR.Z:tC\u001e,\u0007K]8dKN\u001cxN]:\u0015\t\u00055\u0012Q\u001a\u0005\u0006WN\u0001\r\u0001\\\u0001\u0018g\u0016l\u0017M\u001c;jG\ncwnY6WC2LG-\u0019;peN$B!a5\u0002dB1\u0011qFA\"\u0003+\u0004R!a6\u0002`zk!!!7\u000b\t\u0005m\u0017Q\\\u0001\u000bm\u0006d\u0017\u000eZ1uS>t'bAABy%!\u0011\u0011]Am\u0005Y\u0019V-\\1oi&\u001c'\t\\8dWZ\u000bG.\u001b3bi>\u0014\b\"B6\u0015\u0001\u0004a\u0017A\u00065jgR|'/\u001f\"m_\u000e\\g+\u00197jI\u0006$xN]:\u0015\t\u0005%\u0018\u0011\u001f\t\u0007\u0003_\t\u0019%a;\u0011\u0019\u0005]\u0017Q\u001e$Y=\u0006=V0! \n\t\u0005=\u0018\u0011\u001c\u0002\u0016\u0011&\u001cHo\u001c:z\u00052|7m\u001b,bY&$\u0017\r^8s\u0011\u0015YW\u00031\u0001m\u0003]\u0019\u0007.Z2l\u0003:$'+Z2pm\u0016\u00148\u000b^8sC\u001e,7\u000f\u0006\u0003\u0002x\n\u0015\u0001CBA}\u0003w\fy0\u0004\u0002\u0002B%!\u0011Q`A!\u0005\u0019y\u0005\u000f^5p]Ba\u0011\u0011 B\u0001\u0003{\nY)a%\u0002\"&!!1AA!\u0005\u0019!V\u000f\u001d7fi!9!q\u0001\fA\u0002\u0005]\u0018\u0001\u0004:fgR|'/\u001a3ECR\f\u0017\u0001\u0004:fgR|'/Z*uCR,GC\u0001B\u0007!\u0019\tI0a?\u0003\u0010Aa\u0011\u0011 B\u0001\u0005#\u0011)Ba\u0006\u0003\u001aA\u0019!1C\u0007\u000e\u0003\u0001\u00012Aa\u0005\u000f!\r\u0011\u0019b\u0004\t\u0004\u0005'\u0001\u0012\u0001D4f]\u0016\u001c\u0018n]*uCR,WC\u0001B\b\u0003E\u0011Gn\\2l\u0011\u0006\u001c\b\u000e\u0015:pm&$WM\u001d\u000b\u0005\u0005G\u0011)\u0004\u0005\u0004\u0002z\u0006m(Q\u0005\t\u0005\u0005O\u0011yC\u0004\u0003\u0003*\t-\u0002\u0003BA\u001a\u0003\u0003JAA!\f\u0002B\u00051\u0001K]3eK\u001aLAA!\r\u00034\t11\u000b\u001e:j]\u001eTAA!\f\u0002B!9!qG\rA\u0002\te\u0012A\u00025fS\u001eDG\u000f\u0005\u0003\u0002z\nm\u0012\u0002\u0002B\u001f\u0003\u0003\u00121!\u00138u\u0003I9W\r\u001e$fKB\u000b\u00170\\3oiNLeNZ8\u0015\r\t\r#Q\tB$!\r\u0011\u0019\"\u0005\u0005\u0007Ij\u0001\rA!\u0006\t\u000f\t%#\u00041\u0001\u0003:\u0005)r/\u001b;iIJ\fw/\u00197Fa>\u001c\u0007NT;nE\u0016\u0014\u0018aF4fiN\u001b\u0017M\u001c)feNL7\u000f^3oi^\u000bG\u000e\\3u))\u00119Ba\u0014\u0003T\te#Q\f\u0005\u0007\u0005#Z\u0002\u0019\u00010\u0002\u00155|G\rV8BaBd\u0017\u0010C\u0004\u0003Vm\u0001\rAa\u0016\u0002\u000fM$\u0018\r^3PaB1\u0011\u0011`A~\u0005+AqAa\u0017\u001c\u0001\u0004\u0011I$A\u0006fa>\u001c\u0007NT;nE\u0016\u0014\bbBAM7\u0001\u0007!qC\u0001\fO\u0016$hj\u001c3f-&,w\u000f\u0006\u0002\u0002>\u0006\tB.[:u\u001f\u001a\u001cFo\u001c:bO\u0016LeNZ8\u0016\u0005\t\u001d\u0004CBA\u0018\u0003\u0007\u0012I\u0007\u0005\u0003\u0002T\t-\u0014\u0002\u0002B7\u0003+\u0012AcU5eK\u000eD\u0017-\u001b8Ti>\u0014\u0018mZ3J]\u001a|\u0017!I1qa2LHj\\2bY2Lx)\u001a8fe\u0006$X\r\u001a+sC:\u001c\u0018m\u0019;j_:\u001cH\u0003\u0002B:\u0005s\u0002B!!?\u0003v%!!qOA!\u0005\u0011)f.\u001b;\t\u000f\tmd\u00041\u0001\u0003~\u00051a.Z<UqN\u0004R!a\f\u0003\u0000\u0019KAA!!\u0002H\tA\u0011\n^3sC\ndW-A\u0007va\u0012\fG/Z'f[B{w\u000e\u001c\u000b\u000b\u00053\u00119I!$\u0003\u0012\nU\u0005b\u0002BE?\u0001\u0007!1R\u0001\u000ee\u0016lwN^3e\u00052|7m[:\u0011\u000b\u0005=\u00121\t0\t\u000f\t=u\u00041\u0001\u0003\f\u0006i\u0011\r\u001d9mS\u0016$'\t\\8dWNDqAa% \u0001\u0004\u0011I\"A\u0004nK6\u0004vn\u001c7\t\r\u0011|\u0002\u0019\u0001B\u000b\u0003M\u0019XM\u001c3OK^,\u00050Z2UqN,e/\u001a8u)\u0011\u0011\u0019Ha'\t\u000f\tu\u0005\u00051\u0001\u0003~\u0005\u0001B.[:u\u001f\u001atUm^#yK\u000e$\u0006p]\u0001\u001f\u0003\u000e\u001cw.\u001e8u'&$Wm\u00195bS:tu\u000eZ3WS\u0016<\bj\u001c7eKJ\u00042!a\u0019#'\r\u0011#Q\u0015\t\u0005\u0003s\u00149+\u0003\u0003\u0003*\u0006\u0005#AB!osJ+g\r\u0006\u0002\u0003\"\nAb*Z<Fq\u0016\u001cGK]1og\u0006\u001cG/[8og\u00163XM\u001c;\u0014\u0013\u0011\u0012)K!-\u0003X\nu\u0007\u0003\u0002BZ\u0005#tAA!.\u0003L:!!q\u0017Bc\u001d\u0011\u0011IL!1\u000f\t\tm&q\u0018\b\u0005\u0003g\u0011i,C\u0001z\u0013\t9\b0C\u0002\u0003DZ\fqA\\3uo>\u00148.\u0003\u0003\u0003H\n%\u0017\u0001\u0006(pI\u00164\u0016.Z<Ts:\u001c\u0007N]8oSj,'OC\u0002\u0003DZLAA!4\u0003P\u0006\u0011\"+Z2fSZ\f'\r\\3NKN\u001c\u0018mZ3t\u0015\u0011\u00119M!3\n\t\tM'Q\u001b\u0002\u0014\u001d>$WMV5fo\"{G\u000eZ3s\u000bZ,g\u000e\u001e\u0006\u0005\u0005\u001b\u0014y\r\u0005\u0003\u0002z\ne\u0017\u0002\u0002Bn\u0003\u0003\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0003\u0002z\n}\u0017\u0002\u0002Bq\u0003\u0003\u0012AbU3sS\u0006d\u0017N_1cY\u0016\f!B\\3x\u000bb,7\r\u0016=t+\t\u0011i(A\u0006oK^,\u00050Z2UqN\u0004C\u0003\u0002Bv\u0005_\u00042A!<%\u001b\u0005\u0011\u0003b\u0002BrO\u0001\u0007!QP\u0001\u0005G>\u0004\u0018\u0010\u0006\u0003\u0003l\nU\b\"\u0003BrQA\u0005\t\u0019\u0001B?\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"Aa?+\t\tu$Q`\u0016\u0003\u0005\u007f\u0004Ba!\u0001\u0004\f5\u001111\u0001\u0006\u0005\u0007\u000b\u00199!A\u0005v]\u000eDWmY6fI*!1\u0011BA!\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007\u001b\u0019\u0019AA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAB\n!\u0011\u0019)ba\b\u000e\u0005\r]!\u0002BB\r\u00077\tA\u0001\\1oO*\u00111QD\u0001\u0005U\u00064\u0018-\u0003\u0003\u00032\r]\u0011\u0001\u00049s_\u0012,8\r^!sSRLXC\u0001B\u001d\u00039\u0001(o\u001c3vGR,E.Z7f]R$Ba!\u000b\u00040A!\u0011\u0011`B\u0016\u0013\u0011\u0019i#!\u0011\u0003\u0007\u0005s\u0017\u0010C\u0005\u000421\n\t\u00111\u0001\u0003:\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"aa\u000e\u0011\r\re2qHB\u0015\u001b\t\u0019YD\u0003\u0003\u0004>\u0005\u0005\u0013AC2pY2,7\r^5p]&!1\u0011IB\u001e\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\r\u001d3Q\n\t\u0005\u0003s\u001cI%\u0003\u0003\u0004L\u0005\u0005#a\u0002\"p_2,\u0017M\u001c\u0005\n\u0007cq\u0013\u0011!a\u0001\u0007S\t\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0005s\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0007'\ta!Z9vC2\u001cH\u0003BB$\u00077B\u0011b!\r2\u0003\u0003\u0005\ra!\u000b\u000219+w/\u0012=fGR\u0013\u0018M\\:bGRLwN\\:Fm\u0016tG\u000fE\u0002\u0003nN\u001aRaMB2\u0005;\u0004\u0002b!\u001a\u0004l\tu$1^\u0007\u0003\u0007ORAa!\u001b\u0002B\u00059!/\u001e8uS6,\u0017\u0002BB7\u0007O\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c82)\t\u0019y&A\u0003baBd\u0017\u0010\u0006\u0003\u0003l\u000eU\u0004b\u0002Brm\u0001\u0007!QP\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0019Yh! \u0011\r\u0005e\u00181 B?\u0011%\u0019yhNA\u0001\u0002\u0004\u0011Y/A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u00111Q\u0011\t\u0005\u0007+\u00199)\u0003\u0003\u0004\n\u000e]!AB(cU\u0016\u001cG\u000f")
public class AccountSidechainNodeViewHolder
extends AbstractSidechainNodeViewHolder<AccountTransaction<Proposition, Proof<Proposition>>, AccountBlockHeader, AccountBlock>
implements AccountEventNotifier {
    private Seq<SidechainStorageInfo> listOfStorageInfo;
    private final SidechainSettings sidechainSettings;
    private final NetworkParams params;
    private final NetworkTimeProvider timeProvider;
    private final AccountHistoryStorage historyStorage;
    private final ConsensusDataStorage consensusDataStorage;
    private final AccountStateMetadataStorage stateMetadataStorage;
    private final Database stateDbStorage;
    private final Seq<MessageProcessor> customMessageProcessors;
    private final SidechainSecretStorage secretStorage;
    private final AccountBlock genesisBlock;
    private volatile boolean bitmap$0;

    public Seq<MessageProcessor> messageProcessors(NetworkParams params) {
        return MessageProcessorUtil$.MODULE$.getMessageProcessorSeq(params, this.customMessageProcessors);
    }

    @Override
    public Seq<SemanticBlockValidator<AccountBlock>> semanticBlockValidators(NetworkParams params) {
        return (Seq)super.semanticBlockValidators(params).$colon$plus((Object)new ChainIdBlockSemanticValidator(params), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public Seq<HistoryBlockValidator<AccountTransaction<Proposition, Proof<Proposition>>, AccountBlockHeader, AccountBlock, AccountFeePaymentsInfo, AccountHistoryStorage, AccountHistory>> historyBlockValidators(NetworkParams params) {
        return (Seq)super.historyBlockValidators(params).$colon$plus((Object)new BaseFeeBlockValidator(), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public Option<Tuple4<AccountHistory, AccountState, AccountWallet, AccountMemoryPool>> checkAndRecoverStorages(Option<Tuple4<AccountHistory, AccountState, AccountWallet, AccountMemoryPool>> restoredData) {
        return restoredData.flatMap((Function1 & Serializable & scala.Serializable)dataOpt -> {
            Some some;
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            BoxedUnit boxedUnit3;
            this.dumpStorages();
            if (this.log().underlying().isInfoEnabled()) {
                this.log().underlying().info("Checking state consistency...");
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            AccountHistory restoredHistory = (AccountHistory)dataOpt._1();
            AccountState restoredState = (AccountState)dataOpt._2();
            AccountWallet restoredWallet = (AccountWallet)dataOpt._3();
            AccountMemoryPool restoredMempool = (AccountMemoryPool)dataOpt._4();
            String historyVersion = restoredHistory.bestBlockId();
            String checkedStateVersion = sparkz.util.package$.MODULE$.bytesToId(((ByteArrayWrapper)$this.stateMetadataStorage.lastVersionId().get()).data());
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug("history bestBlockId = {}, stateVersion = {}", (Object[])new String[]{historyVersion, checkedStateVersion});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            if (this.log().underlying().isDebugEnabled()) {
                int height_h = restoredHistory.blockInfoById(restoredHistory.bestBlockId()).height();
                int height_s = restoredHistory.blockInfoById(checkedStateVersion).height();
                new StringBuilder(34).append("history height = ").append(height_h).append(", state height = ").append(height_s).toString();
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            String string = historyVersion;
            String string2 = checkedStateVersion;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                BoxedUnit boxedUnit4;
                if (this.log().underlying().isInfoEnabled()) {
                    this.log().underlying().info("state and history storages are consistent");
                    boxedUnit4 = BoxedUnit.UNIT;
                } else {
                    boxedUnit4 = BoxedUnit.UNIT;
                }
                some = new Some((Object)new Tuple4((Object)restoredHistory, (Object)restoredState, (Object)restoredWallet, (Object)restoredMempool));
            } else {
                None$ none$;
                BoxedUnit boxedUnit5;
                if (this.log().underlying().isWarnEnabled()) {
                    this.log().underlying().warn("Inconsistent state and history storages, trying to recover...");
                    boxedUnit5 = BoxedUnit.UNIT;
                } else {
                    boxedUnit5 = BoxedUnit.UNIT;
                }
                Option<Seq<String>> option = restoredHistory.chainBack(checkedStateVersion, (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)blockId -> BoxesRunTime.boxToBoolean((boolean)AccountSidechainNodeViewHolder.$anonfun$checkAndRecoverStorages$2(restoredHistory, blockId)), Integer.MAX_VALUE);
                if (option instanceof Some) {
                    None$ none$2;
                    BoxedUnit boxedUnit6;
                    BoxedUnit boxedUnit7;
                    Some some2 = (Some)option;
                    Seq nonChainSuffix = (Seq)some2.value();
                    if (this.log().underlying().isInfoEnabled()) {
                        this.log().underlying().info("sequence of blocks not in active chain (root included) = {}", new Object[]{nonChainSuffix});
                        boxedUnit7 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit7 = BoxedUnit.UNIT;
                    }
                    String rollbackTo2 = (String)nonChainSuffix.head();
                    ((TraversableLike)nonChainSuffix.tail()).headOption().foreach((Function1 & Serializable & scala.Serializable)childBlock -> {
                        AccountSidechainNodeViewHolder.$anonfun$checkAndRecoverStorages$3(this, restoredHistory, childBlock);
                        return BoxedUnit.UNIT;
                    });
                    if (this.log().underlying().isWarnEnabled()) {
                        this.log().underlying().warn("Inconsistent storage and history, rolling back state to history best block id = {}", new Object[]{rollbackTo2});
                        boxedUnit6 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit6 = BoxedUnit.UNIT;
                    }
                    Try<AccountState> try_ = restoredState.rollbackTo(package$.MODULE$.idToVersion(rollbackTo2));
                    if (try_ instanceof Success) {
                        BoxedUnit boxedUnit8;
                        Success success = (Success)try_;
                        AccountState s = (AccountState)success.value();
                        if (this.log().underlying().isDebugEnabled()) {
                            this.log().underlying().debug("State successfully rolled back");
                            boxedUnit8 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit8 = BoxedUnit.UNIT;
                        }
                        this.dumpStorages();
                        none$2 = new Some((Object)new Tuple4((Object)restoredHistory, (Object)s, (Object)restoredWallet, (Object)restoredMempool));
                    } else if (try_ instanceof Failure) {
                        BoxedUnit boxedUnit9;
                        Failure failure = (Failure)try_;
                        Throwable e = failure.exception();
                        if (this.log().underlying().isErrorEnabled()) {
                            this.log().underlying().error("State roll back failed: ", e);
                            boxedUnit9 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit9 = BoxedUnit.UNIT;
                        }
                        this.context().system().eventStream().publish((Object)NodeViewSynchronizer.ReceivableMessages$.RollbackFailed$.MODULE$);
                        none$2 = None$.MODULE$;
                    } else {
                        throw new MatchError(try_);
                    }
                    none$ = none$2;
                } else if (None$.MODULE$.equals(option)) {
                    BoxedUnit boxedUnit10;
                    if (this.log().underlying().isErrorEnabled()) {
                        this.log().underlying().error("Could not recover storages inconsistency, could not find a rollback point in history");
                        boxedUnit10 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit10 = BoxedUnit.UNIT;
                    }
                    none$ = None$.MODULE$;
                } else {
                    throw new MatchError(option);
                }
                some = none$;
            }
            return some;
        });
    }

    /*
     * WARNING - void declaration
     */
    public Option<Tuple4<AccountHistory, AccountState, AccountWallet, AccountMemoryPool>> restoreState() {
        void var2_2;
        BoxedUnit boxedUnit;
        if (this.log().underlying().isInfoEnabled()) {
            this.log().underlying().info("Restoring persistent state from storage...");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Option restoredData = AccountHistory$.MODULE$.restoreHistory(this.historyStorage, this.consensusDataStorage, this.params, this.semanticBlockValidators(this.params), this.historyBlockValidators(this.params)).flatMap((Function1 & Serializable & scala.Serializable)history -> AccountState$.MODULE$.restoreState($this.stateMetadataStorage, $this.stateDbStorage, this.messageProcessors($this.params), $this.params, $this.timeProvider, height -> this.blockHashProvider(height)).flatMap((Function1 & Serializable & scala.Serializable)state -> AccountWallet$.MODULE$.restoreWallet($this.sidechainSettings.wallet().seed().getBytes(StandardCharsets.UTF_8), $this.secretStorage).flatMap((Function1 & Serializable & scala.Serializable)wallet -> new Some((Object)AccountMemoryPool$.MODULE$.createEmptyMempool(() -> (AccountStateReader)this.minimalState(), () -> (BaseStateReader)this.minimalState(), $this.sidechainSettings.accountMempool(), () -> this)).map((Function1 & Serializable & scala.Serializable)pool -> new Tuple4(history, state, wallet, pool)))));
        Option<Tuple4<AccountHistory, AccountState, AccountWallet, AccountMemoryPool>> result = this.checkAndRecoverStorages((Option<Tuple4<AccountHistory, AccountState, AccountWallet, AccountMemoryPool>>)restoredData);
        return var2_2;
    }

    public Tuple4<AccountHistory, AccountState, AccountWallet, AccountMemoryPool> genesisState() {
        Try result = AccountState$.MODULE$.createGenesisState(this.stateMetadataStorage, this.stateDbStorage, this.messageProcessors(this.params), this.params, this.timeProvider, height -> this.blockHashProvider(height), this.genesisBlock).flatMap((Function1 & Serializable & scala.Serializable)state -> new Success(state.getCurrentConsensusEpochInfo()).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)AccountSidechainNodeViewHolder.$anonfun$genesisState$3(check$ifrefutable$1))).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> {
            ConsensusEpochInfo consensusEpochInfo;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x$1;
                    if (tuple2 == null) break block2;
                    String string = (String)tuple2._1();
                    consensusEpochInfo = (ConsensusEpochInfo)tuple2._2();
                    Option option = ClassTag$.MODULE$.apply(String.class).unapply((Object)string);
                    if (!option.isEmpty() && option.get() != null && consensusEpochInfo != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            ConsensusEpochInfo consensusEpochInfo2 = consensusEpochInfo;
            Try try_ = AccountHistory$.MODULE$.createGenesisHistory($this.historyStorage, $this.consensusDataStorage, $this.params, $this.genesisBlock, this.semanticBlockValidators($this.params), this.historyBlockValidators($this.params), new StakeConsensusEpochInfo(consensusEpochInfo2.forgingStakeInfoTree().rootHash(), consensusEpochInfo2.forgersStake())).flatMap((Function1 & Serializable & scala.Serializable)history -> AccountWallet$.MODULE$.createGenesisWallet($this.sidechainSettings.wallet().seed().getBytes(StandardCharsets.UTF_8), $this.secretStorage).flatMap((Function1 & Serializable & scala.Serializable)wallet -> new Success((Object)AccountMemoryPool$.MODULE$.createEmptyMempool(() -> (AccountStateReader)this.minimalState(), () -> (BaseStateReader)this.minimalState(), $this.sidechainSettings.accountMempool(), () -> this)).map((Function1 & Serializable & scala.Serializable)pool -> new Tuple4(history, state, wallet, pool))));
            return try_;
        }));
        return (Tuple4)result.get();
    }

    private Option<String> blockHashProvider(int height) {
        return ((AbstractHistory)this.history()).blockIdByHeight(height);
    }

    public AccountFeePaymentsInfo getFeePaymentsInfo(AccountState state, int withdrawalEpochNumber) {
        int consensusEpochNumber = ((ConsensusEpochInfo)state.getCurrentConsensusEpochInfo()._2()).epoch();
        Seq<AccountPayment> feePayments = state.getFeePaymentsInfo(withdrawalEpochNumber, consensusEpochNumber, state.getFeePaymentsInfo$default$3());
        return new AccountFeePaymentsInfo(feePayments);
    }

    public AccountWallet getScanPersistentWallet(AccountBlock modToApply, Option<AccountState> stateOp, int epochNumber, AccountWallet wallet) {
        return wallet.scanPersistent(modToApply);
    }

    @Override
    public AccountNodeView getNodeView() {
        return new AccountNodeView((NodeAccountHistory)this.history(), (NodeAccountState)this.minimalState(), (NodeWalletBase)this.vault(), (NodeAccountMemoryPool)this.memoryPool());
    }

    private Seq<SidechainStorageInfo> listOfStorageInfo$lzycompute() {
        AccountSidechainNodeViewHolder accountSidechainNodeViewHolder = this;
        synchronized (accountSidechainNodeViewHolder) {
            if (!this.bitmap$0) {
                this.listOfStorageInfo = (Seq)new .colon.colon((Object)this.historyStorage, (List)new .colon.colon((Object)this.consensusDataStorage, (List)new .colon.colon((Object)this.stateMetadataStorage, (List)new .colon.colon((Object)this.secretStorage, (List)Nil$.MODULE$))));
                this.bitmap$0 = true;
            }
        }
        return this.listOfStorageInfo;
    }

    @Override
    public Seq<SidechainStorageInfo> listOfStorageInfo() {
        return !this.bitmap$0 ? this.listOfStorageInfo$lzycompute() : this.listOfStorageInfo;
    }

    @Override
    public void applyLocallyGeneratedTransactions(Iterable<AccountTransaction<Proposition, Proof<Proposition>>> newTxs) {
        newTxs.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            AccountSidechainNodeViewHolder.$anonfun$applyLocallyGeneratedTransactions$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public AccountMemoryPool updateMemPool(Seq<AccountBlock> removedBlocks, Seq<AccountBlock> appliedBlocks, AccountMemoryPool memPool, AccountState state) {
        return memPool.updateMemPool(removedBlocks, appliedBlocks);
    }

    @Override
    public void sendNewExecTxsEvent(Iterable<AccountTransaction<Proposition, Proof<Proposition>>> listOfNewExecTxs) {
        this.context().system().eventStream().publish((Object)new NewExecTransactionsEvent(listOfNewExecTxs));
    }

    public static final /* synthetic */ boolean $anonfun$checkAndRecoverStorages$2(AccountHistory restoredHistory$1, String blockId) {
        return ((AbstractHistoryStorage)restoredHistory$1.storage()).isInActiveChain(blockId);
    }

    public static final /* synthetic */ void $anonfun$checkAndRecoverStorages$3(AccountSidechainNodeViewHolder $this, AccountHistory restoredHistory$1, String childBlock) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if ($this.log().underlying().isDebugEnabled()) {
            $this.log().underlying().debug("Child {} is in history", new Object[]{childBlock});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if ($this.log().underlying().isDebugEnabled()) {
            $this.log().underlying().debug("Child info {}", new Object[]{restoredHistory$1.blockInfoById(childBlock)});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$genesisState$3(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        if (tuple2 == null) return false;
        String string = (String)tuple2._1();
        ConsensusEpochInfo consensusEpochInfo = (ConsensusEpochInfo)tuple2._2();
        Option option = ClassTag$.MODULE$.apply(String.class).unapply((Object)string);
        if (option.isEmpty()) return false;
        if (option.get() == null) return false;
        if (consensusEpochInfo == null) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$applyLocallyGeneratedTransactions$2(AccountTransaction x$2) {
        return x$2 instanceof EthereumTransaction;
    }

    public static final /* synthetic */ boolean $anonfun$applyLocallyGeneratedTransactions$4(AccountSidechainNodeViewHolder $this, EthereumTransaction ethTx) {
        return !$this.sidechainSettings.accountMempool().allowUnprotectedTxs() && ethTx.isLegacy() && !ethTx.isEIP155();
    }

    public static final /* synthetic */ void $anonfun$applyLocallyGeneratedTransactions$1(AccountSidechainNodeViewHolder $this, AccountTransaction x0$1) {
        AccountTransaction accountTransaction = x0$1;
        if (new Some((Object)accountTransaction).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AccountSidechainNodeViewHolder.$anonfun$applyLocallyGeneratedTransactions$2(x$2))).map((Function1 & Serializable & scala.Serializable)x$3 -> (EthereumTransaction)x$3).exists((Function1 & Serializable & scala.Serializable)ethTx -> BoxesRunTime.boxToBoolean((boolean)AccountSidechainNodeViewHolder.$anonfun$applyLocallyGeneratedTransactions$4($this, ethTx)))) {
            $this.context().system().eventStream().publish((Object)new NodeViewSynchronizer.ReceivableMessages$.FailedTransaction(accountTransaction.id(), (Throwable)new IllegalArgumentException("Legacy unprotected transactions are not allowed."), true));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            if ($this.log().underlying().isInfoEnabled()) {
                $this.log().underlying().info("Got locally generated tx {} of type {}", new Object[]{accountTransaction.id(), BoxesRunTime.boxToByte((byte)accountTransaction.modifierTypeId())});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            $this.txModify(accountTransaction);
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        }
    }

    public AccountSidechainNodeViewHolder(SidechainSettings sidechainSettings, NetworkParams params, NetworkTimeProvider timeProvider, AccountHistoryStorage historyStorage, ConsensusDataStorage consensusDataStorage, AccountStateMetadataStorage stateMetadataStorage, Database stateDbStorage, Seq<MessageProcessor> customMessageProcessors, SidechainSecretStorage secretStorage, AccountBlock genesisBlock) {
        this.sidechainSettings = sidechainSettings;
        this.params = params;
        this.timeProvider = timeProvider;
        this.historyStorage = historyStorage;
        this.consensusDataStorage = consensusDataStorage;
        this.stateMetadataStorage = stateMetadataStorage;
        this.stateDbStorage = stateDbStorage;
        this.customMessageProcessors = customMessageProcessors;
        this.secretStorage = secretStorage;
        this.genesisBlock = genesisBlock;
        super(sidechainSettings, timeProvider);
    }

    public static class NewExecTransactionsEvent
    implements NodeViewSynchronizer.ReceivableMessages$.NodeViewHolderEvent,
    Product,
    scala.Serializable {
        private final Iterable<AccountTransaction<Proposition, Proof<Proposition>>> newExecTxs;

        public Iterable<AccountTransaction<Proposition, Proof<Proposition>>> newExecTxs() {
            return this.newExecTxs;
        }

        public NewExecTransactionsEvent copy(Iterable<AccountTransaction<Proposition, Proof<Proposition>>> newExecTxs) {
            return new NewExecTransactionsEvent(newExecTxs);
        }

        public Iterable<AccountTransaction<Proposition, Proof<Proposition>>> copy$default$1() {
            return this.newExecTxs();
        }

        public String productPrefix() {
            return "NewExecTransactionsEvent";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return this.newExecTxs();
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof NewExecTransactionsEvent;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof NewExecTransactionsEvent)) return false;
            boolean bl = true;
            if (!bl) return false;
            NewExecTransactionsEvent newExecTransactionsEvent = (NewExecTransactionsEvent)x$1;
            Iterable<AccountTransaction<Proposition, Proof<Proposition>>> iterable = this.newExecTxs();
            Iterable<AccountTransaction<Proposition, Proof<Proposition>>> iterable2 = newExecTransactionsEvent.newExecTxs();
            if (iterable == null) {
                if (iterable2 != null) {
                    return false;
                }
            } else if (!iterable.equals(iterable2)) return false;
            if (!newExecTransactionsEvent.canEqual(this)) return false;
            return true;
        }

        public NewExecTransactionsEvent(Iterable<AccountTransaction<Proposition, Proof<Proposition>>> newExecTxs) {
            this.newExecTxs = newExecTxs;
            Product.$init$((Product)this);
        }
    }
}

