/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account;

import akka.actor.ActorRef;
import akka.actor.ActorRefFactory;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.horizen.AbstractSidechainApp;
import io.horizen.ChainInfo;
import io.horizen.SidechainAppEvents$SidechainApplicationStart$;
import io.horizen.SidechainAppStopper;
import io.horizen.SidechainSettings;
import io.horizen.SidechainSyncInfoMessageSpec$;
import io.horizen.account.AccountNodeViewHolderRef$;
import io.horizen.account.api.http.AccountApplicationApiGroup;
import io.horizen.account.api.http.route.AccountApplicationApiRoute;
import io.horizen.account.api.http.route.AccountBlockApiRoute;
import io.horizen.account.api.http.route.AccountEthRpcRoute;
import io.horizen.account.api.http.route.AccountTransactionApiRoute;
import io.horizen.account.api.http.route.AccountWalletApiRoute;
import io.horizen.account.api.rpc.handler.RpcHandler;
import io.horizen.account.api.rpc.service.EthService;
import io.horizen.account.api.rpc.service.RpcProcessor;
import io.horizen.account.api.rpc.service.RpcUtils$;
import io.horizen.account.block.AccountBlock;
import io.horizen.account.block.AccountBlockHeader;
import io.horizen.account.block.AccountBlockSerializer;
import io.horizen.account.certificatesubmitter.AccountCertificateSubmitterRef$;
import io.horizen.account.chain.AccountFeePaymentsInfo;
import io.horizen.account.companion.SidechainAccountTransactionsCompanion;
import io.horizen.account.forger.AccountForgerRef$;
import io.horizen.account.history.AccountHistory;
import io.horizen.account.network.AccountNodeViewSynchronizer$;
import io.horizen.account.node.AccountNodeView;
import io.horizen.account.node.NodeAccountHistory;
import io.horizen.account.node.NodeAccountMemoryPool;
import io.horizen.account.node.NodeAccountState;
import io.horizen.account.state.MessageProcessor;
import io.horizen.account.storage.AccountHistoryStorage;
import io.horizen.account.storage.AccountStateMetadataStorage;
import io.horizen.account.transaction.AccountTransaction;
import io.horizen.account.websocket.WebSocketAccountServerRef$;
import io.horizen.api.http.SidechainBlockActorRef$;
import io.horizen.api.http.SidechainTransactionActorRef$;
import io.horizen.api.http.SidechainTransactionRateLimiterActorRef$;
import io.horizen.api.http.route.MainchainBlockApiRoute;
import io.horizen.api.http.route.SidechainNodeApiRoute;
import io.horizen.api.http.route.SidechainSubmitterApiRoute;
import io.horizen.block.SidechainBlockBase$;
import io.horizen.certificatesubmitter.network.CertificateSignaturesManagerRef$;
import io.horizen.consensus.ConsensusDataStorage;
import io.horizen.evm.Database;
import io.horizen.evm.LevelDBDatabase;
import io.horizen.fork.ForkConfigurator;
import io.horizen.helper.NodeViewProvider;
import io.horizen.helper.NodeViewProviderImpl;
import io.horizen.helper.TransactionSubmitProvider;
import io.horizen.helper.TransactionSubmitProviderImpl;
import io.horizen.network.SyncStatusActorRef$;
import io.horizen.node.NodeWalletBase;
import io.horizen.proof.Proof;
import io.horizen.proposition.Proposition;
import io.horizen.secret.Secret;
import io.horizen.secret.SecretSerializer;
import io.horizen.storage.SidechainSecretStorage;
import io.horizen.storage.leveldb.VersionedLevelDbStorageAdapter;
import io.horizen.transaction.TransactionSerializer;
import io.horizen.utils.BytesUtils;
import io.horizen.utils.Pair;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import sparkz.core.NodeViewModifier;
import sparkz.core.api.http.ApiRoute;
import sparkz.core.serialization.SparkzSerializer;
import sparkz.core.transaction.Transaction$;

@ScalaSignature(bytes="\u0006\u0001\u0011\ra\u0001B#G\u00015C\u0011B\u0015\u0001\u0003\u0002\u0003\u0006Ia\u0015,\t\u0013\u001d\u0004!\u0011!Q\u0001\n!|\bBCA\u0004\u0001\t\u0005\t\u0015!\u0003\u0002\n!Q\u0011q\b\u0001\u0003\u0002\u0003\u0006I!!\u0011\t\u0019\u0005u\u0003A!A!\u0002\u0013\ty&a\"\t\u0015\u0005=\u0005A!A!\u0002\u0013\t\t\n\u0003\u0007\u0002&\u0002\u0011\t\u0011)A\u0005\u0003O\u000bi\u000b\u0003\u0007\u00026\u0002\u0011\t\u0011)A\u0005\u0003o\u000b\u0019\r\u0003\u0007\u0002L\u0002\u0011\t\u0011)A\u0005\u0003\u001b\f\u0019\u000e\u0003\u0006\u0002\\\u0002\u0011\t\u0011)A\u0005\u0003[BA\"a9\u0001\u0005\u0003\u0005\u000b\u0011BAs\u0003[Dq!!>\u0001\t\u0003\t90\u0002\u0004\u00034\u0001\u0001\u0013qC\u0003\u0007\u0005k\u0001\u0001Ea\u000e\u0006\r\t\r\u0003\u0001\tB#\u0011%\u0011Y\u0005\u0001b\u0001\n\u0003\u0012i\u0005\u0003\u0005\u0003P\u0001\u0001\u000b\u0011BA7\u0011)\u0011\t\u0006\u0001EC\u0002\u0013E!1\u000b\u0005\u000b\u0005C\u0002\u0001R1A\u0005B\t\r\u0004\"\u0003B3\u0001\t\u0007I\u0011\u0001B'\u0011!\u00119\u0007\u0001Q\u0001\n\u00055\u0004\"\u0003B5\u0001\t\u0007I\u0011\u0001B6\u0011!\u00119\b\u0001Q\u0001\n\t5\u0004\"\u0003B=\u0001\t\u0007I\u0011\u0001B6\u0011!\u0011Y\b\u0001Q\u0001\n\t5\u0004\"\u0003B?\u0001\t\u0007I\u0011\u0001B6\u0011!\u0011y\b\u0001Q\u0001\n\t5\u0004\"\u0003BA\u0001\t\u0007I\u0011\u0001B6\u0011!\u0011\u0019\t\u0001Q\u0001\n\t5\u0004\"\u0003BC\u0001\t\u0007I\u0011\u0003BD\u0011!\u0011)\n\u0001Q\u0001\n\t%\u0005\"\u0003BL\u0001\t\u0007I\u0011\u0003BM\u0011!\u0011)\u000b\u0001Q\u0001\n\tm\u0005\"\u0003BT\u0001\t\u0007I\u0011\u0003BU\u0011!\u0011\t\f\u0001Q\u0001\n\t-\u0006\"\u0003BZ\u0001\t\u0007I\u0011\u0003B[\u0011!\u0011\u0019\r\u0001Q\u0001\n\t]\u0006\"\u0003Bc\u0001\t\u0007I\u0011\u0003Bd\u0011!\u0011)\u000e\u0001Q\u0001\n\t%\u0007\"\u0003Bl\u0001\t\u0007I\u0011\tBm\u0011!\u0011Y\u000f\u0001Q\u0001\n\tm\u0007b\u0002Bw\u0001\u0011\u0005!q\u001e\u0005\n\u0007w\u0001!\u0019!C!\u00053D\u0001b!\u0010\u0001A\u0003%!1\u001c\u0005\n\u0007\u007f\u0001!\u0019!C\u0001\u00053D\u0001b!\u0011\u0001A\u0003%!1\u001c\u0005\n\u0007\u0007\u0002!\u0019!C\u0001\u00053D\u0001b!\u0012\u0001A\u0003%!1\u001c\u0005\n\u0007\u000f\u0002!\u0019!C\u0001\u00053D\u0001b!\u0013\u0001A\u0003%!1\u001c\u0005\n\u0007\u0017\u0002!\u0019!C\u0001\u00053D\u0001b!\u0014\u0001A\u0003%!1\u001c\u0005\n\u0007\u001f\u0002!\u0019!C\u0001\u00053D\u0001b!\u0015\u0001A\u0003%!1\u001c\u0005\n\u0007'\u0002!\u0019!C\u0001\u00053D\u0001b!\u0016\u0001A\u0003%!1\u001c\u0005\n\u0007/\u0002!\u0019!C\u0001\u00073B\u0001ba\u001b\u0001A\u0003%11\f\u0005\n\u0007[\u0002!\u0019!C\u0001\u0007_B\u0001b! \u0001A\u0003%1\u0011\u000f\u0005\u000b\u0007\u007f\u0002\u0001R1A\u0005B\r\u0005\u0005BCBP\u0001!\u0015\r\u0011\"\u0011\u0004\u0002\"I1\u0011\u0015\u0001C\u0002\u0013\u000511\u0015\u0005\t\u0007c\u0004\u0001\u0015!\u0003\u0004&\"911\u001f\u0001\u0005\u0002\r\r\u0006\"CB{\u0001\t\u0007I\u0011AB|\u0011!\u0019y\u0010\u0001Q\u0001\n\re\bb\u0002C\u0001\u0001\u0011\u00053q\u001f\u0002\u0014\u0003\u000e\u001cw.\u001e8u'&$Wm\u00195bS:\f\u0005\u000f\u001d\u0006\u0003\u000f\"\u000bq!Y2d_VtGO\u0003\u0002J\u0015\u00069\u0001n\u001c:ju\u0016t'\"A&\u0002\u0005%|7\u0001A\n\u0003\u00019\u0003\"a\u0014)\u000e\u0003!K!!\u0015%\u0003)\u0005\u00137\u000f\u001e:bGR\u001c\u0016\u000eZ3dQ\u0006Lg.\u00119q\u0003E\u0019\u0018\u000eZ3dQ\u0006LgnU3ui&twm\u001d\t\u0003\u001fRK!!\u0016%\u0003#MKG-Z2iC&t7+\u001a;uS:<7/\u0003\u0002S!\"\"\u0011\u0001\u00173f!\tI&-D\u0001[\u0015\tYF,\u0001\u0003oC6,'BA/_\u0003\u0019IgN[3di*\u0011q\fY\u0001\u0007O>|w\r\\3\u000b\u0003\u0005\f1aY8n\u0013\t\u0019'LA\u0003OC6,G-A\u0003wC2,X-I\u0001g\u0003E\u0019\u0016\u000eZ3dQ\u0006LgnU3ui&twm]\u0001\u0018GV\u001cHo\\7TK\u000e\u0014X\r^*fe&\fG.\u001b>feN\u0004B!\u001b8qm6\t!N\u0003\u0002lY\u0006!Q\u000f^5m\u0015\u0005i\u0017\u0001\u00026bm\u0006L!a\u001c6\u0003\u000f!\u000b7\u000f['baB\u0011\u0011\u000f^\u0007\u0002e*\u00111\u000f\\\u0001\u0005Y\u0006tw-\u0003\u0002ve\n!!)\u001f;f!\r9(\u0010`\u0007\u0002q*\u0011\u0011\u0010S\u0001\u0007g\u0016\u001c'/\u001a;\n\u0005mD(\u0001E*fGJ,GoU3sS\u0006d\u0017N_3s!\t9X0\u0003\u0002\u007fq\n11+Z2sKRL!a\u001a))\u000b\tAF-a\u0001\"\u0005\u0005\u0015\u0011aF\"vgR|WnU3de\u0016$8+\u001a:jC2L'0\u001a:t\u0003\r\u001aWo\u001d;p[\u0006\u001b7m\\;oiR\u0013\u0018M\\:bGRLwN\\*fe&\fG.\u001b>feN\u0004R!\u001b8q\u0003\u0017\u0001b!!\u0004\u0002\u0014\u0005]QBAA\b\u0015\r\t\t\u0002S\u0001\fiJ\fgn]1di&|g.\u0003\u0003\u0002\u0016\u0005=!!\u0006+sC:\u001c\u0018m\u0019;j_:\u001cVM]5bY&TXM\u001d\t\t\u00033\ti\"!\t\u0002.5\u0011\u00111\u0004\u0006\u0004\u0003#1\u0015\u0002BA\u0010\u00037\u0011!#Q2d_VtG\u000f\u0016:b]N\f7\r^5p]B!\u00111EA\u0015\u001b\t\t)CC\u0002\u0002(!\u000b1\u0002\u001d:pa>\u001c\u0018\u000e^5p]&!\u00111FA\u0013\u0005-\u0001&o\u001c9pg&$\u0018n\u001c8\u0011\r\u0005=\u0012QGA\u0011\u001b\t\t\tDC\u0002\u00024!\u000bQ\u0001\u001d:p_\u001aLA!a\u000e\u00022\t)\u0001K]8pM\"*1\u0001\u00173\u0002<\u0005\u0012\u0011QH\u0001$\u0007V\u001cHo\\7BG\u000e|WO\u001c;Ue\u0006t7/Y2uS>t7+\u001a:jC2L'0\u001a:t\u0003=\u0019Wo\u001d;p[\u0006\u0003\u0018n\u0012:pkB\u001c\b#B5\u0002D\u0005\u001d\u0013bAA#U\n!A*[:u!\u0011\tI%a\u0015\u000e\u0005\u0005-#\u0002BA'\u0003\u001f\nA\u0001\u001b;ua*\u0019\u0011\u0011\u000b$\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0002V\u0005-#AG!dG>,h\u000e^!qa2L7-\u0019;j_:\f\u0005/[$s_V\u0004\b&\u0002\u0003YI\u0006e\u0013EAA.\u0003=\u0019Uo\u001d;p[\u0006\u0003\u0018n\u0012:pkB\u001c\u0018\u0001\u0005:fU\u0016\u001cG/\u001a3Ba&\u0004\u0016\r\u001e5t!\u0015I\u00171IA1!!\t\u0019'!\u001b\u0002n\u00055TBAA3\u0015\r\t9\u0007S\u0001\u0006kRLGn]\u0005\u0005\u0003W\n)G\u0001\u0003QC&\u0014\b\u0003BA8\u0003\u0003sA!!\u001d\u0002~A!\u00111OA=\u001b\t\t)HC\u0002\u0002x1\u000ba\u0001\u0010:p_Rt$BAA>\u0003\u0015\u00198-\u00197b\u0013\u0011\ty(!\u001f\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019)!\"\u0003\rM#(/\u001b8h\u0015\u0011\ty(!\u001f\n\u0007\u0005u\u0003\u000bK\u0003\u00061\u0012\fY)\t\u0002\u0002\u000e\u0006\u0001\"+\u001a6fGR,G-\u00119j!\u0006$\bn]\u0001\u0018GV\u001cHo\\7NKN\u001c\u0018mZ3Qe>\u001cWm]:peN\u0004R![A\"\u0003'\u0003B!!&\u0002\u001c6\u0011\u0011q\u0013\u0006\u0004\u000333\u0015!B:uCR,\u0017\u0002BAO\u0003/\u0013\u0001#T3tg\u0006<W\r\u0015:pG\u0016\u001c8o\u001c:)\u000b\u0019AF-!)\"\u0005\u0005\r\u0016aF\"vgR|W.T3tg\u0006<W\r\u0015:pG\u0016\u001c8o\u001c:t\u0003I\t\u0007\u000f\u001d7jG\u0006$\u0018n\u001c8Ti>\u0004\b/\u001a:\u0011\u0007=\u000bI+C\u0002\u0002,\"\u00131cU5eK\u000eD\u0017-\u001b8BaB\u001cFo\u001c9qKJL1!!*QQ\u00159\u0001\fZAYC\t\t\u0019,\u0001\nBaBd\u0017nY1uS>t7\u000b^8qa\u0016\u0014\u0018\u0001\u00054pe.\u001cuN\u001c4jOV\u0014\u0018\r^8s!\u0011\tI,a0\u000e\u0005\u0005m&bAA_\u0011\u0006!am\u001c:l\u0013\u0011\t\t-a/\u0003!\u0019{'o[\"p]\u001aLw-\u001e:bi>\u0014\u0018bAA[!\"*\u0001\u0002\u00173\u0002H\u0006\u0012\u0011\u0011Z\u0001\u0012\r>\u00148nQ8oM&<WO]1uS>t\u0017!C2iC&t\u0017J\u001c4p!\ry\u0015qZ\u0005\u0004\u0003#D%!C\"iC&t\u0017J\u001c4p\u0013\r\tY\r\u0015\u0015\u0006\u0013a#\u0017q[\u0011\u0003\u00033\f\u0011b\u00115bS:LeNZ8\u0002\u0015\u0005\u0004\bOV3sg&|g\u000eK\u0003\u000b1\u0012\fy.\t\u0002\u0002b\u0006Q\u0011\t\u001d9WKJ\u001c\u0018n\u001c8\u0002+5\u001c'\t\\8dWJ+g-\u001a:f]\u000e,G)\u001a7bsB!\u0011q]Au\u001b\t\tI(\u0003\u0003\u0002l\u0006e$aA%oi&\u0019\u00111\u001d))\u000b-AF-!=\"\u0005\u0005M\u0018\u0001H'bS:\u001c\u0007.Y5o\u00052|7m\u001b*fM\u0016\u0014XM\\2f\t\u0016d\u0017-_\u0001\u0007y%t\u0017\u000e\u001e \u00151\u0005e\u0018Q B\u0001\u0005\u000b\u0011IA!\u0004\u0003\u0012\tU!\u0011\u0004B\u000f\u0005C\u0011)\u0003E\u0002\u0002|\u0002i\u0011A\u0012\u0005\u0006%2\u0001\ra\u0015\u0015\u0006\u0003{DF-\u001a\u0005\u0006O2\u0001\r\u0001\u001b\u0015\u0007\u0005\u0003AF-a\u0001\t\u000f\u0005\u001dA\u00021\u0001\u0002\n!2!Q\u0001-e\u0003wAq!a\u0010\r\u0001\u0004\t\t\u0005\u000b\u0004\u0003\na#\u0017\u0011\f\u0005\b\u0003;b\u0001\u0019AA0Q\u0019\u0011i\u0001\u00173\u0002\f\"9\u0011q\u0012\u0007A\u0002\u0005E\u0005F\u0002B\t1\u0012\f\t\u000bC\u0004\u0002&2\u0001\r!a*)\r\tU\u0001\fZAY\u0011\u001d\t)\f\u0004a\u0001\u0003oCcA!\u0007YI\u0006\u001d\u0007bBAf\u0019\u0001\u0007\u0011Q\u001a\u0015\u0007\u0005;AF-a6\t\u000f\u0005mG\u00021\u0001\u0002n!2!\u0011\u0005-e\u0003?Dq!a9\r\u0001\u0004\t)\u000f\u000b\u0004\u0003&a#\u0017\u0011\u001f\u0015\u0004\u0019\t-\u0002\u0003\u0002B\u0017\u0005_i\u0011\u0001X\u0005\u0004\u0005ca&AB%oU\u0016\u001cGO\u0001\u0002U1\n!\u0001+T(E!\u0011\u0011IDa\u0010\u000e\u0005\tm\"b\u0001B\u001f\r\u0006)!\r\\8dW&!!\u0011\tB\u001e\u00051\t5mY8v]R\u0014En\\2l\u0005\u0011qe\u000b\u0013+\u0011\t\u0005m(qI\u0005\u0004\u0005\u00132%AH!dG>,h\u000e^*jI\u0016\u001c\u0007.Y5o\u001d>$WMV5fo\"{G\u000eZ3s\u00035\u0019x/Y4hKJ\u001cuN\u001c4jOV\u0011\u0011QN\u0001\u000fg^\fwmZ3s\u0007>tg-[4!\u0003y\u0019\u0018\u000eZ3dQ\u0006Lg\u000e\u0016:b]N\f7\r^5p]N\u001cu.\u001c9b]&|g.\u0006\u0002\u0003VA!!q\u000bB/\u001b\t\u0011IFC\u0002\u0003\\\u0019\u000b\u0011bY8na\u0006t\u0017n\u001c8\n\t\t}#\u0011\f\u0002&'&$Wm\u00195bS:\f5mY8v]R$&/\u00198tC\u000e$\u0018n\u001c8t\u0007>l\u0007/\u00198j_:\fAbZ3oKNL7O\u00117pG.,\"Aa\u000e\u0002'\u0011\fG/\u0019#je\u0006\u00137o\u001c7vi\u0016\u0004\u0016\r\u001e5\u0002)\u0011\fG/\u0019#je\u0006\u00137o\u001c7vi\u0016\u0004\u0016\r\u001e5!\u0003-\u0019Xm\u0019:fiN#xN]3\u0016\u0005\t5\u0004\u0003\u0002B8\u0005gj!A!\u001d\u000b\u0005-c\u0017\u0002\u0002B;\u0005c\u0012AAR5mK\u0006a1/Z2sKR\u001cFo\u001c:fA\u0005qQ.\u001a;b'R\fG/Z*u_J,\u0017aD7fi\u0006\u001cF/\u0019;f'R|'/\u001a\u0011\u0002\u0019!L7\u000f^8ssN#xN]3\u0002\u001b!L7\u000f^8ssN#xN]3!\u00039\u0019wN\\:f]N,8o\u0015;pe\u0016\fqbY8og\u0016t7/^:Ti>\u0014X\rI\u0001\u0018g&$Wm\u00195bS:D\u0015n\u001d;pef\u001cFo\u001c:bO\u0016,\"A!#\u0011\t\t-%\u0011S\u0007\u0003\u0005\u001bS1Aa$G\u0003\u001d\u0019Ho\u001c:bO\u0016LAAa%\u0003\u000e\n)\u0012iY2pk:$\b*[:u_JL8\u000b^8sC\u001e,\u0017\u0001G:jI\u0016\u001c\u0007.Y5o\u0011&\u001cHo\u001c:z'R|'/Y4fA\u000512/\u001b3fG\"\f\u0017N\\*fGJ,Go\u0015;pe\u0006<W-\u0006\u0002\u0003\u001cB!!Q\u0014BQ\u001b\t\u0011yJC\u0002\u0003\u0010\"KAAa)\u0003 \n12+\u001b3fG\"\f\u0017N\\*fGJ,Go\u0015;pe\u0006<W-A\ftS\u0012,7\r[1j]N+7M]3u'R|'/Y4fA\u0005!2\u000f^1uK6+G/\u00193bi\u0006\u001cFo\u001c:bO\u0016,\"Aa+\u0011\t\t-%QV\u0005\u0005\u0005_\u0013iIA\u000eBG\u000e|WO\u001c;Ti\u0006$X-T3uC\u0012\fG/Y*u_J\fw-Z\u0001\u0016gR\fG/Z'fi\u0006$\u0017\r^1Ti>\u0014\u0018mZ3!\u00039\u0019H/\u0019;f\t\n\u001cFo\u001c:bO\u0016,\"Aa.\u0011\t\te&qX\u0007\u0003\u0005wS1A!0I\u0003\r)g/\\\u0005\u0005\u0005\u0003\u0014YLA\bMKZ,G\u000e\u0012\"ECR\f'-Y:f\u0003=\u0019H/\u0019;f\t\n\u001cFo\u001c:bO\u0016\u0004\u0013\u0001F2p]N,gn];t\t\u0006$\u0018m\u0015;pe\u0006<W-\u0006\u0002\u0003JB!!1\u001aBi\u001b\t\u0011iMC\u0002\u0003P\"\u000b\u0011bY8og\u0016t7/^:\n\t\tM'Q\u001a\u0002\u0015\u0007>t7/\u001a8tkN$\u0015\r^1Ti>\u0014\u0018mZ3\u0002+\r|gn]3ogV\u001cH)\u0019;b'R|'/Y4fA\u0005\tbn\u001c3f-&,w\u000fS8mI\u0016\u0014(+\u001a4\u0016\u0005\tm\u0007\u0003\u0002Bo\u0005Ol!Aa8\u000b\t\t\u0005(1]\u0001\u0006C\u000e$xN\u001d\u0006\u0003\u0005K\fA!Y6lC&!!\u0011\u001eBp\u0005!\t5\r^8s%\u00164\u0017A\u00058pI\u00164\u0016.Z<I_2$WM\u001d*fM\u0002\n1#\\8eS\u001aLWM]*fe&\fG.\u001b>feN,\"A!=\u0011\u0011\u0005=$1\u001fB|\u0007+IAA!>\u0002\u0006\n\u0019Q*\u00199\u0011\t\te8q\u0002\b\u0005\u0005w\u001cIA\u0004\u0003\u0003~\u000e\ra\u0002BA:\u0005\u007fL!a!\u0001\u0002\rM\u0004\u0018M]6{\u0013\u0011\u0019)aa\u0002\u0002\t\r|'/\u001a\u0006\u0003\u0007\u0003IAaa\u0003\u0004\u000e\u00059\u0001/Y2lC\u001e,'\u0002BB\u0003\u0007\u000fIAa!\u0005\u0004\u0014\tqQj\u001c3jM&,'\u000fV=qK&#'\u0002BB\u0006\u0007\u001b\u0001Daa\u0006\u0004(A11\u0011DB\u0010\u0007Gi!aa\u0007\u000b\t\ru1QB\u0001\u000eg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\n\t\r\u000521\u0004\u0002\u0011'B\f'o\u001b>TKJL\u0017\r\\5{KJ\u0004Ba!\n\u0004(1\u0001AaCB\u0015U\u0005\u0005\t\u0011!B\u0001\u0007W\u00111a\u0018\u00132#\u0011\u0019ica\r\u0011\t\u0005\u001d8qF\u0005\u0005\u0007c\tIHA\u0004O_RD\u0017N\\4\u0011\t\rU2qG\u0007\u0003\u0007\u001bIAa!\u000f\u0004\u000e\t\u0001bj\u001c3f-&,w/T8eS\u001aLWM]\u0001\u0015]>$WMV5foNKhn\u00195s_:L'0\u001a:\u0002+9|G-\u001a,jK^\u001c\u0016P\\2ie>t\u0017N_3sA\u0005a2/\u001b3fG\"\f\u0017N\u001c\"m_\u000e\\gi\u001c:hKJ\f5\r^8s%\u00164\u0017!H:jI\u0016\u001c\u0007.Y5o\u00052|7m\u001b$pe\u001e,'/Q2u_J\u0014VM\u001a\u0011\u00029MLG-Z2iC&tGK]1og\u0006\u001cG/[8o\u0003\u000e$xN\u001d*fM\u0006i2/\u001b3fG\"\f\u0017N\u001c+sC:\u001c\u0018m\u0019;j_:\f5\r^8s%\u00164\u0007%\u0001\ftS\u0012,7\r[1j]\ncwnY6BGR|'OU3g\u0003]\u0019\u0018\u000eZ3dQ\u0006LgN\u00117pG.\f5\r^8s%\u00164\u0007%A\fdKJ$\u0018NZ5dCR,7+\u001e2nSR$XM\u001d*fM\u0006A2-\u001a:uS\u001aL7-\u0019;f'V\u0014W.\u001b;uKJ\u0014VM\u001a\u0011\u0002?\r,'\u000f^5gS\u000e\fG/Z*jO:\fG/\u001e:fg6\u000bg.Y4feJ+g-\u0001\u0011dKJ$\u0018NZ5dCR,7+[4oCR,(/Z:NC:\fw-\u001a:SK\u001a\u0004\u0013AE:z]\u000e\u001cF/\u0019;vg\u0006\u001bGo\u001c:SK\u001a\f1c]=oGN#\u0018\r^;t\u0003\u000e$xN\u001d*fM\u0002\n!B\u001d9d\u0011\u0006tG\r\\3s+\t\u0019Y\u0006\u0005\u0003\u0004^\r\u001dTBAB0\u0015\u0011\u0019\tga\u0019\u0002\u000f!\fg\u000e\u001a7fe*!1QMA(\u0003\r\u0011\boY\u0005\u0005\u0007S\u001ayF\u0001\u0006Sa\u000eD\u0015M\u001c3mKJ\f1B\u001d9d\u0011\u0006tG\r\\3sA\u0005a!\u000f]2Qe>\u001cWm]:peV\u00111\u0011\u000f\t\u0005\u0007g\u001aI(\u0004\u0002\u0004v)!1qOB2\u0003\u001d\u0019XM\u001d<jG\u0016LAaa\u001f\u0004v\ta!\u000b]2Qe>\u001cWm]:pe\u0006i!\u000f]2Qe>\u001cWm]:pe\u0002\nA#\u00199qY&\u001c\u0017\r^5p]\u0006\u0003\u0018NU8vi\u0016\u001cXCABB!\u0019\u0019)i!$\u0004\u0014:!1qQBF\u001d\u0011\t\u0019h!#\n\u0005\u0005m\u0014\u0002BB\u0006\u0003sJAaa$\u0004\u0012\n\u00191+Z9\u000b\t\r-\u0011\u0011\u0010\t\u0005\u0007+\u001bY*\u0004\u0002\u0004\u0018*!\u0011QJBM\u0015\u0011\t\tf!\u0004\n\t\ru5q\u0013\u0002\t\u0003BL'k\\;uK\u0006i1m\u001c:f\u0003BL'k\\;uKN\f\u0001C\\8eKZKWm\u001e)s_ZLG-\u001a:\u0016\u0005\r\u0015\u0006CFBT\u0007[\u001b\tl!.\u0004<\u000eu6\u0011ZBk\u00077\u001c)oa;\u000e\u0005\r%&bABV\u0011\u00061\u0001.\u001a7qKJLAaa,\u0004*\n\u0001bj\u001c3f-&,w\u000f\u0015:pm&$WM\u001d\t\u0004\u0007gkQ\"\u0001\u0001\u0011\t\te2qW\u0005\u0005\u0007s\u0013YD\u0001\nBG\u000e|WO\u001c;CY>\u001c7\u000eS3bI\u0016\u0014\bcABZ\u001dA!1qXBc\u001b\t\u0019\tMC\u0002\u0004D\u001a\u000bQa\u00195bS:LAaa2\u0004B\n1\u0012iY2pk:$h)Z3QCflWM\u001c;t\u0013:4w\u000e\u0005\u0003\u0004L\u000eEWBABg\u0015\r\u0019yMR\u0001\u0005]>$W-\u0003\u0003\u0004T\u000e5'A\u0005(pI\u0016\f5mY8v]RD\u0015n\u001d;pef\u0004Baa3\u0004X&!1\u0011\\Bg\u0005Aqu\u000eZ3BG\u000e|WO\u001c;Ti\u0006$X\r\u0005\u0003\u0004^\u000e\u0005XBABp\u0015\r\u0019y\rS\u0005\u0005\u0007G\u001cyN\u0001\bO_\u0012,w+\u00197mKR\u0014\u0015m]3\u0011\t\r-7q]\u0005\u0005\u0007S\u001ciMA\u000bO_\u0012,\u0017iY2pk:$X*Z7pef\u0004vn\u001c7\u0011\t\r-7Q^\u0005\u0005\u0007_\u001ciMA\bBG\u000e|WO\u001c;O_\u0012,g+[3x\u0003Eqw\u000eZ3WS\u0016<\bK]8wS\u0012,'\u000fI\u0001\u0014O\u0016$hj\u001c3f-&,w\u000f\u0015:pm&$WM]\u0001\u001aiJ\fgn]1di&|gnU;c[&$\bK]8wS\u0012,'/\u0006\u0002\u0004zB11qUB~\u0007cKAa!@\u0004*\nIBK]1og\u0006\u001cG/[8o'V\u0014W.\u001b;Qe>4\u0018\u000eZ3s\u0003i!(/\u00198tC\u000e$\u0018n\u001c8Tk\nl\u0017\u000e\u001e)s_ZLG-\u001a:!\u0003q9W\r\u001e+sC:\u001c\u0018m\u0019;j_:\u001cVOY7jiB\u0013xN^5eKJ\u0004")
public class AccountSidechainApp
extends AbstractSidechainApp {
    private SidechainAccountTransactionsCompanion sidechainTransactionsCompanion;
    private AccountBlock genesisBlock;
    private Seq<ApiRoute> applicationApiRoutes;
    private Seq<ApiRoute> coreApiRoutes;
    @Named(value="CustomAccountTransactionSerializers")
    private HashMap<Byte, TransactionSerializer<AccountTransaction<Proposition, Proof<Proposition>>>> customAccountTransactionSerializers;
    @Named(value="CustomApiGroups")
    private java.util.List<AccountApplicationApiGroup> customApiGroups;
    @Named(value="AppVersion")
    private String appVersion;
    private final String swaggerConfig;
    private final String dataDirAbsolutePath;
    private final File secretStore;
    private final File metaStateStore;
    private final File historyStore;
    private final File consensusStore;
    private final AccountHistoryStorage sidechainHistoryStorage;
    private final SidechainSecretStorage sidechainSecretStorage;
    private final AccountStateMetadataStorage stateMetadataStorage;
    private final LevelDBDatabase stateDbStorage;
    private final ConsensusDataStorage consensusDataStorage;
    private final ActorRef nodeViewHolderRef;
    private final ActorRef nodeViewSynchronizer;
    private final ActorRef sidechainBlockForgerActorRef;
    private final ActorRef sidechainTransactionActorRef;
    private final ActorRef sidechainBlockActorRef;
    private final ActorRef certificateSubmitterRef;
    private final ActorRef certificateSignaturesManagerRef;
    private final ActorRef syncStatusActorRef;
    private final RpcHandler rpcHandler;
    private final RpcProcessor rpcProcessor;
    private final NodeViewProvider<AccountTransaction<Proposition, Proof<Proposition>>, AccountBlockHeader, AccountBlock, AccountFeePaymentsInfo, NodeAccountHistory, NodeAccountState, NodeWalletBase, NodeAccountMemoryPool, AccountNodeView> nodeViewProvider;
    private final TransactionSubmitProvider<AccountTransaction<Proposition, Proof<Proposition>>> transactionSubmitProvider;
    private volatile byte bitmap$0;

    public String swaggerConfig() {
        return this.swaggerConfig;
    }

    private SidechainAccountTransactionsCompanion sidechainTransactionsCompanion$lzycompute() {
        AccountSidechainApp accountSidechainApp = this;
        synchronized (accountSidechainApp) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.sidechainTransactionsCompanion = new SidechainAccountTransactionsCompanion(this.customAccountTransactionSerializers);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        this.customAccountTransactionSerializers = null;
        return this.sidechainTransactionsCompanion;
    }

    public SidechainAccountTransactionsCompanion sidechainTransactionsCompanion() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.sidechainTransactionsCompanion$lzycompute() : this.sidechainTransactionsCompanion;
    }

    private AccountBlock genesisBlock$lzycompute() {
        AccountSidechainApp accountSidechainApp = this;
        synchronized (accountSidechainApp) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.genesisBlock = (AccountBlock)new AccountBlockSerializer(this.sidechainTransactionsCompanion()).parseBytes(BytesUtils.fromHexString(super.sidechainSettings().genesisData().scGenesisBlockHex()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.genesisBlock;
    }

    @Override
    public AccountBlock genesisBlock() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.genesisBlock$lzycompute() : this.genesisBlock;
    }

    public String dataDirAbsolutePath() {
        return this.dataDirAbsolutePath;
    }

    public File secretStore() {
        return this.secretStore;
    }

    public File metaStateStore() {
        return this.metaStateStore;
    }

    public File historyStore() {
        return this.historyStore;
    }

    public File consensusStore() {
        return this.consensusStore;
    }

    public AccountHistoryStorage sidechainHistoryStorage() {
        return this.sidechainHistoryStorage;
    }

    public SidechainSecretStorage sidechainSecretStorage() {
        return this.sidechainSecretStorage;
    }

    public AccountStateMetadataStorage stateMetadataStorage() {
        return this.stateMetadataStorage;
    }

    public LevelDBDatabase stateDbStorage() {
        return this.stateDbStorage;
    }

    public ConsensusDataStorage consensusDataStorage() {
        return this.consensusDataStorage;
    }

    public ActorRef nodeViewHolderRef() {
        return this.nodeViewHolderRef;
    }

    public Map<Object, SparkzSerializer<? extends NodeViewModifier>> modifierSerializers() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToByte((byte)SidechainBlockBase$.MODULE$.ModifierTypeId())), (Object)new AccountBlockSerializer(this.sidechainTransactionsCompanion())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToByte((byte)Transaction$.MODULE$.ModifierTypeId())), (Object)this.sidechainTransactionsCompanion())}));
    }

    public ActorRef nodeViewSynchronizer() {
        return this.nodeViewSynchronizer;
    }

    public ActorRef sidechainBlockForgerActorRef() {
        return this.sidechainBlockForgerActorRef;
    }

    public ActorRef sidechainTransactionActorRef() {
        return this.sidechainTransactionActorRef;
    }

    public ActorRef sidechainBlockActorRef() {
        return this.sidechainBlockActorRef;
    }

    public ActorRef certificateSubmitterRef() {
        return this.certificateSubmitterRef;
    }

    public ActorRef certificateSignaturesManagerRef() {
        return this.certificateSignaturesManagerRef;
    }

    public ActorRef syncStatusActorRef() {
        return this.syncStatusActorRef;
    }

    public RpcHandler rpcHandler() {
        return this.rpcHandler;
    }

    public RpcProcessor rpcProcessor() {
        return this.rpcProcessor;
    }

    private Seq<ApiRoute> applicationApiRoutes$lzycompute() {
        AccountSidechainApp accountSidechainApp = this;
        synchronized (accountSidechainApp) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.applicationApiRoutes = (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.customApiGroups).asScala()).map((Function1 & Serializable & scala.Serializable)apiRoute -> new AccountApplicationApiRoute(this.settings().restApi(), (AccountApplicationApiGroup)apiRoute, this.nodeViewHolderRef(), (ActorRefFactory)this.actorSystem()), Buffer$.MODULE$.canBuildFrom());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        this.customApiGroups = null;
        return this.applicationApiRoutes;
    }

    @Override
    public Seq<ApiRoute> applicationApiRoutes() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.applicationApiRoutes$lzycompute() : this.applicationApiRoutes;
    }

    private Seq<ApiRoute> coreApiRoutes$lzycompute() {
        AccountSidechainApp accountSidechainApp = this;
        synchronized (accountSidechainApp) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.coreApiRoutes = (Seq)new .colon.colon(new MainchainBlockApiRoute(this.settings().restApi(), this.nodeViewHolderRef(), (ActorRefFactory)this.actorSystem(), this.executionContext(), ClassTag$.MODULE$.apply(AccountNodeView.class)), (List)new .colon.colon((Object)new AccountBlockApiRoute(this.settings().restApi(), this.nodeViewHolderRef(), this.sidechainBlockActorRef(), this.sidechainTransactionsCompanion(), this.sidechainBlockForgerActorRef(), this.params(), this.timeProvider(), (ActorRefFactory)this.actorSystem(), this.executionContext()), (List)new .colon.colon(new SidechainNodeApiRoute(this.peerManagerRef(), this.networkControllerRef(), this.timeProvider(), this.settings().restApi(), this.nodeViewHolderRef(), this, this.params(), this.appVersion, (ActorRefFactory)this.actorSystem(), this.executionContext(), ClassTag$.MODULE$.apply(AccountNodeView.class)), (List)new .colon.colon((Object)new AccountTransactionApiRoute(this.settings().restApi(), this.nodeViewHolderRef(), this.sidechainTransactionActorRef(), this.sidechainTransactionsCompanion(), this.params(), this.circuitType(), (ActorRefFactory)this.actorSystem(), this.executionContext()), (List)new .colon.colon((Object)new AccountWalletApiRoute(this.settings().restApi(), this.nodeViewHolderRef(), this.sidechainSecretsCompanion(), (ActorRefFactory)this.actorSystem(), this.executionContext()), (List)new .colon.colon(new SidechainSubmitterApiRoute(this.settings().restApi(), this.params(), this.certificateSubmitterRef(), this.nodeViewHolderRef(), this.circuitType(), (ActorRefFactory)this.actorSystem(), this.executionContext(), ClassTag$.MODULE$.Nothing()), (List)new .colon.colon((Object)new AccountEthRpcRoute(this.settings().restApi(), this.nodeViewHolderRef(), this.rpcProcessor(), (ActorRefFactory)this.actorSystem(), this.executionContext()), (List)Nil$.MODULE$)))))));
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        this.appVersion = null;
        return this.coreApiRoutes;
    }

    @Override
    public Seq<ApiRoute> coreApiRoutes() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.coreApiRoutes$lzycompute() : this.coreApiRoutes;
    }

    public NodeViewProvider<AccountTransaction<Proposition, Proof<Proposition>>, AccountBlockHeader, AccountBlock, AccountFeePaymentsInfo, NodeAccountHistory, NodeAccountState, NodeWalletBase, NodeAccountMemoryPool, AccountNodeView> nodeViewProvider() {
        return this.nodeViewProvider;
    }

    public NodeViewProvider<AccountTransaction<Proposition, Proof<Proposition>>, AccountBlockHeader, AccountBlock, AccountFeePaymentsInfo, NodeAccountHistory, NodeAccountState, NodeWalletBase, NodeAccountMemoryPool, AccountNodeView> getNodeViewProvider() {
        return this.nodeViewProvider();
    }

    public TransactionSubmitProvider<AccountTransaction<Proposition, Proof<Proposition>>> transactionSubmitProvider() {
        return this.transactionSubmitProvider;
    }

    public TransactionSubmitProvider<AccountTransaction<Proposition, Proof<Proposition>>> getTransactionSubmitProvider() {
        return this.transactionSubmitProvider();
    }

    @Inject
    public AccountSidechainApp(@Named(value="SidechainSettings") SidechainSettings sidechainSettings, @Named(value="CustomSecretSerializers") HashMap<Byte, SecretSerializer<Secret>> customSecretSerializers, @Named(value="CustomAccountTransactionSerializers") HashMap<Byte, TransactionSerializer<AccountTransaction<Proposition, Proof<Proposition>>>> customAccountTransactionSerializers, @Named(value="CustomApiGroups") java.util.List<AccountApplicationApiGroup> customApiGroups, @Named(value="RejectedApiPaths") java.util.List<Pair<String, String>> rejectedApiPaths, @Named(value="CustomMessageProcessors") java.util.List<MessageProcessor> customMessageProcessors, @Named(value="ApplicationStopper") SidechainAppStopper applicationStopper, @Named(value="ForkConfiguration") ForkConfigurator forkConfigurator, @Named(value="ChainInfo") ChainInfo chainInfo, @Named(value="AppVersion") String appVersion, @Named(value="MainchainBlockReferenceDelay") int mcBlockReferenceDelay) {
        ActorRef actorRef;
        this.customAccountTransactionSerializers = customAccountTransactionSerializers;
        this.customApiGroups = customApiGroups;
        this.appVersion = appVersion;
        super(sidechainSettings, customSecretSerializers, rejectedApiPaths, applicationStopper, forkConfigurator, chainInfo, mcBlockReferenceDelay);
        this.swaggerConfig = Source$.MODULE$.fromResource("account/api/accountApi.yaml", Source$.MODULE$.fromResource$default$2(), Codec$.MODULE$.UTF8()).getLines().mkString("\n");
        Predef$.MODULE$.require(!this.isCSWEnabled(), (Function0 & Serializable & scala.Serializable)() -> "Ceased Sidechain Withdrawal (CSW) should not be enabled in AccountSidechainApp!");
        this.dataDirAbsolutePath = super.sidechainSettings().sparkzSettings().dataDir().getAbsolutePath();
        this.secretStore = new File(new StringBuilder(7).append(this.dataDirAbsolutePath()).append("/secret").toString());
        this.metaStateStore = new File(new StringBuilder(6).append(this.dataDirAbsolutePath()).append("/state").toString());
        this.historyStore = new File(new StringBuilder(8).append(this.dataDirAbsolutePath()).append("/history").toString());
        this.consensusStore = new File(new StringBuilder(14).append(this.dataDirAbsolutePath()).append("/consensusData").toString());
        this.sidechainHistoryStorage = new AccountHistoryStorage(this.registerClosableResource(new VersionedLevelDbStorageAdapter(this.historyStore(), 5)), this.sidechainTransactionsCompanion(), this.params());
        this.sidechainSecretStorage = new SidechainSecretStorage(this.registerClosableResource(new VersionedLevelDbStorageAdapter(this.secretStore(), 5)), this.sidechainSecretsCompanion());
        this.stateMetadataStorage = new AccountStateMetadataStorage(this.registerClosableResource(new VersionedLevelDbStorageAdapter(this.metaStateStore(), this.params().maxHistoryRewritingLength() * 2)));
        this.stateDbStorage = this.registerClosableResource(new LevelDBDatabase(new StringBuilder(10).append(this.dataDirAbsolutePath()).append("/evm-state").toString()));
        this.consensusDataStorage = new ConsensusDataStorage(this.registerClosableResource(new VersionedLevelDbStorageAdapter(this.consensusStore(), 5)));
        if (this.sidechainSecretStorage().isEmpty()) {
            super.sidechainSettings().wallet().genesisSecrets().foreach((Function1 & Serializable & scala.Serializable)secretHex -> this.sidechainSecretStorage().add((Secret)this.sidechainSecretsCompanion().parseBytes(BytesUtils.fromHexString(secretHex))));
            super.sidechainSettings().withdrawalEpochCertificateSettings().signersSecrets().foreach((Function1 & Serializable & scala.Serializable)secretSchnorr -> this.sidechainSecretStorage().add((Secret)this.sidechainSecretsCompanion().parseBytes(BytesUtils.fromHexString(secretSchnorr))));
        }
        this.nodeViewHolderRef = AccountNodeViewHolderRef$.MODULE$.apply(super.sidechainSettings(), this.sidechainHistoryStorage(), this.consensusDataStorage(), this.stateMetadataStorage(), (Database)this.stateDbStorage(), (Seq<MessageProcessor>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(customMessageProcessors).asScala()), this.sidechainSecretStorage(), this.params(), this.timeProvider(), this.genesisBlock(), this.actorSystem());
        this.nodeViewSynchronizer = this.actorSystem().actorOf(AccountNodeViewSynchronizer$.MODULE$.props(this.networkControllerRef(), this.nodeViewHolderRef(), SidechainSyncInfoMessageSpec$.MODULE$, this.settings().network(), this.timeProvider(), this.modifierSerializers(), this.executionContext()));
        this.sidechainBlockForgerActorRef = AccountForgerRef$.MODULE$.apply("AccountForger", super.sidechainSettings(), this.nodeViewHolderRef(), this.mainchainSynchronizer(), this.sidechainTransactionsCompanion(), this.timeProvider(), this.params(), this.actorSystem());
        if (super.sidechainSettings().apiRateLimiter().enabled()) {
            ActorRef rateLimiterActorRef = SidechainTransactionRateLimiterActorRef$.MODULE$.apply(this.nodeViewHolderRef(), super.sidechainSettings().apiRateLimiter(), this.actorSystem(), this.executionContext());
            actorRef = SidechainTransactionActorRef$.MODULE$.apply(rateLimiterActorRef, this.actorSystem(), this.executionContext());
        } else {
            actorRef = SidechainTransactionActorRef$.MODULE$.apply(this.nodeViewHolderRef(), this.actorSystem(), this.executionContext());
        }
        this.sidechainTransactionActorRef = actorRef;
        this.sidechainBlockActorRef = SidechainBlockActorRef$.MODULE$.apply("AccountBlock", super.sidechainSettings(), this.sidechainBlockForgerActorRef(), ClassTag$.MODULE$.apply(AccountBlock.class), ClassTag$.MODULE$.apply(AccountHistory.class), this.actorSystem(), this.executionContext());
        this.certificateSubmitterRef = AccountCertificateSubmitterRef$.MODULE$.apply(super.sidechainSettings(), this.nodeViewHolderRef(), this.secureEnclaveApiClient(), this.params(), this.mainchainNodeChannel(), this.actorSystem(), this.executionContext());
        this.certificateSignaturesManagerRef = CertificateSignaturesManagerRef$.MODULE$.apply(this.networkControllerRef(), this.certificateSubmitterRef(), this.params(), super.sidechainSettings().sparkzSettings().network(), this.actorSystem(), this.executionContext());
        this.syncStatusActorRef = SyncStatusActorRef$.MODULE$.apply("SyncStatus", super.sidechainSettings(), this.nodeViewHolderRef(), this.sidechainBlockForgerActorRef(), this.params(), this.timeProvider(), this.actorSystem(), this.executionContext());
        this.rpcHandler = new RpcHandler(new EthService(this.nodeViewHolderRef(), this.networkControllerRef(), this.settings().restApi().timeout(), this.params(), super.sidechainSettings().ethService(), super.sidechainSettings().sparkzSettings().network().maxIncomingConnections(), RpcUtils$.MODULE$.getClientVersion(), this.sidechainTransactionActorRef(), this.syncStatusActorRef(), this.sidechainTransactionsCompanion()));
        this.rpcProcessor = new RpcProcessor(this.rpcHandler());
        if (super.sidechainSettings().websocketServer().wsServer()) {
            ActorRef webSocketServerActor = WebSocketAccountServerRef$.MODULE$.apply(this.nodeViewHolderRef(), this.rpcProcessor(), super.sidechainSettings().websocketServer(), this.actorSystem(), this.executionContext());
        }
        this.nodeViewProvider = new NodeViewProviderImpl<AccountTransaction<Proposition, Proof<Proposition>>, AccountBlockHeader, AccountBlock, AccountFeePaymentsInfo, NodeAccountHistory, NodeAccountState, NodeWalletBase, NodeAccountMemoryPool, AccountNodeView>(this.nodeViewHolderRef());
        this.actorSystem().eventStream().publish((Object)SidechainAppEvents$SidechainApplicationStart$.MODULE$);
        this.transactionSubmitProvider = new TransactionSubmitProviderImpl<AccountTransaction<Proposition, Proof<Proposition>>>(this.sidechainTransactionActorRef());
    }
}

