package io.horizen.vrf;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import io.horizen.cryptolibprovider.CryptoLibProvider;
import io.horizen.json.Views;
import io.horizen.utils.BytesUtils;
import sparkz.core.serialization.BytesSerializable;
import sparkz.core.serialization.SparkzSerializer;

import java.util.Arrays;

@JsonView(Views.Default.class)
public class VrfOutput implements BytesSerializable {
    public static final int OUTPUT_LENGTH = CryptoLibProvider.vrfFunctions().vrfOutputLen();

    @JsonProperty("bytes")
    final byte[] vrfOutputBytes;

    public VrfOutput(byte[] bytes) {
        if (bytes.length != OUTPUT_LENGTH)
            throw new IllegalArgumentException(String.format("Incorrect output length, %d expected, %d found", OUTPUT_LENGTH,
                    bytes.length));

        vrfOutputBytes = Arrays.copyOf(bytes, bytes.length);
    }

    @Override
    public byte[] bytes() {
        return serializer().toBytes(this);
    }

    @Override
    public SparkzSerializer serializer() {
        return VrfOutputSerializer.getSerializer();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        VrfOutput vrfOutput = (VrfOutput) o;
        return Arrays.equals(vrfOutputBytes, vrfOutput.vrfOutputBytes);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(vrfOutputBytes);
    }

    @Override
    public String toString() {
        return "VrfOutput{" +
                "vrfOutputBytes=" + BytesUtils.toHexString(vrfOutputBytes) +
                '}';
    }
}
