/*
 * Decompiled with CFR 0.152.
 */
package io.horizen;

import at.favre.lib.crypto.bcrypt.BCrypt;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.horizen.SidechainModel;
import io.horizen.account.secret.PrivateKeySecp256k1;
import io.horizen.account.secret.PrivateKeySecp256k1Creator;
import io.horizen.block.MainchainBlockReference;
import io.horizen.block.MainchainBlockReferenceData;
import io.horizen.block.SidechainCreationVersions;
import io.horizen.block.SidechainsVersionsManager;
import io.horizen.companion.SidechainSecretsCompanion;
import io.horizen.cryptolibprovider.CircuitTypes;
import io.horizen.cryptolibprovider.CryptoLibProvider;
import io.horizen.fork.ForkConfigurator;
import io.horizen.fork.ForkManager;
import io.horizen.params.MainNetParams;
import io.horizen.params.NetworkParams;
import io.horizen.params.RegTestParams;
import io.horizen.params.TestNetParams;
import io.horizen.proof.VrfProof;
import io.horizen.secret.PrivateKey25519;
import io.horizen.secret.PrivateKey25519Creator;
import io.horizen.secret.SchnorrKeyGenerator;
import io.horizen.secret.SchnorrSecret;
import io.horizen.secret.VrfKeyGenerator;
import io.horizen.secret.VrfSecretKey;
import io.horizen.tools.utils.Command;
import io.horizen.tools.utils.CommandProcessor;
import io.horizen.tools.utils.MessagePrinter;
import io.horizen.transaction.MC2SCAggregatedTransaction;
import io.horizen.transaction.mainchain.SidechainCreation;
import io.horizen.transaction.mainchain.SidechainRelatedMainchainOutput;
import io.horizen.utils.AbstractSidechainsVersionsManager;
import io.horizen.utils.ByteArrayWrapper;
import io.horizen.utils.BytesUtils;
import io.horizen.utils.CompactSize;
import io.horizen.utils.MerklePath;
import io.horizen.utils.NewSidechainsVersionsManager;
import io.horizen.utils.OldSidechainsVersionsManager;
import io.horizen.vrf.VrfOutput;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import scala.Enumeration;
import scala.Tuple4;

public class ScBootstrappingToolCommandProcessor
extends CommandProcessor {
    private static boolean dlogKeyInit = false;
    private static final int maxSeedLength = 1000;
    private static final int minSeedLength = 6;
    private final SidechainModel<?> scModel;

    private static boolean initDlogKey() {
        if (dlogKeyInit) {
            return true;
        }
        if (!CryptoLibProvider.commonCircuitFunctions().generateCoboundaryMarlinDLogKeys()) {
            return false;
        }
        dlogKeyInit = true;
        return true;
    }

    public ScBootstrappingToolCommandProcessor(MessagePrinter printer, SidechainModel<?> scModel) {
        super(printer);
        this.scModel = scModel;
    }

    public void processCommand(String input) throws Exception {
        Command command = this.parseCommand(input);
        switch (command.name()) {
            case "help": {
                this.printUsageMsg();
                break;
            }
            case "generatekey": {
                this.processGenerateKey(command.data());
                break;
            }
            case "genesisinfo": {
                this.processGenesisInfo(command.data());
                break;
            }
            case "generateVrfKey": {
                this.processGenerateVrfKey(command.data());
                break;
            }
            case "generateAccountKey": {
                this.processGenerateAccountKey(command.data());
                break;
            }
            case "generateCertificateSignerKey": {
                this.processGenerateCertificateSignerKey(command.data());
                break;
            }
            case "generateCertProofInfo": {
                this.processGenerateCertProofInfo(command.data());
                break;
            }
            case "generateCertWithKeyRotationProofInfo": {
                this.processGenerateCertWithKeyRotationProofInfo(command.data());
                break;
            }
            case "generateCswProofInfo": {
                this.processGenerateCswProofInfo(command.data());
                break;
            }
            case "encodeString": {
                this.processEncodeString(command.data());
                break;
            }
            default: {
                this.printUnsupportedCommandMsg(command.name());
            }
        }
    }

    protected Command parseCommand(String input) throws IOException {
        JsonNode jsonNode;
        String jsonData;
        ObjectMapper objectMapper;
        String[] inputData;
        block17: {
            inputData = input.trim().split(" ", 2);
            if (inputData.length == 0) {
                throw new IOException(String.format("Error: unrecognized input structure '%s'.%nSee 'help' for usage guideline.", input));
            }
            objectMapper = new ObjectMapper();
            if (inputData.length == 1) {
                return new Command(inputData[0], (JsonNode)objectMapper.createObjectNode());
            }
            String commandArguments = inputData[1].trim();
            if (commandArguments.startsWith("-f ")) {
                String filePath = commandArguments.replaceAll("^-f\\s*\"*|\"$", "");
                try (FileReader file = new FileReader(filePath);
                     BufferedReader reader = new BufferedReader(file);){
                    jsonData = reader.readLine();
                    break block17;
                }
                catch (FileNotFoundException e) {
                    throw new IOException(String.format("Error: Input data file '%s' not found.%nSee 'help' for usage guideline.", filePath));
                }
            }
            jsonData = commandArguments;
        }
        try {
            jsonNode = objectMapper.readTree(jsonData);
        }
        catch (Exception e) {
            throw new IOException(String.format("Error: Invalid input data format '%s'. Json expected.%nSee 'help' for usage guideline.", jsonData));
        }
        return new Command(inputData[0], jsonNode);
    }

    protected void printUsageMsg() {
        this.printer.print("Usage:\n\tFrom command line: <program name> <command name> [<json data>]\n\tFor interactive mode: <command name> [<json data>]\n\tRead command arguments from file: <command name> -f <path to file with json data>\nSupported commands:\n\thelp\n\tgeneratekey <arguments>\n\tgenerateVrfKey <arguments>\n\tgenerateAccountKey <arguments>\n\tgenerateCertificateSignerKey <arguments>\n\tgenerateCertProofInfo <arguments>\n\tgenerateCswProofInfo <arguments>\n\tgenesisinfo <arguments>\n\texit\n");
    }

    private void printGenerateKeyUsageMsg(String error) {
        this.printer.print("Error: " + error);
        this.printer.print("Usage:\n\tgeneratekey {\"seed\":\"my seed\"} - seed can be any string from 6 up to 1000 characters long");
    }

    private void processGenerateKey(JsonNode json) {
        if (!json.has("seed") || !json.get("seed").isTextual()) {
            this.printGenerateKeyUsageMsg("seed is not specified or has invalid format.");
            return;
        }
        String seed = json.get("seed").asText();
        if (seed.length() < 6) {
            this.printGenerateKeyUsageMsg("seed is too short.");
            return;
        }
        if (seed.length() > 1000) {
            this.printGenerateKeyUsageMsg("seed is too long.");
            return;
        }
        PrivateKey25519 key = PrivateKey25519Creator.getInstance().generateSecret(seed.getBytes(StandardCharsets.UTF_8));
        SidechainSecretsCompanion secretsCompanion = new SidechainSecretsCompanion(new HashMap());
        ObjectNode resJson = new ObjectMapper().createObjectNode();
        resJson.put("secret", BytesUtils.toHexString((byte[])secretsCompanion.toBytes((Object)key)));
        resJson.put("publicKey", BytesUtils.toHexString((byte[])key.publicImage().bytes()));
        String res = resJson.toString();
        this.printer.print(res);
    }

    private void printGenerateVrfKeyUsageMsg(String error) {
        this.printer.print("Error: " + error);
        this.printer.print("Usage:\n\tgenerateVrfKey {\"seed\":\"my seed\"} - seed can be empty string or any string up to 1000 characters long");
    }

    private void processGenerateVrfKey(JsonNode json) {
        if (!json.has("seed") || !json.get("seed").isTextual()) {
            this.printGenerateVrfKeyUsageMsg("seed is not specified or has invalid format.");
            return;
        }
        SidechainSecretsCompanion secretsCompanion = new SidechainSecretsCompanion(new HashMap());
        String seed = json.get("seed").asText();
        if (seed.length() > 1000) {
            this.printGenerateKeyUsageMsg("seed is too long.");
            return;
        }
        VrfSecretKey vrfSecretKey = VrfKeyGenerator.getInstance().generateSecret(seed.getBytes(StandardCharsets.UTF_8));
        ObjectNode resJson = new ObjectMapper().createObjectNode();
        resJson.put("vrfSecret", BytesUtils.toHexString((byte[])secretsCompanion.toBytes((Object)vrfSecretKey)));
        resJson.put("vrfPublicKey", BytesUtils.toHexString((byte[])vrfSecretKey.getPublicBytes()));
        String res = resJson.toString();
        this.printer.print(res);
    }

    private void printGenerateAccountKeyUsageMsg(String error) {
        this.printer.print("Error: " + error);
        this.printer.print("Usage:\n\tgenerateAccountKey {\"seed\":\"my seed\"} - seed can be any string from 6 up to 1000 characters long");
    }

    private void processGenerateAccountKey(JsonNode json) {
        if (!json.has("seed") || !json.get("seed").isTextual()) {
            this.printGenerateAccountKeyUsageMsg("seed is not specified or has invalid format.");
            return;
        }
        String seed = json.get("seed").asText();
        if (seed.length() < 6) {
            this.printGenerateKeyUsageMsg("seed is too short.");
            return;
        }
        if (seed.length() > 1000) {
            this.printGenerateKeyUsageMsg("seed is too long.");
            return;
        }
        SidechainSecretsCompanion secretsCompanion = new SidechainSecretsCompanion(new HashMap());
        PrivateKeySecp256k1 secret = PrivateKeySecp256k1Creator.getInstance().generateSecret(seed.getBytes(StandardCharsets.UTF_8));
        ObjectNode resJson = new ObjectMapper().createObjectNode();
        resJson.put("accountSecret", BytesUtils.toHexString((byte[])secretsCompanion.toBytes((Object)secret)));
        resJson.put("accountProposition", BytesUtils.toHexString((byte[])secret.publicImage().pubKeyBytes()));
        String res = resJson.toString();
        this.printer.print(res);
    }

    private void printGenerateCertificateSignerKey(String error) {
        this.printer.print("Error: " + error);
        this.printer.print("Usage:\n\tgenerateCertificateSignerKey {\"seed\":\"my seed\"} - seed can be empty string or any string up to 1000 characters long");
    }

    private void processGenerateCertificateSignerKey(JsonNode json) {
        if (!json.has("seed") || !json.get("seed").isTextual()) {
            this.printGenerateCertificateSignerKey("seed is not specified or has invalid format.");
            return;
        }
        String seed = json.get("seed").asText();
        if (seed.length() > 1000) {
            this.printGenerateKeyUsageMsg("seed is too long.");
            return;
        }
        SchnorrSecret secretKey = SchnorrKeyGenerator.getInstance().generateSecret(seed.getBytes(StandardCharsets.UTF_8));
        ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
        ObjectNode resJson = mapper.createObjectNode();
        SidechainSecretsCompanion secretsCompanion = new SidechainSecretsCompanion(new HashMap());
        resJson.put("signerSecret", BytesUtils.toHexString((byte[])secretsCompanion.toBytes((Object)secretKey)));
        resJson.put("signerPublicKey", BytesUtils.toHexString((byte[])secretKey.getPublicBytes()));
        String res = resJson.toString();
        this.printer.print(res);
    }

    private void printGenerateCertProofInfoUsageMsg(String error) {
        this.printer.print("Error: " + error);
        this.printer.print("Usage:\n\tgenerateCertProofInfo {\"signersPublicKeys:\":\"[pk1, pk2, ...]\", \"threshold\":5, \"provingKeyPath\": \"/tmp/sidechain/snark_proving_key\", \"verificationKeyPath\": \"/tmp/sidechain/snark_verification_key\", \"isCSWEnabled\": true}\n\t - threshold parameter should be less or equal to keyCount.\n\t - isCSWEnabled parameter could be true or false.");
    }

    private void processGenerateCertProofInfo(JsonNode json) {
        String verificationKey;
        if (!json.has("signersPublicKeys") || !json.get("signersPublicKeys").isArray()) {
            this.printGenerateCertProofInfoUsageMsg("signersPublicKeys are missing or have unsupported format.");
            return;
        }
        ArrayList<String> publicKeys = new ArrayList<String>();
        Iterator pksIterator = json.get("signersPublicKeys").elements();
        while (pksIterator.hasNext()) {
            JsonNode pkNode = (JsonNode)pksIterator.next();
            if (!pkNode.isTextual()) {
                this.printGenerateCertProofInfoUsageMsg("wrong signersPublicKeys format");
                return;
            }
            publicKeys.add(pkNode.asText());
        }
        if (!json.has("threshold") || !json.get("threshold").isInt()) {
            this.printGenerateCertProofInfoUsageMsg("threshold is missing or it has unsupported format");
            return;
        }
        int threshold = json.get("threshold").asInt();
        if (threshold <= 0 || threshold > publicKeys.size()) {
            this.printGenerateCertProofInfoUsageMsg("threshold parameter should be greater than 0 and be less or equal to keyCount. Current value: " + threshold);
            return;
        }
        if (!json.has("provingKeyPath") || !json.get("provingKeyPath").isTextual()) {
            this.printGenerateCertProofInfoUsageMsg("wrong provingKeyPath value. Textual value expected.");
            return;
        }
        String provingKeyPath = json.get("provingKeyPath").asText();
        if (!json.has("verificationKeyPath") || !json.get("verificationKeyPath").isTextual()) {
            this.printGenerateCertProofInfoUsageMsg("wrong verificationKeyPath value. Textual value expected.");
            return;
        }
        String verificationKeyPath = json.get("verificationKeyPath").asText();
        if (!json.has("isCSWEnabled") || !json.get("isCSWEnabled").isBoolean()) {
            this.printGenerateCertProofInfoUsageMsg("wrong isCSWEnabled value. Boolean value expected.");
            return;
        }
        boolean isCSWEnabled = json.get("isCSWEnabled").asBoolean();
        SidechainSecretsCompanion secretsCompanion = new SidechainSecretsCompanion(new HashMap());
        if (!Files.exists(Paths.get(verificationKeyPath, new String[0]), new LinkOption[0])) {
            if (!ScBootstrappingToolCommandProcessor.initDlogKey()) {
                this.printer.print("Error occurred during dlog key generation.");
                return;
            }
            int numOfCustomFields = 0;
            if (isCSWEnabled) {
                numOfCustomFields = 2;
            }
            if (!CryptoLibProvider.sigProofThresholdCircuitFunctions().generateCoboundaryMarlinSnarkKeys((long)publicKeys.size(), provingKeyPath, verificationKeyPath, numOfCustomFields)) {
                this.printer.print("Error occurred during snark keys generation.");
                return;
            }
        }
        if ((verificationKey = CryptoLibProvider.commonCircuitFunctions().getCoboundaryMarlinSnarkVerificationKeyHex(verificationKeyPath)).isEmpty()) {
            this.printer.print("Verification key file is empty or the key is broken.");
            return;
        }
        List publicKeysBytes = publicKeys.stream().map(BytesUtils::fromHexString).collect(Collectors.toList());
        String genSysConstant = BytesUtils.toHexString((byte[])CryptoLibProvider.sigProofThresholdCircuitFunctions().generateSysDataConstant(publicKeysBytes, (long)threshold));
        ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
        ObjectNode resJson = mapper.createObjectNode();
        resJson.put("maxPks", publicKeys.size());
        resJson.put("threshold", threshold);
        resJson.put("genSysConstant", genSysConstant);
        resJson.put("verificationKey", verificationKey);
        ArrayNode keyArrayNode = resJson.putArray("schnorrPublicKeys");
        for (String publicKeyStr : publicKeys) {
            keyArrayNode.add(publicKeyStr);
        }
        String res = resJson.toString();
        this.printer.print(res);
    }

    private void printGenerateCertWithKeyRotationProofInfoUsageMsg(String error) {
        this.printer.print("Error: " + error);
        this.printer.print("Usage:\n\tgenerateCertWithKeyRotationProofInfo {\"signersPublicKeys\": [signerPk1, signerPk2, ...], \"mastersPublicKeys\": [masterPk1, masterPk2, ...],\", \"threshold\":5, signersPublicKeys and mastersPublicKeys size should be equal,\"provingKeyPath\": \"/tmp/sidechain/snark_proving_key\", \"verificationKeyPath\": \"/tmp/sidechain/snark_verification_key\"}\n\t - threshold parameter should be less or equal to keyCount.");
    }

    private void processGenerateCertWithKeyRotationProofInfo(JsonNode json) throws Exception {
        String verificationKey;
        if (!json.has("signersPublicKeys") || !json.get("signersPublicKeys").isArray()) {
            this.printGenerateCertWithKeyRotationProofInfoUsageMsg("signersPublicKeys are missing or have unsupported format.");
            return;
        }
        ArrayList<String> signersPublicKeys = new ArrayList<String>();
        Iterator pksIterator = json.get("signersPublicKeys").elements();
        int index = 1;
        while (pksIterator.hasNext()) {
            JsonNode pkNode = (JsonNode)pksIterator.next();
            if (!pkNode.isTextual()) {
                this.printGenerateCertWithKeyRotationProofInfoUsageMsg("wrong signersPublicKeys format");
                return;
            }
            String pk = pkNode.asText();
            int duplicateIndex = signersPublicKeys.indexOf(pk);
            if (duplicateIndex != -1) {
                this.printGenerateCertWithKeyRotationProofInfoUsageMsg(String.format("signersKeys contains duplicate values. SignersKey with index %d is identical to signersKey with index %d.", duplicateIndex + 1, index));
                return;
            }
            signersPublicKeys.add(pk);
            ++index;
        }
        if (!json.has("mastersPublicKeys") || !json.get("mastersPublicKeys").isArray()) {
            this.printGenerateCertWithKeyRotationProofInfoUsageMsg("mastersPublicKeys are missing or have unsupported format.");
            return;
        }
        ArrayList<String> mastersPublicKeys = new ArrayList<String>();
        Iterator mastersPublicKeysIterator = json.get("mastersPublicKeys").elements();
        index = 1;
        while (mastersPublicKeysIterator.hasNext()) {
            JsonNode pkNode = (JsonNode)mastersPublicKeysIterator.next();
            if (!pkNode.isTextual()) {
                this.printGenerateCertWithKeyRotationProofInfoUsageMsg("wrong mastersPublicKeys format");
                return;
            }
            String masterKey = pkNode.asText();
            int duplicateIndex = mastersPublicKeys.indexOf(masterKey);
            if (duplicateIndex != -1) {
                this.printGenerateCertWithKeyRotationProofInfoUsageMsg(String.format("masterKeys contains duplicate values. MasterKey with index %d is identical to masterKey with index %d.", duplicateIndex + 1, index));
                return;
            }
            mastersPublicKeys.add(masterKey);
            ++index;
        }
        if (mastersPublicKeys.size() != signersPublicKeys.size()) {
            this.printGenerateCertWithKeyRotationProofInfoUsageMsg(String.format("the number of signer keys must be equal to the number of master keys.", new Object[0]));
            return;
        }
        for (int i = 0; i < mastersPublicKeys.size(); ++i) {
            int duplicateIndex = signersPublicKeys.indexOf(mastersPublicKeys.get(i));
            if (duplicateIndex == -1) continue;
            this.printGenerateCertWithKeyRotationProofInfoUsageMsg(String.format("duplicated keys are found. SignersKey with index %d equals to mastersKey with index %d", duplicateIndex, i));
            return;
        }
        if (!json.has("threshold") || !json.get("threshold").isInt()) {
            this.printGenerateCertWithKeyRotationProofInfoUsageMsg("threshold is missing or it has unsupported format");
            return;
        }
        int threshold = json.get("threshold").asInt();
        if (threshold <= 0 || threshold > signersPublicKeys.size()) {
            this.printGenerateCertWithKeyRotationProofInfoUsageMsg("threshold parameter should be greater than 0 and be less than or equal to keyCount. Current value: " + threshold);
            return;
        }
        if (!json.has("provingKeyPath") || !json.get("provingKeyPath").isTextual()) {
            this.printGenerateCertWithKeyRotationProofInfoUsageMsg("wrong provingKeyPath value. Textual value expected.");
            return;
        }
        String provingKeyPath = json.get("provingKeyPath").asText();
        if (!json.has("verificationKeyPath") || !json.get("verificationKeyPath").isTextual()) {
            this.printGenerateCertWithKeyRotationProofInfoUsageMsg("wrong verificationKeyPath value. Textual value expected.");
            return;
        }
        String verificationKeyPath = json.get("verificationKeyPath").asText();
        SidechainSecretsCompanion secretsCompanion = new SidechainSecretsCompanion(new HashMap());
        if (!Files.exists(Paths.get(verificationKeyPath, new String[0]), new LinkOption[0])) {
            if (!ScBootstrappingToolCommandProcessor.initDlogKey()) {
                this.printer.print("Error occurred during dlog key generation.");
                return;
            }
            if (!CryptoLibProvider.thresholdSignatureCircuitWithKeyRotation().generateCoboundaryMarlinSnarkKeys((long)signersPublicKeys.size(), provingKeyPath, verificationKeyPath)) {
                this.printer.print("Error occurred during snark keys generation.");
                return;
            }
        }
        if ((verificationKey = CryptoLibProvider.commonCircuitFunctions().getCoboundaryMarlinSnarkVerificationKeyHex(verificationKeyPath)).isEmpty()) {
            this.printer.print("Verification key file is empty or the key is broken.");
            return;
        }
        List signersPublicKeysBytes = signersPublicKeys.stream().map(BytesUtils::fromHexString).collect(Collectors.toList());
        List mastersPublicKeysBytes = mastersPublicKeys.stream().map(BytesUtils::fromHexString).collect(Collectors.toList());
        String genSysConstant = BytesUtils.toHexString((byte[])CryptoLibProvider.thresholdSignatureCircuitWithKeyRotation().generateSysDataConstant(signersPublicKeysBytes, mastersPublicKeysBytes, (long)threshold));
        ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
        ObjectNode resJson = mapper.createObjectNode();
        resJson.put("maxPks", signersPublicKeys.size());
        resJson.put("threshold", threshold);
        resJson.put("genSysConstant", genSysConstant);
        resJson.put("verificationKey", verificationKey);
        ArrayNode signingKeyArrayNode = resJson.putArray("signersPublicKeys");
        for (String string : signersPublicKeys) {
            signingKeyArrayNode.add(string);
        }
        ArrayNode masterKeyArrayNode = resJson.putArray("mastersPublicKeys");
        for (String publicKeyStr : mastersPublicKeys) {
            masterKeyArrayNode.add(publicKeyStr);
        }
        String string = resJson.toString();
        this.printer.print(string);
    }

    private void printGenerateCswProofInfoUsageMsg(String error) {
        this.printer.print("Error: " + error);
        this.printer.print("Usage:\n\tgenerateCswProofInfo {\"withdrawalEpochLen\":100, \"provingKeyPath\": \"/tmp/sidechain/csw_proving_key\", \"verificationKeyPath\": \"/tmp/sidechain/csw_verification_key\" }");
    }

    private void printEncodeStringUsageMsg(String error) {
        this.printer.print("Error: " + error);
        this.printer.print("Usage:\n\tencodeString {\"string\":\"string_to_encode\"}");
    }

    private void processGenerateCswProofInfo(JsonNode json) {
        String verificationKey;
        if (!json.has("withdrawalEpochLen") || !json.get("withdrawalEpochLen").isInt()) {
            this.printGenerateCswProofInfoUsageMsg("wrong withdrawalEpochLen");
            return;
        }
        int withdrawalEpochLen = json.get("withdrawalEpochLen").asInt();
        if (withdrawalEpochLen <= 0) {
            this.printGenerateCswProofInfoUsageMsg("wrong withdrawalEpochLen: " + withdrawalEpochLen);
            return;
        }
        if (!json.has("provingKeyPath") || !json.get("provingKeyPath").isTextual()) {
            this.printGenerateCswProofInfoUsageMsg("wrong provingKeyPath value. Textual value expected.");
            return;
        }
        String provingKeyPath = json.get("provingKeyPath").asText();
        if (!json.has("verificationKeyPath") || !json.get("verificationKeyPath").isTextual()) {
            this.printGenerateCswProofInfoUsageMsg("wrong verificationKeyPath value. Textual value expected.");
            return;
        }
        String verificationKeyPath = json.get("verificationKeyPath").asText();
        if (!Files.exists(Paths.get(verificationKeyPath, new String[0]), new LinkOption[0])) {
            if (!ScBootstrappingToolCommandProcessor.initDlogKey()) {
                this.printer.print("Error occurred during dlog key generation.");
                return;
            }
            if (!CryptoLibProvider.cswCircuitFunctions().generateCoboundaryMarlinSnarkKeys(withdrawalEpochLen, provingKeyPath, verificationKeyPath)) {
                this.printer.print("Error occurred during snark keys generation.");
                return;
            }
        }
        if ((verificationKey = CryptoLibProvider.commonCircuitFunctions().getCoboundaryMarlinSnarkVerificationKeyHex(verificationKeyPath)).isEmpty()) {
            this.printer.print("Verification key file is empty or the key is broken.");
            return;
        }
        ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
        ObjectNode resJson = mapper.createObjectNode();
        resJson.put("withdrawalEpochLen", withdrawalEpochLen);
        resJson.put("verificationKey", verificationKey);
        String res = resJson.toString();
        this.printer.print(res);
    }

    private void processEncodeString(JsonNode json) {
        if (!json.has("string") || !json.get("string").isTextual()) {
            this.printEncodeStringUsageMsg("wrong string");
            return;
        }
        String toEncode = json.get("string").asText();
        String encoded = BCrypt.with((BCrypt.Version)BCrypt.Version.VERSION_2Y).hashToString(8, toEncode.toCharArray());
        ObjectNode resJson = new ObjectMapper().createObjectNode();
        resJson.put("encodedString", encoded);
        String res = resJson.toString();
        this.printer.print(res);
    }

    private void printGenesisInfoUsageMsg(String error) {
        this.printer.print("Error: " + error);
        this.printer.print("Usage:\n\tgenesisinfo {\n\t\t\"secret\": <secret hex>, - private key to sign the sc genesis block\n\t\t\"vrfSecret\": <vrf secret hex>, secret vrf key\n\t\t\"info\": <sc genesis info hex> - hex data retrieved from MC RPC call 'getscgenesisinfo'\n\t\t\"virtualWithdrawalEpochLength\": optional field used for non-ceasing sidechain to specify the cert generation frequency.\n\t\t\"updateconfig\": boolean - Optional. Default false. If true, put the results in a copy of source config.\n\t\t\"sourceconfig\": <path to in config file> - expected if 'updateconfig' = true.\n\t\t\"resultconfig\": <path to out config file> - expected if 'updateconfig' = true.\n\t\t\"model\": String - Optional, default = 'utxo', 'account' model.\n\t}");
        this.printer.print("Examples:\n\tgenesisinfo {\"secret\":\"78fa...e818\", \"info\":\"0001....ad11\"}\n\n\tgenesisinfo {\"secret\":\"78fa...e818\", \"info\":\"0001....ad11\", \"model\":\"account\"}\n\n\tgenesisinfo {\"secret\":\"78fa...e818\", \"info\":\"0001....ad11\", \n\t\"updateconfig\": true, \"sourceconfig\":\"./template.conf\", \"resultconfig\":\"./result.conf\"}");
    }

    private void processGenesisInfo(JsonNode json) {
        boolean shouldUpdateConfig;
        VrfSecretKey vrfSecretKey;
        byte[] vrfSecretBytes;
        PrivateKey25519 key;
        byte[] secretBytes;
        byte[] infoBytes;
        String model;
        if (!(json.has("info") && json.get("info").isTextual() && json.has("vrfSecret") && json.get("vrfSecret").isTextual() && json.has("secret") && json.get("secret").isTextual())) {
            this.printGenesisInfoUsageMsg("wrong arguments syntax.");
            return;
        }
        if (json.has("model")) {
            model = json.get("model").asText();
            if (!model.equals("account") && !model.equals("utxo")) {
                this.printGenesisInfoUsageMsg("Optional 'model' string field expected to be 'utxo' or 'account'.");
                return;
            }
        } else {
            model = "utxo";
        }
        SidechainSecretsCompanion secretsCompanion = new SidechainSecretsCompanion(new HashMap());
        String infoHex = json.get("info").asText();
        try {
            infoBytes = BytesUtils.fromHexString((String)infoHex);
        }
        catch (IllegalArgumentException e) {
            this.printGenesisInfoUsageMsg("'info' expected to be a hex string.");
            return;
        }
        String secretHex = json.get("secret").asText();
        try {
            secretBytes = BytesUtils.fromHexString((String)secretHex);
        }
        catch (IllegalArgumentException e) {
            this.printGenesisInfoUsageMsg("'secret' expected to be a hex string.");
            return;
        }
        try {
            key = (PrivateKey25519)secretsCompanion.parseBytes(secretBytes);
        }
        catch (Exception e) {
            this.printGenesisInfoUsageMsg("'secret' value is broken. Can't deserialize the key.");
            return;
        }
        String vrfSecretHex = json.get("vrfSecret").asText();
        try {
            vrfSecretBytes = BytesUtils.fromHexString((String)vrfSecretHex);
        }
        catch (IllegalArgumentException e) {
            this.printGenesisInfoUsageMsg("'secret' expected to be a hex string.");
            return;
        }
        try {
            vrfSecretKey = (VrfSecretKey)secretsCompanion.parseBytes(vrfSecretBytes);
        }
        catch (Exception e) {
            this.printGenesisInfoUsageMsg("'vrfSecret' value is broken. Can't deserialize the key.");
            return;
        }
        int virtualWithdrawalEpochLength = 0;
        if (json.has("virtualWithdrawalEpochLength")) {
            if (!json.get("virtualWithdrawalEpochLength").isInt()) {
                this.printGenesisInfoUsageMsg("'virtualWithdrawalEpochLength' should be integer.");
                return;
            }
            virtualWithdrawalEpochLength = json.get("virtualWithdrawalEpochLength").asInt();
            if (virtualWithdrawalEpochLength < 0) {
                this.printGenesisInfoUsageMsg("'virtualWithdrawalEpochLength' can't be negative.");
                return;
            }
        }
        boolean bl = shouldUpdateConfig = json.has("updateconfig") && json.get("updateconfig").asBoolean();
        if (!(!shouldUpdateConfig || json.has("sourceconfig") && json.get("sourceconfig").isTextual() && json.has("resultconfig") && json.get("resultconfig").isTextual())) {
            this.printGenesisInfoUsageMsg("'updateconfig' is specified but path to configs doesn't not.");
            return;
        }
        int offset = 0;
        try {
            boolean isNonCeasing;
            int withdrawalEpochLength;
            byte network = infoBytes[offset];
            byte[] scId = Arrays.copyOfRange(infoBytes, ++offset, offset + 32);
            CompactSize powDataLength = BytesUtils.getCompactSize((byte[])infoBytes, (int)(offset += 32));
            String powData = BytesUtils.toHexString((byte[])Arrays.copyOfRange(infoBytes, offset += powDataLength.size(), offset + (int)powDataLength.value() * 8));
            offset = (int)((long)offset + powDataLength.value() * 8L);
            int mcBlockHeight = BytesUtils.getReversedInt((byte[])infoBytes, (int)offset);
            CompactSize initialCumulativeCommTreeHashLength = BytesUtils.getCompactSize((byte[])infoBytes, (int)(offset += 4));
            byte[] initialCumulativeCommTreeHash = Arrays.copyOfRange(infoBytes, offset += initialCumulativeCommTreeHashLength.size(), offset + (int)initialCumulativeCommTreeHashLength.value());
            offset = (int)((long)offset + initialCumulativeCommTreeHashLength.value());
            byte[] rest = Arrays.copyOfRange(infoBytes, offset, infoBytes.length);
            Integer mcBlockLength = (Integer)((Tuple4)MainchainBlockReference.parseMainchainBlockBytes((byte[])rest).get())._4();
            byte[] mcBlockBytes = Arrays.copyOfRange(infoBytes, offset, offset + mcBlockLength);
            AbstractSidechainsVersionsManager versionsManager = null;
            if ((offset += mcBlockLength.intValue()) < infoBytes.length) {
                HashMap<ByteArrayWrapper, Enumeration.Value> scVersions = new HashMap<ByteArrayWrapper, Enumeration.Value>();
                CompactSize scSidechainVersionsLength = BytesUtils.getCompactSize((byte[])infoBytes, (int)offset);
                offset += scSidechainVersionsLength.size();
                int i = 0;
                while ((long)i < scSidechainVersionsLength.value()) {
                    byte[] sidechainId = Arrays.copyOfRange(infoBytes, offset, offset + 32);
                    byte version = infoBytes[offset += 32];
                    ++offset;
                    scVersions.put(new ByteArrayWrapper(sidechainId), SidechainCreationVersions.getVersion((int)version));
                    ++i;
                }
                versionsManager = new NewSidechainsVersionsManager(scVersions);
            } else {
                versionsManager = new OldSidechainsVersionsManager();
            }
            String mcNetworkName = this.getNetworkName(network);
            NetworkParams params = this.getNetworkParams(network, scId, false);
            MainchainBlockReference mcRef = (MainchainBlockReference)MainchainBlockReference.create((byte[])mcBlockBytes, (NetworkParams)params, (SidechainsVersionsManager)versionsManager).get();
            SidechainCreation sidechainCreation = null;
            if (mcRef.data().sidechainRelatedAggregatedTransaction().isEmpty()) {
                throw new IllegalArgumentException("Sidechain related data is not found in genesisinfo mc block.");
            }
            for (SidechainRelatedMainchainOutput output : ((MC2SCAggregatedTransaction)mcRef.data().sidechainRelatedAggregatedTransaction().get()).mc2scTransactionsOutputs()) {
                if (!(output instanceof SidechainCreation)) continue;
                sidechainCreation = (SidechainCreation)output;
            }
            boolean isNewCircuit = sidechainCreation.getScCrOutput().fieldElementCertificateFieldConfigs().length() == 32;
            params = this.getNetworkParams(network, scId, isNewCircuit);
            if (sidechainCreation == null) {
                throw new IllegalArgumentException("Sidechain creation transaction is not found in genesisinfo mc block.");
            }
            byte[] vrfMessage = "!SomeVrfMessage1!SomeVrfMessage2".getBytes(StandardCharsets.UTF_8);
            VrfProof vrfProof = (VrfProof)vrfSecretKey.prove(vrfMessage).getKey();
            VrfOutput vrfOutput = (VrfOutput)vrfProof.proofToVrfOutput(vrfSecretKey.publicImage(), vrfMessage).get();
            MerklePath mp = new MerklePath(new ArrayList());
            ForkManager.reset();
            ForkManager.init((ForkConfigurator)this.scModel.getForkConfigurator(), (String)mcNetworkName);
            Object blockBase = this.scModel.buildScGenesisBlock(mcRef, sidechainCreation, json, key, vrfProof, vrfOutput, mp, params);
            try {
                SidechainCreation creationOutput = (SidechainCreation)((MC2SCAggregatedTransaction)((MainchainBlockReferenceData)blockBase.mainchainBlockReferencesData().head()).sidechainRelatedAggregatedTransaction().get()).mc2scTransactionsOutputs().get(0);
                withdrawalEpochLength = creationOutput.withdrawalEpochLength();
            }
            catch (Exception e) {
                this.printGenesisInfoUsageMsg("'info' data is corrupted: MainchainBlock expected to contain a valid Transaction with a Sidechain Creation output.");
                return;
            }
            String sidechainBlockHex = BytesUtils.toHexString((byte[])blockBase.bytes());
            boolean bl2 = isNonCeasing = withdrawalEpochLength == 0;
            if (isNonCeasing && virtualWithdrawalEpochLength == 0) {
                this.printGenesisInfoUsageMsg("For non-ceasing sidechains virtualWithdrawalEpochLength must be specified.");
                return;
            }
            if (!isNonCeasing && virtualWithdrawalEpochLength != 0) {
                this.printGenesisInfoUsageMsg("For ceasing sidechains virtualWithdrawalEpochLength must not be specified.");
                return;
            }
            if (isNonCeasing && virtualWithdrawalEpochLength < params.minVirtualWithdrawalEpochLength()) {
                this.printGenesisInfoUsageMsg(String.format("Virtual withdrawal epoch length is too short. It should be at least %d for %s network.", params.minVirtualWithdrawalEpochLength(), mcNetworkName));
                return;
            }
            ObjectNode resJson = new ObjectMapper().createObjectNode();
            resJson.put("scId", BytesUtils.toHexString((byte[])BytesUtils.reverseBytes((byte[])scId)));
            resJson.put("scGenesisBlockHex", sidechainBlockHex);
            resJson.put("powData", powData);
            resJson.put("mcBlockHeight", mcBlockHeight);
            resJson.put("mcNetwork", mcNetworkName);
            resJson.put("isNonCeasing", isNonCeasing);
            resJson.put("withdrawalEpochLength", isNonCeasing ? virtualWithdrawalEpochLength : withdrawalEpochLength);
            resJson.put("initialCumulativeCommTreeHash", BytesUtils.toHexString((byte[])initialCumulativeCommTreeHash));
            String res = resJson.toString();
            this.printer.print(res);
            if (shouldUpdateConfig) {
                this.updateTemplateFile(json.get("sourceconfig").asText(), json.get("resultconfig").asText(), mcBlockHeight, powData, BytesUtils.toHexString((byte[])scId), sidechainBlockHex, mcNetworkName, withdrawalEpochLength, BytesUtils.toHexString((byte[])initialCumulativeCommTreeHash));
            }
        }
        catch (Exception e) {
            this.printer.print(String.format("Error: 'info' data is corrupted: %s", e.getMessage()));
        }
    }

    private String getNetworkName(byte network) {
        switch (network) {
            case 0: {
                return "mainnet";
            }
            case 1: {
                return "testnet";
            }
            case 2: {
                return "regtest";
            }
        }
        return "";
    }

    private NetworkParams getNetworkParams(byte network, byte[] scId, boolean isNewCircuit) {
        Enumeration.Value circuitType = isNewCircuit ? CircuitTypes.NaiveThresholdSignatureCircuitWithKeyRotation() : CircuitTypes.NaiveThresholdSignatureCircuit();
        switch (network) {
            case 0: {
                return new MainNetParams(scId, null, null, null, null, 1, 0, 100L, null, null, circuitType, 0, null, null, null, null, null, null, null, false, null, null, 11111111L, true, false, true, 0);
            }
            case 1: {
                return new TestNetParams(scId, null, null, null, null, 1, 0, 100L, null, null, circuitType, 0, null, null, null, null, null, null, null, false, null, null, 11111111L, true, false, true, 0);
            }
            case 2: {
                return new RegTestParams(scId, null, null, null, null, 1, 0, 100L, null, null, circuitType, 0, null, null, null, null, null, null, null, false, null, null, 11111111L, true, false, true, 0);
            }
        }
        throw new IllegalStateException("Unexpected network type: " + network);
    }

    private void updateTemplateFile(String pathToSourceConfig, String pathToResultConf, int mcBlockHeight, String powData, String scId, String scBlockHex, String mcNetworkName, int withdrawalEpochLength, String initialCumulativeCommTreeHashHex) {
        try {
            String templateConf = new String(Files.readAllBytes(Paths.get(pathToSourceConfig, new String[0])), StandardCharsets.UTF_8);
            String conf = templateConf + "\nsparkz {\n\tgenesis {\n\t\tscGenesisBlockHex = \"" + scBlockHex + "\"\n\t\tscId = \"" + scId + "\"\n\t\tpowData = \"" + powData + "\"\n\t\tmcBlockHeight = " + mcBlockHeight + "\n\t\tmcNetwork = " + mcNetworkName + "\n\t\twithdrawalEpochLength = " + withdrawalEpochLength + "\n\t\tinitialCumulativeCommTreeHash = \"" + initialCumulativeCommTreeHashHex + "\"\n\t}\n}\n";
            Files.write(Paths.get(pathToResultConf, new String[0]), conf.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (Exception e) {
            this.printer.print("Error: unable to open config file.");
        }
    }
}

