/*
 * Decompiled with CFR 0.152.
 */
package io.horizen;

import com.fasterxml.jackson.databind.JsonNode;
import io.horizen.SidechainModel;
import io.horizen.account.block.AccountBlock;
import io.horizen.account.companion.SidechainAccountTransactionsCompanion;
import io.horizen.account.fork.GasFeeFork;
import io.horizen.account.proposition.AddressProposition;
import io.horizen.account.state.AccountStateView;
import io.horizen.account.state.BaseAccountStateView;
import io.horizen.account.state.MessageProcessor;
import io.horizen.account.state.MessageProcessorInitializationException;
import io.horizen.account.state.MessageProcessorUtil;
import io.horizen.account.storage.AccountStateMetadataStorageView;
import io.horizen.account.utils.AccountFeePaymentsUtils;
import io.horizen.account.utils.Bloom;
import io.horizen.account.utils.FeeUtils;
import io.horizen.account.utils.MainchainTxCrosschainOutputAddressUtil;
import io.horizen.block.MainchainBlockReference;
import io.horizen.block.MainchainBlockReferenceData;
import io.horizen.block.MainchainHeader;
import io.horizen.consensus.ForgingStakeInfo;
import io.horizen.evm.Database;
import io.horizen.evm.Hash;
import io.horizen.evm.MemoryDatabase;
import io.horizen.evm.StateDB;
import io.horizen.params.NetworkParams;
import io.horizen.params.RegTestParams;
import io.horizen.proof.VrfProof;
import io.horizen.secret.PrivateKey25519;
import io.horizen.transaction.mainchain.SidechainCreation;
import io.horizen.utils.MerklePath;
import io.horizen.vrf.VrfOutput;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import scala.Option;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public abstract class AbstractAccountModel
implements SidechainModel<AccountBlock> {
    private static final String model = "account";

    @Override
    public String getModelName() {
        return model;
    }

    @Override
    public AccountBlock buildScGenesisBlock(MainchainBlockReference mcRef, SidechainCreation sidechainCreation, JsonNode json, PrivateKey25519 key, VrfProof vrfProof, VrfOutput vrfOutput, MerklePath mp, NetworkParams params) {
        byte[] stateRoot;
        byte blockVersion = AccountBlock.ACCOUNT_BLOCK_VERSION();
        byte[] feePaymentsHash = AccountFeePaymentsUtils.DEFAULT_ACCOUNT_FEE_PAYMENTS_HASH();
        try {
            stateRoot = this.getGenesisStateRoot(mcRef, params);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Error: 'Could not get genesis state root: %s", e.getMessage()));
        }
        byte[] receiptsRoot = StateDB.EMPTY_ROOT_HASH.toBytes();
        AddressProposition forgerAddress = new AddressProposition(MainchainTxCrosschainOutputAddressUtil.getAccountAddress((byte[])sidechainCreation.getScCrOutput().address()));
        BigInteger baseFee = FeeUtils.INITIAL_BASE_FEE();
        BigInteger gasUsed = BigInteger.ZERO;
        BigInteger gasLimit = GasFeeFork.get((int)0).blockGasLimit();
        SidechainAccountTransactionsCompanion sidechainTransactionsCompanion = new SidechainAccountTransactionsCompanion(new HashMap());
        ForgingStakeInfo forgingStakeInfo = sidechainCreation.getAccountForgerStakeInfo();
        Bloom logsBloom = new Bloom();
        long currentTimeSeconds = System.currentTimeMillis() / 1000L;
        int regtestBlockTimestampRewind = json.has("regtestBlockTimestampRewind") ? json.get("regtestBlockTimestampRewind").asInt() : 0;
        long timestamp = params instanceof RegTestParams ? currentTimeSeconds - (long)regtestBlockTimestampRewind : currentTimeSeconds;
        List<MainchainBlockReferenceData> mainchainBlockReferencesData = Collections.singletonList(mcRef.data());
        List<MainchainHeader> mainchainHeadersData = Collections.singletonList(mcRef.header());
        return (AccountBlock)AccountBlock.create((String)params.sidechainGenesisBlockParentId(), (byte)blockVersion, (long)timestamp, (Seq)((Iterable)JavaConverters.collectionAsScalaIterableConverter(mainchainBlockReferencesData).asScala()).toSeq(), (Seq)((Iterable)JavaConverters.collectionAsScalaIterableConverter(new ArrayList()).asScala()).toSeq(), (Seq)((Iterable)JavaConverters.collectionAsScalaIterableConverter(mainchainHeadersData).asScala()).toSeq(), (Seq)((Iterable)JavaConverters.collectionAsScalaIterableConverter(new ArrayList()).asScala()).toSeq(), (PrivateKey25519)key, (ForgingStakeInfo)forgingStakeInfo, (VrfProof)vrfProof, (VrfOutput)vrfOutput, (MerklePath)mp, (byte[])feePaymentsHash, (byte[])stateRoot, (byte[])receiptsRoot, (AddressProposition)forgerAddress, (BigInteger)baseFee, (BigInteger)gasUsed, (BigInteger)gasLimit, (SidechainAccountTransactionsCompanion)sidechainTransactionsCompanion, (Bloom)logsBloom, (Option)Option.empty()).get();
    }

    protected byte[] getGenesisStateRoot(MainchainBlockReference mcRef, NetworkParams params) throws MessageProcessorInitializationException {
        AccountStateView view;
        List<MainchainBlockReferenceData> mainchainBlockReferencesData = Collections.singletonList(mcRef.data());
        List<MessageProcessor> customMessageProcessors = this.getCustomMessageProcessors(params);
        Seq messageProcessorSeq = MessageProcessorUtil.getMessageProcessorSeq((NetworkParams)params, (Seq)JavaConverters.asScalaBuffer(customMessageProcessors));
        try (AccountStateView accountStateView = view = this.getStateView((Seq<MessageProcessor>)messageProcessorSeq);){
            Iterator iter = messageProcessorSeq.iterator();
            while (iter.hasNext()) {
                ((MessageProcessor)iter.next()).init((BaseAccountStateView)view);
            }
            for (MainchainBlockReferenceData mcBlockRefData : mainchainBlockReferencesData) {
                view.applyMainchainBlockReferenceData(mcBlockRefData);
            }
            Object object = view.getIntermediateRoot();
            return object;
        }
    }

    private AccountStateView getStateView(Seq<MessageProcessor> mps) {
        MemoryDatabase dbm = new MemoryDatabase();
        StateDB stateDb = new StateDB((Database)dbm, new Hash(AccountStateMetadataStorageView.DEFAULT_ACCOUNT_STATE_ROOT()));
        return new AccountStateView(null, stateDb, mps);
    }

    protected abstract List<MessageProcessor> getCustomMessageProcessors(NetworkParams var1);
}

