/*
 * Decompiled with CFR 0.152.
 */
package sparkz.crypto.authds.merkle.serialization;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArraySeq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.Try$;
import sparkz.crypto.authds.merkle.BatchMerkleProof;
import sparkz.crypto.authds.package$;
import sparkz.crypto.hash.CryptographicHash;

@ScalaSignature(bytes="\u0006\u0005\u0005}b\u0001\u0002\u000b\u0016\u0001\u0001B\u0001\u0002\u000b\u0001\u0003\u0006\u0004%\u0019!\u000b\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005U!)Q\n\u0001C\u0001\u001d\"91\u000b\u0001b\u0001\n\u0013!\u0006B\u0002-\u0001A\u0003%Q\u000bC\u0004Z\u0001\t\u0007I\u0011\u0002+\t\ri\u0003\u0001\u0015!\u0003V\u0011\u001dY\u0006A1A\u0005\nQCa\u0001\u0018\u0001!\u0002\u0013)\u0006bB/\u0001\u0005\u0004%I\u0001\u0016\u0005\u0007=\u0002\u0001\u000b\u0011B+\t\u000f}\u0003!\u0019!C\u0005)\"1\u0001\r\u0001Q\u0001\nUCQ!\u0019\u0001\u0005\u0002\tDQa\u001c\u0001\u0005\u0002ADa!\u001f\u0001\u0005\u0002UQ\b\u0002CA\f\u0001\u0011\u0005Q#!\u0007\t\u0011\u0005M\u0002\u0001\"\u0001\u0016\u0003kA\u0001\"!\u000f\u0001\t\u0003)\u00121\b\u0002\u001b\u0005\u0006$8\r['fe.dW\r\u0015:p_\u001a\u001cVM]5bY&TXM\u001d\u0006\u0003-]\tQb]3sS\u0006d\u0017N_1uS>t'B\u0001\r\u001a\u0003\u0019iWM]6mK*\u0011!dG\u0001\u0007CV$\b\u000eZ:\u000b\u0005qi\u0012AB2ssB$xNC\u0001\u001f\u0003\u0019\u0019\b/\u0019:lu\u000e\u0001QcA\u0011:YM\u0011\u0001A\t\t\u0003G\u0019j\u0011\u0001\n\u0006\u0002K\u0005)1oY1mC&\u0011q\u0005\n\u0002\u0007\u0003:L(+\u001a4\u0002\u0005!4W#\u0001\u0016\u0011\u0005-bC\u0002\u0001\u0003\u0006[\u0001\u0011\rA\f\u0002\u0003\u0011\u001a\u000b\"a\f\u001a\u0011\u0005\r\u0002\u0014BA\u0019%\u0005\u001dqu\u000e\u001e5j]\u001e\u00042a\r\u001c9\u001b\u0005!$BA\u001b\u001c\u0003\u0011A\u0017m\u001d5\n\u0005]\"$!E\"ssB$xn\u001a:ba\"L7\rS1tQB\u00111&\u000f\u0003\u0006u\u0001\u0011\ra\u000f\u0002\u0002\tF\u0011q\u0006\u0010\t\u0003{%s!AP$\u000f\u0005}2eB\u0001!F\u001d\t\tE)D\u0001C\u0015\t\u0019u$\u0001\u0004=e>|GOP\u0005\u0002=%\u0011A$H\u0005\u0003kmI!\u0001\u0013\u001b\u0002\u000fA\f7m[1hK&\u0011!j\u0013\u0002\t\t&<Wm\u001d;4e)\u0011\u0001\nN\u0001\u0004Q\u001a\u0004\u0013A\u0002\u001fj]&$h\bF\u0001P)\t\u0001&\u000b\u0005\u0003R\u0001aRS\"A\u000b\t\u000b!\u001a\u00019\u0001\u0016\u0002\u0015\u0011Lw-Z:u'&TX-F\u0001V!\t\u0019c+\u0003\u0002XI\t\u0019\u0011J\u001c;\u0002\u0017\u0011Lw-Z:u'&TX\rI\u0001\nS:$W\r_*ju\u0016\f!\"\u001b8eKb\u001c\u0016N_3!\u0003!\u0019\u0018\u000eZ3TSj,\u0017!C:jI\u0016\u001c\u0016N_3!\u0003-Ig\u000eZ5dKN\u001c\u0016N_3\u0002\u0019%tG-[2fgNK'0\u001a\u0011\u0002\u0015A\u0014xn\u001c4t'&TX-A\u0006qe>|gm]*ju\u0016\u0004\u0013!C:fe&\fG.\u001b>f)\t\u0019\u0017\u000eE\u0002$I\u001aL!!\u001a\u0013\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\r:\u0017B\u00015%\u0005\u0011\u0011\u0015\u0010^3\t\u000b)t\u0001\u0019A6\u0002\u0007\tl\u0007\u000fE\u0002m[bj\u0011aF\u0005\u0003]^\u0011\u0001CQ1uG\"lUM]6mKB\u0013xn\u001c4\u0002\u0017\u0011,7/\u001a:jC2L'0\u001a\u000b\u0003c^\u00042A];l\u001b\u0005\u0019(B\u0001;%\u0003\u0011)H/\u001b7\n\u0005Y\u001c(a\u0001+ss\")\u0001p\u0004a\u0001G\u0006)!-\u001f;fg\u0006q\u0011N\u001c3jG\u0016\u001cHk\u001c\"zi\u0016\u001cHCA2|\u0011\u0015a\b\u00031\u0001~\u0003\u001dIg\u000eZ5dKN\u0004RA`A\u0003\u0003\u0017q1a`A\u0002\u001d\r\t\u0015\u0011A\u0005\u0002K%\u0011\u0001\nJ\u0005\u0005\u0003\u000f\tIAA\u0002TKFT!\u0001\u0013\u0013\u0011\r\r\ni!VA\t\u0013\r\ty\u0001\n\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007u\n\u0019\"C\u0002\u0002\u0016-\u0013a\u0001R5hKN$\u0018!\u00049s_>47\u000fV8CsR,7\u000fF\u0002d\u00037Aq!!\b\u0012\u0001\u0004\ty\"\u0001\u0004qe>|gm\u001d\t\u0006}\u0006\u0015\u0011\u0011\u0005\t\bG\u00055\u0011\u0011CA\u0012!\u0011\t)#!\f\u000f\t\u0005\u001d\u00121\u0006\b\u0004\u007f\u0005%\u0012B\u0001\u000e\u001c\u0013\tA\u0015$\u0003\u0003\u00020\u0005E\"\u0001B*jI\u0016T!\u0001S\r\u0002!%tG-[2fg\u001a\u0013x.\u001c\"zi\u0016\u001cHcA?\u00028!)\u0001P\u0005a\u0001G\u0006y\u0001O]8pMN4%o\\7CsR,7\u000f\u0006\u0003\u0002 \u0005u\u0002\"\u0002=\u0014\u0001\u0004\u0019\u0007")
public class BatchMerkleProofSerializer<D extends byte[], HF extends CryptographicHash<D>> {
    private final HF hf;
    private final int digestSize;
    private final int indexSize;
    private final int sideSize;
    private final int indicesSize;
    private final int proofsSize;

    public HF hf() {
        return this.hf;
    }

    private int digestSize() {
        return this.digestSize;
    }

    private int indexSize() {
        return this.indexSize;
    }

    private int sideSize() {
        return this.sideSize;
    }

    private int indicesSize() {
        return this.indicesSize;
    }

    private int proofsSize() {
        return this.proofsSize;
    }

    public byte[] serialize(BatchMerkleProof<D> bmp) {
        return Bytes.concat((byte[][])new byte[][]{Ints.toByteArray((int)bmp.indices().size()), Ints.toByteArray((int)bmp.proofs().size()), this.indicesToBytes(bmp.indices()), this.proofsToBytes(bmp.proofs())});
    }

    public Try<BatchMerkleProof<D>> deserialize(byte[] bytes) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            if (bytes.length < 8) {
                throw new Error("Deserialization error, empty input.");
            }
            int numIndices = Ints.fromByteArray((byte[])((byte[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.byteArrayOps(bytes), 0, 4)));
            int numProofs = Ints.fromByteArray((byte[])((byte[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.byteArrayOps(bytes), 4, 8)));
            Tuple2 tuple2 = ArrayOps$.MODULE$.splitAt$extension(Predef$.MODULE$.byteArrayOps((byte[])ArrayOps$.MODULE$.drop$extension(Predef$.MODULE$.byteArrayOps(bytes), 8)), numIndices * this.indicesSize());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            byte[] indices = (byte[])tuple2._1();
            byte[] proofs = (byte[])tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)indices, (Object)proofs);
            Tuple2 tuple23 = tuple22;
            byte[] indices2 = (byte[])tuple23._1();
            byte[] proofs2 = (byte[])tuple23._2();
            if (indices2.length != numIndices * this.indicesSize() || proofs2.length != numProofs * this.proofsSize()) {
                throw new Error("Deserialization error, invalid input.");
            }
            return new BatchMerkleProof(this.indicesFromBytes(indices2), this.proofsFromBytes(proofs2), this.hf());
        });
    }

    public byte[] indicesToBytes(Seq<Tuple2<Object, byte[]>> indices) {
        return Bytes.concat((byte[][])new byte[][]{(byte[])((IterableOnceOps)((IterableOps)indices.map((Function1 & Serializable)i -> new Tuple2((Object)Ints.toByteArray((int)i._1$mcI$sp()), i._2()))).flatten((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            byte[] a = (byte[])tuple2._1();
            byte[] b = (byte[])tuple2._2();
            ArraySeq.ofByte ofByte2 = Predef$.MODULE$.wrapByteArray(Bytes.concat((byte[][])new byte[][]{a, b}));
            return ofByte2;
        })).toArray((ClassTag)ClassTag$.MODULE$.Byte())});
    }

    public byte[] proofsToBytes(Seq<Tuple2<byte[], Object>> proofs) {
        return Bytes.concat((byte[][])new byte[][]{(byte[])((IterableOnceOps)((IterableOps)proofs.map((Function1 & Serializable)p -> new Tuple2(p._1(), (Object)new byte[]{BoxesRunTime.unboxToByte((Object)p._2())}))).flatten((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                byte[] a = (byte[])tuple2._1();
                byte[] b = (byte[])tuple2._2();
                if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.byteArrayOps(a))) {
                    return Predef$.MODULE$.wrapByteArray(Bytes.concat((byte[][])new byte[][]{(byte[])Array$.MODULE$.ofDim(32, (ClassTag)ClassTag$.MODULE$.Byte()), b}));
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            byte[] a = (byte[])tuple2._1();
            byte[] b = (byte[])tuple2._2();
            return Predef$.MODULE$.wrapByteArray(Bytes.concat((byte[][])new byte[][]{a, b}));
        })).toArray((ClassTag)ClassTag$.MODULE$.Byte())});
    }

    public Seq<Tuple2<Object, byte[]>> indicesFromBytes(byte[] bytes) {
        return ArrayOps$.MODULE$.grouped$extension(Predef$.MODULE$.byteArrayOps(bytes), this.indicesSize()).map((Function1 & Serializable)b -> {
            int index = Ints.fromByteArray((byte[])((byte[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.byteArrayOps(b), 0, this.indexSize())));
            byte[] hash = (byte[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.byteArrayOps(b), this.indexSize(), this.indicesSize());
            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)index), (Object)hash);
        }).toSeq();
    }

    public Seq<Tuple2<byte[], Object>> proofsFromBytes(byte[] bytes) {
        return ArrayOps$.MODULE$.grouped$extension(Predef$.MODULE$.byteArrayOps(bytes), this.proofsSize()).map((Function1 & Serializable)b -> {
            byte[] hashBytes = (byte[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.byteArrayOps(b), 0, this.digestSize());
            byte[] hash = ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.byteArrayOps(hashBytes), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BatchMerkleProofSerializer.$anonfun$proofsFromBytes$2(x$1))) ? package$.MODULE$.EmptyByteArray() : hashBytes;
            byte side = BoxesRunTime.unboxToByte((Object)BoxesRunTime.boxToByte((byte)b[this.digestSize()]));
            return new Tuple2((Object)hash, (Object)BoxesRunTime.boxToByte((byte)side));
        }).toSeq();
    }

    public static final /* synthetic */ boolean $anonfun$proofsFromBytes$2(Object x$1) {
        return ((Object)BoxesRunTime.boxToByte((byte)((byte)0))).equals(x$1);
    }

    public BatchMerkleProofSerializer(HF hf) {
        this.hf = hf;
        this.digestSize = hf.DigestSize();
        this.indexSize = 4;
        this.sideSize = 1;
        this.indicesSize = this.digestSize() + this.indexSize();
        this.proofsSize = this.digestSize() + this.sideSize();
    }
}

