/*
 * Decompiled with CFR 0.152.
 */
package sparkz.crypto.authds.merkle;

import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArraySeq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import sparkz.crypto.authds.merkle.EmptyNode;
import sparkz.crypto.authds.merkle.EmptyRootNode;
import sparkz.crypto.authds.merkle.InternalNode;
import sparkz.crypto.authds.merkle.Leaf;
import sparkz.crypto.authds.merkle.MerkleTree;
import sparkz.crypto.authds.merkle.Node;
import sparkz.crypto.hash.CryptographicHash;

public final class MerkleTree$
implements Serializable {
    public static final MerkleTree$ MODULE$ = new MerkleTree$();
    private static final byte LeafPrefix = 0;
    private static final byte InternalNodePrefix = 1;

    public byte LeafPrefix() {
        return LeafPrefix;
    }

    public byte InternalNodePrefix() {
        return InternalNodePrefix;
    }

    public <D extends byte[]> MerkleTree<D> apply(Seq<byte[]> payload, CryptographicHash<D> hf) {
        Seq leafs = (Seq)payload.map((Function1 & Serializable)d -> new Leaf((byte[])d, hf));
        Map elementsIndex = leafs.indices().map((Function1 & Serializable)i -> MerkleTree$.$anonfun$apply$2(leafs, BoxesRunTime.unboxToInt((Object)i))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Node<D> topNode = this.calcTopNode(leafs, hf);
        return new MerkleTree<D>(topNode, (Map<ArraySeq.ofByte, Object>)elementsIndex);
    }

    public <D extends byte[]> Node<D> calcTopNode(Seq<Node<D>> nodes, CryptographicHash<D> hf) {
        Node<D> node;
        while (true) {
            if (nodes.isEmpty()) {
                node = new EmptyRootNode<D>(hf);
                break;
            }
            Seq nextNodes = nodes.grouped(2).map((Function1 & Serializable)lr -> new InternalNode((Node)lr.head(), lr.lengthCompare(2) == 0 ? (Node)lr.last() : new EmptyNode(hf), hf)).toSeq();
            if (nextNodes.lengthCompare(1) == 0) {
                node = (Node)nextNodes.head();
                break;
            }
            nodes = nextNodes;
        }
        return node;
    }

    public <D extends byte[]> MerkleTree<D> apply(Node<D> topNode, Map<ArraySeq.ofByte, Object> elementsHashIndex) {
        return new MerkleTree<D>(topNode, elementsHashIndex);
    }

    public <D extends byte[]> Option<Tuple2<Node<D>, Map<ArraySeq.ofByte, Object>>> unapply(MerkleTree<D> x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2(x$0.topNode(), x$0.elementsHashIndex()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(MerkleTree$.class);
    }

    public static final /* synthetic */ Tuple2 $anonfun$apply$2(Seq leafs$1, int i) {
        return new Tuple2((Object)new ArraySeq.ofByte(((Leaf)leafs$1.apply(i)).hash()), (Object)BoxesRunTime.boxToInteger((int)i));
    }

    private MerkleTree$() {
    }
}

