/*
 * Decompiled with CFR 0.152.
 */
package sparkz.crypto.signatures;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.math.ec.rfc8032.Ed25519;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Tuple2;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Try$;
import sparkz.crypto.hash.Sha256$;
import sparkz.crypto.signatures.EllipticCurveSignatureScheme;
import sparkz.crypto.signatures.SigningFunctions;
import sparkz.crypto.signatures.package$PrivateKey$;
import sparkz.crypto.signatures.package$PublicKey$;
import sparkz.crypto.signatures.package$Signature$;
import sparkz.util.SparkzLogging;
import supertagged.package;

public final class Ed25519$
implements EllipticCurveSignatureScheme,
SparkzLogging {
    public static final Ed25519$ MODULE$ = new Ed25519$();
    private static final int SignatureLength;
    private static final int KeyLength;
    private static Logger logger;

    static {
        SigningFunctions.$init$(MODULE$);
        StrictLogging.$init$((StrictLogging)MODULE$);
        SparkzLogging.$init$((SparkzLogging)MODULE$);
        SignatureLength = 64;
        KeyLength = 32;
    }

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    @Override
    public Tuple2<byte[], byte[]> createKeyPair() {
        return SigningFunctions.createKeyPair$(this);
    }

    public Logger logger() {
        return logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    @Override
    public int SignatureLength() {
        return SignatureLength;
    }

    @Override
    public int KeyLength() {
        return KeyLength;
    }

    @Override
    public Tuple2<byte[], byte[]> createKeyPair(byte[] seed) {
        Ed25519PrivateKeyParameters privateKey = new Ed25519PrivateKeyParameters(Sha256$.MODULE$.hash(seed), 0);
        Ed25519PublicKeyParameters publicKey = privateKey.generatePublicKey();
        return new Tuple2(package$PrivateKey$.MODULE$.$at$at(privateKey.getEncoded(), package.Tagger$.MODULE$.baseRaw()), package$PublicKey$.MODULE$.$at$at(publicKey.getEncoded(), package.Tagger$.MODULE$.baseRaw()));
    }

    @Override
    public byte[] sign(byte[] privateKey, byte[] message) {
        byte[] signature = new byte[64];
        Ed25519.sign((byte[])privateKey, (int)0, null, (byte[])message, (int)0, (int)message.length, (byte[])signature, (int)0);
        return (byte[])package$Signature$.MODULE$.$at$at(signature, package.Tagger$.MODULE$.baseRaw());
    }

    @Override
    public boolean verify(byte[] signature, byte[] message, byte[] publicKey) {
        return BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> Ed25519.verify((byte[])signature, (int)0, (byte[])publicKey, (int)0, (byte[])message, (int)0, (int)message.length)).recoverWith((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                BoxedUnit boxedUnit;
                A1 A1 = x1;
                if (Ed25519$.MODULE$.log().underlying().isDebugEnabled()) {
                    Ed25519$.MODULE$.log().underlying().debug("Error while message signature verification", A1);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                Failure failure = new Failure(A1);
                return (B1)failure;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
        }).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
    }

    private Ed25519$() {
    }
}

