/*
 * Decompiled with CFR 0.152.
 */
package sparkz.crypto.authds.merkle;

import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.WrappedArray;
import scala.runtime.BoxesRunTime;
import sparkz.crypto.authds.merkle.EmptyNode;
import sparkz.crypto.authds.merkle.EmptyRootNode;
import sparkz.crypto.authds.merkle.InternalNode;
import sparkz.crypto.authds.merkle.Leaf;
import sparkz.crypto.authds.merkle.MerkleTree;
import sparkz.crypto.authds.merkle.Node;
import sparkz.crypto.hash.CryptographicHash;

public final class MerkleTree$
implements Serializable {
    public static MerkleTree$ MODULE$;
    private final byte LeafPrefix;
    private final byte InternalNodePrefix;

    static {
        new MerkleTree$();
    }

    public byte LeafPrefix() {
        return this.LeafPrefix;
    }

    public byte InternalNodePrefix() {
        return this.InternalNodePrefix;
    }

    public <D extends byte[]> MerkleTree<D> apply(Seq<byte[]> payload, CryptographicHash<D> hf) {
        Seq leafs = (Seq)payload.map((Function1 & java.io.Serializable & Serializable)d -> new Leaf((byte[])d, hf), Seq$.MODULE$.canBuildFrom());
        Map elementsIndex = ((TraversableOnce)leafs.indices().map((Function1 & java.io.Serializable & Serializable)i -> MerkleTree$.$anonfun$apply$2(leafs, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Node<D> topNode = this.calcTopNode(leafs, hf);
        return new MerkleTree<D>(topNode, (Map<WrappedArray.ofByte, Object>)elementsIndex);
    }

    public <D extends byte[]> Node<D> calcTopNode(Seq<Node<D>> nodes, CryptographicHash<D> hf) {
        Node<D> node;
        while (true) {
            if (nodes.isEmpty()) {
                node = new EmptyRootNode<D>(hf);
                break;
            }
            Seq nextNodes = nodes.grouped(2).map((Function1 & java.io.Serializable & Serializable)lr -> new InternalNode((Node)lr.head(), lr.lengthCompare(2) == 0 ? (Node)lr.last() : new EmptyNode(hf), hf)).toSeq();
            if (nextNodes.lengthCompare(1) == 0) {
                node = (Node)nextNodes.head();
                break;
            }
            nodes = nextNodes;
        }
        return node;
    }

    public <D extends byte[]> MerkleTree<D> apply(Node<D> topNode, Map<WrappedArray.ofByte, Object> elementsHashIndex) {
        return new MerkleTree<D>(topNode, elementsHashIndex);
    }

    public <D extends byte[]> Option<Tuple2<Node<D>, Map<WrappedArray.ofByte, Object>>> unapply(MerkleTree<D> x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2(x$0.topNode(), x$0.elementsHashIndex()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ Tuple2 $anonfun$apply$2(Seq leafs$1, int i) {
        return new Tuple2((Object)new WrappedArray.ofByte(((Leaf)leafs$1.apply(i)).hash()), (Object)BoxesRunTime.boxToInteger((int)i));
    }

    private MerkleTree$() {
        MODULE$ = this;
        this.LeafPrefix = 0;
        this.InternalNodePrefix = 1;
    }
}

