/*
 * Decompiled with CFR 0.152.
 */
package sparkz.crypto.authds.avltree.batch;

import com.google.common.primitives.Ints;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Random;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sparkz.crypto.authds.avltree.batch.AuthenticatedTreeOps;
import sparkz.crypto.authds.avltree.batch.BatchAVLProver$;
import sparkz.crypto.authds.avltree.batch.BatchProofConstants;
import sparkz.crypto.authds.avltree.batch.InternalNode;
import sparkz.crypto.authds.avltree.batch.InternalProverNode;
import sparkz.crypto.authds.avltree.batch.Leaf;
import sparkz.crypto.authds.avltree.batch.Node;
import sparkz.crypto.authds.avltree.batch.Operation;
import sparkz.crypto.authds.avltree.batch.ProverLeaf;
import sparkz.crypto.authds.avltree.batch.ProverNodes;
import sparkz.crypto.authds.avltree.batch.ToStringHelper;
import sparkz.crypto.authds.package$ADValue$;
import sparkz.crypto.authds.package$Balance$;
import sparkz.crypto.authds.package$SerializedAdProof$;
import sparkz.crypto.hash.Blake2b256$;
import sparkz.crypto.hash.CryptographicHash;
import sparkz.util.SparkzEncoder;
import sparkz.util.SparkzEncoding;
import sparkz.util.SparkzLogging;
import sparkz.utils.ByteArray$;
import supertagged.package;

@ScalaSignature(bytes="\u0006\u0001\r5c\u0001B\u001f?\u0001%C\u0001\u0002\u001f\u0001\u0003\u0006\u0004%\t!\u001f\u0005\t{\u0002\u0011\t\u0011)A\u0005u\"Aa\u0010\u0001BC\u0002\u0013\u0005q\u0010\u0003\u0006\u0002\b\u0001\u0011\t\u0011)A\u0005\u0003\u0003A!\"!\u0003\u0001\u0005\u0003\u0005\u000b\u0011BA\u0006\u0011)\tI\u0002\u0001BC\u0002\u0013\u0005\u00111\u0004\u0005\u000b\u0003G\u0001!\u0011!Q\u0001\n\u0005u\u0001BCA\u0013\u0001\t\u0015\r\u0011b\u0001\u0002(!Q\u0011\u0011\b\u0001\u0003\u0002\u0003\u0006I!!\u000b\t\u000f\u0005m\u0002\u0001\"\u0001\u0002>!A\u0011Q\n\u0001C\u0002\u0013E\u0011\u0010C\u0004\u0002P\u0001\u0001\u000b\u0011\u0002>\t\u0015\u0005E\u0003\u00011A\u0005\u0002y\n\u0019\u0006\u0003\u0006\u0002V\u0001\u0001\r\u0011\"\u0001?\u0003/B\u0001\"a\u0019\u0001A\u0003&\u00111\u0003\u0005\t\u0003K\u0002\u0001\u0019!C\u0001s\"I\u0011q\r\u0001A\u0002\u0013\u0005\u0011\u0011\u000e\u0005\b\u0003[\u0002\u0001\u0015)\u0003{\u0011%\ty\u0007\u0001a\u0001\n\u0013\t\u0019\u0006C\u0005\u0002r\u0001\u0001\r\u0011\"\u0003\u0002t!A\u0011q\u000f\u0001!B\u0013\t\u0019\u0002C\u0005\u0002z\u0001\u0001\r\u0011\"\u0003\u0002|!I\u00111\u0013\u0001A\u0002\u0013%\u0011Q\u0013\u0005\t\u00033\u0003\u0001\u0015)\u0003\u0002~!A\u00111\u0014\u0001A\u0002\u0013%\u0011\u0010C\u0005\u0002\u001e\u0002\u0001\r\u0011\"\u0003\u0002 \"9\u00111\u0015\u0001!B\u0013Q\b\u0002CAS\u0001\u0001\u0007I\u0011B=\t\u0013\u0005\u001d\u0006\u00011A\u0005\n\u0005%\u0006bBAW\u0001\u0001\u0006KA\u001f\u0005\t\u0003_\u0003\u0001\u0019!C\u0005s\"I\u0011\u0011\u0017\u0001A\u0002\u0013%\u00111\u0017\u0005\b\u0003o\u0003\u0001\u0015)\u0003{\u0011%\tI\f\u0001a\u0001\n\u0013\tY\u0002C\u0005\u0002<\u0002\u0001\r\u0011\"\u0003\u0002>\"A\u0011\u0011\u0019\u0001!B\u0013\ti\u0002C\u0004\u0002D\u0002!\t\"!2\t\u000f\u0005\u0015\b\u0001\"\u0005\u0002h\"1\u00111\u001f\u0001\u0005\u0012eDq!!>\u0001\t#\t9\u0010C\u0004\u0003\u000e\u0001!\tAa\u0004\t\u000f\t]\u0001\u0001\"\u0001\u0003\u001a!9!\u0011\u0007\u0001\u0005\u0002\tM\u0002b\u0002B#\u0001\u0011\u0005!q\t\u0005\b\u0005\u000b\u0002A\u0011\u0001B'\u0011\u001d\u0011)\u0006\u0001C\u0001\u0005/BqA!\u001c\u0001\t\u0003\u0011y\u0007C\u0004\u0003r\u0001!\tAa\u001d\t\u000f\t\u001d\u0006\u0001\"\u0001\u0003*\"I!\u0011\u0018\u0001\u0012\u0002\u0013\u0005!1\u0018\u0005\b\u0005#\u0004A\u0011\u0001Bj\u0011!\u00119\u000e\u0001C\u0001}\te\u0007B\u0003Bp\u0001E\u0005I\u0011\u0001 \u0003b\"9!Q\u001d\u0001\u0005B\t\u001dx!\u0003B}}\u0005\u0005\t\u0012\u0001B~\r!id(!A\t\u0002\tu\bbBA\u001eq\u0011\u0005!q \u0005\n\u0007\u0003A\u0014\u0013!C\u0001\u0007\u0007A\u0011b!\u00079#\u0003%\taa\u0007\t\u0013\r\u001d\u0002(%A\u0005\u0002\r%\"A\u0004\"bi\u000eD\u0017I\u0016'Qe>4XM\u001d\u0006\u0003\u007f\u0001\u000bQAY1uG\"T!!\u0011\"\u0002\u000f\u00054H\u000e\u001e:fK*\u00111\tR\u0001\u0007CV$\b\u000eZ:\u000b\u0005\u00153\u0015AB2ssB$xNC\u0001H\u0003\u0019\u0019\b/\u0019:lu\u000e\u0001Q\u0003\u0002&X\u0003W\u0019R\u0001A&R_J\u0004\"\u0001T(\u000e\u00035S\u0011AT\u0001\u0006g\u000e\fG.Y\u0005\u0003!6\u0013a!\u00118z%\u00164\u0007c\u0001*T+6\ta(\u0003\u0002U}\t!\u0012)\u001e;iK:$\u0018nY1uK\u0012$&/Z3PaN\u0004\"AV,\r\u0001\u0011)\u0001\f\u0001b\u00013\n\tA)\u0005\u0002[;B\u0011AjW\u0005\u000396\u0013qAT8uQ&tw\r\u0005\u0002_Y:\u0011q,\u001b\b\u0003A\u001et!!\u00194\u000f\u0005\t,W\"A2\u000b\u0005\u0011D\u0015A\u0002\u001fs_>$h(C\u0001H\u0013\t)e)\u0003\u0002i\t\u0006!\u0001.Y:i\u0013\tQ7.A\u0004qC\u000e\\\u0017mZ3\u000b\u0005!$\u0015BA7o\u0005\u0019!\u0015nZ3ti*\u0011!n\u001b\t\u0003%BL!!\u001d \u0003\u001dQ{7\u000b\u001e:j]\u001eDU\r\u001c9feB\u00111O^\u0007\u0002i*\u0011QOR\u0001\u0005kRLG.\u0003\u0002xi\ni1\u000b]1sWjdunZ4j]\u001e\f\u0011b[3z\u0019\u0016tw\r\u001e5\u0016\u0003i\u0004\"\u0001T>\n\u0005ql%aA%oi\u0006Q1.Z=MK:<G\u000f\u001b\u0011\u0002\u001dY\fG.^3MK:<G\u000f[(qiV\u0011\u0011\u0011\u0001\t\u0005\u0019\u0006\r!0C\u0002\u0002\u00065\u0013aa\u00149uS>t\u0017a\u0004<bYV,G*\u001a8hi\"|\u0005\u000f\u001e\u0011\u0002!=dGMU8pi\u0006sG\rS3jO\"$\b#\u0002'\u0002\u0004\u00055\u0001C\u0002'\u0002\u0010\u0005M!0C\u0002\u0002\u00125\u0013a\u0001V;qY\u0016\u0014\u0004\u0003\u0002*\u0002\u0016UK1!a\u0006?\u0005-\u0001&o\u001c<fe:{G-Z:\u0002'\r|G\u000e\\3di\u000eC\u0017M\\4fI:{G-Z:\u0016\u0005\u0005u\u0001c\u0001'\u0002 %\u0019\u0011\u0011E'\u0003\u000f\t{w\u000e\\3b]\u0006!2m\u001c7mK\u000e$8\t[1oO\u0016$gj\u001c3fg\u0002\n!\u0001\u001b4\u0016\u0005\u0005%\u0002c\u0001,\u0002,\u00119\u0011Q\u0006\u0001C\u0002\u0005=\"A\u0001%G#\rQ\u0016\u0011\u0007\t\u0006\u0003g\t)$V\u0007\u0002W&\u0019\u0011qG6\u0003#\r\u0013\u0018\u0010\u001d;pOJ\f\u0007\u000f[5d\u0011\u0006\u001c\b.A\u0002iM\u0002\na\u0001P5oSRtDCCA \u0003\u000b\n9%!\u0013\u0002LQ!\u0011\u0011IA\"!\u0015\u0011\u0006!VA\u0015\u0011%\t)C\u0003I\u0001\u0002\b\tI\u0003C\u0003y\u0015\u0001\u0007!\u0010\u0003\u0004\u007f\u0015\u0001\u0007\u0011\u0011\u0001\u0005\n\u0003\u0013Q\u0001\u0013!a\u0001\u0003\u0017A\u0011\"!\u0007\u000b!\u0003\u0005\r!!\b\u0002\u00171\f'-\u001a7MK:<G\u000f[\u0001\rY\u0006\u0014W\r\u001c'f]\u001e$\b\u000eI\u0001\bi>\u0004hj\u001c3f+\t\t\u0019\"A\u0006u_Btu\u000eZ3`I\u0015\fH\u0003BA-\u0003?\u00022\u0001TA.\u0013\r\ti&\u0014\u0002\u0005+:LG\u000fC\u0005\u0002b9\t\t\u00111\u0001\u0002\u0014\u0005\u0019\u0001\u0010J\u0019\u0002\u0011Q|\u0007OT8eK\u0002\naB]8pi:{G-\u001a%fS\u001eDG/\u0001\ns_>$hj\u001c3f\u0011\u0016Lw\r\u001b;`I\u0015\fH\u0003BA-\u0003WB\u0001\"!\u0019\u0012\u0003\u0003\u0005\rA_\u0001\u0010e>|GOT8eK\"+\u0017n\u001a5uA\u0005Qq\u000e\u001c3U_Btu\u000eZ3\u0002\u001d=dG\rV8q\u001d>$Wm\u0018\u0013fcR!\u0011\u0011LA;\u0011%\t\t\u0007FA\u0001\u0002\u0004\t\u0019\"A\u0006pY\u0012$v\u000e\u001d(pI\u0016\u0004\u0013A\u00033je\u0016\u001cG/[8ogV\u0011\u0011Q\u0010\t\u0007\u0003\u007f\nI)!$\u000e\u0005\u0005\u0005%\u0002BAB\u0003\u000b\u000bq!\\;uC\ndWMC\u0002\u0002\b6\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\tY)!!\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\u0004\u0019\u0006=\u0015bAAI\u001b\n!!)\u001f;f\u00039!\u0017N]3di&|gn]0%KF$B!!\u0017\u0002\u0018\"I\u0011\u0011M\f\u0002\u0002\u0003\u0007\u0011QP\u0001\fI&\u0014Xm\u0019;j_:\u001c\b%A\neSJ,7\r^5p]N\u0014\u0015\u000e\u001e'f]\u001e$\b.A\feSJ,7\r^5p]N\u0014\u0015\u000e\u001e'f]\u001e$\bn\u0018\u0013fcR!\u0011\u0011LAQ\u0011!\t\tGGA\u0001\u0002\u0004Q\u0018\u0001\u00063je\u0016\u001cG/[8og\nKG\u000fT3oORD\u0007%A\u0006sKBd\u0017-_%oI\u0016D\u0018a\u0004:fa2\f\u00170\u00138eKb|F%Z9\u0015\t\u0005e\u00131\u0016\u0005\t\u0003Cj\u0012\u0011!a\u0001u\u0006a!/\u001a9mCfLe\u000eZ3yA\u0005iA.Y:u%&<\u0007\u000e^*uKB\f\u0011\u0003\\1tiJKw\r\u001b;Ti\u0016\u0004x\fJ3r)\u0011\tI&!.\t\u0011\u0005\u0005\u0004%!AA\u0002i\fa\u0002\\1tiJKw\r\u001b;Ti\u0016\u0004\b%A\u0003g_VtG-A\u0005g_VtGm\u0018\u0013fcR!\u0011\u0011LA`\u0011%\t\tgIA\u0001\u0002\u0004\ti\"\u0001\u0004g_VtG\rI\u0001\u0014]\u0016DH\u000fR5sK\u000e$\u0018n\u001c8Jg2+g\r\u001e\u000b\u0007\u0003;\t9-a7\t\u000f\u0005%W\u00051\u0001\u0002L\u0006\u00191.Z=\u0011\t\u00055\u0017Q\u001b\b\u0005\u0003\u001f\f\u0019ND\u0002a\u0003#L!a\u0011#\n\u0005)\u0014\u0015\u0002BAl\u00033\u0014Q!\u0011#LKfT!A\u001b\"\t\u000f\u0005uW\u00051\u0001\u0002`\u0006\t!\u000f\u0005\u0003S\u0003C,\u0016bAAr}\ta\u0011J\u001c;fe:\fGNT8eK\u0006q1.Z=NCR\u001c\u0007.Z:MK\u00064GCBA\u000f\u0003S\fY\u000fC\u0004\u0002J\u001a\u0002\r!a3\t\u000f\u0005ug\u00051\u0001\u0002nB!!+a<V\u0013\r\t\tP\u0010\u0002\u0005\u0019\u0016\fg-\u0001\tsKBd\u0017-_\"p[B\f'/[:p]\u00069\u0011\r\u001a3O_\u0012,G\u0003CA}\u0003\u007f\u0014\tAa\u0001\u0011\tI\u000bY0V\u0005\u0004\u0003{t$AE%oi\u0016\u0014h.\u00197Qe>4XM\u001d(pI\u0016Dq!!8)\u0001\u0004\ti\u000fC\u0004\u0002J\"\u0002\r!a3\t\u000f\t\u0015\u0001\u00061\u0001\u0003\b\u0005\ta\u000f\u0005\u0003\u0002N\n%\u0011\u0002\u0002B\u0006\u00033\u0014q!\u0011#WC2,X-\u0001\u0004eS\u001e,7\u000f^\u000b\u0003\u0005#\u0001B!!4\u0003\u0014%!!QCAm\u0005!\tE\tR5hKN$\u0018a\u00059fe\u001a|'/\\(oK>\u0003XM]1uS>tG\u0003\u0002B\u000e\u0005O\u0001bA!\b\u0003\"\t\u0015RB\u0001B\u0010\u0015\t)X*\u0003\u0003\u0003$\t}!a\u0001+ssB)A*a\u0001\u0003\b!9!\u0011\u0006\u0016A\u0002\t-\u0012!C8qKJ\fG/[8o!\r\u0011&QF\u0005\u0004\u0005_q$!C(qKJ\fG/[8o\u00031\u0011X-\\8wK\u0012tu\u000eZ3t)\t\u0011)\u0004\u0005\u0004\u00038\t}\u00121\u0003\b\u0005\u0005s\u0011iDD\u0002c\u0005wI\u0011AT\u0005\u0003U6KAA!\u0011\u0003D\t!A*[:u\u0015\tQW*\u0001\u0005d_:$\u0018-\u001b8t)\u0011\tiB!\u0013\t\u000f\t-C\u00061\u0001\u0002\u0014\u0005!an\u001c3f)\u0019\tiBa\u0014\u0003R!9\u0011\u0011Z\u0017A\u0002\u0005-\u0007B\u0002B*[\u0001\u0007Q+A\u0003mC\n,G.\u0001\u000ehK:,'/\u0019;f!J|wN\u001a$pe>\u0003XM]1uS>t7\u000f\u0006\u0003\u0003Z\t\r\u0004C\u0002B\u000f\u0005C\u0011Y\u0006E\u0004M\u0003\u001f\u0011iF!\u0005\u0011\t\u00055'qL\u0005\u0005\u0005C\nINA\tTKJL\u0017\r\\5{K\u0012\fE\r\u0015:p_\u001aDqA!\u001a/\u0001\u0004\u00119'\u0001\u0006pa\u0016\u0014\u0018\r^5p]N\u0004bAa\u000e\u0003j\t-\u0012\u0002\u0002B6\u0005\u0007\u00121aU3r\u000359WM\\3sCR,\u0007K]8pMR\u0011!QL\u0001\tiJ,WmV1mWV1!Q\u000fBI\u0005s\"\u0002Ba\u001e\u0003\u0006\n]%1\u0015\t\u0004-\neDa\u0002B>a\t\u0007!Q\u0010\u0002\u0003\u0019J\u000b2A\u0017B@!\ra%\u0011Q\u0005\u0004\u0005\u0007k%aA!os\"9!q\u0011\u0019A\u0002\t%\u0015AD5oi\u0016\u0014h.\u00197O_\u0012,gI\u001c\t\n\u0019\n-\u0015\u0011 BH\u0005+K1A!$N\u0005%1UO\\2uS>t'\u0007E\u0002W\u0005##qAa%1\u0005\u0004\u0011iH\u0001\u0002J%B9A*a\u0004\u0002\u0014\t=\u0005b\u0002BMa\u0001\u0007!1T\u0001\u0007Y\u0016\fgM\u00128\u0011\u00131\u0013YI!(\u0003\u0010\n]\u0004\u0003\u0002*\u0003 VK1A!)?\u0005)\u0001&o\u001c<fe2+\u0017M\u001a\u0005\b\u0005K\u0003\u0004\u0019\u0001BH\u0003\u001dIg.\u001b;jC2\f!B]1oI>lw+\u00197l)\u0011\u0011YKa,\u0011\u000b1\u000b\u0019A!,\u0011\u000f1\u000by!a3\u0003\b!I!\u0011W\u0019\u0011\u0002\u0003\u0007!1W\u0001\u0005e\u0006tG\r\u0005\u0003\u0003\u001e\tU\u0016\u0002\u0002B\\\u0005?\u0011aAU1oI>l\u0017\u0001\u0006:b]\u0012|WnV1mW\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003>*\"!1\u0017B`W\t\u0011\t\r\u0005\u0003\u0003D\n5WB\u0001Bc\u0015\u0011\u00119M!3\u0002\u0013Ut7\r[3dW\u0016$'b\u0001Bf\u001b\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t='Q\u0019\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!F;oCV$\b.\u001a8uS\u000e\fG/\u001a3M_>\\W\u000f\u001d\u000b\u0005\u0005K\u0011)\u000eC\u0004\u0002JN\u0002\r!a3\u0002\u0013\rDWmY6Ue\u0016,G\u0003BA-\u00057D\u0011B!85!\u0003\u0005\r!!\b\u0002\u0013A|7\u000f\u001e)s_>4\u0017aE2iK\u000e\\GK]3fI\u0011,g-Y;mi\u0012\nTC\u0001BrU\u0011\tiBa0\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"A!;\u0011\t\t-(1\u001f\b\u0005\u0005[\u0014y\u000f\u0005\u0002c\u001b&\u0019!\u0011_'\u0002\rA\u0013X\rZ3g\u0013\u0011\u0011)Pa>\u0003\rM#(/\u001b8h\u0015\r\u0011\t0T\u0001\u000f\u0005\u0006$8\r[!W\u0019B\u0013xN^3s!\t\u0011\u0006h\u0005\u00029\u0017R\u0011!1`\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\r\r\u00151qBB\t+\t\u00199A\u000b\u0003\u0004\n\t}fb\u0001'\u0004\f%\u00191QB'\u0002\t9{g.\u001a\u0003\u00061j\u0012\r!\u0017\u0003\b\u0003[Q$\u0019AB\n#\rQ6Q\u0003\t\u0007\u0003g\t)da\u0006\u0011\u0007Y\u001by!A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u000b\u0007\u0005C\u001ciba\b\u0005\u000ba[$\u0019A-\u0005\u000f\u000552H1\u0001\u0004\"E\u0019!la\t\u0011\r\u0005M\u0012QGB\u0013!\r16QD\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\u0016\r\r-21IB$))\u0019ic!\u000e\u00048\re2Q\t\u0016\u0005\u0007_\u0011yL\u0004\u0003\u00024\rE\u0012bAB\u001aW\u0006Q!\t\\1lKJ\u0012''\u000e\u001c\t\u000bad\u0004\u0019\u0001>\t\ryd\u0004\u0019AA\u0001\u0011\u001d\tI\u0001\u0010a\u0001\u0007w\u0001R\u0001TA\u0002\u0007{\u0001b\u0001TA\b\u0007\u007fQ\b#\u0002*\u0002\u0016\r\u0005\u0003c\u0001,\u0004D\u0011)\u0001\f\u0010b\u00013\"9\u0011\u0011\u0004\u001fA\u0002\u0005uAaBA\u0017y\t\u00071\u0011J\t\u00045\u000e-\u0003CBA\u001a\u0003k\u0019\t\u0005")
public class BatchAVLProver<D extends byte[], HF extends CryptographicHash<D>>
implements AuthenticatedTreeOps<D>,
SparkzLogging {
    private final int keyLength;
    private final Option<Object> valueLengthOpt;
    private final boolean collectChangedNodes;
    private final HF hf;
    private final int labelLength;
    private ProverNodes<D> topNode;
    private int rootNodeHeight;
    private ProverNodes<D> oldTopNode;
    private ArrayBuffer<Object> directions;
    private int directionsBitLength;
    private int replayIndex;
    private int lastRightStep;
    private boolean found;
    private final Logger logger;
    private final ArrayBuffer<ProverNodes<D>> changedNodesBuffer;
    private final ArrayBuffer<ProverNodes<D>> changedNodesBufferToCheck;
    private final byte[] PositiveInfinityKey;
    private final byte[] NegativeInfinityKey;
    private final SparkzEncoder encoder;
    private final byte LeafInPackagedProof;
    private final byte LabelInPackagedProof;
    private final byte EndOfTreeInPackagedProof;

    public static <D extends byte[], HF extends CryptographicHash<D>> Blake2b256$ $lessinit$greater$default$5(int n, Option<Object> option, Option<Tuple2<ProverNodes<D>, Object>> option2, boolean bl) {
        return BatchAVLProver$.MODULE$.$lessinit$greater$default$5(n, option, option2, bl);
    }

    public static <D extends byte[], HF extends CryptographicHash<D>> boolean $lessinit$greater$default$4() {
        return BatchAVLProver$.MODULE$.$lessinit$greater$default$4();
    }

    public static <D extends byte[], HF extends CryptographicHash<D>> None$ $lessinit$greater$default$3() {
        return BatchAVLProver$.MODULE$.$lessinit$greater$default$3();
    }

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    @Override
    public void onNodeVisit(Node<D> n, Operation operation, boolean isRotate) {
        AuthenticatedTreeOps.onNodeVisit$(this, n, operation, isRotate);
    }

    @Override
    public boolean onNodeVisit$default$3() {
        return AuthenticatedTreeOps.onNodeVisit$default$3$(this);
    }

    @Override
    public byte[] digest(Node<D> rootNode) {
        return AuthenticatedTreeOps.digest$(this, rootNode);
    }

    @Override
    public Try<Tuple2<Node<D>, Option<byte[]>>> returnResultOfOneOperation(Operation operation, Node<D> rootNode) {
        return AuthenticatedTreeOps.returnResultOfOneOperation$(this, operation, rootNode);
    }

    @Override
    public String arrayToString(byte[] a) {
        return ToStringHelper.arrayToString$(this, a);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public ArrayBuffer<ProverNodes<D>> changedNodesBuffer() {
        return this.changedNodesBuffer;
    }

    @Override
    public ArrayBuffer<ProverNodes<D>> changedNodesBufferToCheck() {
        return this.changedNodesBufferToCheck;
    }

    @Override
    public byte[] PositiveInfinityKey() {
        return this.PositiveInfinityKey;
    }

    @Override
    public byte[] NegativeInfinityKey() {
        return this.NegativeInfinityKey;
    }

    @Override
    public void sparkz$crypto$authds$avltree$batch$AuthenticatedTreeOps$_setter_$changedNodesBuffer_$eq(ArrayBuffer<ProverNodes<D>> x$1) {
        this.changedNodesBuffer = x$1;
    }

    @Override
    public void sparkz$crypto$authds$avltree$batch$AuthenticatedTreeOps$_setter_$changedNodesBufferToCheck_$eq(ArrayBuffer<ProverNodes<D>> x$1) {
        this.changedNodesBufferToCheck = x$1;
    }

    @Override
    public void sparkz$crypto$authds$avltree$batch$AuthenticatedTreeOps$_setter_$PositiveInfinityKey_$eq(byte[] x$1) {
        this.PositiveInfinityKey = x$1;
    }

    @Override
    public void sparkz$crypto$authds$avltree$batch$AuthenticatedTreeOps$_setter_$NegativeInfinityKey_$eq(byte[] x$1) {
        this.NegativeInfinityKey = x$1;
    }

    public SparkzEncoder encoder() {
        return this.encoder;
    }

    public void sparkz$util$SparkzEncoding$_setter_$encoder_$eq(SparkzEncoder x$1) {
        this.encoder = x$1;
    }

    @Override
    public byte LeafInPackagedProof() {
        return this.LeafInPackagedProof;
    }

    @Override
    public byte LabelInPackagedProof() {
        return this.LabelInPackagedProof;
    }

    @Override
    public byte EndOfTreeInPackagedProof() {
        return this.EndOfTreeInPackagedProof;
    }

    @Override
    public void sparkz$crypto$authds$avltree$batch$BatchProofConstants$_setter_$LeafInPackagedProof_$eq(byte x$1) {
        this.LeafInPackagedProof = x$1;
    }

    @Override
    public void sparkz$crypto$authds$avltree$batch$BatchProofConstants$_setter_$LabelInPackagedProof_$eq(byte x$1) {
        this.LabelInPackagedProof = x$1;
    }

    @Override
    public void sparkz$crypto$authds$avltree$batch$BatchProofConstants$_setter_$EndOfTreeInPackagedProof_$eq(byte x$1) {
        this.EndOfTreeInPackagedProof = x$1;
    }

    @Override
    public int keyLength() {
        return this.keyLength;
    }

    @Override
    public Option<Object> valueLengthOpt() {
        return this.valueLengthOpt;
    }

    @Override
    public boolean collectChangedNodes() {
        return this.collectChangedNodes;
    }

    public HF hf() {
        return this.hf;
    }

    public int labelLength() {
        return this.labelLength;
    }

    public ProverNodes<D> topNode() {
        return this.topNode;
    }

    public void topNode_$eq(ProverNodes<D> x$1) {
        this.topNode = x$1;
    }

    @Override
    public int rootNodeHeight() {
        return this.rootNodeHeight;
    }

    @Override
    public void rootNodeHeight_$eq(int x$1) {
        this.rootNodeHeight = x$1;
    }

    private ProverNodes<D> oldTopNode() {
        return this.oldTopNode;
    }

    private void oldTopNode_$eq(ProverNodes<D> x$1) {
        this.oldTopNode = x$1;
    }

    private ArrayBuffer<Object> directions() {
        return this.directions;
    }

    private void directions_$eq(ArrayBuffer<Object> x$1) {
        this.directions = x$1;
    }

    private int directionsBitLength() {
        return this.directionsBitLength;
    }

    private void directionsBitLength_$eq(int x$1) {
        this.directionsBitLength = x$1;
    }

    private int replayIndex() {
        return this.replayIndex;
    }

    private void replayIndex_$eq(int x$1) {
        this.replayIndex = x$1;
    }

    private int lastRightStep() {
        return this.lastRightStep;
    }

    private void lastRightStep_$eq(int x$1) {
        this.lastRightStep = x$1;
    }

    private boolean found() {
        return this.found;
    }

    private void found_$eq(boolean x$1) {
        this.found = x$1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean nextDirectionIsLeft(byte[] key, InternalNode<D> r) {
        void var3_4;
        BoxedUnit boxedUnit;
        boolean bl;
        if (this.found()) {
            bl = true;
        } else {
            int n = ByteArray$.MODULE$.compare(key, ((InternalProverNode)r).key());
            switch (n) {
                case 0: {
                    this.found_$eq(true);
                    this.lastRightStep_$eq(this.directionsBitLength());
                    bl = false;
                    break;
                }
                default: {
                    if (n < 0) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
            }
        }
        boolean ret = bl;
        if ((this.directionsBitLength() & 7) == 0) {
            boxedUnit = this.directions().$plus$eq((Object)(ret ? BoxesRunTime.boxToByte((byte)1) : BoxesRunTime.boxToByte((byte)0)));
        } else {
            if (ret) {
                int i = this.directionsBitLength() >> 3;
                this.directions().update(i, (Object)BoxesRunTime.boxToByte((byte)((byte)(BoxesRunTime.unboxToByte((Object)this.directions().apply(i)) | 1 << (this.directionsBitLength() & 7)))));
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        this.directionsBitLength_$eq(this.directionsBitLength() + 1);
        return (boolean)var3_4;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean keyMatchesLeaf(byte[] key, Leaf<D> r) {
        void var3_3;
        boolean ret = this.found();
        this.found_$eq(false);
        return (boolean)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int replayComparison() {
        void var1_1;
        int ret = this.replayIndex() == this.lastRightStep() ? 0 : ((byte)(BoxesRunTime.unboxToByte((Object)this.directions().apply(this.replayIndex() >> 3)) & (byte)(1 << (this.replayIndex() & 7))) == 0 ? 1 : -1);
        this.replayIndex_$eq(this.replayIndex() + 1);
        return (int)var1_1;
    }

    @Override
    public InternalProverNode<D> addNode(Leaf<D> r, byte[] key, byte[] v) {
        byte[] n = r.nextLeafKey();
        byte[] x$1 = key;
        byte[] x$2 = r.getNew$default$1();
        byte[] x$3 = r.getNew$default$2();
        return new InternalProverNode(key, (ProverLeaf)r.getNew(x$2, x$3, x$1), new ProverLeaf(key, v, n, this.hf()), BoxesRunTime.unboxToByte((Object)package$Balance$.MODULE$.$at$at(BoxesRunTime.boxToByte((byte)((byte)0)), package.Tagger$.MODULE$.baseRaw())), this.hf());
    }

    public byte[] digest() {
        return this.digest(this.topNode());
    }

    public Try<Option<byte[]>> performOneOperation(Operation operation) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            this.replayIndex_$eq(this.directionsBitLength());
            Try try_ = this.returnResultOfOneOperation(operation, this.topNode());
            if (!(try_ instanceof Success)) {
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    int oldDirectionsByteLength = (this.replayIndex() + 7) / 8;
                    this.directions().trimEnd(this.directions().length() - oldDirectionsByteLength);
                    this.directionsBitLength_$eq(this.replayIndex());
                    if ((this.directionsBitLength() & 7) > 0) {
                        int mask = (1 << (this.directionsBitLength() & 7)) - 1;
                        this.directions().update(this.directions().length() - 1, (Object)BoxesRunTime.boxToByte((byte)((byte)(BoxesRunTime.unboxToByte((Object)this.directions().apply(this.directions().length() - 1)) & mask))));
                    }
                    throw e;
                }
                throw new MatchError(try_);
            }
            Success success = (Success)try_;
            Tuple2 n = (Tuple2)success.value();
            this.topNode_$eq((ProverNodes)n._1());
            Option option = (Option)n._2();
            return option;
        });
    }

    public List<ProverNodes<D>> removedNodes() {
        this.changedNodesBufferToCheck().foreach((Function1 & Serializable & scala.Serializable)cn -> !this.contains((ProverNodes)cn) ? this.changedNodesBuffer().$plus$eq(cn) : BoxedUnit.UNIT);
        return this.changedNodesBuffer().toList();
    }

    public boolean contains(ProverNodes<D> node) {
        return this.contains(node.key(), node.label());
    }

    public boolean contains(byte[] key, D label) {
        return this.loop$1(this.topNode(), false, (byte[])label, key);
    }

    public Try<Tuple2<byte[], byte[]>> generateProofForOperations(Seq<Operation> operations) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            BatchAVLProver newProver = new BatchAVLProver(this.keyLength(), this.valueLengthOpt(), new Some((Object)new Tuple2(this.topNode(), (Object)BoxesRunTime.boxToInteger((int)this.rootNodeHeight()))), false, this.hf());
            operations.foreach((Function1 & Serializable & scala.Serializable)o -> (Option)newProver.performOneOperation((Operation)o).get());
            return new Tuple2((Object)newProver.generateProof(), (Object)newProver.digest());
        });
    }

    public byte[] generateProof() {
        this.changedNodesBuffer().clear();
        this.changedNodesBufferToCheck().clear();
        ArrayBuffer packagedTree = new ArrayBuffer();
        BooleanRef previousLeafAvailable = BooleanRef.create((boolean)false);
        this.packTree$1(this.oldTopNode(), packagedTree, previousLeafAvailable);
        packagedTree.$plus$eq((Object)BoxesRunTime.boxToByte((byte)this.EndOfTreeInPackagedProof()));
        packagedTree.$plus$plus$eq(this.directions());
        BatchAVLProver.resetNew$1(this.topNode());
        this.directions_$eq((ArrayBuffer<Object>)new ArrayBuffer());
        this.directionsBitLength_$eq(0);
        this.oldTopNode_$eq(this.topNode());
        return (byte[])package$SerializedAdProof$.MODULE$.$at$at(packagedTree.toArray(ClassTag$.MODULE$.Byte()), package.Tagger$.MODULE$.baseRaw());
    }

    public <IR, LR> LR treeWalk(Function2<InternalProverNode<D>, IR, Tuple2<ProverNodes<D>, IR>> internalNodeFn, Function2<ProverLeaf<D>, IR, LR> leafFn, IR initial) {
        return (LR)this.walk$1(this.topNode(), initial, leafFn, internalNodeFn);
    }

    public Option<Tuple2<byte[], byte[]>> randomWalk(Random rand) {
        return (Option)this.treeWalk((Function2 & Serializable & scala.Serializable)(r, dummy) -> BatchAVLProver.internalNodeFn$2(r, dummy, rand), (Function2 & Serializable & scala.Serializable)(leaf, dummy) -> this.leafFn$2((ProverLeaf)leaf, (BoxedUnit)dummy), BoxedUnit.UNIT);
    }

    public Random randomWalk$default$1() {
        return new Random();
    }

    public Option<byte[]> unauthenticatedLookup(byte[] key) {
        return (Option)this.treeWalk((Function2 & Serializable & scala.Serializable)(r, found) -> BatchAVLProver.internalNodeFn$3(r, BoxesRunTime.unboxToBoolean((Object)found), key), (Function2 & Serializable & scala.Serializable)(leaf, found) -> BatchAVLProver.leafFn$3(leaf, BoxesRunTime.unboxToBoolean((Object)found)), BoxesRunTime.boxToBoolean((boolean)false));
    }

    public void checkTree(boolean postProof) {
        BooleanRef fail = BooleanRef.create((boolean)false);
        Tuple3 tuple3 = this.checkTreeHelper$1(this.topNode(), fail, postProof);
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        ProverLeaf minTree = (ProverLeaf)tuple3._1();
        ProverLeaf maxTree = (ProverLeaf)tuple3._2();
        int treeHeight = BoxesRunTime.unboxToInt((Object)tuple3._3());
        Tuple3 tuple32 = new Tuple3((Object)minTree, (Object)maxTree, (Object)BoxesRunTime.boxToInteger((int)treeHeight));
        Tuple3 tuple33 = tuple32;
        ProverLeaf minTree2 = (ProverLeaf)tuple33._1();
        ProverLeaf maxTree2 = (ProverLeaf)tuple33._2();
        int treeHeight2 = BoxesRunTime.unboxToInt((Object)tuple33._3());
        Predef$.MODULE$.require(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(minTree2.key())).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(this.NegativeInfinityKey())));
        Predef$.MODULE$.require(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(maxTree2.nextLeafKey())).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(this.PositiveInfinityKey())));
        Predef$.MODULE$.require(treeHeight2 == this.rootNodeHeight());
        Predef$.MODULE$.require(!fail.elem, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(14).append("Tree failed: \n").append(this.toString()).toString());
    }

    public boolean checkTree$default$1() {
        return false;
    }

    public String toString() {
        return this.stringTreeHelper$1(this.topNode(), 0);
    }

    private final boolean loop$1(ProverNodes currentNode, boolean keyFound, byte[] label$1, byte[] key$1) {
        boolean bl;
        block7: {
            block3: while (true) {
                ProverNodes proverNodes = currentNode;
                if (new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(currentNode.label())).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(label$1))) {
                    bl = true;
                    break block7;
                }
                if (!(proverNodes instanceof InternalProverNode)) break;
                InternalProverNode internalProverNode = (InternalProverNode)proverNodes;
                if (keyFound) {
                    keyFound = true;
                    currentNode = internalProverNode.left();
                    continue;
                }
                int n = ByteArray$.MODULE$.compare(key$1, internalProverNode.key());
                switch (n) {
                    case 0: {
                        keyFound = true;
                        currentNode = internalProverNode.right();
                        continue block3;
                    }
                }
                if (n < 0) {
                    keyFound = false;
                    currentNode = internalProverNode.left();
                    continue;
                }
                keyFound = false;
                currentNode = internalProverNode.right();
            }
            bl = false;
        }
        return bl;
    }

    private final void packTree$1(ProverNodes rNode, ArrayBuffer packagedTree$1, BooleanRef previousLeafAvailable$1) {
        if (!rNode.visited()) {
            packagedTree$1.$plus$eq((Object)BoxesRunTime.boxToByte((byte)this.LabelInPackagedProof()));
            packagedTree$1.$plus$plus$eq((TraversableOnce)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(rNode.label())));
            Predef$.MODULE$.assert(ScalaRunTime$.MODULE$.array_length(rNode.label()) == this.labelLength());
            previousLeafAvailable$1.elem = false;
        } else {
            rNode.visited_$eq(false);
            ProverNodes proverNodes = rNode;
            if (proverNodes instanceof ProverLeaf) {
                ProverLeaf proverLeaf = (ProverLeaf)proverNodes;
                packagedTree$1.$plus$eq((Object)BoxesRunTime.boxToByte((byte)this.LeafInPackagedProof()));
                Object object = !previousLeafAvailable$1.elem ? packagedTree$1.$plus$plus$eq((TraversableOnce)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(proverLeaf.key()))) : BoxedUnit.UNIT;
                packagedTree$1.$plus$plus$eq((TraversableOnce)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(proverLeaf.nextLeafKey())));
                Object object2 = this.valueLengthOpt().isEmpty() ? packagedTree$1.$plus$plus$eq((TraversableOnce)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(Ints.toByteArray((int)proverLeaf.value().length)))) : BoxedUnit.UNIT;
                packagedTree$1.$plus$plus$eq((TraversableOnce)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(proverLeaf.value())));
                previousLeafAvailable$1.elem = true;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (proverNodes instanceof InternalProverNode) {
                InternalProverNode internalProverNode = (InternalProverNode)proverNodes;
                this.packTree$1((ProverNodes)internalProverNode.left(), packagedTree$1, previousLeafAvailable$1);
                this.packTree$1((ProverNodes)internalProverNode.right(), packagedTree$1, previousLeafAvailable$1);
                packagedTree$1.$plus$eq((Object)BoxesRunTime.boxToByte((byte)internalProverNode.balance()));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)proverNodes);
            }
        }
    }

    private static final void resetNew$1(ProverNodes r) {
        block2: {
            if (!r.isNew()) break block2;
            ProverNodes proverNodes = r;
            if (proverNodes instanceof InternalProverNode) {
                InternalProverNode internalProverNode = (InternalProverNode)proverNodes;
                BatchAVLProver.resetNew$1((ProverNodes)internalProverNode.left());
                BatchAVLProver.resetNew$1((ProverNodes)internalProverNode.right());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            r.isNew_$eq(false);
            r.visited_$eq(false);
        }
    }

    private final Object walk$1(ProverNodes rNode, Object ir, Function2 leafFn$1, Function2 internalNodeFn$1) {
        ProverNodes proverNodes;
        block1: {
            while (true) {
                if ((proverNodes = rNode) instanceof ProverLeaf) break block1;
                if (!(proverNodes instanceof InternalProverNode)) break;
                InternalProverNode internalProverNode = (InternalProverNode)proverNodes;
                Tuple2 i = (Tuple2)internalNodeFn$1.apply((Object)internalProverNode, ir);
                ir = i._2();
                rNode = (ProverNodes)i._1();
            }
            throw new MatchError((Object)proverNodes);
        }
        ProverLeaf proverLeaf = (ProverLeaf)proverNodes;
        Object object = leafFn$1.apply((Object)proverLeaf, ir);
        return object;
    }

    private static final Tuple2 internalNodeFn$2(InternalProverNode r, BoxedUnit dummy, Random rand$1) {
        Tuple2 tuple2;
        boolean bl = rand$1.nextBoolean();
        if (bl) {
            tuple2 = new Tuple2((Object)r.right(), (Object)BoxedUnit.UNIT);
        } else if (!bl) {
            tuple2 = new Tuple2((Object)r.left(), (Object)BoxedUnit.UNIT);
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        return tuple2;
    }

    private final Option leafFn$2(ProverLeaf leaf, BoxedUnit dummy) {
        return new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(leaf.key())).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(this.PositiveInfinityKey())) ? None$.MODULE$ : (new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(leaf.key())).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(this.NegativeInfinityKey())) ? None$.MODULE$ : new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)leaf.key()), (Object)leaf.value())));
    }

    private static final Tuple2 internalNodeFn$3(InternalProverNode r, boolean found, byte[] key$2) {
        Tuple2 tuple2;
        if (found) {
            tuple2 = new Tuple2((Object)r.left(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        } else {
            int n = ByteArray$.MODULE$.compare(key$2, r.key());
            switch (n) {
                case 0: {
                    tuple2 = new Tuple2((Object)r.right(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                    break;
                }
                default: {
                    if (n < 0) {
                        tuple2 = new Tuple2((Object)r.left(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                        break;
                    }
                    tuple2 = new Tuple2((Object)r.right(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                    break;
                }
            }
        }
        return tuple2;
    }

    private static final Option leafFn$3(ProverLeaf leaf, boolean found) {
        return found ? new Some((Object)leaf.value()) : None$.MODULE$;
    }

    private final void myRequire$1(boolean t, String s, ProverNodes rNode$1, BooleanRef fail$1) {
        block3: {
            BoxedUnit boxedUnit;
            if (t) break block3;
            int x = rNode$1.key()[0];
            if (x < 0) {
                x += 256;
            }
            if (this.log().underlying().isErrorEnabled()) {
                this.log().underlying().error(new StringBuilder(23).append("Tree failed at key = ").append(x).append(": ").append(s).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            fail$1.elem = true;
        }
    }

    private final Tuple3 checkTreeHelper$1(ProverNodes rNode, BooleanRef fail$1, boolean postProof$1) {
        Tuple3 tuple3;
        this.myRequire$1(!postProof$1 || !rNode.visited() && !rNode.isNew(), "postproof flags", rNode, fail$1);
        ProverNodes proverNodes = rNode;
        if (proverNodes instanceof InternalProverNode) {
            Tuple3 tuple32;
            InternalProverNode internalProverNode = (InternalProverNode)proverNodes;
            if (internalProverNode.left() instanceof InternalProverNode) {
                this.myRequire$1(ByteArray$.MODULE$.compare(internalProverNode.left().key(), internalProverNode.key()) < 0, "wrong left key", rNode, fail$1);
            }
            if (internalProverNode.right() instanceof InternalProverNode) {
                this.myRequire$1(ByteArray$.MODULE$.compare(internalProverNode.right().key(), internalProverNode.key()) > 0, "wrong right key", rNode, fail$1);
            }
            if ((tuple32 = this.checkTreeHelper$1((ProverNodes)internalProverNode.left(), fail$1, postProof$1)) == null) {
                throw new MatchError((Object)tuple32);
            }
            ProverLeaf minLeft = (ProverLeaf)tuple32._1();
            ProverLeaf maxLeft = (ProverLeaf)tuple32._2();
            int leftHeight = BoxesRunTime.unboxToInt((Object)tuple32._3());
            Tuple3 tuple33 = new Tuple3((Object)minLeft, (Object)maxLeft, (Object)BoxesRunTime.boxToInteger((int)leftHeight));
            Tuple3 tuple34 = tuple33;
            ProverLeaf minLeft2 = (ProverLeaf)tuple34._1();
            ProverLeaf maxLeft2 = (ProverLeaf)tuple34._2();
            int leftHeight2 = BoxesRunTime.unboxToInt((Object)tuple34._3());
            Tuple3 tuple35 = this.checkTreeHelper$1((ProverNodes)internalProverNode.right(), fail$1, postProof$1);
            if (tuple35 == null) {
                throw new MatchError((Object)tuple35);
            }
            ProverLeaf minRight = (ProverLeaf)tuple35._1();
            ProverLeaf maxRight = (ProverLeaf)tuple35._2();
            int rightHeight = BoxesRunTime.unboxToInt((Object)tuple35._3());
            Tuple3 tuple36 = new Tuple3((Object)minRight, (Object)maxRight, (Object)BoxesRunTime.boxToInteger((int)rightHeight));
            Tuple3 tuple37 = tuple36;
            ProverLeaf minRight2 = (ProverLeaf)tuple37._1();
            ProverLeaf maxRight2 = (ProverLeaf)tuple37._2();
            int rightHeight2 = BoxesRunTime.unboxToInt((Object)tuple37._3());
            this.myRequire$1(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(maxLeft2.nextLeafKey())).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(minRight2.key())), "children don't match", rNode, fail$1);
            this.myRequire$1(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(minRight2.key())).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(internalProverNode.key())), "min of right subtree doesn't match", rNode, fail$1);
            this.myRequire$1(internalProverNode.balance() >= -1 && internalProverNode.balance() <= 1 && internalProverNode.balance() == rightHeight2 - leftHeight2, "wrong balance", rNode, fail$1);
            int height = package$.MODULE$.max(leftHeight2, rightHeight2) + 1;
            tuple3 = new Tuple3((Object)minLeft2, (Object)maxRight2, (Object)BoxesRunTime.boxToInteger((int)height));
        } else if (proverNodes instanceof ProverLeaf) {
            ProverLeaf proverLeaf = (ProverLeaf)proverNodes;
            tuple3 = new Tuple3((Object)proverLeaf, (Object)proverLeaf, (Object)BoxesRunTime.boxToInteger((int)0));
        } else {
            throw new MatchError((Object)proverNodes);
        }
        return tuple3;
    }

    private final String stringTreeHelper$1(ProverNodes rNode, int depth) {
        String string;
        StringBuilder stringBuilder = new StringBuilder(0).append(((TraversableOnce)Seq$.MODULE$.fill(depth + 2, (Function0 & Serializable & scala.Serializable)() -> " ")).mkString());
        ProverNodes proverNodes = rNode;
        if (proverNodes instanceof ProverLeaf) {
            ProverLeaf proverLeaf = (ProverLeaf)proverNodes;
            string = new StringBuilder(39).append("At leaf label = ").append(this.arrayToString((byte[])proverLeaf.label())).append(" key = ").append(this.arrayToString(proverLeaf.key())).append(" nextLeafKey = ").append(this.arrayToString(proverLeaf.nextLeafKey())).append("\n").toString();
        } else if (proverNodes instanceof InternalProverNode) {
            InternalProverNode internalProverNode = (InternalProverNode)proverNodes;
            string = new StringBuilder(41).append("Internal node label = ").append(this.arrayToString((byte[])internalProverNode.label())).append(" key = ").append(this.arrayToString(internalProverNode.key())).append(" balance = ").append(internalProverNode.balance()).append("\n").append(this.stringTreeHelper$1((ProverNodes)internalProverNode.left(), depth + 1)).append(this.stringTreeHelper$1((ProverNodes)internalProverNode.right(), depth + 1)).toString();
        } else {
            throw new MatchError((Object)proverNodes);
        }
        return stringBuilder.append((Object)string).toString();
    }

    public BatchAVLProver(int keyLength, Option<Object> valueLengthOpt, Option<Tuple2<ProverNodes<D>, Object>> oldRootAndHeight, boolean collectChangedNodes, HF hf) {
        this.keyLength = keyLength;
        this.valueLengthOpt = valueLengthOpt;
        this.collectChangedNodes = collectChangedNodes;
        this.hf = hf;
        BatchProofConstants.$init$(this);
        SparkzEncoding.$init$((SparkzEncoding)this);
        ToStringHelper.$init$(this);
        AuthenticatedTreeOps.$init$(this);
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
        this.labelLength = hf.DigestSize();
        this.topNode = (ProverNodes)oldRootAndHeight.map((Function1 & Serializable & scala.Serializable)x$1 -> (ProverNodes)x$1._1()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            void var1_1;
            ProverLeaf t = new ProverLeaf(this.NegativeInfinityKey(), (byte[])package$ADValue$.MODULE$.$at$at(Array$.MODULE$.fill(BoxesRunTime.unboxToInt((Object)this.valueLengthOpt().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)), (Function0)(JFunction0.mcB.sp & Serializable & scala.Serializable)() -> 0, ClassTag$.MODULE$.Byte()), package.Tagger$.MODULE$.baseRaw()), this.PositiveInfinityKey(), this.hf());
            t.isNew_$eq(false);
            return var1_1;
        });
        this.rootNodeHeight = BoxesRunTime.unboxToInt((Object)oldRootAndHeight.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2._2$mcI$sp())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        this.oldTopNode = this.topNode();
        this.directions = new ArrayBuffer();
        this.directionsBitLength = 0;
        this.replayIndex = 0;
        this.lastRightStep = 0;
        this.found = false;
    }
}

