/*
 * Decompiled with CFR 0.152.
 */
package sparkz.crypto.authds.avltree.batch.serialization;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.Try$;
import sparkz.crypto.authds.avltree.batch.BatchAVLProver;
import sparkz.crypto.authds.avltree.batch.BatchAVLProver$;
import sparkz.crypto.authds.avltree.batch.InternalProverNode;
import sparkz.crypto.authds.avltree.batch.ProverLeaf;
import sparkz.crypto.authds.avltree.batch.ProverNodes;
import sparkz.crypto.authds.avltree.batch.serialization.BatchAVLProverManifest;
import sparkz.crypto.authds.avltree.batch.serialization.BatchAVLProverSubtree;
import sparkz.crypto.authds.avltree.batch.serialization.ProxyInternalNode;
import sparkz.crypto.authds.avltree.batch.serialization.ProxyInternalNode$;
import sparkz.crypto.authds.package$ADKey$;
import sparkz.crypto.authds.package$ADValue$;
import sparkz.crypto.authds.package$Balance$;
import sparkz.crypto.hash.CryptographicHash;
import sparkz.util.encode.Base16$;
import sparkz.utils.ByteArray$;
import supertagged.package;

@ScalaSignature(bytes="\u0006\u0001\u0005mc\u0001B\b\u0011\u0001uA\u0001\"\n\u0001\u0003\u0006\u0004%\u0019A\n\u0005\t\u0013\u0002\u0011\t\u0011)A\u0005O!)!\n\u0001C\u0001\u0017\"9\u0001\u000b\u0001b\u0001\n\u0013\t\u0006BB+\u0001A\u0003%!+\u0002\u0003W\u0001\u00019\u0006\"\u00025\u0001\t\u0003I\u0007\"\u0002;\u0001\t\u0003)\bbBA\u0006\u0001\u0011\u0005\u0011Q\u0002\u0005\b\u0003?\u0001A\u0011AA\u0011\u0011\u001d\tY\u0003\u0001C\u0001\u0003[Aq!a\r\u0001\t\u0003\t)\u0004C\u0004\u0002B\u0001!\t!a\u0011\t\u000f\u0005=\u0003\u0001\"\u0001\u0002R\tA\")\u0019;dQ\u00063F\n\u0015:pm\u0016\u00148+\u001a:jC2L'0\u001a:\u000b\u0005E\u0011\u0012!D:fe&\fG.\u001b>bi&|gN\u0003\u0002\u0014)\u0005)!-\u0019;dQ*\u0011QCF\u0001\bCZdGO]3f\u0015\t9\u0002$\u0001\u0004bkRDGm\u001d\u0006\u00033i\taa\u0019:zaR|'\"A\u000e\u0002\rM\u0004\u0018M]6{\u0007\u0001)2A\b\u001c*'\t\u0001q\u0004\u0005\u0002!G5\t\u0011EC\u0001#\u0003\u0015\u00198-\u00197b\u0013\t!\u0013E\u0001\u0004B]f\u0014VMZ\u0001\u0003Q\u001a,\u0012a\n\t\u0003Q%b\u0001\u0001B\u0003+\u0001\t\u00071F\u0001\u0002I\rF\u0011Af\f\t\u0003A5J!AL\u0011\u0003\u000f9{G\u000f[5oOB\u0019\u0001gM\u001b\u000e\u0003ER!A\r\r\u0002\t!\f7\u000f[\u0005\u0003iE\u0012\u0011c\u0011:zaR|wM]1qQ&\u001c\u0007*Y:i!\tAc\u0007B\u00038\u0001\t\u0007\u0001HA\u0001E#\ta\u0013\b\u0005\u0002;\r:\u00111\b\u0012\b\u0003y\rs!!\u0010\"\u000f\u0005y\nU\"A \u000b\u0005\u0001c\u0012A\u0002\u001fs_>$h(C\u0001\u001c\u0013\tI\"$\u0003\u000231%\u0011Q)M\u0001\ba\u0006\u001c7.Y4f\u0013\t9\u0005J\u0001\u0004ES\u001e,7\u000f\u001e\u0006\u0003\u000bF\n1\u0001\u001b4!\u0003\u0019a\u0014N\\5u}Q\tA\n\u0006\u0002N\u001fB!a\nA\u001b(\u001b\u0005\u0001\u0002\"B\u0013\u0004\u0001\b9\u0013a\u00037bE\u0016dG*\u001a8hi\",\u0012A\u0015\t\u0003AMK!\u0001V\u0011\u0003\u0007%sG/\u0001\u0007mC\n,G\u000eT3oORD\u0007E\u0001\u0006TY&\u001cW\r\u001a+sK\u0016\u0004B\u0001\t-[;&\u0011\u0011,\t\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u00079[V'\u0003\u0002]!\t1\")\u0019;dQ\u00063F\n\u0015:pm\u0016\u0014X*\u00198jM\u0016\u001cH\u000fE\u0002_E\u0016t!aX1\u000f\u0005y\u0002\u0017\"\u0001\u0012\n\u0005\u0015\u000b\u0013BA2e\u0005\r\u0019V-\u001d\u0006\u0003\u000b\u0006\u00022A\u001446\u0013\t9\u0007CA\u000bCCR\u001c\u0007.\u0011,M!J|g/\u001a:Tk\n$(/Z3\u0002\u000bMd\u0017nY3\u0015\u0007)d'\u000f\u0005\u0002l\r5\t\u0001\u0001C\u0003n\u000f\u0001\u0007a.\u0001\u0003ue\u0016,\u0007\u0003B8qk\u001dj\u0011AE\u0005\u0003cJ\u0011aBQ1uG\"\fe\u000b\u0014)s_Z,'\u000fC\u0003t\u000f\u0001\u0007!+\u0001\u0007tk\n$(/Z3EKB$\b.A\u0004d_6\u0014\u0017N\\3\u0015\u000bYdh0!\u0001\u0011\u0007]Th.D\u0001y\u0015\tI\u0018%\u0001\u0003vi&d\u0017BA>y\u0005\r!&/\u001f\u0005\u0006{\"\u0001\rA[\u0001\u0007g2L7-\u001a3\t\u000b}D\u0001\u0019\u0001*\u0002\u0013-,\u0017\u0010T3oORD\u0007bBA\u0002\u0011\u0001\u0007\u0011QA\u0001\u000fm\u0006dW/\u001a'f]\u001e$\bn\u00149u!\u0011\u0001\u0013q\u0001*\n\u0007\u0005%\u0011E\u0001\u0004PaRLwN\\\u0001\u0010[\u0006t\u0017NZ3tiR{')\u001f;fgR!\u0011qBA\u000e!\u0015\u0001\u0013\u0011CA\u000b\u0013\r\t\u0019\"\t\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004A\u0005]\u0011bAA\rC\t!!)\u001f;f\u0011\u0019\ti\"\u0003a\u00015\u0006AQ.\u00198jM\u0016\u001cH/A\tnC:Lg-Z:u\rJ|WNQ=uKN$b!a\t\u0002&\u0005%\u0002cA<{5\"9\u0011q\u0005\u0006A\u0002\u0005=\u0011!\u00022zi\u0016\u001c\b\"B@\u000b\u0001\u0004\u0011\u0016AD:vER\u0014X-\u001a+p\u0005f$Xm\u001d\u000b\u0005\u0003\u001f\ty\u0003\u0003\u0004\u00022-\u0001\r!Z\u0001\u0002i\u0006\u00012/\u001e2ue\u0016,gI]8n\u0005f$Xm\u001d\u000b\u0007\u0003o\tI$!\u0010\u0011\u0007]TX\rC\u0004\u0002<1\u0001\r!a\u0004\u0002\u0003\tDa!a\u0010\r\u0001\u0004\u0011\u0016AA6m\u00031qw\u000eZ3t)>\u0014\u0015\u0010^3t)\u0011\ty!!\u0012\t\u000f\u0005\u001dS\u00021\u0001\u0002J\u0005A!o\\8u\u001d>$W\r\u0005\u0003p\u0003\u0017*\u0014bAA'%\tY\u0001K]8wKJtu\u000eZ3t\u00039qw\u000eZ3t\rJ|WNQ=uKN$b!a\u0015\u0002V\u0005e\u0003\u0003B<{\u0003\u0013Bq!a\u0016\u000f\u0001\u0004\ty!A\u0004csR,7/\u00138\t\u000b}t\u0001\u0019\u0001*")
public class BatchAVLProverSerializer<D extends byte[], HF extends CryptographicHash<D>> {
    private final HF hf;
    private final int labelLength;

    public HF hf() {
        return this.hf;
    }

    private int labelLength() {
        return this.labelLength;
    }

    public Tuple2<BatchAVLProverManifest<D>, Seq<BatchAVLProverSubtree<D>>> slice(BatchAVLProver<D, HF> tree, int subtreeDepth) {
        Tuple2 tuple2;
        ProverNodes<D> proverNodes = tree.topNode();
        if (proverNodes instanceof InternalProverNode) {
            InternalProverNode internalProverNode = (InternalProverNode)proverNodes;
            int height = tree.rootNodeHeight();
            ProxyInternalNode rootProxyNode = ProxyInternalNode$.MODULE$.apply(internalProverNode, this.hf());
            Seq subtrees = (Seq)this.getSubtrees$1((ProverNodes)internalProverNode.left(), height - 1, rootProxyNode, subtreeDepth).$plus$plus((GenTraversableOnce)this.getSubtrees$1((ProverNodes)internalProverNode.right(), height - 1, rootProxyNode, subtreeDepth), Seq$.MODULE$.canBuildFrom());
            BatchAVLProverManifest manifest = new BatchAVLProverManifest(rootProxyNode, height);
            tuple2 = new Tuple2(manifest, (Object)subtrees);
        } else if (proverNodes instanceof ProverLeaf) {
            ProverLeaf proverLeaf = (ProverLeaf)proverNodes;
            tuple2 = new Tuple2(new BatchAVLProverManifest(proverLeaf, tree.rootNodeHeight()), (Object)Nil$.MODULE$);
        } else {
            throw new MatchError(proverNodes);
        }
        return tuple2;
    }

    public Try<BatchAVLProver<D, HF>> combine(Tuple2<BatchAVLProverManifest<D>, Seq<BatchAVLProverSubtree<D>>> sliced, int keyLength, Option<Object> valueLengthOpt) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            BatchAVLProverManifest manifest = (BatchAVLProverManifest)sliced._1();
            ProverNodes proverNodes = manifest.root();
            if (proverNodes instanceof InternalProverNode) {
                InternalProverNode internalProverNode = (InternalProverNode)proverNodes;
                this.mutateLoop$1(internalProverNode, sliced);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (proverNodes instanceof ProverLeaf) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(proverNodes);
            }
            return new BatchAVLProver(keyLength, valueLengthOpt, new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(manifest.root()), (Object)BoxesRunTime.boxToInteger((int)manifest.rootHeight()))), BatchAVLProver$.MODULE$.$lessinit$greater$default$4(), this.hf());
        });
    }

    public byte[] manifestToBytes(BatchAVLProverManifest<D> manifest) {
        return Bytes.concat((byte[][])new byte[][]{Ints.toByteArray((int)manifest.rootHeight()), this.nodesToBytes(manifest.root())});
    }

    public Try<BatchAVLProverManifest<D>> manifestFromBytes(byte[] bytes, int keyLength) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            int oldHeight = Ints.fromByteArray((byte[])((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).slice(0, 4)));
            ProverNodes oldTop = (ProverNodes)this.nodesFromBytes((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).slice(4, bytes.length), keyLength).get();
            return new BatchAVLProverManifest(oldTop, oldHeight);
        });
    }

    public byte[] subtreeToBytes(BatchAVLProverSubtree<D> t) {
        return this.nodesToBytes(t.subtreeTop());
    }

    public Try<BatchAVLProverSubtree<D>> subtreeFromBytes(byte[] b, int kl) {
        return this.nodesFromBytes(b, kl).map((Function1 & Serializable & scala.Serializable)topNode -> new BatchAVLProverSubtree(topNode));
    }

    public byte[] nodesToBytes(ProverNodes<D> rootNode) {
        return BatchAVLProverSerializer.loop$1(rootNode);
    }

    public Try<ProverNodes<D>> nodesFromBytes(byte[] bytesIn, int keyLength) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.loop$2(bytesIn, keyLength));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Seq getSubtrees$1(ProverNodes currentNode, int currentHeight, ProxyInternalNode parent, int subtreeDepth$1) {
        boolean bl = false;
        InternalProverNode internalProverNode = null;
        ProverNodes proverNodes = currentNode;
        if (proverNodes instanceof InternalProverNode) {
            bl = true;
            internalProverNode = (InternalProverNode)proverNodes;
            if (currentHeight > subtreeDepth$1) {
                ProxyInternalNode nextParent = ProxyInternalNode$.MODULE$.apply(internalProverNode, this.hf());
                parent.setChild(nextParent);
                Seq leftSubtrees = this.getSubtrees$1((ProverNodes)internalProverNode.left(), currentHeight - 1, nextParent, subtreeDepth$1);
                Seq rightSubtrees = this.getSubtrees$1((ProverNodes)internalProverNode.right(), currentHeight - 1, nextParent, subtreeDepth$1);
                return (Seq)leftSubtrees.$plus$plus((GenTraversableOnce)rightSubtrees, Seq$.MODULE$.canBuildFrom());
            }
        }
        if (bl) {
            parent.setChild(ProxyInternalNode$.MODULE$.apply(internalProverNode, this.hf()));
            return (Seq)new .colon.colon(new BatchAVLProverSubtree(internalProverNode.left()), (List)new .colon.colon(new BatchAVLProverSubtree(internalProverNode.right()), (List)Nil$.MODULE$));
        }
        if (!(proverNodes instanceof ProverLeaf)) throw new MatchError((Object)proverNodes);
        ProverLeaf proverLeaf = (ProverLeaf)proverNodes;
        parent.setChild(proverLeaf);
        return (Seq)new .colon.colon(new BatchAVLProverSubtree(proverLeaf), (List)Nil$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$combine$2(ProxyInternalNode x2$1, BatchAVLProverSubtree x$1) {
        return new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(x$1.id())).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(x2$1.leftLabel()));
    }

    public static final /* synthetic */ boolean $anonfun$combine$3(ProxyInternalNode x2$1, BatchAVLProverSubtree x$2) {
        return new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(x$2.id())).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(x2$1.rightLabel()));
    }

    private final void mutateLoop$1(ProverNodes n, Tuple2 sliced$1) {
        block2: {
            while (true) {
                ProxyInternalNode proxyInternalNode;
                ProverNodes proverNodes;
                if ((proverNodes = n) instanceof ProxyInternalNode && (proxyInternalNode = (ProxyInternalNode)proverNodes).isEmpty()) {
                    ProverNodes left = ((BatchAVLProverSubtree)((IterableLike)sliced$1._2()).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BatchAVLProverSerializer.$anonfun$combine$2(proxyInternalNode, x$1))).get()).subtreeTop();
                    ProverNodes right = ((BatchAVLProverSubtree)((IterableLike)sliced$1._2()).find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)BatchAVLProverSerializer.$anonfun$combine$3(proxyInternalNode, x$2))).get()).subtreeTop();
                    proxyInternalNode.setChild(left);
                    proxyInternalNode.setChild(right);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block2;
                }
                if (!(proverNodes instanceof InternalProverNode)) break;
                InternalProverNode internalProverNode = (InternalProverNode)proverNodes;
                this.mutateLoop$1((ProverNodes)internalProverNode.left(), sliced$1);
                n = internalProverNode.right();
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private static final byte[] loop$1(ProverNodes currentNode) {
        ProxyInternalNode proxyInternalNode;
        byte[] byArray;
        ProverNodes proverNodes = currentNode;
        if (proverNodes instanceof ProverLeaf) {
            ProverLeaf proverLeaf = (ProverLeaf)proverNodes;
            byArray = Bytes.concat((byte[][])new byte[][]{{(byte)0}, proverLeaf.key(), proverLeaf.nextLeafKey(), proverLeaf.value()});
        } else if (proverNodes instanceof ProxyInternalNode && (proxyInternalNode = (ProxyInternalNode)proverNodes).isEmpty()) {
            byArray = Bytes.concat((byte[][])new byte[][]{{(byte)2, proxyInternalNode.balance()}, proxyInternalNode.key(), (byte[])proxyInternalNode.leftLabel(), (byte[])proxyInternalNode.rightLabel()});
        } else if (proverNodes instanceof InternalProverNode) {
            InternalProverNode internalProverNode = (InternalProverNode)proverNodes;
            byte[] leftBytes = BatchAVLProverSerializer.loop$1((ProverNodes)internalProverNode.left());
            byte[] rightBytes = BatchAVLProverSerializer.loop$1((ProverNodes)internalProverNode.right());
            byArray = Bytes.concat((byte[][])new byte[][]{{(byte)1, internalProverNode.balance()}, internalProverNode.key(), Ints.toByteArray((int)leftBytes.length), leftBytes, rightBytes});
        } else {
            throw new MatchError((Object)proverNodes);
        }
        return byArray;
    }

    private final ProverNodes loop$2(byte[] bytes, int keyLength$3) {
        ProverNodes<Object> proverNodes;
        byte by = BoxesRunTime.unboxToByte((Object)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).head());
        switch (by) {
            case 0: {
                byte[] key = (byte[])package$ADKey$.MODULE$.$at$at(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).slice(1, keyLength$3 + 1), package.Tagger$.MODULE$.baseRaw());
                byte[] nextLeafKey = (byte[])package$ADKey$.MODULE$.$at$at(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).slice(keyLength$3 + 1, 2 * keyLength$3 + 1), package.Tagger$.MODULE$.baseRaw());
                byte[] value = (byte[])package$ADValue$.MODULE$.$at$at(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).slice(2 * keyLength$3 + 1, bytes.length), package.Tagger$.MODULE$.baseRaw());
                proverNodes = new ProverLeaf(key, value, nextLeafKey, this.hf());
                break;
            }
            case 1: {
                byte balance = BoxesRunTime.unboxToByte((Object)package$Balance$.MODULE$.$at$at(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).slice(1, 2))).head(), package.Tagger$.MODULE$.baseRaw()));
                byte[] key = (byte[])package$ADKey$.MODULE$.$at$at(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).slice(2, keyLength$3 + 2), package.Tagger$.MODULE$.baseRaw());
                int leftLength = Ints.fromByteArray((byte[])((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).slice(keyLength$3 + 2, keyLength$3 + 6)));
                byte[] leftBytes = (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).slice(keyLength$3 + 6, keyLength$3 + 6 + leftLength);
                byte[] rightBytes = (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).slice(keyLength$3 + 6 + leftLength, bytes.length);
                ProverNodes left = this.loop$2(leftBytes, keyLength$3);
                ProverNodes right = this.loop$2(rightBytes, keyLength$3);
                int leftComparison = ByteArray$.MODULE$.compare(left.key(), key);
                int rightComparison = ByteArray$.MODULE$.compare(key, right.key());
                Predef$.MODULE$.require(leftComparison < 0 && rightComparison <= 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("key check fail for key ").append(Base16$.MODULE$.encode(key)).toString());
                proverNodes = new InternalProverNode(key, left, right, balance, this.hf());
                break;
            }
            case 2: {
                byte balance = BoxesRunTime.unboxToByte((Object)package$Balance$.MODULE$.$at$at(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).slice(1, 2))).head(), package.Tagger$.MODULE$.baseRaw()));
                byte[] key = (byte[])package$ADKey$.MODULE$.$at$at(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).slice(2, keyLength$3 + 2), package.Tagger$.MODULE$.baseRaw());
                byte[] leftLabel = (byte[])this.hf().byteArrayToDigest((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).slice(keyLength$3 + 2, keyLength$3 + 2 + this.labelLength())).get();
                byte[] rightLabel = (byte[])this.hf().byteArrayToDigest((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).slice(keyLength$3 + 2 + this.labelLength(), keyLength$3 + 2 + 2 * this.labelLength())).get();
                proverNodes = new ProxyInternalNode<byte[]>(key, leftLabel, rightLabel, balance, (CryptographicHash<byte[]>)this.hf());
                break;
            }
            default: {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }
        }
        return proverNodes;
    }

    public BatchAVLProverSerializer(HF hf) {
        this.hf = hf;
        this.labelLength = hf.DigestSize();
    }
}

