/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.evm;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.sun.jna.Callback;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import io.horizen.evm.CallbackRegistry;
import io.horizen.evm.Converter;
import io.horizen.evm.GlogCallback;
import io.horizen.evm.LibEvmCallback;
import io.horizen.evm.LibEvmException;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class LibEvm {
    private static final Logger logger = LogManager.getLogger();
    private static final GlogCallback logCallback = new GlogCallback(logger);
    private static final CallbackProxy proxy = new CallbackProxy();

    private static native void FreeBuffer(Pointer var0);

    private static native Pointer CreateBuffer(int var0);

    private static native void SetCallbackProxy(CallbackProxy var0);

    private static native void SetupLogging(int var0, String var1);

    private static native Pointer Invoke(String var0, String var1);

    private LibEvm() {
    }

    private static String readNativeString(Pointer ptr) {
        if (ptr == null) {
            return null;
        }
        try {
            String string = ptr.getString(0L);
            return string;
        }
        finally {
            LibEvm.FreeBuffer(ptr);
        }
    }

    static <R> R invoke(String method, Object args, Class<R> responseType) {
        JavaType type;
        String argsJson = args == null ? null : Converter.toJson(args);
        Pointer ptr = LibEvm.Invoke(method, argsJson);
        String json = LibEvm.readNativeString(ptr);
        InteropResult response = (InteropResult)Converter.fromJson(json, type = TypeFactory.defaultInstance().constructParametricType(InteropResult.class, new Class[]{responseType}));
        if (response.isError()) {
            throw new LibEvmException(response.error, method, argsJson);
        }
        return response.result;
    }

    static <R> R invoke(String method, Class<R> responseType) {
        return LibEvm.invoke(method, null, responseType);
    }

    static void invoke(String method, Object args) {
        LibEvm.invoke(method, args, Void.class);
    }

    static void invoke(String method) {
        LibEvm.invoke(method, null, Void.class);
    }

    static {
        logger.info("loading libevm for platform {}", (Object)Platform.RESOURCE_PREFIX);
        Native.register((String)"evm");
        LibEvm.SetCallbackProxy(proxy);
        LibEvm.SetupLogging(LibEvm.logCallback.handle, GlogCallback.log4jToGlogLevel(logger.getLevel()));
    }

    private static class CallbackProxy
    implements Callback {
        private CallbackProxy() {
        }

        public Pointer callback(int handle, Pointer msg) {
            try {
                LibEvmCallback callback = CallbackRegistry.get(handle);
                if (callback == null) {
                    return null;
                }
                String result = callback.invoke(msg.getString(0L));
                if (result == null) {
                    return null;
                }
                byte[] bytes = result.getBytes(StandardCharsets.UTF_8);
                Pointer buffer = LibEvm.CreateBuffer(bytes.length + 1);
                buffer.write(0L, bytes, 0, bytes.length);
                buffer.setByte((long)bytes.length, (byte)0);
                return buffer;
            }
            catch (Exception e) {
                logger.warn("error while handling callback", (Throwable)e);
                return null;
            }
        }
    }

    private static class InteropResult<R> {
        public String error;
        public R result;

        private InteropResult() {
        }

        public boolean isError() {
            return !this.error.isEmpty();
        }

        public String toString() {
            if (!this.error.isEmpty()) {
                return String.format("error: %s", this.error);
            }
            return "success";
        }
    }
}

