/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.evm;

import io.horizen.evm.Converter;
import io.horizen.evm.LibEvmCallback;
import java.util.HashMap;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

class GlogCallback
extends LibEvmCallback {
    private final Logger logger;

    GlogCallback(Logger logger) {
        this.logger = logger;
    }

    @Override
    public String invoke(String args) {
        try {
            HashMap data = Converter.fromJson(args, HashMap.class);
            Level level = GlogCallback.glogToLog4jLevel((String)data.remove("lvl"));
            Object file = data.remove("file");
            Object line = data.remove("line");
            Object fn = data.remove("fn");
            Object msg = data.remove("msg");
            data.remove("t");
            this.logger.log(level, String.format("[%s:%s] (%s) %s %s", file, line, fn, msg, data));
        }
        catch (Exception e) {
            this.logger.warn("received invalid log message data", (Throwable)e);
        }
        return null;
    }

    static Level glogToLog4jLevel(String glogLevel) {
        switch (glogLevel) {
            case "trce": {
                return Level.TRACE;
            }
            default: {
                return Level.DEBUG;
            }
            case "info": {
                return Level.INFO;
            }
            case "warn": {
                return Level.WARN;
            }
            case "eror": {
                return Level.ERROR;
            }
            case "crit": 
        }
        return Level.FATAL;
    }

    static String log4jToGlogLevel(Level level) {
        switch (level.toString()) {
            default: {
                return "trce";
            }
            case "DEBUG": {
                return "dbug";
            }
            case "INFO": {
                return "info";
            }
            case "WARN": {
                return "warn";
            }
            case "ERROR": {
                return "eror";
            }
            case "FATAL": 
            case "OFF": 
        }
        return "crit";
    }
}

