/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.evm;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.io.BaseEncoding;
import io.horizen.evm.utils.BigIntegerDeserializer;
import io.horizen.evm.utils.BigIntegerSerializer;
import java.io.IOException;
import java.math.BigInteger;

final class Converter {
    private static final ObjectMapper mapper;

    private Converter() {
    }

    public static String toJson(Object obj) {
        try {
            return mapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T fromJson(String json, JavaType type) {
        try {
            return (T)mapper.readValue(json, type);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T fromJson(String json, Class<T> valueType) {
        try {
            return (T)mapper.readValue(json, valueType);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static byte[] fromHexString(String hex) {
        return BaseEncoding.base16().lowerCase().decode((CharSequence)hex.toLowerCase());
    }

    public static String toHexString(byte[] bytes) {
        return BaseEncoding.base16().lowerCase().encode(bytes);
    }

    static {
        SimpleModule module = new SimpleModule();
        module.addSerializer(BigInteger.class, (JsonSerializer)new BigIntegerSerializer());
        module.addDeserializer(BigInteger.class, (JsonDeserializer)new BigIntegerDeserializer());
        mapper = new ObjectMapper();
        mapper.registerModule((Module)module);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    }
}

