/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.evm;

import io.horizen.evm.Converter;
import io.horizen.evm.Hash;
import io.horizen.evm.LibEvmCallback;
import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class BlockHashCallback
extends LibEvmCallback {
    private static final Logger logger = LogManager.getLogger();

    protected abstract Hash getBlockHash(BigInteger var1);

    @Override
    public String invoke(String args) {
        logger.debug("received block hash callback");
        try {
            BigInteger blockNumber = Converter.fromJson(args, BigInteger.class);
            return Converter.toJson(this.getBlockHash(blockNumber));
        }
        catch (Exception e) {
            logger.warn("received invalid block hash callback", (Throwable)e);
            return Converter.toJson(Hash.ZERO);
        }
    }
}

