/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.evm;

import io.horizen.evm.Hash;
import io.horizen.evm.LibEvmTestBase;
import io.horizen.evm.StateDB;
import io.horizen.evm.TrieHasher;
import org.junit.Assert;
import org.junit.Test;

public class TrieHasherTest
extends LibEvmTestBase {
    @Test
    public void trieHasher() {
        Hash hashEmptyTest = TrieHasher.Root(null);
        Hash hashEmptyTest2 = TrieHasher.Root((byte[][])new byte[0][0]);
        Hash hashA = TrieHasher.Root((byte[][])new byte[][]{{1}, {2}, {3}});
        Hash hashA2 = TrieHasher.Root((byte[][])new byte[][]{{1}, {2}, {3}});
        Hash hashB = TrieHasher.Root((byte[][])new byte[][]{{1, 2, 3}});
        Hash hashC = TrieHasher.Root((byte[][])new byte[][]{{1, 2}, {3, 4}, {1}});
        Hash hashD = TrieHasher.Root((byte[][])new byte[][]{{1, 2}, {3, 4}, {2}});
        Hash hashE = TrieHasher.Root((byte[][])new byte[][]{{-127, 127}, {3, 4}, {0, 0}});
        Hash hashF = TrieHasher.Root((byte[][])new byte[200][1]);
        Hash hashG = TrieHasher.Root((byte[][])new byte[1000][67]);
        Assert.assertEquals((String)"should return well-known empty root hash", (Object)StateDB.EMPTY_ROOT_HASH, (Object)hashEmptyTest);
        Assert.assertEquals((String)"should return well-known empty root hash", (Object)hashEmptyTest, (Object)hashEmptyTest2);
        Assert.assertNotEquals((String)"should not give empty root hash", (Object)hashEmptyTest, (Object)hashA);
        Assert.assertEquals((String)"should return same root hash for same input", (Object)hashA, (Object)hashA2);
        Assert.assertNotEquals((String)"should return different root hash for different input", (Object)hashA, (Object)hashB);
        Assert.assertNotEquals((String)"should return different root hash for different input", (Object)hashB, (Object)hashC);
        Assert.assertNotEquals((String)"should return different root hash for different input", (Object)hashC, (Object)hashD);
        Assert.assertNotEquals((String)"should return different root hash for different input", (Object)hashD, (Object)hashE);
        Assert.assertNotEquals((String)"should return different root hash for different input", (Object)hashE, (Object)hashF);
        Assert.assertNotEquals((String)"should return different root hash for different input", (Object)hashF, (Object)hashG);
    }
}

