/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.evm;

import io.horizen.evm.Converter;
import io.horizen.evm.Hash;
import java.util.Arrays;
import java.util.Random;

public class LibEvmTestBase {
    private static final Random rand = new Random();

    protected static byte[] bytes(String hex) {
        return Converter.fromHexString((String)hex);
    }

    protected static byte[] concat(byte[] a, byte[] b) {
        byte[] merged = Arrays.copyOf(a, a.length + b.length);
        System.arraycopy(b, 0, merged, a.length, b.length);
        return merged;
    }

    protected static Hash padToHash(byte[] bytes) {
        byte[] padded = new byte[32];
        System.arraycopy(bytes, 0, padded, padded.length - bytes.length, bytes.length);
        return new Hash(padded);
    }

    protected static Hash randomHash() {
        byte[] bytes = new byte[32];
        rand.nextBytes(bytes);
        return new Hash(bytes);
    }
}

