/*
 * Decompiled with CFR 0.152.
 */
package io.honnix.rkt.launcher.service.api;

import com.spotify.apollo.AppInit;
import com.spotify.apollo.Environment;
import com.spotify.apollo.route.Route;
import com.typesafe.config.ConfigRenderOptions;
import io.honnix.rkt.launcher.RktLauncherConfig;
import io.honnix.rkt.launcher.service.api.RktCommandResource;
import io.honnix.rkt.launcher.service.api.RktImageCommandResource;
import io.honnix.rkt.launcher.service.exception.RktLauncherServiceException;
import io.honnix.rkt.launcher.util.Json;
import java.io.IOException;

public final class RktLauncherApi
implements AppInit {
    public void create(Environment environment) {
        RktLauncherConfig rktLauncherConfig;
        String json = environment.config().getValue("rktLauncher").render(ConfigRenderOptions.concise());
        try {
            rktLauncherConfig = (RktLauncherConfig)Json.deserialize((String)json, RktLauncherConfig.class);
        }
        catch (IOException e) {
            throw new RktLauncherServiceException("invalid configuration", e);
        }
        RktCommandResource rktCommandResource = new RktCommandResource(rktLauncherConfig);
        RktImageCommandResource rktImageCommandResource = new RktImageCommandResource(rktLauncherConfig);
        environment.routingEngine().registerAutoRoute(Route.sync((String)"GET", (String)"/ping", rc -> "pong")).registerRoutes(rktCommandResource.routes()).registerRoutes(rktImageCommandResource.routes());
    }
}

