/*
 * Decompiled with CFR 0.152.
 */
package io.honnix.rkt.launcher.service.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.spotify.apollo.Request;
import com.spotify.apollo.RequestContext;
import com.spotify.apollo.Response;
import com.spotify.apollo.Status;
import com.spotify.apollo.StatusType;
import com.spotify.apollo.entity.EntityCodec;
import com.spotify.apollo.entity.EntityMiddleware;
import com.spotify.apollo.entity.JacksonEntityCodec;
import com.spotify.apollo.route.AsyncHandler;
import com.spotify.apollo.route.Middleware;
import com.spotify.apollo.route.Route;
import io.honnix.rkt.launcher.RktLauncher;
import io.honnix.rkt.launcher.RktLauncherConfig;
import io.honnix.rkt.launcher.command.Command;
import io.honnix.rkt.launcher.command.image.CatManifest;
import io.honnix.rkt.launcher.command.image.Gc;
import io.honnix.rkt.launcher.command.image.Rm;
import io.honnix.rkt.launcher.exception.RktException;
import io.honnix.rkt.launcher.exception.RktLauncherException;
import io.honnix.rkt.launcher.options.Options;
import io.honnix.rkt.launcher.options.image.GcOptions;
import io.honnix.rkt.launcher.options.image.ListOptions;
import io.honnix.rkt.launcher.output.Output;
import io.honnix.rkt.launcher.output.image.CatManifestOutput;
import io.honnix.rkt.launcher.output.image.GcOutput;
import io.honnix.rkt.launcher.output.image.ListOutput;
import io.honnix.rkt.launcher.output.image.RmOutput;
import io.honnix.rkt.launcher.service.api.Api;
import io.honnix.rkt.launcher.service.exception.RktLauncherServiceException;
import io.honnix.rkt.launcher.util.Json;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import okio.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RktImageCommandResource {
    private static final Logger LOG = LoggerFactory.getLogger(RktImageCommandResource.class);
    private static final Function<RktLauncherConfig, RktLauncher> DEFAULT_RKT_LAUNCHER_FACTORY = RktLauncher::new;
    private static final String DEFAULT_HTTP_METHOD = "POST";
    private final RktLauncherConfig rktLauncherConfig;
    private Function<RktLauncherConfig, RktLauncher> rktLauncherFactory;

    RktImageCommandResource(RktLauncherConfig rktLauncherConfig) {
        this(rktLauncherConfig, DEFAULT_RKT_LAUNCHER_FACTORY);
    }

    RktImageCommandResource(RktLauncherConfig rktLauncherConfig, Function<RktLauncherConfig, RktLauncher> rktLauncherFactory) {
        this.rktLauncherConfig = Objects.requireNonNull(rktLauncherConfig);
        this.rktLauncherFactory = Objects.requireNonNull(rktLauncherFactory);
    }

    Stream<? extends Route<? extends AsyncHandler<? extends Response<ByteString>>>> routes() {
        String base = "/rkt/image";
        EntityMiddleware em = EntityMiddleware.forCodec((EntityCodec)JacksonEntityCodec.forMapper((ObjectMapper)Json.OBJECT_MAPPER));
        List<Route<AsyncHandler<Response<ByteString>>>> entityRoutes = Stream.of(Route.with((Middleware)em.serializerResponse(CatManifestOutput.class), (String)DEFAULT_HTTP_METHOD, (String)"/rkt/image/cat-manifest/<id>", rc -> this.catManifest(RktImageCommandResource.getId(rc))), Route.with((Middleware)em.serializerResponse(GcOutput.class), (String)DEFAULT_HTTP_METHOD, (String)"/rkt/image/gc", rc -> this.gc(rc.request())), Route.with((Middleware)em.serializerResponse(ListOutput.class), (String)DEFAULT_HTTP_METHOD, (String)"/rkt/image/list", rc -> this.list()), Route.with((Middleware)em.serializerResponse(RmOutput.class), (String)DEFAULT_HTTP_METHOD, (String)"/rkt/image/rm", rc -> this.rm(rc.request())), Route.with((Middleware)em.serializerResponse(RmOutput.class), (String)DEFAULT_HTTP_METHOD, (String)"/rkt/image/rm/<id>", rc -> this.rm(RktImageCommandResource.getId(rc)))).map(r -> r.withMiddleware(Middleware::syncToAsync)).collect(Collectors.toList());
        return Api.prefixRoutes(entityRoutes, Api.Version.V0);
    }

    private static String getId(RequestContext rc) {
        return (String)rc.pathArgs().get("id");
    }

    private static <T> T readPayloadIfExists(Request request, Class<T> optionsClass) throws IOException {
        Optional payload = request.payload();
        if (payload.isPresent() && ((ByteString)payload.get()).size() != 0) {
            return (T)Json.deserialize((byte[])((ByteString)payload.get()).toByteArray(), optionsClass);
        }
        return null;
    }

    private <T extends Options, S extends Output> Response<S> runCommand(Command<T, S> command) {
        try {
            return Response.forPayload((Object)this.rktLauncherFactory.apply(this.rktLauncherConfig).run(command));
        }
        catch (RktLauncherException e) {
            LOG.error("unable to execute command [{}]]", command, (Object)e);
            throw new RktLauncherServiceException(e);
        }
        catch (RktException e) {
            LOG.debug("non zero exit code [{}] received from rkt when executing command [{}]]", new Object[]{e.getExitCode(), command, e});
            return Response.forStatus((StatusType)Status.UNPROCESSABLE_ENTITY.withReasonPhrase(e.toString()));
        }
    }

    private Response<CatManifestOutput> catManifest(String id) {
        CatManifest catManifest = CatManifest.builder().args((List)ImmutableList.of((Object)id)).build();
        return this.runCommand((Command)catManifest);
    }

    private Response<GcOutput> gc(Request request) {
        GcOptions options;
        try {
            options = RktImageCommandResource.readPayloadIfExists(request, GcOptions.class);
        }
        catch (IOException e) {
            return Response.forStatus((StatusType)Status.BAD_REQUEST.withReasonPhrase(e.getMessage()));
        }
        Gc gc = Gc.builder().options(options).build();
        return this.runCommand((Command)gc);
    }

    private Response<ListOutput> list() {
        io.honnix.rkt.launcher.command.image.List list = io.honnix.rkt.launcher.command.image.List.builder().options(ListOptions.builder().build()).build();
        return this.runCommand((Command)list);
    }

    private Response<RmOutput> rm(Request request) {
        List ids = (List)request.parameters().get("id");
        if (ids == null) {
            return Response.forStatus((StatusType)Status.BAD_REQUEST.withReasonPhrase("Missing 'id' query parameter"));
        }
        Rm rm = Rm.builder().args(ids).build();
        return this.runCommand((Command)rm);
    }

    private Response<RmOutput> rm(String id) {
        Rm rm = Rm.builder().args((List)ImmutableList.of((Object)id)).build();
        return this.runCommand((Command)rm);
    }
}

