/*
 * Decompiled with CFR 0.152.
 */
package io.honnix.rkt.launcher.service.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.spotify.apollo.Request;
import com.spotify.apollo.RequestContext;
import com.spotify.apollo.Response;
import com.spotify.apollo.Status;
import com.spotify.apollo.StatusType;
import com.spotify.apollo.entity.EntityCodec;
import com.spotify.apollo.entity.EntityMiddleware;
import com.spotify.apollo.entity.JacksonEntityCodec;
import com.spotify.apollo.route.AsyncHandler;
import com.spotify.apollo.route.Middleware;
import com.spotify.apollo.route.Route;
import io.honnix.rkt.launcher.RktLauncher;
import io.honnix.rkt.launcher.RktLauncherConfig;
import io.honnix.rkt.launcher.command.CatManifest;
import io.honnix.rkt.launcher.command.Command;
import io.honnix.rkt.launcher.command.Config;
import io.honnix.rkt.launcher.command.Fetch;
import io.honnix.rkt.launcher.command.Gc;
import io.honnix.rkt.launcher.command.Prepare;
import io.honnix.rkt.launcher.command.Rm;
import io.honnix.rkt.launcher.command.Run;
import io.honnix.rkt.launcher.command.RunPrepared;
import io.honnix.rkt.launcher.command.Stop;
import io.honnix.rkt.launcher.command.Version;
import io.honnix.rkt.launcher.exception.RktException;
import io.honnix.rkt.launcher.exception.RktLauncherException;
import io.honnix.rkt.launcher.exception.RktUnexpectedOutputException;
import io.honnix.rkt.launcher.options.FetchOptions;
import io.honnix.rkt.launcher.options.GcOptions;
import io.honnix.rkt.launcher.options.ListOptions;
import io.honnix.rkt.launcher.options.Options;
import io.honnix.rkt.launcher.options.PrepareOptions;
import io.honnix.rkt.launcher.options.RunOptions;
import io.honnix.rkt.launcher.options.RunPreparedOptions;
import io.honnix.rkt.launcher.options.StatusOptions;
import io.honnix.rkt.launcher.options.StopOptions;
import io.honnix.rkt.launcher.output.CatManifestOutput;
import io.honnix.rkt.launcher.output.ConfigOutput;
import io.honnix.rkt.launcher.output.FetchOutput;
import io.honnix.rkt.launcher.output.GcOutput;
import io.honnix.rkt.launcher.output.ListOutput;
import io.honnix.rkt.launcher.output.Output;
import io.honnix.rkt.launcher.output.PrepareOutput;
import io.honnix.rkt.launcher.output.RmOutput;
import io.honnix.rkt.launcher.output.RunOutput;
import io.honnix.rkt.launcher.output.StatusOutput;
import io.honnix.rkt.launcher.output.StopOutput;
import io.honnix.rkt.launcher.output.VersionOutput;
import io.honnix.rkt.launcher.service.api.Api;
import io.honnix.rkt.launcher.service.exception.RktLauncherServiceException;
import io.honnix.rkt.launcher.util.Json;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import okio.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RktCommandResource {
    private static final Logger LOG = LoggerFactory.getLogger(RktCommandResource.class);
    private static final Function<RktLauncherConfig, RktLauncher> DEFAULT_RKT_LAUNCHER_FACTORY = RktLauncher::new;
    private static final String DEFAULT_HTTP_METHOD = "POST";
    private final RktLauncherConfig rktLauncherConfig;
    private Function<RktLauncherConfig, RktLauncher> rktLauncherFactory;

    RktCommandResource(RktLauncherConfig rktLauncherConfig) {
        this(rktLauncherConfig, DEFAULT_RKT_LAUNCHER_FACTORY);
    }

    RktCommandResource(RktLauncherConfig rktLauncherConfig, Function<RktLauncherConfig, RktLauncher> rktLauncherFactory) {
        this.rktLauncherConfig = Objects.requireNonNull(rktLauncherConfig);
        this.rktLauncherFactory = Objects.requireNonNull(rktLauncherFactory);
    }

    Stream<? extends Route<? extends AsyncHandler<? extends Response<ByteString>>>> routes() {
        String base = "/rkt";
        EntityMiddleware em = EntityMiddleware.forCodec((EntityCodec)JacksonEntityCodec.forMapper((ObjectMapper)Json.OBJECT_MAPPER));
        List<Route<AsyncHandler<Response<ByteString>>>> entityRoutes = Stream.of(Route.with((Middleware)em.serializerResponse(CatManifestOutput.class), (String)DEFAULT_HTTP_METHOD, (String)"/rkt/cat-manifest/<id>", rc -> this.catManifest(RktCommandResource.getId(rc))), Route.with((Middleware)em.serializerResponse(ConfigOutput.class), (String)DEFAULT_HTTP_METHOD, (String)"/rkt/config", rc -> this.config()), Route.with((Middleware)em.serializerResponse(FetchOutput.class), (String)DEFAULT_HTTP_METHOD, (String)"/rkt/fetch", rc -> this.fetch(rc.request())), Route.with((Middleware)em.serializerResponse(GcOutput.class), (String)DEFAULT_HTTP_METHOD, (String)"/rkt/gc", rc -> this.gc(rc.request())), Route.with((Middleware)em.serializerResponse(ListOutput.class), (String)DEFAULT_HTTP_METHOD, (String)"/rkt/list", rc -> this.list()), Route.with((Middleware)em.response(PrepareOptions.class, PrepareOutput.class), (String)DEFAULT_HTTP_METHOD, (String)"/rkt/prepare", rc -> this::prepare), Route.with((Middleware)em.serializerResponse(RmOutput.class), (String)DEFAULT_HTTP_METHOD, (String)"/rkt/rm", rc -> this.rm(rc.request())), Route.with((Middleware)em.serializerResponse(RmOutput.class), (String)DEFAULT_HTTP_METHOD, (String)"/rkt/rm/<id>", rc -> this.rm(RktCommandResource.getId(rc))), Route.with((Middleware)em.response(RunOptions.class, RunOutput.class), (String)DEFAULT_HTTP_METHOD, (String)"/rkt/run", rc -> payload -> this.run(rc.request(), (RunOptions)payload)), Route.with((Middleware)em.serializerResponse(RunOutput.class), (String)DEFAULT_HTTP_METHOD, (String)"/rkt/run-prepared/<id>", rc -> this.runPrepared(RktCommandResource.getId(rc), rc.request())), Route.with((Middleware)em.serializerResponse(StatusOutput.class), (String)DEFAULT_HTTP_METHOD, (String)"/rkt/status/<id>", rc -> this.status(RktCommandResource.getId(rc), rc.request())), Route.with((Middleware)em.serializerResponse(StopOutput.class), (String)DEFAULT_HTTP_METHOD, (String)"/rkt/stop", rc -> this.stop(rc.request())), Route.with((Middleware)em.serializerResponse(StopOutput.class), (String)DEFAULT_HTTP_METHOD, (String)"/rkt/stop/<id>", rc -> this.stop(RktCommandResource.getId(rc), rc.request())), Route.with((Middleware)em.serializerResponse(VersionOutput.class), (String)DEFAULT_HTTP_METHOD, (String)"/rkt/version", rc -> this.version())).map(r -> r.withMiddleware(Middleware::syncToAsync)).collect(Collectors.toList());
        return Api.prefixRoutes(entityRoutes, Api.Version.V0);
    }

    private static String getId(RequestContext rc) {
        return (String)rc.pathArgs().get("id");
    }

    private static <T> T readPayloadIfExists(Request request, Class<T> optionsClass) throws IOException {
        Optional payload = request.payload();
        if (payload.isPresent() && ((ByteString)payload.get()).size() != 0) {
            return (T)Json.deserialize((byte[])((ByteString)payload.get()).toByteArray(), optionsClass);
        }
        return null;
    }

    private <T extends Options, S extends Output> Response<S> runCommand(Command<T, S> command) {
        try {
            return Response.forPayload((Object)this.rktLauncherFactory.apply(this.rktLauncherConfig).run(command));
        }
        catch (RktLauncherException e) {
            LOG.error("unable to execute command [{}]]", command, (Object)e);
            throw new RktLauncherServiceException(e);
        }
        catch (RktException e) {
            LOG.debug("non zero exit code [{}] received from rkt when executing command [{}]]", new Object[]{e.getExitCode(), command, e});
            return Response.forStatus((StatusType)Status.UNPROCESSABLE_ENTITY.withReasonPhrase(e.toString()));
        }
        catch (RktUnexpectedOutputException e) {
            LOG.error("unexpected output received from rkt when executing command [{}]", command, (Object)e);
            throw e;
        }
    }

    private Response<CatManifestOutput> catManifest(String id) {
        CatManifest catManifest = CatManifest.builder().args((List)ImmutableList.of((Object)id)).build();
        return this.runCommand((Command)catManifest);
    }

    private Response<ConfigOutput> config() {
        return this.runCommand((Command)Config.COMMAND);
    }

    private Response<FetchOutput> fetch(Request request) {
        FetchOptions options;
        List images = (List)request.parameters().get("image");
        if (images == null) {
            return Response.forStatus((StatusType)Status.BAD_REQUEST.withReasonPhrase("Missing 'image' query parameter"));
        }
        try {
            options = RktCommandResource.readPayloadIfExists(request, FetchOptions.class);
        }
        catch (IOException e) {
            return Response.forStatus((StatusType)Status.BAD_REQUEST.withReasonPhrase(e.getMessage()));
        }
        Fetch fetch = Fetch.builder().options(options).args(images).build();
        return this.runCommand((Command)fetch);
    }

    private Response<GcOutput> gc(Request request) {
        GcOptions options;
        try {
            options = RktCommandResource.readPayloadIfExists(request, GcOptions.class);
        }
        catch (IOException e) {
            return Response.forStatus((StatusType)Status.BAD_REQUEST.withReasonPhrase(e.getMessage()));
        }
        Gc gc = Gc.builder().options(options).build();
        return this.runCommand((Command)gc);
    }

    private Response<ListOutput> list() {
        io.honnix.rkt.launcher.command.List list = io.honnix.rkt.launcher.command.List.builder().options(ListOptions.builder().build()).build();
        return this.runCommand((Command)list);
    }

    private Response<PrepareOutput> prepare(PrepareOptions options) {
        Prepare prepare = Prepare.builder().options(options).build();
        return this.runCommand((Command)prepare);
    }

    private Response<RmOutput> rm(Request request) {
        List ids = (List)request.parameters().get("id");
        if (ids == null) {
            return Response.forStatus((StatusType)Status.BAD_REQUEST.withReasonPhrase("Missing 'id' query parameter"));
        }
        Rm rm = Rm.builder().args(ids).build();
        return this.runCommand((Command)rm);
    }

    private Response<RmOutput> rm(String id) {
        Rm rm = Rm.builder().args((List)ImmutableList.of((Object)id)).build();
        return this.runCommand((Command)rm);
    }

    private Response<RunOutput> run(Request request, RunOptions options) {
        boolean daemonize = request.parameter("daemonize").orElse("true").equals("true");
        if (options.uuidFileSave().isPresent()) {
            return Response.forStatus((StatusType)Status.BAD_REQUEST.withReasonPhrase("UUID file not supported"));
        }
        Run run = Run.builder().daemonize(daemonize).options(options).build();
        return this.runCommand((Command)run);
    }

    private Response<RunOutput> runPrepared(String id, Request request) {
        RunPreparedOptions options;
        try {
            options = RktCommandResource.readPayloadIfExists(request, RunPreparedOptions.class);
        }
        catch (IOException e) {
            return Response.forStatus((StatusType)Status.BAD_REQUEST.withReasonPhrase(e.getMessage()));
        }
        boolean daemonize = request.parameter("daemonize").orElse("true").equals("true");
        RunPrepared runPrepared = RunPrepared.builder().daemonize(daemonize).options(options).addArg(id).build();
        return this.runCommand((Command)runPrepared);
    }

    private Response<StatusOutput> status(String id, Request request) {
        StatusOptions userOptions;
        try {
            userOptions = RktCommandResource.readPayloadIfExists(request, StatusOptions.class);
        }
        catch (IOException e) {
            return Response.forStatus((StatusType)Status.BAD_REQUEST.withReasonPhrase(e.getMessage()));
        }
        StatusOptions options = userOptions == null ? StatusOptions.builder().build() : userOptions;
        io.honnix.rkt.launcher.command.Status status = io.honnix.rkt.launcher.command.Status.builder().options(options).addArg(id).build();
        return this.runCommand((Command)status);
    }

    private Response<StopOutput> stop(List<String> ids, Request request) {
        StopOptions options;
        try {
            options = RktCommandResource.readPayloadIfExists(request, StopOptions.class);
        }
        catch (IOException e) {
            return Response.forStatus((StatusType)Status.BAD_REQUEST.withReasonPhrase(e.getMessage()));
        }
        if (options != null && options.uuidFile().isPresent()) {
            return Response.forStatus((StatusType)Status.BAD_REQUEST.withReasonPhrase("UUID file not supported"));
        }
        Stop stop = Stop.builder().options(options).args(ids).build();
        return this.runCommand((Command)stop);
    }

    private Response<StopOutput> stop(Request request) {
        List ids = (List)request.parameters().get("id");
        if (ids == null) {
            return Response.forStatus((StatusType)Status.BAD_REQUEST.withReasonPhrase("Missing 'id' query parameter"));
        }
        return this.stop(ids, request);
    }

    private Response<StopOutput> stop(String id, Request request) {
        return this.stop((List<String>)ImmutableList.of((Object)id), request);
    }

    private Response<VersionOutput> version() {
        return this.runCommand((Command)Version.COMMAND);
    }
}

