/*
 * Decompiled with CFR 0.152.
 */
package io.higgs.http.server.transformers;

import io.higgs.core.ConfigUtil;
import io.higgs.core.reflect.ReflectionUtil;
import io.higgs.http.server.HttpRequest;
import io.higgs.http.server.HttpResponse;
import io.higgs.http.server.HttpStatus;
import io.higgs.http.server.config.TemplateConfig;
import io.higgs.http.server.protocol.HttpMethod;
import io.higgs.http.server.resource.MediaType;
import io.higgs.http.server.transformers.BaseTransformer;
import io.higgs.http.server.transformers.thymeleaf.Thymeleaf;
import io.higgs.http.server.transformers.thymeleaf.WebContext;
import io.netty.channel.ChannelHandlerContext;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IContext;

public class ThymeleafTransformer
extends BaseTransformer {
    protected TemplateConfig config;
    protected Thymeleaf tl;
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public ThymeleafTransformer() {
        this.config = (TemplateConfig)ConfigUtil.loadYaml((String)"thymeleaf_config.yml", TemplateConfig.class);
        this.tl = new Thymeleaf(this.config);
        this.setPriority(this.config.priority);
        this.addSupportedTypes(new MediaType[]{MediaType.WILDCARD_TYPE, MediaType.TEXT_HTML_TYPE, MediaType.APPLICATION_FORM_URLENCODED_TYPE, MediaType.APPLICATION_XHTML_XML_TYPE});
    }

    public boolean canTransform(Object response, HttpRequest request, MediaType mediaType, HttpMethod method, ChannelHandlerContext ctx) {
        return method == null ? super.canTransform(response, request, mediaType, method, ctx) : method.hasTemplate() && super.canTransform(response, request, mediaType, method, ctx);
    }

    public void transform(Object response, HttpRequest request, HttpResponse res, MediaType mediaType, HttpMethod method, ChannelHandlerContext ctx) {
        WebContext webContext = new WebContext();
        String[] fragements = method.getFragments();
        String template = method.getTemplate();
        if (fragements.length > 0) {
            template = this.tl.getFullTemplate(template, fragements);
        }
        byte[] data = null;
        try {
            if (request != null) {
                if (this.config.determine_language_from_accept_header) {
                    try {
                        webContext.setLocale(Locale.forLanguageTag(request.headers().get("Accept-Language")));
                    }
                    catch (Throwable t) {
                        this.log.warn("Unable to set locale from accept header");
                    }
                }
                this.populateContext(webContext, response, request, method);
            }
            if (this.isError(response)) {
                template = this.determineErrorTemplate(res, response);
            }
            this.populateContext(webContext, response, request, method);
            String content = this.tl.getTemplateEngine().process(template, (IContext)webContext);
            data = content.getBytes(Charset.forName(this.config.character_encoding));
        }
        catch (Throwable e) {
            this.log.warn("Unable to transform response to HTML using Thymeleaf transformer", e);
            res.setStatus(HttpStatus.INTERNAL_SERVER_ERROR);
        }
        this.setResponseContent(res, data);
    }

    public ThymeleafTransformer instance() {
        return new ThymeleafTransformer();
    }

    private void populateContext(WebContext ctx, Object response, HttpRequest request, HttpMethod method) {
        ctx.setVariable("_query", request.getQueryParams());
        ctx.setVariable("_form", request.getFormParam());
        ctx.setVariable("_files", request.getFormFiles());
        ctx.setVariable("_subject", request.getSubject());
        ctx.setVariable("_session", request.getSubject().getSession());
        ctx.setVariable("_cookies", request.getCookies());
        ctx.setVariable("_request", request);
        ctx.setVariable("_response", response);
        if (method != null) {
            ctx.setVariable("_validation", method.getValidationResult());
        }
        if (response instanceof Map || response != null && !ReflectionUtil.isNumeric(response.getClass()) && !(response instanceof Collection)) {
            if (response instanceof Map && this.config.convert_map_responses_to_key_value_pairs) {
                ctx.setVariables((Map)response);
            } else if (this.config.convert_pojo_responses_to_key_value_pairs) {
                Set fields = ReflectionUtil.getAllFields(new HashSet(), response.getClass(), (int)10);
                for (Field field : fields) {
                    try {
                        field.setAccessible(true);
                        ctx.setVariable(field.getName(), field.get(response));
                    }
                    catch (IllegalAccessException e) {
                        this.log.warn(String.format("Unable to set template variable %s", field.getName()), (Throwable)e);
                    }
                }
            }
        }
    }

    protected String determineErrorTemplate(HttpResponse res, Object response) {
        Throwable err = response instanceof Throwable ? (Throwable)response : null;
        this.determineErrorStatus(res, err);
        return "error/default";
    }

    public TemplateConfig getConfig() {
        return this.config;
    }

    public TemplateEngine getTemplateEngine() {
        return this.tl.getTemplateEngine();
    }
}

