/*
 * Decompiled with CFR 0.152.
 */
package io.higgs.http.server.transformers.thymeleaf;

import io.higgs.core.HiggsServer;
import io.higgs.http.server.config.TemplateConfig;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.Set;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.FileTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresolver.UrlTemplateResolver;

public class Thymeleaf {
    private final TemplateConfig config;
    private TemplateEngine templateEngine = new TemplateEngine();
    private HashSet<ITemplateResolver> resolvers = new HashSet();
    private ClassLoaderTemplateResolver clResolver = new ClassLoaderTemplateResolver();
    private FileTemplateResolver fileResolver = new FileTemplateResolver();
    private UrlTemplateResolver urlResolver = new UrlTemplateResolver();
    private boolean ignoreConfigPrefixAndSuffix;

    public Thymeleaf(TemplateConfig config) {
        this(config, false);
    }

    public Thymeleaf(TemplateConfig config, boolean ignoreConfigPrefixAndSuffix) {
        this.config = config;
        this.ignoreConfigPrefixAndSuffix = ignoreConfigPrefixAndSuffix;
        this.templateEngine.setTemplateResolvers(this.getTemplateResolvers());
        if (config.auto_initialize_thymeleaf) {
            this.templateEngine.initialize();
        }
    }

    public Set<? extends ITemplateResolver> getTemplateResolvers() {
        if (!this.ignoreConfigPrefixAndSuffix) {
            this.fileResolver.setSuffix(this.config.suffix);
            this.fileResolver.setPrefix(this.config.prefix);
            this.clResolver.setSuffix(this.config.suffix);
            this.clResolver.setPrefix(this.config.prefix);
            this.urlResolver.setSuffix(this.config.suffix);
            this.urlResolver.setPrefix(this.config.prefix);
        }
        this.fileResolver.setTemplateMode(this.config.template_mode);
        this.urlResolver.setTemplateMode(this.config.template_mode);
        this.clResolver.setTemplateMode(this.config.template_mode);
        this.clResolver.setCacheable(this.config.cacheable);
        this.clResolver.setCacheTTLMs(Long.valueOf(this.config.cache_age_ms));
        this.clResolver.setCharacterEncoding(this.config.character_encoding);
        this.clResolver.setOrder(this.config.classLoader_resolver_order);
        this.fileResolver.setCacheable(this.config.cacheable);
        this.fileResolver.setCacheTTLMs(Long.valueOf(this.config.cache_age_ms));
        this.fileResolver.setCharacterEncoding(this.config.character_encoding);
        this.fileResolver.setOrder(this.config.fileResolver_order);
        this.urlResolver.setCacheable(this.config.cacheable);
        this.urlResolver.setCacheTTLMs(Long.valueOf(this.config.cache_age_ms));
        this.urlResolver.setCharacterEncoding(this.config.character_encoding);
        this.urlResolver.setOrder(this.config.url_resolver_order);
        this.resolvers.add((ITemplateResolver)this.clResolver);
        this.resolvers.add((ITemplateResolver)this.fileResolver);
        this.resolvers.add((ITemplateResolver)this.urlResolver);
        return this.resolvers;
    }

    public TemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    public ClassLoaderTemplateResolver getClResolver() {
        return this.clResolver;
    }

    public FileTemplateResolver getFileResolver() {
        return this.fileResolver;
    }

    public UrlTemplateResolver getUrlResolver() {
        return this.urlResolver;
    }

    public String getFullTemplate(String suggestedName, String[] fragements) {
        String fullPath;
        File file;
        String name = this.config.fragments_dir;
        if (suggestedName == null || suggestedName.isEmpty()) {
            for (String a : fragements) {
                name = name + "_" + a;
            }
        } else {
            name = name + suggestedName;
        }
        if (!(file = HiggsServer.BASE_PATH.resolve(fullPath = this.config.prefix + name + this.config.suffix).toFile()).exists() || this.config.merge_fragments_on_each_request) {
            try {
                if (file.exists() && !file.delete()) {
                    throw new IllegalStateException(String.format("Unable to delete template file '%s'", file.getAbsolutePath()));
                }
                File parent = file.getParentFile();
                if (!parent.exists() && !parent.mkdirs()) {
                    throw new IllegalStateException(String.format("Unable to create directory structure for fragments '%s'", file.getAbsolutePath()));
                }
                if (!file.createNewFile()) {
                    throw new IllegalStateException(String.format("Unable to create template file from fragments '%s'", file.getAbsolutePath()));
                }
                BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
                for (String frag : fragements) {
                    String line;
                    String fragmentPath = this.config.prefix + frag + this.config.suffix;
                    BufferedReader stream = new BufferedReader(new FileReader(HiggsServer.BASE_PATH.resolve(fragmentPath).toFile()));
                    while ((line = stream.readLine()) != null) {
                        out.append(line);
                    }
                    out.flush();
                    stream.close();
                }
                out.close();
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Couldn't build template file from fragments - %s", file.getAbsolutePath()), e);
            }
        }
        return name;
    }
}

