/*
 * Decompiled with CFR 0.152.
 */
package io.higgs.http.server.transformers.handlebars;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.HumanizeHelper;
import com.github.jknack.handlebars.Jackson2Helper;
import com.github.jknack.handlebars.MarkdownHelper;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.ValueResolver;
import com.github.jknack.handlebars.cache.HighConcurrencyTemplateCache;
import com.github.jknack.handlebars.cache.TemplateCache;
import com.github.jknack.handlebars.context.FieldValueResolver;
import com.github.jknack.handlebars.context.JavaBeanValueResolver;
import com.github.jknack.handlebars.context.MapValueResolver;
import com.github.jknack.handlebars.context.MethodValueResolver;
import com.github.jknack.handlebars.io.TemplateLoader;
import io.higgs.core.ConfigUtil;
import io.higgs.core.reflect.dependency.DependencyProvider;
import io.higgs.http.server.HttpRequest;
import io.higgs.http.server.HttpResponse;
import io.higgs.http.server.config.HandlebarsConfig;
import io.higgs.http.server.protocol.HttpMethod;
import io.higgs.http.server.resource.MediaType;
import io.higgs.http.server.transformers.BaseTransformer;
import io.higgs.http.server.transformers.ResponseTransformer;
import io.higgs.http.server.transformers.handlebars.HandlebarHelper;
import io.higgs.http.server.transformers.handlebars.HiggsTemplateLoader;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import javax.ws.rs.WebApplicationException;

public class HandlebarsTransformer
extends BaseTransformer {
    public static final String HANDLE_BARS = "{{handlebars}}";
    protected HandlebarsConfig config = (HandlebarsConfig)ConfigUtil.loadYaml((String)"handlebars_config.yml", HandlebarsConfig.class);
    protected Handlebars handlebars;
    protected HiggsTemplateLoader loader;

    public HandlebarsTransformer() {
        this.setPriority(this.config.priority);
        this.addSupportedTypes(new MediaType[]{MediaType.WILDCARD_TYPE, MediaType.TEXT_HTML_TYPE, MediaType.APPLICATION_FORM_URLENCODED_TYPE, MediaType.APPLICATION_XHTML_XML_TYPE});
        if (DependencyProvider.global().get(HANDLE_BARS) == null) {
            DependencyProvider.global().put(HANDLE_BARS, new HashMap());
        }
        this.loader = new HiggsTemplateLoader(this.config);
        this.handlebars = new Handlebars((TemplateLoader)this.loader);
        this.loadHelpers();
        if (this.config.enable_humanize_helper) {
            HumanizeHelper.register((Handlebars)this.handlebars);
        }
        if (this.config.enable_jackson_helper) {
            this.handlebars.registerHelper("json", Jackson2Helper.INSTANCE);
        }
        if (this.config.enable_markdown_helper) {
            this.handlebars.registerHelper("md", MarkdownHelper.INSTANCE);
        }
        if (this.config.cache_templates) {
            this.handlebars.with((TemplateCache)new HighConcurrencyTemplateCache());
        }
    }

    protected void loadHelpers() {
        Iterator<HandlebarHelper> providers = ServiceLoader.load(HandlebarHelper.class).iterator();
        while (providers.hasNext()) {
            try {
                HandlebarHelper helper = providers.next();
                this.handlebars.registerHelper(helper.getName(), (Helper)helper);
            }
            catch (ServiceConfigurationError sce) {
                this.log.warn("Unable to register Handlebar helper factory", (Throwable)sce);
            }
        }
    }

    public boolean canTransform(Object response, HttpRequest request, MediaType mediaType, HttpMethod method, ChannelHandlerContext ctx) {
        return method == null ? super.canTransform(response, request, mediaType, method, ctx) : method.hasTemplate() && super.canTransform(response, request, mediaType, method, ctx);
    }

    public void transform(Object response, HttpRequest request, HttpResponse res, MediaType mediaType, HttpMethod method, ChannelHandlerContext ctx) {
        String tpl = "error/default";
        if (this.isError(response)) {
            this.determineErrorStatus(res, (Throwable)response);
            if (!(response instanceof WebApplicationException)) {
                response = new WebApplicationException((Throwable)response, 500);
            }
        } else {
            if (method == null) {
                throw new WebApplicationException(HttpResponseStatus.EXPECTATION_FAILED.code());
            }
            if (!method.hasTemplate()) {
                throw new WebApplicationException("HandlebarsTransformer only supports a template value, to use fragments use mustacheTransformer's inheritance", HttpResponseStatus.FAILED_DEPENDENCY.code());
            }
            tpl = method.getTemplate();
        }
        ByteBuf buf = ctx.alloc().heapBuffer();
        ByteBufOutputStream in = new ByteBufOutputStream(buf);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)in);
        try {
            Template template = this.handlebars.compile(tpl);
            template.apply(this.scopes(response, request, method), (Writer)writer);
            ((Writer)writer).flush();
            byte[] data = new byte[buf.readableBytes()];
            buf.readBytes(data);
            this.setResponseContent(res, data);
        }
        catch (IOException e) {
            this.log.warn("Failed to write the results of a mustacheTransformer execution", (Throwable)e);
            res.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
            this.setResponseContent(res, new byte[0]);
        }
    }

    private Context scopes(Object response, HttpRequest request, HttpMethod method) {
        Context ctx = Context.newBuilder((Object)response).resolver(new ValueResolver[]{JavaBeanValueResolver.INSTANCE, MapValueResolver.INSTANCE, FieldValueResolver.INSTANCE, MethodValueResolver.INSTANCE}).build();
        Map anything = (Map)DependencyProvider.global().get(HANDLE_BARS);
        ctx.data("_query", (Object)request.getQueryParams()).data("_form", (Object)request.getFormParam()).data("_files", (Object)request.getFormFiles()).data("_subject", (Object)request.getSubject()).data("_session", (Object)request.getSubject().getSession()).data("_cookies", (Object)request.getCookies()).data("_request", (Object)request).data("_response", response).data(anything);
        if (method != null) {
            ctx.data("_validation", (Object)method.getValidationResult());
        }
        return ctx;
    }

    public ResponseTransformer instance() {
        return new HandlebarsTransformer();
    }
}

