/*
 * Decompiled with CFR 0.152.
 */
package io.higgs.http.server.transformers.handlebars;

import com.github.jknack.handlebars.io.TemplateSource;
import com.google.common.base.Charsets;
import io.higgs.core.ResolvedFile;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class HiggsTemplateSource
implements TemplateSource {
    private final ResolvedFile file;
    private String data = "";

    public HiggsTemplateSource(ResolvedFile file) {
        this.file = file;
    }

    public String content() throws IOException {
        if (this.data == null || this.data.isEmpty()) {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.file.getStream(), Charsets.UTF_8));
            StringBuilder builder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                builder.append(line);
            }
            this.data = builder.toString();
        }
        return this.data;
    }

    public String filename() {
        return this.file.getName();
    }

    public long lastModified() {
        return this.file.lastModified();
    }

    public int hashCode() {
        int result = this.file != null ? this.file.hashCode() : 0;
        result = 31 * result + (this.data != null ? this.data.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HiggsTemplateSource that = (HiggsTemplateSource)o;
        if (this.data != null ? !this.data.equals(that.data) : that.data != null) {
            return false;
        }
        return !(this.file != null ? !this.file.equals((Object)that.file) : that.file != null);
    }
}

