/*
 * Decompiled with CFR 0.152.
 */
package io.higgs.http.server.transformers.handlebars;

import com.github.jknack.handlebars.io.TemplateLoader;
import com.github.jknack.handlebars.io.TemplateSource;
import io.higgs.core.FileUtil;
import io.higgs.core.ResolvedFile;
import io.higgs.http.server.config.HandlebarsConfig;
import io.higgs.http.server.transformers.handlebars.HiggsTemplateSource;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;

public class HiggsTemplateLoader
implements TemplateLoader {
    protected HandlebarsConfig config;
    protected Path base;

    public HiggsTemplateLoader(HandlebarsConfig config) {
        this.config = config;
        this.base = Paths.get(config.directory, new String[0]);
    }

    public TemplateSource sourceAt(String template) throws IOException {
        ResolvedFile file;
        String ext = this.config.template;
        if (!template.endsWith(ext) || !template.contains(".")) {
            template = template + ext;
        }
        if (!(file = FileUtil.resolve((Path)this.base, (Path)Paths.get(template, new String[0]))).exists()) {
            throw new IOException(template + " not found");
        }
        return new HiggsTemplateSource(file);
    }

    public String resolve(String s) {
        return s;
    }

    public String getPrefix() {
        return "";
    }

    public String getSuffix() {
        return this.config.template;
    }
}

